## 组件介绍

TUIVoiceRoom 组件是一个开源的场景化解决方案，帮助您快速在您的小程序中集成**语音聊天室**功能，内部集成语音聊天与文字聊天功能，非常适合用于多人语音会议，娱乐聊天室，语音交友平台等场景中。

#### 创建房间

由于用户不需要安装 app 就可以使用该功能，因此 TUIVoiceRoom 非常适合用于快速发起多人语音聊天室的场景。

#### 房间管理

房间内部继承**低延迟、高质量**语音通话功能，创建者可对房间麦位进行锁定解锁并对用户进行禁言、禁画以及踢出操作。

#### 其它平台

除了小程序版的 TUIVoiceRoom，我们同时也推出了 Android、iOS 等平台的源代码，用户可直接使用并对源码进行修改。

## 效果展示
您可以单击 [Demo 体验](https://cloud.tencent.com/document/product/647/17021) 扫描二维码单击**语音聊天室**进行体验。语音聊天室包括麦位管理、低延时语音互动、文字聊天等 TRTC 在语音聊天场景下的相关能力。
<table>
     <tr>
         <th>房主麦位操作</th>  
         <th>听众麦位操作</th>  
     </tr>
<tr>
<td><img src="./voiceRoom_pick_seat.gif"/></td>
<td><img src="./voiceRoom_take_seat.gif"/></td>
</tr>
</table>

如需快速接入语音聊天室功能，您可以直接基于我们提供的 Demo 进行修改适配。
## 环境要求
- 微信 App iOS 最低版本要求：7.0.9。
- 微信 App Android 最低版本要求：7.0.8。
- 小程序基础库最低版本要求：2.10.0。
- 由于微信开发者工具不支持原生组件（即 &lt;live-pusher&gt; 和 &lt;live-player&gt; 标签），需要在真机上进行运行体验。
- 由于小程序测试号不具备 &lt;live-pusher&gt; 和 &lt;live-player&gt; 的使用权限，需要申请常规小程序账号进行开发。
- 不支持 uniapp 开发环境，请使用原生小程序开发环境。

## 前提条件
1. 您已 [注册腾讯云](https://cloud.tencent.com/document/product/378/17985) 账号，并完成 [实名认证](https://cloud.tencent.com/document/product/378/3629)。
2. **开通小程序类目与推拉流标签权限（如不开通则无法正常使用）**。
   出于政策和合规的考虑，微信暂未放开所有小程序对实时音视频功能（即 &lt;live-pusher&gt; 和 &lt;live-player&gt; 标签）的支持：
- 小程序推拉流标签不支持个人小程序，只支持企业类小程序。
- 小程序推拉流标签使用权限暂时只开放给有限 [类目](https://developers.weixin.qq.com/miniprogram/dev/component/live-pusher.html)。
- 符合类目要求的小程序，需要在 **[微信公众平台](https://mp.weixin.qq.com)** > **开发** > **开发管理** > **接口设置** 中自助开通该组件权限，如下图所示：
  ![](https://main.qcloudimg.com/raw/dc6d3c9102bd81443cb27b9810c8e981.png)

## 跑通 Demo

[](id:ui.step1)
### 步骤一：开通小程序权限

由于 TUIVoiceRoom 所使用的小程序标签有更苛刻的权限要求，因此集成 TUIVoiceRoom 的第一步就是要开通小程序的类目和标签使用权限，**否则无法使用**，这包括如下步骤：

- 小程序推拉流标签不支持个人小程序，只支持企业类小程序。需要在[注册](https://developers.weixin.qq.com/community/business/doc/000200772f81508894e94ec965180d)时填写主体类型为企业，如下图所示：
  ![](https://qcloudimg.tencent-cloud.cn/raw/bd694ee723341b63afbec7ff39111451.png)
- 小程序推拉流标签使用权限暂时只开放给有限 [类目](https://developers.weixin.qq.com/miniprogram/dev/component/live-pusher.html)。
- 符合类目要求的小程序，需要在【[微信公众平台](https://mp.weixin.qq.com)】>【开发】>【开发管理】>【接口设置】中自助开通该组件权限，如下图所示：
  ![](https://main.qcloudimg.com/raw/dc6d3c9102bd81443cb27b9810c8e981.png)

[](id:ui.step2)
### 步骤二：在小程序控制台配置域名

在【[微信公众平台](https://mp.weixin.qq.com)】>【开发】>【开发管理】>【开发设置】>【服务器域名】中设置"request合法域名"和"socket合法域名"，如下图所示：
request合法域名:

```
https://official.opensso.tencent-cloud.com
https://yun.tim.qq.com
https://cloud.tencent.com
https://webim.tim.qq.com
https://query.tencent-cloud.com
https://web.sdk.qcloud.com
```

socket合法域名:

```
wss://wss.im.qcloud.com
wss://wss.tim.qq.com
```

![](https://qcloudimg.tencent-cloud.cn/raw/a79ca9726309bb1fdabb9ef8961ce147.png)

[](id:ui.step3)
### 步骤三：创建新的应用
1. 登录实时音视频控制台，选择**开发辅助** > **[快速跑通Demo](https://console.cloud.tencent.com/trtc/quickstart)**。
2. 输入应用名称，例如 `TestVoiceRoom` ，单击**创建**。

>!本功能同时使用了腾讯云 [实时音视频 TRTC](https://cloud.tencent.com/document/product/647/16788) 和 [即时通信 IM](https://cloud.tencent.com/document/product/269) 两个基础 PaaS 服务，开通实时音视频后会同步开通即时通信 IM 服务。 即时通信 IM 属于增值服务，详细计费规则请参见 [即时通信 IM 价格说明](https://cloud.tencent.com/document/product/269/11673)。


[](id:ui.step4)
### 步骤四：下载 App 源码
单击进入 [TUIVoiceRoom](https://github.com/tencentyun/TUIVoiceRoom/tree/main/MiniProgram)，Clone 或者下载源码。

[](id:ui.step5)
### 步骤五：配置 Demo 工程文件
1. 进入修改配置页，根据您下载的源码包，选择相应的开发环境。
2. 找到并打开 `./debug/GenerateTestUserSig.js` 文件。
3. 设置 `GenerateTestUserSig.js` 文件中的相关参数：
  <ul><li>SDKAPPID：默认为0，请设置为实际的 SDKAppID。</li>
  <li>SECRETKEY：默认为空字符串，请设置为实际的密钥信息。</li></ul> 
  <img src="https://main.qcloudimg.com/raw/575902219de19b4f2d4595673fa755d4.png">
4. 粘贴完成后，单击**已复制粘贴，下一步**即创建成功。
5. 编译完成后，单击**回到控制台概览**即可。

>!
>- 本文提到的生成 UserSig 的方案是在客户端代码中配置 SECRETKEY，该方法中 SECRETKEY 很容易被反编译逆向破解，一旦您的密钥泄露，攻击者就可以盗用您的腾讯云流量，因此**该方法仅适合本地跑通 Demo 和功能调试**。
>- 正确的 UserSig 签发方式是将 UserSig 的计算代码集成到您的服务端，并提供面向 App 的接口，在需要 UserSig 时由您的 App 向业务服务器发起请求获取动态 UserSig。更多详情请参见 [服务端生成 UserSig](https://cloud.tencent.com/document/product/647/17275#Server)。


[](id:ui.step6)

###  步骤六：编译运行
1. 打开微信开发者工具，选择**小程序**，单击新建图标，选择**导入项目**。
2. 填写您微信小程序的 AppID，单击**导入**。
   ![](https://qcloudimg.tencent-cloud.cn/raw/efb1ea09c0b61b2e669104c90ae3a1c7.png)
>!此处应输入您微信小程序的 AppID，而非 SDKAppID。
3. 单击**预览**，生成二维码，通过手机微信扫码二维码即可进入小程序。


[](id:QQ)
## 技术咨询
了解更多详情您可 QQ 咨询：<dx-tag-link link="#QQ" tag="技术交流群">941036374</dx-tag-link>

## 参考文档
- [实时音视频 trtc-wx API 手册](https://cloud.tencent.com/document/product/647/17018)
- [即时通信 IM sdk API 手册](https://web.sdk.qcloud.com/im/doc/zh-cn//SDK.html#setGroupAttributes)
- [小程序 TUIVoiceRoom 源码](https://github.com/tencentyun/TUIVoiceRoom/tree/main/MiniProgram)
- [小程序 TUIRoom 源码](https://github.com/tencentyun/TUIRoom/tree/main/MiniProgram)
- [小程序如何支持 typescript + sass/less](https://developers.weixin.qq.com/miniprogram/dev/devtools/compilets.html)
