/* tslint:disable */

import { Stock } from '../models/stock';

export const stocksInPortfolio: Stock[] = [
    {
        symbol: 'AAN',
        name: "Aaron's, Inc.",
        price: 76.61,
        day_change: -1.18,
        change_pct: -1.52,
        volume: 710442,
        volume_avg: 837114,
        market_cap: 5174814208,
        pe: 25.94,
        intraday: [
            77.77, 77.48, 77.47, 77.22, 77.29, 76.9, 76.69, 76.65, 76.69, 76.82, 76.75, 76.81, 76.87, 76.84, 76.7, 76.65, 76.44, 76.29,
            76.42, 76.32, 76.2, 75.94, 75.87, 75.8, 75.99, 76.09, 75.8, 75.82, 75.91, 75.84, 75.85, 76.01, 75.99, 75.92, 75.99, 76.06,
            76.06, 76.11, 76.17, 76.18, 76.17, 76.13, 76.04, 75.88, 75.72, 75.69, 75.92, 75.99, 76.04, 76.07, 76.03, 75.95, 75.75, 75.58,
            75.8, 75.87, 75.93, 76.08, 75.95, 76.01, 76.05, 76.07, 76.16, 76.21, 76.2, 76.38, 76.41, 76.43, 76.38, 76.51, 76.7, 76.65,
            76.71, 76.68, 76.65, 76.46, 76.53, 76.59
        ]
    },
    {
        symbol: 'AAPL',
        name: 'Apple Inc.',
        price: 246.58,
        day_change: 2.49,
        change_pct: 1.02,
        volume: 15827692,
        volume_avg: 20028962,
        market_cap: 1114344259584,
        pe: 20.94,
        intraday: [
            243.75, 243.54, 243.32, 243.47, 243.74, 243.43, 243.34, 243.39, 243.47, 243.66, 243.68, 244.43, 244.53, 244.25, 244.16, 243.93,
            244.41, 244.69, 244.52, 244.52, 244.62, 244.88, 245.07, 245.7, 245.31, 245.34, 245.48, 245.54, 245.28, 245.43, 245.41, 245.2,
            245.33, 245.31, 245.34, 245.56, 245.59, 245.47, 245.1, 245.18, 245.29, 245.24, 245.35, 245.26, 245.16, 245.38, 245.31, 245.3,
            245.3, 245.25, 245.39, 245.45, 245.38, 245.37, 245.25, 244.81, 245.05, 245.07, 245.1, 245.2, 245.18, 245.13, 245.18, 245.35,
            245.34, 245.31, 245.39, 245.46, 245.57, 245.65, 245.67, 245.76, 245.68, 245.77, 245.79, 245.86, 245.9, 246.24
        ]
    },
    {
        symbol: 'ACN',
        name: 'Accenture plc',
        price: 183.07,
        day_change: -0.77,
        change_pct: -0.42,
        volume: 1369124,
        volume_avg: 1892150,
        market_cap: 116597284864,
        pe: 24.87,
        intraday: [
            184.08, 184.36, 183.49, 183.77, 183.74, 183.57, 183.62, 183.76, 184.13, 183.95, 183.99, 184.16, 184.05, 183.85, 183.81, 183.84,
            184.4, 184.34, 184.4, 184.32, 184.24, 184.45, 184.5, 184.54, 184.52, 184.55, 184.58, 184.71, 184.63, 184.74, 184.58, 184.29,
            184.13, 184.12, 184.1, 184.11, 184.21, 184.21, 184.11, 184.05, 184.06, 184, 183.94, 183.9, 183.89, 183.9, 183.94, 183.83, 183.9,
            183.75, 183.73, 183.78, 183.78, 183.92, 183.9, 183.75, 183.87, 183.87, 183.83, 183.81, 183.7, 183.4, 183.42, 183.53, 183.53,
            183.6, 183.64, 183.5, 183.46, 183.51, 183.54, 183.62, 183.59, 183.66, 183.54, 183.4, 183.24, 183.31
        ]
    },
    {
        symbol: 'ADBE',
        name: 'Adobe Inc.',
        price: 270.98,
        day_change: 2.93,
        change_pct: 1.09,
        volume: 1511852,
        volume_avg: 3342325,
        market_cap: 131175735296,
        pe: 48.22,
        intraday: [
            267.66, 267.8, 268.63, 269.04, 269.44, 269.13, 269.3, 269.95, 270.13, 269.81, 269.9, 270.2, 270.35, 270.2, 270.14, 270.33,
            271.13, 270.73, 270.55, 270.31, 270.46, 271.06, 271.54, 271.31, 270.86, 270.97, 271.18, 271.33, 271.16, 271.29, 271.11, 270.73,
            270.61, 270.82, 271.02, 270.95, 271.18, 271.07, 270.96, 271.03, 271.02, 270.95, 270.91, 270.93, 270.88, 271.06, 271.03, 270.89,
            271.02, 270.95, 271.04, 270.74, 270.86, 270.57, 270.85, 270.68, 270.63, 270.59, 270.59, 270.7, 270.82, 270.35, 270.53, 270.73,
            270.76, 271, 271.06, 270.64, 270.65, 270.79, 270.88, 270.88, 270.9, 271.02, 270.77, 270.72, 270.68, 270.59
        ]
    },
    {
        symbol: 'AGM',
        name: 'Federal Agricultural Mortgage Corporation',
        price: 84.57,
        day_change: 0.17,
        change_pct: 0.2,
        volume: 22444,
        volume_avg: 22114,
        market_cap: 890445952,
        pe: 9.46,
        intraday: [
            84.42, 84.87, 84.87, 84.02, 84.02, 84.18, 84.11, 83.5, 82.7, 82.7, 82.97, 82.97, 82.97, 83.08, 83.08, 83.29, 83.29, 83.01,
            83.01, 83.21, 83.21, 83.18, 83.38, 83.08, 83.08, 83.34, 83.34, 83.39, 83.39, 83.35, 83.35, 83.32, 83.32, 83.28, 83.28, 83.28,
            83.58, 83.58, 83.58, 83.26, 83.26, 83.49, 83.49, 84.52, 84.52, 84.1, 84.1, 84.1, 83.41, 84.77, 83.53, 83.53, 83.92, 83.92,
            83.76, 83.76, 84.44, 84.44, 84.44, 84.33, 84.72, 84.59
        ]
    },
    {
        symbol: 'AMZN',
        name: 'Amazon.com, Inc.',
        price: 1779.99,
        day_change: 17.78,
        change_pct: 1.01,
        volume: 2173743,
        volume_avg: 3771314,
        market_cap: 882513674240,
        pe: 78.87,
        intraday: [
            1762.22, 1762, 1763.11, 1768.61, 1768.02, 1766.44, 1764.64, 1766.46, 1767.14, 1768.17, 1767.75, 1769.02, 1768.68, 1771.99,
            1771.46, 1774.6, 1778.5, 1778.76, 1776.4, 1773.73, 1774.49, 1771.65, 1772.55, 1773.22, 1773.5, 1770.94, 1769.19, 1770.69,
            1771.39, 1772.2, 1770.41, 1771.65, 1769.62, 1769.5, 1769.54, 1768.72, 1768.31, 1767.99, 1767.33, 1766.14, 1765.66, 1765.45,
            1765.79, 1765.99, 1767.82, 1767.14, 1768.4, 1768.29, 1767.83, 1767.51, 1769.12, 1767.93, 1768.07, 1768.5, 1769.81, 1769.46,
            1775.4, 1774.97, 1772.7, 1771, 1768.94, 1769.56, 1774.53, 1775.34, 1778.57, 1779.69, 1780.34, 1779.24, 1778.32, 1780, 1781,
            1779.16, 1778.02, 1777.22, 1777.04, 1778.57, 1780.24, 1780
        ]
    },
    {
        symbol: 'ASML',
        name: 'ASML Holding N.V.',
        price: 263.99,
        day_change: 1.26,
        change_pct: 0.48,
        volume: 549797,
        volume_avg: 1164687,
        market_cap: 110834614272,
        pe: 37.94,
        intraday: [
            262.8, 262.63, 262.18, 261.98, 262.34, 262.23, 262.23, 262.21, 262.78, 262.62, 262.75, 262.74, 262.88, 262.85, 263.11, 263,
            263.38, 263.45, 263.63, 263.23, 263.45, 263.16, 263.29, 263.48, 263.52, 263.89, 264.08, 264.5, 264.54, 264.38, 263.95, 263.82,
            263.78, 263.93, 264.13, 264.16, 263.97, 263.94, 264, 263.84, 263.98, 263.95, 264.11, 264.15, 264.26, 264.06, 264.49, 264.02,
            264.08, 264.6, 264.65, 264.27, 264.36, 263.92, 263.75, 264.29, 264.09, 264.24, 264.33, 263.92, 263.77, 263.74, 264.02, 263.88,
            263.82, 263.79, 263.6, 263.43, 263.58, 263.57, 263.61, 263.55, 263.57, 263.41, 264.06
        ]
    },
    {
        symbol: 'AVGO',
        name: 'Broadcom Inc.',
        price: 289.82,
        day_change: 5.87,
        change_pct: 2.07,
        volume: 1987976,
        volume_avg: 1691400,
        market_cap: 114963193856,
        pe: 40.79,
        intraday: [
            283.88, 284.32, 284.93, 284.65, 285.68, 285.99, 286.07, 285.96, 286.29, 286.21, 286.29, 286.64, 286.62, 286.22, 286.17, 285.92,
            286.8, 286.83, 287.17, 287.14, 287.66, 287.87, 287.92, 288.42, 288.4, 288.42, 288.8, 288.9, 289.24, 289.27, 288.96, 288.16,
            288.27, 288.4, 288.8, 288.8, 289.16, 288.92, 288.97, 289.09, 289.16, 288.75, 288.88, 289.1, 289.4, 290.08, 290.01, 290.26,
            290.67, 290.22, 290.47, 290.91, 290.79, 291.15, 291.27, 290.16, 290.1, 289.79, 290.02, 290.05, 290.03, 289.9, 289.92, 290.29,
            290.22, 290.28, 290.24, 290.46, 290.64, 290.62, 290.67, 290.61, 290.63, 290.19, 290.01, 290.2, 289.89, 289.75
        ]
    },
    {
        symbol: 'BNPQY',
        name: 'BNP Paribas SA',
        price: 26.43,
        day_change: 0.43,
        change_pct: 1.65,
        volume: 103645,
        volume_avg: 193571,
        market_cap: 66021871616,
        pe: null,
        intraday: [
            26, 25.97, 25.97, 25.98, 25.95, 25.95, 25.89, 25.91, 25.89, 25.85, 25.91, 25.93, 25.89, 25.94, 25.94, 25.94, 25.94, 25.91, 25.9,
            25.89, 25.92, 25.97, 25.97, 25.94, 25.94, 25.94, 25.94, 25.99, 26.07, 26.07, 26.01, 26.01, 26.04, 26.03, 26.03, 26.03, 25.99,
            25.99, 26.08, 26.08, 26.06, 26.05, 26.05, 26.05, 25.99, 25.99, 25.99, 26.06, 25.99, 26.02, 26.05, 26.05, 26, 26, 26, 25.98, 26,
            26, 26.03, 26.11, 26.22, 26.26, 26.36, 26.41, 26.41, 26.29, 26.41, 26.4, 26.35, 26.35, 26.42, 26.43, 26.43
        ]
    },
    {
        symbol: 'CACC',
        name: 'Credit Acceptance Corporation',
        price: 439.2,
        day_change: -0.69,
        change_pct: -0.16,
        volume: 57324,
        volume_avg: 84857,
        market_cap: 8255554560,
        pe: 13.4,
        intraday: [
            439.4, 438.08, 438.08, 438.57, 438.57, 439.86, 439.86, 440.89, 440.89, 439.95, 439.95, 440, 440.8, 440.58, 439.52, 439.03,
            438.46, 437.69, 437.29, 438.59, 437.05, 437.25, 437.34, 438.89, 438.89, 438.89, 440, 438.22, 437.41, 438.13, 438.14, 437.57,
            437.14, 436.77, 436.77, 437.89, 437.31, 437.31, 437.09, 437.09, 436.91, 436.91, 437.43, 437.43, 437.22, 437.22, 436.83, 436.47,
            436.47, 436.82, 436.82, 438.84, 438.84, 437.4, 437.4, 438.35, 438.35, 438.2, 439.57, 440.49, 438.99, 438.67, 440.14, 439.22,
            439.77, 439.77, 439.25, 439.43, 438.9, 439.24, 438.69, 438.71
        ]
    }
];

export const uncategorizedStocks: Stock[] = [
    {
        symbol: 'CAI',
        name: 'CAI International, Inc.',
        price: 23.77,
        day_change: -1.23,
        change_pct: -4.92,
        volume: 184691,
        volume_avg: 114114,
        market_cap: 414063904,
        pe: 12.99,
        intraday: [
            25, 25.5, 24.95, 24.99, 25.19, 25, 24.69, 24.55, 24.31, 24.32, 24.22, 24.15, 23.97, 23.77, 24.13, 24, 24, 24.07, 23.91, 24.06,
            23.91, 23.71, 23.59, 23.57, 23.72, 23.56, 23.47, 23.32, 23.68, 23.68, 23.65, 23.65, 23.65, 23.63, 23.67, 23.67, 23.62, 23.77,
            23.67, 23.56, 23.44, 23.69, 23.69, 23.85, 23.84, 23.79, 23.79, 23.58, 23.58, 23.58, 23.78, 23.84, 23.66, 23.67, 24.15, 23.98,
            23.98, 23.81, 23.8, 23.8, 23.77, 23.91, 23.91, 23.83, 23.98, 23.95, 23.88, 23.91, 23.84, 23.78, 23.92, 23.7, 23.93, 23.76, 23.7,
            23.76, 23.76, 23.77
        ]
    },
    {
        symbol: 'CBTX',
        name: 'CBTX, Inc.',
        price: 28.71,
        day_change: 0.04,
        change_pct: 0.14,
        volume: 43506,
        volume_avg: 26514,
        market_cap: 746933696,
        pe: 13.87,
        intraday: [
            28.58, 28.58, 28.55, 28.55, 28.55, 28.43, 28.43, 28.33, 28.33, 28.43, 28.43, 28.43, 28.45, 28.45, 28.46, 28.46, 28.75, 28.64,
            28.7, 28.7, 28.55, 28.55, 28.55, 28.55, 28.55, 28.49, 28.49, 28.46, 28.46, 28.47, 28.43, 28.43, 28.41, 28.39, 28.39, 28.5,
            28.51, 28.48, 28.23, 28.23, 28.41, 28.41, 28.45, 28.45, 28.55, 28.5, 28.55, 28.55, 28.75, 28.75, 28.74, 28.74, 28.9, 28.9,
            28.82, 28.82, 28.79, 28.85, 28.62
        ]
    },
    {
        symbol: 'CMA',
        name: 'Comerica Incorporated',
        price: 66.52,
        day_change: 0.28,
        change_pct: 0.42,
        volume: 1407582,
        volume_avg: 1229371,
        market_cap: 9587926016,
        pe: 8.42,
        intraday: [
            66.25, 66.08, 66.16, 66.01, 65.99, 65.83, 65.75, 65.89, 65.83, 65.75, 65.76, 65.8, 65.67, 65.61, 65.69, 65.9, 66.02, 65.95,
            65.96, 65.91, 65.93, 65.99, 65.9, 65.88, 65.79, 65.9, 65.86, 65.92, 65.91, 65.95, 65.97, 66.1, 66.06, 65.92, 65.96, 65.98,
            66.11, 66.15, 66.2, 66.15, 66.24, 66.31, 66.35, 66.3, 66.25, 66.26, 66.23, 66.18, 66.22, 66.22, 66.22, 66.13, 66.2, 66.25,
            66.49, 66.36, 66.53, 66.59, 66.56, 66.63, 66.63, 66.92, 67.06, 67.06, 67.1, 67.23, 67.23, 66.94, 66.89, 66.81, 66.9, 66.84,
            66.78, 66.71, 66.63, 66.47, 66.63, 66.53
        ]
    },
    {
        symbol: 'CRM',
        name: 'salesforce.com, inc.',
        price: 150.49,
        day_change: 3.21,
        change_pct: 2.18,
        volume: 4814264,
        volume_avg: 5236950,
        market_cap: 131979730944,
        pe: 124.99,
        intraday: [
            147.19, 147.16, 147.29, 147.91, 147.87, 147.83, 147.8, 147.78, 148.08, 148.2, 148.04, 148.39, 148.23, 148.01, 147.88, 148.18,
            148.77, 148.51, 148.4, 148.32, 148.33, 148.69, 148.79, 148.83, 148.79, 148.89, 148.89, 148.89, 148.95, 149.04, 148.96, 148.76,
            148.61, 148.61, 148.69, 148.63, 148.73, 148.79, 148.69, 148.72, 148.71, 148.79, 148.75, 148.79, 148.79, 149.03, 149.08, 149.15,
            149.2, 149.11, 149.34, 149.55, 149.63, 149.58, 149.63, 149.64, 149.78, 149.89, 149.93, 149.95, 149.97, 149.6, 149.74, 149.73,
            149.94, 149.99, 149.96, 149.98, 150.05, 150.1, 150.17, 150.23, 150.24, 150.41, 150.32, 150.4, 150.23, 150.4
        ]
    },
    {
        symbol: 'CSCO',
        name: 'Cisco Systems, Inc.',
        price: 46.9,
        day_change: 0.31,
        change_pct: 0.67,
        volume: 12554651,
        volume_avg: 16144737,
        market_cap: 196328095744,
        pe: 17.97,
        intraday: [
            46.59, 46.67, 46.74, 46.77, 46.79, 46.76, 46.79, 46.78, 46.78, 46.82, 46.77, 46.79, 46.82, 46.79, 46.74, 46.67, 46.76, 46.77,
            46.74, 46.74, 46.74, 46.8, 46.88, 46.96, 46.96, 46.94, 46.95, 46.96, 46.94, 46.95, 46.91, 46.86, 46.88, 46.87, 46.88, 46.86,
            46.9, 46.94, 46.92, 46.93, 46.94, 46.92, 46.92, 46.89, 46.87, 46.91, 46.89, 46.88, 46.88, 46.85, 46.89, 46.9, 46.85, 46.87,
            46.83, 46.86, 46.86, 46.78, 46.8, 46.81, 46.78, 46.72, 46.72, 46.78, 46.8, 46.83, 46.86, 46.87, 46.88, 46.86, 46.88, 46.92,
            46.96, 46.94, 46.94, 46.94, 46.88, 46.9
        ]
    },
    {
        symbol: 'ECPG',
        name: 'Encore Capital Group, Inc.',
        price: 33.79,
        day_change: -0.76,
        change_pct: -2.2,
        volume: 233014,
        volume_avg: 189114,
        market_cap: 1049429568,
        pe: 6.82,
        intraday: [
            34.56, 34.45, 34.45, 34.53, 34.38, 34.26, 34.17, 34.17, 34.13, 34.19, 34.21, 34.27, 34.27, 34.17, 34.17, 34.17, 34.12, 34.17,
            34.18, 34.18, 34.14, 34.1, 34.12, 34.09, 34.09, 34.03, 33.99, 33.97, 33.98, 33.97, 34.02, 33.99, 33.99, 34, 33.96, 34.01, 34.01,
            34.03, 34.05, 34.1, 34.04, 34.06, 34.01, 34.01, 34.01, 33.9, 33.88, 33.88, 33.85, 33.85, 33.86, 33.88, 33.88, 33.89, 33.92,
            33.96, 33.94, 33.94, 33.91, 33.88, 33.89, 33.87, 33.9, 33.9, 33.87, 33.87, 33.89, 33.86, 33.85, 33.87, 33.76, 33.85, 33.79,
            33.81, 33.9, 33.86, 33.8
        ]
    },
    {
        symbol: 'EPRT',
        name: 'Essential Properties Realty Trust, Inc.',
        price: 25.58,
        day_change: 0.04,
        change_pct: 0.16,
        volume: 894983,
        volume_avg: 909457,
        market_cap: 1952475392,
        pe: 49.57,
        intraday: [
            25.54, 25.43, 25.4, 25.29, 25.21, 25.24, 25.26, 25.32, 25.3, 25.23, 25.33, 25.39, 25.41, 25.3, 25.37, 25.36, 25.36, 25.43,
            25.45, 25.43, 25.37, 25.46, 25.48, 25.49, 25.48, 25.5, 25.51, 25.55, 25.53, 25.54, 25.56, 25.6, 25.53, 25.51, 25.5, 25.53,
            25.51, 25.54, 25.56, 25.55, 25.55, 25.5, 25.47, 25.47, 25.45, 25.47, 25.5, 25.53, 25.48, 25.49, 25.43, 25.38, 25.45, 25.46,
            25.4, 25.42, 25.34, 25.37, 25.36, 25.34, 25.35, 25.33, 25.42, 25.41, 25.48, 25.44, 25.46, 25.48, 25.5, 25.49, 25.49, 25.45,
            25.52, 25.56, 25.57, 25.58, 25.59, 25.58
        ]
    },
    {
        symbol: 'FB',
        name: 'Facebook, Inc.',
        price: 187.89,
        day_change: 2.09,
        change_pct: 1.12,
        volume: 6979273,
        volume_avg: 12925912,
        market_cap: 536040767488,
        pe: 31.78,
        intraday: [
            185.81, 185.25, 185.73, 185.74, 185.93, 186.33, 186.08, 186.03, 186.39, 186.33, 186.44, 186.87, 187.51, 187.11, 187.29, 187.43,
            187.83, 187.96, 188.27, 188.29, 188.25, 188.5, 188.76, 188.93, 188.54, 188.44, 188.52, 188.55, 188.33, 188.35, 188.21, 187.93,
            188.05, 188.29, 188.36, 188.5, 188.57, 188.47, 188.43, 188.63, 188.66, 188.66, 188.57, 188.57, 188.43, 188.57, 188.52, 188.4,
            188.29, 188.26, 188.44, 188.24, 188.28, 188.36, 188.24, 187.91, 188.05, 188.12, 187.77, 187.85, 187.83, 187.62, 187.74, 187.93,
            187.96, 187.96, 188.04, 188.17, 188.18, 188.18, 188.05, 188.19, 188.1, 188.19, 188.07, 188.02, 187.93, 187.9
        ]
    },
    {
        symbol: 'FOR',
        name: 'Forestar Group Inc.',
        price: 18.5,
        day_change: -0.32,
        change_pct: -1.7,
        volume: 77837,
        volume_avg: 88428,
        market_cap: 887951872,
        pe: 6.72,
        intraday: [
            18.8, 18.8, 18.43, 18.43, 18.48, 18.48, 18.38, 18.38, 18.43, 18.43, 18.35, 18.4, 18.32, 18.32, 18.33, 18.33, 18.3, 18.26, 18.26,
            18.21, 18.21, 18.12, 18.13, 18.13, 18.12, 18.13, 18.13, 18.19, 18.17, 18.16, 18.16, 18.17, 18.2, 18.17, 18.16, 18.16, 18.14,
            18.16, 18.19, 18.19, 18.16, 18.16, 18.16, 18.17, 18.17, 18.19, 18.19, 18.17, 18.17, 18.17, 18.18, 18.18, 18.16, 18.18, 18.17,
            18.17, 18.17, 18.17, 18.16, 18.16, 18.2, 18.29, 18.29, 18.35, 18.35, 18.35, 18.39, 18.36, 18.5, 18.49, 18.45, 18.47, 18.5, 18.48
        ]
    },
    {
        symbol: 'GATX',
        name: 'GATX Corporation',
        price: 80.2,
        day_change: -1.39,
        change_pct: -1.7,
        volume: 144502,
        volume_avg: 283171,
        market_cap: 2815019776,
        pe: 14.51,
        intraday: [
            81.6, 81.53, 81.64, 81.64, 81.26, 81.26, 80.63, 80.89, 80.91, 80.98, 81.06, 81.09, 80.93, 80.89, 80.8, 80.85, 80.65, 80.68,
            80.58, 80.46, 80.6, 80.38, 80.24, 80.01, 79.79, 80.02, 80.01, 80.08, 80.3, 80.4, 80.46, 80.6, 80.6, 80.32, 80.37, 80.44, 80.61,
            80.49, 80.49, 80.58, 80.58, 80.59, 80.64, 80.52, 80.49, 80.3, 80.45, 80.36, 80.29, 80.35, 80.45, 80.36, 80.41, 80.4, 79.86,
            79.41, 79.56, 79.64, 80.03, 80.16, 80.17, 80.22, 80.18, 80.25, 80.46, 80.56, 80.55, 80.59, 80.47, 80.42, 80.57, 80.41, 80.39,
            80.24, 80.23, 80.09, 80.26, 80.21
        ]
    },
    {
        symbol: 'GOOGL',
        name: 'Alphabet Inc.',
        price: 1264.3,
        day_change: 12.77,
        change_pct: 1.02,
        volume: 1243991,
        volume_avg: 1160087,
        market_cap: 877319290880,
        pe: 25.52,
        intraday: [
            1250.64, 1251.31, 1254.55, 1256.5, 1255.41, 1254.68, 1252.91, 1254.09, 1256.22, 1256.61, 1257.85, 1260.42, 1260.15, 1259.65,
            1261.1, 1261.26, 1263.52, 1264, 1264.86, 1264.52, 1264.04, 1264.98, 1266.85, 1267.93, 1265.79, 1266.83, 1266.93, 1267.49,
            1266.84, 1266.75, 1265.67, 1264.12, 1263.36, 1264.1, 1263.71, 1264.6, 1265, 1265, 1264.28, 1264.64, 1265.52, 1265.67, 1265.46,
            1265.36, 1265.49, 1265.6, 1265.38, 1265.37, 1264.68, 1263.98, 1264.75, 1265.1, 1266, 1266.34, 1266.22, 1264.06, 1263.03,
            1263.04, 1261.88, 1262.14, 1261.77, 1261, 1260.89, 1260.72, 1263.04, 1263.1, 1262.93, 1262.81, 1263.68, 1263.31, 1262.4,
            1263.43, 1263.6, 1264.01, 1264.16, 1263.89, 1263.45, 1263.41
        ]
    },
    {
        symbol: 'IBM',
        name: 'International Business Machines Corporation',
        price: 135.44,
        day_change: 0.91,
        change_pct: 0.68,
        volume: 2543592,
        volume_avg: 5996562,
        market_cap: 119982915584,
        pe: 14.23,
        intraday: [
            134.52, 134.76, 134.94, 134.59, 134.44, 134.35, 134.45, 134.42, 134.39, 134.52, 134.84, 135.26, 134.93, 134.77, 134.82, 134.88,
            135.34, 135.29, 135.45, 135.43, 135.36, 135.7, 135.72, 135.89, 135.9, 135.75, 135.72, 135.82, 135.74, 135.76, 135.65, 135.5,
            135.46, 135.55, 135.64, 135.59, 135.55, 135.59, 135.51, 135.4, 135.46, 135.44, 135.46, 135.49, 135.48, 135.49, 135.48, 135.37,
            135.37, 135.3, 135.3, 135.32, 135.31, 135.35, 135.36, 135.18, 135.25, 135.43, 135.55, 135.5, 135.43, 135.32, 135.29, 135.28,
            135.28, 135.4, 135.4, 135.34, 135.38, 135.37, 135.35, 135.39, 135.44, 135.43, 135.48, 135.43, 135.41, 135.43
        ]
    },
    {
        symbol: 'INTC',
        name: 'Intel Corporation',
        price: 56.46,
        day_change: 1.99,
        change_pct: 3.64,
        volume: 56704514,
        volume_avg: 16469900,
        market_cap: 252583968768,
        pe: 13.11,
        intraday: [
            54.61, 55.48, 55.38, 55.4, 55.68, 55.71, 55.87, 55.93, 55.85, 55.9, 55.96, 55.94, 55.94, 55.94, 55.85, 55.58, 55.92, 55.9,
            55.99, 55.98, 55.93, 56.11, 56.15, 56.4, 56.33, 56.2, 55.97, 56.17, 56.34, 56.17, 56.21, 56.18, 56.14, 56.14, 56.22, 56.19,
            56.25, 56.07, 56.1, 56.19, 56.14, 56.09, 56.03, 56.08, 56.13, 56.22, 56.24, 56.22, 56.23, 56.15, 56.26, 56.37, 56.31, 56.31,
            56.23, 56.19, 56.22, 56.29, 56.34, 56.33, 56.35, 56.25, 56.22, 56.18, 56.19, 56.22, 56.19, 56.25, 56.28, 56.39, 56.41, 56.46,
            56.53, 56.45, 56.43, 56.37, 56.4, 56.6
        ]
    },
    {
        symbol: 'INTU',
        name: 'Intuit Inc.',
        price: 257.67,
        day_change: -1.99,
        change_pct: -0.77,
        volume: 1038001,
        volume_avg: 1170162,
        market_cap: 67013271552,
        pe: 43.75,
        intraday: [
            259.8, 258.72, 258.6, 259.23, 259.13, 258.44, 258.75, 259.33, 259.71, 259.47, 259.68, 259.95, 259.79, 259.05, 259.1, 258.85,
            259.25, 258.8, 258.9, 258.83, 258.99, 259.42, 259.41, 259.01, 258.94, 258.98, 259.07, 258.93, 258.87, 258.76, 258.64, 258.04,
            257.73, 257.94, 258.08, 257.92, 258.15, 258.01, 257.96, 258.01, 258.18, 258.07, 258.07, 257.97, 257.9, 258.01, 258.01, 257.83,
            257.77, 257.46, 257.64, 257.78, 257.74, 257.58, 257.5, 257.19, 257.26, 257.2, 257.13, 257.06, 257.22, 256.83, 256.94, 257.04,
            256.81, 257.05, 257.08, 256.97, 256.86, 257.14, 257.15, 257.2, 257.29, 257.47, 257.39, 257.56, 257.4, 257.81
        ]
    },
    {
        symbol: 'JPM',
        name: 'JPMorgan Chase & Co.',
        price: 125.73,
        day_change: -0.11,
        change_pct: -0.09,
        volume: 7792212,
        volume_avg: 10052585,
        market_cap: 394352164864,
        pe: 12.41,
        intraday: [
            125.86, 125.75, 126.07, 125.8, 125.74, 125.78, 125.52, 125.68, 125.78, 125.78, 125.69, 125.68, 125.47, 125.29, 125.35, 125.44,
            125.52, 125.57, 125.6, 125.57, 125.56, 125.52, 125.29, 125.31, 125.22, 125.34, 125.24, 125.05, 124.98, 125.07, 125.08, 125.11,
            125.07, 125.14, 125.26, 125.36, 125.45, 125.35, 125.45, 125.44, 125.44, 125.54, 125.64, 125.51, 125.43, 125.4, 125.49, 125.46,
            125.48, 125.49, 125.44, 125.39, 125.49, 125.45, 125.57, 125.28, 125.44, 125.46, 125.59, 125.62, 125.65, 125.74, 126, 126.05,
            126.08, 126.03, 125.96, 125.79, 125.75, 125.69, 125.93, 125.82, 125.82, 125.73, 125.67, 125.51, 125.72, 125.75
        ]
    },
    {
        symbol: 'MSFT',
        name: 'Microsoft Corporation',
        price: 140.73,
        day_change: 1.04,
        change_pct: 0.75,
        volume: 20464765,
        volume_avg: 26070562,
        market_cap: 1094723174400,
        pe: 26.55,
        intraday: [
            139.48, 139.56, 139.57, 139.89, 140.3, 140.12, 140.35, 140.58, 140.98, 140.71, 140.77, 140.77, 140.69, 140.61, 140.65, 140.62,
            140.82, 140.82, 140.82, 140.84, 140.62, 140.92, 141.1, 141.08, 140.78, 140.83, 141.07, 141.01, 140.97, 141.02, 140.84, 140.72,
            140.69, 140.7, 140.77, 140.71, 140.73, 140.62, 140.55, 140.65, 140.69, 140.66, 140.68, 140.66, 140.68, 140.79, 140.84, 140.71,
            140.57, 140.51, 140.58, 140.65, 140.66, 140.68, 140.59, 140.51, 140.45, 140.48, 140.46, 140.44, 140.39, 140.26, 140.29, 140.26,
            140.25, 140.36, 140.41, 140.35, 140.41, 140.38, 140.47, 140.54, 140.49, 140.52, 140.43, 140.42, 140.38, 140.52
        ]
    },
    {
        symbol: 'NVDA',
        name: 'NVIDIA Corporation',
        price: 204.54,
        day_change: 3,
        change_pct: 1.49,
        volume: 10357677,
        volume_avg: 8645212,
        market_cap: 122178895872,
        pe: 46.12,
        intraday: [
            201.49, 202.51, 202.97, 201.91, 202.82, 202.28, 201.87, 201.42, 202.09, 202.28, 201.57, 202.62, 202.68, 202.38, 202.45, 202.53,
            203.34, 203.21, 203.85, 204.02, 204.29, 204.48, 204.57, 204.88, 204.4, 204.41, 204.4, 204.63, 204.89, 205.22, 204.87, 204.64,
            204.23, 204.36, 204.67, 204.61, 204.59, 204.07, 204.16, 204.2, 204.29, 203.85, 203.76, 203.75, 204, 204.4, 204.45, 204.57,
            204.75, 204.55, 204.51, 204.9, 204.9, 204.62, 204.52, 203.82, 203.72, 203.82, 203.87, 203.81, 203.77, 203.35, 203.47, 203.75,
            203.87, 203.93, 203.73, 203.69, 203.86, 203.84, 204.38, 204.71, 204.8, 204.66, 204.52, 204.57, 204.33, 204.49
        ]
    },
    {
        symbol: 'ORCL',
        name: 'Oracle Corporation',
        price: 54.17,
        day_change: 0.09,
        change_pct: 0.17,
        volume: 5741404,
        volume_avg: 9189612,
        market_cap: 177814110208,
        pe: 17.73,
        intraday: [
            54.04, 54.27, 54.25, 54.19, 54.23, 54.24, 54.24, 54.29, 54.35, 54.34, 54.35, 54.36, 54.28, 54.24, 54.18, 54.13, 54.22, 54.21,
            54.21, 54.21, 54.18, 54.28, 54.34, 54.38, 54.38, 54.36, 54.38, 54.38, 54.38, 54.42, 54.39, 54.28, 54.3, 54.28, 54.27, 54.26,
            54.27, 54.23, 54.22, 54.23, 54.25, 54.2, 54.2, 54.26, 54.27, 54.28, 54.26, 54.26, 54.24, 54.19, 54.22, 54.22, 54.22, 54.2, 54.2,
            54.13, 54.16, 54.15, 54.14, 54.1, 54.08, 54.01, 54.04, 54.05, 54.04, 54.1, 54.12, 54.1, 54.12, 54.12, 54.13, 54.16, 54.18,
            54.19, 54.15, 54.15, 54.13, 54.13
        ]
    },
    {
        symbol: 'PRGS',
        name: 'Progress Software Corporation',
        price: 40.31,
        day_change: 0.43,
        change_pct: 1.08,
        volume: 119189,
        volume_avg: 166171,
        market_cap: 1805307648,
        pe: 33.76,
        intraday: [
            39.86, 39.69, 39.69, 39.72, 39.74, 39.68, 39.5, 39.45, 39.55, 39.55, 39.65, 39.65, 39.63, 39.76, 39.79, 39.89, 39.87, 39.86,
            39.85, 39.85, 39.85, 39.85, 39.85, 39.86, 39.87, 39.92, 39.88, 39.86, 39.83, 39.82, 39.83, 39.83, 39.95, 39.94, 39.9, 39.94,
            39.94, 39.94, 39.95, 39.97, 39.96, 39.94, 39.93, 39.91, 39.89, 39.92, 39.93, 39.96, 39.95, 39.93, 39.92, 39.93, 39.9, 39.96,
            39.88, 39.9, 39.88, 39.94, 39.98, 39.95, 39.91, 39.9, 39.93, 39.97, 40.18, 40.18, 40.19, 40.19, 40.19, 40.24, 40.35, 40.28,
            40.3, 40.27, 40.33, 40.3, 40.33, 40.29
        ]
    },
    {
        symbol: 'QCOM',
        name: 'QUALCOMM Incorporated',
        price: 80.17,
        day_change: 0.94,
        change_pct: 1.19,
        volume: 5950509,
        volume_avg: 5573175,
        market_cap: 97459462144,
        pe: 29.34,
        intraday: [
            79.2, 79.12, 79.34, 79.07, 79.09, 79.15, 79.1, 79.08, 79.15, 79.21, 79.22, 79.32, 79.35, 79.28, 79.24, 79.13, 79.31, 79.33,
            79.39, 79.43, 79.55, 79.55, 79.6, 79.82, 79.83, 79.89, 79.91, 79.96, 80, 80.08, 80.06, 80.02, 79.98, 80, 80.03, 79.98, 80.01,
            79.87, 79.95, 79.97, 79.99, 79.91, 79.94, 79.9, 79.92, 79.98, 79.99, 79.98, 79.99, 79.9, 79.91, 79.98, 79.92, 79.92, 79.95,
            79.85, 80.01, 80.1, 80.15, 80.11, 80.07, 79.93, 79.84, 79.84, 79.82, 79.95, 79.93, 79.83, 79.82, 79.95, 79.98, 80.14, 80.16,
            80.1, 80.1, 80.12, 80.14, 80.14
        ]
    },
    {
        symbol: 'SAP',
        name: 'SAP SE',
        price: 131.87,
        day_change: 0.34,
        change_pct: 0.26,
        volume: 558142,
        volume_avg: 1046450,
        market_cap: 162669559808,
        pe: 31.86,
        intraday: [
            131.43, 131.37, 131.06, 131.03, 131.23, 131.25, 131.32, 131.33, 131.59, 131.67, 131.72, 131.82, 131.79, 131.81, 131.76, 131.78,
            131.85, 131.84, 131.95, 131.79, 131.77, 131.83, 131.92, 132.02, 131.95, 132.08, 131.99, 132.05, 131.96, 131.94, 131.75, 131.73,
            131.73, 131.72, 131.71, 131.78, 131.73, 131.67, 131.73, 131.74, 131.82, 131.79, 131.83, 131.83, 131.82, 131.79, 131.77, 131.75,
            131.7, 131.72, 131.77, 131.74, 131.73, 131.67, 131.65, 131.61, 131.62, 131.65, 131.62, 131.63, 131.55, 131.56, 131.6, 131.58,
            131.69, 131.69, 131.65, 131.61, 131.65, 131.66, 131.7, 131.7, 131.71, 131.68, 131.66, 131.67, 131.77
        ]
    },
    {
        symbol: 'SNAP',
        name: 'Snap Inc.',
        price: 13.52,
        day_change: 0.29,
        change_pct: 2.19,
        volume: 54048642,
        volume_avg: 44871025,
        market_cap: 18647865344,
        pe: null,
        intraday: [
            13.22, 12.93, 12.94, 12.94, 13.03, 13.06, 13.06, 13.02, 13.06, 13.08, 13.07, 13.09, 13.1, 13.15, 13.16, 13.27, 13.2, 13.33,
            13.44, 13.52, 13.58, 13.6, 13.48, 13.54, 13.53, 13.6, 13.55, 13.56, 13.58, 13.65, 13.58, 13.6, 13.58, 13.51, 13.54, 13.58,
            13.54, 13.54, 13.55, 13.54, 13.56, 13.61, 13.61, 13.55, 13.55, 13.52, 13.48, 13.47, 13.47, 13.38, 13.42, 13.44, 13.43, 13.39,
            13.42, 13.41, 13.4, 13.41, 13.38, 13.4, 13.39, 13.41, 13.44, 13.43, 13.49, 13.51, 13.51, 13.54, 13.56, 13.59, 13.58, 13.58,
            13.57, 13.53, 13.51, 13.49, 13.48, 13.51
        ]
    },
    {
        symbol: 'SNE',
        name: 'Sony Corporation',
        price: 58.51,
        day_change: 0.47,
        change_pct: 0.81,
        volume: 670753,
        volume_avg: 757475,
        market_cap: 71632035840,
        pe: 12.3,
        intraday: [
            58.11, 58.09, 58.15, 58.11, 58.19, 58.17, 58.16, 58.2, 58.27, 58.24, 58.24, 58.25, 58.29, 58.25, 58.28, 58.34, 58.41, 58.38,
            58.4, 58.35, 58.35, 58.38, 58.47, 58.48, 58.47, 58.52, 58.53, 58.59, 58.58, 58.57, 58.52, 58.5, 58.48, 58.48, 58.48, 58.45,
            58.47, 58.39, 58.38, 58.39, 58.42, 58.43, 58.43, 58.39, 58.42, 58.4, 58.39, 58.43, 58.46, 58.42, 58.47, 58.45, 58.43, 58.46,
            58.47, 58.4, 58.45, 58.46, 58.5, 58.5, 58.47, 58.44, 58.46, 58.48, 58.5, 58.49, 58.5, 58.52, 58.52, 58.55, 58.53, 58.54, 58.54,
            58.58, 58.57, 58.58, 58.56, 58.58
        ]
    },
    {
        symbol: 'TSM',
        name: 'Taiwan Semiconductor Manufacturing Company Limited',
        price: 51.13,
        day_change: 0.36,
        change_pct: 0.71,
        volume: 5965678,
        volume_avg: 9484987,
        market_cap: 250063552512,
        pe: 22.93,
        intraday: [
            50.79, 50.85, 50.92, 50.9, 50.92, 50.91, 50.86, 50.78, 50.73, 50.82, 50.85, 50.87, 50.85, 50.88, 50.97, 50.95, 51.05, 51.06,
            50.99, 51.01, 51.03, 50.93, 50.92, 51, 51, 50.92, 50.97, 50.98, 50.97, 50.94, 50.93, 50.9, 50.92, 50.92, 50.96, 50.99, 51,
            50.97, 51.04, 51.03, 51.01, 51.05, 51.05, 51.06, 51.06, 51.06, 51.05, 51.03, 51.03, 51.01, 50.99, 51.03, 51.04, 51.04, 51.04,
            50.97, 50.96, 50.96, 50.99, 51, 51, 50.97, 50.99, 51.01, 51.03, 51.06, 51.04, 51.03, 51.07, 51.03, 51.04, 51.12, 51.14, 51.1,
            51.11, 51.09, 51.1, 51.15
        ]
    },
    {
        symbol: 'TWTR',
        name: 'Twitter, Inc.',
        price: 30.75,
        day_change: -0.64,
        change_pct: -2.07,
        volume: 105075360,
        volume_avg: 10571275,
        market_cap: 23770302464,
        pe: 10.16,
        intraday: [
            30.95, 30.53, 30.56, 30.64, 30.53, 30.39, 30.26, 30.13, 30.03, 29.99, 30.11, 30.16, 30.14, 30.02, 30.01, 30, 30.11, 30.16,
            30.22, 30.17, 30.15, 30.2, 30.23, 30.33, 30.35, 30.3, 30.39, 30.44, 30.48, 30.55, 30.34, 30.47, 30.37, 30.42, 30.44, 30.47,
            30.51, 30.56, 30.48, 30.52, 30.53, 30.63, 30.58, 30.51, 30.45, 30.52, 30.52, 30.49, 30.33, 30.34, 30.29, 30.3, 30.31, 30.26,
            30.31, 30.2, 30.25, 30.15, 30.1, 30.07, 30.08, 30.06, 30.07, 30.14, 30.17, 30.13, 30.14, 30.13, 30.15, 30.18, 30.2, 30.24,
            30.21, 30.32, 30.31, 30.33, 30.33, 30.31
        ]
    },
    {
        symbol: 'TXN',
        name: 'Texas Instruments Incorporated',
        price: 120.51,
        day_change: 1.21,
        change_pct: 1.01,
        volume: 4106890,
        volume_avg: 6018987,
        market_cap: 112698302464,
        pe: 22.37,
        intraday: [
            119.32, 119.08, 119.2, 118.7, 118.93, 119.07, 118.95, 118.92, 118.99, 118.98, 119.1, 118.98, 118.92, 118.8, 118.84, 118.81,
            119.13, 119.21, 119.36, 119.32, 119.32, 119.34, 119.31, 119.61, 119.58, 119.79, 119.85, 119.97, 120, 119.92, 119.78, 119.71,
            119.78, 119.97, 120.08, 120.07, 120.22, 120.14, 120.18, 120.25, 120.25, 120.13, 120.28, 120.32, 120.38, 120.46, 120.55, 120.52,
            120.59, 120.37, 120.39, 120.56, 120.43, 120.51, 120.43, 120.24, 120.29, 120.23, 120.21, 120.22, 120.24, 120.03, 120.12, 120.17,
            120.24, 120.28, 120.32, 120.33, 120.25, 120.29, 120.35, 120.5, 120.5, 120.5, 120.39, 120.46, 120.37, 120.53
        ]
    },
    {
        symbol: 'XOM',
        name: 'Exxon Mobil Corporation',
        price: 67.72,
        day_change: -0.54,
        change_pct: -0.79,
        volume: 11995831,
        volume_avg: 10012842,
        market_cap: 286530764800,
        pe: 16.32,
        intraday: [
            68.28, 68.18, 68.1, 68.04, 68.04, 68.03, 68, 68.1, 68.11, 68.02, 68.07, 68.01, 68, 68.07, 67.97, 68, 67.98, 67.99, 67.93, 67.88,
            67.85, 67.82, 67.81, 67.82, 67.77, 67.81, 67.77, 67.72, 67.71, 67.64, 67.71, 67.78, 67.71, 67.71, 67.68, 67.67, 67.7, 67.61,
            67.62, 67.59, 67.62, 67.61, 67.7, 67.71, 67.7, 67.62, 67.6, 67.63, 67.6, 67.57, 67.57, 67.5, 67.47, 67.5, 67.46, 67.36, 67.41,
            67.4, 67.43, 67.51, 67.39, 67.31, 67.3, 67.36, 67.43, 67.5, 67.55, 67.54, 67.54, 67.53, 67.54, 67.56, 67.53, 67.5, 67.51, 67.49,
            67.64, 67.74
        ]
    }
];

export const heatmapStocks = [
    {
        'symbol': 'SNAP',
        'name': 'Snap Inc.',
        'currency': 'USD',
        'price': '13.52',
        'price_open': '13.18',
        'day_high': '13.65',
        'day_low': '12.71',
        '52_week_high': '18.36',
        '52_week_low': '4.82',
        'day_change': '0.34',
        'change_pct': '2.58',
        'close_yesterday': '13.18',
        'market_cap': '18647865344',
        'volume': '54048642',
        'volume_avg': '44871025',
        'shares': '1103779968',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-24 16:01:50',
        'pe': 'N/A',
        'eps': '-0.72'
    },
    {
        'symbol': 'TWTR',
        'name': 'Twitter, Inc.',
        'currency': 'USD',
        'price': '30.75',
        'price_open': '31.86',
        'day_high': '32.39',
        'day_low': '30.51',
        '52_week_high': '45.86',
        '52_week_low': '26.26',
        'day_change': '-8.08',
        'change_pct': '-20.81',
        'close_yesterday': '38.83',
        'market_cap': '23770302464',
        'volume': '105075360',
        'volume_avg': '10571275',
        'shares': '773017984',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-24 16:03:45',
        'pe': '10.16',
        'eps': '3.03'
    },
    {
        'symbol': 'AAPL',
        'name': 'Apple Inc.',
        'currency': 'USD',
        'price': '246.58',
        'price_open': '243.16',
        'day_high': '246.72',
        'day_low': '242.89',
        '52_week_high': '246.72',
        '52_week_low': '142.00',
        'day_change': '3.00',
        'change_pct': '1.23',
        'close_yesterday': '243.58',
        'market_cap': '1114344259584',
        'volume': '15827692',
        'volume_avg': '20028962',
        'shares': '4519199744',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '20.94',
        'eps': '11.78'
    },
    {
        'symbol': 'FB',
        'name': 'Facebook, Inc.',
        'currency': 'USD',
        'price': '187.89',
        'price_open': '185.83',
        'day_high': '189.00',
        'day_low': '185.09',
        '52_week_high': '208.66',
        '52_week_low': '123.02',
        'day_change': '1.51',
        'change_pct': '0.81',
        'close_yesterday': '186.38',
        'market_cap': '536040767488',
        'volume': '6979273',
        'volume_avg': '12925912',
        'shares': '2405720064',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '31.78',
        'eps': '5.91'
    },
    {
        'symbol': 'GOOGL',
        'name': 'Alphabet Inc.',
        'currency': 'USD',
        'price': '1264.30',
        'price_open': '1252.00',
        'day_high': '1268.00',
        'day_low': '1249.15',
        '52_week_high': '1296.97',
        '52_week_low': '977.66',
        'day_change': '5.19',
        'change_pct': '0.41',
        'close_yesterday': '1259.11',
        'market_cap': '877319290880',
        'volume': '1243991',
        'volume_avg': '1160087',
        'shares': '299532000',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '25.52',
        'eps': '49.54'
    },
    {
        'symbol': 'MSFT',
        'name': 'Microsoft Corporation',
        'currency': 'USD',
        'price': '140.73',
        'price_open': '139.34',
        'day_high': '141.14',
        'day_low': '139.20',
        '52_week_high': '142.37',
        '52_week_low': '93.96',
        'day_change': '0.79',
        'change_pct': '0.56',
        'close_yesterday': '139.94',
        'market_cap': '1094723174400',
        'volume': '20464765',
        'volume_avg': '26070562',
        'shares': '7695349760',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '26.55',
        'eps': '5.30'
    },
    {
        'symbol': 'INTC',
        'name': 'Intel Corporation',
        'currency': 'USD',
        'price': '56.46',
        'price_open': '54.19',
        'day_high': '56.61',
        'day_low': '53.95',
        '52_week_high': '59.59',
        '52_week_low': '42.86',
        'day_change': '4.23',
        'change_pct': '8.10',
        'close_yesterday': '52.23',
        'market_cap': '252583968768',
        'volume': '56704514',
        'volume_avg': '16469900',
        'shares': '4430000128',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '13.11',
        'eps': '4.31'
    },
    {
        'symbol': 'CRM',
        'name': 'salesforce.com, inc.',
        'currency': 'USD',
        'price': '150.49',
        'price_open': '147.05',
        'day_high': '150.66',
        'day_low': '146.30',
        '52_week_high': '167.56',
        '52_week_low': '113.60',
        'day_change': '2.37',
        'change_pct': '1.60',
        'close_yesterday': '148.12',
        'market_cap': '131979730944',
        'volume': '4814264',
        'volume_avg': '5236950',
        'shares': '877000000',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:01:48',
        'pe': '124.99',
        'eps': '1.20'
    },
    {
        'symbol': 'CSCO',
        'name': 'Cisco Systems, Inc.',
        'currency': 'USD',
        'price': '46.90',
        'price_open': '46.54',
        'day_high': '46.99',
        'day_low': '46.46',
        '52_week_high': '58.26',
        '52_week_low': '40.25',
        'day_change': '0.49',
        'change_pct': '1.06',
        'close_yesterday': '46.41',
        'market_cap': '196328095744',
        'volume': '12554651',
        'volume_avg': '16144737',
        'shares': '4243830016',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '17.97',
        'eps': '2.61'
    },
    {
        'symbol': 'ORCL',
        'name': 'Oracle Corporation',
        'currency': 'USD',
        'price': '54.17',
        'price_open': '54.04',
        'day_high': '54.42',
        'day_low': '54.01',
        '52_week_high': '60.50',
        '52_week_low': '42.40',
        'day_change': '-0.09',
        'change_pct': '-0.17',
        'close_yesterday': '54.26',
        'market_cap': '177814110208',
        'volume': '5741404',
        'volume_avg': '9189612',
        'shares': '3288329984',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:03:50',
        'pe': '17.73',
        'eps': '3.06'
    },
    {
        'symbol': 'SAP',
        'name': 'SAP SE',
        'currency': 'USD',
        'price': '131.87',
        'price_open': '131.35',
        'day_high': '132.18',
        'day_low': '130.96',
        '52_week_high': '140.62',
        '52_week_low': '94.81',
        'day_change': '0.08',
        'change_pct': '0.06',
        'close_yesterday': '131.79',
        'market_cap': '162669559808',
        'volume': '558142',
        'volume_avg': '1046450',
        'shares': '1228499968',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:04:17',
        'pe': '31.86',
        'eps': '4.14'
    },
    {
        'symbol': 'TSM',
        'name': 'Taiwan Semiconductor Manufacturing Company Limited',
        'currency': 'USD',
        'price': '51.13',
        'price_open': '50.80',
        'day_high': '51.23',
        'day_low': '50.69',
        '52_week_high': '51.23',
        '52_week_low': '34.21',
        'day_change': '0.18',
        'change_pct': '0.35',
        'close_yesterday': '50.95',
        'market_cap': '250063552512',
        'volume': '5965678',
        'volume_avg': '9484987',
        'shares': '5186079744',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:01:26',
        'pe': '22.93',
        'eps': '2.23'
    },
    {
        'symbol': 'ACN',
        'name': 'Accenture plc',
        'currency': 'USD',
        'price': '183.07',
        'price_open': '184.67',
        'day_high': '184.83',
        'day_low': '183.02',
        '52_week_high': '202.80',
        '52_week_low': '132.63',
        'day_change': '-1.93',
        'change_pct': '-1.04',
        'close_yesterday': '185.00',
        'market_cap': '116597284864',
        'volume': '1369124',
        'volume_avg': '1892150',
        'shares': '636000000',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:12',
        'pe': '24.87',
        'eps': '7.36'
    },
    {
        'symbol': 'ADBE',
        'name': 'Adobe Inc.',
        'currency': 'USD',
        'price': '270.98',
        'price_open': '267.80',
        'day_high': '271.61',
        'day_low': '267.02',
        '52_week_high': '313.11',
        '52_week_low': '204.95',
        'day_change': '1.28',
        'change_pct': '0.47',
        'close_yesterday': '269.70',
        'market_cap': '131175735296',
        'volume': '1511852',
        'volume_avg': '3342325',
        'shares': '484079008',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '48.22',
        'eps': '5.62'
    },
    {
        'symbol': 'AVGO',
        'name': 'Broadcom Inc.',
        'currency': 'USD',
        'price': '289.82',
        'price_open': '283.26',
        'day_high': '291.37',
        'day_low': '283.22',
        '52_week_high': '323.20',
        '52_week_low': '208.23',
        'day_change': '7.51',
        'change_pct': '2.66',
        'close_yesterday': '282.31',
        'market_cap': '114963193856',
        'volume': '1987976',
        'volume_avg': '1691400',
        'shares': '396671008',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '40.79',
        'eps': '7.11'
    },
    {
        'symbol': 'IBM',
        'name': 'International Business Machines Corporation',
        'currency': 'USD',
        'price': '135.44',
        'price_open': '134.12',
        'day_high': '135.93',
        'day_low': '134.10',
        '52_week_high': '152.95',
        '52_week_low': '105.94',
        'day_change': '1.37',
        'change_pct': '1.02',
        'close_yesterday': '134.07',
        'market_cap': '119982915584',
        'volume': '2543592',
        'volume_avg': '5996562',
        'shares': '885875008',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:04',
        'pe': '14.23',
        'eps': '9.52'
    },
    {
        'symbol': 'NVDA',
        'name': 'NVIDIA Corporation',
        'currency': 'USD',
        'price': '204.54',
        'price_open': '200.10',
        'day_high': '205.38',
        'day_low': '199.79',
        '52_week_high': '222.00',
        '52_week_low': '124.46',
        'day_change': '7.68',
        'change_pct': '3.90',
        'close_yesterday': '196.86',
        'market_cap': '122178895872',
        'volume': '10357677',
        'volume_avg': '8645212',
        'shares': '609000000',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '46.12',
        'eps': '4.44'
    },
    {
        'symbol': 'ASML',
        'name': 'ASML Holding N.V.',
        'currency': 'USD',
        'price': '263.99',
        'price_open': '262.45',
        'day_high': '264.70',
        'day_low': '261.88',
        '52_week_high': '269.39',
        '52_week_low': '144.50',
        'day_change': '-0.98',
        'change_pct': '-0.37',
        'close_yesterday': '264.97',
        'market_cap': '110834614272',
        'volume': '549797',
        'volume_avg': '1164687',
        'shares': '421143008',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '37.94',
        'eps': '6.96'
    },
    {
        'symbol': 'INTU',
        'name': 'Intuit Inc.',
        'currency': 'USD',
        'price': '257.67',
        'price_open': '259.13',
        'day_high': '260.28',
        'day_low': '256.70',
        '52_week_high': '295.77',
        '52_week_low': '182.61',
        'day_change': '-1.23',
        'change_pct': '-0.48',
        'close_yesterday': '258.90',
        'market_cap': '67013271552',
        'volume': '1038001',
        'volume_avg': '1170162',
        'shares': '260074000',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '43.75',
        'eps': '5.89'
    },
    {
        'symbol': 'QCOM',
        'name': 'QUALCOMM Incorporated',
        'currency': 'USD',
        'price': '80.17',
        'price_open': '79.00',
        'day_high': '80.23',
        'day_low': '78.91',
        '52_week_high': '90.34',
        '52_week_low': '49.10',
        'day_change': '1.18',
        'change_pct': '1.49',
        'close_yesterday': '78.99',
        'market_cap': '97459462144',
        'volume': '5950509',
        'volume_avg': '5573175',
        'shares': '1215660032',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '29.34',
        'eps': '2.73'
    },
    {
        'symbol': 'SNE',
        'name': 'Sony Corporation',
        'currency': 'USD',
        'price': '58.51',
        'price_open': '58.23',
        'day_high': '58.62',
        'day_low': '58.03',
        '52_week_high': '60.74',
        '52_week_low': '41.91',
        'day_change': '-0.12',
        'change_pct': '-0.20',
        'close_yesterday': '58.63',
        'market_cap': '71632035840',
        'volume': '670753',
        'volume_avg': '757475',
        'shares': '1234150016',
        'stock_exchange_long': 'New York Stock Exchange',
        'stock_exchange_short': 'NYSE',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:02:00',
        'pe': '12.30',
        'eps': '4.76'
    },
    {
        'symbol': 'TXN',
        'name': 'Texas Instruments Incorporated',
        'currency': 'USD',
        'price': '120.51',
        'price_open': '118.51',
        'day_high': '120.68',
        'day_low': '118.51',
        '52_week_high': '132.20',
        '52_week_low': '87.70',
        'day_change': '2.10',
        'change_pct': '1.77',
        'close_yesterday': '118.41',
        'market_cap': '112698302464',
        'volume': '4106890',
        'volume_avg': '6018987',
        'shares': '933619968',
        'stock_exchange_long': 'NASDAQ Stock Exchange',
        'stock_exchange_short': 'NASDAQ',
        'timezone': 'EDT',
        'timezone_name': 'America/New_York',
        'gmt_offset': '-14400',
        'last_trade_time': '2019-10-25 16:00:01',
        'pe': '22.37',
        'eps': '5.39'
    }
];
