# Kendo UI for Angular

Kendo UI for Angular uses GitHub Issues as an official bug tracker.

This repository is intended to support users by providing information on available support options and by storing the sample projects that are referred to from the official Kendo UI for Angular documentation.

**This repository does not contain the actual source code of the components.**

## In This Article

* [Available Support Options](#support-options)
    * [Information on How to Use Specific Features](#how-do-i)
    * [Queries on Future Releases](#when-do-you-plan-on-releasing-feature-x)
    * [Bug Discovery](#i-think-i-found-a-bug)
    * [Bug Reports](#i-want-to-report-a-bug)
    * [Tailor-Made Solutions](#i-need-a-tailor-made-solution)
* [Sample Projects and Applications](#sample-projects)

## Support Options

Kendo UI for Angular provides the following support options.

### How do I...?

1. Check out the [**Components** &nearr;](http://www.telerik.com/kendo-angular-ui/components/), or the [**FAQ** &nearr;](http://www.telerik.com/kendo-angular-ui/components/faq/) and [**Troubleshooting** &nearr;](http://www.telerik.com/kendo-angular-ui/components/troubleshooting/) pages.
1. Browse the [kendo-ui-angular2 &nearr;](http://stackoverflow.com/questions/tagged/kendo-ui-angular2) questions on Stack Overflow. If you haven't found what you are looking for there, pose a question for the Stack Overflow community to follow or answer.
1. Use our official support channel and [submit a support ticket &nearr;](https://www.telerik.com/account/support-tickets).

### When do you plan on releasing Feature X?

1. Check the [Roadmap](https://www.telerik.com/support/whats-new/kendo-ui/roadmap#angular-roadmap) for the planned items.
1. If the item you need is not present there, [check our feedback portal](https://feedback.telerik.com/kendo-angular-ui). If someone has already posted it there, you can upvote it. If nobody has requested it so far, you can post a new idea.

### I think I found a bug

1. Review the issues in the [Issue Tracker &nearr;](https://github.com/telerik/kendo-angular/issues). Maybe someone has already reported it and it will be fixed soon.
1. The problem might have also been fixed. In this case, you will find the issue in [the closed issues list &nearr;](https://github.com/telerik/kendo-angular/issues?q=is%3Aissue+is%3Aclosed).
1. If you cannot find your issue, [follow the reproduction steps guide below](#i-want-to-report-a-bug). We will look into it.

### I want to report a bug

1. Find an example in [the documentation](http://www.telerik.com/kendo-angular-ui/components/) that looks similar to your case.
1. Open it in StackBlitz by using the **Edit in StackBlitz** button.
1. Modify the example, so that the issue is reproducible in it. Try to include the minimum possible amount of code.
1. Save the example by using the blue **Fork** button at the top.
1. Copy the link from the address bar of the browser.
1. [Open a new issue](https://github.com/telerik/kendo-angular/issues/new) and add the StackBlitz link in the description.
1. Provide any additional information necessary for us to reproduce the problem&mdash;for example, browser version, steps to perform, etc.

We might not be able to act on issues **without a runnable demo**.

If you need assistance on troubleshooting or isolating a problem, you can request a remote assistance session through our [Support Ticket](https://www.telerik.com/account/support-tickets) system. Remote Assistance is included in the [DevCraft Ultimate](http://www.telerik.com/purchase/kendo-ui) subscription.

### I need a tailor-made solution

Our aim is to provide the most versatile and proven set of application building blocks. Still, depending on the functionality you desire, some assembly is required.

The [Progress Services](https://www.progress.com/services) team is available to assist in building functional blocks or complete applications according to your specification. They will help you make the most of Kendo UI while freeing you to work on the real business problems.

## Sample Projects

The kendo-angular repository is a single storing place for all sample applications that are referred in the [official Kendo UI for Angular documentation]. All currently available sample applications are located under the following folders:

* [examples/projects/](https://github.com/telerik/kendo-angular/tree/master/examples/projects)
* [examples-standalone](https://github.com/telerik/kendo-angular/tree/master/examples-standalone)
