//-----------------------------------------------------------------------
// <copyright file="DummyControllerProvider.cs" company="Google Inc.">
// Copyright 2016 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// </copyright>
//-----------------------------------------------------------------------

using Gvr;

/// @cond
namespace Gvr.Internal
{
    /// Dummy controller provider.
    /// Used in platforms that do not support controllers.
    class DummyControllerProvider : IControllerProvider
    {
        private ControllerState dummyState = new ControllerState();

        public bool SupportsBatteryStatus
        {
            get
            {
                return false;
            }
        }

        public int MaxControllerCount
        {
            get
            {
                return 1;
            }
        }

        internal DummyControllerProvider()
        {
        }

        public void Dispose()
        {
        }

        public void ReadState(ControllerState outState, int controller_id)
        {
            outState.CopyFrom(dummyState);
        }

        public void OnPause()
        {
        }

        public void OnResume()
        {
        }
    }
}

/// @endcond
