# Contributing to gollm

Welcome to gollm! We're excited that you're interested in contributing. This guide aims to make your contribution experience smooth and enjoyable.

## Our Philosophy

- **Simplicity is key**: We believe in clear, readable code that speaks for itself.
- **Learn by example**: New features should come with well-commented examples.
- **Open to all**: Whether you're fixing a typo, adding a new provider or implementing a major feature, your contribution is valuable. (thank you !)

## How to Contribute

1. **Fork the repository** and create your branch from `main`.
2. **Make your changes**:
   - Focus on a single purpose per commit.
   - Ensure your code is readable and well-commented.
   - Add examples for new features.
3. **Test your changes** to make sure everything works as expected.
4. **Submit a pull request** with a clear title and description.

## Best Practices

- **Keep it simple**: Aim for clear, concise code that others can easily understand.
- **Comment your code**: Explain the 'why' behind complex logic.
- **Write examples**: For new features, include a simple example of how to use it.
- **Follow Go conventions**: Use `gofmt` to format your code.

## Need Help?

- **Ask questions**: If you're unsure about something, just ask! Open an issue or start a discussion.
- **Join the community**: https://discord.gg/Kk9sBTexG5

## Bug Reports and Feature Requests

- Use the issue tracker to report bugs or suggest features.
- Describe what you expected to happen and what actually happened.
- Include as much information as possible: version numbers, operating system, etc.

## Code of Conduct

Be kind, respectful, and inclusive. We want gollm to be a welcoming community for all.

Thank you for contributing to gollm! Your efforts help make this project better for everyone.
