'use strict';
describe('setInterval', function () {
    it('should work with setInterval', function (done) {
        var testZone = global.zone.fork({
            addTask: function (fn) { wtfMock.log.push('addTask ' + fn.id); },
            removeTask: function (fn) { wtfMock.log.push('removeTask ' + fn.id); },
            addRepeatingTask: function (fn) { wtfMock.log.push('addRepeatingTask ' + fn.id); },
            removeRepeatingTask: function (fn) { wtfMock.log.push('removeRepeatingTask ' + fn.id); },
        });
        var zId;
        var setIntervalId = '?';
        testZone.run(function () {
            zId = global.zone.$id;
            var intervalFn = function () {
                var zCallbackId = global.zone.$id;
                // creates implied zone in all callbacks.
                expect(global.zone).toBeDirectChildOf(testZone);
                clearInterval(cancelId);
                global.zone.setTimeoutUnpatched(function () {
                    expect(wtfMock.log).toEqual([
                        'addRepeatingTask abc',
                        '# Zone#setInterval(' + zId + ', ' + cancelId + ', 10)',
                        '> Zone#cb:setInterval(' + zCallbackId + ', ' + cancelId + ', 10)',
                        '# Zone#clearInterval(' + zCallbackId + ', ' + cancelId + ')',
                        'removeRepeatingTask abc',
                        '< Zone#cb:setInterval'
                    ]);
                    done();
                });
            };
            intervalFn.id = 'abc';
            var cancelId = setInterval(intervalFn, 10);
            expect(wtfMock.log[0]).toEqual('addRepeatingTask abc');
            expect(wtfMock.log[1]).toEqual('# Zone#setInterval(' + zId + ', ' + cancelId + ', 10)');
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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