var util_1 = require('../util');
describe('WebSocket', util_1.ifEnvSupports('WebSocket', function () {
    var socket;
    var TEST_SERVER_URL = 'ws://localhost:8001';
    var flag;
    var testZone = global.zone.fork();
    beforeEach(function (done) {
        socket = new WebSocket(TEST_SERVER_URL);
        socket.addEventListener('open', done);
        socket.addEventListener('error', function () {
            fail("Can't establish socket to " + TEST_SERVER_URL +
                "! do you have test/ws-server.js running?");
            done();
        });
    });
    afterEach(function (done) {
        socket.addEventListener('close', done);
        socket.close();
        done();
    });
    it('should be patched in a Web Worker', function (done) {
        var worker = new Worker('/base/test/ws-webworker-context.ts');
        worker.onmessage = function (e) {
            expect(e.data).toBe('pass');
            done();
        };
    });
    it('should work with addEventListener', function (done) {
        testZone.run(function () {
            socket.addEventListener('message', function (event) {
                expect(global.zone).toBeDirectChildOf(testZone);
                expect(event['data']).toBe('hi');
                done();
            });
        });
        socket.send('hi');
    });
    it('should respect removeEventListener', function (done) {
        var log = '';
        function logOnMessage() {
            log += 'a';
            expect(log).toEqual('a');
            socket.removeEventListener('message', logOnMessage);
            socket.send('hi');
            setTimeout(function () {
                expect(log).toEqual('a');
                done();
            }, 10);
        }
        ;
        socket.addEventListener('message', logOnMessage);
        socket.send('hi');
    });
    it('should work with onmessage', function (done) {
        testZone.run(function () {
            socket.onmessage = function (contents) {
                expect(global.zone).toBeDirectChildOf(testZone);
                expect(contents.data).toBe('hi');
                done();
            };
        });
        socket.send('hi');
    });
    it('should only allow one onmessage handler', function (done) {
        var log = '';
        socket.onmessage = function () {
            log += 'a';
            expect(log).toEqual('b');
            done();
        };
        socket.onmessage = function () {
            log += 'b';
            expect(log).toEqual('b');
            done();
        };
        socket.send('hi');
    });
    it('should handle removing onmessage', function (done) {
        var log = '';
        socket.onmessage = function () {
            log += 'a';
        };
        socket.onmessage = null;
        socket.send('hi');
        setTimeout(function () {
            expect(log).toEqual('');
            done();
        }, 100);
    });
}));
//# sourceMappingURL=data:application/json;base64,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