var util_1 = require('../util');
describe('FileReader', util_1.ifEnvSupports('FileReader', function () {
    var fileReader;
    var blob;
    var data = 'Hello, World!';
    var testZone = global.zone.fork();
    // Android 4.3's native browser doesn't implement add/RemoveEventListener for FileReader 
    function supportsEventTargetFns() {
        return FileReader.prototype.addEventListener && FileReader.prototype.removeEventListener;
    }
    supportsEventTargetFns.message = 'FileReader#addEventListener and FileReader#removeEventListener';
    beforeEach(function () {
        fileReader = new FileReader();
        try {
            blob = new Blob([data]);
        }
        catch (e) {
            // For hosts that don't support the Blob ctor (e.g. Android 4.3's native browser)
            var blobBuilder = new global.WebKitBlobBuilder();
            blobBuilder.append(data);
            blob = blobBuilder.getBlob();
        }
    });
    describe('EventTarget methods', util_1.ifEnvSupports(supportsEventTargetFns, function () {
        it('should bind addEventListener listeners', function (done) {
            testZone.run(function () {
                fileReader.addEventListener('load', function () {
                    expect(global.zone).toBeDirectChildOf(testZone);
                    expect(fileReader.result).toEqual(data);
                    done();
                });
            });
            fileReader.readAsText(blob);
        });
        it('should remove listeners via removeEventListener', function (done) {
            var listenerSpy = jasmine.createSpy('listener');
            testZone.run(function () {
                fileReader.addEventListener('loadstart', listenerSpy);
                fileReader.addEventListener('loadend', function () {
                    expect(listenerSpy).not.toHaveBeenCalled();
                    done();
                });
            });
            fileReader.removeEventListener('loadstart', listenerSpy);
            fileReader.readAsText(blob);
        });
    }));
    it('should bind onEventType listeners', function (done) {
        var listenersCalled = 0;
        testZone.run(function () {
            fileReader.onloadstart = function () {
                listenersCalled++;
                expect(global.zone).toBeDirectChildOf(testZone);
            };
            fileReader.onload = function () {
                listenersCalled++;
                expect(global.zone).toBeDirectChildOf(testZone);
            };
            fileReader.onloadend = function () {
                listenersCalled++;
                expect(global.zone).toBeDirectChildOf(testZone);
                expect(fileReader.result).toEqual(data);
                expect(listenersCalled).toBe(3);
                done();
            };
        });
        fileReader.readAsText(blob);
    });
    it('should have correct readyState', function (done) {
        fileReader.onloadend = function () {
            expect(fileReader.readyState).toBe(FileReader.DONE);
            done();
        };
        expect(fileReader.readyState).toBe(FileReader.EMPTY);
        fileReader.readAsText(blob);
    });
}));
//# sourceMappingURL=data:application/json;base64,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