import { Scheduler } from '../Scheduler';
import { Observable } from '../Observable';
/**
 * Returns an Observable that emits the items in a specified Iterable before it begins to emit items emitted by the
 * source Observable.
 *
 * <img src="./img/startWith.png" width="100%">
 *
 * @param {Values} an Iterable that contains the items you want the modified Observable to emit first.
 * @returns {Observable} an Observable that emits the items in the specified Iterable and then emits the items
 * emitted by the source Observable.
 */
export declare function startWith<T>(...array: Array<T | Scheduler>): Observable<T>;
