import { Scheduler } from '../Scheduler';
import { Observable } from '../Observable';
/**
 * Returns an Observable that delays the emission of items from the source Observable
 * by a given timeout or until a given Date.
 * @param {number|Date} delay the timeout value or date until which the emission of the source items is delayed.
 * @param {Scheduler} [scheduler] the Scheduler to use for managing the timers that handle the timeout for each item.
 * @returns {Observable} an Observable that delays the emissions of the source Observable by the specified timeout or Date.
 */
export declare function delay<T>(delay: number | Date, scheduler?: Scheduler): Observable<T>;
