export class PromiseWrapper {
    static resolve(obj) { return Promise.resolve(obj); }
    static reject(obj, _) { return Promise.reject(obj); }
    // Note: We can't rename this method into `catch`, as this is not a valid
    // method name in Dart.
    static catchError(promise, onError) {
        return promise.catch(onError);
    }
    static all(promises) {
        if (promises.length == 0)
            return Promise.resolve([]);
        return Promise.all(promises);
    }
    static then(promise, success, rejection) {
        return promise.then(success, rejection);
    }
    static wrap(computation) {
        return new Promise((res, rej) => {
            try {
                res(computation());
            }
            catch (e) {
                rej(e);
            }
        });
    }
    static scheduleMicrotask(computation) {
        PromiseWrapper.then(PromiseWrapper.resolve(null), computation, (_) => { });
    }
    static isPromise(obj) { return obj instanceof Promise; }
    static completer() {
        var resolve;
        var reject;
        var p = new Promise(function (res, rej) {
            resolve = res;
            reject = rej;
        });
        return { promise: p, resolve: resolve, reject: reject };
    }
}
//# sourceMappingURL=data:application/json;base64,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