import { CONST_EXPR } from 'angular2/src/facade/lang';
import { NgControlName } from './directives/ng_control_name';
import { NgFormControl } from './directives/ng_form_control';
import { NgModel } from './directives/ng_model';
import { NgControlGroup } from './directives/ng_control_group';
import { NgFormModel } from './directives/ng_form_model';
import { NgForm } from './directives/ng_form';
import { DefaultValueAccessor } from './directives/default_value_accessor';
import { CheckboxControlValueAccessor } from './directives/checkbox_value_accessor';
import { NumberValueAccessor } from './directives/number_value_accessor';
import { RadioControlValueAccessor } from './directives/radio_control_value_accessor';
import { NgControlStatus } from './directives/ng_control_status';
import { SelectControlValueAccessor, NgSelectOption } from './directives/select_control_value_accessor';
import { RequiredValidator, MinLengthValidator, MaxLengthValidator } from './directives/validators';
export { NgControlName } from './directives/ng_control_name';
export { NgFormControl } from './directives/ng_form_control';
export { NgModel } from './directives/ng_model';
export { NgControlGroup } from './directives/ng_control_group';
export { NgFormModel } from './directives/ng_form_model';
export { NgForm } from './directives/ng_form';
export { DefaultValueAccessor } from './directives/default_value_accessor';
export { CheckboxControlValueAccessor } from './directives/checkbox_value_accessor';
export { RadioControlValueAccessor, RadioButtonState } from './directives/radio_control_value_accessor';
export { NumberValueAccessor } from './directives/number_value_accessor';
export { NgControlStatus } from './directives/ng_control_status';
export { SelectControlValueAccessor, NgSelectOption } from './directives/select_control_value_accessor';
export { RequiredValidator, MinLengthValidator, MaxLengthValidator } from './directives/validators';
export { NgControl } from './directives/ng_control';
/**
 *
 * A list of all the form directives used as part of a `@View` annotation.
 *
 *  This is a shorthand for importing them each individually.
 *
 * ### Example
 *
 * ```typescript
 * @Component({
 *   selector: 'my-app',
 *   directives: [FORM_DIRECTIVES]
 * })
 * class MyApp {}
 * ```
 */
export const FORM_DIRECTIVES = CONST_EXPR([
    NgControlName,
    NgControlGroup,
    NgFormControl,
    NgModel,
    NgFormModel,
    NgForm,
    NgSelectOption,
    DefaultValueAccessor,
    NumberValueAccessor,
    CheckboxControlValueAccessor,
    SelectControlValueAccessor,
    RadioControlValueAccessor,
    NgControlStatus,
    RequiredValidator,
    MinLengthValidator,
    MaxLengthValidator
]);
//# sourceMappingURL=data:application/json;base64,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