#pragma once

#include <Windows.h>
#include <unordered_map>

const static std::unordered_map<std::string, unsigned short> keycodes = {
	{"lmb", VK_LBUTTON},
	{"rmb", VK_RBUTTON},
	{"mmb", VK_MBUTTON},
	{"mb1", VK_XBUTTON1},
	{"mb2", VK_XBUTTON2},
	{"backspace", VK_BACK},
	{"tab", VK_TAB},
	{"enter", VK_RETURN},
	{"lshift", VK_LSHIFT},
	{"rshift", VK_RSHIFT},
	{"lctrl", VK_LCONTROL},
	{"rctrl", VK_RCONTROL},
	{"lalt", VK_LMENU},
	{"ralt", VK_RMENU},
	{"pause", VK_PAUSE},
	{"capslock", VK_CAPITAL},
	{"escape", VK_ESCAPE},
	{"spacebar", VK_SPACE},
	{"pageup", VK_PRIOR},
	{"pagedown", VK_NEXT},
	{"end", VK_END},
	{"home", VK_HOME},
	{"leftarrow", VK_LEFT},
	{"uparrow", VK_UP},
	{"rightarrow", VK_RIGHT},
	{"downarrow", VK_DOWN},
	{"printscreen", VK_SNAPSHOT},
	{"insert", VK_INSERT},
	{"delete", VK_DELETE},
	{"0", 0x30},
	{"1", 0x31},
	{"2", 0x32},
	{"3", 0x33},
	{"4", 0x34},
	{"5", 0x35},
	{"6", 0x36},
	{"7", 0x37},
	{"8", 0x38},
	{"9", 0x39},
	{"a", 0x41},
	{"b", 0x42},
	{"c", 0x43},
	{"d", 0x44},
	{"e", 0x45},
	{"f", 0x46},
	{"g", 0x47},
	{"h", 0x48},
	{"i", 0x49},
	{"j", 0x4a},
	{"k", 0x4b},
	{"l", 0x4c},
	{"m", 0x4d},
	{"n", 0x4e},
	{"o", 0x4f},
	{"p", 0x50},
	{"q", 0x51},
	{"r", 0x52},
	{"s", 0x53},
	{"t", 0x54},
	{"u", 0x55},
	{"v", 0x56},
	{"w", 0x57},
	{"x", 0x58},
	{"y", 0x59},
	{"z", 0x5a},
	{"numpad0", VK_NUMPAD0},
	{"numpad1", VK_NUMPAD1},
	{"numpad2", VK_NUMPAD2},
	{"numpad3", VK_NUMPAD3},
	{"numpad4", VK_NUMPAD4},
	{"numpad5", VK_NUMPAD5},
	{"numpad6", VK_NUMPAD6},
	{"numpad7", VK_NUMPAD7},
	{"numpad8", VK_NUMPAD8},
	{"numpad9", VK_NUMPAD9},
	{"multiply", VK_MULTIPLY},
	{"add", VK_ADD},
	{"separator", VK_SEPARATOR},
	{"subtract", VK_SUBTRACT},
	{"decimal", VK_DECIMAL},
	{"divide", VK_DIVIDE},
	{"f1", VK_F1},
	{"f2", VK_F2},
	{"f3", VK_F3},
	{"f4", VK_F4},
	{"f5", VK_F5},
	{"f6", VK_F6},
	{"f7", VK_F7},
	{"f8", VK_F8},
	{"f9", VK_F9},
	{"f10", VK_F10},
	{"f11", VK_F11},
	{"f12", VK_F12},
	{"numlock", VK_NUMLOCK},
	{"scrolllock", VK_SCROLL}
};

const static std::unordered_map<std::string, unsigned short> controllerKeycodes = {
	{"dpadup", 0x0001},
	{"dpaddown", 0x0002},
	{"dpadleft", 0x0004},
	{"dpadright", 0x0008},
	{"start", 0x0010},
	{"select", 0x0020},
	{"lthumbpress", 0x0040},
	{"rthumbpress", 0x0080},
	{"lshoulder", 0x0100},
	{"rshoulder", 0x0200},
	{"xa", 0x1000},
	{"xb", 0x2000},
	{"xx", 0x4000},
	{"xy", 0x8000}
};