project (Mif)
set (PROJECT ${PROJECT_NAME})
string (TOLOWER "${PROJECT}" PROJECT_LC)

if (NOT MIF_STD_CXX)
    set (MIF_STD_CXX "c++11")
endif(NOT MIF_STD_CXX)

set (CMAKE_MODULE_PATH ${PROJECT_SOURCE_DIR}/MyCMakeScripts)

if (NOT DEFINED THITD_PARTY_OUTPUT_PATH)
    set (THITD_PARTY_OUTPUT_PATH ${CMAKE_SOURCE_DIR}/third_party)
endif()

set (THITD_PARTY_SOURCES_PATH ${CMAKE_SOURCE_DIR}/third_party_sources)
set (EXECUTABLE_OUTPUT_PATH ${CMAKE_SOURCE_DIR}/bin)
set (CMAKE_RUNTIME_OUTPUT_DIRECTORY ${CMAKE_SOURCE_DIR}/bin)
set (CMAKE_LIBRARY_OUTPUT_DIRECTORY ${CMAKE_SOURCE_DIR}/lib)
set (CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${CMAKE_LIBRARY_OUTPUT_DIRECTORY})
set (LIBRARY_OUTPUT_DIRECTORY ${CMAKE_LIBRARY_OUTPUT_DIRECTORY})

set (MIF_SHARED_LIB_SUFFIX "_shared")

if (NOT CMAKE_BUILD_TYPE)
  set (CMAKE_BUILD_TYPE "Release" CACHE INTERNAL "")
endif(NOT CMAKE_BUILD_TYPE)

set (CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fPIC")

set (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -W -Wall -fPIC -std=${MIF_STD_CXX}")
set (CMAKE_CXX_FLAGS_DEBUG "-O0 -g3 -DDEBUG")
set (CMAKE_CXX_FLAGS_RELEASE "-O3 -g0 -DNDEBUG")
set (CMAKE_EXE_LINKER_FLAGS "-static-libgcc -static-libstdc++")
set (CMAKE_SHARED_LINKER_FLAGS "-static-libgcc -static-libstdc++")
set (CMAKE_POSITION_INDEPENDENT_CODE ON)

set(Boost_USE_STATIC_LIBS ON)  
set(Boost_USE_MULTITHREADED ON)