package syntax

var SyntaxTypescript = syntax{
	Extensions: []string{".ts"},
	Patterns: []SyntaxPattern{
		NewSyntaxPattern(`/*`, `*/`, ``, true, StyleComment), // ML comment
		NewSyntaxPattern(`//`, ``, ``, false, StyleComment),  // comment
		NewSyntaxPattern(`"`, `"`, `\`, false, StyleString),  // string
		NewSyntaxPattern("'", "'", `\`, false, StyleString),  // char
	},
	Keywords1: []string{
		"const", "import", "class", "interface", "extends", "implements",
		"package", "enum", "var", "export", "let", "declare", "function",
		"module", "async", "from", "namespace", "type", "await",
	},
	Keywords2: []string{
		"abstract",
		"any",
		"as",
		"boolean",
		"break",
		"byte",
		"case",
		"catch",
		"char",
		"constructor",
		"continue",
		"debugger",
		"default",
		"delete",
		"do",
		"double",
		"else",
		"false",
		"final",
		"finally",
		"float",
		"for",
		"get",
		"goto",
		"if",
		"in",
		"is",
		"instanceof",
		"int",
		"long",
		"native",
		"new",
		"number",
		"null",
		"of",
		"private",
		"protected",
		"public",
		"require",
		"return",
		"set",
		"short",
		"static",
		"super",
		"switch",
		"string",
		"symbol",
		"synchronized",
		"this",
		"throw",
		"throws",
		"transient",
		"true",
		"try",
		"typeof",
		"undefined",
		"void",
		"volatile",
		"while",
		"with",
		"yeld",
	},
	Symbols1: []string{ // ~ assignment
		"++", "+=", "-=", "*=", "/=", "%=",
		"--", "=", "&=", "^=", "|=", "<<=", ">>=", ">>>=",
	},
	Symbols2: []string{ // ~ comparators
		"&&", "||", ">=", "<=", "!=", "==", ">", "<", "===", "!==", "?:",
	},
	Symbols3: []string{ // others
		"+", "-", "*", "/", "%", "|", "&", "^", "<<", ">>", ">>>", "~", "!",
	},
	Separators1: []string{
		"(", ")", "[", "]", "{", "}",
	},
	Separators2: []string{
		",", ".", ";", ":", "=>",
	},
}
