package syntax

var SyntaxSql = syntax{
	Extensions: []string{".sql"},
	Patterns: []SyntaxPattern{
		NewSyntaxPattern(`/*`, `*/`, ``, true, StyleComment),
		NewSyntaxPattern(`#`, ``, ``, false, StyleComment),
		NewSyntaxPattern(`--`, ``, ``, false, StyleComment),
		NewSyntaxPattern(`"`, `"`, `\`, false, StyleString),
		NewSyntaxPattern(`'`, `'`, `\`, false, StyleString),
	},
	Keywords2: []string{
		"ADD",
		"add",
		"EXCEPT",
		"except",
		"PERCENT",
		"percent",
		"ALL",
		"all",
		"EXEC",
		"exec",
		"PLAN",
		"plan",
		"ALTER",
		"alter",
		"EXECUTE",
		"execute",
		"PRECISION",
		"precision",
		"AND",
		"and",
		"EXISTS",
		"exists",
		"PRIMARY",
		"primary",
		"ANY",
		"any",
		"EXIT",
		"exit",
		"PRINT",
		"print",
		"AS",
		"as",
		"FETCH",
		"fetch",
		"PROC",
		"proc",
		"ASC",
		"asc",
		"FILE",
		"file",
		"PROCEDURE",
		"procedure",
		"AUTHORIZATION",
		"authorization",
		"FILLFACTOR",
		"fillfactor",
		"PUBLIC",
		"public",
		"BACKUP",
		"backup",
		"FOR",
		"for",
		"RAISERROR",
		"raiserror",
		"BEGIN",
		"begin",
		"FOREIGN",
		"foreign",
		"READ",
		"read",
		"BETWEEN",
		"between",
		"FREETEXT",
		"freetext",
		"READTEXT",
		"readtext",
		"BREAK",
		"break",
		"FREETEXTTABLE",
		"freetexttable",
		"RECONFIGURE",
		"reconfigure",
		"BROWSE",
		"browse",
		"FROM",
		"from",
		"REFERENCES",
		"references",
		"BULK",
		"bulk",
		"FULL",
		"full",
		"REPLICATION",
		"replication",
		"BY",
		"by",
		"FUNCTION",
		"function",
		"RESTORE",
		"restore",
		"CASCADE",
		"cascade",
		"GOTO",
		"goto",
		"RESTRICT",
		"restrict",
		"CASE",
		"case",
		"GRANT",
		"grant",
		"RETURN",
		"return",
		"CHECK",
		"check",
		"GROUP",
		"group",
		"REVOKE",
		"revoke",
		"CHECKPOINT",
		"checkpoint",
		"HAVING",
		"having",
		"RIGHT",
		"right",
		"CLOSE",
		"close",
		"HOLDLOCK",
		"holdlock",
		"ROLLBACK",
		"rollback",
		"CLUSTERED",
		"clustered",
		"IDENTITY",
		"identity",
		"ROWCOUNT",
		"rowcount",
		"COALESCE",
		"coalesce",
		"IDENTITY_INSERT",
		"identity_insert",
		"ROWGUIDCOL",
		"rowguidcol",
		"COLLATE",
		"collate",
		"IDENTITYCOL",
		"identitycol",
		"RULE",
		"rule",
		"COLUMN",
		"column",
		"IF",
		"if",
		"SAVE",
		"save",
		"COMMIT",
		"commit",
		"IN",
		"in",
		"SCHEMA",
		"schema",
		"COMPUTE",
		"compute",
		"INDEX",
		"index",
		"SELECT",
		"select",
		"CONSTRAINT",
		"constraint",
		"INNER",
		"inner",
		"SESSION_USER",
		"session_user",
		"CONTAINS",
		"contains",
		"INSERT",
		"insert",
		"SET",
		"set",
		"CONTAINSTABLE",
		"containstable",
		"INTERSECT",
		"intersect",
		"SETUSER",
		"setuser",
		"CONTINUE",
		"continue",
		"INTO",
		"into",
		"SHUTDOWN",
		"shutdown",
		"CONVERT",
		"convert",
		"IS",
		"is",
		"SOME",
		"some",
		"CREATE",
		"create",
		"JOIN",
		"join",
		"STATISTICS",
		"statistics",
		"CROSS",
		"cross",
		"KEY",
		"key",
		"SYSTEM_USER",
		"system_user",
		"CURRENT",
		"current",
		"KILL",
		"kill",
		"TABLE",
		"table",
		"CURRENT_DATE",
		"current_date",
		"LEFT",
		"left",
		"TEXTSIZE",
		"textsize",
		"CURRENT_TIME",
		"current_time",
		"LIKE",
		"like",
		"THEN",
		"then",
		"CURRENT_TIMESTAMP",
		"current_timestamp",
		"LINENO",
		"lineno",
		"TO",
		"to",
		"CURRENT_USER",
		"current_user",
		"LOAD",
		"load",
		"TOP",
		"top",
		"CURSOR",
		"cursor",
		"NATIONAL",
		"national",
		"TRAN",
		"tran",
		"DATABASE",
		"database",
		"NOCHECK",
		"nocheck",
		"TRANSACTION",
		"transaction",
		"DBCC",
		"dbcc",
		"NONCLUSTERED",
		"nonclustered",
		"TRIGGER",
		"trigger",
		"DEALLOCATE",
		"deallocate",
		"NOT",
		"not",
		"TRUNCATE",
		"truncate",
		"DECLARE",
		"declare",
		"NULL",
		"null",
		"TSEQUAL",
		"tsequal",
		"DEFAULT",
		"default",
		"NULLIF",
		"nullif",
		"UNION",
		"union",
		"DELETE",
		"delete",
		"OF",
		"of",
		"UNIQUE",
		"unique",
		"DENY",
		"deny",
		"OFF",
		"off",
		"UPDATE",
		"update",
		"DESC",
		"desc",
		"OFFSETS",
		"offsets",
		"UPDATETEXT",
		"updatetext",
		"DISK",
		"disk",
		"ON",
		"on",
		"USE",
		"use",
		"DISTINCT",
		"distinct",
		"OPEN",
		"open",
		"USER",
		"user",
		"DISTRIBUTED",
		"distributed",
		"OPENDATASOURCE",
		"opendatasource",
		"VALUES",
		"values",
		"DOUBLE",
		"double",
		"OPENQUERY",
		"openquery",
		"VARYING",
		"varying",
		"DROP",
		"drop",
		"OPENROWSET",
		"openrowset",
		"VIEW",
		"view",
		"DUMMY",
		"dummy",
		"OPENXML",
		"openxml",
		"WAITFOR",
		"waitfor",
		"DUMP",
		"dump",
		"OPTION",
		"option",
		"WHEN",
		"when",
		"ELSE",
		"else",
		"OR",
		"or",
		"WHERE",
		"where",
		"END",
		"end",
		"ORDER",
		"order",
		"WHILE",
		"while",
		"ERRLVL",
		"errlvl",
		"OUTER",
		"outer",
		"WITH",
		"with",
		"ESCAPE",
		"escape",
		"OVER",
		"over",
		"WRITETEXT",
		"writetext",
	},
	Symbols1: []string{
		"+", "-", "*", "/", "%",
	},
	Symbols2: []string{
		"=", "!=", "<>", ">", "<", ">=", "<=", "!<", "!>",
	},
	Separators2: []string{
		"(", ")", "[", "]", "{", "}",
	},
	Separators1: []string{
		".", ",", ":", ";",
	},
}
