package syntax

var SyntaxPhp = syntax{
	Extensions: []string{".php", ".php4", ".php5", ".PHP", ".lame"},
	Patterns: []SyntaxPattern{
		NewSyntaxPattern(`/*`, `*/`, ``, true, StyleComment), // ML comment
		NewSyntaxPattern(`#!`, ``, ``, false, StyleKw3),
		NewSyntaxPattern(`//`, ``, ``, false, StyleComment), // comment
		NewSyntaxPattern(`#`, ``, ``, false, StyleComment),  // comment
		NewSyntaxPattern("'", "'", ``, false, StyleString),  // string
		NewSyntaxPattern(`"`, `"`, `\`, false, StyleString), // string
	},
	Keywords1: []string{
		"__halt_compiler()",
		"__HALT_COMPILER()",
		"abstract",
		"ABSTRACT",
		"and",
		"AND",
		"array()",
		"ARRAY()",
		"as",
		"AS",
		"break",
		"BREAK",
		"callable",
		"CALLABLE",
		"case",
		"CASE",
		"catch",
		"CATCH",
		"class",
		"CLASS",
		"clone",
		"CLONE",
		"const",
		"CONST",
		"continue",
		"CONTINUE",
		"declare",
		"DECLARE",
		"default",
		"DEFAULT",
		"die()",
		"DIE()",
		"do",
		"DO",
		"echo",
		"ECHO",
		"else",
		"ELSE",
		"elseif",
		"ELSEIF",
		"empty()",
		"EMPTY()",
		"enddeclare",
		"ENDDECLARE",
		"endfor",
		"ENDFOR",
		"endforeach",
		"ENDFOREACH",
		"endif",
		"ENDIF",
		"endswitch",
		"ENDSWITCH",
		"endwhile",
		"ENDWHILE",
		"eval()",
		"EVAL()",
		"exit()",
		"EXIT()",
		"extends",
		"EXTENDS",
		"final",
		"FINAL",
		"finally",
		"FINALLY",
		"for",
		"FOR",
		"foreach",
		"FOREACH",
		"function",
		"FUNCTION",
		"global",
		"GLOBAL",
		"goto",
		"GOTO",
		"if",
		"IF",
		"implements",
		"IMPLEMENTS",
		"include",
		"INCLUDE",
		"include_once",
		"INCLUDE_ONCE",
		"instanceof",
		"INSTANCEOF",
		"insteadof",
		"INSTEADOF",
		"interface",
		"INTERFACE",
		"isset()",
		"ISSET()",
		"list()",
		"LIST()",
		"new",
		"NEW",
		"or",
		"OR",
		"print",
		"PRINT",
		"private",
		"PRIVATE",
		"protected",
		"PROTECTED",
		"public",
		"PUBLIC",
		"require",
		"REQUIRE",
		"require_once",
		"REQUIRE_ONCE",
		"return",
		"RETURN",
		"static",
		"STATIC",
		"switch",
		"SWITCH",
		"throw",
		"THROW",
		"trait",
		"TRAIT",
		"try",
		"TRY",
		"unset()",
		"UNSET()",
		"use",
		"USE",
		"var",
		"VAR",
		"while",
		"WHILE",
		"xor",
		"XOR",
		"yield",
		"YIELD",
	},
	Keywords2: []string{
		"__CLASS__",
		"__DIR__",
		"__FILE__",
		"__FUNCTION__",
		"__LINE__",
		"__METHOD__",
		"__NAMESPACE__",
		"__TRAIT__",
	},
	Symbols1: []string{ // ~ assignment
		"=", "**=", "+=", "-=", "*=", "/=", "%=", ".=",
	},
	Symbols2: []string{ // ~ comparators
		"<=>", ">=", "<=", "!=", "==", ">", "<", "===", ".eql?", ".equal?",
		"||", "&&", "!", "defined?",
	},
	Symbols3: []string{ // others
		"+", "-", "*", "/", "%", "|", "&", "^", "<<", ">>", "~", "**",
		"..", "...", "$",
	},
	Separators1: []string{
		"(", ")", "[", "]", "{", "}", "<", ">", "</", "/>",
	},
	Separators2: []string{
		",", ".", ";", ":", "::", "->",
	},
	Separators3: []string{
		"<?php", "<?PHP", "?>",
	},
}
