package syntax

var SyntaxActionScript = syntax{
	Extensions: []string{".as"},
	Patterns: []SyntaxPattern{
		NewSyntaxPattern(`/*`, `*/`, ``, true, StyleComment),
		NewSyntaxPattern(`//`, ``, ``, false, StyleComment),
		NewSyntaxPattern(`"`, `"`, `\`, false, StyleString),
	},
	Keywords1: []string{
		"as",
		"break",
		"case",
		"catch",
		"const",
		"continue",
		"default",
		"do",
		"dynamic",
		"each",
		"else",
		"extends",
		"false",
		"final",
		"finally",
		"for",
		"get",
		"if",
		"in",
		"is",
		"implements",
		"internal",
		"label",
		"namespace",
		"native",
		"new",
		"null",
		"override",
		"private",
		"protected",
		"public",
		"return",
		"set",
		"static",
		"super",
		"switch",
		"this",
		"throw",
		"true",
		"try",
		"with",
		"while",
	},
	Keywords2: []string{
		"import", "package", "include", "interface", "class", "function", "var",
	},
	Symbols1: []string{ // ~ assignment
		"=", "+=", "-=", "*=", "/=", "%=", "&=", "|=", "^=", ">>=", "<<=",
		">>>=", "&&=", "||=",
	},
	Symbols2: []string{ // ~ comparators
		">=", "<=", "!=", "==", ">", "<", "===", "!==", "&&", "||", "!", "?=",
	},
	Symbols3: []string{ // others
		"+", "-", "*", "/", "%", "++", "--", "&", "|", "~", "^", ">>", "<<",
		">>>",
	},
	Separators1: []string{
		"(", ")", "[", "]", "{", "}",
	},
	Separators2: []string{
		",", ".", ";", ":", "::",
	},
}
