---
title: "Practical Vim"
date: 2014-11-13 22:11
collection: "编辑器"
tag: vim, book
---

[TOC]

## 第一章 .(dot)命令 ##

> `.` 命令可以重复上次的修改

Vim把进入插入模式到退出形成一次修改, `i{insert something}<Esc>`, 在插入模式中移动光标会重置修改状态

`>G` 增加从当前行到文档末尾的缩进层级

`A` 在当前行的结尾添加内容(等价`$a`), 类似还有:

* `C` = `c$`
* `s` = `cl`
* `S` = `^c`
* `I` = `^i` 

查找:

* `f{char}` 行内查找下一处指定字符出现的位置, 使用`;` 重复上次查找, 使用`,`回退
* `F{char}` 行内查找上一个指定字符
* `/{pattern}` 和 `?{pattern}` 分别是文档中查找下/上一处匹配, 重复是`n`, 回退是`N`

## 第二章 普通模式(Normal Mode) ##

> 如果在插入模式使用了上下左右光标键，会产生一个新的撤销块 (P16)

> 构造一个可重复的撤销块 (配合 点`.`操作符使用)

这里要注意什么是`一次修改`. `u`会撤销最后一次修改.

<http://vimgolf.com/> 尽量用最少的按键次数实现一个操作, 一个有趣的网站

`db`反向删除, 从光标开始位置到单词开头的内容(不包括光标下的字符)
`dw`正向删除, 从光标开始位置到下一个单词前(包括光标下的字符)
`daw` 反向删除, 从光标位置开始到前一个单词后(包括光标下的字符)

简单的算数运算:

> `<C-a>` 和 `<C-x>` 会把当前光标之上或之后的数值加1/减1
> `count<C-a>` 会把数值加上 [count]

这个依然可以配合点操作符

`cW` 从当前光标删除一个单词.

> 能够重复，就别用次数

之前的如`dw`, 都可以配合上次数, 如`2dw`, `d2w`

`操作符 + 动作命令 = 操作`

如`{d:操作符}{w:动作}`删除单词. "w" 是词移动命令。实际上，"d" 命令后面可以跟任何 "动作" (motion) 命令，它会删除从当前位置到光标移动到的目标位置的全部内容. [refer](http://vimcdoc.sourceforge.net/doc/usr_04.html#04.1)

常用操作符:

* `c`: 修改
* `d`: 删除
* `y`: 复制到寄存器
* `g~`: 反转大小写
* `gu`: 转换为小写
* `gU`: 转换为大写
* `>`: 增加缩进
* `<`: 减小缩进
* `=`: 自动缩进

当操作符连续调用两次, 会作用于当前行. 如 `dd`, `>>`, `gUgU`或简写`gUU`

## 第三章 插入模式(Insert Mode) ##

在插入模式中更正错误，如果出错的位置在单词开头，删除整个单词再重新输入比退格键要快.

* `<C-h>` 删除前一个字符(类似退格键)
* `<C-w>` 删除前一个单词
* `<C-u>` 删至行首

* `<C-[>` 和`<Esc>` 类似，也是切换到普通模式
* `<C-o>` 切换到 `插入-普通模式`, 是普通模式的一个特例, 进入此模式，执行一个普通模式命令后，会自动切换回插入模式.

`zz` 命令可以重绘窗口，使当前行在窗口居中.

使用`<C-o>`配合`zz`(即`<C-o>zz`)可以方便的在插入模式写代码时，让当前行从末尾移到屏幕中央.

`K` 查看光标下单词的手册页
`J` 把当前行和下一行连接在一起

@todo 寄存器 tip 15, P 28

在插入模式中, 使用`<C-r>=`可以使用寄存器做运算.

	<i><C-r>=(40+60)*5 + 500/10<CR>

`C-v{code}`, 其中{code}是要插入的字符编码

	# 输入A
	<C-v>065

	# 输入一个unicode,
	# :h i_CTRL-V _digit
	<C-v>u00bf

光标移到字符上，使用`ga`可以查看它的编码.

`<C-k>{char1}{char2}` 二合字母(digraph)可以打出一些特殊字符

	# 字符 «
	<C-k><<

@todo tip 19 P33, 虚拟替换模式

## 第四章 可视模式(Virtual Mode) ##

可视模式有三种:

* 字符文本
* 行文本
* 块文本

`viw`高亮选择当前光标下的单词, 然后使用`c`修改所选内容, 这样会删掉单词并进入插入模式.

* `v`: 激活面向字符的可视模式
* `V`: 面向行
* `C-v`: 面向列块
* `gv`: 重选上次的高亮选区
* `o`: 切换高亮选取的活动端

高亮选取的范围由两个端点界定, 其中一个固定, 一个岁光标移动. `o`可修改固定端点. (P37)

在可视模式下, dot(`.`)操作符一般对行操作有用.

可视模式一般使用一次性的操作, 如果是重复操作, 最好使用操作符命令.

可视模式配合一些动作命令也很强大:

* `Vr-`: 将一行全部替换为减号
* `<C-v>jje` 和 `<C-v>jj$`: P44 和 P45的例子

## 第五章 命令行模式 ##

按`:`进入命令行模式, 在命令行模式下执行的命令又称`Ex命令`. (源至ex行编辑器, vi先祖)

`:h ex-cmd-index` 查看完成的Ex命令列表

* `:[range]delete [x]`: 删除指定范围的行 [到寄存器x中]
* `:[range]yank [x]`: 复制指定范围的行 [到寄存器x中]
* `:[range]copy {address}`: 把指定范围内的行拷贝到 {address} 所指定的行之下
* `:[range]move {address}`: 把指定范围内的行移动到 {address} 所指定的行之下
* `:[range]normal {commands}`: 对指定范围内的没一行执行普通模式命令 {commands}

很多Ex命令可以用`[range]`指定要操作的范围.可以在某一范围内的所有行执行操作.

`:print` 命令(简写`:p`)用于在命令行显示指定行的内容

比如`:2p`移动到第二行并显示内容; `:2,5p`显示第2~5行的内容; `:.,$p`显示当前行到最后一行的内容; `%p`显示所有内容

使用`VG`高亮选取后按`:`进入命令行模式, 会自动填充`:'<,'>`, 这个也是Ex命令

用模式指定范围, 用偏移对地址进行修正. TODO

`[range]`定义的范围语法可以是行号、位置标记、查找模式、偏移:

* `1`: 文件第一行
* `0`: 虚拟行, 文件第一行上方
* `$`: 文件最后一行
* `.`: 光标所在行
* `'m`: 包含位置标记m的行
* `'<`: 高亮选取的起始行
* `'>`: 高亮选取的结束行
* `%`: 整个文件 (`:1,$`的简写)

复制, 使用`:copy` 或者 `:co` 或 `:t`. 如

* `:6t.` 将第6行复制到当前行
* `:t6` 将当前行复制到第6行下
* `:t.` 同`yyp`
* `:t$` 将当前行复制到文件末尾
* `:'<,'>t0` 将高亮选中的行复制到文件开头

快速跳会原来的位置 `C-o`

> 普通模式命令适合在本地操作; Ex命令适合远距离操作

`:normal` 配合 `.` 命令, 可以在多行完成相同的内容, 如:

`A;<ESC>` -> `jVG` -> `:'<.'>normal .` 从当前行到文件末尾, 每行最后加一个分号

更简单的方式: `.,$normal A;`

`:%normal i//`所有行加上注释

`.`命令无法重复由Vim命令行中做出的修改, 改为使用`@:`重复上次的Ex命令. 然后可以使用`@@`来重复操作

在Ex命令自动补全时, 键入`<C-d>`会显示可用的补全列表, 如:

	:col<C-d>
	colder       colorscheme

对于命令历史, `q:`打开Ex命令的历史记录窗口; `q\`打开查找命令的历史记录窗口

在Ex命令窗口输入`:!{command}` 可以运行一次shell命令. 执行`:shell`可以启动一个交互的shell会话.

## 第六章 管理多个文件 ##

> 我们所编辑的只是文件在内存中的映像, 也就是Vim的"缓冲区"

如果vim同时打开多个文件, 会把这些文件都加到缓存区, 但只有一个是激活的.

使用`:ls`可以查看缓冲区列表:

	:ls
	  1 %a   "a.txt"                        line 1
	  2      "b.txt"                        line 0

使用`:bnext`可以切换到下一个缓冲区:

	:ls
	  1 #    "a.txt"                        line 1
	  2 %a   "b.txt"                        line 1

其中`%`表示当前窗口中可见的缓冲区, `a`表示active, `#`表示轮转文件, 也就是切换过来的前一个缓冲区. `<C-^>`可以在两者间快速切换.

* `:bprev`: 切换到前一个缓冲区
* `:bnext`: 切换到下一个缓冲区
* `:bfirst`: 切换到第一个缓冲区
* `:blast`: 切换到最后一个缓冲区
* `:b N`: 切换到第N个缓冲区

这里`b`表示`buffer`简写

如果缓冲区有修改, 则`:ls`会显示`+`:

	:ls
	  1 #    "a.txt"                        line 1
	  2 %a + "b.txt"                        line 18

此时如果要切换缓冲区, 需要加`!`强制执行, 如`:bnext!`, 此时当前缓存冲会被标记为隐藏缓冲区(`h`):

	:ls
	  1 %a   "a.txt"                        line 1
	  2 #h + "b.txt"                        line 18

`:args`类似`:ls`, 不过显示的比较简陋.

分割窗口:

* `<C-w>s`: 水平分割
* `<C-w>v`: 垂直分割

排列窗口:

* `<C-w>=` 等高、等宽
* `<C-w>_` 最大化活动窗口高度
* `<C-w>|` 最大化活动窗口宽度
