---
title: "arp"
date: 2013-09-06 10:24
collection: "网络相关"
---


# arp #

Address Resolution Protocol

## arp 原理 ##

> 以主机A（192.168.38.10）向主机B（192.168.38.11）发送数据为例。当发送数据时，主机A会在自己的ARP缓存表中寻找是否有目标IP地址。如果找到了，也就知道了目标MAC地址为（00-BB-00-62-C2-02），直接把目标MAC地址写入帧里面发送就可以了；如果在ARP缓存表中没有找到相对应的IP地址，主机A就会在网络上发送一个广播（ARP request），目标MAC地址是“FF.FF.FF.FF.FF.FF”，这表示向同一网段内的所有主机发出这样的询 问：“192.168.38.11的MAC地址是什么？”网络上其他主机并不响应ARP询问，只有主机B接收到这个帧时，才向主机A做出这样的回应（ARP response）：“192.168.38.11的MAC地址是（00-BB-00-62-C2-02）”。 这样，主机A就知道了主机B的MAC地址，它就可以向主机B发送信息了。同时它还更新了自己的ARP缓存表，下次再向主机B发送信息时，直接从ARP缓存表里查找就可以了。ARP缓存表采用了老化机制，在一段时间内如果表中的某一行没有使用，就会被删除，这样可以大大减少ARP缓存表的长度，加快查询速度。

摘自[维基百科](http://zh.wikipedia.org/wiki/%E5%9C%B0%E5%9D%80%E8%A7%A3%E6%9E%90%E5%8D%8F%E8%AE%AE)

## 清空所有arp缓存 ##

	arp -n | awk '/^[1-9]/{print "arp -d " $1}' | sudo sh -x

或

	for a in `arp | grep "eth1" | cut -d " " -f1`; do arp -d $a; done



## arp 缓存问题 ##

最近迁移服务器A时, 网络等都未做改动, 发现从外面的机器B可以ping通内网(走vpn), 但是ping不通外网, 而服务器A可以ping通外面, 再次从B ping A, 则可以ping通. 这就是 arp缓存 的问题, 上面的 **arp 原理** 算是对这个问题作了讲解. 当从 A ping 外面时, 会更新路由器上的arp缓存, 否则通过 B ping A 时, 经过路由器时只能找到 原来A的 mac 地址, 而这台机器已经没用了.
