---
title: "Redis"
date: 2017-04-16 21:25
logs: "新增"
---

[TOC]

[Redis](https://redis.io/) 是一个基于 key-value 的 NoSQL 数据库。学习成本也比较低。

以前都是在运维层面关注它比较多，最近有一个项目选择用它，所以快速扫了一遍。


大概方向就是：

* 基本配置
* 基本的命令。如 `SELECT`，`KEYS`，`EXISTS`，`DEL`，`TYPE` 等
* 基本类型。了解每种的基本命令、使用方法和使用场景
	- 字符串
	- 哈希
	- 列表
	- 集合
	- 有序集合
* 高级
	- 事务 `MULTI`、`EXEC`
	- 排序 `SORT`、`SORT .. BY ..`
	- 过期时间 `EXPIRE`、`TTL`、`PERSIST`，以及知道什么操作会将失效时间变为持久
* 持久化，包括 RDB 和 AOF
* 主从配置 以及 哨兵
* 管理，如 `SLOWLOG`，`MONITOR`
* 安全，配置密码


一些需要关注的点：

* 字符串类型是其它几种基本类型的根本，其它类型的字段值只能是字符串
* 如 哈希、列表、集合类型的 key 个数最多 `2^32-1` 个
* 安全性要注意，默认是无密码，监听环回地址。这块的安全性交由使用者决定，操作如果是监听非环回，尤其外网，一定要做好相应的安全报障，如 iptables 限制访问 ip，配置 `requirepass` 等
* 如果配置了哨兵，注意 master 选举切换时，是会自动修改原 master 的配置的，增加 `slaveof`
* 针对事务，因为是 `MULTI` 和 `EXEC` 之间的一串命令最后一起执行，所以针对期间的语法错误，是会在开始就捕获，相当于未执行；但是运行时错误，因为顺序执行下去，遇到错误时当前这条命令不生效，后续继续执行。


资源：

- 《[Redis入门指南](https://book.douban.com/subject/26419240/)》适合用来快速入门
- 命令文档 [官网](https://redis.io/commands) | [中文](http://redisdoc.com/) 入门后遇到就直接查文档
