import { siteConfig } from '@/lib/config'

/**
 * 网站版权日期
 * 示例： 2021-2024
 * @returns
 */
export default function CopyRightDate() {
  const d = new Date()
  const currentYear = d.getFullYear()
  const since = siteConfig('SINCE')
  const copyrightDate =
    parseInt(since) < currentYear ? since + '-' + currentYear : currentYear

  return (
    <span className='whitespace-nowrap flex items-center gap-x-1'>
      <i className='fas fa-copyright' />
      <span>{copyrightDate}</span>
      <a
        href={siteConfig('LINK')}
        className='underline font-semibold dark:text-gray-300 '>
        {siteConfig('AUTHOR')}
      </a>
    </span>
  )
}
