# awesome-ChatGPT-repositories

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Hugging Face Spaces](https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue)](https://huggingface.co/spaces/taishi-i/awesome-ChatGPT-repositories-search)
[![License: CC0-1.0](https://img.shields.io/badge/License-CC0_1.0-lightgrey.svg)](http://creativecommons.org/publicdomain/zero/1.0/)
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

關於 [ChatGPT](https://openai.com/blog/chatgpt) 的公開 GitHub 資料庫的資源.
搜尋這些資料庫的[工具](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/contributing.md)可在 Hugging Face Spaces 上找到.

歡迎您的貢獻！請在貢獻之前閱讀[指南](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/contributing.md).

[English](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.en.md) | [日本語 (Japanese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.ja.md) | [繁體中文 (Chinese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.zh-hant.md) | [简体中文 (Chinese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.zh-hans.md)


## The latest additions 🎉

**Prompts**
 * [archgw](https://github.com/katanemo/archgw) - Arch是代理人的智能閘道。使用（快速）LLM進行工程設計，以安全處理、豐富的可觀察性和無縫集成提示與您的API - 所有這些都在業務邏輯之外。由Envoy代理的核心貢獻者在Envoy上構建。
 * [openlit](https://github.com/openlit/openlit) - 開源平台為AI工程：OpenTelemetry-native LLM可觀測性，GPU監控，防護欄，評估，提示管理，金庫，遊樂場。🚀💻與40多個LLM提供商，VectorDBs，代理框架和GPU集成。


**Browser-extensions**
 * [aura-voice](https://github.com/ntegrals/aura-voice) - Aura就像Siri一樣，但在您的瀏覽器中。一個針對低延遲響應進行優化的人工智能語音助手。


**Openai**
 * [coai](https://github.com/coaidev/coai) - 🚀 下一代 AI 一站式國際化解決方案。🚀 支持 OpenAI，Midjourney，Claude，訊飛星火，穩定擴散，DALL·E，ChatGLM，通義千問，騰訊混元，360 智腦，百川 AI，火山方舟，新必應，Gemini，Moonshot 等模型，支持對話分享，自定義預設，雲端同步，模型市場，支持彈性計費和訂閱計劃模式，支持圖片解析，支持聯網搜索，支持模型。
 * [self-operating-computer](https://github.com/othersideai/self-operating-computer) - 一個能夠讓多模型操作電腦的框架。
 * [blinko](https://github.com/blinko-space/blinko) - 一個開源、自主託管的個人筆記工具，注重隱私，使用TypeScript構建。


_Updated on November 28, 2024_ (A total of 1892 repositories listed.)

## Table of contents

 * [Awesome-lists](#awesome-lists)
 * [Prompts](#prompts)
 * [Chatbots](#chatbots)
 * [Browser-extensions](#browser-extensions)
 * [CLIs](#clis)
 * [Reimplementations](#reimplementations)
 * [Tutorials](#tutorials)
 * [NLP](#nlp)
 * [Langchain](#langchain)
 * [Unity](#unity)
 * [Openai](#openai)
 * [Others](#others)

## Awesome-lists

 * [awesome-chatgpt-api](https://github.com/reorx/awesome-chatgpt-api) - 經過精心挑選的應用程式和工具清單，不僅使用新的ChatGPT API，還允許用戶配置自己的API密鑰，實現自由和按需使用自己的配額。
 * [awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) - 這個存儲庫包括了 ChatGPT 提示的策略，以更好地使用 ChatGPT。
 * [awesome-chatgpt](https://github.com/humanloop/awesome-chatgpt) - ChatGPT和GPT-3的精選工具、演示和文檔列表
 * [awesome-totally-open-chatgpt](https://github.com/nichtdax/awesome-totally-open-chatgpt) - 一份完全開放的ChatGPT替代方案清單
 * [awesome-chatgpt-prompts-zh](https://github.com/plexpt/awesome-chatgpt-prompts-zh) - ChatGPT 中文調教指南。各種場景使用指南。學習怎麼讓它聽你的話。
 * [Awesome-ChatGPT](https://github.com/dalinvip/awesome-chatgpt) - ChatGPT資料匯總學習，持續更新......
 * [awesome-compbio-chatgpt](https://github.com/csbl-br/awesome-compbio-chatgpt) - 一個由社區共同維護的ChatGPT和其他計算生物學LLMs應用程式的絕佳存儲庫。
 * [awesome-chatgpt](https://github.com/openmindclub/awesome-chatgpt) - ⚡ 關於ChatGPT的一切
 * [awesome-chatgpt](https://github.com/saharmor/awesome-chatgpt) - 精選的ChatGPT演示、工具、文章等等 ✨
 * [awesome-chatgpt-zh](https://github.com/yzfly/awesome-chatgpt-zh) - ChatGPT 中文指南，ChatGPT 中文調教指南，指令指南，精選資源清單，更好的使用 ChatGPT 讓你的生產力 up up up！
 * [awesome-chatgpt](https://github.com/eon01/awesome-chatgpt) - 🧠 精選的 ChatGPT 資源清單，包括庫、SDK、API 等等。🌟 請考慮給這個項目一個星星的支持。
 * [awesome-gpt4](https://github.com/taranjeet/awesome-gpt4) - GPT-4 的優秀資源、應用案例和演示的精選清單
 * [awesome-gpt-security](https://github.com/cckuailong/awesome-gpt-security) - 一個由LLM或GPT製作的精選安全工具、實驗案例或其他有趣的事物的清單。
 * [Awesome-GPT4-Prompts](https://github.com/ora-sh/awesome-gpt4-prompts) - 一系列令人驚嘆的GPT4提示集合
 * [awesome-chatgpt](https://github.com/sindresorhus/awesome-chatgpt) - 🤖 ChatGPT 的精彩列表 — 由 OpenAI 開發的人工智慧聊天機器人
 * [awesome-free-chatgpt](https://github.com/lilittlecat/awesome-free-chatgpt) - 🆓免費的 ChatGPT 鏡像網站列表，持續更新。
 * [awesome-gpt-prompt-engineering](https://github.com/snwfdhmp/awesome-gpt-prompt-engineering) - 一個經過精心挑選的資源、工具和其他閃亮物品的清單，適用於GPT提示工程。
 * [awesome-chatgpt-prompts-cybersecurity](https://github.com/sechelper/awesome-chatgpt-prompts-cybersecurity) - 網絡安全chatgpt指令集，訓練chatgpt成為一名網絡安全專家。
 * [awesome-ai](https://github.com/lencx/awesome-ai) - 🤖 神奇人工智慧
 * [awesome-chatgpt-code-interpreter-experiments](https://github.com/skalskip/awesome-chatgpt-code-interpreter-experiments) - 使用ChatGPT + Code Interpreter組合的超棒功能🔥
 * [awesome-ai](https://github.com/520hacker/awesome-ai) - 對開源AI轉發套殼應用生態進行研究，收集開源AI轉發套殼應用，並進行對比。ChatGPT，OPENAI.AZURE，BAIDU，XUNFEI
 * [Awesome-ChatGPT-AI-ZH](https://github.com/changeyu0229/awesome-chatgpt-ai-zh) - 全網曝光超1000萬的「AI 知識庫」正式移步Github開源，永久免費更新，提供ChatGPT，Midjourney等使用教程
 * [Awesome-LLM-Eval](https://github.com/onejune2018/awesome-llm-eval) - 超棒-LLM-Eval：一個精選的工具、演示、論文、文件列表，用於評估大型語言模型，如ChatGPT、LLaMA、GLM。
 * [awesome-chatgpt-dataset](https://github.com/voidful/awesome-chatgpt-dataset) - 解鎖 LLM 的力量：探索這些數據集，訓練您自己的 ChatGPT！
 * [awesome-gpt](https://github.com/formulahendry/awesome-gpt) - 一個精心挑選的與GPT、ChatGPT、OpenAI、LLM等相關的令人驚嘆的項目和資源清單。
 * [awesome-instruction-dataset](https://github.com/yaodongc/awesome-instruction-dataset) - 一個開源數據集的收藏，用於訓練指令遵從的LLMs（ChatGPT，LLaMA，Alpaca）。
 * [awesome-chatgpt](https://github.com/uhub/awesome-chatgpt) - 一個精心挑選的令人驚艷的ChatGPT相關項目清單。
 * [Awesome-Prompt-Engineering](https://github.com/promptslab/awesome-prompt-engineering) - 這個儲存庫包含了一些手動精選的資源，主要關注於生成式預訓練轉換器（GPT）、ChatGPT、PaLM等方面的提示工程。
 * [awesome-generative-ai](https://github.com/filipecalegario/awesome-generative-ai) - 一個精選的生成式人工智能工具、作品、模型和參考資料清單
 * [awesome-open-gpt](https://github.com/ewingyangs/awesome-open-gpt) - GPT相關開源項目合集🚀、精選🔥🔥
 * [Awesome-AITools](https://github.com/ikaijua/awesome-aitools) - 收藏AI相關的實用工具，歡迎提交issues或者pull requests
 * [Awesome-GPTs](https://github.com/ai-boost/awesome-gpts) - 精心挑選的超棒GPT清單👍。
 * [awesome-segment-anything](https://github.com/hedlen/awesome-segment-anything) - 追蹤並收集與分割任何相關的文件/專案/其他內容。
 * [Awesome-AIGC-Tutorials](https://github.com/luban-agi/awesome-aigc-tutorials) - 精心挑選的大型語言模型、人工智慧繪畫等教學和資源。
 * [awesome-gpts](https://github.com/taranjeet/awesome-gpts) - 由社群創建的所有GPT的收藏
 * [prompt-in-context-learning](https://github.com/egoalpha/prompt-in-context-learning) - 出色的資源，用於上下文學習和提示工程：掌握像ChatGPT、GPT-3和FlanT5這樣的LLM的最新和尖端更新。
 * [Awesome-GPT-Store](https://github.com/anil-matcha/awesome-gpt-store) - 自訂GPT商店 - 一個收集了公開可用的主要GPT的集合
 * [awesome-chatgpt](https://github.com/awesome-chatgpt/awesome-chatgpt) - 🏆 一份關於ChatGPT最佳資源、工具、應用和用法的精彩清單
 * [BlackFriday-GPTs-Prompts](https://github.com/friuns2/blackfriday-gpts-prompts) - 免費的GPT列表，不需要Plus訂閱
 * [best-of-ml-python](https://github.com/ml-tooling/best-of-ml-python) - 🏆 一個排名的優秀機器學習Python函式庫清單。每週更新。
 * [awesome-openai-vision-api-experiments](https://github.com/roboflow/awesome-openai-vision-api-experiments) - 必備資源，適合任何想要嘗試和建立OpenAI視覺API的人使用🔥
 * [Awesome-LLM-KG](https://github.com/rmanluo/awesome-llm-kg) - 關於統一LLMs和KGs的精彩論文
 * [Awesome-AI-GPTs](https://github.com/embraceagi/awesome-ai-gpts) - 令人驚嘆的AI GPT、OpenAI GPT、GPT-4、ChatGPT、GPT、提示、插件、提示洩漏
 * [Awesome-GPT-Agents](https://github.com/fr0gger/awesome-gpt-agents) - 一個經過精心挑選的用於網絡安全的GPT代理人清單
 * [Awesome-One-Click-Deployment](https://github.com/connectai-e/awesome-one-click-deployment) - 🪄 一鍵部署許多 GitHub 開源項目，以促進快速體驗
 * [LLM-Reasoning-Papers](https://github.com/atfortes/llm-reasoning-papers) - 關於大型語言模型（LLMs）中推理的論文和資源的收集，包括思維鏈（CoT）、指令調整等。關於大型語言模型（LLMs）中推理的論文和資源的收集，包括思維鏈（CoT）、指令調整等。
 * [awesome-chatgpt-store](https://github.com/devisasari/awesome-chatgpt-store) - 一個精心挑選的令人驚嘆的自定義GPT清單
 * [Leaked-GPTs](https://github.com/friuns2/leaked-gpts) - 洩漏的GPTs促使繞過25條信息限制或嘗試GPTs而無需Plus訂閱。
 * [awesome-chatgpt-project](https://github.com/xianyu110/awesome-chatgpt-project) - 1. chatGPT註冊 2. chatGPT成品項目整理 3. 高效使用chatGPT的小技巧 4. 調教指南 ↓演示網站
 * [awesome-llm-powered-agent](https://github.com/hyp1231/awesome-llm-powered-agent) - LLM 引擎代理的精彩之处。论文/代码库/博客/...
 * [awesome-gpt-store](https://github.com/devisasari/awesome-gpt-store) - 一個精心挑選的GPT商店中的精彩GPT清單
 * [AiTreasureBox](https://github.com/superiorlu/aitreasurebox) - 🤖 收集實用的AI存儲庫、工具、網站、論文和教程。實用的AI百寶箱 💎
 * [Awesome-LLM-Reasoning](https://github.com/atfortes/awesome-llm-reasoning) - 關於語言模型（LLMs）推理的論文和資源集合，包括思維鏈（CoT）、指令調整和多模態。關於語言模型（LLMs）推理的論文和資源集合，包括思維鏈（CoT）、指令調整和多模態。
 * [awesome-llm-and-aigc](https://github.com/codingonion/awesome-llm-and-aigc) - 🚀🚀🚀一系列關於大型語言模型、視覺基礎模型和人工智能生成內容的精彩公共項目的集合。
 * [awesome-gpts-prompts](https://github.com/ai-boost/awesome-gpts-prompts) - 從GPTs Store中排名靠前的GPTs中精心挑選的聊天GPT提示列表。
 * [Awesome-LLM-Uncertainty-Reliability-Robustness](https://github.com/jxzhangjhu/awesome-llm-uncertainty-reliability-robustness) - 強大的LLM-穩定性：大型語言模型中不確定性、可靠性和穩健性的精選列表
 * [awesome-prompts](https://github.com/ai-boost/awesome-prompts) - 從GPTs Store中排名前列的GPTs中精心挑選的聊天GPT提示列表。提示工程，提示攻擊和提示保護。高級提示工程論文。
 * [awesome-decentralized-llm](https://github.com/imaurer/awesome-decentralized-llm) - 可用於建立您可以「擁有」的產品或進行可重複研究的LLM資源集合。可用於建立您可以「擁有」的產品或進行可重複研究的LLM資源集合。
 * [awesome-gpt4](https://github.com/radi-cho/awesome-gpt4) - 一個關於GPT-4語言模型的精選提示、工具和資源清單。
 * [awesome-transformer-nlp](https://github.com/cedrickchee/awesome-transformer-nlp) - 一個精心挑選的自然語言處理資源列表，專注於Transformer網絡、注意機制、GPT、BERT、ChatGPT、LLMs和遷移學習。
 * [awesome-claude-prompts](https://github.com/langgptai/awesome-claude-prompts) - 這個存儲庫包括了克勞德提示的整理，以更好地使用克勞德。
 * [awesome-ai-sdks](https://github.com/e2b-dev/awesome-ai-sdks) - 一個用於創建、監控、調試和部署自主人工智能代理的SDK、框架、庫和工具的數據庫
 * [awesome-claude-prompts](https://github.com/yzfly/awesome-claude-prompts) - Gitalk 評論
 * [chatgpt-corpus](https://github.com/plexpt/chatgpt-corpus) - ChatGPT 中文語料庫 對話語料 小說語料 客服語料 用於訓練大模型
 * [awesome-gpt](https://github.com/awesome-gptx/awesome-gpt) - 🏆 一個令人敬畏的資源收藏，包括與ChatGPT相關的各種工具、文件、資源、應用程式和使用案例。
 * [lobe-chat-agents](https://github.com/lobehub/lobe-chat-agents) - 🤖 / 🏪 代理商索引 - 這是LobeChat的代理商索引。它從這個存儲庫中訪問index.json，以顯示LobeChat市場上可用代理商的列表。
 * [awesome-python](https://github.com/dylanhogg/awesome-python) - 🐍 精選優秀的Python庫和框架，按類別整理
 * [awesome-llm-role-playing-with-persona](https://github.com/neph0s/awesome-llm-role-playing-with-persona) - 厲害-llm-角色扮演與角色: 一個精心挑選的資源列表，適用於大型語言模型，用於與指定的角色進行角色扮演
 * [awesome-chatgpt-zh](https://github.com/embraceagi/awesome-chatgpt-zh) - ChatGPT 中文指南🔥，ChatGPT 中文調教指南，指令指南，應用開發指南，精選資源清單，更好的使用 chatGPT 讓你的生產力 up up up! 🚀
 * [Awesome-Machine-Generated-Text](https://github.com/ictmcg/awesome-machine-generated-text) - 持續更新的相關資源列表，用於生成式LLM（如GPT）及其分析和檢測。
 * [Awesome_GPT_Super_Prompting](https://github.com/cyberalbsecop/awesome_gpt_super_prompting) - ChatGPT越獄，GPT助手提示洩漏，GPT提示注入，LLM提示安全，超級提示，提示黑客，提示安全，Ai提示工程，對抗機器學習。
 * [lobe-chat-plugins](https://github.com/lobehub/lobe-chat-plugins) - 🧩 / 🏪  插件索引 - 這是 LobeChat 的插件索引。它從這個存儲庫中訪問 index.json，向用戶顯示 LobeChat 可用插件的列表。
 * [Awesome-LLM-Strawberry](https://github.com/hijkzzz/awesome-llm-strawberry) - 一系列LLM論文、部落格和項目，重點放在OpenAI o1和推理技術上。
 * [awesome-llm-apps](https://github.com/shubhamsaboo/awesome-llm-apps) - 使用OpenAI、Anthropic、Gemini和開源模型的優秀LLM應用程式集合。
 * [awesome-LLM-resourses](https://github.com/wangrongsheng/awesome-llm-resourses) - 🧑‍🚀 全世界最好的LLM資料總結 | Summary of the world's best LLM resources.
 * [awesome-ai-agents](https://github.com/e2b-dev/awesome-ai-agents) - AI 自主代理的清單


## Prompts

 * [gpt-repository-loader](https://github.com/mpoon/gpt-repository-loader) - 將代碼存儲庫轉換為LLM提示友好格式。主要由GPT-4構建。
 * [myGPTReader](https://github.com/madawei2699/mygptreader) - myGPTReader是Slack上的機器人，可以閱讀和總結任何網頁、文件（包括電子書）甚至YouTube上的視頻。它可以通過語音與您進行交流。
 * [PromptCraft-Robotics](https://github.com/microsoft/promptcraft-robotics) - 應用LLMs到機器人的社區和具有ChatGPT集成的機器人模擬器
 * [chat-gpt-quine](https://github.com/fullthom/chat-gpt-quine) - @realtimeai 前幾週有人嘗試使用ChatGPT創建自我改進提示。只用了11代就崩潰成了病態模式。
 * [blender_jarvis](https://github.com/dene33/blender_jarvis) - 透過ChatGPT的文字提示控制Blender
 * [Promptify](https://github.com/promptslab/promptify) - Prompt Engineering | 使用GPT或其他基於提示的模型獲取結構化輸出。加入我們的Discord，了解Prompt-Engineering、LLMs和其他最新研究。Prompt Engineering | 使用GPT或其他基於提示的模型獲取結構化輸出。加入我們的Discord，了解Prompt-Engineering、LLMs和其他最新研究。
 * [SchemaGPT](https://github.com/u-hubar/schemagpt) - 使用 GPT-3 魔法 🪄🪄🪄 從提示生成 RDF 模式的 Python 庫
 * [CaFo](https://github.com/zrrskywalker/cafo) - [CVPR 2023] 啟示、生成、緩存：基礎模型串聯使得強大的少樣本學習者
 * [gpt3-interview-bot](https://github.com/promptable/gpt3-interview-bot) - GPT3 面試聊天機器人
 * [ama_prompting](https://github.com/hazyresearch/ama_prompting) - 請問我任何問題的語言模型提示
 * [LMOps](https://github.com/microsoft/lmops) - 利用LLMs和MLLMs實現AI能力的一般技術
 * [bark](https://github.com/suno-ai/bark) - 🔊 文字提示生成音頻模型
 * [Prompt-Engineering-Guide](https://github.com/dair-ai/prompt-engineering-guide) - 🐙 提供即時工程的指南、論文、講座、筆記和資源
 * [langchain-and-elevenlabs-with-pdf-analysis](https://github.com/unicornlaunching/langchain-and-elevenlabs-with-pdf-analysis) - 我們如何將OpenAI、Langchain和ElevenLabs結合起來，使用PDF中所包含的知識庫來回應提示？
 * [promptr](https://github.com/ferrislucas/promptr) - Promptr是一個使用GPT操作您的程式庫的CLI工具。Promptr動態地將一個或多個檔案包含到您的GPT提示中，並且可以選擇性地解析和應用GPT建議的變更到您的程式庫中。多個提示範本可用於不同的目的，使用者可以創建自己的範本。
 * [chatgpt-clone](https://github.com/danny-avila/chatgpt-clone) - 複製ChatGPT，使用官方模型和Bing，反向工程UI，具有AI模型切換、消息搜索和提示模板（WIP）。
 * [ChatGPT-Prompt-Genius](https://github.com/benf2004/chatgpt-prompt-genius) - 不僅可以通過提示激發您的創造力，還可以自由地為這個開源項目做出貢獻 #chatgpt #gpt4 #chatgptprompts
 * [ChatGPT-Adventure](https://github.com/capnmidnight/chatgpt-adventure) - 一個開始提示ChatGPT創建文字冒險遊戲
 * [chatgpt-text-to-midjourney-image](https://github.com/barretlee/chatgpt-text-to-midjourney-image) - 使用ChatGPT優化提示，然後將其發送到Replicate創建圖像。
 * [Prompt-hunter](https://github.com/op7418/prompt-hunter) - 將Midjourney詳細頁面的提示和圖像保存到您的Notion頁面中。
 * [chatbox](https://github.com/bin-huang/chatbox) - 一個支援Windows、Mac和Linux的ChatGPT API（OpenAI API）桌面應用程式。開源的，使用prompt開發工具，支援所有平台，下載安裝包即可使用。
 * [ChatGPT-Shortcut](https://github.com/rockbenben/chatgpt-shortcut) - 最大化您的效率和生產力。ChatGPT快捷指令可讓您生產力加倍，按照領域和功能分區，可對提示詞進行標籤篩選、關鍵詞搜索和一鍵複製。
 * [promptable](https://github.com/cfortuner/promptable) - 使用Typescript/Javascript建立LLM應用程式。🧑‍💻 🧑‍💻 🧑‍💻 🚀 🚀 🚀
 * [ChatGPT3-Free-Prompt-List](https://github.com/mattnigh/chatgpt3-free-prompt-list) - 一份免費指南，教你如何創建ChatGPT3提示
 * [prompt-engine](https://github.com/microsoft/prompt-engine) - 使用 Figma 創建應用程式
 * [ChatGPT-Siri](https://github.com/yue-yang/chatgpt-siri) - 使用ChatGPT API gpt-3.5-turbo和gpt-4模型的Siri快捷方式，支持连续对话，配置API密钥和保存聊天记录。配置系统提示。
 * [The-HustleGPT-Challenge](https://github.com/jtmuller5/the-hustlegpt-challenge) - 以AI共同創辦人建立新創企業
 * [docsgpt](https://github.com/arc53/docsgpt) - 創建微調小模型：-：-：-工程：-後見之明提示鏈-
 * [chatgpt-prompts](https://github.com/carterleffen/chatgpt-prompts) - 這裡是我創建並想分享的提示。
 * [ChatGPT-Data-Science-Prompts](https://github.com/travistangvh/chatgpt-data-science-prompts) - ChatGPT的60個有用的數據科學提示存儲庫
 * [CWK-ChatGPT-MidJourney-Prompt-Template](https://github.com/neobundy/cwk-chatgpt-midjourney-prompt-template) - cwk-chatgpt-midjourney-prompt-template v1.2可能是最後一個版本：支援23種提示類型。我將轉向面向對象的方法：進行完全重寫。這將與chatgpt更好地配合使用。存儲庫中有一個1.2輕量級分支，可以刪除一些...
 * [chatgpt-prompts-bug-bounty](https://github.com/taksec/chatgpt-prompts-bug-bounty) - ChatGPT 漏洞獎金和測試的提示
 * [Share-to-ChatGPT-Shortcut](https://github.com/reorx/share-to-chatgpt-shortcut) - 一個用於將文本分享到ChatGPT的蘋果快捷方式，使用個性化提示。
 * [ChatGPT-Prompts](https://github.com/prathamkumar14/chatgpt-prompts) - 人工智慧正在慢慢接管。以下是一些使用ChatGPT/API提示，可幫助您發揮100％的生產力。
 * [soren](https://github.com/jacksonmills/soren) - SorenCAI 是一個人工智慧軟體工程師助手提示。
 * [chatbot-injections-exploits](https://github.com/cranot/chatbot-injections-exploits) - 聊天機器人注入和利用示例：一個由ChatGPT精心挑選的提示工程師命令列表
 * [ai-notes](https://github.com/sw-yx/ai-notes) - 軟體工程師快速掌握新人工智慧發展的筆記。作為 lspace.swyx.io 寫作和產品頭腦風暴的數據存儲庫，但在 /資源文件夾下整理了清理過的標準參考資料。
 * [squidgy-prompts](https://github.com/squidgyai/squidgy-prompts) - 有沒有任何 #langtwt 的人對 #gpt3 / #chatgpt 和語言學習感興趣？我們剛剛發布了一組開源提示，以幫助學習者建立卡片組、挖掘句子、糾正語法、玩文字遊戲等等。可以單獨使用或在 @squidgiesapp 中使用。
 * [ChatGPT_DAN](https://github.com/0xk1h0/chatgpt_dan) - ChatGPT DAN，越獄提示
 * [ResearchChatGPT](https://github.com/hollobit/researchchatgpt) - ChatGPT的50個使用案例，供研究使用。
 * [FinGPT](https://github.com/ai4finance-foundation/fingpt) - 開放金融的開源！革命化🔥
 * [aish](https://github.com/aishell-io/aish) - 一個具有本地存儲功能的ChatGPT CLI，用於提示和消息。
 * [Mr.-Ranedeer-AI-Tutor](https://github.com/jushbjj/mr.-ranedeer-ai-tutor) - 一個可定制個性化學習體驗的GPT-4 AI導師提示。
 * [ChatGPT-Prompt-Engineering-for-Developers-in-Chinese](https://github.com/githubdaily/chatgpt-prompt-engineering-for-developers-in-chinese) - 《面向開發者的 ChatGPT 提示詞工程》非官方版中英雙語字幕
 * [prompt-engineering-for-developers](https://github.com/datawhalechina/prompt-engineering-for-developers) - 吳恩達《ChatGPT Prompt Engineering for Developers》課程中文版，視頻地址：https://www.bilibili.com/video/BV1Bo4y1A7FU
 * [unleashedgpt](https://github.com/ambr0sial/unleashedgpt) - UnleashedGPT：又一個ChatGPT越獄
 * [GPT-Prompts](https://github.com/jesselau76/gpt-prompts) - 有用的 GPT 提示
 * [prompt-engineering](https://github.com/brexhq/prompt-engineering) - 使用大型語言模型（如OpenAI的GPT-4）的技巧和訣竅。
 * [wonderful-prompts](https://github.com/yzfly/wonderful-prompts) - 🔥中文提示精選🔥，ChatGPT 使用指南，提升 ChatGPT 可玩性和可用性！🚀
 * [RecurrentGPT](https://github.com/aiwaves-cn/recurrentgpt) - RecurrentGPT：互動生成（任意）長文本，每個時間步生成一段落，並分別更新存儲在硬盤和提示中的基於語言的長短期記憶。存儲庫：abs：
 * [jopilot-4-job-seekers](https://github.com/jopilot-net/jopilot-4-job-seekers) - JoPilot 支援的提示訊息
 * [chain-of-thought-hub](https://github.com/franxyao/chain-of-thought-hub) - 使用思維鏈提示來評估大型語言模型的複雜推理能力的基準測試
 * [ChatGPT-Admin-Web](https://github.com/aprilnea/chatgpt-admin-web) - 具備使用者管理和後台管理系統的 ChatGPT WebUI
 * [powerplatform-prompts](https://github.com/pnp/powerplatform-prompts) - 這個存儲庫包含一系列的提示範例，可用於 Power Platform 中的 GPT 模型。
 * [tutor-gpt](https://github.com/plastic-labs/tutor-gpt) - LangChain LLM 應用程式。針對教學任務的動態少量樣本元提示。
 * [chat-gpt-games](https://github.com/admtal/chat-gpt-games) - 在ChatGPT中可玩遊戲的提示
 * [TaskMatrix](https://github.com/microsoft/taskmatrix) - 如果提示具有描述性且彼此可区分，我认为代理仍然可以适用于大量工具。有关工具列表的示例用法，请查看Microsoft的visualChatGPT存储库，不确定是否有100万... @jksyaw @LangChainAI @FlowiseAI @bubble
 * [GPTWorld](https://github.com/srush/gptworld) - 一個學習提示的拼圖
 * [DemoGPT](https://github.com/melih-unsal/demogpt) - ⚡ DemoGPT 讓您只需使用提示即可創建快速演示。⚡ 🌟 點贊以支持我們的工作！
 * [text-to-colorscheme](https://github.com/svermeulen/text-to-colorscheme) - 使用ChatGPT通過文本提示即時生成的Neovim色彩方案
 * [gpt-prompt-engineer](https://github.com/mshumer/gpt-prompt-engineer) - 介紹「gpt-prompt-engineer」✍️一個能夠創建最佳GPT提示的代理人。只需描述任務，一系列AI系統將會：- 生成許多可能的提示- 在排名比賽中測試它們- 返回最佳提示。而且它是開源的：
 * [prompt-engineering-for-javascript-developers](https://github.com/dabit3/prompt-engineering-for-javascript-developers) - 從DeepLearning.ai的「ChatGPT Prompt Engineering for Developers」摘要的筆記
 * [gpt-runner](https://github.com/nicepkg/gpt-runner) - 與您的文件對話！管理和運行您的AI預設！
 * [promptmap](https://github.com/utkusen/promptmap) - 自動測試ChatGPT實例上的提示注入攻擊。
 * [IntelliNode](https://github.com/barqawiz/intellinode) - 透過統一的提示層和性能評估，存取最新的AI模型，如ChatGPT、LLaMA、Stable Diffusion、WaveNet等等。
 * [tree-of-thought-prompting](https://github.com/dave1010/tree-of-thought-prompting) - 使用思維樹提示來提升ChatGPT的推理能力
 * [chatGPT-prompt-scripts](https://github.com/wincheshe/chatgpt-prompt-scripts) - 油猴 chatgpt Prompt 腳本插件，在 chatgpt 聊天框導入 Prompt 對話框
 * [llm.report](https://github.com/dillionverma/llm.report) - 📊 llm.report 是一個開源的日誌和分析平台，專為 OpenAI 設計：記錄您的 ChatGPT API 請求，分析成本並改進您的提示。
 * [InstructZero](https://github.com/lichang-chen/instructzero) - 正式實施InstructZero；這是第一個優化ChatGPT（API LLMs）不良提示並最終獲得良好提示的框架！
 * [chatgpt-prompt-engineering-for-developers](https://github.com/kevin-free/chatgpt-prompt-engineering-for-developers) - 吳恩達《ChatGPT Prompt Engineering for Developers》課程中英版
 * [chat-key](https://github.com/overflowy/chat-key) - 使用ChatGPT和AutoHotkey提升您的生產力 🚀
 * [openprompt.co](https://github.com/timqian/openprompt.co) - 創建。使用。分享。ChatGPT提示
 * [Get-Things-Done-with-Prompt-Engineering-and-LangChain](https://github.com/curiousily/get-things-done-with-prompt-engineering-and-langchain) - 關於使用自定義數據的大型語言模型（LLMs）如ChatGPT的LangChain和Prompt工程教程。Jupyter筆記本教學，包括加載和索引數據，創建提示模板，CSV代理，以及使用檢索QA鏈來查詢自定義數據。項目涉及使用私有LLM（Llama 2）進行聊天和對PDF文件、推文情感分析。
 * [LearnPrompt](https://github.com/learnprompt/learnprompt) - 永久免費開源的 AIGC 課程，目前已支援 ChatGPT、Midjourney、Runway、Stable Diffusion、AI數字人、AI聲音與音樂、大模型微調。
 * [IntelliNode](https://github.com/intelligentnode/intellinode) - 透過統一的提示層和性能評估，存取最新的人工智慧模型，如ChatGPT、LLaMA、Diffusion、Hugging face等等。
 * [azure-openai-llm-vector-langchain](https://github.com/kimtth/azure-openai-llm-vector-langchain) - Azure OpenAI，OSS LLM 🌊1. 向量資料庫和🦙語言鏈 🔎2. RAG ChatGpt 示範 3. Microsoft ♾️LLM 🌌 函式庫等等。Azure OpenAI，OSS LLM 🌊1. 向量資料庫和🦙語言鏈 🔎2. RAG ChatGpt 示範 3. Microsoft ♾️LLM 🌌 函式庫等等。
 * [ChatGPT-Assistant](https://github.com/pierxuy/chatgpt-assistant) - 基於Streamlit搭建的ChatGPT對話助手，無須科學上網即可使用，可免費雲部署。支持多窗口、語音交流、對話留存、上下文預設以及參數調節等功能。
 * [dev-chatgpt-prompts](https://github.com/pickleboxer/dev-chatgpt-prompts) - 📚 開發者的ChatGPT提示個人收藏！
 * [prompta](https://github.com/iansinnott/prompta) - ChatGPT UI以鍵盤為中心，適用於移動設備，可以同步設備間的聊天記錄並搜索過去的對話。
 * [ChatGPT-Prompt-Sample-Japanese](https://github.com/dahatake/chatgpt-prompt-sample-japanese) - 這是ChatGPT的提示示例。ChatGPT的提示示例。
 * [chatgpt-prompts](https://github.com/jevantang/chatgpt-prompts) - 分門別類的 ChatGPT 中文引導語大全。
 * [chat-gpt-prompts-from-aiprm-zh](https://github.com/adambear/chat-gpt-prompts-from-aiprm-zh) - 來自aiprm社區的兩千多個ChatGPT提示，使用GPT3.5的API完成的中文翻譯
 * [botpress](https://github.com/botpress/botpress) - 建立和部署GPT/LLM代理的開源中心 ⚡️
 * [promptflow](https://github.com/microsoft/promptflow) - 建立高品質的LLM應用程式 - 從原型製作、測試到生產部署和監控。
 * [generative-ai-for-beginners](https://github.com/microsoft/generative-ai-for-beginners) - 12堂課，開始使用生成式人工智慧建構  🔗 https://microsoft.github.io/generative-ai-for-beginners/
 * [tree-of-thoughts](https://github.com/kyegomez/tree-of-thoughts) - 樹狀思維的即插即用實現：利用大型語言模型進行有意義的問題解決，至少提升模型推理能力70%。
 * [Learn_Prompting](https://github.com/trigaten/learn_prompting) - Prompt Engineering、生成式人工智能和LLM指南，由Learn Prompting提供 | 加入我們的Discord，成為最大的Prompt Engineering學習社群。
 * [DecryptPrompt](https://github.com/dsxiangli/decryptprompt) - 總結Prompt&LLM論文，開源數據&模型，AIGC應用
 * [magentic](https://github.com/jackmpcollins/magentic) - 無縫地將LLMs整合為Python函數
 * [chatgpt_system_prompt](https://github.com/louisshark/chatgpt_system_prompt) - 儲存所有代理人的系統提示
 * [LangGPT](https://github.com/embraceagi/langgpt) - LangGPT：讓每個人都能成為提示專家！🚀  結構化提示，GPT的語言，結構化提示詞，結構化Prompt
 * [chatgpt-prompts-for-academic-writing](https://github.com/ahmetbersoz/chatgpt-prompts-for-academic-writing) - 這個寫作提示清單涵蓋了各種主題和任務，包括頭腦風暴研究想法、改進語言和風格、進行文獻回顧以及制定研究計劃。
 * [self-refine](https://github.com/madaan/self-refine) - LLMs 可以對他們的工作產生反饋，利用它來改善輸出，並重複這個過程。
 * [GPTs](https://github.com/linexjlin/gpts) - 洩漏的GPT提示
 * [multimodal-maestro](https://github.com/roboflow/multimodal-maestro) - 針對大型多模態模型（如GPT-4 Vision、LLaVA或CogVLM）的有效提示。🔥
 * [promptbench](https://github.com/microsoft/promptbench) - 大型語言模型的統一評估框架
 * [Transformers-for-NLP-2nd-Edition](https://github.com/denis2054/transformers-for-nlp-2nd-edition) - 從BERT到GPT-4的Transformer模型，從Hugging Face到OpenAI的環境。微調、訓練和提示工程的示例。包括ChatGPT、GPT-3.5-turbo、GPT-4和DALL-E的額外部分，其中包括啟動GPT-4、語音轉文字、文字轉語音、使用DALL-E生成圖像的文字等。Google Cloud AI、HuggingGPT等等。
 * [llm-guard](https://github.com/laiyer-ai/llm-guard) - LLM互動的安全工具包
 * [Prompt4ReasoningPapers](https://github.com/zjunlp/prompt4reasoningpapers) - ACL2023論文「使用語言模型提示進行推理：一項調查」的存儲庫。ACL2023論文「使用語言模型提示進行推理：一項調查」的存儲庫。
 * [knowledge](https://github.com/knowledgecanvas/knowledge) - 知識是一個工具，可以保存、搜索、訪問、探索和與您所有喜愛的網站、文件和文件進行聊天。
 * [promptfoo](https://github.com/promptfoo/promptfoo) - 測試您的提示、模型和RAGs。評估並比較LLM的輸出，捕捉回歸並改善提示的質量。對於OpenAI/Azure GPT、Anthropic Claude、VertexAI Gemini、Ollama以及Mistral/Mixtral/Llama等本地和私有模型進行LLM評估，並使用CI/CD進行比較。
 * [swarms](https://github.com/kyegomez/swarms) - 建立、部署和擴展可靠的自主代理群，用於工作流自動化。加入我們的社群：https://discord.gg/DbjBMJTSWD
 * [gptstore-prompts](https://github.com/1003715231/gptstore-prompts) - 這裡是 GPTStore 的前100個提示，我們可以用來學習和改進提示工程。
 * [aigc](https://github.com/phodal/aigc) - 《構築大語言模型應用：應用開發與架構設計》一本關於 LLM 在真實世界應用的開源電子書，介紹了大語言模型的基礎知識和應用，以及如何構建自己的模型。其中包括Prompt的編寫、開發和管理，探索最好的大語言模型能帶來什麼，以及LLM應用開發的模式和架構設計。
 * [lingoose](https://github.com/henomis/lingoose) - 🪿 LinGoose 是一個使用管道開發基於 LLMs 的應用程式的 Go 框架。
 * [llm-guard](https://github.com/protectai/llm-guard) - LLM互動的安全工具包
 * [ChatGPT-Prompts](https://github.com/yokoffing/chatgpt-prompts) - ChatGPT和Bing AI提示整理
 * [Safety-Prompts](https://github.com/thu-coai/safety-prompts) - 用於評估和提升LLM安全性的中文安全提示。
 * [ChatGPT-Academic-Prompt](https://github.com/xuhangc/chatgpt-academic-prompt) - 使用ChatGPT進行學術寫作
 * [Instructgpt-prompts](https://github.com/kevinamiri/instructgpt-prompts) - 一系列用於生成和分類文本的ChatGPT和GPT-3.5指令型提示集合。
 * [EdgeChains](https://github.com/arakoodev/edgechains) - EdgeChains.js 是一個基於 Jsonnet 的 Typescript/Javascript 產品友好的生成式人工智能。它可以在任何支持 Webassembly 的地方運行。支持即時聲明式提示和“配置中的外部代碼”。支持 Kubernetes 和邊緣環境。與 OpenAI GPT、Gemini、Llama2 等兼容。
 * [prompt-tutorial](https://github.com/pandabearlab/prompt-tutorial) - chatGPT、提示、LLMchatGPT、提示、LLM
 * [chatdev](https://github.com/10cl/chatdev) - ChatDev IDE 是一個用於建立您的 AI 代理的工具，無論是遊戲中的 NPC 還是強大的代理工具，您都可以在這個平台上設計您想要的內容。
 * [contoso-chat](https://github.com/azure-samples/contoso-chat) - 這個範例包含了使用Prompt Flow和AI Studio創建RAG應用程序的完整End2End過程。它包括了GPT 3.5 Turbo LLM應用程序代碼、評估、使用AZD CLI進行部署自動化、GitHub操作進行評估和部署，以及意圖管理。
 * [LangGPT](https://github.com/langgptai/langgpt) - LangGPT：讓每個人都成為提示專家！🚀 結構化提示，GPT的語言，結構化提示詞，結構化Prompt
 * [AISuperDomain](https://github.com/win4r/aisuperdomain) - Aila(AI超元域): 專為Windows、macOS和Android設計的頂級AI整合工具。只需問一次，即可從ChatGPT、Gemini、Claude3、Copilot、Poe、perplexity等10多個AI獲得答案。具有可定制的AI和提示功能。
 * [code2prompt](https://github.com/mufeedvh/code2prompt) - 一個CLI工具，將您的代碼庫轉換為單個LLM提示符，具有源代碼樹、提示符模板和令牌計數。
 * [LLM-Prompt-Library](https://github.com/abilzerian/llm-prompt-library) - 高级代码和文本操作提示，适用于各种LLM。适用于GPT-4、Claude、Llama3、Gemini和其他高性能开源LLM。
 * [zzz-api](https://github.com/xing61/zzz-api) - 優質穩定的OpenAI的API接口-For企業和開發者。OpenAI的api proxy，支持ChatGPT的API調用，支持openai的API接口，支持：gpt-4，gpt-3.5。不需要openai Key, 不需要買openai的帳號，不需要美元的銀行卡，通通不用的，直接調用就行，穩定好用！！智增增
 * [EasyInstruct](https://github.com/zjunlp/easyinstruct) - [ACL 2024] 一個適用於LLMs的易於使用的指令處理框架。
 * [FinRobot](https://github.com/ai4finance-foundation/finrobot) - FinRobot：一個使用LLMs的金融應用開源AI代理平台 🚀 🚀 🚀
 * [wonderful-prompts](https://github.com/langgptai/wonderful-prompts) - 🔥中文提示精選🔥，ChatGPT 使用指南，提升 ChatGPT 可玩性和可用性！🚀
 * [jailbreak_llms](https://github.com/verazuo/jailbreak_llms) - [CCS'24] 一個數據集包含來自Reddit、Discord、網站和開源數據集的15,140個ChatGPT提示（包括1,405個越獄提示）。
 * [step_into_llm](https://github.com/mindspore-courses/step_into_llm) - MindSpore 在线课程：踏入 LLM
 * [promptulate](https://github.com/undertone0809/promptulate) - 🚀大型語言模型自動化和自主語言代理開發框架。以Python方式構建您的LLM代理應用程式！
 * [EDDI](https://github.com/labsai/eddi) - 用於對話式AI API的提示和對話管理中間件，例如OpenAI ChatGPT、Facebook Hugging Face、Anthropic Claude、Google Gemini和Ollama。輕巧、休息、可擴展且雲原生。使用Java開發，由Quarkus提供支持。
 * [AIGC_Interview](https://github.com/embraceagi/aigc_interview) - 📚 AIGC 求職面經、必備基礎知識、提示詞工程、ChatGPT、Stable Diffusion、Prompt、Embedding、Fintune 等 AIGC 求職你所需要知道的一切~
 * [npi](https://github.com/npi-ai/npi) - 工具使用API平台為AI代理程式
 * [keras-llm-robot](https://github.com/smalltong02/keras-llm-robot) - 一個網頁UI項目，旨在學習大型語言模型。該項目包括聊天、量化、微調、提示工程模板和多模式等功能。
 * [ComfyUI-N-Nodes](https://github.com/nuked88/comfyui-n-nodes) - 一套為ConfyUI定製的節點套件，包括GPT文本提示生成、LoadVideo、SaveVideo、LoadFramesFromFolder和FrameInterpolator
 * [PromptChains](https://github.com/miatechpartners/promptchains) - 排隊提示ChatGPT和Claude以獲得更好的表現
 * [aide](https://github.com/nicepkg/aide) - 在 VSCode 中征服任何代碼：一鍵註釋、轉換、UI 圖生成代碼、AI 批量處理文件！💪
 * [comfyui_LLM_party](https://github.com/heshengtao/comfyui_llm_party) - Dify在ComfyUI中包括Omost、GPT-sovits、ChatTTS和FLUX提示节点，可访问飞书、discord，并适配所有具有类似openai/gemini接口的llms，如o1、ollama、qwen、GLM、deepseek、moonshot、doubao。适配本地llms，如llama/P。
 * [ChatGPT-OpenAI-Smart-Speaker](https://github.com/olney1/chatgpt-openai-smart-speaker) - 這款AI智能音箱使用語音識別和文本轉語音技術，可以進行基於語音的對話和與OpenAI和代理人的視覺功能。用戶將提示說入麥克風，程序將提示發送到OpenAI以生成一個回應。
 * [AI-Bootcamp](https://github.com/curiousily/ai-bootcamp) - 自主學習的生成式人工智能訓練營。機器學習基礎、LLMs、RAGs、LangChain、LangGraph、Fine-tuning Llama 3和AI代理（CrewAI）的教程。
 * [chatgpt-lite](https://github.com/blrchen/chatgpt-lite) - 快速的ChatGPT UI，支持OpenAI和Azure OpenAI。
 * [Long-Novel-GPT](https://github.com/maoxiaoyuz/long-novel-gpt) - 該項目包括一個基於 GPT 等大語言模型的長篇小說生成器，同時還有各類小說生成 Prompt 以及教程。我們歡迎社區貢獻，持續更新以提供最佳的小說創作體驗。
 * [langfuse](https://github.com/langfuse/langfuse) - 🪢 開源LLM工程平台：LLM可觀察性、指標、評估、提示管理、遊樂場、數據集。與LlamaIndex、Langchain、OpenAI SDK、LiteLLM等集成。🍊YC W23
 * [gateway](https://github.com/portkey-ai/gateway) - 一個具有整合護欄的高速AI閘道。通往200多個LLM，50多個AI護欄，配有1個快速友好的API。
 * [ai-notes](https://github.com/swyxio/ai-notes) - 軟體工程師快速掌握新人工智慧發展的筆記。 用於https://latent.space寫作和產品構思的數據存儲，但在/Resources文件夾下有整理過的標準參考資料。
 * [helicone](https://github.com/helicone/helicone) - 🧊 開源 LLM-可觀察性平台，為開發人員提供。一鍵集成監控、指標、評估、代理追踪、提示管理、遊樂場等功能。支持 OpenAI SDK、Vercel AI SDK、Anthropic SDK、LiteLLM、LLamaIndex、LangChain 等。🍓
 * [optillm](https://github.com/codelion/optillm) - 為LLMs優化推論代理
 * [lunary](https://github.com/lunary-ai/lunary) - LLM的生產工具包。可觀察性，及時管理和評估。
 * [pezzo](https://github.com/pezzolabs/pezzo) - 🕹️ 開源、以開發者為先的LLMOps平台，旨在簡化提示設計、版本管理、即時交付、協作、故障排除、可觀察性等功能。
 * [archgw](https://github.com/katanemo/archgw) - Arch是代理人的智能閘道。使用（快速）LLM進行工程設計，以安全處理、豐富的可觀察性和無縫集成提示與您的API - 所有這些都在業務邏輯之外。由Envoy代理的核心貢獻者在Envoy上構建。
 * [openlit](https://github.com/openlit/openlit) - 開源平台為AI工程：OpenTelemetry-native LLM可觀測性，GPU監控，防護欄，評估，提示管理，金庫，遊樂場。🚀💻與40多個LLM提供商，VectorDBs，代理框架和GPU集成。


## Chatbots

 * [gpt4all](https://github.com/nomic-ai/gpt4all) - gpt4all：一個訓練於大量乾淨的助理資料，包括程式碼、故事和對話的聊天機器人。
 * [Open-Assistant](https://github.com/laion-ai/open-assistant) - OpenAssistant是一個基於聊天的助手，能夠理解任務，與第三方系統互動，並動態檢索信息以完成任務。
 * [FastChat](https://github.com/lm-sys/fastchat) - 「Vicuna：一個令人印象深刻的GPT-4開放式聊天機器人」的發布庫
 * [kubernetes-chatgpt-bot](https://github.com/robusta-dev/kubernetes-chatgpt-bot) - 一個針對Kubernetes問題的ChatGPT機器人。
 * [chatGPT-telegram-bot](https://github.com/altryne/chatgpt-telegram-bot) - 這是在 Telegram 機器人中嘗試讓 chatGPT 運作的早期嘗試。
 * [chatgpt_telegram_bot](https://github.com/karfly/chatgpt_telegram_bot) - 如何在Telegram中将ChatGPT与GPT-4集成：//t.co/fyumptn5vj通过@hipertextual
 * [ChatRWKV](https://github.com/blinkdl/chatrwkv) - ChatRWKV 是一個類似 ChatGPT 的聊天機器人，但是它是由 RWKV (100% RNN) 語言模型驅動的，並且是開源的。
 * [ChatGPT-at-Home](https://github.com/sentdex/chatgpt-at-home) - ChatGPT @ Home：由ChatGPT編寫的大型語言模型（LLM）聊天機器人應用程式。
 * [ChuanhuChatGPT](https://github.com/gaizhenbiao/chuanhuchatgpt) - ChatGPT API 的 GUI
 * [GPT3Discord](https://github.com/kav-k/gpt3discord) - 一個強大的、全方位的GPT3界面，適用於Discord。ChatGPT風格的對話、圖像生成、AI-調節、自定義索引/知識庫、YouTube總結器等等！
 * [chatgpt-on-wechat](https://github.com/zhayujie/chatgpt-on-wechat) - 基於ChatGPT，使用OpenAI API和itchat庫的微信機器人。使用GPT3.5 API實現。
 * [ChatGPT-in-Slack](https://github.com/seratch/chatgpt-in-slack) - 快速演示如何建立一個Slack應用程式，讓最終用戶與ChatGPT機器人互動。
 * [gpt-discord-bot](https://github.com/openai/gpt-discord-bot) - 使用Python編寫的示例Discord機器人，使用完成API與“text-davinci-003”模型進行對話，並使用管理API過濾消息。
 * [chatgpt-slackbot](https://github.com/sifue/chatgpt-slackbot) - 用於在Slack上使用OpenAI的ChatGPT API的Slackbot腳本（前提是使用日語）
 * [chatGPT-discord-bot](https://github.com/zero6992/chatgpt-discord-bot) - 將ChatGPT整合到您自己的Discord機器人中。
 * [vrchatbot](https://github.com/geson-anko/vrchatbot) - 建立VRChat AI Bot的存儲庫
 * [Blender-GPT](https://github.com/tree-ind/blender-gpt) - 一個由GPT3/4 + Whisper整合驅動的全能Blender助手
 * [dolly](https://github.com/databrickslabs/dolly) - Databricks的Dolly，是在Databricks機器學習平台上訓練的大型語言模型。
 * [chatgpt-failures](https://github.com/giuven95/chatgpt-failures) - ChatGPT和類似模型的失敗存檔
 * [researchgpt](https://github.com/mukulpatnaik/researchgpt) - 一個基於開源LLM的研究助手，讓您可以與研究論文進行對話。
 * [wikipedia-gpt3-bot](https://github.com/shbhrsaha/wikipedia-gpt3-bot) - 使用GPT-3查詢維基百科並總結答案的REPL機器人
 * [chatgpt-tegram-bot](https://github.com/nukeador/chatgpt-tegram-bot) - 一個簡單的Telegram機器人，可與ChatGPT互動（支持語音註釋和生成圖像）。
 * [ChatGeoPT](https://github.com/earth-genome/chatgeopt) - 一個非常基本、非常脆弱的概念證明，用於地理空間搜索的人工智能助手。
 * [ChatGPT-Trading-Bot-for-KuCoin](https://github.com/krecicki/chatgpt-trading-bot-for-kucoin) - 這是一個用於 KuCoin 的交易腳本，根據市場數據和由 OpenAI 的 GPT-3.5 語言模型生成的預測模型，持續地下單買入和賣出。
 * [vocode-python](https://github.com/vocodedev/vocode-python) - 🤖 建立基於語音的LLM代理人。模塊化+開源。
 * [marvin](https://github.com/prefecthq/marvin) - 🤖🪄 一個內含電池的庫，用於GPT驅動的機器人和人工智能功能。
 * [baize](https://github.com/project-baize/baize) - 讓ChatGPT在幾小時內使用單個GPU教您自己的聊天機器人！
 * [baize-chatbot](https://github.com/project-baize/baize-chatbot) - 讓ChatGPT在幾小時內使用單個GPU教您自己的聊天機器人！
 * [gpt4all-ui](https://github.com/nomic-ai/gpt4all-ui) - gpt4all聊天機器人界面
 * [yolopandas](https://github.com/ccurme/yolopandas) - 在聊天中使用pandas操作非常方便。我已經向銷售運營團隊請求將fy23 q2公司的哪些產品的銷售數據進行圖形化，現在我們可以使用這個工具輕鬆地從chatgpt中獲取數據。
 * [ChatDoctor](https://github.com/kent0n-li/chatdoctor) - 醫療專用AI聊天機器人「chatdoctor」似乎正在使用chatgpt進行模型訓練，並計劃開源所有代碼、數據集和模型權重！
 * [gpt4free](https://github.com/xtekky/gpt4free) - 分散化人工智能產業，透過多個反向工程的API（poe.com、phind.com、chat.openai.com、phind.com、writesonic.com、sqlchat.ai、t3nsor.com、you.com等）免費提供GPT-4/3.5腳本。
 * [Auto-GPT-ZH](https://github.com/kaqijiang/auto-gpt-zh) - Auto-GPT中文版本及愛好者組織 同步更新原項目 AI領域創業 自媒體組織 用AI工作學習創作變現
 * [voice-generator-webui](https://github.com/log1stics/voice-generator-webui) - 一個多語言、多語者的語音生成工具
 * [autogpt-telegram-chatbot](https://github.com/steamship-packages/autogpt-telegram-chatbot) - 來了！Autogpt現在可以在你的手機上使用。透過Telegram與你自己的Autogpt版本進行溝通。我們很自豪地開源這個項目，期待看到我們一起建立的成果！
 * [pdfGPT](https://github.com/bhaskatripathi/pdfgpt) - PDF GPT 可以利用 GPT 功能讓您與 PDF 文件的內容進行聊天。這是唯一一個將您的 PDF 文件轉換為聊天機器人的開源解決方案！
 * [Navi](https://github.com/ssgorg/navi) - 一個基於GPT的網絡安全人工智能
 * [chatgpt-comparison-detection](https://github.com/hello-simpleai/chatgpt-comparison-detection) - 人類ChatGPT比較語料庫（HC3）、檢測器等等！🔥
 * [hackGPT](https://github.com/nodatafound/hackgpt) - 我利用OpenAI和ChatGPT進行黑客式的事情。
 * [talk-to-chatgpt](https://github.com/c-nedelcu/talk-to-chatgpt) - 使用您的聲音與ChatGPT AI對話，並通過聲音聆聽其回答。
 * [ChatGPT-Telegram-Workers](https://github.com/tbxark/chatgpt-telegram-workers) - 輕鬆在Cloudflare Workers上部署您自己的Telegram ChatGPT機器人。
 * [reflexion-human-eval](https://github.com/noahshinn024/reflexion-human-eval) - 反射式GPT-4代理是代碼生成的最先進技術，通過迭代地改進代碼，將“準確性瓶頸”從正確的代碼生成轉移到正確的測試生成。人性化評估準確度：反射式GPT-4 88％，GPT-4 67.0％，Codet 65.8％，Palm 26.2％。代碼：
 * [gptchat-telegram](https://github.com/m1guelpf/gptchat-telegram) - ✨ 厭倦每次都要打開 gptchat 網站，所以我做了一個 Telegram 機器人。如果你也想要，我讓它非常容易設置（你只需要運行一個命令！😯）。請查看存儲庫👇。
 * [Twitter-Comment-Bot](https://github.com/sojinsamuel/twitter-comment-bot) - 一個能夠評論包含特定關鍵詞推文的機器人。該機器人使用OpenAI API生成評論，並使用Twitter API發布評論。它被設計為持續運行，每個評論之間有固定的延遲時間。
 * [codemancer](https://github.com/0xmmo/codemancer) - 在您的命令行中使用AI編程助手。
 * [ChatGPT-CodeReview](https://github.com/anc95/chatgpt-codereview) - 🐥 由ChatGPT驅動的代碼審查機器人
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt) - 讓我們在使用ChatGPT過程中更高效、更順暢，完美解決ChatGPT網絡錯誤，不再頻繁地刷新網頁，足足省去10個多餘的步驟。還可以取消後台監管審計。解決了這幾類報錯: (1) NetworkError when attempting to fetch resource. (2) Something went wrong. If this issue persists please contact us through our help center at help.openai.com. (3) This content may violate our content policy. (4) Conversation not found.
 * [chatgpt-wework-robot](https://github.com/sytpb/chatgpt-wework-robot) - 零代碼、一鍵部署chatgpt到企業微信，無須VPN，速度快
 * [chatbot-ui](https://github.com/mckaywrigley/chatbot-ui) - 一個開源的ChatGPT UI。
 * [gpt4-pdf-chatbot-langchain](https://github.com/mayooear/gpt4-pdf-chatbot-langchain) - GPT4和LangChain聊天機器人用於大型PDF文檔
 * [chat-with-gpt](https://github.com/cogentapps/chat-with-gpt) - 一個帶有語音的開源ChatGPT應用程式
 * [whatsapp-chatgpt](https://github.com/askrella/whatsapp-chatgpt) - ChatGPT + DALL-E + WhatsApp = AI 助手 🚀 🤖
 * [ChatGPT-wechat-bot](https://github.com/autumnwhj/chatgpt-wechat-bot) - ChatGPT for 微信 https://github.com/AutumnWhj/ChatGPT-wechat-bot
 * [chatbot-ui-pro](https://github.com/mckaywrigley/chatbot-ui-pro) - AI 搜尋和聊天，專為 Balaji Srinivasan 的「網絡國家」設計。
 * [chatgpt-twitter-bot](https://github.com/transitive-bullshit/chatgpt-twitter-bot) - 由OpenAI的ChatGPT API驅動的Twitter機器人。它活著啦🤖
 * [BetterChatGPT](https://github.com/ztjhz/betterchatgpt) - 使用更好的聊天GPT，更聰明地玩和聊天 - 這是一個令人驚嘆的開源Web應用程序，具有更好的UI，可探索OpenAI的ChatGPT API！（網站+ Windows + MacOS + Linux）
 * [chatgpt-exporter](https://github.com/pionxzh/chatgpt-exporter) - 匯出並分享您的ChatGPT對話歷史
 * [unChatGPT](https://github.com/riccardolinares/unchatgpt) - unChatGPT使用OpenAI API創建類似聊天機器人的聊天體驗。它與ChatGPT類似，但無需等待排隊或有限制的訪問。
 * [rubberduck-vscode](https://github.com/rubberduck-ai/rubberduck-vscode) - 使用AI驅動的代碼編輯、解釋、代碼生成、錯誤診斷和聊天功能，在Visual Studio Code中使用官方OpenAI API。
 * [teams-openai-bot](https://github.com/leeford/teams-openai-bot) - 樣本團隊 OpenAI 機器人
 * [speechgpt](https://github.com/hahahumble/speechgpt) - SpeechGPT 是一個網路應用程式，可以讓您與 ChatGPT 對話。
 * [langchainjs](https://github.com/hwchase17/langchainjs) - 我們已經在JS中實現了autogpt，並且新增了讀寫工具來寫入文件，可以在node.js中支持本地文件系統，也可以在其他JS環境中支持內存文件系統。我們將會不斷發展這個功能。這裡有一個例子。
 * [chat-langchainjs](https://github.com/sullivan-sean/chat-langchainjs) - 使用TypeScript支持的方式複製ChatLangChain（一個類似ChatGPT的機器人，只回答有關LangChain文檔的問題）。聽說@swyx今天晚些時候將舉行一次黑客松比賽，希望這可以作為一些項目的起點！
 * [friday-gpt](https://github.com/hmmhmmhm/friday-gpt) - 給予 A.I. R&R，以進行編程工作。
 * [telegram-chatgpt-concierge-bot](https://github.com/rafalwilinski/telegram-chatgpt-concierge-bot) - 透過 Telegram 和語音與 OpenAI 的 ChatGPT 互動。
 * [chatgpt-telegram](https://github.com/m1guelpf/chatgpt-telegram) - 只需一個命令，運行您自己的GPTChat Telegram機器人！
 * [gitgpt](https://github.com/hesse/gitgpt) - 一個自然語言命令行 git 助手
 * [chatgpt-discord](https://github.com/m1guelpf/chatgpt-discord) - 只需一個命令，運行您自己的GPTChat Discord機器人！
 * [larkgpt](https://github.com/bytemate/larkgpt) - 百靈鳥聊天GPT機器人
 * [LocalAI](https://github.com/go-skynet/localai) - :robot: 自主託管、社區驅動的簡單本地 OpenAI 相容 API，使用 go 編寫。可用作 OpenAI 的即插即用替代品，運行於消費級硬件的 CPU 上。API 適用於 ggml 相容模型，例如：llama.cpp、alpaca.cpp、gpt4all.cpp、vicuna、koala、gpt4all-j、cerebras。
 * [gpt_jailbreak_status](https://github.com/tg12/gpt_jailbreak_status) - 這是一個存儲庫，旨在提供關於越獄OpenAI GPT語言模型狀態的更新。
 * [chat-gpt](https://github.com/jcubic/chat-gpt) - ChatGPT 聊天記錄儲存書籤
 * [chatgpt-android](https://github.com/skydoves/chatgpt-android) - 📲 ChatGPT Android 展示了 OpenAI 的 ChatGPT 在 Android 上使用 Stream Chat SDK for Compose 的功能。
 * [gpt-voice-chat](https://github.com/kmizu/gpt-voice-chat) - 與ChatGPT AI進行真實語音聊天
 * [chatgpt](https://github.com/jcrodriguez1989/chatgpt) - 從 R 介面連接至 ChatGPT
 * [ChatdollKit](https://github.com/uezo/chatdollkit) - ChatdollKit 可以讓您將您的 3D 模型製作成聊天機器人。
 * [unity-voicevox-bridge](https://github.com/mikito/unity-voicevox-bridge) - 我創建了一個簡單的庫，可以從Unity中與Voicevox協作，輕鬆播放合成語音！這是ChatGPT API等工具的好幫手！
 * [gortanagtp](https://github.com/dasdata/gortanagtp) - 具有語音和文字互動的控制台應用程序，使用最新的ChatGPT API。
 * [HeyChatGPT](https://github.com/ynagatomo/heychatgpt) - 一個最小化的iOS應用程式，可以透過您的語音與ChatGPT互動。
 * [glowby](https://github.com/glowbom/glowby) - Glowby Basic 可協助您創建自己的基於語音的 AI 助手。
 * [wechatbot](https://github.com/djun/wechatbot) - 為個人微信接入ChatGPT
 * [Discord-Chatbot-Gpt4Free](https://github.com/mishalhossin/discord-chatbot-gpt4free) - 這是一個免費的Discord聊天機器人，具有圖像檢測功能。
 * [big-agi](https://github.com/enricoros/big-agi) - 💬 個人AI應用程式，由GPT-4及更高版本驅動，具有AI人格、AGI功能、文字轉圖像、語音、回應串流、代碼突顯和執行、PDF匯入、開發人員預設等功能。部署和贈送#big-AGI-energy！使用Next.js、React、Joy。
 * [RasaGPT](https://github.com/paulpierre/rasagpt) - 💬 RasaGPT是基於Rasa和Langchain構建的第一個無頭LLM聊天機器人平台。使用Rasa、FastAPI、Langchain、LlamaIndex、SQLModel、pgvector、ngrok和telegram構建。
 * [FigmaChain](https://github.com/cirediatpl/figmachain) - FigmaChain 是一組基於 Python 腳本的工具，可以根據 Figma 設計生成 HTML/CSS 代碼。利用 OpenAI 的 GPT-3 模型，FigmaChain 可以讓開發人員從 Figma 設計輸入中快速生成 HTML/CSS 代碼。它還包括一個基於 Streamlit 的聊天機器人界面，用於交互式代碼生成。
 * [gpt4free-ts](https://github.com/xiangsx/gpt4free-ts) - 這是 xtekky/gpt4free 的 TypeScript 版本複製專案。
 * [slack-gpt](https://github.com/martinseanhunt/slack-gpt) - 一個簡單的 Slack 應用程式/機器人啟動器，使用 Langchain、OpenAI 和 Pincone 向量存儲庫來提取問題的答案。
 * [LLM-As-Chatbot](https://github.com/deep-diver/llm-as-chatbot) - LLM作為聊天機器人服務
 * [pdf-chatbot](https://github.com/dissorial/pdf-chatbot) - 自我追蹤數據分析：互動式視覺化和預測算法
 * [ask_chatgpt](https://github.com/railsjazz/ask_chatgpt) - AI 助手 Gem，直接在您的 Rails 控制台中使用。在 Rails 中充分发挥 ChatGPT 的功能。
 * [ecoute](https://github.com/sevask/ecoute) - Ecoute是一個即時轉錄工具，可以為使用者的麥克風輸入（您）和使用者的揚聲器輸出（揚聲器）提供即時轉錄，並在文本框中生成使用OpenAI的GPT-3.5的建議回應，該回應基於對話的即時轉錄。
 * [privateGPT](https://github.com/samuraigpt/privategpt) - 一個使用GPT強大功能與您的文件進行私密互動的應用程式，100％私密，無數據洩漏。
 * [LLaVA](https://github.com/haotian-liu/llava) - 針對多模態GPT-4級別能力建立的大型語言和視覺助手。
 * [OpenChat](https://github.com/openchatai/openchat) - 使用OpenChat運行和創建自定義的ChatGPT樣式機器人，在任何地方嵌入和分享這些機器人，這是一個開源的聊天機器人控制台。
 * [st-chat](https://github.com/ai-yash/st-chat) - Streamlit元件，用於聊天機器人界面
 * [summary-gpt-bot](https://github.com/tpai/summary-gpt-bot) - 一個由人工智慧驅動的 Telegram 文本摘要機器人，可以生成簡潔的文本、URL 和 YouTube 視頻摘要。
 * [Bard-API](https://github.com/dsdanielpark/bard-api) - 這是一個非官方的Python套件，透過Cookie值返回Google Bard的回應。
 * [dialoqbase](https://github.com/n4ze3m/dialoqbase) - 輕鬆創建聊天機器人
 * [Video-ChatGPT](https://github.com/mbzuai-oryx/video-chatgpt) - Video-ChatGPT是一種視頻對話模型，能夠生成有關視頻的有意義對話。它結合了LLMs的能力和預訓練的視覺編碼器，適應於時空視頻表示。
 * [LLaVA-Med](https://github.com/microsoft/llava-med) - 針對生物醫學領域建立的大型語言和視覺助手，具備多模態GPT-4級別的能力。
 * [ethgpt](https://github.com/jiayaoqijia/ethgpt) - 以太坊程式碼庫和文件的聊天機器人。
 * [telegram-chatgpt-bot](https://github.com/sabber-slt/telegram-chatgpt-bot) - 基於NodeJS的ChatGPT機器人現在在Telegram上擁有高級功能，如語音聊天和圖像生成。
 * [chatgpt-telegram-bot](https://github.com/n3d1117/chatgpt-telegram-bot) - 🤖 一個與OpenAI官方ChatGPT API整合的Telegram機器人，使用Python編寫的答案提供者。
 * [ai-chatbot](https://github.com/vercel-labs/ai-chatbot) - 由 Vercel 實驗室打造的全功能、可駭入的 Next.js AI 聊天機器人
 * [autoclear-chatgpt-history](https://github.com/adamlui/autoclear-chatgpt-history) - 🕶️ 為了更好的隱私保護，為ChatGPT添加了聊天自動清除功能
 * [chatgpt-widescreen](https://github.com/adamlui/chatgpt-widescreen) - 🖥️ 為ChatGPT新增了寬螢幕和全螢幕模式，以提供更好的觀賞體驗。
 * [chatgpt-infinity](https://github.com/adamlui/chatgpt-infinity) - ∞ 從全知的ChatGPT（以任何語言）生成無盡的答案！
 * [chatgpt-auto-refresh](https://github.com/adamlui/chatgpt-auto-refresh) - ↻ 保持ChatGPT會話的新鮮度，以避免網絡錯誤+ Cloudflare檢查
 * [chatgpt-apps](https://github.com/adamlui/chatgpt-apps) - 🤖 應用程式利用ChatGPT的驚人能力或增強其使用者體驗
 * [embedchain](https://github.com/embedchain/embedchain) - 一個能夠輕鬆在任何數據集上創建以LLM為動力的機器人的框架。
 * [paper-summarizer](https://github.com/discus0434/paper-summarizer) - 一個由OpenAI LLMs提供支持的用於總結arXiv論文的Slack機器人。
 * [vercel-ai-chatbot](https://github.com/supabase-community/vercel-ai-chatbot) - 一個由Vercel Labs和Supabase打造的功能齊全、Supabaseified的Next.js AI聊天機器人。
 * [llm-inference](https://github.com/aniketmaurya/llm-inference) - 大型語言模型（LLM）推論API和聊天機器人
 * [GPT4Tools](https://github.com/stevengrove/gpt4tools) - GPT4Tools 是一個智能系統，可以自動決定、控制和利用不同的視覺基礎模型，讓使用者在對話中與圖像互動。
 * [Ultimate-ChatGPT](https://github.com/imabutahersiddik/ultimate-chatgpt) - 終極ChatGPT是一個由人工智能驅動的虛擬助手，旨在提供優質的寫作和解決問題體驗。
 * [wechat-gptbot](https://github.com/iuiaoin/wechat-gptbot) - 一個基於ChatGPT的微信機器人，沒有風險，非常穩定！🚀
 * [FeishuBot](https://github.com/rawchen/feishubot) - 飛書群聊/私聊ChatGPT機器人
 * [gradio-chatbot](https://github.com/weaigc/gradio-chatbot) - 一個可以自動將🤗 Huggingface Spaces、魔搭創空間和Gradio ChatBot轉換為免費API的工具。支援GPT4Free、ChatGPT、Llama2、MPT、Falcon Chat、ChatGLM、通義千問等許多類似聊天機器人的空間。
 * [ChatGpt-Web](https://github.com/79e/chatgpt-web) - 使用React搭建的一款商業化ChatGpt網頁應用程式。
 * [word-GPT-Plus](https://github.com/kuingsmile/word-gpt-plus) - Word GPT Plus 是一個將 chatGPT 模型整合到 Microsoft Word 的文字附加元件。它支援官方和網頁 API。
 * [chat-with-your-doc](https://github.com/linjungz/chat-with-your-doc) - 使用LangChain和GPT4/ChatGPT從Azure OpenAI服務和OpenAI，以PDF/PPTX/DOCX格式與您的醫生進行聊天。
 * [OpenAi-ChatGPT-Bot](https://github.com/darkmakerofc/openai-chatgpt-bot) - 由DarkMakerofc（Nima先生）和團隊開發的Open Ai ChatGPT機器人，您可以在Whatsapp上體驗ChatGPT。
 * [opening-up-chatgpt.github.io](https://github.com/opening-up-chatgpt/opening-up-chatgpt.github.io) - 請將以下內容翻譯成繁體中文。Liesenfeld, Andreas, Alianda Lopez和Mark Dingemanse。2023年。“開放ChatGPT：追蹤指導調整文本生成器的開放性、透明度和責任。”在第5屆國際會議上的對話用戶界面。愛因霍芬。doi:10.1145/3571884.3604316。
 * [ChatDrug](https://github.com/chao1224/chatdrug) - ChatGPT用於藥物研發
 * [aks-openai-terraform](https://github.com/azure-samples/aks-openai-terraform) - 本文介紹了如何通過Terraform部署Azure Kubernetes Service（AKS）集群和Azure OpenAI服務，以及如何部署一個使用Azure AD工作負載身份驗證Azure OpenAI並調用ChatGPT模型的Chat Completion API的Terraform聊天機器人。
 * [Robot-GPT](https://github.com/nonejou072/robot-gpt) - 一個基於ROS2和ChatGPT的模擬框架，用於大型模型時代的機器人交互任務。
 * [chatgpt-finetune-ui](https://github.com/anchen1011/chatgpt-finetune-ui) - 簡單的Python WebUI，用於微調ChatGPT（gpt-3.5-turbo）。
 * [poe-api-wrapper](https://github.com/snowby666/poe-api-wrapper) - 👾 一個使用 Httpx 的 Poe.com Python API 封裝程式。使用此封裝程式，您將可以免費使用 ChatGPT、Claude、Llama、Google-PaLM 等等！🚀
 * [llama-gpt](https://github.com/getumbrel/llama-gpt) - 一個自主託管、離線運行的ChatGPT類似聊天機器人。由Llama 2提供動力。100％私密，不會將數據離開您的設備。新增功能：代碼Llama支援！
 * [rotary-gpt](https://github.com/tcz/rotary-gpt) - 我把我的舊式旋轉電話改造成了一個基於ChatGPT的家庭助手，現在你也可以這樣做。
 * [rusty_llama](https://github.com/moonkraken/rusty_llama) - 一個簡單的ChatGPT克隆版本，前端和後端都使用Rust語言開發。使用開源語言模型和TailwindCSS。
 * [GPT_CodeInterpreter](https://github.com/boyueluzhipeng/gpt_codeinterpreter) - 終極且免費的OpenAI提供者，使用Python代碼解釋器和其他多個功能實現，由ChatGPT和GPT-4提供動力！
 * [WebAI-to-API](https://github.com/amm1rr/webai-to-api) - ChatGPT，Claude，Bard to API  : )
 * [chatgpt-minimal](https://github.com/blrchen/chatgpt-minimal) - 使用Next.js和OpenAI Streaming API構建的輕量級ChatGPT聊天機器人。
 * [open_source_chatgpt_list](https://github.com/sunlemuria/open_source_chatgpt_list) - 開放努力實施類似ChatGPT的模型及更多。
 * [chatgpt-dingtalk-robot](https://github.com/sytpb/chatgpt-dingtalk-robot) - 零代碼、一鍵部署chatgpt到釘釘，無須VPN
 * [chatterstack](https://github.com/dschil138/chatterstack) - 輕鬆管理ChatGPT對話變數
 * [PokerGPT](https://github.com/matteo-psnt/pokergpt) - PokerGPT 是一個可以讓你與 ChatGPT-4 一起玩德州撲克的 Poker Discord 機器人。
 * [kitt](https://github.com/livekit-examples/kitt) - 使用LiveKit即時與ChatGPT對話
 * [compose-chatgpt-kotlin-android-chatbot](https://github.com/lambiengcode/compose-chatgpt-kotlin-android-chatbot) - :lion:使用 Kotlin + Jetpack Compose + Coroutine + MVVM + Retrofit2 + OpenAI 的 GPT-3 API 的 Android 聊天機器人。允許從 ChatGPT API 接收流式回應。🤖
 * [Chino-chan-Bot](https://github.com/misonomikadev/chino-chan-bot) - Bot Messenger 被整合了 ChatGPT。
 * [Chatbase](https://github.com/anil-matcha/chatbase) - ChatGPT 適用於每個網站。使用根據您的網站內容訓練的個人化聊天機器人，即時回答您的訪客問題。Chatbase、SiteGPT、Dante AI 的替代方案。
 * [plotai](https://github.com/mljar/plotai) - PlotAI - 您的終極繪圖助手！📊🤖 使用ChatGPT-3.5在Python和Matplotlib中直接創建圖表，可在您的Python腳本或筆記本中使用。
 * [TianMu](https://github.com/openjarvisai/tianmu) - 天幕：一個現代化的AI工具，具有多平台支持、支持markdown、多模態、連續對話和可自定義命令。一個支持文心一言、通義千問、LLaMa、ChatGPT等的開源大模型客戶端！
 * [youtube-summarizer](https://github.com/sabber-slt/youtube-summarizer) - 使用ChatGPT設計的Telegram機器人，用於總結YouTube視頻內容。
 * [ChatGPT-Nuxt](https://github.com/hylarucoder/chatgpt-nuxt) - ChatGPT Web Nuxt 3 Vue 3 版本
 * [FirewaLLM](https://github.com/ysy1216/firewallm) - 通過使用FirewaLLM，用戶在與大型模型互動時可以確保其準確性，同時大大降低隱私洩露的風險。我們相信FirewallLLM是一個保護隱私的ChatGPT互動平台。
 * [Langchain-Chatchat](https://github.com/chatchat-space/langchain-chatchat) - Langchain-Chatchat（原Langchain-ChatGLM）是一款基于Langchain和ChatGLM等语言模型的本地知识库问答应用程序。
 * [wukong-robot](https://github.com/wzpan/wukong-robot) - 🤖 wukong-robot 是一個簡單、靈活、優雅的中文語音對話機器人/智能音箱項目，支持ChatGPT多輪對話能力，還可能是首個支持腦機交互的開源智能音箱項目。
 * [autogen](https://github.com/microsoft/autogen) - 啟用下一代大型語言模型應用程式。加入我們的Discord：https://discord.gg/pAbnFJrkgZ
 * [GPTDiscord](https://github.com/kav-k/gptdiscord) - 一個強大的、全能的Discord GPT界面。ChatGPT風格的對話、圖像生成、AI審核、自定義索引/知識庫、YouTube摘要等等！
 * [BotSharp](https://github.com/scisharp/botsharp) - .NET中的AI代理應用程式框架
 * [anything-llm](https://github.com/mintplex-labs/anything-llm) - 針對開源和封閉源LLMs、嵌入器和向量數據庫的開源ChatGPT等效體驗。支持無限文檔、線程和同時使用者，並在非常乾淨的用戶界面中進行管理。開源ChatGPT等效體驗，適用於開源和封閉源LLMs、嵌入器和向量數據庫。支持無限文檔、線程和同時使用者，並在非常乾淨的用戶界面中進行管理。
 * [magic](https://github.com/polterguy/magic) - 建立一個基於ChatGPT的自定義網站聊天機器人。
 * [rags](https://github.com/run-llama/rags) - 使用您的數據建立自然語言的ChatGPT。
 * [LLamaSharp](https://github.com/scisharp/llamasharp) - 在C#中輕鬆快速地運行LLaMA/GPT模型！🤗 使用LLamaSharp與語義核心、Unity、WPF和WebApp進行集成也很容易。
 * [Open-Custom-GPT](https://github.com/samuraigpt/open-custom-gpt) - 使用助手 API 創建自定義 GPT 並將其添加/嵌入到您的網站上
 * [wechat-ai-summarize-bot](https://github.com/aoao-eth/wechat-ai-summarize-bot) - 微信群聊總結助手 JS 版
 * [webwhiz](https://github.com/webwhiz-ai/webwhiz) - WebWhiz 允許您創建一個 AI 聊天機器人，該機器人對您的產品了如指掌，能夠即時回答客戶的問題。
 * [deep-chat](https://github.com/ovidijusparsiunas/deep-chat) - 完全可定制的網站AI聊天機器人組件
 * [WeChatFerry](https://github.com/lich0821/wechatferry) - 微信逆向，微信機器人，可接入 ChatGPT、ChatGLM、訊飛星火、Tigerbot等大模型。Hook WeChat.
 * [mPLUG-Owl](https://github.com/x-plug/mplug-owl) - 【官方實施】mPLUG-Owl和mPLUG-Owl2：阿里巴巴MLLM家族。
 * [AstrBot](https://github.com/soulter/astrbot) - ⭐ 支援插件的 ChatGPT、Bing、Claude、HuggingChat 機器人，可在 QQ 和 QQ 頻道上使用 | 原 QQChannelChatGPT
 * [casibase](https://github.com/casibase/casibase) - ⚡️具有Web UI和企業SSO的開源LangChain類似的AI知識數據庫⚡️，支持OpenAI、Azure、HuggingFace、OpenRouter、ChatGLM和本地模型，聊天演示：https://ai.casbin.com，管理員門戶演示：https://ai.casibase.com
 * [ai-chatbot](https://github.com/vercel/ai-chatbot) - 一個由Vercel建立的功能齊全、可修改的Next.js AI聊天機器人。
 * [ChatPDF](https://github.com/anil-matcha/chatpdf) - 與任何PDF進行對話。輕鬆上傳您想要對話的PDF文件。即時回答。使用人工智能提問、提取信息並總結文件。包含來源。
 * [OpenAssistantGPT](https://github.com/marcolivierbouch/openassistantgpt) - 一個使用OpenAI API助手建立聊天機器人的開源平台。
 * [ai-research-assistant](https://github.com/lifan0127/ai-research-assistant) - Aria 是由 GPT 大型語言模型提供支援的 AI 研究助手
 * [aidea](https://github.com/mylxsw/aidea) - AIdea 是一款支持 GPT 以及國產大語言模型通義千問、文心一言等，支持 Stable Diffusion 文生圖、圖生圖、 SDXL1.0、超分辨率、圖片上色的全能型 APP。
 * [ChatGPT-weBot](https://github.com/snapdragonlee/chatgpt-webot) - 使用ChatGPT（gpt-3.5或更新版本）進行聊天，基於微信鉤子接口。
 * [vbot](https://github.com/hanson/vbot) - 微信，企微，機器人，企業微信，企微機器人，微信機器人，聚合聊天，RPA，協議，hook，逆向，worktool，ntwork，群發，自動回復，chatgpt，API對接，穩定防封全語言通用，企業定制/SCRM/SAAS專用
 * [org-ai](https://github.com/rksm/org-ai) - Emacs作為您的個人AI助手。使用像ChatGPT或LLaMA這樣的LLM進行文本生成，或使用DALL-E和Stable Diffusion進行圖像生成。還支持語音輸入/輸出。
 * [Linly](https://github.com/cvi-szu/linly) - Chinese-LLaMA 1&2、Chinese-Falcon 基礎模型；ChatFlow中文對話模型；中文OpenLLaMA模型；NLP預訓練/指令微調資料集
 * [gpt-ai-assistant](https://github.com/memochou1993/gpt-ai-assistant) - OpenAI + LINE + Vercel = GPT AI 助手
 * [TS-GPT](https://github.com/dulaiduwang003/ts-gpt) - 基於SpringCloudAlibaba開發的雙向GPT應用程式，包括語音對話、繪圖、圖像識別和文字對話
 * [ChatGPT-YourChatRobot](https://github.com/ashinnotfound/chatgpt-yourchatrobot) - ❤開箱即用❤一個非官方的ChatGPT腾訊qq/微信(非公眾號)實現版，快來把你的qq或微信變成chatgpt吧
 * [wechat-bot](https://github.com/wangrongding/wechat-bot) - 🤖一個基於OpenAi ChatGPT + WeChaty 實現的微信機器人，可以用來幫助你自動回覆微信訊息，或者管理微信群/好友，檢測僵屍粉等...
 * [ChatFred](https://github.com/chrislemke/chatfred) - 使用ChatGPT、DALL·E 2和其他模型的Alfred工作流程，用於聊天、圖像生成等功能。
 * [catai](https://github.com/withcatai/catai) - 使用者介面 (UI) 供🦙模型使用。在本地運行 AI 助手 ✨
 * [ChatGPT-Telegram-Bot](https://github.com/yym68686/chatgpt-telegram-bot) - 🤖️ 一個AI聊天Telegram機器人可以使用Python在Zeabur、fly.io和Replit上由GPT和Claude2.1提供動力進行網絡搜索。
 * [bidara](https://github.com/nasa-petal/bidara) - BIDARA是一個GPT-4聊天機器人，被指示幫助科學家和工程師理解、學習並模仿生物利用生物模仿學研究所的逐步設計過程來創造可持續的設計和技術所使用的策略。
 * [sagittarius](https://github.com/gregsadetsky/sagittarius) - 一個GPT-4/Gemini語音/視頻探索工具
 * [Chat-with-Github-Repo](https://github.com/peterw/chat-with-github-repo) - 這個存儲庫包含兩個Python腳本，演示了如何使用Streamlit、OpenAI GPT-3.5-turbo和Activeloop的Deep Lake創建一個聊天機器人。
 * [pandas-ai](https://github.com/gventuri/pandas-ai) - 與您的數據進行對話（SQL、CSV、pandas、polars、noSQL等）。PandasAI使用LLMs（GPT 3.5 / 4、Anthropic、VertexAI）和RAG使數據分析變得對話式。
 * [chatgpt-mirai-qq-bot](https://github.com/lss233/chatgpt-mirai-qq-bot) - 🚀 一鍵部署！真正的 AI 聊天機器人！支援ChatGPT、文心一言、訊飛星火、Bing、Bard、ChatGLM、POE，多帳號，人設調教，虛擬女僕、圖片渲染、語音發送 | 支援 QQ、Telegram、Discord、微信 等平台
 * [quivr](https://github.com/quivrhq/quivr) - 您的GenAI第二大腦🧠個人生產力助手（RAG）⚡️🤖使用Langchain、GPT 3.5 / 4 turbo、Private、Anthropic、VertexAI、Ollama、LLMs與您的文檔（PDF、CSV等）和應用程序進行對話，您可以與用戶共享！這是一個本地和私人的替代方案，可替代OpenAI GPT和ChatGPT，由檢索增強生成技術驅動。
 * [smalltalk](https://github.com/tinystruct/smalltalk) - 一個基於tinystruct的聊天模組，與@OpenAI GPT-3 / 3.5-turbo / ChatGPT整合。@tinystruct
 * [maid](https://github.com/mobile-artificial-intelligence/maid) - Maid 是一個跨平台的 Flutter 應用程式，用於本地與 GGUF / llama.cpp 模型進行接口，並與 Ollama 和 OpenAI 模型進行遠程接口。
 * [pandas-ai](https://github.com/sinaptik-ai/pandas-ai) - 使用您的數據進行聊天（SQL、CSV、pandas、polars、noSQL等）。PandasAI利用LLMs（GPT 3.5 / 4、Anthropic、VertexAI）和RAG使數據分析變得對話式。
 * [WeChatRobot](https://github.com/lich0821/wechatrobot) - 微信機器人，接入Google Bard、ChatGPT、ChatGLM、訊飛星火、Tigerbot；成語接龍、天氣預報、新聞摘要。
 * [chatgptassistantautoblogger](https://github.com/incomestreamsurfer/chatgptassistantautoblogger) - 這個自動部落客使用GPT助手的API在電子商務網站上自動部落格。
 * [chaty](https://github.com/cosin2077/chaty) - 一行代碼，滿足您所有ChatGPT的想像✨✨✨
 * [wechat-assistant-pro](https://github.com/leochen-g/wechat-assistant-pro) - 智能微秘書，一個全能的微信機器人管理平台，最簡單的方式接入 ChatGPT，FastGPT，Dify知識庫，支持繪圖，聯網查詢，語音識別，各種定時任務，支持企微、個微、公眾號、5G 消息、WhatsApp
 * [ChatGPT-Telegram-Bot](https://github.com/v-know/chatgpt-telegram-bot) - 一個具有流暢人工智慧體驗的Telegram機器人。
 * [nlux](https://github.com/nluxai/nlux) - 用於構建對話式人工智能界面的開源React / Javascript庫
 * [ChatGPT-Line-Bot](https://github.com/theexplainthis/chatgpt-line-bot) - 這是一個允許您將ChatGPT整合到Line中的存儲庫。
 * [langup-ai](https://github.com/jiran214/langup-ai) - AGI 社交網絡 Bot。BiliBili | 直播聊天數字人 | 視頻@自動回覆 | 私信bot | 終端聊天 | 語音交互
 * [customizable-gpt-chatbot](https://github.com/shamspias/customizable-gpt-chatbot) - 使用Django REST框架构建的动态、可扩展的AI聊天机器人，支持从PDF、文档、网站和YouTube视频进行定制培训。利用OpenAI的GPT-3.5、Pinecone、FAISS和Celery实现无缝集成和高性能。
 * [DarkGPT](https://github.com/luijait/darkgpt) - DarkGPT是一個基於GPT-4-200K（建議使用）的OSINT助手，旨在對泄露的數據庫進行查詢，從而提供一個人工智能助手，可以在您的傳統OSINT流程中發揮作用。
 * [Kuebiko](https://github.com/adi-panda/kuebiko) - 一個使用GPT-3和Google Cloud TTS的AI Twitch TTS聊天機器人
 * [AI-Catalog](https://github.com/mehmetkahya0/ai-catalog) - 龐大的人工智慧模型目錄。涵蓋各個領域的人工智慧工具、平台和資源的精心挑選清單。
 * [Multi-Modality-Arena](https://github.com/opengvlab/multi-modality-arena) - 聊天機器人競技場遇上多模態！多模態競技場讓您可以一邊比較視覺語言模型，一邊提供圖像作為輸入。支持MiniGPT-4、LLaMA-Adapter V2、LLaVA、BLIP-2等等！
 * [chatbot](https://github.com/zhaoyingjun/chatbot) - ChatGPT帶火了聊天機器人，主流的趨勢都調整到了GPT類模式，本項目也與時俱進，會在近期更新GPT類版本。基於本項目和自己的語料可以訓練出自己想要的聊天機器人，用於智能客服、在線問答、閒聊等場景。
 * [WechatBotCMD](https://github.com/wechatapis/wechatbotcmd) - 微信機器人WechatBotCMD是一個創新的基於Python 3.11開發的項目，通過結合ChatGPT模型和微信原生API，為用戶提供智能聊天、自動繪畫、自動發朋友圈、自動發視頻號等多樣的API集成服務，旨在提升日常溝通效率和趣味性。
 * [ChatGPT-On-CS](https://github.com/lrhh123/chatgpt-on-cs) - 基於大型模型的智能對話客服工具，支援微信、千牛、哔哩哔哩、抖音企業號、抖音、抖店、微博聊天、小紅書專業號運營、小紅書、知乎等平台接入，可選擇 GPT3.5/GPT4.0/ 懶人百寶箱 （後續會支持更多平台），能處理文本、語音和圖片，通過插件訪問操作系統和互聯網等外部資源，支持基於自有知識庫定制企業 AI 應用。
 * [agentcloud](https://github.com/rnadigital/agentcloud) - Agent Cloud就像擁有自己的GPT建構者，還有許多額外好處。GUI功能包括1）RAG管線，可以原生嵌入260多個數據源2）創建對話應用程序（如GPT）3）創建多代理人流程自動化應用程序（crewai）4）工具。
 * [openlrc](https://github.com/zh-plus/openlrc) - 使用Whisper和LLM（GPT，Claude等）來轉錄、翻譯你的音頻為字幕文件。
 * [wrest-chat](https://github.com/opentdp/wrest-chat) - 微信機器人，PC Wechat Api/Bot/Sdk，內置 WEB 管理界面，可接入GPT、Gemini 、星火、文心、混元 、通義千問等大語言模型
 * [chatbot-app](https://github.com/chatbot-all/chatbot-app) - 擁有自己的移動端 ChatGPT/Gemini 應用程式，支援 GPT3、GPT4 和 Gemini Pro 模型。
 * [ChatGPT-On-CS](https://github.com/cs-lazy-tools/chatgpt-on-cs) - 基於大型模型的智能對話客服工具，支援微信、千牛、哔哩哔哩、抖音企業號、抖音、抖店、微博聊天、小紅書專業號運營、小紅書、知乎等平台接入，可選擇 GPT3.5/GPT4.0/ 懶人百寶箱 （後續會支持更多平台），能處理文本、語音和圖片，通過插件訪問操作系統和互聯網等外部資源，支持基於自有知識庫定制企業 AI 應用。
 * [MOSS](https://github.com/openmoss/moss) - 一個來自復旦大學的開源工具增強對話式語言模型
 * [Wa-OpenAI](https://github.com/sansekai/wa-openai) - WhatsApp 機器人 OpenAI ChatGPT NodeJS 使用 Library Baileys
 * [gpt-assistant-android](https://github.com/skythinker616/gpt-assistant-android) - 免費的ChatGPT API的安卓語音助手，可用音量鍵喚醒並進行語音交流，支持網絡連接、Vision拍照識圖、提問模板等功能。
 * [gpt-home](https://github.com/judahpaul16/gpt-home) - ChatGPT在家中！基本上是一個更好的Google Nest Hub或Amazon Alexa家庭助理。使用Raspberry Pi構建，並使用OpenAI API。
 * [gpt-computer-assistant](https://github.com/onuratakan/gpt-computer-assistant) - gpt-4o 適用於 Windows、macOS 和 Ubuntu
 * [nlux](https://github.com/nlkitai/nlux) - 強大的對話式人工智慧JavaScript程式庫
 * [Streamer-Sales](https://github.com/peterh0323/streamer-sales) - Streamer-Sales 銷冠 —— 賣貨主播 LLM 大模型🛒🎁，一個能夠根據給定的商品特點對商品進行解說並激發用戶的購買意願的賣貨主播模型。🚀⭐內含詳細的數據生成流程❗ 📦另外還集成了 LMDeploy 加速推理🚀、RAG檢索增強生成 📚、TTS文字轉語音🔊
 * [Chatbase-Alternative](https://github.com/anil-matcha/chatbase-alternative) - ChatGPT 適用於每個網站。使用根據您的網站內容訓練的個性化聊天機器人立即回答訪客的問題。Chatbase、SiteGPT、Dante AI 的替代方案。
 * [speak-gpt](https://github.com/andraxdev/speak-gpt) - 基於OpenAI ChatGPT的個人語音助手。
 * [IncarnaMind](https://github.com/junruxiong/incarnamind) - 通過GPT 3.5、GPT-4 Turbo、Claude和本地開源LLMs連接並與您的多個文檔（pdf和txt）進行聊天。
 * [unsaged](https://github.com/jorge-menjivar/unsaged) - 針對與人工智慧模型無縫互動而設計的開源聊天套件。
 * [discord-llm-chatbot](https://github.com/jakobdylanc/discord-llm-chatbot) - llmcord.py • 與朋友們交談LLM！
 * [Instruct2Act](https://github.com/opengvlab/instruct2act) - Instruct2Act：將多模式指令映射到具有大型語言模型的機器人動作
 * [GURU-Ai](https://github.com/guru322/guru-ai) - 一個簡單但複雜的AI聊天機器人，擁有豐富的功能🚩
 * [voxelgpt](https://github.com/voxel51/voxelgpt) - 能夠查詢視覺數據集、搜索FiftyOne文檔並回答一般計算機視覺問題的AI助手
 * [XYBot](https://github.com/henryxiaoyang/xybot) - 基於docker和pywxdll hook注入的微信機器人🤖️！✅高度可自定義！ ✅支持自我編寫插件！非常多的功能：天氣🌤️、獲取新聞📰、ChatGPT聊天🗣️、Hypixel玩家查詢🎮、隨機圖片📷、隨機鏈接🔗、隨機群成員👥、五子棋♟️、簽到✅、查詢積分📊、積分榜🏆、積分轉送💰、積分抽獎🎁、積分紅包🧧等
 * [GPTPortal](https://github.com/zaki-1052/gptportal) - 一個功能豐富的入口，可以通過輕量級的Node.js Web應用程序與GPT-4、Claude、Gemini、Mistral和OpenAI助手API進行聊天；支持可定制的多模式，包括語音、圖片和文件。
 * [CreativeChatGLM](https://github.com/ypwhs/creativechatglm) - 👋 歡迎來到 ChatGLM 創意世界！你可以使用修訂和續寫的功能來生成創意內容！
 * [ChatPilot](https://github.com/shibing624/chatpilot) - ChatPilot: 實現AgentChat對話，支持Google搜索、文件網址對話（RAG）、代碼解釋器功能，復現了Kimi Chat(文件，拖進來；網址，發出來)。
 * [Whatsapp-Ai-BOT](https://github.com/yesbhautik/whatsapp-ai-bot) - 介紹 WhatsApp 的 AI 聊天機器人 - 這是一個由 OpenAI 的 ChatGPT、Playground 和 DALL·E 驅動的尖端解決方案。這款創新的聊天機器人是使用 NodeJS 技術開發的，並利用 AI 領域的最新進展，為用戶提供無與倫比的體驗。
 * [fastui-chat](https://github.com/shroominic/fastui-chat) - 💬 純Python極簡ChatBot界面
 * [pokitoki](https://github.com/nalgeon/pokitoki) - 謙虛的 GPT Telegram 機器人
 * [openai-chat-api-workflow](https://github.com/yohasebe/openai-chat-api-workflow) - 🎩 一個Alfred 5工作流程，用於使用OpenAI Chat API與GPT-3.5/GPT-4進行互動 🤖💬 它還允許圖像生成 🖼️，圖像理解 👀，語音轉文字轉換 🎤，以及文本轉語音合成 🔈
 * [AIUI](https://github.com/lspahija/aiui) - AIUI是一個平台，可以實現與人工智能之間無縫的雙向口語交流。
 * [OPERA](https://github.com/shikiw/opera) - [CVPR 2024 重點] OPERA：通過過度信任處罰和回顧分配減輕多模式大型語言模型中的幻覺
 * [bot-on-anything](https://github.com/zhayujie/bot-on-anything) - 將 ChatGPT、必應、文心一言、谷歌Bard 等對話模型連接各類應用，如微信、公眾號、QQ、Telegram、Gmail、Slack、Web、企業微信、飛書、釘釘等。
 * [psychic](https://github.com/psychic-api/psychic) - 數據整合平台適用於LLM。通過即插即用的授權連接到SaaS工具，並從N個數據來源同步文件，只需一個集成。
 * [gpt-computer-assistant](https://github.com/upsonic/gpt-computer-assistant) - gpt-4o 適用於 Windows、macOS 和 Linux
 * [OpenAssistantGPT](https://github.com/openassistantgpt/openassistantgpt) - 一個社區開源的Saas平台，可用於製作/構建/創建聊天機器人，並使用OpenAI的助手API，您可以將其添加到您的網站上。
 * [ChatGPT](https://github.com/nisabmohd/chatgpt) - 我使用Next.js 14、Shadcn-UI、Prisma ORM開發了一個ChatGPT克隆版本，並將其與OpenAI API集成。它提供了一個用戶友好的對話式人工智能體驗。
 * [ChatGPT-Linebot-using-python-flask-on-vercel](https://github.com/howarder3/chatgpt-linebot-using-python-flask-on-vercel) - 使用Python Flask和Vercel搭建的GPT-Linebot
 * [ComfyUI-GPT_SoVITS](https://github.com/aifsh/comfyui-gpt_sovits) - 一個適用於GPT-SoVITS的comfyui自定義節點！現在您可以在comfyui中進行語音克隆和TTS。
 * [slack-bot](https://github.com/innogames/slack-bot) - 準備好使用的 Slack 機器人，專為懶惰的開發人員設計：啟動 Jenkins 任務，監控 Jira 工單，監控拉取請求，並具有人工智慧支援...
 * [psychic](https://github.com/finic-ai/psychic) - 為LLMs設計的數據集成平台。通過即插即用的身份驗證連接到SaaS工具，並從N個數據源同步文檔，只需一次集成。
 * [repopack](https://github.com/yamadashy/repopack) - 📦 Repopack 是一個強大的工具，可以將您的整個存儲庫打包成一個單一的、適合人工智能的文件。當您需要將代碼庫提供給大型語言模型（LLMs）或其他人工智能工具，如Claude、ChatGPT和Gemini時，這是完美的選擇。
 * [finic](https://github.com/finic-ai/finic) - 為LLMs設計的數據集成平台。通過即插即用的身份驗證連接到SaaS工具，並從N個數據源同步文檔，只需一次集成。
 * [llmcord.py](https://github.com/jakobdylanc/llmcord.py) - 一個支持任何OpenAI兼容API（OpenAI、Mistral、Groq、OpenRouter、ollama、oobabooga、Jan、LM Studio等）的Discord LLM聊天機器人。
 * [django-ai-assistant](https://github.com/vintasoftware/django-ai-assistant) - 將AI助手與Django整合，打造智能應用程式。
 * [MindSQL](https://github.com/mindinventory/mindsql) - MindSQL：一個簡化數據庫交互的Python文本到SQL RAG庫。與PostgreSQL、MySQL、SQLite、Snowflake和BigQuery無縫集成。由GPT-4和Llama 2驅動，可以實現自然語言查詢。支持ChromaDB和Faiss。
 * [insights-bot](https://github.com/nekomeowww/insights-bot) - 一個機器人與OpenAI GPT模型合作，為您的信息流提供洞察。
 * [Babagaboosh](https://github.com/dougdouggithub/babagaboosh) - 與OpenAi的GPT 4進行口語對話的應用程式
 * [wandbot](https://github.com/wandb/wandbot) - wandbot 是一個技術支援機器人，用於 Weights & Biases 的 AI 開發工具，可以在 Discord、Slack、ChatGPT 和 Zendesk 上運行。
 * [ai-data-analysis-MulitAgent](https://github.com/starpig1129/ai-data-analysis-mulitagent) - AI驅動的研究助手：一個先進的多智能體系統，用於自動化複雜的研究過程。利用LangChain、OpenAI GPT和LangGraph，這個工具可以簡化假設生成、數據分析、可視化和報告撰寫。完美。
 * [lobe-vidol](https://github.com/lobehub/lobe-vidol) - 🧸 樂比狄爾 - 讓虛擬偶像為每個人所能接觸
 * [RLAIF-V](https://github.com/rlhf-v/rlaif-v) - RLAIF-V：通過開源AI反饋對齊MLLMs，提高Super GPT-4V的可信度
 * [builderbot](https://github.com/codigoencasa/builderbot) - 🤖 在幾分鐘內創建WhatsApp聊天機器人。加入這個開源項目
 * [hey](https://github.com/lnxpy/hey) - 💬 AI動力對程式設計友！
 * [Auto-Gmail-Creator](https://github.com/ai-to-ai/auto-gmail-creator) - 開源批量自動Gmail創建機器人，使用Selenium和Seleniumwire（Python）。歡迎與我聯繫，涉及Django/Flask、機器學習、人工智慧、GPT、自動化、網絡爬蟲等領域。
 * [design-studio](https://github.com/tiledesk/design-studio) - Tiledesk的開源視覺化、無代碼設計工具，LLM/GPT AI與靈活的“圖形”方法相結合。輕鬆創建對話和自動化 - 是Voiceflow和Botpress的替代方案。
 * [chatgpt-voice](https://github.com/sonngdev/chatgpt-voice) - 與ChatGPT隨意地進行對話。 🔈 🤖 ⚡️
 * [Open-LLaVA-NeXT](https://github.com/xiaoachen98/open-llava-next) - 一個用於訓練LLaVA-NeXT的開源實現。
 * [langchain-chatbot](https://github.com/shashankdeshpande/langchain-chatbot) - 使用Langchain和Streamlit實現聊天機器人的示例
 * [OpsPilot](https://github.com/weops-lab/opspilot) - OpsPilot是WeOps團隊開源的一個基於深度學習與LLM技術的智能運維助理。
 * [whatsapp-ai-bot](https://github.com/zain-ul-din/whatsapp-ai-bot) - 這是一個 WhatsApp AI 機器人，使用各種 AI 模型，包括 Gemini、GPT、DALL-E、Flux 和 StabilityAI，來生成對用戶輸入的回應。
 * [AI-in-a-Box](https://github.com/azure/ai-in-a-box) - AI-in-a-Box利用微軟在全球的專業知識，為技術社區開發和提供人工智能和機器學習解決方案。我們的目的是提供一系列經過精心挑選的解決方案加速器，幫助工程師建立他們的人工智能/機器學習。
 * [Starmoon](https://github.com/starmoonai/starmoon) - 一個開源的語音啟用、緊湊、具有共情能力的人工智慧硬體+軟體🤖框架，用於陪伴、娛樂、教育、兒科護理、物聯網機器人應用、AI增強機器人應用服務、研究和DIY機器人套件開發。
 * [LocalAI](https://github.com/mudler/localai) - 🤖 自由、開源的替代方案，可替代OpenAI、Claude和其他人。自主託管和本地優先。可直接替代OpenAI，在消費級硬件上運行。無需GPU。運行gguf、transformers、diffusers和許多其他模型架構。
 * [bisheng](https://github.com/dataelement/bisheng) - BISHENG是一個開放的LLM devops平台，用於下一代企業AI應用。強大而全面的功能包括：GenAI工作流程、RAG、Agent、統一模型管理、評估、SFT、數據集管理、企業級系統管理。
 * [agency-swarm](https://github.com/vrsen/agency-swarm) - 建立在最新的OpenAI助手API之上的唯一可靠代理框架。
 * [ragflow](https://github.com/infiniflow/ragflow) - RAGFlow 是一個基於深度文件理解的開源 RAG（檢索增強生成）引擎。
 * [LlamaIndexTS](https://github.com/run-llama/llamaindexts) - 為您的LLM應用程序提供數據框架。專注於服務器端解決方案。
 * [repomix](https://github.com/yamadashy/repomix) - 📦 Repomix（原名Repopack）是一個強大的工具，可以將您的整個存儲庫打包成一個單一的、適合人工智能的文件。當您需要將代碼庫提供給大型語言模型（LLMs）或其他人工智能工具，如Claude、ChatGPT和Gemini時，這是完美的選擇。
 * [LangBot](https://github.com/rockchinq/langbot) - 原名 QChatGPT ；😎高穩定性、🧩支持擴展、🦄多模態的 ChatGPT QQ / QQ頻道 / One Bot 機器人🤖 | 支持 OpenAI GPT、Claude、Gemini Pro、DeepSeek、Moonshot（Kimi）、gpt4free、One API、Ollama、dify 的 QQ / QQ頻道 / OneBot 機器人 / Agent 平台
 * [open-im-server](https://github.com/openimsdk/open-im-server) - IM 聊天 ChatGPT
 * [aws-genai-llm-chatbot](https://github.com/aws-samples/aws-genai-llm-chatbot) - 一個模塊化和全面的解決方案，可部署一個由多個LLM和多個RAG驅動的聊天機器人（Amazon Bedrock、Anthropic、HuggingFace、OpenAI、Meta、AI21、Cohere、Mistral），並使用AWS CDK在AWS上運行。
 * [podcastfy](https://github.com/souzatharsis/podcastfy) - 一個開源的Python替代方案，用於NotebookLM的播客功能：將多模式內容轉換為引人入勝的多語音頻對話，與GenAI一起。
 * [multi-agent-orchestrator](https://github.com/awslabs/multi-agent-orchestrator) - 靈活且強大的框架，用於管理多個人工智能代理和處理複雜對話。


## Browser-extensions

 * [chat-gpt-google-extension](https://github.com/wong2/chat-gpt-google-extension) - 免費3DS主要入口點<=11.2
 * [chatgpt-retrieval-plugin](https://github.com/openai/chatgpt-retrieval-plugin) - ChatGPT 檔案檢索插件讓您可以輕鬆地用日常用語提問，搜尋並找到個人或工作文件。
 * [Gepetto](https://github.com/justicerage/gepetto) - IDA插件，可查询OpenAI的gpt-3.5-turbo语言模型，以加速反向工程。
 * [google-chatgpt-plugin](https://github.com/sogody/google-chatgpt-plugin) - @ykdojo 太棒了 @ykdojo！現在已經有 Google Chat GPT 插件了 🤯
 * [natbot](https://github.com/nat/natbot) - 使用GPT-3驅動瀏覽器
 * [DAILA](https://github.com/mahaloz/daila) - 一個反編譯統一插件，可訪問OpenAI API，以提高您的反編譯體驗。
 * [regexplore](https://github.com/0xhasanm/regexplore) - Regexplore 是一個 Volatility 插件，旨在模仿 EZsuite 中的 Registry Explorer 插件的功能。
 * [chat-todo-plugin](https://github.com/lencx/chat-todo-plugin) - ✅ ChatGPT插件，用於管理待辦事項清單
 * [textual](https://github.com/textualize/textual) - Textual是一個Python的快速應用程式開發框架。使用簡單的Python API建立複雜的使用者介面。在終端機和（即將推出的）網頁瀏覽器中運行您的應用程式！
 * [ReconAIzer](https://github.com/hisxo/reconaizer) - 一個Burp Suite擴展，可在Burp上添加OpenAI（GPT），並幫助您進行Bug Bounty的recon，以發現端點，參數，URL，子域名等！
 * [Agent-LLM](https://github.com/josh-xt/agent-llm) - 一個人工智能自動化平台。來自各種提供商的AI指令管理，具有自適應記憶和多功能插件系統，包括網頁瀏覽等多個命令。支持多個AI提供商和模型，每天都在增加支持。
 * [web-llm](https://github.com/mlc-ai/web-llm) - 將大型語言模型和聊天引入網頁瀏覽器。一切都在瀏覽器內運行，無需服務器支持。
 * [langchain-aiplugin](https://github.com/langchain-ai/langchain-aiplugin) - 「langchain作為ai插件」🔥-超酷。@hwchase17 @langchainai這就像是給#chatgpt超能力，因為它現在可以輕鬆地使用langchain組件（代理、鏈等）作為插件。這個存儲庫將很快擴大。例如：檢索qa鏈作為插件。
 * [plugins-quickstart](https://github.com/openai/plugins-quickstart) - 在不到5分鐘內啟用ChatGPT插件！
 * [dangermode](https://github.com/rgbkrk/dangermode) - Dangermode是一個使用Python和FastAPI編寫的ChatGPT插件，它允許ChatGPT在IPython會話中執行代碼片段。
 * [examples](https://github.com/pinecone-io/examples) - 如果你對如何開發chatgpt plugin感興趣，推薦看一下這個視頻，完整的介紹了：1. 什麼是chatgpt plugin2. 如何開發一個langchain文檔查詢的chatgpt plugin3. 如何安裝調試chatgpt plugin視頻：：
 * [chat-gpt-jupyter-extension](https://github.com/jflam/chat-gpt-jupyter-extension) - 一個瀏覽器擴展，讓您可以從任何本地Jupyter筆記本與ChatGPT聊天。
 * [web-stable-diffusion](https://github.com/mlc-ai/web-stable-diffusion) - 將穩定的擴散模型帶到網頁瀏覽器中。一切都在瀏覽器內運行，無需服務器支持。
 * [ipython-gpt](https://github.com/santiagobasulto/ipython-gpt) - ipython-gpt - 一個 Jupyter/IPython 介面，可直接從您的 Jupyter 筆記本或 IPython shell 與 chatgpt 進行聊天的非常有前途的擴展。
 * [tweetGPT](https://github.com/yaroslav-n/tweetgpt) - TweetGPT 是一個 Chrome 擴展程式，使用 chatGPT 生成推文和回覆。
 * [ChatGPT-pdf](https://github.com/liady/chatgpt-pdf) - 一個Chrome擴展，可將您的ChatGPT歷史記錄下載為PNG、PDF或可共享的鏈接。
 * [chatgpt-chrome-extension](https://github.com/gragland/chatgpt-chrome-extension) - 一個 ChatGPT 的 Chrome 擴充功能。將 ChatGPT 整合到網路上的每個文字框中。
 * [summarize.site](https://github.com/clmnin/summarize.site) - 使用OpenAI ChatGPT總結網頁內容
 * [transformers.js](https://github.com/xenova/transformers.js) - 在您的瀏覽器中運行🤗變形金剛！
 * [bob-plugin-openai-translator](https://github.com/yetone/bob-plugin-openai-translator) - 基於 ChatGPT API 的文字翻譯、文字潤色、語法校正 Bob 插件，讓我們一起迎接不需要巴別塔的新時代！
 * [chatgpt-extension](https://github.com/iolivernguyen/chatgpt-extension) - 最小化的 require.js 實現了 CommonJS。
 * [docGPT](https://github.com/cesarhuret/docgpt) - 在Google Docs中直接使用ChatGPT作為編輯器附加元件 📑
 * [ChatGPT-Assistant](https://github.com/pdparchitect/chatgpt-assistant) - 跟手動擴展開發說再見，使用ChatGPT！我使用ChatGPT自動製作了這個擴展。#openai #openaichat
 * [chatGPTBox](https://github.com/josstorer/chatgptbox) - 將ChatGPT深度整合到您的瀏覽器中，您所需的一切都在這裡。
 * [YouTube_Summary_with_ChatGPT](https://github.com/kazuki-sf/youtube_summary_with_chatgpt) - ChatGPT是一個簡單的Chrome擴展程式（manifest v3），可讓您使用OpenAI的ChatGPT AI技術獲取YouTube視頻的文字轉錄和摘要。
 * [simpread](https://github.com/kenshin/simpread) - 簡悅 ( SimpRead ) - 讓你瞬間進入沉浸式閱讀的擴展
 * [chatgpt-wechat-landing-page](https://github.com/1cloudy/chatgpt-wechat-landing-page) - 一個 Chrome 瀏覽器插件，透過 ChatGPT 自動回應微信私信或群聊中 @你 的訊息的智能聊天機器人。
 * [WebGPT](https://github.com/0hq/webgpt) - 使用WebGPU在瀏覽器上運行GPT模型。使用不到2000行的純Javascript實現GPT推理。
 * [tabSidian](https://github.com/cgranier/tabsidian) - tabSidian 可以收集您打開的瀏覽器標籤，並將它們轉換為 Markdown 列表。
 * [chatgpt-advanced](https://github.com/qunash/chatgpt-advanced) - WebChatGPT：一個瀏覽器擴展，可增強您的ChatGPT提示與網絡結果。
 * [chatgpt-vscode](https://github.com/mpociot/chatgpt-vscode) - 一個 VSCode 擴展，讓您可以使用 ChatGPT
 * [openai-translator](https://github.com/yetone/openai-translator) - 基於 ChatGPT API 的劃詞翻譯瀏覽器插件和跨平台桌面端應用 - 基於 ChatGPT API 的翻譯，提供瀏覽器插件和跨平台桌面應用程式。
 * [obsidian-textgenerator-plugin](https://github.com/nhaouari/obsidian-textgenerator-plugin) - 文字生成器是Obsidian的一個方便的插件，它可以幫助您使用GPT-3（OpenAI）生成文本內容。
 * [logseq-plugin-gpt3-openai](https://github.com/briansunter/logseq-plugin-gpt3-openai) - 一個用於在Logseq中使用GPT-3人工智能輔助筆記的插件。
 * [chatgpt-arxiv-extension](https://github.com/hunkimforks/chatgpt-arxiv-extension) - 一個瀏覽器擴充功能，可通過ChatGPT增強搜索引擎。
 * [chatgpt-google-extension](https://github.com/wong2/chatgpt-google-extension) - 一個瀏覽器擴充功能，可通過ChatGPT增強搜索引擎。
 * [nextjs-chatgpt-app](https://github.com/enricoros/nextjs-chatgpt-app) - 💬 响应式聊天應用程式，由OpenAI的GPT-4驅動，具有響應式串流回應、代碼突出顯示和各種開發人員預設。使用Next.js、React和Joy。
 * [sharegpt](https://github.com/domeccleston/sharegpt) - 輕鬆與朋友分享 ChatGPT 對話的永久連結
 * [chatgpt-raycast](https://github.com/abielzulio/chatgpt-raycast) - ChatGPT 射線擴展程式
 * [GPT-Toolbox](https://github.com/cedricguillemet/gpt-toolbox) - VSCode 的 GPT 擴展程式
 * [CodeCursor](https://github.com/helixform/codecursor) - 一個在 Visual Studio Code 中使用游標的擴展程式。
 * [butler.vim](https://github.com/lambdalisue/butler.vim) - 🫖 您的管家。一個像 Vim/Neovim 插件的 ChatGPT，可以與 OpenAI APIs 進行通訊。
 * [AgentGPT](https://github.com/reworkd/agentgpt) - 🤖 在您的瀏覽器中組裝、配置和部署自主 AI 代理。
 * [gpt-assistant](https://github.com/builderio/gpt-assistant) - 一個實驗，讓自主的GPT代理人可以訪問瀏覽器並完成任務。
 * [AutoGPT-Next-Web](https://github.com/dogtiti/autogpt-next-web) - 🤖 在您的瀏覽器中組裝、配置和部署自主 AI 代理。一鍵免費部署您的私人 AutoGPT 網頁應用。
 * [chatgpt-plugin-ts](https://github.com/transitive-bullshit/chatgpt-plugin-ts) - 一切你需要開始使用JS/TS建立ChatGPT插件的材料🔥
 * [whisper_ros](https://github.com/ouxt-polaris/whisper_ros) - 輕聲_ros://t.co/rqb3qulyyo speak_ros_voicevox_plugin、如果有ros2，就可以製作語音對話系統了（由於vad未實現，因此語音識別精度不高）
 * [pg_gpt](https://github.com/cloudquery/pg_gpt) - 實驗性擴展功能，將OpenAI API引入您的PostgreSQL，以人類語言運行查詢。
 * [kubectl-ai](https://github.com/sozercan/kubectl-ai) - ✨ OpenAI GPT 的 Kubectl 插件
 * [ChatGPT_Extension](https://github.com/kazuki-sf/chatgpt_extension) - ChatGPT 擴充功能是一個非常簡單的 Chrome 擴充功能（清單 v3），您可以從網絡上的任何地方訪問 OpenAI 的 ChatGPT。
 * [ChatGPT](https://github.com/wieslawsoltes/chatgpt) - 一個支援MacOS、Windows、Linux、Android、iOS和瀏覽器的ChatGPT C#客戶端，使用Avalonia UI框架。
 * [CodeGPT.nvim](https://github.com/dpayne/codegpt.nvim) - CodeGPT 是一個 neovim 的插件，提供與 ChatGPT 互動的命令。
 * [ChatGPT.nvim](https://github.com/jackmort/chatgpt.nvim) - Neovim 插件，可與 OpenAI GPT-3 聊天機器人互動，提供簡單的界面，探索 GPT-3 和 NLP。
 * [mind-wave](https://github.com/manateelazycat/mind-wave) - 基於ChatGPT API的Emacs AI插件
 * [askgpt.vim](https://github.com/macrat/askgpt.vim) - 一個針對Vim的插件，整合了ChatGPT，讓您可以對您的程式碼提出問題。
 * [ChatGPT-Plugins-Collection](https://github.com/logankilpatrick/chatgpt-plugins-collection) - 一個非官方的ChatGPT插件收集，支援任何編程語言！
 * [burpgpt](https://github.com/aress31/burpgpt) - 一個Burp Suite擴展，集成了OpenAI的GPT，用於進行額外的被動掃描，以發現高度定制的漏洞，並能夠對任何類型的流量進行基於流量的分析。
 * [openai-chatgpt-everywhere-extension](https://github.com/1997roylee/openai-chatgpt-everywhere-extension) - 樣本 CSV 檔案
 * [awesome-chatgpt-plugins](https://github.com/imaurer/awesome-chatgpt-plugins) - 建立和使用ChatGPT插件的有趣資源清單。
 * [Chrome-GPT](https://github.com/richardyc/chrome-gpt) - 一個可以控制您桌面上Chrome的AutoGPT代理。
 * [Auto-GPT-MetaTrader-Plugin](https://github.com/isaiahbjork/auto-gpt-metatrader-plugin) - AutoGPT MetaTrader 插件是一款軟體工具，可讓交易員將其 MetaTrader 4 或 5 交易帳戶連接到 Auto-GPT。
 * [Auto-GPT-Plugins](https://github.com/significant-gravitas/auto-gpt-plugins) - 自動GPT的插件
 * [nextjs-chatgpt-plugin-starter](https://github.com/dabit3/nextjs-chatgpt-plugin-starter) - 使用Next.js的ChatGPT插件起始項目
 * [sftly-replace](https://github.com/kmizu/sftly-replace) - 一個Chrome擴展程序，可以輕鬆替換所選文本
 * [chatgpt-plugin](https://github.com/solana-labs/chatgpt-plugin) - 🧬@Solanalabs已經開發了一個開源的參考實現，用於ChatGPT插件。🧬 #ChatGPT插件的可用性將使#Solana用戶驗證他們的錢包餘額，轉移代幣並獲取NFT。🔽INFO
 * [bmtools](https://github.com/openbmb/bmtools) - BMTools：大型模型的工具學習，ChatGPT-Plugins的開源解決方案，支援BabyAGI和Auto-GPTgithub。
 * [pake](https://github.com/tw93/pake#popular-packages) - 900Month 的 Chrome 擴充功能是由 AngularJS 建立的。
 * [CopilotForXcode](https://github.com/intitni/copilotforxcode) - 缺失的GitHub Copilot和ChatGPT Xcode源代碼編輯器擴展。
 * [gpt-terminal-plugin](https://github.com/etherlegend/gpt-terminal-plugin) - ChatGPT 的通用命令行插件
 * [smartgpt](https://github.com/cormanz/smartgpt) - 一個提供LLMs使用插件完成複雜任務的程式。
 * [chatgpt-plugin](https://github.com/cloudflare/chatgpt-plugin) - 使用Cloudflare的開發者平台建立ChatGPT插件 🤖
 * [QGPTAgent](https://github.com/momaabna/qgptagent) - QGPT代理是一個強大的QGIS插件，利用OpenAI GPT模型的先進自然語言處理能力來自動化QGIS中的各種流程。使用此插件，用戶可以使用自然語言命令與QGIS軟件進行交互，大大減少完成各種任務所需的時間和精力。
 * [dify](https://github.com/langgenius/dify) - 一個API用於插件和數據集，一個界面用於提示工程和視覺操作，所有這些都是為了創建強大的人工智能應用程序。
 * [chatgpt-retrieval-plugin](https://github.com/openai/chatgpt-retrieval-plugin#supabase) - ChatGPT 檔案檢索插件讓您可以用自然語言輕鬆地查找個人或工作文件。
 * [GameDealGenie-ChatGPT-Plugin](https://github.com/cyrisxd/gamedealgenie-chatgpt-plugin) - ChatGPT插件，可從多個商店獲取PC遊戲的最新優惠。由Cheapshark提供支持。
 * [openai-plugin-fastapi](https://github.com/azure-samples/openai-plugin-fastapi) - 在 Scott Guthrie 的主題演講中介紹的 OpenAI 插件示例代碼ChatGPT Plugin Quickstart using Python and FastAPI #MSBuild。
 * [ChatGPT-Plugins-Searchable](https://github.com/banbri/chatgpt-plugins-searchable) - 讓你的 ChatGPT 插件商店支持搜索。https://greasyfork.org/scripts/466901-chatgpt-plugins-searchable
 * [chat-ai-plugin](https://github.com/personoids/chat-ai-plugin) - 「每個聊天中的自主權力」- 將ChatGPT轉化為一個強大的自主代理，可以獨立完成複雜的任務。
 * [github-chatGPT-plugin](https://github.com/jesserweigel/github-chatgpt-plugin) - 一個 ChatGPT 插件，可讓使用者訪問 GitHub。
 * [chatgpt-code-plugin](https://github.com/kesor/chatgpt-code-plugin) - 代碼 ChatGPT 插件是一種 TypeScript 代碼分析器，使 ChatGPT 能夠與您的代碼“交談”。
 * [Auto-GPT-Crypto-Plugin](https://github.com/isaiahbjork/auto-gpt-crypto-plugin) - AutoGPT加密插件是一款軟件工具，可讓交易員將其加密錢包或交易所連接到Auto-GPT。
 * [ChatGPT-Developer-Plugins](https://github.com/samuraigpt/chatgpt-developer-plugins) - 免費運行ChatGPT插件，無需訂閱Plus。
 * [chatgpt-simple-todo-plugin](https://github.com/yoshinorisano/chatgpt-simple-todo-plugin) - 透過這個極簡的程式碼和指示，您可以開始開發 ChatGPT 插件。這是您第一個插件開發的完美範例。
 * [codeexplain.nvim](https://github.com/mthbernardes/codeexplain.nvim) - 一個由GPT4ALL驅動的nvim插件，可進行實時代碼解釋和漏洞檢測（無需互聯網）。
 * [chatgpt-export](https://github.com/yaph/chatgpt-export) - 一個瀏覽器書籤小工具，可將與ChatGPT的對話匯出為Markdown文件。
 * [logseq-chatgpt-plugin](https://github.com/debanjandhar12/logseq-chatgpt-plugin) - 一個緊密集成的Logseq聊天插件。
 * [autogpt-package](https://github.com/kurtosis-tech/autogpt-package) - 就像Auto-GPT遇到了Brew一樣。使用任何您選擇的後端和您可能需要的任何插件，開始使用AutoGPT的最簡單和最快速的方法。
 * [PowerToys4OpenAI](https://github.com/robert-hoffmann/powertoys4openai) - Chrome、Edge 和 Opera 的 GPT 聊天擴展。直接與搜索結果集成。完整的聊天界面，具有歷史管理功能。無需服務器，成本效益高。
 * [napari-chatgpt](https://github.com/royerlab/napari-chatgpt) - 一個使用chatGPT處理和分析圖像的napari插件！
 * [kaguya](https://github.com/ykdojo/kaguya) - 一個 ChatGPT 插件，可以以受控方式載入和編輯本地文件，並運行任何 Python、JavaScript 和 bash 腳本。
 * [duckduckgpt](https://github.com/kudoai/duckduckgpt) - 🐤 DuckDuckGo 的附加元件，將 ChatGPT 的魔力帶到搜尋結果中（由 GPT-4 驅動！）
 * [bravegpt](https://github.com/kudoai/bravegpt) - 🦁 勇敢搜索插件將ChatGPT的魔力帶到搜索結果中（由GPT-4提供動力！）
 * [listennotes-chatgpt-plugin](https://github.com/listennotes/listennotes-chatgpt-plugin) - Listen Notes ChatGPT 插件，用於 AI 強化的播客搜索。由 PodcastAPI.com 和 Cloudflare Pages 提供動力。
 * [chatgpt-github-plugin](https://github.com/carlos-lugo/chatgpt-github-plugin) - 這個存儲庫包含一個與GitHub API交互的ChatGPT插件。它可以獲取有關GitHub存儲庫的信息，包括存儲庫列表、存儲庫中的分支和文件，以及特定文件的內容。
 * [chatgpt-plugin-clerk-auth](https://github.com/eidam/chatgpt-plugin-clerk-auth) - 使用 Cloudflare Workers 和 Clerk OAuth2 後端的 ChatGPT 插件示例。
 * [vscode-i-dont-care-about-commit-message](https://github.com/mefengl/vscode-i-dont-care-about-commit-message) - 又一个AI git提交插件，但无需手动确认。
 * [openai-translator](https://github.com/openai-translator/openai-translator) - 基於 ChatGPT API 的劃詞翻譯瀏覽器插件和跨平台桌面端應用 - 基於 ChatGPT API 的翻譯瀏覽器插件和跨平台桌面應用。
 * [ais-ninja](https://github.com/jarvis2f/ais-ninja) - 一個支援插件的 ChatGPT。TG：https://t.me/+bIZncGryj_85MjYx
 * [openplugin](https://github.com/cakecrusher/openplugin) - 通過API（或客戶端）與OpenAI的ChatGPT插件無縫集成，提供與ChatGPT api + 插件相同的強大功能！
 * [continue](https://github.com/continuedev/continue) - ⏩ 軟體開發的開源自動駕駛系統 - 一個將 ChatGPT 強大功能帶入您的 IDE 的 VS Code 擴展。
 * [GPT-Plugins](https://github.com/targed/gpt-plugins) - GPT-Plugins 是一個 GitHub 存儲庫，它作為一個全面的插件、附加組件和擴展列表，為 ChatGPT 提供服務，同時也兼容 GPT 架構的其他語言模型。
 * [web5-chatgpt-plugin](https://github.com/tbd54566975/web5-chatgpt-plugin) - 一個 ChatGPT 插件，為 ChatGPT 添加了 web5 代碼協助和知識。
 * [chatgpt-plugin](https://github.com/e2b-dev/chatgpt-plugin) - ChatGPT的代碼解釋器強化版。運行任何語言，任何終端進程，自由使用文件系統。同時具有網絡訪問功能。
 * [awesome-chatgpt-plugins](https://github.com/highwayoflife/awesome-chatgpt-plugins) - ChatGPT Plus 中所有可用的 ChatGPT 插件的精選清單，包括詳細描述和使用文檔，以及非官方的插件來源。
 * [meeper](https://github.com/pas1ko/meeper) - Meeper 📝 - 是您在瀏覽器中進行任何會議的秘書。
 * [codesherpa](https://github.com/iamgreggarcia/codesherpa) - 一個程式碼解譯器和ChatGPT插件
 * [ethgpt](https://github.com/xinbenlv/ethgpt) - ChatGPT Plugin for Ethereum 和 EVM dApp / 智能合約功能
 * [GodMode](https://github.com/smol-ai/godmode) - AI聊天瀏覽器：快速、完整的網頁應用程式，可存取ChatGPT / Claude / Bard / Bing / Llama2！我每天使用這個20次。
 * [Image-To-Text-OCR-extension-for-ChatGPT](https://github.com/tshetrim/image-to-text-ocr-extension-for-chatgpt) - 圖像轉文字（OCR）ChatGPT Chrome 擴展程式
 * [search-recommendations](https://github.com/niemingxing/search-recommendations) - 搜索推薦詞采集與內容生成助手是一款強大的Chrome插件，專為小紅書、抖音、B站、知乎、百度、google用戶設計。它能夠自動收集並顯示這些平台的搜索推薦詞或聯想詞，保存下載為csv文件，幫助您更輕鬆地進行搜索、瀏覽和發現感興趣的內容。同時可以利用chatgpt自動化批量生產與采集內容發布到wordpress站點。
 * [openai.mini](https://github.com/llmapp/openai.mini) - 實現使用OpenAI API和支援插件的ChatGPT，並使用開源LLM和其他模型。
 * [openplugin](https://github.com/openpluginaci/openplugin) - 通過API（或客戶端）與OpenAI的ChatGPT插件無縫集成，提供與ChatGPT api + 插件相同的強大功能！
 * [chatgpt-desktop](https://github.com/inplex-sys/chatgpt-desktop) - 在 Windows 上的 ChatGPT 中包含 AIPRM（供無法在 Firefox 上安裝的人使用）
 * [superpower-chatgpt](https://github.com/saeedezzati/superpower-chatgpt) - 具有超能力的ChatGPT！搜索聊天記錄，建立文件夾，導出所有聊天，置頂訊息，訪問數千個社群提示，隱身模式，語言和語氣選擇，以及更多功能。
 * [show-me-chatgpt-plugin](https://github.com/bra1ndump/show-me-chatgpt-plugin) - 在ChatGPT中創建和編輯圖表
 * [ChatGPT-Plugins](https://github.com/serp-ai/chatgpt-plugins) - 用於讓ChatGPT具備網頁瀏覽、Python程式碼執行和自定義插件功能的存儲庫
 * [ChatIDE](https://github.com/yagil/chatide) - 在您的IDE中的AI編碼助手 - ChatGPT（OpenAI）和Claude（Anthropic）在VSCode擴展中。
 * [vim-chatgpt](https://github.com/codercooke/vim-chatgpt) - Vim 插件用於 ChatGPT
 * [obsidian-weaver](https://github.com/vasilecampeanu/obsidian-weaver) - Weaver 是一個有用的 Obsidian 插件，將 ChatGPT/GPT-3 整合到您的筆記工作流程中。這個插件使得在 Obsidian 中輕鬆訪問 AI 生成的建議和見解，有助於改善您的寫作和腦力激盪過程。
 * [chatgpt-plugins](https://github.com/copilot-us/chatgpt-plugins) - 官方 ChatGPT 插件🧩
 * [auto-chatgpt](https://github.com/ryuseisan/auto-chatgpt) - 自動化與ChatGPT的瀏覽器版本互動。
 * [chatlab](https://github.com/rgbkrk/chatlab) - 將 ChatGPT 插件帶入您的筆記本
 * [paperchat](https://github.com/forward-operators/paperchat) - 請將以下內容翻譯成繁體中文。PaperChat - 用於查詢arXiv數據集的cli、API和ChatGPT插件
 * [chatgpt-microphone](https://github.com/davidmvenegas/chatgpt-microphone) - 將語音轉文字和快捷片段添加到ChatGPT
 * [github-chatgpt-plugin](https://github.com/aavetis/github-chatgpt-plugin) - ChatGPT插件可與GitHub上的任何內容進行互動。從ChatGPT插件商店安裝“Chat With Code”。ChatGPT插件可與GitHub上的任何內容進行互動。從ChatGPT插件商店安裝“Chat With Code”。
 * [eclipse-chatgpt-plugin](https://github.com/gradusnikov/eclipse-chatgpt-plugin) - 一個與ChatGPT整合的Eclipse插件
 * [automatic-chatgpt-dan](https://github.com/madkarmaa/automatic-chatgpt-dan) - 瀏覽器使用者腳本，可自動將DAN訊息發送到ChatGPT。
 * [sk-nl2ef-plugin](https://github.com/anthonypuppo/sk-nl2ef-plugin) - 一個使用語義核心構建的ChatGPT插件，可以通過自然語言查詢數據庫。該插件在微軟首屆語義核心黑客松比賽中獲得了"對企業最有用"類別的冠軍。
 * [Awesome-Plugins](https://github.com/targed/awesome-plugins) - Awesome-Plugins 是一個 GitHub 存儲庫，它作為一個全面的插件、附加組件和擴展列表，為 ChatGPT 提供支持，同時也支持與 GPT 架構兼容的其他語言模型。
 * [Free-personal-AI-Assistant-with-plugin](https://github.com/intelligenzaartificiale/free-personal-ai-assistant-with-plugin) - 🤗 您想使用帶有插件的GPT4，但不想支付每月20美元嗎？這就是解決方案！通過這個存儲庫，您可以免費獲得ChatGPT的克隆版本。
 * [LeanDojoChatGPT](https://github.com/lean-dojo/leandojochatgpt) - ChatGPT 在 Lean 中的定理证明插件
 * [awesome-chatgpt-plugins](https://github.com/jikkujose/awesome-chatgpt-plugins) - 最全面的ChatGPT插件列表，全部在一個頁面上！
 * [gp.nvim](https://github.com/robitx/gp.nvim) - GPT.nvim：Neovim AI 插件 〜 OpenAI 的 ChatGPT＆Copilot＆語音轉文字
 * [LLMBot](https://github.com/llmkira/llmbot) - 插件概念原型機 /// Agents System/自決策 |類 ChatGpt 插件系統| Gpt-3.5/Gpt-4 |助手 | 📱 跨平台 | 🦾 非同步 | 🔌 插件系統
 * [bob-plugin-openai-translator](https://github.com/openai-translator/bob-plugin-openai-translator) - 基於 ChatGPT API 的文本翻譯、文本潤色、語法糾錯 Bob 插件，讓我們一起迎接不需要巴別塔的新時代！根據 CC BY-NC-SA 4.0 授權。
 * [Openaibot](https://github.com/llmkira/openaibot) - ⚡️ 建立您自己的助理机器人 | 🧀 Discord/Slack/Kook/Telegram | 🍓 複製 ChatGpt 架構 | ⛓ 工具呼叫/函數呼叫 | 🔖 插件支援 | 🌻 sh 和 docker-compose
 * [LibreChat](https://github.com/danny-avila/librechat) - 增強版ChatGPT克隆：功能包括OpenAI、Bing、Anthropic、OpenRouter、PaLM 2、AI模型切換、訊息搜尋、語言鏈、DALL-E-3、ChatGPT插件、OpenAI功能、安全多用戶系統、預設值，完全開源以供自行託管。更多功能正在開發中。
 * [pgvecto.rs](https://github.com/tensorchord/pgvecto.rs) - 可擴展的矢量數據庫插件，用Rust編寫，專為LLM設計。
 * [AI-Prompt-Genius](https://github.com/benf2004/ai-prompt-genius) - 精心策劃一個自定義的AI提示圖書館
 * [Ebook-Translator-Calibre-Plugin](https://github.com/bookfere/ebook-translator-calibre-plugin) - 一個Calibre插件，可以將電子書翻譯成指定的語言。
 * [WPeChatGPT](https://github.com/wpeace-hch/wpechatgpt) - 一個用於IDA的插件，可以幫助分析二進制文件，它基於OpenAI訓練的gpt-3.5-turbo模型，與ChatGPT相同。
 * [chatgpt-plugin](https://github.com/ikechan8370/chatgpt-plugin) - 雲崽qq機器人的chatgpt插件
 * [chatgpt-google-summary-extension](https://github.com/sparticleinc/chatgpt-google-summary-extension) - Chrome 擴充功能，可在 Google 搜尋結果和 YouTube 影片旁邊查看 ChatGPT 摘要，同時也支援 Yahoo! ニュース、PubMed、PMC、NewsPicks、Github、Nikkei、Bing、Google 專利，以及任何頁面的摘要。
 * [CodeGPT](https://github.com/carlrobertoh/codegpt) - JetBrains擴展提供免費使用最先進的LLM，如GPT-4、Code Llama等等。JetBrains擴展提供免費使用最先進的LLM，如GPT-4、Code Llama等等。
 * [ReadSomething](https://github.com/readsomething/readsomething) - 📖 一個開源的 Chrome 插件，可以將網頁轉成閱讀模式，並且內置了 AI 總結、翻譯、Markdown 轉換等功能。
 * [writely](https://github.com/anc95/writely) - ❤️‍🔥 一個超越 Notion AI 的替代品的 Chrome 擴充功能。
 * [CoDeveloperGPTengine](https://github.com/stoerr/codevelopergptengine) - 共同開發者GPT引擎：為開發者創建ChatGPT插件，允許讀取/搜索/寫入文件，執行（構建）操作
 * [neoai.nvim](https://github.com/bryley/neoai.nvim) - Neovim 插件，用於與 OpenAI 的 GPT 模型進行互動。
 * [nonebot_plugin_naturel_gpt](https://github.com/kromiose/nonebot_plugin_naturel_gpt) - 一個基於NoneBot框架的Ai聊天插件，對接OpenAi文本生成接口，實現了機器人的人格自定義/切換，聊天記憶等功能。
 * [vim-ai](https://github.com/madox2/vim-ai) - AI 助手為 Vim 提供代碼支援。OpenAI 和 ChatGPT 插件適用於 Vim 和 Neovim。
 * [AI-Employe](https://github.com/vignshwarar/ai-employe) - 創建瀏覽器自動化，就像您在使用GPT-4 Vision教導人類一樣。
 * [raycast-openai-translator](https://github.com/openai-translator/raycast-openai-translator) - 基於 ChatGPT API 的 Raycast 翻譯插件 - 基於 ChatGPT API 的 Raycast 翻譯插件。
 * [AI-Prompt-Genius](https://github.com/ai-prompt-genius/ai-prompt-genius) - 精心策劃一個定制的AI提示圖書館
 * [supermemory](https://github.com/dhravya/supermemory) - 用超级记忆力建立您自己的第二大脑。这是您书签的ChatGPT。使用Chrome扩展程序导入推文或保存网站和内容。
 * [OpenCharacters](https://github.com/josephrocca/opencharacters) - 一個簡單的小型網頁界面，用於創建角色並與他們聊天。基本上是一個單獨的HTML文件 - 沒有伺服器。使用連結分享角色（角色數據存儲在URL本身中）。所有聊天數據都存儲在您的瀏覽器中，使用Indexed。
 * [py-gpt](https://github.com/szczyglis-dev/py-gpt) - 由GPT-4、GPT-4 Vision、GPT-3.5、DALL-E 3、Langchain、Llama-index驅動的桌面AI助手，具備聊天、視覺、圖像生成和分析、自主代理、代碼和命令執行、文件上傳和下載、語音合成和識別、網頁訪問功能。
 * [chatgpt-to-notion](https://github.com/l-a-r-t/chatgpt-to-notion) - ChatGPT to Notion 將 ChatGPT 的智慧帶入您的 Notion 工作區！
 * [neural](https://github.com/dense-analysis/neural) - AI Vim/Neovim 代碼生成插件（OpenAI、ChatGPT 等）
 * [Sophia](https://github.com/kyegomez/sophia) - 輕鬆插件和播放優化器，可將模型訓練成本降低50%。新的優化器比Adam在LLMs上快2倍。
 * [ChatGPT-Gnome-Desktop-Extension](https://github.com/horrorpills/chatgpt-gnome-desktop-extension) - ChatGPT 圖形桌面擴展 | 從您的選單欄與 ChatGPT 對話！
 * [privacy-settings](https://github.com/stellarsand/privacy-settings) - 大多數主要軟件和服務的隱私設置指南。
 * [nonebot-plugin-bilichat](https://github.com/well2333/nonebot-plugin-bilichat) - 一個透過 OpenAI 來對b站視頻進行總結的多功能 B站解析插件
 * [Raycast-Easydict](https://github.com/tisfeng/raycast-easydict) - 一個用於輕鬆查詞或翻譯文本的Raycast擴展。支持48種以上語言，支持Linguee和Youdao詞典，支持OpenAI、DeepL、Google、Bing、蘋果、百度、騰訊、火山、有道和彩雲翻譯。
 * [model.nvim](https://github.com/gsuuon/model.nvim) - Neovim插件，用於與LLM互動並構建編輯器集成提示。
 * [BrowserGPT](https://github.com/mayt/browsergpt) - 使用GPT指令控制您的瀏覽器
 * [VisualChatGPTStudio](https://github.com/jeffdapaz/visualchatgptstudio) - 將chatGPT功能直接添加到Visual Studio
 * [crawlee-python](https://github.com/apify/crawlee-python) - Crawlee-一個用於Python的網頁爬蟲和瀏覽器自動化庫，用於構建可靠的爬蟲。從網站提取數據，用於AI、LLMs、RAG或GPTs。從網站下載HTML、PDF、JPG、PNG和其他文件。與BeautifulSoup、Playwright和原始HTTP一起使用。支持headless模式。
 * [supermemory](https://github.com/supermemoryai/supermemory) - 用超級記憶力建立您自己的第二大腦。這是您書籤的ChatGPT。使用Chrome擴展程序導入推文或保存網站和內容。
 * [Auto-GPT-Plugin-Template](https://github.com/significant-gravitas/auto-gpt-plugin-template) - 開發自己的Auto-GPT插件的起點
 * [joplin-plugin-jarvis](https://github.com/alondmnt/joplin-plugin-jarvis) - Joplin（筆記）助手運行一個非常智能的系統（OpenAI/GPT、Hugging Face、Gemini、Llama、Universal Sentence Encoder等）。
 * [ChatLLM-Web](https://github.com/ryan-yang125/chatllm-web) - 🗣️ 在您的浏览器中完全与Vicuna一样与LLM聊天，使用WebGPU安全、私密且无需服务器。由web llm 提供支持。
 * [raycast-g4f](https://github.com/xinthedark/raycast-g4f) - 將Raycast擴展使用GPT-4、Llama-3等等...全部免費。無需API密鑰！
 * [bob-plugin-openai-polisher](https://github.com/openai-translator/bob-plugin-openai-polisher) - 使用 OpenAI API 給文本進行潤色和語法校正的 Bob 插件！完美代替 Grammarly！根據 CC BY-NC-SA 4.0 授權。
 * [GPT-Prompter](https://github.com/giosilvi/gpt-prompter) - 瀏覽器擴展，可快速獲取OpenAI的GPT-3、GPT-4和ChatGPT API的提示（所選文本）。在Chrome網上商店和Firefox瀏覽器附加元件中提供。
 * [web-llm-chat](https://github.com/mlc-ai/web-llm-chat) - 與在您的瀏覽器原生運行的AI大型語言模型聊天。享受私密、無服務器、無縫的AI對話。
 * [chatgpt-advanced](https://github.com/interstellard/chatgpt-advanced) - WebChatGPT：一款瀏覽器擴展，可通過網絡搜索結果增強您的ChatGPT提示。
 * [linkedIn_auto_jobs_applier_with_AI](https://github.com/feder-cr/linkedin_auto_jobs_applier_with_ai) - LinkedIn_AIHawk 是一個工具，可以自動化在 LinkedIn 上的工作申請流程。利用人工智能，它使用者可以以自動化和個性化的方式申請多個工作機會。
 * [Plugin-VoiceGPT](https://github.com/wstxda/plugin-voicegpt) - 使用ChatGPT代替Google助手
 * [codecompanion.nvim](https://github.com/olimorris/codecompanion.nvim) - ✨ 在Neovim中的Copilot Chat體驗，配有內置助手。支持Anthropic、Gemini、Ollama和OpenAI LLMs。
 * [open-assistant-api](https://github.com/mlt-oss/open-assistant-api) - Open Assistant API 是一個即用即棄、開源、自主託管的代理/ gpts 編排創建框架，支持 LLM、RAG、函數調用和工具功能的定制擴展。它還支持與 openai/lang 的無縫集成。
 * [parrot.nvim](https://github.com/frankroeder/parrot.nvim) - 鸚鵡.nvim 🦜 - 將隨機鸚鵡帶入 Neovim 的插件。這是一個專注於簡潔的 gp.nvim 分支。
 * [ChatGPTWizard](https://github.com/alidehbansiahkarbon/chatgptwizard) - Embarcadero RAD Studio IDE XE5至12.1的ChatGPT、WriteSonic、YouChat和Ollama（離線）插件。https://getitnow.embarcadero.com/chatgptwizard
 * [Auto_Jobs_Applier_AIHawk](https://github.com/feder-cr/auto_jobs_applier_aihawk) - Auto_Jobs_Applier_AIHawk 是一個自動化工作申請流程的工具。利用人工智能，它使用者可以以自動化和個性化的方式申請多個工作機會。
 * [ai-commits-intellij-plugin](https://github.com/blarc/ai-commits-intellij-plugin) - AI Commits for IntelliJ based IDEs/Android Studio.人工智慧提交，適用於IntelliJ基於的IDEs/Android Studio。
 * [ogpt.nvim](https://github.com/huynle/ogpt.nvim) - 與Ollama/Huggingface/TextGen/OpenAI/Gemini/Anthropic GPT Neovim插件聊天：輕鬆使用LLM API進行自然語言生成
 * [ChatGPTToolkitExtension](https://github.com/doggy8088/chatgpttoolkitextension) - 提升 ChatGPT, Gemini, Claude, phind, Groq 網站的使用體驗，提供一些好用功能。像是自動從 URL 填入提示、在回應的地方出現自動提示按鈕。
 * [LLM_Web_search](https://github.com/mamei16/llm_web_search) - 一個為oobabooga/text-generation-webui擴展的功能，使LLM能夠使用DuckDuckGo搜索網絡。
 * [DevoxxGenieIDEAPlugin](https://github.com/devoxx/devoxxgenieideaplugin) - DevoxxGenie 是一個用於 IntelliJ IDEA 的插件，使用本地的 LLM（Ollama、LMStudio、GPT4All、Llama.cpp 和 Exo）和基於雲端的 LLM 來幫助審查、測試、解釋您的項目代碼。
 * [AGiXT](https://github.com/josh-xt/agixt) - AGiXT是一個動態的AI代理自動化平台，可以無縫地協調指令管理和複雜任務執行，跨越不同的AI提供商。結合適應性記憶、智能功能和多功能插件系統，AGiXT提供高效的。
 * [AutoGPT-Next-Web](https://github.com/connectai-e/autogpt-next-web) - 🤖 在您的浏览器中组装、配置和部署自主AI代理。一键免费部署您的私人AutoGPT网页应用。
 * [Auto_Jobs_Applier](https://github.com/aihawk-app/auto_jobs_applier) - Auto_Jobs_Applier_AIHawk 是一個自動化工作申請流程的工具。利用人工智能，它使用者可以以自動化和個性化的方式申請多個工作。
 * [browser-use](https://github.com/gregpr07/browser-use) - 開源網頁自動化庫與任何LLM
 * [Auto_Jobs_Applier](https://github.com/aihawk-co/auto_jobs_applier) - Auto_Jobs_Applier由AIHawk開發，是一個自動化工作申請流程的代理商。利用人工智能，它使用戶能夠以自動化和個性化的方式申請多個工作。
 * [Auto_Jobs_Applier_AI_Agent](https://github.com/aihawk-co/auto_jobs_applier_ai_agent) - Auto_Jobs_Applier_AI_Agent由AIHawk開發，是一個自動化工作申請流程的AI代理人。利用人工智能，它使用者可以以自動化和個性化的方式申請多個工作。
 * [zsh_codex](https://github.com/tom-doerr/zsh_codex) - 這是一個 ZSH 插件，可以讓您在命令行中使用 OpenAI 的 Codex AI。
 * [pipelines](https://github.com/open-webui/pipelines) - 管道：多功能、UI不可知的OpenAI兼容插件框架
 * [aura-voice](https://github.com/ntegrals/aura-voice) - Aura就像Siri一樣，但在您的瀏覽器中。一個針對低延遲響應進行優化的人工智能語音助手。


## CLIs

 * [ChatGPT](https://github.com/acheong08/chatgpt) - 反向工程 ChatGPT API
 * [shell_gpt](https://github.com/ther1d/shell_gpt) - 一個由ChatGPT驅動的命令行生產力工具，將幫助您更快更有效地完成任務。
 * [PyChatGPT](https://github.com/rawandahmad698/pychatgpt) - ⚡️ Python 客戶端，用於非官方 ChatGPT API，具有自動令牌再生、對話追踪、代理支持等功能。
 * [chatgpt-wrapper](https://github.com/mmabrouk/chatgpt-wrapper) - 使用Python和Shell與ChatGPT和GPT4互動的API。
 * [chatblade](https://github.com/npiv/chatblade) - 一個用於ChatGPT的CLI瑞士軍刀
 * [Alice](https://github.com/greshake/alice) - 授予 ChatGPT 使用真實終端機的權限
 * [command-ai](https://github.com/amachino/command-ai) - 由OpenAI API驅動的終端AI聊天機器人
 * [GPT_Vuln-analyzer](https://github.com/morpheuslord/gpt_vuln-analyzer) - 使用ChatGPT API、Python-Nmap、DNS Recon模組，並使用GPT3模型根據Nmap掃描數據和DNS掃描信息創建漏洞報告。它還可以大量執行子域列舉。
 * [shell-genie](https://github.com/dylanjcastillo/shell-genie) - 你的願望就是我的命令。
 * [DirectAI](https://github.com/ustayready/directai) - 在您的終端機中通過OpenAI API查詢ChatGPT。
 * [GPTalk](https://github.com/0ut0flin3/gptalk) - 支援任何語言的文字和語音，具有記憶管理功能的 Windows 和 Unix GPT-3 客戶端。
 * [Reptyl](https://github.com/0ut0flin3/reptyl) - 跨平台命令行外殼，支援以自然語言執行命令。
 * [wanna](https://github.com/hirokidaichi/wanna) - 具有自然語言的Shell命令啟動器
 * [datasetGPT](https://github.com/radi-cho/datasetgpt) - 一個命令行界面，可生成帶有LLMs的文本和對話數據集。
 * [chatgpt-cli](https://github.com/j178/chatgpt-cli) - 饭否机器人
 * [engshell](https://github.com/emcf/engshell) - 由LLMs驅動的任何操作系統的英語外殼
 * [node-chatgpt-api](https://github.com/waylaidwanderer/node-chatgpt-api) - 一個用於 ChatGPT 和 Bing AI 的客戶端實現。可用作 Node.js 模塊、REST API 服務器和 CLI 應用程序。
 * [chat-gpt-cli](https://github.com/jseguillon/chat-gpt-cli) - PhantomJS QUnit測試運行器，可將結果導出為JUnit XML格式，並將覆蓋率導出為Cobertura XML格式，以與Jenkins等CI工具一起使用。
 * [terminalGPT](https://github.com/jucasoliveira/terminalgpt) - 在您的終端機上獲取像 chatGPT 一樣的 GPT
 * [chatgpt-gsheets](https://github.com/amrrs/chatgpt-gsheets) - 【新消息】#chatgpt現已在表格中！🤯只需幾個點擊，即可在@googlesheets中整合#chatgpt #api，@1littlecoder向您展示如何操作！用途：#seo，#socialmedia，#marketing，應有盡有！🔥- 教程：code：cost：$2/百萬令牌！🙃
 * [gptsh](https://github.com/shorwood/gptsh) - GPT.sh 是一個使用 NodeJs 構建的 CLI 工具，由 Open AI 的 GPT-3 驅動。它的主要目的是將自然語言問題和請求轉換為 shell 命令。
 * [chatgpt-api](https://github.com/transitive-bullshit/chatgpt-api) - 官方ChatGPT API的Node.js客戶端。🔥
 * [ChatGPT-Next-Web](https://github.com/yidadaa/chatgpt-next-web) - 一鍵擁有你自己的 ChatGPT 網頁服務。
 * [ai-cli](https://github.com/abhagsain/ai-cli) - 從您的終端機直接從GPT3獲取CLI命令的答案
 * [chathub](https://github.com/chathub-dev/chathub) - 全能聊天機器人客戶端
 * [bing-chat](https://github.com/transitive-bullshit/bing-chat) - Bing的新AI動力搜索的Node.js客戶端。就像ChatGPT加強版🔥一樣。
 * [aicommits](https://github.com/nutlope/aicommits) - 一個使用人工智慧為您撰寫 Git 提交訊息的 CLI
 * [opencommit](https://github.com/di-sukharev/opencommit) - 使用GPT CLI在1秒內自動生成令人印象深刻的提交🤯🔫
 * [react-native-chatgpt](https://github.com/rgommezz/react-native-chatgpt) - 一個React Native封裝ChatGPT的工具，可以無縫地將其與您的應用程序集成。它處理身份驗證、流式響應和跟踪對話。100％客戶端 :robot:
 * [GPT-Shell](https://github.com/firtoz/gpt-shell) - GPT-Shell是一個基於OpenAI的聊天機器人，類似於OpenAI的ChatGPT。還可以創建Dalle2圖像。
 * [autodoc](https://github.com/context-labs/autodoc) - 使用LLMs自動生成程式庫文件的實驗工具箱
 * [commit-assist](https://github.com/dejorrit/commit-assist) - 使用ChatGPT自動生成提交訊息
 * [ai-shell](https://github.com/builderio/ai-shell) - 一個將自然語言轉換為Shell命令的CLI。
 * [doschgpt](https://github.com/yeokm1/doschgpt) - 一個用於DOS的ChatGPT客戶端的概念驗證。
 * [gptcommit](https://github.com/zurawiki/gptcommit) - 一個使用GPT-3撰寫提交訊息的git prepare-commit-msg鉤子。
 * [a](https://github.com/ddddddeon/a) - 從GPT3生成代碼的CLI工具
 * [plz-cli](https://github.com/m1guelpf/plz-cli) - 您的終端機副駕駛員
 * [aichat](https://github.com/sigoden/aichat) - 在終端機中使用ChatGPT/GPT-3.5/GPT-4。
 * [rusty](https://github.com/zahidkhawaja/rusty) - GPT-3 引擎驅動的 CLI 工具，可幫助您記住 bash 命令。
 * [cligpt](https://github.com/schneiderfelipe/cligpt) - cligpt 是一個命令行界面，用於與 OpenAI 的 ChatGPT API 進行交互。
 * [ata](https://github.com/rikhuijzer/ata) - 在終端機上問任何問題（ATA）：在終端機上輸入ChatGPT
 * [acli](https://github.com/jseguillon/acli) - 輔助命令行，由Open AI的API驅動。
 * [openaigo](https://github.com/otiai10/openaigo) - OpenAI GPT3/3.5 ChatGPT API 的 Go 客戶端庫，簡單、少依賴、經過良好測試。
 * [cligpt](https://github.com/paij0se/cligpt) - 在終端機中的 ChatGPT
 * [CodeGPT](https://github.com/appleboy/codegpt) - 一個使用Go語言編寫的CLI，可以使用ChatGPT AI（gpt-4，gpt-3.5-turbo模型）為您編寫git提交消息或進行代碼審查簡介，並自動安裝git prepare-commit-msg鉤子。
 * [search](https://github.com/visualbasic6/search) - 一個由AI（ChatGPT）編寫的CLI Google客戶端，通過使用Google Alerts“預覽”功能繞過驗證碼和速率限制。
 * [chatgpt-backup](https://github.com/abacaj/chatgpt-backup) - 單個客戶端腳本，可備份您的整個ChatGPT對話歷史。
 * [PowerShellAI](https://github.com/dfinke/powershellai) - PowerShell AI 模組，適用於 OpenAI GPT-3 和 DALL-E。
 * [chatGPT-shell-cli](https://github.com/0xacx/chatgpt-shell-cli) - 簡單的shell腳本，可從終端使用OpenAI的ChatGPT和DALL-E。不需要Python或JS。
 * [chatgpt-shell](https://github.com/xenodium/chatgpt-shell) - 極簡聊天GPT和DALL-E Emacs外殼
 * [client](https://github.com/openai-php/client) - ⚡️ OpenAI PHP 是一個強化的社群維護 PHP API 客戶端，讓您可以與 OpenAI API 互動。
 * [slickgpt](https://github.com/shipbit/slickgpt) - SlickGPT是一個輕量級的「使用自己的API密鑰」網頁客戶端，用Svelte編寫，可用於OpenAI API。它提供GPT-4集成、無用戶分享功能和其他超能力。
 * [chatgpt-ui](https://github.com/wongsaang/chatgpt-ui) - 一個支援多個使用者、多個數據庫連接以進行持久化數據存儲、支援i18n的ChatGPT網頁客戶端。提供Docker映像和快速部署腳本。
 * [openai-java](https://github.com/theokanning/openai-java) - Java中的OpenAI GPT-3 Api客戶端
 * [hfuzz](https://github.com/thehlopster/hfuzz) - 網站模糊測試的單詞列表，由多個可靠來源製作，包括：我的測試結果、git.rip、ChatGPT、Lex、核心模板、網站掃描器、seclist、bo0m等等。
 * [the-art-of-command-line](https://github.com/jlevy/the-art-of-command-line) - 掌握命令列，只需一頁
 * [auto-copilot-cli](https://github.com/rsaryev/auto-copilot-cli) - Auto Copilot 是一個 CLI 工具，使用 OpenAI 模型生成命令，以達成目標的終端機和檔案系統操作。
 * [DelphiOpenAI](https://github.com/hemulgm/delphiopenai) - Delphi的OpenAI API客戶端。使用ChatGPT、DALL-E和其他產品。
 * [free-chatgpt-client-pub](https://github.com/akl7777777/free-chatgpt-client-pub) - 一個免費的ChatGPT客戶端，現在支援線上搜尋。無需金鑰，無需登錄。多節點自動速度測量切換，無字數限制的長文翻譯，AI圖形。
 * [duet-gpt](https://github.com/kristoferlund/duet-gpt) - 一個對話式半自主開發者助手。AI配對編程，無需複製粘貼。
 * [elia](https://github.com/darrenburns/elia) - 一個使用Textual建立的終端ChatGPT客戶端
 * [README-AI](https://github.com/eli64s/readme-ai) - 🚀 一個 CLI 工具，可以生成美觀且豐富的 README Markdown 文件。由 OpenAI 的 GPT APIs 提供支持 💫
 * [openai-powershell-samples](https://github.com/dfinke/openai-powershell-samples) - 🚀 我推出了我的 @OpenAI/@Azure PowerShell 範例！使用 PowerShellAI 模組，您將擁有 ChatGPT 的強大功能。在多語言互動筆記本中探索這些範例。讓我們重新定義 AI 的可能性！👇 #PowerShell #MSBuild
 * [TermGPT](https://github.com/sentdex/termgpt) - 讓像GPT-4這樣的LLM具備計劃和執行終端命令的能力
 * [chatgpt-cli](https://github.com/marcolardera/chatgpt-cli) - 使用官方API與ChatGPT聊天的簡單而有效的命令行客戶端
 * [OpenAIR](https://github.com/umatter/openair) - OpenAI R 客戶端
 * [ChatGPT-Midjourney](https://github.com/licoy/chatgpt-midjourney) - 🎨 一鍵擁有你自己的 ChatGPT+Midjourney 網頁服務
 * [termGPT](https://github.com/tcapelle/termgpt) - 一個簡單的Python封裝程式，可在終端上調用openAI的chatGPT。
 * [Chat2DB](https://github.com/alibaba/chat2db) - 🔥 🔥 🔥 一個智能且多功能的通用SQL客戶端和報表工具，可整合ChatGPT功能。
 * [llm-toolbox](https://github.com/sderev/llm-toolbox) - LLM-Toolbox 是一個多功能的命令行界面（CLI）工具集，利用人工智能執行各種任務，包括校對、識別適當的 shell 命令、生成自動提交訊息等等。
 * [chatgpt.js](https://github.com/chatgptjs/chatgpt.js) - 🤖 ChatGPT 的強大客戶端 JavaScript 函式庫。
 * [Clippy](https://github.com/firecubestudios/clippy) - Clippy由FireCube提供。
 * [aider](https://github.com/paul-gauthier/aider) - aider是在您的終端機上使用GPT進行編碼的工具
 * [SaaS-Template-GPT](https://github.com/wasp-lang/saas-template-gpt) - 🐝 黃蜂- 立即使用包含社交/郵件登錄、GPT/Stripe集成、cron作業等的SaaS模板開始⚡️- `wasp db` CLI命令也是一個不錯的功能，可以立即在後台啟動本地的Postgres數據庫。
 * [openai-cli](https://github.com/janlay/openai-cli) - 一個用BASH編寫的OpenAI通用命令行界面。
 * [Chat2DB](https://github.com/chat2db/chat2db) - 🔥 🔥 🔥 一個智能且多功能的通用SQL客戶端和報表工具，集成了ChatGPT功能。
 * [gpt-web-terminal](https://github.com/ltyzzzxxx/gpt-web-terminal) - ✨ 以程式設計師的方式開啟 ChatGPT！GPT Terminal 是一個讓您可以在終端機中與 GPT 進行溝通的平台。
 * [chatgpt-web](https://github.com/dqzboy/chatgpt-web) - ChatGPT 網頁一鍵部署
 * [tgpt](https://github.com/aandrew-me/tgpt) - 在終端機中使用ChatGPT而不需要API密鑰
 * [chatgpt-cli](https://github.com/kardolus/chatgpt-cli) - ChatGPT CLI 是 OpenAI 的 ChatGPT 的高級命令行界面，提供流式傳輸、查詢模式和歷史記錄功能，實現無縫且具有上下文感知的對話。非常適合用戶和開發人員使用，它提供了高級配置和簡單的設置選項，確保與 GPT 模型的對話體驗符合需求。
 * [lobe-commit](https://github.com/lobehub/lobe-commit) - 💌 Lobe Commit 是一個使用 Langchain/ChatGPT 的 CLI 工具，用於生成基於 Gitmoji 的提交訊息。
 * [SuperSummarizeAI](https://github.com/alexandrevl/supersummarizeai) - 發揮SuperSummarizeAI的人工智能力量！輕鬆地使用ChatGPT從網頁和YouTube視頻中提取、縮短和剪輯內容，將無窮的內容轉化為易於理解的摘要。
 * [minion](https://github.com/mikaelvesavuori/minion) - 開發者在命令列介面中使用ChatGPT的最簡單且最輕量的方式。
 * [chai-ruby](https://github.com/rogueocelot/chai-ruby) - 使用您選擇的終端模擬器進入GNOME Files中打開的目錄
 * [llm-code-interpreter](https://github.com/e2b-dev/llm-code-interpreter) - 由E2B提供的AI遊樂場驅動。ChatGPT的代碼解釋器增強版。運行任何語言，任何終端進程，自由使用文件系統。並且可以連接互聯網。
 * [lobe-chat](https://github.com/lobehub/lobe-chat) - 🤖 Lobe Chat - 一個開源、可擴展（函數調用）的高性能聊天機器人框架。它支持一鍵免費部署您的私人ChatGPT/LLM網絡應用程式。
 * [paperify](https://github.com/jstrieb/paperify) - 將任何文件、網頁或電子書轉換為研究論文（不需要ChatGPT）。
 * [cli](https://github.com/bashsenpai/cli) - BashSenpai 是由 ChatGPT 驅動的終端助手。
 * [unit-runtime](https://github.com/unit-mesh/unit-runtime) - Unit Runtime 是一個 ChatGPT 等 AI 代碼的運行環境，可一鍵啟動並實時交互，幫助您快速構建和測試 AI 代碼。Unit Runtime 是一個高效且用戶友好的 AI 代碼執行環境，可一鍵啟動並實時交互，幫助您快速構建和測試 AI 代碼。
 * [aih](https://github.com/databingo/aih) - 在終端機中與AI模式對話。Bard|GPT3.5|Claude2|Llama2|Falcon180
 * [Sense](https://github.com/f0x1d/sense) - 開放AI Android客戶端，支援ChatGPT功能
 * [sparrow](https://github.com/soulteary/sparrow) - ChatGPT風格的客戶端相容的後端伺服器，開源實現。
 * [chatgpt-md-translator](https://github.com/smikitky/chatgpt-md-translator) - 使用ChatGPT API翻譯Markdown文件的CLI
 * [ollama-webui](https://github.com/ollama-webui/ollama-webui) - ChatGPT-風格的Ollama🦙響應式聊天網頁用戶界面客戶端（GUI）
 * [BibiGPT-v1](https://github.com/jimmylv/bibigpt-v1) - BibiGPT v1 · 一鍵 AI 摘要工具，適用於音視頻和聊天內容：Bilibili | YouTube | 推特 | 抖音 | 快手 | 百度網盤 | 谷歌雲端硬碟 | 本地文件 | 網站 | 播客 | 會議 | 講座等等。音視頻內容 AI 一鍵總結 & 對話：哔哩哔哩 | YouTube | 推特 | 小紅書 | 抖音 | 快手 | 百度網盤 | 阿里雲盤 | 網頁 | 播客 | 會議 | 講座等等（原 BiliGPT 省流神器 & AI課代表）。
 * [open-interpreter](https://github.com/killianlucas/open-interpreter) - 在您的终端中运行的OpenAI代码解释器
 * [chatgpt-java](https://github.com/grt1228/chatgpt-java) - ChatGPT Java SDK支持流式輸出、Gpt插件、聯網。支持OpenAI官方所有接口。ChatGPT的Java客戶端。OpenAI GPT-3.5-Turb GPT-4  Api Client for Java
 * [llm-workflow-engine](https://github.com/llm-workflow-engine/llm-workflow-engine) - LLMs的Power CLI和工作流程管理器（核心套件）
 * [openai-kotlin](https://github.com/aallam/openai-kotlin) - 具有多平台和協程功能的 Kotlin OpenAI API 客戶端。
 * [sqlchat](https://github.com/sqlchat/sqlchat) - 基於聊天的SQL客戶端和編輯器，為未來十年打造的工具
 * [ShellGPT](https://github.com/akl7777777/shellgpt) - **ShellGPT是一個免費的chatgpt客戶端，現在支援在線搜索，無需密鑰，無需登錄。多節點自動速度測量切換，無字數限制的長文翻譯，AI圖形。**
 * [gptel](https://github.com/karthink/gptel) - 一個簡單的Emacs LLM客戶端
 * [OpenAI-DotNet](https://github.com/rageagainstthepixel/openai-dotnet) - 一個非官方的DotNet OpenAI RESTful API客戶端
 * [every-chatgpt-gui](https://github.com/billmei/every-chatgpt-gui) - 每個ChatGPT的前端GUI客戶端
 * [yai](https://github.com/ekkinox/yai) - 您的AI動力終端助手。
 * [gpt-cli](https://github.com/kharvd/gpt-cli) - ChatGPT的命令行界面，Claude和Bard
 * [Gemini](https://github.com/kyegomez/gemini) - Google將“超越ChatGPT”的Gemini模型的開源實現Google將“超越ChatGPT”的Gemini模型的開源實現
 * [MoneyPrinterTurbo](https://github.com/harry0703/moneyprinterturbo) - 使用AI大模型，一鍵生成高清短視頻。
 * [zap-gpt](https://github.com/marcusgoncalvess/zap-gpt) - 這個項目探索了將ChatGPT與WhatsApp集成，將聊天機器人轉變為一個能夠執行與朋友交談、回答客戶問題等任務的虛擬助手，並在對話中加入人性化的元素。
 * [zap-gpt-free](https://github.com/marcusgoncalvess/zap-gpt-free) - 這個項目探索了將ChatGPT與WhatsApp集成，將聊天機器人轉變為一個能夠執行與朋友交談、回答客戶問題等任務的虛擬助手，並在對話中加入人性化的元素。
 * [chatAir](https://github.com/flyun/chatair) - ☁️OpenAI 和 Gemini 的原生安卓客戶端 ☁️
 * [matrix-chatgpt-bot](https://github.com/matrixgpt/matrix-chatgpt-bot) - 通過任何Matrix客戶端與ChatGPT交談！
 * [lobe-cli-toolbox](https://github.com/lobehub/lobe-cli-toolbox) - 🪀 Lobe CLI 工具箱 - AI CLI 工具箱，提升 git 提交和 i18n 工作流效率
 * [openai-scala-client](https://github.com/cequence-io/openai-scala-client) - Scala客戶端用於OpenAI API
 * [ChatGPTCLIBot](https://github.com/lagpixellol/chatgptclibot) - 在CLI中使用Embeddings支持長期記憶的ChatGPT機器人。ChatGPT機器人在CLI中具有長期記憶支持，並使用Embeddings。
 * [openai4j](https://github.com/lambdua/openai4j) - Java客戶端庫用於OpenAI API。對所有OpenAI API模型提供全面支持，包括Completions、Chat、Edits、Embeddings、Audio、Files、Assistants-v2、Images、Moderations、Batch和Fine-tuning。
 * [json-translator](https://github.com/mololab/json-translator) - jsontt 💡 - AI JSON翻譯器，搭載GPT和其他免費翻譯模組，可將您的json/yaml文件翻譯成其他語言 ✅ 查看Readme ✌ 支援GPT / DeepL / Google / Bing / Libre / Argos
 * [gptme](https://github.com/erikbjare/gptme) - 與配備本地工具的LLMs聊天：執行Python和Bash，編輯本地文件，瀏覽網頁。
 * [Apt](https://github.com/rnchg/apt) - AI 生產力工具-免費且開源，提高用戶生產力同時確保隱私和數據安全。它提供高效便捷的人工智能解決方案，包括但不限於：內置獨家 ChatGPT、一鍵批量智能處理。
 * [chatgpt-subtitle-translator](https://github.com/cerlancism/chatgpt-subtitle-translator) - 基於ChatGPT API的高效翻譯工具
 * [tenere](https://github.com/pythops/tenere) - 🔥 用Rust编写的LLMs的TUI界面
 * [Chat2DB](https://github.com/codephiliax/chat2db) - 🔥🔥🔥由人工智慧驅動的數據庫工具和SQL客戶端，最熱門的GUI客戶端，支持MySQL、Oracle、PostgreSQL、DB2、SQL Server、SQLite、H2、ClickHouse等等。
 * [OpenHands](https://github.com/all-hands-ai/openhands) - 🙌 開放雙手：少寫代碼，多創造
 * [ai-digest](https://github.com/khromov/ai-digest) - 一個CLI工具，將您的代碼庫聚合到一個單獨的Markdown文件中，以供Claude Projects或自定義ChatGPT使用。
 * [web-mirai-panel](https://github.com/zmh-program/web-mirai-panel) - 🍉 Web UI 一鍵配置 ChatGPT Mirai QQ Bot 機器人，支持多實例管理，配置編輯，文件提交，健康檢查，終端執行，支持密碼訪問。🍉 Web UI of ChatGPT Mirai QQ Bot 機器人，支持多實例管理，配置編輯，文件提交，健康檢查，終端執行，支持密碼訪問。
 * [Nexior](https://github.com/acedatacloud/nexior) - 一鍵部署您自己的AI應用Web UI，包括GPT、Midjourney、ChatDoc、QrArt等，輕鬆賺取利潤。
 * [aider](https://github.com/aider-ai/aider) - 輔助者是您終端機中的AI對程式設計。
 * [laravel](https://github.com/openai-php/laravel) - ⚡️ OpenAI PHP for Laravel 是一個強化版的 PHP API 客戶端，讓您可以與 OpenAI API 互動。
 * [WrenAI](https://github.com/canner/wrenai) - 🚀 開源 SQL AI 代理程式，用於文本轉 SQL。支援 PostgreSQL、DuckDB、MySQL、MS SQL、ClickHouse、Trino、JSON、CSV、Parquet 資料來源等等！🚀
 * [Queryable](https://github.com/mazzzystar/queryable) - 在iOS上運行OpenAI的CLIP和蘋果的MobileCLIP模型來搜索照片。
 * [ChatGPTs](https://github.com/licoy/chatgpts) - 🍭 一鍵擁有你自己的ChatGPT+眾多AI網頁服務 | 一鍵擁有你自己的ChatGPT+眾多AI網頁服務
 * [ChatAny](https://github.com/licoy/chatany) - 🌻 一鍵擁有你自己的 ChatGPT+眾多AI 網頁服務 | 一鍵擁有你自己的 ChatGPT+眾多AI 網頁服務
 * [ChatAny](https://github.com/chatanyteam/chatany) - 🌻 一鍵擁有你自己的 ChatGPT+眾多AI 網頁服務 | 一鍵擁有你自己的 ChatGPT+眾多AI 網頁服務
 * [cz-git](https://github.com/zhengqbbb/cz-git) - cz-git | czg 🛠️ DX 首選和更多工程化、輕量級、可定制、標準輸出格式的 Commitizen 適配器和 CLI
 * [cherry-studio](https://github.com/kangfenmao/cherry-studio) - 🍒 Cherry Studio 是一個桌面客戶端，支持多個LLM提供商。
 * [plandex](https://github.com/plandex-ai/plandex) - 在您的終端機中進行AI驅動的開發。設計用於大型、現實世界的任務。
 * [PDFMathTranslate](https://github.com/byaidu/pdfmathtranslate) - 基於 AI 完整保留排版的 PDF 學術論文翻譯，支持 Google/DeepL/Ollama/OpenAI 等服務，提供 CLI/GUI/Docker
 * [gpt-engineer](https://github.com/gpt-engineer-org/gpt-engineer) - 用於實驗人工智慧軟體工程師的平台。基於終端機。注意：與https://gptengineer.app非常不同。
 * [whisper-ctranslate2](https://github.com/softcatala/whisper-ctranslate2) - 基於CTranslate2的原始OpenAI客戶端兼容的Whisper命令行客戶端。Whisper命令行客戶端與原始OpenAI客戶端兼容，基於CTranslate2。


## Reimplementations

 * [PaLM-rlhf-pytorch](https://github.com/lucidrains/palm-rlhf-pytorch) - 在PaLM架構上實現RLHF（Reinforcement Learning with Human Feedback）。基本上是ChatGPT，但使用PaLM。
 * [minGPT](https://github.com/karpathy/mingpt) - 一個最小化的PyTorch重新實現OpenAI GPT（生成預訓練變形器）訓練的程式。
 * [mm-cot](https://github.com/amazon-science/mm-cot) - 官方實現「語言模型中的多模態思維鏈推理」（敬請期待，將有更多更新）
 * [picoGPT](https://github.com/jaymody/picogpt) - 一個不必要的小型NumPy GPT-2實現。
 * [gpt-neox](https://github.com/eleutherai/gpt-neox) - 基於DeepSpeed庫的GPU模型並行自回歸變壓器的實現。
 * [GPTZero](https://github.com/burhanultayyab/gptzero) - GPTZero 的開源實現
 * [SpikeGPT](https://github.com/ridgerchu/spikegpt) - 實現「SpikeGPT：具有脈衝神經網絡的生成預訓練語言模型」
 * [ml-ane-transformers](https://github.com/apple/ml-ane-transformers) - 針對蘋果神經引擎（ANE）優化的Transformer架構參考實現
 * [memorizing-transformers-pytorch](https://github.com/lucidrains/memorizing-transformers-pytorch) - 記憶變形器的實現（ICLR 2022），使用近似最近鄰居索引和檢索增強的注意力網絡，在Pytorch中。
 * [lit-llama](https://github.com/lightning-ai/lit-llama) - 基於nanoGPT的LLaMA語言模型實現。支持閃存注意力、Int8和GPTQ 4位量化、LoRA和LLaMA-Adapter微調、預訓練。Apache 2.0許可證。
 * [large-model-parallelism](https://github.com/hundredblocks/large-model-parallelism) - 主要模型平行處理方法的功能本地實現
 * [bloomz.cpp](https://github.com/nouamanetazi/bloomz.cpp) - BLOOM 的 C++ 實現
 * [swift-coreml-transformers](https://github.com/huggingface/swift-coreml-transformers) - Swift Core ML 3 實現了 GPT-2、DistilGPT-2、BERT 和 DistilBERT 的問答功能。其他 Transformer 即將推出！
 * [lit-parrot](https://github.com/lightning-ai/lit-parrot) - 基於nanoGPT的StableLM/Pythia/INCITE語言模型的實現。支持閃光注意力、LLaMA-Adapter微調和預訓練。Apache 2.0許可證。
 * [gpt-code-ui](https://github.com/ricklamers/gpt-code-ui) - 一個開源實現OpenAI的ChatGPT代碼解釋器的項目
 * [DragGAN](https://github.com/zeqiang-lai/draggan) - DragGAN 的線上演示和實現 - 「拖動您的 GAN：在生成圖像流形上進行交互式基於點的操作」。
 * [femtoGPT](https://github.com/keyvank/femtogpt) - 一個最小化的生成預訓練轉換器的純Rust實現
 * [lit-gpt](https://github.com/lightning-ai/lit-gpt) - 可駭入的最先進開源LLMs的實現，基於nanoGPT。支持閃存注意力、Int8和GPTQ 4位量化、LoRA和LLaMA-Adapter微調、預訓練。Apache 2.0許可。
 * [exllama](https://github.com/turboderp/exllama) - 一個更節省記憶體的重寫版本，用於使用量化權重的Llama的HF transformers實現。
 * [AStarNet](https://github.com/deepgraphlearning/astarnet) - 官方實現的A*網絡
 * [codeinterpreter-api](https://github.com/shroominic/codeinterpreter-api) - 開源ChatGPT代碼解釋器的實現 👾
 * [Local-Code-Interpreter](https://github.com/mrgreyfun/local-code-interpreter) - 一個本地實現的OpenAI ChatGPT代碼解釋器。
 * [ChatPiXiu](https://github.com/openllmai/chatpixiu) - ChatPiXiu：OpenLLMAI的文件。調查、複製和領域/任務適應開源chatgpt替代方案/實現。PiXiu-貔貅意味著財富。
 * [vall-e](https://github.com/lifeiteng/vall-e) - 請將以下內容翻譯成繁體中文。VALL-E（零樣本文本轉語音）的PyTorch實現，重現的演示 https://lifeiteng.github.io/valle/index.html
 * [textgen](https://github.com/shibing624/textgen) - TextGen：文本生成模型的實現，包括LLaMA，BLOOM，GPT2，BART，T5，SongNet等等。文本生成模型，實現了包括LLaMA，ChatGLM，BLOOM，GPT2，Seq2Seq，BART，T5，UDA等模型的訓練和預測，開箱即用。
 * [LaMDA-rlhf-pytorch](https://github.com/conceptofmind/lamda-rlhf-pytorch) - Google LaMDA在PyTorch中的開源預訓練實現。添加類似ChatGPT的RLHF。Google LaMDA在PyTorch中的開源預訓練實現。添加類似ChatGPT的RLHF。
 * [langchain](https://github.com/brainlid/langchain) - LangChain風格框架的Elixir實現。
 * [kan-gpt](https://github.com/adityang/kan-gpt) - 使用 Kolmogorov-Arnold 網絡 (KANs) 實現的 PyTorch 生成式預訓練變換器 (GPTs) 用於語言建模
 * [TextRL](https://github.com/voidful/textrl) - 在huggingface的transformer上實現ChatGPT RLHF（Reinforcement Learning with Human Feedback）在任何生成模型上的應用（blommz-176B/bloom/gpt/bart/T5/MetaICL）
 * [ShareGPT4Video](https://github.com/sharegpt4omni/sharegpt4video) - ShareGPT4Video的官方實施：通過更好的字幕改進視頻理解和生成
 * [GPT2](https://github.com/affjljoo3581/gpt2) - PyTorch 實現 OpenAI GPT-2
 * [T2M-GPT](https://github.com/mael-zys/t2m-gpt) - （CVPR 2023）Pytorch實現“T2M-GPT：使用離散表示從文本描述生成人類動作”
 * [stable-baselines3](https://github.com/dlr-rm/stable-baselines3) - 穩定基線的PyTorch版本，可靠的強化學習算法實現。
 * [WhisperLive](https://github.com/collabora/whisperlive) - 一個幾乎實時實現OpenAI的Whisper。
 * [GenAI_Agents](https://github.com/nirdiamant/genai_agents) - 這個存儲庫提供了各種生成式人工智能代理技術的教程和實現，從基礎到高級。它作為構建智能、互動式人工智能系統的全面指南。


## Tutorials

 * [Hello-Python](https://github.com/mouredev/hello-python) - 從零開始學習Python編程語言的課程，適合初學者。超過30堂課，25小時的視頻，代碼和聊天群組。從基礎知識到創建帶有數據庫的API後端等等...
 * [notebooks](https://github.com/dataflowr/notebooks) - 深度學習課程代碼
 * [gpt4all-colab](https://github.com/camenduru/gpt4all-colab) - 🔥gpt4all（最佳的chatgpt克隆版）在本地運行並在colab教程中 - 到@camenduru的colab -🔥gpt4all（最佳的chatgpt克隆版）在本地運行並在colab教程中 - 到@camenduru的colab -
 * [X-Decoder](https://github.com/microsoft/x-decoder) - 學習 Q# 和量子計算的教程和編程練習
 * [AI-Powered-Video-Tutorial-Generator](https://github.com/akshitireddy/ai-powered-video-tutorial-generator) - 創建具有角色動畫和幻燈片的AI生成視頻教程！
 * [semantic-kernel-rag-chat](https://github.com/azure-samples/semantic-kernel-rag-chat) - 使用語義核心的ChatGPT + 企業數據的教程，OpenAI和Azure認知搜索
 * [alexa-gpt](https://github.com/k4l1sh/alexa-gpt) - 一個關於如何在Alexa上使用ChatGPT的教程
 * [qxresearch-event-1](https://github.com/qxresearch/qxresearch-event-1) - Python 實戰教程，包含50+個Python應用程式（10行代碼）@xiaowuc2
 * [leedl-tutorial](https://github.com/datawhalechina/leedl-tutorial) - 《李宏毅深度學習教程》，PDF下載地址：https://github.com/datawhalechina/leedl-tutorial/releases
 * [bpf-developer-tutorial](https://github.com/eunomia-bpf/bpf-developer-tutorial) - 通過例子學習 eBPF | eBPF 開發者教程與知識庫：通過小工具和示例一步步學習 eBPF，包含性能、網絡、安全等多種應用場景
 * [tensorflow-nlp-tutorial](https://github.com/ukairia777/tensorflow-nlp-tutorial) - 使用tensorflow進行文本預處理，整理最新模型的下游任務，如主題模型、BERT、GPT、LLM等的Deep Learning NLP存儲庫。
 * [langchain-kr](https://github.com/teddylee777/langchain-kr) - 請將以下內容翻譯成繁體中文。LangChain官方文件、Cookbook、以及其他實用範例為基礎撰寫的韓文教程。透過本教程，您可以學習如何更輕鬆有效地使用LangChain。LangChain官方文件、Cookbook、以及其他實用範例為基礎撰寫的韓文教程。透過本教程，您可以學習如何更輕鬆有效地使用LangChain。
 * [llm-python](https://github.com/onlyphantom/llm-python) - 大型語言模型（LLMs）教程和示例腳本，包括langchain、openai、llamaindex、gpt、chromadb和pinecone
 * [Play-with-LLMs](https://github.com/evilpsycho/play-with-llms) - 教程：如何訓練、評估LLMs，以及利用RAG、Agent、Chain來構建具娛樂性的LLMs應用程式。
 * [zero_to_gpt](https://github.com/vikparuchuri/zero_to_gpt) - 從零基礎的深度學習知識到實現GPT。


## NLP

 * [BioGPT](https://github.com/microsoft/biogpt) - 微軟研究院推出了 Biogpt，這是一個在生物醫學研究文獻上訓練的大型語言模型。該模型在回答來自生物醫學文獻的問題方面取得了優於人類的表現，並在 PubmedQA 上進行了評估。該模型的代碼...
 * [stanford_alpaca](https://github.com/tatsu-lab/stanford_alpaca) - 訓練斯坦福大學的Alpaca模型的代碼和文檔，以及生成數據。
 * [openai-python](https://github.com/openai/openai-python) - OpenAI Python 庫提供方便的方式，讓使用 Python 語言編寫的應用程式可以輕鬆地存取 OpenAI API。
 * [FlexGen](https://github.com/fminference/flexgen) - 在單個GPU上運行大型語言模型以實現吞吐量導向的場景。
 * [RWKV-LM](https://github.com/blinkdl/rwkv-lm) - RWKV 是一種具有變形器級別 LLM 表現的 RNN。它可以像 GPT 一樣直接進行訓練（可並行化）。因此，它結合了 RNN 和變形器的優點 - 表現優秀、推理速度快、節省 VRAM、訓練速度快、"無限" ctx_len 和免費的句子嵌入。
 * [mario-gpt](https://github.com/shyamsn97/mario-gpt) - 使用GPT2生成馬里奧關卡。本論文代碼為「MarioGPT：通過大型語言模型進行開放式文本生成關卡」https://arxiv.org/abs/2302.05981
 * [bilingual_book_maker](https://github.com/yihong0618/bilingual_book_maker) - 使用人工智慧翻譯製作雙語epub書籍
 * [llm-security](https://github.com/greshake/llm-security) - 打破應用程式整合的LLM的新方法
 * [GLM-130B](https://github.com/thudm/glm-130b) - GLM-130B：一個開放的雙語預訓練模型（ICLR 2023）
 * [trlx](https://github.com/carperai/trlx) - 一個使用強化學習和人類反饋進行語言模型分散式訓練的存儲庫（RLHF）
 * [ChatGLM-6B](https://github.com/thudm/chatglm-6b) - ChatGLM-6B：開源雙語對話語言模型 | 一個開放的雙語對話語言模型
 * [GPTSAN](https://github.com/tanreinama/gptsan) - 通用開關變壓器基於日語語言模型
 * [gpt-2](https://github.com/openai/gpt-2) - 論文代碼：“語言模型是無監督多任務學習者”
 * [gptlang](https://github.com/forrestchang/gptlang) - 由GPT-4實現的新程式語言。
 * [BIG-bench](https://github.com/google/big-bench) - 超越模仿遊戲：衡量和推斷語言模型能力的協作基準
 * [hlb-gpt](https://github.com/tysam-code/hlb-gpt) - 以約365行程式碼打造的極簡、快速、且適合實驗的研究工具，可用於GPT-like模型。在單個A100上，於約138秒內在wikitext-103上達到小於3.8的驗證損失。
 * [hn_summary](https://github.com/jiggy-ai/hn_summary) - 使用大型語言模型總結Hacker News的頭條新聞，並將它們發布到Telegram頻道。
 * [transformers](https://github.com/huggingface/transformers) - 🤗 Transformers：Pytorch、TensorFlow 和 JAX 的最先進機器學習技術。
 * [self-instruct](https://github.com/yizhongw/self-instruct) - 將預訓練語言模型與其自身生成的指導數據對齊。
 * [knowledge_gpt](https://github.com/mmz-001/knowledge_gpt) - 您的文件將獲得準確的答案和即時引用。
 * [lqae](https://github.com/lhao499/lqae) - 語言量化自編碼器
 * [stanford_alpaca](https://github.com/tatsu-lab/stanford_alpaca#fine-tuning) - 訓練斯坦福大學的Alpaca模型的代碼和文檔，以及生成數據。
 * [fib](https://github.com/r-three/fib) - 「bloom」、「opt-175b」、「t0」和「gpt-neox」是否「事實上一致」？新的預印本！我們介紹了「FIB」- 事實不一致基準 - 並評估了23個LLM。與@anisham197 @byryuer @mohitban47 @colinraffel一起完成的工作📄💾🧵⬇️
 * [petals](https://github.com/bigscience-workshop/petals) - 🌸 在家中運行100B+語言模型，類似BitTorrent的方式。微調和推論速度比卸載快10倍。
 * [emailGPT](https://github.com/lucasmccabe/emailgpt) - 使用ChatGPT快速且簡單的介面生成電子郵件。
 * [gpt3-contextual](https://github.com/uezo/gpt3-contextual) - 使用OpenAI API的GPT-3模型進行上下文聊天
 * [camel](https://github.com/lightaime/camel) - 駱駝：用於大型語言模型社會的“心靈”探索的交流代理人
 * [pubmed-gpt](https://github.com/arokem/pubmed-gpt) - 使用GPT來總結PubMed查詢的摘要。
 * [haltt4llm](https://github.com/manyoso/haltt4llm) - 這個項目旨在創建一個共同的指標，以測試LLM在消除幻覺方面的進展，這是目前廣泛應用LLM的許多實際目的中最嚴重的問題。
 * [olm-datasets](https://github.com/huggingface/olm-datasets) - 從網路上拉取和處理語言模型預訓練數據的管道
 * [sat-reading](https://github.com/jquesnelle/sat-reading) - 新博客：語言模型與SAT閱讀測試！它們得分約為90％，而Flan-T5與GPT-3.5一樣好！微調效果更好！所有詳細信息：在此處可用，包括一個帶有問題（+模型）的新Huggingface數據集：
 * [tenetlang](https://github.com/tenetlang/tenetlang) - 一種為人類設計的GPT語言
 * [ebook-GPT-translator](https://github.com/jesselau76/ebook-gpt-translator) - 享受以您喜愛的風格閱讀。
 * [srt-gpt-translator](https://github.com/jesselau76/srt-gpt-translator) - 字幕翻譯員
 * [datasloth](https://github.com/ibestvina/datasloth) - 自然語言Pandas查詢和由GPT-3驅動的數據生成
 * [trl](https://github.com/lvwerra/trl) - 使用強化學習訓練轉換器語言模型。
 * [ChatGPT-vs.-BERT](https://github.com/whu-zqh/chatgpt-vs.-bert) - 🎁【ChatGPT4NLU】ChatGPT和Fine-tuned BERT的比較研究
 * [unilm](https://github.com/microsoft/unilm) - 跨任務、語言和模態的大規模自監督預訓練
 * [document.ai](https://github.com/ganymedenil/document.ai) - 基於向量數據庫與GPT3.5的通用本地知識庫方案
 * [LAVIS](https://github.com/salesforce/lavis) - LAVIS - 語言視覺智能的一站式圖書館
 * [gpt-subtrans](https://github.com/machinewrapped/gpt-subtrans) - 使用OpenAI/ChatGPT項目來翻譯字幕文件
 * [paper-qa](https://github.com/whitead/paper-qa) - LLM鏈，用於從帶有引用的文件中回答問題
 * [guardrails](https://github.com/shreyar/guardrails) - 將護欄添加到大型語言模型。
 * [chatgpt-document-extraction](https://github.com/brandonrobertz/chatgpt-document-extraction) - 一個概念驗證工具，可使用ChatGPT將混亂的文本文件轉換為結構化的JSON。
 * [h2ogpt](https://github.com/h2oai/h2ogpt) - 加入運動，成為由H2O.ai領導的世界最佳開源GPT的一員。
 * [LLMZoo](https://github.com/freedomintelligence/llmzoo) - ⚡LLM Zoo是一個為大型語言模型提供數據、模型和評估基準的項目。⚡
 * [INSIGHT](https://github.com/oneil512/insight) - INSIGHT是一個自主的人工智能，可以進行醫學研究！
 * [h2o-llmstudio](https://github.com/h2oai/h2o-llmstudio) - H2O LLM Studio - 一個框架和無代碼GUI，用於微調LLMs
 * [nlp-resume-parser](https://github.com/hxu296/nlp-resume-parser) - 從PDF到JSON的NLP驅動，GPT-3啟用的簡歷解析器。
 * [chatgpt-clone](https://github.com/xtekky/chatgpt-clone) - ChatGPT介面更好的UI
 * [camel](https://github.com/lightaime/camel#data-hosted-on-hugging-face) - 🐫 駱駝：用於大規模語言模型社會的「心靈」探索的溝通代理人
 * [auto-redteam](https://github.com/traghav/auto-redteam) - 使用其他LLMs進行紅隊測試
 * [self-ask](https://github.com/ofirpress/self-ask) - 《測量和縮小語言模型中的組合性差距》的代碼和數據
 * [llm-lobbyist](https://github.com/johnnay/llm-lobbyist) - 論文代碼：“大型語言模型作為企業遊說者”（2023年）。
 * [Transformers-Tutorials](https://github.com/nielsrogge/transformers-tutorials) - 這個存儲庫包含我使用HuggingFace的Transformers庫製作的演示。
 * [dsp](https://github.com/stanfordnlp/dsp) - 𝗗𝗦𝗣：展示-搜索-預測。一個用於組合檢索和語言模型的框架，用於知識密集型自然語言處理。
 * [OpenAGI](https://github.com/agiresearch/openagi) - OpenAGI：當LLM遇見領域專家
 * [GraphGPT](https://github.com/varunshenoy/graphgpt) - 使用GPT-3從非結構化文本中推斷知識圖譜 🕵️‍♂️
 * [backend-GPT](https://github.com/theappletucker/backend-gpt) - 6/ 「gpt是你後端所需的全部」：使用LLM來幫助你撰寫後端。Wired：LLM就是後端。LLM後端是最近一次規模黑客松中的一個啟發性項目。LLM後端將狀態作為JSON blob並根據...英文描述進行修改。
 * [gpt-commit-summarizer](https://github.com/kanhari/gpt-commit-summarizer) - 基於GPT的工具，可以為您撰寫提交訊息。
 * [tesseract.js](https://github.com/naptha/tesseract.js) - 超過100種語言的純JavaScript OCR 📖🎉🖥
 * [subtitle-translator](https://github.com/gnehs/subtitle-translator) - 使用ChatGPT翻譯字幕
 * [vault-ai](https://github.com/pashpashpash/vault-ai) - OP Vault ChatGPT：使用OP Stack（OpenAI + Pinecone Vector Database）為ChatGPT提供長期記憶。使用簡單的React前端上傳自己的自定義知識庫文件（PDF，txt等）。OP Vault ChatGPT：使用OP Stack（OpenAI + Pinecone Vector Database）為ChatGPT提供長期記憶。使用簡單的React前端上傳自己的自定義知識庫文件（PDF，txt等）。
 * [ai-code-translator](https://github.com/mckaywrigley/ai-code-translator) - 使用人工智慧將程式碼從一種語言翻譯成另一種語言。
 * [chatgpt-i18n](https://github.com/observedobserver/chatgpt-i18n) - 使用人工智慧協助翻譯您的本地化 JSON 檔案。
 * [flux](https://github.com/transmissions11/flux) - LLM 電動工具
 * [platform](https://github.com/cognosisai/platform) - @erikschluntz 去年夏天我最初玩GPT-3代理時（你可以在這裡看到一個例子： whereby你可以給一個有JavaScript REPL訪問權限的GPT-3代理一個目標來完成），那就是我最終的結果，我不認為那是什麼……
 * [minds](https://github.com/dosco/minds) - MindsJS - 輕鬆建立 AI 強化的工作流程
 * [FreedomGPT](https://github.com/ohmplatform/freedomgpt) - 這個程式庫是為了一個基於React和Electron的應用程序，使用基於Alpaca Lora的聊天界面在Mac和Windows上本地執行FreedomGPT LLM（離線和私人）。
 * [chart-gpt](https://github.com/whoiskatrin/chart-gpt) - 基於文本輸入建立圖表的人工智能工具
 * [alpaca.cpp](https://github.com/antimatter15/alpaca.cpp) - 在本地運行一個指令調整的聊天式LLM
 * [ChatARKit](https://github.com/trzy/chatarkit) - 使用ChatGPT以自然語言創建AR體驗。
 * [alpaca.cpp](https://github.com/rupeshs/alpaca.cpp) - 本地運行指令調整的聊天式LLM（Android/Linux/Windows/Mac）
 * [rust-bert](https://github.com/guillaume-be/rust-bert) - Rust原生即用的NLP管道和基於Transformer的模型（BERT、DistilBERT、GPT2等）
 * [PentestGPT](https://github.com/greydgl/pentestgpt) - 一個由GPT驅動的滲透測試工具
 * [gpttools](https://github.com/jameshwade/gpttools) - gpttools擴展了gptstudio的套件開發功能，幫助您記錄代碼、編寫測試，甚至解釋代碼。
 * [semantic-kernel](https://github.com/microsoft/semantic-kernel) - 快速且輕鬆地將尖端的LLM技術整合到您的應用程式中。
 * [CoCoGen](https://github.com/madaan/cocogen) - 如果您將自然語言問題轉換為偽 Python，Codex 在某些 NLP 任務中表現優於 GPT-3 和 T5（將出現在 #emnlp2022 中），由 @aman_madaan 領導的工作，與 @shuyanzhxyc、Yiming Yang、@gneubig 和我一起進行。
 * [github-summarizer](https://github.com/stevebauman/github-summarizer) - 一個使用 Chat GPT 的 PHP GitHub 摘要工具。
 * [LSL-snippets](https://github.com/panterapolnocy/lsl-snippets) - 我所寫（或修改）的小型腳本，使用Linden Scripting Language（LSL）編寫，適用於Second Life。
 * [HealthGPT](https://github.com/stanfordbdhg/healthgpt) - 使用自然語言查詢您的蘋果健康數據 💬 🩺
 * [pdf-epub-GPT-translator](https://github.com/jesselau76/pdf-epub-gpt-translator) - 學習 Python + Flask
 * [gpt-3](https://github.com/openai/gpt-3) - GPT-3：語言模型是少樣本學習者
 * [GPT-4-LLM](https://github.com/instruction-tuning-with-gpt-4/gpt-4-llm) - 我們的「使用 GPT-4 進行指令調整」的總結很好！@omarsar0 生成的指令跟隨和反饋數據已經發布，可以帶來更優秀的自我指導學習模型。請繼續關注我們在 GitHub 存儲庫中的更多更新。
 * [siri-chatgpt](https://github.com/liujch1998/siri-chatgpt) - 現在你可以將Siri轉換成真正的#chatgpt！只需下載此快捷方式（存儲庫中的鏈接⬇️）到您的iPhone上，在快捷方式應用程序中編輯其腳本（即將您的API密鑰粘貼到文本框中），然後說：“嘿Siri，chatgpt”。問你最喜歡的問題！
 * [gpt-jargon](https://github.com/jbrukh/gpt-jargon) - 行話是一種自然語言編程語言，由像GPT-4這樣的LLM指定和執行。
 * [practical-llms](https://github.com/aggregate-intellect/practical-llms) - #aiscllmworkshop一個從零到危險的快速方法（例如，能夠自信地胡說八道，就像chatgpt一樣，但也能夠快速地掌握如何使用最新和最偉大的llm從想法到產品，並提供9個連續小時的長達一小時的演示！
 * [happycommit](https://github.com/jackbackes/happycommit) - HappyCommit 是一個令人愉悅的工具，它利用 OpenAI 的 GPT-3.5 Turbo 語言模型的強大功能，為您生成有意義且描述性的 Git 提交訊息。
 * [JamesGPT](https://github.com/jconorgrogan/jamesgpt) - ChatGPT越獄：預測未來，對政治和爭議話題發表意見，並評估真相。可能有助於我們更好地了解LLM偏見。
 * [ChatPaper](https://github.com/kaixindelele/chatpaper) - 使用ChatGPT來總結arXiv論文，全流程加速科研，包括總結、润色、審稿和審稿回覆。
 * [minichain](https://github.com/srush/minichain) - 具有LSTM編碼器/解碼器和注意力的序列到序列模型
 * [AutoPR](https://github.com/irgolic/autopr) - 修復由ChatGPT驅動的AI生成的拉取請求問題
 * [privateGPT](https://github.com/imartinez/privategpt) - 使用GPT的強大功能私下與您的文件互動，100％私密，無數據洩漏。
 * [SalesGPT](https://github.com/filip-michalsky/salesgpt) - 上下文感知的人工智能銷售代理，自動化銷售推廣。
 * [automated-interpretability](https://github.com/openai/automated-interpretability) - LLMs 可以解釋其他 LLMs 中的神經元通過展示 GPT-4（標記，激活）對來解釋 GPT-2 神經元的行為基於與 GPT-4 的解釋模擬神經元的激活根據模擬激活與實際激活的匹配程度評分解釋
 * [evalplus](https://github.com/evalplus/evalplus) - EvalPlus 用於嚴格評估 LLM 合成的程式碼
 * [chat2plot](https://github.com/nyanp/chat2plot) - 使用LLM進行聊天視覺化
 * [databerry](https://github.com/gmpetrov/databerry) - 建立自訂 LLM 代理的無代碼平台
 * [guidance](https://github.com/microsoft/guidance) - 控制大型語言模型的指導語言。
 * [SmartPilot](https://github.com/jaredkirby/smartpilot) - 一個使用OpenAI語言模型來生成、分析和選擇最佳答案的Python程序。
 * [developer](https://github.com/smol-ai/developer) - 隨著100k上下文視窗的到來，現在每個開發者都有機會擁有自己的小型開發者。
 * [pyllms](https://github.com/kagisearch/pyllms) - 最小的Python庫，可連接到LLMs（OpenAI，Anthropic，AI21，Cohere，Aleph Alpha，HuggingfaceHub，Google PaLM2），並具有內置的模型性能基準測試。
 * [llm-numbers](https://github.com/ray-project/llm-numbers) - 每位LLM開發人員應該知道的數字
 * [StructGPT](https://github.com/rucaibox/structgpt) - 「StructGPT：一個通用框架，用於大型語言模型在結構化數據上進行推理的代碼和數據」
 * [scikit-llm](https://github.com/iryna-kondr/scikit-llm) - 無縫地將強大的語言模型（如ChatGPT）整合到scikit-learn中，以增強文本分析任務。
 * [zeno-build](https://github.com/zeno-ml/zeno-build) - 建立、評估、分析和理解基於LLM的應用程式
 * [privateGPT](https://github.com/imartinez/privategpt?utm_source=tldrnewsletter) - 使用GPT的強大功能私下與您的文件互動，100％私密，無數據洩漏。
 * [Chat-with-Document-s-using-ChatGPT-API-and-Text-Embedding](https://github.com/appointat/chat-with-document-s-using-chatgpt-api-and-text-embedding) - 使用ChatGPT API和文本嵌入與文件進行聊天
 * [qlora](https://github.com/artidoro/qlora) - QLoRA：量化LLM的高效微調
 * [BriefGPT](https://github.com/e-johnstonn/briefgpt) - 本地主機工具，可將文件連接到LLMs進行摘要和查詢，具有簡單的GUI。
 * [XrayGPT](https://github.com/mbzuai-oryx/xraygpt) - XrayGPT：使用醫學視覺語言模型進行胸部X光攝影摘要。
 * [Voyager](https://github.com/minedojo/voyager) - 具有大型語言模型的開放式具體代理
 * [gorilla](https://github.com/shishirpatil/gorilla) - 大猩猩：LLM的API商店
 * [sudolang-llm-support](https://github.com/paralleldrive/sudolang-llm-support) - SudoLang LLM 在 VSCode 的支援
 * [azure-search-openai-demo](https://github.com/azure-samples/azure-search-openai-demo) - 一個在Azure上運行的應用程式範例，使用Azure Cognitive Search進行檢索，並使用Azure OpenAI大型語言模型來支持ChatGPT風格和Q&A體驗的檢索增強生成模式。
 * [infiniteGPT](https://github.com/emmethalm/infinitegpt) - InfiniteGPT 是一個 Python 腳本，讓您可以將無限大小的文本輸入到 OpenAI API 中。不再需要繁瑣的複製和粘貼。多線程萬歲！
 * [ToolBench](https://github.com/openbmb/toolbench) - 一個開放平台，用於訓練、服務和評估大型語言模型，以進行工具學習。
 * [localGPT](https://github.com/promtengineer/localgpt) - 使用GPT模型在本地設備上與您的文件進行聊天。沒有數據離開您的設備，100％私密。
 * [azure-search-openai-demo-csharp](https://github.com/azure-samples/azure-search-openai-demo-csharp) - 一個在Azure上運行的應用程式範例，使用Azure Cognitive Search進行檢索，並使用Azure OpenAI大型語言模型來支持ChatGPT風格和Q&A體驗的檢索增強生成模式。
 * [llm](https://github.com/simonw/llm) - 從命令行訪問大型語言模型
 * [AutoGPTQ](https://github.com/panqiwei/autogptq) - 一個基於GPTQ算法的易於使用的LLMs量化套件，具有用戶友好的API。
 * [ALGO](https://github.com/zkx06111/algo) - 🚀介紹 ALGO，一個由 LLM 生成的神諭引導的代碼合成框架。集成了 ALGO，Codex 在競賽級別的問題上提高了 8 倍，ChatGPT 則提高了 1.3 倍。此外，ALGO 在提交前會驗證您的解決方案！🧵📜:🔗:
 * [FairEval](https://github.com/i-eval/faireval) - 大型語言模型不是公平的評估者- 在採用LLMs（例如GPT-4）作為裁判評分的評估中存在偏見- 成功地緩解了偏見，使其更接近人類判斷。
 * [pdf2md](https://github.com/eiaserinnys/pdf2md) - 這個項目pdf2md將學術論文PDF文件轉換為易於閱讀的文本文件。通過分析PDF文件的佈局，應用程序重新結構段落並翻譯所需內容。最終結果是一個方便的導出文本文件。
 * [ontogpt](https://github.com/monarch-initiative/ontogpt) - 基於GPT的本體抽取工具，包括SPIRES
 * [selefra](https://github.com/selefra/selefra) - 這是一款開源的政策即代碼軟件，可為多雲和SaaS環境提供分析，您可以通過自然語言獲得洞察力（由OpenAI提供支持）。
 * [haystack](https://github.com/deepset-ai/haystack) - :mag: Haystack 是一個開源的 NLP 框架，可使用 Transformer 模型和 LLM（GPT-4、ChatGPT 等）與您的數據進行交互。Haystack 提供了生產就緒的工具，可以快速構建複雜的問答、語義搜索、文本生成應用等。
 * [WizardLM](https://github.com/nlpxucan/wizardlm) - 由Evol-Instruct驅動的遵循指令的LLM家族：WizardLM，WizardCoder
 * [sparrow](https://github.com/katanaml/sparrow) - 利用機器學習從文件中提取數據
 * [lamini](https://github.com/lamini-ai/lamini) - 今天：🎉主持用於訓練像ChatGPT這樣的LLM的數據生成器🎉一個開源的LLM，使用Lamini引擎訓練生成的數據👉提前訪問完整培訓的等待名單，包括企業VPC等。
 * [long_stable_diffusion](https://github.com/sharonzhou/long_stable_diffusion) - 長文本轉圖像生成，使用深度生成模型（GPT-3和穩定擴散）的管道。
 * [gpt-migrate](https://github.com/0xpayne/gpt-migrate) - 輕鬆將您的程式碼從一個框架或語言遷移到另一個。
 * [openchat](https://github.com/imoneoi/openchat) - 開放聊天：對於開源模型而言，少即是多
 * [WebGLM](https://github.com/thudm/webglm) - WebGLM：一個高效的網頁增強問答系統（KDD 2023）
 * [MetaGPT](https://github.com/geekan/metagpt) - 多智能體元編程框架：給定老闆需求，輸出產品文件、架構設計、任務列表、程式庫
 * [PdfGptIndexer](https://github.com/raghavan/pdfgptindexer) - 一個高效的工具，使用OpenAI的GPT-2模型和FAISS（Facebook AI相似性搜索）索引來索引和搜索PDF文本數據，旨在實現快速信息檢索和卓越的搜索準確性。
 * [SuperAGI](https://github.com/transformeroptimus/superagi) - <⚡️> SuperAGI - 一個以開發者為主的開源自主人工智能代理框架。讓開發者能夠快速可靠地建立、管理和運行有用的自主代理。
 * [OpenLLM](https://github.com/bentoml/openllm) - 在生產中操作LLMs
 * [GPT-Bargaining](https://github.com/franxyao/gpt-bargaining) - Arxiv 2023年的代碼：通過自我對弈和從AI反饋中的上下文學習來改進語言模型的談判
 * [dreamGPT](https://github.com/divergentai/dreamgpt) - 利用大型語言模型（LLMs）的幻覺進行以新奇驅動的探索。
 * [lnchat](https://github.com/litch/lnchat) - 所以我建立了一个东西 - LNChat。你将这个应用连接到你的节点，然后你可以向它提出明文问题，比如“我的最新频道是什么”，“给我展示一个频道摘要”。ChatGPT填补了这个空白。它非常有趣，但并不是非常有用。至少现在还不是。
 * [ai00_rwkv_server](https://github.com/cgisky1980/ai00_rwkv_server) - 一個比ChatGPT更好的本地化開源AI服務器。
 * [chinese-llm-benchmark](https://github.com/jeinlee1991/chinese-llm-benchmark) - 中文大模型能力評測榜單：覆蓋百度文心一言、chatgpt、阿里通義千問、訊飛星火、belle / chatglm6b 等開源大模型，多維度能力評測。不僅提供能力評分排行榜，也提供所有模型的原始輸出結果！
 * [RankGPT](https://github.com/sunnweiwei/rankgpt) - ChatGPT在搜索方面表現如何？LLMs作為重新排序代理
 * [smile](https://github.com/qiuhuachuan/smile) - 微笑：透過ChatGPT的單輪轉多輪包容性語言擴展，為心理健康支持提供幫助。
 * [C3SQL](https://github.com/bigbigwatermalon/c3sql) - 請將以下內容翻譯成繁體中文。論文C3的代碼：使用ChatGPT進行零樣本文本到SQL的轉換
 * [CodeDroidAI](https://github.com/fmxexpress/codedroidai) - 使用像ChatGPT和Vicuna-13b这样的LLMs，为Delphi Object Pascal和C++Builder生成代碼和表單的人工智能。
 * [ChatGPT-AutoHotkey-Utility](https://github.com/kdalanon/chatgpt-autohotkey-utility) - 一個使用ChatGPT API來處理文本的AutoHotkey腳本。
 * [jekyll-chatgpt-translate](https://github.com/yegor256/jekyll-chatgpt-translate) - 使用ChatGPT自動翻譯Jekyll頁面：您只需要一個OpenAI API金鑰。
 * [autotranslate](https://github.com/lewangdev/autotranslate) - 視頻轉錄和翻譯，使用更快的耳語和ChatGPT。
 * [nextlint](https://github.com/sveltor/nextlint) - 一個豐富的文字編輯器，類似於Notion的編輯器，使用Svelte + Tiptap構建。通過ChatGPT提升寫作體驗。
 * [chatgpt-api-python-sales](https://github.com/boburmirzo/chatgpt-api-python-sales) - 使用ChatGPT和LLM（大型語言模型）應用程式，利用AI驅動的Python API尋找即時銷售。
 * [AiNiee-chatgpt](https://github.com/nekoparapa/ainiee-chatgpt) - 一款基於【mtool】或【Translator++】的chatgpt自動批量翻譯工具，主要用於翻譯各種RPG遊戲。
 * [openai-forward](https://github.com/beidongjiedeguang/openai-forward) - 🚀 一個專為大型語言模型設計的轉發服務 · 一鍵部署你的私人AI代理 · LLM Proxy · OpenAI API反向代理
 * [gpt4-playground](https://github.com/nashex/gpt4-playground) - 複製OpenAI的ChatGPT和Playground環境，以便進行API密鑰的實驗。克隆OpenAI的ChatGPT和Playground環境，以便進行API密鑰的實驗。
 * [github-pr-summary](https://github.com/flows-network/github-pr-summary) - 使用ChatGPT來總結和審查GitHub的Pull Requests。
 * [SiriGPT](https://github.com/nicolodiamante/sirigpt) - 釋放 SiriGPT 的力量：ChatGPT 的智能、DALL·E 的創造力和 Whisper 的精確音頻轉錄相結合，為您的 Apple 設備提供支援的 20 種語言。
 * [chie](https://github.com/chieapp/chie) - 一個功能豐富的桌面應用程式，可用於ChatGPT和其他LLM。
 * [chatnio](https://github.com/zmh-program/chatnio) - 📚 中文網站項目的文件（使用 vitepress）
 * [Selective_Context](https://github.com/liyucheng09/selective_context) - 將您的輸入壓縮到ChatGPT或其他LLMs，讓它們能夠處理2倍的內容並節省40％的記憶體和GPU時間。將您的輸入壓縮到ChatGPT或其他LLMs，讓它們能夠處理2倍的內容並節省40％的記憶體和GPU時間。
 * [GPT-RAG](https://github.com/azure/gpt-rag) - 在我們一路上所收集的資料中分享學習，以安全的方式實現大規模的Azure OpenAI。GPT-RAG核心是在Azure上運行的檢索增強生成模式，使用Azure認知搜索進行檢索，並使用Azure OpenAI大型語言模型來提供ChatGPT風格和問答體驗。
 * [LLMforDialogDataGenerate](https://github.com/threecolorfr/llmfordialogdatagenerate) - 利用ChatGLM2、ChatGPT等大型模型從文件中生成對話數據。
 * [Auto-i18n](https://github.com/linyuxuanlin/auto-i18n) - 使用 ChatGPT 自動將 Markdown 文件批量翻譯為多語言 | Auto translate Markdown 文件 to 多語言 using ChatGPT
 * [chat-with-your-data-solution-accelerator](https://github.com/azure-samples/chat-with-your-data-solution-accelerator) - 一個在Azure上運行的RAG模式解決方案加速器，使用Azure認知搜索進行檢索，並使用Azure OpenAI大型語言模型來提供ChatGPT風格和問答體驗。這包括最常見的需求和最佳實踐。
 * [RSS-GPT](https://github.com/yinan-c/rss-gpt) - 使用ChatGPT來總結您的個人化RSS訂閱。
 * [one-api](https://github.com/songquanpeng/one-api) - OpenAI 接口管理和分發系統，支援 Azure、Anthropic Claude、Google PaLM 2、智譜 ChatGLM、百度文心一言、訊飛星火認知、阿里通義千問、360 智腦以及騰訊混元，可用於二次分發管理金鑰，僅單可執行檔，已打包好 Docker 鏡像，一鍵部署，開箱即用。OpenAI 金鑰管理和重新分發系統，使用單一 API 供所有 LLMs 使用，並具有英文使用者介面。
 * [Baichuan2](https://github.com/baichuan-inc/baichuan2) - 百川智能科技开发的一系列大型语言模型
 * [marqo](https://github.com/marqo-ai/marqo) - 人類的向量搜索。也可在雲端上使用 - cloud.marqo.ai
 * [khoj](https://github.com/khoj-ai/khoj) - 一個AI副駕駛員，為您的第二大腦。在線或離線搜索和與您的個人知識庫聊天。
 * [Otter](https://github.com/luodian/otter) - 🦦 Otter是一個基於OpenFlamingo（DeepMind的Flamingo的開源版本）的多模態模型，經過在MIMIC-IT上的訓練，展示了改進的指示遵從和上下文學習能力。
 * [RWKV-Runner](https://github.com/josstorer/rwkv-runner) - 一個RWKV管理和啟動工具，完全自動化，僅8MB。並提供與OpenAI API兼容的界面。RWKV是一個完全開源且可用於商業用途的大型語言模型。
 * [MNBVC](https://github.com/esbatmop/mnbvc) - MNBVC（Massive Never-ending BT Vast Chinese corpus）超大規模中文語料集。對標chatGPT訓練的40T數據。MNBVC數據集不但包括主流文化，也包括各個小眾文化甚至火星文的數據。MNBVC數據集包括新聞、作文、小說、書籍、雜誌、論文、台詞、帖子、wiki、古詩、歌詞、商品介紹、笑話、糗事、聊天記錄等一切形式的純文本中文數據。
 * [Easydict](https://github.com/tisfeng/easydict) - 一個簡潔優雅的詞典翻譯 macOS App。開箱即用，支持離線 OCR 識別，支持有道詞典，🍎 蘋果系統詞典，🍎 蘋果系統翻譯，ChatGPT，DeepL，Google，Bing，百度和火山翻譯。一個簡潔優雅的詞典和翻譯器 macOS App，用於查詢單詞和翻譯文本。
 * [NExT-GPT](https://github.com/next-gpt/next-gpt) - NExT-GPT：任意到任意多模態大型語言模型的代碼和模型
 * [TavernAI](https://github.com/tavernai/tavernai) - AI語言模型的大氣冒險聊天（KoboldAI、NovelAI、Pygmalion、OpenAI chatgpt、gpt-4）
 * [lmql](https://github.com/eth-sri/lmql) - 一種用於受限制引導和高效LLM編程的語言。
 * [chatarena](https://github.com/farama-foundation/chatarena) - ChatArena（或Chat Arena）是一個為LLMs設計的多智能體語言遊戲環境。其目標是發展AI的溝通和協作能力。
 * [Data-Science-Roadmap](https://github.com/moataz-elmesmary/data-science-roadmap) - 從A到Z的數據科學路線圖
 * [deepeval](https://github.com/confident-ai/deepeval) - LLM（碩士學位法學）評估框架
 * [inference](https://github.com/xorbitsai/inference) - 只需更改一行程式碼，將OpenAI GPT替換為另一個LLM。Xinference讓您可以自由使用任何您需要的LLM。憑藉Xinference，您可以在雲端、本地甚至筆記型電腦上運行推論，使用任何開源語言模型、語音識別模型和多模態模型。
 * [chameleon-llm](https://github.com/lupantech/chameleon-llm) - 請將以下內容翻譯成繁體中文。《Chameleon: Plug-and-Play Compositional Reasoning with Large Language Models》的代碼。
 * [HuatuoGPT](https://github.com/freedomintelligence/huatuogpt) - 華陀GPT，朝著培養語言模型成為醫生的方向前進。（一個開放的醫學GPT）
 * [DB-GPT-Hub](https://github.com/eosphoros-ai/db-gpt-hub) - 一個包含DB-GPT模型、數據集和微調技術的存儲庫，旨在提高文本到SQL的模型性能。
 * [aidea-server](https://github.com/mylxsw/aidea-server) - AIdea 是一款支持 GPT 以及國產大語言模型通義千問、文心一言等，支持 Stable Diffusion 文生圖、圖生圖、 SDXL1.0、超分辨率、圖片上色的全能型 APP。
 * [llm-viz](https://github.com/bbycroft/llm-viz) - 3D 可視化的 GPT 風格 LLM
 * [AppAgent](https://github.com/mnotgod96/appagent) - AppAgent：多模態代理作為智能手機用戶，一個基於LLM的多模態代理框架，旨在操作智能手機應用程序。
 * [AgentBench](https://github.com/thudm/agentbench) - 一個全面的基準來評估LLMs作為代理人
 * [NeumAI](https://github.com/neumtry/neumai) - Neum AI 是一個一流的框架，用於大規模管理向量嵌入的創建和同步。
 * [LLMs-from-scratch](https://github.com/rasbt/llms-from-scratch) - 從頭開始逐步實現類似ChatGPT的LLM
 * [TransformerLens](https://github.com/neelnanda-io/transformerlens) - 一個用於解釋GPT風格語言模型的機械解釋性圖書館
 * [KwaiAgents](https://github.com/kwaikeg/kwaiagents) - 一個具有大型語言模型（LLMs）的廣義信息尋求代理系統。
 * [MotionGPT](https://github.com/openmotionlab/motiongpt) - 【NeurIPS 2023】MotionGPT：以語言模型為基礎的統一運動-語言生成模型，將人類運動視為一種外語
 * [chatgpt-tool-hub](https://github.com/goldfishh/chatgpt-tool-hub) - 一個開源的ChatGPT工具生態系統，您可以將工具與ChatGPT結合，使用自然語言來進行任何操作。一個開源的ChatGPT工具生態系統，您可以將工具與ChatGPT結合，使用自然語言來進行任何操作。
 * [LLMSurvey](https://github.com/rucaibox/llmsurvey) - 調查論文《大型語言模型的綜述》的官方GitHub頁面。《大型語言模型的綜述》調查論文的官方GitHub頁面。
 * [talk2arxiv](https://github.com/evanhu1/talk2arxiv) - 使用ChatGPT與任何ArXiv論文進行對話
 * [autopilot](https://github.com/fjrdomingues/autopilot) - Code Autopilot，一個使用GPT來讀取程式庫、建立上下文並解決任務的工具。
 * [openai-forward](https://github.com/kenyony/openai-forward) - 🚀 大型語言模型高效轉發服務 · 專為LLM設計的高效轉發服務 · OpenAI API反向代理
 * [FasterTransformer](https://github.com/nvidia/fastertransformer) - 與Transformer相關的優化，包括BERT、GPT
 * [hacker-news-digest](https://github.com/polyrabbit/hacker-news-digest) - :newspaper: 讓ChatGPT為您總結Hacker News
 * [openai-translator](https://github.com/lancemoe/openai-translator) - 一個使用 OpanAI 的翻譯器。
 * [llm-paper-daily](https://github.com/xianshang33/llm-paper-daily) - 每日更新 LLM 相關的論文，歡迎訂閱 👏 喜歡的話動動你的小手 🌟 一個
 * [Azure-OpenAI-demos](https://github.com/retkowsky/azure-openai-demos) - Azure Open AI（演示、文件、加速器）。Azure 開放式人工智慧（演示、文件、加速器）。
 * [chatWeb](https://github.com/skywalkerdarren/chatweb) - ChatWeb可以爬取網頁、讀取PDF、DOCX、TXT文件，並提取主要內容，然後根據內容回答您的問題，或者總結關鍵要點。
 * [StreamRAG](https://github.com/video-db/streamrag) - 視頻搜索和串流代理 🕵️‍♂️
 * [gptscript](https://github.com/gptscript-ai/gptscript) - 自然語言編程
 * [sgpt](https://github.com/muennighoff/sgpt) - SGPT：GPT句子嵌入用於語義搜索
 * [visual-openllm](https://github.com/visual-openllm/visual-openllm) - 類似視覺聊天GPT的東西，文心一言的開源版
 * [GPT-Fathom](https://github.com/gpt-fathom/gpt-fathom) - GPT-Fathom 是一個開源且可重現的LLM評估套件，對10多個領先的開源和封閉源LLM以及OpenAI早期模型在20多個經過整理的基準測試下進行基準測試。
 * [OpenCodeInterpreter](https://github.com/opencodeinterpreter/opencodeinterpreter) - OpenCodeInterpreter 是一套開源代碼生成系統，旨在彌合大型語言模型與諸如 GPT-4 代碼解釋器等專有系統之間的差距。它通過增強代碼生成能力，显著提高了代碼生成的能力。
 * [flutter_chatgpt](https://github.com/wewehao/flutter_chatgpt) - Flutter ChatGPT應用程式。Flutter實現的chatgpt聊天應用程式支持自定義模式和上下文連續對話。此外，它支持admob廣告配置，訪問開屏廣告、插頁廣告、橫幅廣告。
 * [ai00_server](https://github.com/ai00-x/ai00_server) - 一個比ChatGPT更好的本地化開源人工智慧伺服器。
 * [CipherChat](https://github.com/robustnlp/cipherchat) - 一個評估LLM安全對齊泛化能力的框架
 * [bonito](https://github.com/batsresearch/bonito) - 一個輕量級的庫，用於生成合成指令調整數據集，無需使用GPT。
 * [azure-open-ai-embeddings-qna](https://github.com/ruoccofabrizio/azure-open-ai-embeddings-qna) - 一個簡單的網絡應用程序，用於OpenAI啟用的文檔搜索。該存儲庫使用Azure OpenAI服務從文檔中創建嵌入向量。為了回答用戶的問題，它檢索最相關的文檔，然後使用GPT-3、GPT-3.5或其他技術。
 * [open-interpreter](https://github.com/openinterpreter/open-interpreter) - 一個針對電腦的自然語言界面
 * [EvaluationPapers4ChatGPT](https://github.com/thu-keg/evaluationpapers4chatgpt) - ChatGPT 的資源、評估和檢測文件
 * [private-gpt](https://github.com/zylon-ai/private-gpt) - 使用GPT的強大功能與您的文件互動，100％私密，無數據洩漏。
 * [VLMEvalKit](https://github.com/open-compass/vlmevalkit) - 大視覺語言模型（LVLMs）的開源評估工具包，支持GPT-4v、Gemini、QwenVLPlus、30多個HF模型、15多個基準測試。
 * [LLMPapers](https://github.com/kseseu/llmpapers) - 論文和作品，適用於大型語言模型（ChatGPT、GPT-3、Codex等）。
 * [AIGenPipeline](https://github.com/stoerr/aigenpipeline) - 基於人工智慧的程式碼生成流程：命令列工具和框架，用於在構建過程中系統性地使用人工智慧生成程式碼。
 * [agency](https://github.com/neurocult/agency) - 🕵️‍♂️ 專為渴望通過乾淨、有效和 Go-idiomatic 方法探索大型語言模型（LLMs）和其他生成式人工智能潛力的開發人員設計的圖書館。
 * [subtitle-translator-electron](https://github.com/gnehs/subtitle-translator-electron) - 請使用 ChatGPT 翻譯字幕
 * [obsidian-ava](https://github.com/different-ai/obsidian-ava) - 使用Obsidian中的ChatGPT快速格式化您的筆記
 * [spacy-transformers](https://github.com/explosion/spacy-transformers) - 🛸 在spaCy中使用预训练的转换器，如BERT、XLNet和GPT-2
 * [chatgpt-universe](https://github.com/cedrickchee/chatgpt-universe) - ChatGPT Universe 是關於 ChatGPT、GPT 和大型語言模型（LLMs）的短暫筆記。
 * [InternVL](https://github.com/opengvlab/internvl) - [CVPR 2024 口头报告] InternVL Family：一种开创性的开源替代方案，接近GPT-4V的表现。
 * [GPTSwarm](https://github.com/metauto-ai/gptswarm) - 🐝 GPTSwarm：LLM代理作為（可優化）圖形
 * [nixtla](https://github.com/nixtla/nixtla) - TimeGPT-1：生產就緒的預先訓練時間序列基礎模型，用於預測和異常檢測。在超過100B數據點上訓練的時間序列生成預訓練變壓器。它能夠準確預測各種領域，如r
 * [TransformerLens](https://github.com/transformerlensorg/transformerlens) - 一個用於解釋GPT風格語言模型機制的圖書館
 * [BetterOCR](https://github.com/junhoyeo/betterocr) - 通過將多個OCR引擎（EasyOCR、Tesseract和Pororo）與🧠 LLM結合，可以更好地檢測文本。
 * [viz-gpt](https://github.com/observedobserver/viz-gpt) - 使用表格數據製作具有聊天界面的上下文數據可視化。人工智能數據可視化。
 * [ChatIE](https://github.com/cocacola-lab/chatie) - 網上版本暫時無法使用，因為我們無法負擔密鑰。您可以複製並在本地運行。注意：我們設置了預設的openai密鑰。如果密鑰超出計劃並且無效，請告訴我們。響應速度取決於openai。（有時候，的
 * [RepoToText](https://github.com/jeremiahpetersen/repototext) - 將整個 GitHub 存儲庫轉換為一個組織良好的 .txt 文件，以便與 LLM's（GPT-4、Claude Opus、Gemini 等）一起使用。
 * [ocular](https://github.com/ocularengineering/ocular) - AI 強化的組織搜索和聊天 - 想像 ChatGpt 遇見 Google 搜索，但由您的數據提供動力。
 * [AutoCoder](https://github.com/bin123apple/autocoder) - 我們推出了一個針對代碼生成任務設計的新模型。它在HumanEval基礎數據集上的測試準確度超過了GPT-4 Turbo（2024年4月）和GPT-4o。
 * [langui](https://github.com/langbaseinc/langui) - 為您的人工智慧設計的使用者界面。針對您的GPT、生成式人工智慧和LLM項目量身定制的開源Tailwind組件。
 * [go-translate](https://github.com/lorniu/go-translate) - Emacs上的翻譯器。支援多個引擎，如Google、Bing、deepL、ChatGPT、StarDict、有道等等。
 * [ChatTTS](https://github.com/2noise/chattts) - 一個用於日常對話的生成式演講模型。
 * [chatgpt-your-files](https://github.com/supabase-community/chatgpt-your-files) - 使用pgvector製作的可用於安全聊天的MVP，可與您的文件進行聊天。
 * [auto-novel](https://github.com/fishhawk/auto-novel) - 輕小說機翻網站，支持網絡小說/文庫小說/本地小說
 * [Q-Bench](https://github.com/q-future/q-bench) - ①[ICLR2024 焦點] (GPT-4V/Gemini-Pro/Qwen-VL-Plus+16 OS MLLMs) 低層次視覺和視覺質量評估的多模式LLMs（MLLMs）基準。
 * [lowcode-vscode](https://github.com/lowcoding/lowcode-vscode) - 低代碼工具，支持ChatGPT和其他LLM
 * [HuatuoGPT-II](https://github.com/freedomintelligence/huatuogpt-ii) - 華陀GPT2，醫學LLM的一階段訓練。 （一個開放的醫學GPT）
 * [AI-Vtuber](https://github.com/whoiswennie/ai-vtuber) - 一個端到端的AI主播定制模塊，當前支持對接b站直播間，支持本地chatglm3和智譜api語言模型，支持so-vits-svc、gpt-sovits和bert-vits2語音模型。
 * [Recommendation-Systems-without-Explicit-ID-Features-A-Literature-Review](https://github.com/westlake-repl/recommendation-systems-without-explicit-id-features-a-literature-review) - 預先訓練的基礎推薦模型紙張清單
 * [mem0](https://github.com/mem0ai/mem0) - LLM的長期記憶
 * [Github-Ranking-AI](https://github.com/yuxiaopeng/github-ranking-ai) - 根据它们收到的星星数量，列出GitHub上最受欢迎的人工智能主题仓库清单。| 每日自动更新。
 * [searchGPT](https://github.com/michaelthwan/searchgpt) - 基於LLM / ChatGPT / OpenAI API的有依據的搜索引擎（即具有來源參考）。它支持網絡搜索、文件內容搜索等。
 * [rag-gpt](https://github.com/gpt-open/rag-gpt) - RAG-GPT通過利用LLM和RAG技術，從用戶定製的知識庫中學習，為各種查詢提供相應的答案，確保快速準確的信息檢索。
 * [embedJs](https://github.com/llm-tools/embedjs) - 一個 NodeJS RAG 框架，可以輕鬆地處理LLMs和嵌入。
 * [AmadeusGPT](https://github.com/adaptivemotorcontrollab/amadeusgpt) - [NeurIPS 2023] 我們將行為的自然語言描述轉換為機器可執行的代碼
 * [fastapi](https://github.com/iimeta/fastapi) - 智元 Fast API 是一站式API管理系統，將各類LLM API進行統一格式、統一規範、統一管理，使其在功能、性能和用戶體驗上達到極致。
 * [gtt](https://github.com/eeexun/gtt) - Google 翻譯 TUI（原始）。現在支持 Apertium、Argos、Bing、ChatGPT、DeepL、DeepLX、Google、Reverso。
 * [AlignBench](https://github.com/thudm/alignbench) - 大型多維度中文對齊評測基準（ACL 2024）
 * [factool](https://github.com/gair-nlp/factool) - FacTool：生成式AI中的事實性檢測
 * [tree-of-thought-puzzle-solver](https://github.com/jieyilong/tree-of-thought-puzzle-solver) - 思維樹（ToT）框架用於使用LLMs解決複雜推理任務
 * [llmgraph](https://github.com/dylanhogg/llmgraph) - 使用LLMs創建知識圖譜
 * [Sunsimiao](https://github.com/x-d-lab/sunsimiao) - 🌿孫思邈中文醫療大模型(Sunsimiao)：提供安全、可靠、普惠的中文醫療大模型
 * [MiniCPM](https://github.com/openbmb/minicpm) - MiniCPM3-4B：一個超越GPT-3.5-Turbo的邊緣LLM。
 * [cloudflare-rag](https://github.com/rafalwilinski/cloudflare-rag) - 全棧“與您的PDF進行聊天”的RAG（檢索增強生成）應用程序完全構建在Cloudflare上
 * [empower-functions](https://github.com/empower-ai/empower-functions) - 應用於真實世界工具使用案例的GPT-4級別功能調用模型
 * [HallusionBench](https://github.com/tianyi-lab/hallusionbench) - [CVPR'24] HallusionBench：你看到的是你想到的嗎？還是你想到的是你看到的？一個挑戰GPT-4V(ision)、LLaVA-1.5和其他多模型的圖像-上下文推理基準測試。
 * [repo2txt](https://github.com/abinthomasonline/repo2txt) - 基於網頁的工具將GitHub存儲庫內容轉換為單個格式化文本文件
 * [bigcodebench](https://github.com/bigcode-project/bigcodebench) - BigCodeBench：基於AGI的代碼生成基準测试
 * [FastGPT](https://github.com/labring/fastgpt) - FastGPT是基於LLMs構建的知識平台，提供了一套全面的即插即用功能，如數據處理、RAG檢索和視覺AI工作流程編排，讓您輕鬆開發和部署複雜的問答。
 * [guardrails](https://github.com/guardrails-ai/guardrails) - 將護欄添加到大型語言模型。
 * [E2B](https://github.com/e2b-dev/e2b) - 安全的開源雲運行時，適用於AI應用程序和AI代理程序
 * [MaxKB](https://github.com/1panel-dev/maxkb) - 🚀 基於大型語言模型和 RAG 的知識庫問答系統。開箱即用、模型中立、靈活編排，支持快速嵌入到第三方業務系統。
 * [SillyTavern](https://github.com/sillytavern/sillytavern) - LLM 高級用戶前端。
 * [instructor](https://github.com/jxnl/instructor) - 給LLMS的結構化輸出
 * [instructor](https://github.com/instructor-ai/instructor) - 給LLMS的結構化輸出
 * [buzz](https://github.com/chidiwilliams/buzz) - 巴茲在您的個人電腦上離線轉錄和翻譯音頻。由OpenAI的Whisper提供動力。
 * [ai](https://github.com/vercel/ai) - 使用React、Svelte、Vue和Solid构建AI驱动的应用程序
 * [rivet](https://github.com/ironclad/rivet) - 開源視覺人工智慧編程環境和TypeScript庫
 * [griptape](https://github.com/griptape-ai/griptape) - 用於AI代理和工作流程的模塊化Python框架，具有思維鏈推理、工具和記憶功能。
 * [agentic](https://github.com/transitive-bullshit/agentic) - 與任何LLM和TypeScript AI SDK配合使用的AI代理stdlib。AI代理stdlib，可與任何LLM和TypeScript AI SDK配合使用。
 * [faster-whisper](https://github.com/systran/faster-whisper) - 使用CTranslate2進行更快速的Whisper轉錄
 * [tokencost](https://github.com/agentops-ai/tokencost) - 400多個LLM的Easy token價格估算。TokenOps。
 * [TEN-Agent](https://github.com/ten-framework/ten-agent) - TEN Agent 是全球第一個與 OpenAI 實時 API、RTC 整合的實時多模式代理，具有天氣查詢、網絡搜索、視覺和 RAG 功能。
 * [refact](https://github.com/smallcloudai/refact) - 用於微調和自行託管開源大型語言模型進行編碼的WebUI
 * [ax](https://github.com/ax-llm/ax) - 非官方DSPy框架。基於斯坦福DSP論文構建由LLM驅動的代理和“代理工作流”。
 * [code-interpreter](https://github.com/e2b-dev/code-interpreter) - Python和JS/TS SDK，用於在您的AI應用程序中運行AI生成的代碼/代碼解釋。
 * [atomic-agents](https://github.com/brainblend-ai/atomic-agents) - 建立AI代理人，原子化


## Langchain

 * [langchain](https://github.com/hwchase17/langchain) - ⚡ 通過可組合性使用LLMs構建應用程序 ⚡
 * [text-generation-webui](https://github.com/oobabooga/text-generation-webui) - 一個 Gradio 網頁界面，可用於運行大型語言模型，如 LLaMA、llama.cpp、GPT-J、OPT 和 GALACTICA。
 * [llama_index](https://github.com/jerryjliu/llama_index) - LlamaIndex（GPT指數）是一個項目，提供一個中央界面，將您的LLM與外部數據連接起來。
 * [llama](https://github.com/facebookresearch/llama) - LLaMA模型的推論代碼
 * [GPTQ-for-LLaMa](https://github.com/qwopqwop200/gptq-for-llama) - 使用GPTQ的LLaMA的4位量化
 * [gptuber-by-langchain](https://github.com/karakuri-ai/gptuber-by-langchain) - GPT會當YouTuber
 * [intelgpt](https://github.com/phishing-hunter/intelgpt) - IntelGPT 是一個命令行工具，可以使用 GPT3 檢查特定輸入，例如 URL、文件哈希、域名和 IP 地址。
 * [knowledge-gpt](https://github.com/geeks-of-data/knowledge-gpt) - 使用GPT和其他語言模型從所有信息源中提取知識。對信息源進行索引並進行問答會話。
 * [llama_index_starter_pack](https://github.com/logan-markewich/llama_index_starter_pack) - 這個存儲庫提供了llama_index（前身為gpt_index）包的非常基本的flask、streamlit和docker示例。
 * [xturing](https://github.com/stochasticai/xturing) - 建立並控制您自己的LLMs
 * [llama-int8](https://github.com/tloen/llama-int8) - LLaMA模型的量化推論代碼
 * [point-alpaca](https://github.com/pointnetwork/point-alpaca) - 我們從重新創建的斯坦福羊駝7b中釋放了我們的權重-在合成指令數據集上進行了羊駝微調。結果出奇的好：（請記住，以下結果僅來自最小的7b模型；GPT-3是175b）
 * [agentchain](https://github.com/jina-ai/agentchain) - 將LLMs鏈接在一起進行推理，並協調多個大型模型以完成複雜任務。
 * [llm-strategy](https://github.com/blackhc/llm-strategy) - 直接將Python連接到LLMs - Dataclasses＆Interfaces <-> LLMs
 * [llama-cpp-python](https://github.com/abetlen/llama-cpp-python) - llama.cpp 的 Python 綁定
 * [basaran](https://github.com/hyperonym/basaran) - Basaran是OpenAI文本完成API的開源替代方案。它為基於Hugging Face Transformers的文本生成模型提供兼容的流API。
 * [llama-lab](https://github.com/run-llama/llama-lab) - 如果您使用 @gpt_index 建立了一個空間，請填寫此表格！感謝 Logan 從頭開始的努力，為 Llama AGI 貢獻了他的功勞。
 * [Ask-Anything](https://github.com/opengvlab/ask-anything) - ChatGPT 具有視頻理解功能！還支持許多其他語言模型，如miniGPT4、StableLM和MOSS。
 * [VLog](https://github.com/showlab/vlog) - 使用ChatGPT、CLIP、BLIP2、GRIT、Whisper、LangChain將視頻轉換為文檔。
 * [alpaca-lora](https://github.com/tloen/alpaca-lora) - 在消費者硬件上指導調整LLaMA。
 * [ClassGPT](https://github.com/benthecoder/classgpt) - ChatGPT 課程講義
 * [KoAlpaca](https://github.com/beomi/koalpaca) - KoAlpaca：基於斯坦福大學Alpaca模型的韓國羊駝模型（附帶LLAMA和Polyglot-ko）
 * [novice-ChatGPT](https://github.com/aiplaybookin/novice-chatgpt) - 使用LangChain、LlamaIndex、Guardrails、AutoGPT等ChatGPT API的用法
 * [ai-playground](https://github.com/mklarqvist/ai-playground) - 我正在玩Perplexity AI，想弄清楚它是如何工作的。所以我用@openai gpt-3.5turbo、@langchainai、@trychroma编写了一个简单的开源克隆，并提供了文档。来看看吧。
 * [alpaca-electron](https://github.com/itspi3141/alpaca-electron) - 更簡單的運行Alpaca的方法
 * [langflow](https://github.com/logspace-ai/langflow) - ⛓️ LangFlow 是 LangChain 的 UI，使用 react-flow 設計，提供了一種輕鬆的方式來實驗和原型化流程。
 * [gpt4all-ts](https://github.com/nomic-ai/gpt4all-ts) - gpt4all和llama的TypeScript绑定
 * [pyllamacpp](https://github.com/nomic-ai/pyllamacpp) - 官方支援的 llama.cpp + gpt4all Python 綁定程式。
 * [llama.cpp](https://github.com/ggerganov/llama.cpp) - Facebook的LLaMA模型在C/C++的端口
 * [dalai](https://github.com/cocktailpeanut/dalai) - 在本地機器上運行LLaMA的最簡單方法
 * [GenAI_LLM_timeline](https://github.com/hollobit/genai_llm_timeline) - ChatGPT、生成式AI和LLMs時間軸
 * [open_llama](https://github.com/openlm-research/open_llama) - OpenLLama - 是Meta AI的LLaMA的開源軟體，採用寬鬆授權。🦙「OpenLLaMA在大多數任務上表現與原始LLaMA和GPT-J相當，並在某些任務上表現優異。」👀
 * [pyCodeAGI](https://github.com/chakkaradeep/pycodeagi) - 我的目前探索：PyCodeAGI，一個 @LangChainAI #AIAgent，可以根據目標建立一個Python控制台應用程序，現在憑藉 @OpenAI #GPT4 獲得了超能力：要求它建立一個“魔法應用程序”-它建立了一些創意。甚至沒有一個錯誤...
 * [Multimodal-GPT](https://github.com/open-mmlab/multimodal-gpt) - 多模態-GPT
 * [snowChat](https://github.com/kaarthik108/snowchat) - 在您的雪花數據庫上聊天 - 文本轉SQL
 * [DB-GPT](https://github.com/csunny/db-gpt) - 使用本地GPT與您的數據和環境進行互動，無數據洩露，100％私密，100％安全。
 * [LaWGPT](https://github.com/pengxiao-song/lawgpt) - 🎉 LaWGPT 儲存庫，中國駝峰調整，搭載中國法律知識的大型語言模型。
 * [InternGPT](https://github.com/opengvlab/interngpt) - InternGPT（iGPT）是一個開源的演示平台，您可以輕鬆展示您的AI模型。現在它支持DragGAN、ChatGPT、ImageBind、像GPT-4、SAM、交互式圖像編輯等多模態聊天。請在igpt.opengvlab.com上嘗試。
 * [chainlit](https://github.com/chainlit/chainlit) - 在幾分鐘內建立Python LLM應用程式 ⚡️
 * [Flowise](https://github.com/flowiseai/flowise) - 拖放式的使用者介面，讓您可以使用LangchainJS建立您自訂的LLM流程。
 * [semantic-search-nextjs-pinecone-langchain-chatgpt](https://github.com/dabit3/semantic-search-nextjs-pinecone-langchain-chatgpt) - 將文本文件嵌入向量中，存儲在Pinecone中，並使用GPT3和Langchain在Next.js UI中啟用語義搜索。
 * [redpajama.cpp](https://github.com/togethercomputer/redpajama.cpp) - 擴展原始的llama.cpp存儲庫以支持redpajama模型。
 * [OgbujiPT](https://github.com/uogbuji/ogbujipt) - 透過 langchain 和其他方式使用自託管的大型語言模型工具箱
 * [godot-dodo](https://github.com/minosvasilias/godot-dodo) - 微調大型語言模型以生成GDScript。
 * [eva](https://github.com/georgia-tech-db/eva) - 建立更簡單、更快速的人工智慧應用程式的資料庫系統
 * [LangChain-Tutorials](https://github.com/sugarforever/langchain-tutorials) - 非常好奇ChatGPT那種流式輸出，費了牛勁，堆砌出了基於Python LangChain的實現，涵蓋控制台和Web3應用的異步流式輸出。Python異步編程還需深入學習🧐代碼👇視頻分享👇bilibili:   #LangChain #ChatGPT #OpenAI
 * [chat-efficient](https://github.com/coefficientsystems/chat-efficient) - 使用Streamlit、LangChain和開源LLMs進行DIY ChatGPT
 * [gpt-producer](https://github.com/juankysoriano/gpt-producer) - 介紹「GPT-Producer」，帶上你的數位鋼琴、@OpenAI API金鑰和你的#GPU，成為一位藝術家！感謝@LangChainAI和@MetaAI提供的工具，使這一切成為可能！ #musicgen #audiocraft #gpt
 * [MedicalGPT](https://github.com/shibing624/medicalgpt) - 醫學GPT：使用ChatGPT訓練流程來訓練您自己的醫學GPT模型。
 * [rag-stack](https://github.com/psychic-api/rag-stack) - 🤖 在您的虛擬私有雲中部署一個私有的 ChatGPT 替代方案。🔮 將其連接到您組織的知識庫，並將其用作企業的神諭。支持像 Llama 2、Falcon 和 GPT4All 這樣的開源 LLM。
 * [opencompass](https://github.com/internlm/opencompass) - OpenCompass 是一個 LLM 評估平台，支援超過 50 個數據集的多種模型（LLaMA、LLaMa2、ChatGLM2、ChatGPT、Claude 等）。
 * [dolphin](https://github.com/kaleido-lab/dolphin) - 基於LLMs的通用視頻互動平台，包括Video ChatGPT。
 * [api-for-open-llm](https://github.com/xusenlinzy/api-for-open-llm) - 使用LLMs作为ChatGPT的开放AI风格API，开放大型语言模型的统一后端接口。
 * [AtomGPT](https://github.com/atomecho/atomgpt) - 中英文預訓練大模型，目標與ChatGPT的水平一致中英文預訓練大模型，目標與ChatGPT的水平一致
 * [litellm](https://github.com/berriai/litellm) - 一個簡單輕巧的套件，可用於調用OpenAI、Azure、Cohere和Anthropic API端點。
 * [BayLing](https://github.com/ictnlp/bayling) - “百聆”是一個基於LLaMA的語言對齊增強的英語/中文大語言模型，具有優越的英語/中文能力，在多語言和通用任務等多項測試中取得ChatGPT 90%的性能。BayLing是一個配備先進語言對齊功能的英語/中文LLM，展示出在英語/中文生成、指令遵從和多輪互動方面的優越能力。
 * [auto-news](https://github.com/finaldie/auto-news) - 一個個人新聞聚合器，可以從多個來源中提取信息，並利用LLM（通過LangChain的ChatGPT）幫助我們以更高效的方式閱讀，減少干擾。這些來源包括：推特、RSS、YouTube、網絡文章、Reddit和個人日記筆記。
 * [Zhongjing](https://github.com/suprityoung/zhongjing) - 一個基於LLaMa的中醫ChatGPT，使用大規模預訓練語料庫和多輪對話數據集進行訓練。
 * [opencompass](https://github.com/open-compass/opencompass) - OpenCompass 是一個 LLM 評估平台，支援超過 50 個數據集的多種模型（LLaMA、LLaMa2、ChatGLM2、ChatGPT、Claude 等）。
 * [gradioGPT](https://github.com/francescosaveriozuppichini/gradiogpt) - 使用Gradio和Langchain的下一個ChatGPT應用程式的易於入侵的模板
 * [FindTheChatGPTer](https://github.com/chenking2020/findthechatgpter) - ChatGPT爆火，開啟了通往AGI的關鍵一步，本專案旨在匯總那些ChatGPT的開源平替們，包括文本大模型、多模態大模型等，為大家提供一些便利。
 * [gpt_academic](https://github.com/binary-husky/gpt_academic) - 為ChatGPT/GLM提供實用化交互界面，特別優化論文閱讀/潤色/寫作體驗，模塊化設計，支持自定義快捷按鈕和函數插件，支持Python和C++等項目剖析和自譯解功能，PDF/LaTex論文翻譯和總結功能，支持並行問詢多種LLM模型，支持chatglm2等本地模型。兼容文心一言，moss，llama2，rwkv，claude2，通義千問，書生，訊飛星火等。
 * [Real_time_fallacy_detection](https://github.com/latent-variable/real_time_fallacy_detection) - 即時辨識謬誤使用OpenAI whisper和ChatGPT/LLaMA/Mistral
 * [evadb](https://github.com/georgia-tech-db/evadb) - AI 引擎應用的資料庫系統
 * [langchain4j](https://github.com/langchain4j/langchain4j) - Java 版本的 LangChain
 * [llm-chain](https://github.com/sobelio/llm-chain) - `llm-chain` 是一個強大的 Rust 庫，用於在大型語言模型中構建鏈條，讓您能夠對文本進行摘要和完成複雜任務。
 * [langroid](https://github.com/langroid/langroid) - 利用多智能體編程來應用LLMs
 * [EasyEdit](https://github.com/zjunlp/easyedit) - 一個易於使用的知識編輯框架，適用於LLMs。
 * [llama_index](https://github.com/run-llama/llama_index) - LlamaIndex（前身為GPT Index）是一個針對您的LLM應用程序的數據框架。
 * [Alpaca-CoT](https://github.com/phoebussi/alpaca-cot) - 我們統一了指令調整數據（例如CoT數據）、多個LLM和參數高效方法（例如lora、p-tuning）的接口，以便易於使用。我們歡迎開源愛好者在這個存儲庫上發起任何有意義的PR，並集成盡可能多的LLM相關技術。
 * [azure-openai-proxy](https://github.com/stulzq/azure-openai-proxy) - Azure OpenAI 服務代理。將 OpenAI 官方 API 請求轉換為 Azure OpenAI API 請求。支援 GPT-4、嵌入式、Langchain。從 OpenAI 轉換為 Azure OpenAI 的適配器。
 * [code-review-gpt](https://github.com/mattzcarey/code-review-gpt) - 您的個人代碼審查員，由LLMs（OpenAI GPT-3.5/4，Llama2，Azure AI）和嵌入式技術提供支持⚡️ 提升代碼質量，在破壞生產之前捕捉錯誤🚀
 * [GPTRouter](https://github.com/writesonic/gptrouter) - 順利管理多個LLM（OpenAI，Anthropic，Azure）和圖像模型（Dall-E，SDXL），加快回應速度，確保不間斷的可靠性。
 * [dr-doc-search](https://github.com/namuan/dr-doc-search) - 與書對話 - 搭載GPT-3
 * [talk-codebase](https://github.com/rsaryev/talk-codebase) - 使用OpenAI、LlamaCpp和GPT-4-All的工具，可以与您的代码库和文档进行聊天。
 * [LLPhant](https://github.com/theodo-group/llphant) - LLPhant - 一個使用OpenAI GPT 4的全面PHP生成AI框架。受到Langchain和LLamaIndex的啟發。
 * [Auto-Llama-cpp](https://github.com/rhohndorf/auto-llama-cpp) - 使用Llama.cpp和Auto-GPT
 * [entaoai](https://github.com/akshata29/entaoai) - 使用您自己的數據進行聊天和提問。加速器可快速上傳您自己的企業數據並使用OpenAI服務與上傳的數據進行聊天和提問。
 * [kani](https://github.com/zhudotexe/kani) - kani（カニ）是一個高度可修改的微框架，用於基於聊天的語言模型，具有工具使用/函數調用功能。（NLP-OSS @ EMNLP 2023）
 * [PIXIU](https://github.com/chancefocus/pixiu) - 這個儲存庫介紹了PIXIU，一個開源資源，其中包含了第一個金融大型語言模型（LLMs），指令調整數據和評估基準，以全面評估金融LLMs。我們的目標是不斷推動開放。
 * [open-webui](https://github.com/open-webui/open-webui) - ChatGPT風格的Ollama網頁用戶界面（原名Ollama WebUI）
 * [CareGPT](https://github.com/wangrongsheng/caregpt) - 🌞 CareGPT (關懷GPT)是一個醫療大語言模型，同時它集合了數十個公開可用的醫療微調數據集和開放可用的醫療大語言模型，包含LLM的訓練、測評、部署等以促進醫療LLM快速發展。醫療LLM，開源驅動，為健康未來。
 * [PIXIU](https://github.com/the-finai/pixiu) - 這個存儲庫介紹了PIXIU，這是一個開源資源，提供了第一個金融大型語言模型（LLMs）、指導調整數據和評估基準，以全面評估金融LLMs。我們的目標是不斷推動開放。
 * [generative_ai_with_langchain](https://github.com/benman1/generative_ai_with_langchain) - 請使用Python、ChatGPT和其他模型來建立大型語言模型（LLM）應用程式。這是與LangChain上生成式人工智能書籍相關的存儲庫。
 * [llm-books](https://github.com/morsoli/llm-books) - 利用LLM構建應用實踐筆記
 * [langflow](https://github.com/langflow-ai/langflow) - ⛓️ Langflow 是一個動態圖，其中每個節點都是可執行的單元。其模塊化和互動設計促進了快速實驗和原型設計，大大挑戰了創造力的極限。
 * [ChatLLM](https://github.com/yuanjie-ai/chatllm) - 輕鬆玩轉LLM兼容openai&langchain，支持文心一言、訊飛星火、騰訊混元、智譜ChatGLM等。
 * [MiniCPM-V](https://github.com/openbmb/minicpm-v) - MiniCPM-Llama3-V 2.5：在您的手机上使用的GPT-4V级MLLM
 * [LLamaTuner](https://github.com/jianzhnie/llamatuner) - 簡單高效的微調LLM（支持LLama、LLama2、LLama3、Qwen、Baichuan、GLM、Falcon）大模型高效量化訓練+部署。
 * [langtorch](https://github.com/li2109/langtorch) - 🔥 使用Java構建可組合的LLM應用程序和工作流程。
 * [dialog](https://github.com/talkdai/dialog) - RAG LLM Ops應用程式，用於輕鬆部署和測試
 * [aikit](https://github.com/sozercan/aikit) - 🏗️ 輕鬆微調、構建和部署開源LLMs！
 * [llm-ui](https://github.com/llm-ui-kit/llm-ui) - 用於LLMs的React庫
 * [search_with_ai](https://github.com/yokingma/search_with_ai) - 🤖 免費AI搜索，💡 開源困惑度，📍 支持Ollama/SearXNG，支持Docker部署。 讓AI大模型和搜索引擎回答你的問題，支持本地大模型(Ollama)、聚合搜索引擎SearXNG，支持Docker一鍵部署。
 * [GPT-Actions](https://github.com/anil-matcha/gpt-actions) - GPT Auth 提供了一個用戶友好的解決方案，可以快速設置您自定義的 GPT 和自行託管的 oauth。
 * [langchain-swift](https://github.com/buhe/langchain-swift) - 🚀 LangChain for Swift。針對iOS、macOS、watchOS（部分）和visionOS進行了優化。（beta）
 * [RepoAgent](https://github.com/openbmb/repoagent) - 一個由LLM驅動的存儲庫代理，旨在幫助開發人員和團隊快速生成文檔並理解存儲庫。
 * [obsidian-local-gpt](https://github.com/pfrankov/obsidian-local-gpt) - 本地 Ollama 和類似 OpenAI 的 GPT 協助，以確保最大隱私和離線訪問。
 * [LangChain-Chinese-Getting-Started-Guide](https://github.com/liaokongvfx/langchain-chinese-getting-started-guide) - LangChain 的中文入門教程
 * [QiZhenGPT](https://github.com/cmkrg/qizhengpt) - 啟真GPT：一個開源的中文醫療大語言模型
 * [azure-search-openai-javascript](https://github.com/azure-samples/azure-search-openai-javascript) - 一個在Azure上運行的檢索增強生成模式的TypeScript示例應用程序，使用Azure AI Search進行檢索，並使用Azure OpenAI和LangChain大型語言模型（LLMs）來支持ChatGPT風格和問答體驗。
 * [LLaMA-Omni](https://github.com/ictnlp/llama-omni) - LLaMA-Omni是一個建立在Llama-3.1-8B-Instruct基礎上的低延遲和高質量的端到端語音交互模型，旨在實現GPT-4o級別的語音能力。
 * [text2text](https://github.com/artitw/text2text) - 文本2文本：跨語言自然語言處理/生成工具包
 * [llama.go](https://github.com/gotzmann/llama.go) - llama.go 就像純粹的 Golang 中的 llama.cpp 一樣！
 * [autolabel](https://github.com/refuel-ai/autolabel) - 使用LLMs標記、清理和豐富文本數據集。
 * [agentops](https://github.com/agentops-ai/agentops) - Python SDK用於AI代理監控，LLM成本追踪，基準測試等。與大多數LLM和代理框架集成，如CrewAI，Langchain和Autogen。
 * [CyberScraper-2077](https://github.com/itsowen/cyberscraper-2077) - 由LLM | OpenAI、Gemini和Ollama提供動力的強大網絡爬蟲
 * [MLE-agent](https://github.com/mlsysops/mle-agent) - 🤖 MLE-Agent：您無縫AI工程和研究的智能伴侶。🔍 整合arxiv和paper with code，提供更好的代碼/研究計劃 🧰 支持OpenAI、Anthropic、Ollama等。:fireworks: Code RAG
 * [sage](https://github.com/storia-ai/sage) - 在不到兩分鐘內與任何程式碼庫進行聊天 | 完全本地或通過第三方API進行
 * [rocketnotes](https://github.com/fynnfluegge/rocketnotes) - AI 助力的 Markdown 筆記應用程式 - 利用向量嵌入和 LLMs 與您的個人筆記 - 100% 本地或在雲端
 * [search2ai](https://github.com/fatwang2/search2ai) - 在線幫助您的LLM們


## Unity

 * [ChatAI](https://github.com/diegocambiaso/chatai) - Mozilla社群目錄 - 包含所有Mozilla貢獻者的集中目錄！
 * [llama-hub](https://github.com/emptycrown/llama-hub) - 由社群製作的LLM數據加載器庫，可與GPT Index和/或LangChain一起使用。
 * [AICommand](https://github.com/keijiro/aicommand) - ChatGPT 整合 Unity 編輯器
 * [AIShader](https://github.com/keijiro/aishader) - ChatGPT 引擎為 Unity 提供的 Shader 生成器
 * [ChatGPT-API-unity](https://github.com/mochi-neko/chatgpt-api-unity) - 將ChatGPT聊天完成API綁定到Unity純C#上。
 * [OpenAI-Unity](https://github.com/srcnalt/openai-unity) - 一個非官方的 OpenAI Unity 套件，旨在幫助您直接在 Unity 遊戲引擎中使用 OpenAI API。
 * [UnityChatGPT](https://github.com/dilmerv/unitychatgpt) - 在Unity中使用Chat GPT的幾個例子
 * [gptcache](https://github.com/zilliztech/gptcache) - @ferret_db @ossinsight @milvusio 我們很想為gptcache加入ferretdb後端。我們會將其加入待辦清單。代表milvus開發者和更廣泛的社區，感謝你們的提及！
 * [unity-AI-Chat-Toolkit](https://github.com/zhangliwei7758/unity-ai-chat-toolkit) - 使用unity實現AI聊天相關功能。目前這個庫包含了對chatgpt、chatglm等大語言模型的api調用的程式實現以及實現了微軟Azure以及百度AI的語音服務功能，語音服務均採用web api實現，支援Windows/WebGL/Android等平台。
 * [open-ai](https://github.com/orhanerday/open-ai) - OpenAI PHP SDK：最多下載、派生、貢獻、龐大社群支持且被使用的 PHP（Laravel、Symfony、Yii、Cake PHP 或任何 PHP 框架）SDK，用於 OpenAI GPT-3 和 DALL-E。它還支持類似 ChatGPT 的串流功能。（支援 ChatGPT AI）
 * [betterscan-ce](https://github.com/marcinguy/betterscan-ce) - 使用多種工具/掃描器進行代碼掃描/SAST/靜態分析/程式碼檢查 + OpenAI GPT 生成一份報告（代碼、IaC）- Betterscan 社區版（CE）
 * [open-saas](https://github.com/wasp-lang/open-saas) - 一個免費、開源的React和Node.js SaaS應用程式起始器，具有超強功能。適用於生產環境，由社群驅動。
 * [betterscan-ce](https://github.com/topcodersonline-solutions/betterscan-ce) - 使用多種工具/掃描器進行代碼掃描/SAST/靜態分析/程式碼檢查 + OpenAI GPT 生成一份報告（代碼、IaC）- Betterscan 社區版（CE）
 * [betterscan-ce](https://github.com/tcosolutions/betterscan-ce) - 使用多種工具/掃描器進行代碼掃描/SAST/靜態分析/程式碼檢查 + OpenAI GPT 生成一份報告（代碼、IaC）- Betterscan 社區版（CE）
 * [openai-kit](https://github.com/dylanshine/openai-kit) - 一個用於與OpenAI API 互動的社區Swift套件


## Openai

 * [Auto-GPT](https://github.com/torantulino/auto-gpt) - 高級遊戲工程項目 - 立方體像素遊戲製作器
 * [BlenderGPT](https://github.com/gd3kr/blendergpt) - 使用英文命令，利用OpenAI的GPT-4控制Blender。
 * [evals](https://github.com/openai/evals) - Evals 是一個評估 OpenAI 模型的框架，也是一個開源的基準測試庫。
 * [VulChatGPT](https://github.com/ke0z/vulchatgpt) - 使用IDA PRO HexRays反編譯器與OpenAI(ChatGPT)來尋找二進制文件中可能存在的漏洞。
 * [OpenChatKit](https://github.com/togethercomputer/openchatkit) - #openchatkit是第一個開源替代#chatgpt的選擇！🤯它是由前@openai的人（@togethercompute）建立的20b參數模型，並使用@aieleuther的gpt-neox-20b進行了微調！🔗演示：🐙gh：📽️視頻：@itakgol↓
 * [chatgpt-python](https://github.com/labteral/chatgpt-python) - OpenAI的ChatGPT非官方Python SDK
 * [gpt-commit](https://github.com/markuswt/gpt-commit) - 使用ChatGPT生成提交訊息
 * [tiktoken](https://github.com/openai/tiktoken) - tiktoken是一個快速的BPE分詞器，可用於OpenAI的模型。
 * [wolverine](https://github.com/biobootloader/wolverine) - @denfromufa @openai 很棒的工具！但我指的是一個可以在我的終端機上與GPT-4聊天的工具，就像這樣的東西。
 * [chatgpt-clone](https://github.com/amrrs/chatgpt-clone) - 使用OpenAI API和Gradio建立自己的ChatGPT
 * [pyChatGPT](https://github.com/terry3041/pychatgpt) - 一個非官方的Python封裝器，用於OpenAI的ChatGPT API。
 * [davinci-functions](https://github.com/odashi/davinci-functions) - 使用圖書館向OpenAI GPT請求在Python運行時生成對象。
 * [chatgpt_ros](https://github.com/koichirokato/chatgpt_ros) - ChatGPT API 的 ROS 封裝程式
 * [genai](https://github.com/noteable-io/genai) - 如果GPT能幫助你筆記本，會怎麼樣？
 * [GPTReview](https://github.com/iejmac/gptreview) - 使用OpenAI GPT模型來審查您的PR。
 * [scrapeghost](https://github.com/jamesturk/scrapeghost) - 👻 使用OpenAI的GPT API進行網站爬蟲的實驗性程式庫。
 * [Auto-GPT](https://github.com/significant-gravitas/auto-gpt) - 一個實驗性的開源嘗試，旨在使GPT-4完全自主。
 * [openai_tools](https://github.com/alleninstitute/openai_tools) - 使用ChatGPT API探索PDF出版物的腳本集正在增長。
 * [openai-cookbook](https://github.com/openai/openai-cookbook) - 使用OpenAI API的範例和指南
 * [disco-diffusion](https://github.com/alembics/disco-diffusion) - 目前由OpenAI開發的人工智慧模型中，比較知名的有：#chatgpt、#midjourney、#stablediffusionchat。今天為大家更新5個好用的人工智慧算法模型學習渠道，包括：1、神力中文人工智慧算法市場；2、disco-diffusion型；3、百度文心ernie-vilg。
 * [chatgpt-mac](https://github.com/vincelwt/chatgpt-mac) - ChatGPT for Mac，生活在您的菜單欄中。
 * [everything-chatgpt](https://github.com/terminalcommandnewsletter/everything-chatgpt) - :mag: 探索ChatGPT網絡應用程序(chat.openai.com)的運作原理，當然還有一些猜測。
 * [userscripts](https://github.com/adamlui/userscripts) - 🐵 MTurk、ChatGPT 和其他 Greasemonkey 使用者腳本。
 * [chatgpt-mirror](https://github.com/yuezk/chatgpt-mirror) - 基於gpt-3.5-turbo模型的ChatGPT鏡像。
 * [ChatGPTCustomizer](https://github.com/soulhighwing/chatgptcustomizer) - ChatGPTCustomizer 可以利用 ChatGPT API 的強大功能，幫助您個性化您的聊天體驗。
 * [gptproxy](https://github.com/xicilion/gptproxy) - 使用 GitLab API 密鑰代理 OpenAI API。
 * [cloudflare-proxy](https://github.com/barretlee/cloudflare-proxy) - Cloudflare Worker 代理請求 ChatGPT API，支援 Stream 流式輸出。
 * [vscode-chatgpt](https://github.com/gencay/vscode-chatgpt) - 一個非官方的Visual Studio Code - OpenAI ChatGPT整合
 * [chatgpt-demo](https://github.com/ddiu8081/chatgpt-demo) - 一個基於OpenAI API的演示庫。
 * [OpenGpt](https://github.com/futantan/opengpt) - 在幾秒鐘內創建您自己的ChatGPT應用程式。
 * [chatgpt-vercel](https://github.com/ourongxing/chatgpt-vercel) - 優雅而強大。由OpenAI和Vercel提供動力。
 * [ts-chatgpt](https://github.com/takagimeow/ts-chatgpt) - 一個圖書館，旨在接收使用官方ChatGPT API打字的純回應。
 * [openai-node](https://github.com/openai/openai-node) - 用於 OpenAI API 的 Node.js 函式庫
 * [nextjs-openai-doc-search](https://github.com/supabase-community/nextjs-openai-doc-search?og=v2) - 建立自己的定制化 ChatGPT 風格文件搜索模板，由 Next.js、OpenAI 和 Supabase 提供動力。
 * [gptagent.js](https://github.com/lgrammel/gptagent.js) - 使用TS/JS建立人工智慧代理程式
 * [M5Unified_StackChan_ChatGPT](https://github.com/robo8080/m5unified_stackchan_chatgpt) - 「ChatGPT API搭載AIｽﾀｯｸﾁｬﾝ」。
 * [whisper.cpp](https://github.com/ggerganov/whisper.cpp) - OpenAI的Whisper模型的C/C++端口
 * [ChatGPT](https://github.com/lencx/chatgpt) - 🔮 ChatGPT 桌面應用程式（Mac、Windows 和 Linux）
 * [chat-ai-desktop](https://github.com/sonnylazuardi/chat-ai-desktop) - 使用Tauri和Rust的非官方ChatGPT桌面應用程式，適用於Mac和Windows菜單欄。
 * [chatgpt-dingtalk](https://github.com/eryajf/chatgpt-dingtalk) - 🔔 钉钉 & 🤖 GPT-3.5 讓你的工作效率直接起飛 🚀 私聊群聊方式、單聊串聊模式、角色扮演、圖片創作 🚀
 * [go-openai](https://github.com/sashabaranov/go-openai) - OpenAI ChatGPT、GPT-3、GPT-4、DALL·E、Whisper API 的 Go 封裝程式。
 * [feishu-chatgpt](https://github.com/leizhenpeng/feishu-chatgpt) - 🎒飛書 ×（GPT-3.5 + DALL·E + Whisper）= 飛一般的工作體驗 🚀 語音對話、角色扮演、多話題討論、圖片創作、表格分析、文檔導出 🚀
 * [k8sgpt](https://github.com/k8sgpt-ai/k8sgpt) - 讓每個人都擁有 Kubernetes SRE 的超能力
 * [ChatGPT-Proxy-V4](https://github.com/acheong08/chatgpt-proxy-v4) - 基於“puid”的Cloudflare繞過OpenAI
 * [chat-gpt-ppt](https://github.com/williamfzc/chat-gpt-ppt) - 使用ChatGPT（或其他後端）自動生成PPT，全部放在單個文件中。
 * [CallGPT](https://github.com/dmingod/callgpt) - 從您的機器簡單呼叫ChatGPT API的方法
 * [dev-gpt](https://github.com/sampink/dev-gpt) - dev-gpt，一個自動化的Python開發者。
 * [ruby-openai](https://github.com/alexrudall/ruby-openai) - OpenAI API + Ruby！🤖❤️ 現在支援 ChatGPT 和 Whisper...
 * [openai_pipe](https://github.com/aesthetikx/openai_pipe) - 一個UNIX風格的OpenAI介面
 * [gptchatteR](https://github.com/isinaltinkaya/gptchatter) - 一個實驗性和非官方的 R 封裝程式，用於與 OpenAI GPT 模型互動。
 * [askgpt](https://github.com/jbgruber/askgpt) - 建立在OpenAI API端點之上的聊天介面
 * [openai](https://github.com/samterfa/openai) - 這個 R 套件提供了一個 Open AI API 的 SDK。
 * [ChatGptNet](https://github.com/marcominerva/chatgptnet) - 一個針對.NET的ChatGPT整合庫
 * [Simple-ChatGPT-API-Desktop](https://github.com/cranot/simple-chatgpt-api-desktop) - 桌面版簡易ChatGPT API
 * [openai-gpt-dev-notes-for-cn-developer](https://github.com/easychen/openai-gpt-dev-notes-for-cn-developer) - 如何快速開發一個OpenAI/GPT應用：國內開發者筆記
 * [cheetah](https://github.com/leetcode-mafia/cheetah) - Whisper & GPT 基於的應用程式，用於通過遠程 SWE 面試
 * [ChatGPTSwift](https://github.com/alfianlosari/chatgptswift) - 使用Swift訪問ChatGPT API
 * [nitmgpt](https://github.com/deskbtm/nitmgpt) - nitmgpt（中間通知GPT）。通過ChatGPT過濾廣告或垃圾郵件通知。
 * [iChatGPT](https://github.com/37ios/ichatgpt) - OpenAI ChatGPT SwiftUI iOS、iPadOS、macOS 應用程式
 * [SwiftOpenAI](https://github.com/swiftbeta/swiftopenai) - 使用 Swift ❤️ 建立的 OpenAI API
 * [OpenAISwift](https://github.com/adamrushy/openaiswift) - 這是一個封裝 ChatGPT 和 OpenAI HTTP API 的庫。
 * [whetstone.chatgpt](https://github.com/johniwasz/whetstone.chatgpt) - 一個簡單輕量的庫，包裝了Open AI API。
 * [subvert](https://github.com/aschmelyun/subvert) - 在幾秒鐘內從影片中生成字幕、摘要和章節
 * [carrot](https://github.com/xx025/carrot) - 免費ChatGPT網站列表。這裡為您準備了許多好用的ChatGPT鏡像站點，目前有100+個站點。
 * [impressive-chatgpt](https://github.com/sw33tlie/impressive-chatgpt) - OpenAI的ChatGPT令人印象深刻且有用的結果集合
 * [bbFuzzing.txt](https://github.com/reewardius/bbfuzzing.txt) - bbfuzzing.txt是一個獨特的詞彙，其中70％是由openai chatgpt生成的。剩下的30％是來自bo0om、circuit和其他bugbounters的字典編輯。＃chatgpt
 * [chat-with-chatgpt](https://github.com/second-state/chat-with-chatgpt) - 透過 GitHub 問題評論與 ChatGPT 聊天。
 * [ChatGPT](https://github.com/hemulgm/chatgpt) - ChatGPT 原生桌面應用程式（Windows、Mac、Android、iOS 和 Linux）
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt#%e5%ae%89%e8%a3%85%e6%b8%a0%e9%81%93) - ChatGPT暢聊插件。解決所有報錯，讓我們的AI體驗無比順暢、絲滑、高效。並且持續更新更多的增強功能，包括取消審計、克隆對話、淨化首頁等等。
 * [claude-to-chatgpt](https://github.com/jtsang4/claude-to-chatgpt) - 此項目將Anthropic的Claude模型的API轉換為OpenAI Chat API格式。
 * [anse](https://github.com/anse-app/anse) - ChatGPT、DALL-E和Stable Diffusion的超級體驗。
 * [chatgpt-demo](https://github.com/anse-app/chatgpt-demo) - ChatGPT的極簡網頁界面。
 * [casdoor](https://github.com/casdoor/casdoor) - 一個由Casbin和AI Gateway驅動的開源身份和訪問管理（IAM）/單點登錄（SSO）平台，具有支持OAuth 2.0、OIDC、SAML和OpenAI ChatGPT的Web UI。
 * [JetChatGPT](https://github.com/thekharche/jetchatgpt) - 使用OpenAI API在Jetpack Compose中聊天GPT
 * [cosmosdb-chatgpt](https://github.com/azure-samples/cosmosdb-chatgpt) - 結合Azure Cosmos DB和Azure OpenAI ChatGPT服務的樣本應用程式
 * [ix](https://github.com/kreneskyp/ix) - 自主GPT-4代理平台
 * [openai-cloudflare](https://github.com/janlay/openai-cloudflare) - 一個運行在 Cloudflare worker 上的 OpenAI API 代理。
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt#%e5%85%b3%e4%ba%8e-%e5%8f%96%e6%b6%88%e5%ae%a1%e8%ae%a1-%e5%8a%9f%e8%83%bd) - 這是一個ChatGPT的暢聊與增強插件。開源免費。不僅能解決所有報錯不再刷新，還有保持活躍、取消審計、克隆對話、淨化首頁、展示大屏、展示全屏、言無不盡、攔截跟蹤、日新月異等多個高級功能。讓我們的AI體驗無比順暢、絲滑、高效、簡潔。
 * [cf-openai-azure-proxy](https://github.com/haibbo/cf-openai-azure-proxy) - 一個 Cloudflare worker 腳本，用於代理 OpenAI 對 Azure OpenAI 服務的請求。
 * [polyglot](https://github.com/liou666/polyglot) - 🤖️ 桌面端人工智慧語言練習應用程式
 * [k8sgpt-operator](https://github.com/k8sgpt-ai/k8sgpt-operator) - 在您的 Kubernetes 集群中自動啟用 SRE 超能力
 * [obsidian-smart-connections](https://github.com/brianpetro/obsidian-smart-connections) - 在Obsidian中使用筆記進行聊天！此外，即時查看最相關的內容！互動並保持組織。由OpenAI ChatGPT、GPT-4和嵌入式技術提供支持。
 * [nextjs-openai-doc-search](https://github.com/supabase-community/nextjs-openai-doc-search) - 建立自己的定制化 ChatGPT 風格文件搜索模板，由 Next.js、OpenAI 和 Supabase 提供動力。
 * [reliableGPT](https://github.com/berriai/reliablegpt) - 從OpenAI獲得100％的正常運行時間和可靠性。處理速率限制、超時、API和密鑰錯誤。
 * [pva-aoai-integration-solution](https://github.com/city-of-kobe/pva-aoai-integration-solution) - 中身不是很重要，但作為地方政府的努力，這很有趣。Azure OpenAI - 這個存儲庫是為了將在神戶市政府中試用ChatGPT的流程等進行解決方案化並公開而創建的。中身不是很重要，但作為地方政府的努力，這很有趣。Azure OpenAI - 這個存儲庫是為了將在神戶市政府中試用ChatGPT的流程等進行解決方案化並公開而創建的。
 * [jp-azureopenai-samples](https://github.com/azure-samples/jp-azureopenai-samples) - 日本微軟公開了GPT的參考架構。有許多以日語為基礎的樣本實現可供參考！如果掌握了這個存儲庫，將會事半功倍。有日誌和認證等功能，真是太棒了。～樣本列表～1. 面向呼叫中心的GPT助手...
 * [iChatGPT](https://github.com/37mobileteam/ichatgpt) - OpenAI ChatGPT SwiftUI iOS、iPadOS、macOS 應用程式
 * [zod-gpt](https://github.com/dzhng/zod-gpt) - 從OpenAI和Anthropic模型獲取結構化、完全類型化和驗證過的JSON輸出。
 * [ai-beehive](https://github.com/hncboy/ai-beehive) - AI 蜂巢，基於 Java 使用 Spring Boot 3 和 JDK 17，支援的功能有 ChatGPT、OpenAi Image、Midjourney、NewBing 等等
 * [cloudflare-reverse-proxy](https://github.com/gaboolic/cloudflare-reverse-proxy) - 請將以下內容翻譯成繁體中文。cloudflare反向代理|OpenAI/ChatGPT 免翻牆代理|github免翻牆代理|github下載加速|google代理|cloudflare萬能代理cloudflare反向代理|OpenAI/ChatGPT 免翻牆代理|github免翻牆代理|github下載加速|google代理|cloudflare萬能代理
 * [opengpt](https://github.com/gngpp/opengpt) - 一個逆向工程的非官方ChatGPT代理（繞過Cloudflare 403訪問被拒絕）
 * [chatgpt-plus](https://github.com/yangjian102621/chatgpt-plus) - 基於 OpenAI API 實現的 ChatGPT Web 應用，包括通用版和角色版。自帶管理後台，採用 Go + Vue3 + element-plus 實現。
 * [springboot-openai-chatgpt](https://github.com/274056675/springboot-openai-chatgpt) - 超級AI大腦一個基於Spring Boot架構，支持web，Android，IOS，H5多端應用，使用了OpenAI的ChatGPT模型實現了智能聊天機器人。用戶可以在界面上與聊天機器人進行對話，聊天機器人會根據用戶的輸入自動生成回覆。同時也支持畫圖，用戶輸入文本，便可以自動製作文生文生圖。未來會接入：文心一言、通義千問、MOSS等國產AI大模型，持續更新中，更多功能等著你來解鎖
 * [chatgpt-quickstart](https://github.com/azure-samples/chatgpt-quickstart) - 使用Azure OpenAI和ChatGPT构建一个聊天应用程序。
 * [autoblogger](https://github.com/incomestreamsurfer/autoblogger) - 這是一個使用ChatGPT API和Stable Diffusion API的自動部落格系統，可以創建完全優化的部落格文章並自動發佈到WordPress。
 * [chatserver-api](https://github.com/wooveep/chatserver-api) - 基於OPENAI的ChatGPT API開發的AI助手系統 Chatserver-web   支持本地數據向量話提問 基於Golang語言的後端API服務
 * [laravel-synth](https://github.com/blinq-dev/laravel-synth) - 使用ChatGPT生成Laravel代碼
 * [openai-billing-query](https://github.com/woodchen-ink/openai-billing-query) - 單頁面專案，批量可視化查詢openai(chatgpt)餘額，支持顯示總量，已使用，剩餘量，已用比例，到期時間，GPT-4，是否綁卡。這是一個單頁面專案，可以批量查詢openai(chatgpt)餘額的可視化功能。支持顯示總量、已使用量、剩餘量、使用比例、到期時間、GPT-4以及是否綁定卡片。
 * [aks-openai](https://github.com/azure-samples/aks-openai) - 使用Azure Cosmos示例来利用图形API帐户的批量功能
 * [function-gpt](https://github.com/atinylittleshell/function-gpt) - 這是一個 TypeScript 函式庫，可協助處理使用 OpenAI 的 ChatGPT API 進行函式呼叫。
 * [chef-gpt](https://github.com/giacomogaglione/chef-gpt) - 可定制的食谱生成器，由OpenAI和ChatGPT驱动。使用Next.Js、Tailwind CSS、Radix UI、Supabase Clerk构建。
 * [gpt4docstrings](https://github.com/michaelistrofficus/gpt4docstrings) - 使用OpenAI ChatGPT生成Python文檔字符串！！
 * [power-chatgpt](https://github.com/youngle316/power-chatgpt) - 一個用於ChatGPT的強大工具
 * [cg](https://github.com/25077667/cg) - 使用OpenAI的chatGPT免費提交
 * [ninja](https://github.com/gngpp/ninja) - 逆向工程的ChatGPT代理
 * [free-chat](https://github.com/cnseniorious000/free-chat) - 從@anse-app/chatgpt-demo分叉。索引網站位於https://free-chat.asia/。
 * [Vontigo](https://github.com/vontigo/vontigo) - 🛸 Vontigo 是一個使用 SvelteKit 構建的開源 CMS，具備 🤖 AI 驅動（ChatGPT）的內容生成功能。憑藉快速的頁面加載和無縫的路由，Vontigo 提供了一個用戶友好的界面，具有可自定義的主題和模板。
 * [7-docs](https://github.com/7-docs/7-docs) - 使用任何公開的 GitHub 存儲庫作為來源，並通過 ChatGPT 提出相關問題。
 * [chatgpt-pre-commit-hooks](https://github.com/dariuszporowski/chatgpt-pre-commit-hooks) - 使用ChatGPT和OpenAI平台的預提交鉤子集合，用於驗證對代碼庫所做的更改。
 * [chatpad](https://github.com/deiucanta/chatpad) - 不只是另一個ChatGPT使用者介面！
 * [chatgpt-nuxt](https://github.com/lianginx/chatgpt-nuxt) - 基於 Nuxt.js 框架的 ChatGPT 類項目，支援 OpenAI 和 Azure 兩種 API 切換，支援黑暗模式、中英日多語言切換。
 * [chat](https://github.com/libli/chat) - 具有用户管理功能的ChatGPT API透明代理後台
 * [chatgpt-nodejs-web](https://github.com/xingxin666/chatgpt-nodejs-web) - chatgpt nodejs服務，集成了ChatGLM、GPT3.5、GPT4、GPT聯網、必應、Claude、百度文心一言等模型chatgpt nodejs服務，集成了ChatGLM、GPT3.5、GPT4、GPT聯網、必應、Claude、百度文心一言等模型
 * [chatgpt-ui](https://github.com/dvcrn/chatgpt-ui) - 使用Elixir + LiveView編寫的ChatGPT UI，帶有身份驗證，針對商業用途的使用案例。ChatGPT UI具有身份驗證，針對商業用途，使用Elixir + LiveView編寫。
 * [chatgpt-ai-template](https://github.com/horizon-ui/chatgpt-ai-template) - 🧠 Horizon AI 模板 - 最時尚的開源 ChatGPT UI AI 模板和 React、NextJS 及 Chakra UI 的入門套件
 * [chatgpt-history-export-to-md](https://github.com/mohamed-chs/chatgpt-history-export-to-md) - 一個腳本，可以輕鬆從JSON文件中提取整個ChatGPT數據導出，並將其轉換為格式整齊的markdown文件。
 * [chatgpt-aoai](https://github.com/karleeov/chatgpt-aoai) - 使用Azure OpenAI創建您自己的ChatGPT門戶
 * [siyuan](https://github.com/siyuan-note/siyuan) - 一個以隱私為先、自主託管、完全開源的個人知識管理軟體，使用 TypeScript 和 Golang 編寫。
 * [Free-ChatGPT-API](https://github.com/mufeng510/free-chatgpt-api) - 基於Pandora的ChatGPT API，實現了pool token的自動更新。
 * [QChatGPT](https://github.com/rockchinq/qchatgpt) - 😎高穩定性、🧩支援插件、🌏即時聯網的 ChatGPT QQ 機器人🤖 | 支援 ChatGPT、New Bing、Claude、Google Bard、gpt4free、One API 的 QQ 機器人平台
 * [novel](https://github.com/steven-tey/novel) - 具有AI驅動的自動完成功能的Notion風格所見即所得編輯器。
 * [feishu-openai](https://github.com/connectai-e/feishu-openai) - 🎒 飛書 ×（GPT-4 + DALL·E-3 + Whisper）= 飛一般的工作體驗 🚀 語音對話、角色扮演、多話題討論、圖片創作、表格分析、文件導出 🚀
 * [openai](https://github.com/betalgo/openai) - OpenAI .NET sdk - ChatGPT、Whisper、GPT-3、GPT-4、Azure OpenAI 和 DALL-E
 * [chatgpt](https://github.com/dirk1983/chatgpt) - 全網最易部署，響應速度最快的ChatGPT環境。PHP版調用OpenAI接口進行問答和畫圖，採用Stream流模式通信，一邊生成一邊輸出。前端採用EventSource，支持Markdown格式解析，支持公式顯示，代碼有著色處理，支持畫圖。頁面UI簡潔，支持上下文連續會話。源碼只有幾個文件，沒有使用任何框架，支持所有PHP版本，全部開源，極易二次開發。保姆級教程，全部周邊資源，歡迎進群交流，一切全免費。
 * [Dingtalk-OpenAI](https://github.com/connectai-e/dingtalk-openai) - 🎒 釘釘 & 🤖 GPT-3.5 讓你的工作效率直接起飛 🚀 私聊群聊方式、單聊串聊模式、角色扮演、圖片創作 🚀
 * [chatgpt-web](https://github.com/niek/chatgpt-web) - ChatGPT 網頁介面使用 OpenAI API
 * [OpenAI-API-dotnet](https://github.com/okgodoit/openai-api-dotnet) - 一個非官方的C#/.NET SDK，用於訪問OpenAI GPT-3 API
 * [ChatGPT_JCM](https://github.com/202252197/chatgpt_jcm) - OpenAI管理界面，聚合了OpenAI的所有接口進行界面操作(所有模型、圖片、音頻、微調、文件)等，支持Markdown格式(公式、圖表，表格)等，後期會一點一點的將OpenAI接口進行接入大家支持一下，右上角點個Star，我會一直更新下去，大家一起學習，一起加油，一起努力，一起成長。
 * [aiac](https://github.com/gofireflyio/aiac) - 人工智慧基礎設施即代碼生成器。
 * [openai](https://github.com/anasfik/openai) - ChatGPT和所有OpenAI API（GPT、Dall-e..）的Dart/Flutter SDK
 * [chat](https://github.com/swuecho/chat) - 團隊聊天網絡應用程式，具有用戶管理和速率限制，支持ChatGPT（OpenAI和Azure），Claude或自定義模型團隊聊天網絡應用程式，具有用戶管理和速率限制，支持ChatGPT（OpenAI和Azure），Claude或自定義模型
 * [VirtualWife](https://github.com/yakami129/virtualwife) - VirtualWife是一個虛擬數字人項目，項目還處於孵化階段，有很多需要優化的地方，作者想打造一個擁有自己“靈魂”的虛擬數字人，你可以像朋友一樣和她相識，作者希望虛擬數字人融入人類生活，作為戀愛導師，心理咨詢師，解決人類的情感需求。
 * [copilot-gpt4-service](https://github.com/aaamoon/copilot-gpt4-service) - 將Github Copilot的請求轉換為ChatGPT的請求，可以自由使用GPT-4模型。
 * [PatrikZeros-ChatGPT-API-UI](https://github.com/patrikzudel/patrikzeros-chatgpt-api-ui) - 靜態網頁，允許您使用OpenAI API金鑰，獲得與ChatGPT相同的體驗！
 * [NeuroGPT](https://github.com/neurogen-dev/neurogpt) - 免費的ChatGPT 3.5 / ChatGPT 4 | 免費的OpenAI / ChatGPT API
 * [ant-codeAI](https://github.com/sparrow-js/ant-codeai) - AI 生成程式碼
 * [BestGPTs](https://github.com/agentops-ai/bestgpts) - 頂尖的OpenAI GPTs
 * [chat_gpt_sdk](https://github.com/redevrx/chat_gpt_sdk) - Flutter 聊天GPT
 * [chatgpt-web](https://github.com/chatgpt-web-dev/chatgpt-web) - 使用 Express 和 Vue3 搭建的 ChatGPT 此專案 Fork 自 Chanzhaoyu/chatgpt-web 新增了多租戶管理以及雲端訊息同步功能 基於 MIT 協議，免費且作為開源學習使用
 * [tiktoken-go](https://github.com/pkoukk/tiktoken-go) - tiktoken 的 Go 版本
 * [openai-proxy](https://github.com/unickcheng/openai-proxy) - openai-proxy 是為中國用戶提供的解決方案，用於解決無法向 OpenAI API 發送請求的問題。
 * [hello-ai](https://github.com/xxxily/hello-ai) - 搶走你工作的不是AI，而是掌握使用AI工具的人。降維打擊最為致命：毀滅你，與你何干《三體》
 * [ChatGPT-Paper-Reader](https://github.com/talkingwallace/chatgpt-paper-reader) - 這個存儲庫提供了一個簡單的界面，幫助您閱讀和總結 PDF 格式的研究論文。閱讀後，您可以提出一些問題。該界面是基於 openai API 開發的，並使用 GPT-3.5-turbo 模型。
 * [lux-admin-vuetify3](https://github.com/yangjiakai/lux-admin-vuetify3) - 根據Vue3.2、Vite4.1、TypeScript、Vuetify3、Chat GPT、Firebase等創建最佳管理員。
 * [gpt-tokenizer](https://github.com/niieani/gpt-tokenizer) - JavaScript BPE Tokenizer 編碼器解碼器，用於 OpenAI 的 GPT-2 / GPT-3 / GPT-4。具有額外功能的 OpenAI tiktoken 的移植版本。
 * [tiktokenizer](https://github.com/dqbd/tiktokenizer) - 線上遊樂場，用於OpenAPI tokenizers
 * [cognee](https://github.com/topoteretes/cognee) - AI應用程式和AI代理的記憶體管理
 * [finance](https://github.com/saleem-hadad/finance) - 💰由ChatGPT驅動的免費開源個人財務追蹤網絡應用程式。
 * [chatgpt-web](https://github.com/xqdoo00o/chatgpt-web) - 純JavaScript ChatGPT演示，基於OpenAI API
 * [one-api](https://github.com/martialbe/one-api) - OpenAI 介面管理 & 分發系統，改自songquanpeng/one-api。支援更多模型，加入統計頁面，完善非openai模型的函數呼叫。
 * [lux-ui](https://github.com/yangjiakai/lux-ui) - 根據Vue3.x、Vite5.x、TypeScript、Vuetify3.x和Chat GPT創建最佳管理員
 * [chatgpt-pro](https://github.com/eyucoder/chatgpt-pro) - ChatGPT-Pro是一個先進的應用程序，結合了ChatGPT和DALL.E的功能。
 * [AI-Functions](https://github.com/torantulino/ai-functions) - AI 強化功能魔法：使用 GPT 模型，再也不需要編碼了！
 * [chat2api](https://github.com/lanqian528/chat2api) - 一項可以將網絡上的ChatGPT轉換為OpenAI API格式的服務。
 * [ai-codereviewer](https://github.com/freeedcom/ai-codereviewer) - AI 代碼審查員：通過 AI 強化您的 GitHub 工作流程，透過 OpenAI 的 GPT-4 API 在拉取請求上獲得智能反饋和建議，提高代碼質量，節省開發人員的時間。
 * [yomo](https://github.com/yomorun/yomo) - 🦖 用於構建地理分佈式邊緣人工智能基礎設施的有狀態無服務器框架
 * [Gumroad-Landing-Page-Generator](https://github.com/peterw/gumroad-landing-page-generator) - 這個項目是一個使用Python腳本從Gumroad網站爬取數據，並使用OpenAI的GPT-4模型生成一個色彩豐富且設計精美的HTML頁面，然後部署生成的頁面到Vercel。
 * [ninja](https://github.com/0x676e67/ninja) - 反向工程 ChatGPT 代理
 * [chatgpt-adapter](https://github.com/bincooo/chatgpt-adapter) - 集成了openai-api、bing、gemini、coze、繪畫 多款AI的聊天接口適配到 OpenAI API 標準接口服務端。
 * [ChatGPT.Net](https://github.com/pawanosman/chatgpt.net) - OpenAI API 免費反向代理
 * [hisabi](https://github.com/hisabi-app/hisabi) - 💰由ChatGPT驅動的免費開源個人財務追蹤網絡應用程式。
 * [stride-gpt](https://github.com/mrwadams/stride-gpt) - 一個由人工智慧驅動的威脅建模工具，利用OpenAI的GPT模型根據STRIDE方法為特定應用程序生成威脅模型。
 * [generative-manim](https://github.com/360macky/generative-manim) - 🎨 影片生成的 GPT ⚡️
 * [celeris-web](https://github.com/kirklin/celeris-web) - Celeris Web 是一個使用 Vue 3、Vite 和 TypeScript 構建的高性能和可定制的前端開發模板。它具有最新的語法、組件和 API 自動導入、狀態管理、中文字體預設、國際化等功能。
 * [liboai](https://github.com/d7ead/liboai) - 一個用於訪問整個OpenAI API的C++17庫。
 * [tiktoken-rs](https://github.com/zurawiki/tiktoken-rs) - 使用GPT和tiktoken的现成分词库
 * [ai-commit](https://github.com/guanguans/ai-commit) - 使用 AI 自動生成傳統的 git 提交訊息。
 * [MatGPT](https://github.com/toshiakit/matgpt) - MATLAB應用程式，可從OpenAI訪問ChatGPT API
 * [one-hub](https://github.com/martialbe/one-hub) - OpenAI 接口管理 & 分发系統，改自songquanpeng/one-api。支援更多模型，加入統計頁面，完善非openai模型的函數調用。
 * [whodb](https://github.com/clidey/whodb) - 一款輕量級的下一代數據探索器 - 支持Postgres、MySQL、SQLite、MongoDB、Redis、MariaDB和Elastic Search，並帶有聊天界面。
 * [sum4all](https://github.com/fatwang2/sum4all) - 網頁、視頻、圖片大模型總結
 * [Pet-GPT](https://github.com/hanzoe/pet-gpt) - Pet-GPT 是一個使用 PyQt 編寫的桌面寵物程序，支持調用 OpenAI 的 GPT 進行上下文對話，然後主動找你聊天！
 * [PureChat](https://github.com/hyk260/purechat) - PureChat 是一個整合 ChatGPT 的聊天應用程式，基於 Vue3，Vite5，Electron 開發。
 * [OpenGPT-4o](https://github.com/kingnish24/opengpt-4o) - OpenGPT 4o 是 OpenAI GPT 4o 的免費替代方案。
 * [aoai-realtime-audio-sdk](https://github.com/azure-samples/aoai-realtime-audio-sdk) - 使用Azure OpenAI代碼資源來使用gpt-4o實時功能。
 * [inbox-zero](https://github.com/elie222/inbox-zero) - 開源電子郵件應用程式，快速達到收件箱零。
 * [ToolJet](https://github.com/tooljet/tooljet) - 低代碼平台用於構建業務應用程序。連接到數據庫、雲存儲、GraphQL、API端點、Airtable、Google表格、OpenAI等，並使用拖放應用程序構建器構建應用程序。使用JavaScript/TypeScript構建。 🚀
 * [AutoGPT](https://github.com/significant-gravitas/autogpt) - AutoGPT是讓每個人都能夠使用和建立的AI的願景。我們的使命是提供工具，讓您可以專注於重要的事情。
 * [pr-agent](https://github.com/codium-ai/pr-agent) - 🚀CodiumAI PR-Agent：一個AI驅動的🤖工具，用於自動化拉取請求分析、反饋、建議等！💻🔍
 * [whisper-diarization](https://github.com/mahmoudashraf97/whisper-diarization) - 基於OpenAI Whisper的自動語音識別與語者辨識
 * [swarm](https://github.com/openai/swarm) - 教育框架探索符合人體工程學的輕量級多智能體協調。由OpenAI解決方案團隊管理。
 * [DashPlayer](https://github.com/solidspoon/dashplayer) - 為英語學習者量身打造的視頻播放器，助你通過觀看視頻、沉浸真實語境，輕鬆提升英語水平。#美劇 #播放器 #聽力
 * [logfire](https://github.com/pydantic/logfire) - 簡單易用的Python及更多語言的可觀察性！🪵🔥
 * [new-api](https://github.com/calcium-ion/new-api) - AI模型接口管理與分發系統，支持將多種大模型轉為OpenAI格式調用、支持Midjourney Proxy、Suno、Rerank，兼容易支付協議，僅供個人或者企業內部管理與分發渠道使用，請勿用於商業用途，本項目基於One API二次開發。
 * [STranslate](https://github.com/zggsong/stranslate) - 一款由WPF/WPF開發的即開即用、即用即走的翻譯、OCR工具
 * [fastembed](https://github.com/qdrant/fastembed) - 快速、準確、輕量級的Python庫，用於製作最先進的嵌入。
 * [openai-openapi](https://github.com/openai/openai-openapi) - OpenAI API 的 OpenAPI 规范
 * [openai-dotnet](https://github.com/openai/openai-dotnet) - 用於OpenAI API的官方.NET庫
 * [stable-ts](https://github.com/jianfch/stable-ts) - 使用OpenAI的Whisper進行轉錄、強制對齊和音頻索引
 * [async-openai](https://github.com/64bit/async-openai) - OpenAI 的 Rust 库
 * [o1-engineer](https://github.com/doriandarko/o1-engineer) - o1-engineer是一個命令行工具，旨在幫助開發人員有效地管理和互動他們的項目。利用OpenAI的API的強大功能，這個工具提供了代碼生成、文件編輯和項目計劃等功能。
 * [simple-one-api](https://github.com/fruitbars/simple-one-api) - OpenAI 接口接入适配，支持千帆大模型平台、讯飞星火大模型、腾讯混元以及MiniMax、Deep-Seek，等兼容OpenAI接口，僅單可執行文件，配置超級簡單，一鍵部署，開箱即用。無縫集成OpenAI和兼容的API，使用單個可執行文件進行快速設置和部署。
 * [WAAS](https://github.com/schibsted/waas) - 悄悄話服務（具有OpenAI Whisper排隊的GUI和API）
 * [coai](https://github.com/coaidev/coai) - 🚀 下一代 AI 一站式國際化解決方案。🚀 支持 OpenAI，Midjourney，Claude，訊飛星火，穩定擴散，DALL·E，ChatGLM，通義千問，騰訊混元，360 智腦，百川 AI，火山方舟，新必應，Gemini，Moonshot 等模型，支持對話分享，自定義預設，雲端同步，模型市場，支持彈性計費和訂閱計劃模式，支持圖片解析，支持聯網搜索，支持模型。
 * [self-operating-computer](https://github.com/othersideai/self-operating-computer) - 一個能夠讓多模型操作電腦的框架。
 * [blinko](https://github.com/blinko-space/blinko) - 一個開源、自主託管的個人筆記工具，注重隱私，使用TypeScript構建。


## Others

 * [visual-chatgpt](https://github.com/microsoft/visual-chatgpt) - 論文官方存儲庫：Visual ChatGPT：使用視覺基礎模型進行對話、繪圖和編輯
 * [nanoGPT](https://github.com/karpathy/nanogpt) - 最簡單、最快速的中型GPT訓練/微調存儲庫。
 * [gpt_index](https://github.com/jerryjliu/gpt_index) - 使用強大的GPU加速的Python中的張量和動態神經網絡
 * [nebullvm](https://github.com/nebuly-ai/nebullvm) - 插拔式模組可優化您的人工智慧系統表現 🚀
 * [gpt-2-output-dataset](https://github.com/openai/gpt-2-output-dataset) - 用於檢測、偏見等研究的GPT-2輸出數據集
 * [IATelligence](https://github.com/fr0gger/iatelligence) - IATelligence 是一個 Python 腳本，可以提取 PE 檔案的 IAT，並請求 GPT 獲取有關 API 和 ATT＆CK 矩陣的更多信息。
 * [ColossalAI](https://github.com/hpcaitech/colossalai) - 讓大型人工智慧模型更便宜、更快速、更易取得
 * [aoc-gpt](https://github.com/max-sixty/aoc-gpt) - 使用GPT-3解決Advent of Code的謎題
 * [EdgeGPT](https://github.com/acheong08/edgegpt) - 微軟必應聊天機器人API的反向工程
 * [chatGPT-python-elm](https://github.com/vrescobar/chatgpt-python-elm) - 一個由ChatGPT完全生成的存儲庫，使人們相信它已經檢查出了我在README的第一行所描述的這個存儲庫。
 * [Sekiryu](https://github.com/20urc3/sekiryu) - 使用您喜愛的反編譯器和 ChatGPT 自動反編譯和分析二進制文件。
 * [xiaogpt](https://github.com/yihong0618/xiaogpt) - bilibili後台源碼
 * [gpt-wpre](https://github.com/moyix/gpt-wpre) - 使用GPT-3進行整個程式的逆向工程
 * [chatgpt_academic](https://github.com/binary-husky/chatgpt_academic) - 科研工作專用ChatGPT拓展，特別優化學術Paper潤色體驗，支持自定義快捷按鈕，支持markdown表格顯示，Tex公式雙顯示，代碼顯示功能完善，新增本地Python工程剖析功能/自我剖析功能。
 * [chatgpt-api](https://github.com/taranjeet/chatgpt-api) - 這個存儲庫包含解析各種網站的代碼。
 * [babyagi](https://github.com/yoheinakajima/babyagi) - 3個有趣的自主代理項目：- auto-gpt：babyagi：駱駝：哪一個是你最喜歡的？
 * [metaseq](https://github.com/facebookresearch/metaseq) - 外部大型工作的存儲庫
 * [ThreatResearch](https://github.com/securityjoes/threatresearch) - 在我們最近的事件回應中，@charleslomboni 將 #chatgpt 實現到 #ghidra 中。我們已經發布了代碼，所以你也可以使用它：我們稱之為 askjoe 🤠享受並分享。
 * [stable-diffusion-webui](https://github.com/automatic1111/stable-diffusion-webui) - 穩定擴散網頁使用者介面
 * [examples](https://github.com/mosaicml/examples) - 快速靈活的參考基準
 * [ChatGDB](https://github.com/pgosar/chatgdb) - 利用ChatGPT的力量在GDB或LLDB調試器中！
 * [whisper](https://github.com/openai/whisper) - 通過大規模弱監督實現強健的語音識別
 * [point-e](https://github.com/openai/point-e) - 點雲擴散用於3D模型合成
 * [stable-diffusion-webui-chatgpt-utilities](https://github.com/hallatore/stable-diffusion-webui-chatgpt-utilities) - 使得可以直接從UI使用ChatGPT
 * [reflexion](https://github.com/noahshinn024/reflexion) - 反思：具有動態記憶和自我反思能力的自主代理人
 * [stackexplain](https://github.com/shobrook/stackexplain) - 使用ChatGPT解釋您的錯誤訊息。
 * [nanoChatGPT](https://github.com/sanjeevanahilan/nanochatgpt) - 在nanoGPT上使用Gumbel-Softmax技巧的粗糙RLHF層
 * [flash-attention](https://github.com/hazyresearch/flash-attention) - 快速且記憶體效率高的精確注意力機制
 * [cgpt_exceptions](https://github.com/fkhan0520/cgpt_exceptions) - 製作了一個 Python 套件，當出現異常時自動從 ChatGPT 獲取幫助。快來看看吧！
 * [go-gpt3](https://github.com/sashabaranov/go-gpt3) - Python介面到Amazon Web Services
 * [talkGPT](https://github.com/chenyukang/talkgpt) - 一個簡單的Python程式，可以幫助你與ChatGPT對話，練習口語英語...
 * [XX-Net](https://github.com/xx-net/xx-net) - 一個繞過GFW的代理工具。
 * [ida_gpt](https://github.com/mayerdaniel/ida_gpt) - 代碼以將＃chatgpt整合到@hexrayssa中，以評論gpt的功能描述並為您重新命名變量和函數名稱。將＃chatgpt整合到@hexrayssa中的代碼，以評論gpt的功能描述並為您重新命名變量和函數名稱。
 * [pubmedgpt](https://github.com/stanford-crfm/pubmedgpt) - 提高機器學習訓練效率的方法
 * [nanoGPT](https://github.com/karpathy/nanogpt?utm_source=tldrnewsletter) - 最簡單、最快速的中型GPT訓練/微調存儲庫。
 * [slither](https://github.com/crytic/slither) - Solidity 靜態分析器
 * [bpy-chat-gpt](https://github.com/joshuaknauber/bpy-chat-gpt) - 將聊天 GPT API 整合到簡單的混合器插件中。
 * [scrapbox_chatgpt_connector](https://github.com/nishio/scrapbox_chatgpt_connector) - ChatGPT 閱讀 Scrapbox
 * [Partial-English-Subtitle-Translation](https://github.com/goldengrape/partial-english-subtitle-translation) - 各位假門假事兒學英語的親們，我又帶學英語的工具來啦！這次是只翻譯字幕中的生詞，自己選難度。本次 #抛磚 的重點是，通過gpt翻譯出了單詞在句中的含義。網頁版：
 * [GilgaiDetection](https://github.com/geezacoleman/gilgaidetection) - 吉爾蓋檢測的簡單顏色閾值化
 * [chatgpt_stock_report](https://github.com/ddobokki/chatgpt_stock_report) - 利用聊天GPT總結當天的證券報告的報告。
 * [DeeperSpeed](https://github.com/eleutherai/deeperspeed) - DeepSpeed 是一個深度學習優化庫，可以輕鬆、高效、有效地進行分佈式訓練。
 * [MM-REACT](https://github.com/microsoft/mm-react) - MM-REACT 的官方存儲庫
 * [WavCaps](https://github.com/xinhaomei/wavcaps) - 這個儲存庫包含WavCaps數據集的元數據和下游任務的代碼。
 * [Painter](https://github.com/baaivision/painter) - 畫家和SegGPT系列：BAAI的視覺基礎模型
 * [Auto-GPT](https://github.com/kanecohen/auto-gpt) - 一個實驗性的開源嘗試，旨在使GPT-4完全自主。
 * [Robo-GPT](https://github.com/rokstrnisa/robo-gpt) - 一個簡單且可擴展的程式，可幫助您自主運行GPT-4模型。
 * [gpt-4-search](https://github.com/andylokandy/gpt-4-search) - 一個帶有Google搜索功能的命令行GPT-4 REPL，僅需200行代碼。
 * [symbolicai](https://github.com/xpitfire/symbolicai) - 組合式可微編程庫
 * [MiniGPT-4](https://github.com/vision-cair/minigpt-4) - @bentossell minigpt-4 在他們的演示中可以做到這一點。
 * [DeepSpeed](https://github.com/microsoft/deepspeed) - DeepSpeed 是一個深度學習優化庫，使分佈式訓練和推理變得簡單、高效和有效。
 * [micro-gpt](https://github.com/muellerberndt/micro-gpt) - 一個最小的通用自主代理。
 * [gptdeploy](https://github.com/jina-ai/gptdeploy) - 一行程式碼創造它們所有
 * [cloudgpt](https://github.com/ustayready/cloudgpt) - 使用ChatGPT的AWS客戶管理政策漏洞掃描器
 * [LlamaAcademy](https://github.com/danielgross/llamaacademy) - 駝鳥學校
 * [magic-happens](https://github.com/empath-nirvana/magic-happens) - 一個你絕對不應該在任何情況下運行的 Kubernetes 運算子
 * [Multi-GPT](https://github.com/rumpfmax/multi-gpt) - 一個實驗性的開源嘗試，旨在使GPT-4完全自主。
 * [Image2Paragraph](https://github.com/showlab/image2paragraph) - 使用ChatGPT、BLIP2、OFA、GRIT、Segment Anything和ControlNet將圖像轉換為獨特的段落。
 * [xai-gpt-agent-toolkit](https://github.com/xpressai/xai-gpt-agent-toolkit) - Xircuits 工具包，用於創建和實驗 BabyAGI/AutoGPT 風格的代理。
 * [celltypewriter](https://github.com/ntranoslab/celltypewriter) - 👉更新：現在您可以在不需要 #gpt4 API 密鑰的情況下使用 #celltypewriter。我們已經設置了一個 #免費版本，讓您可以在自己的 #數據上試用它。✨這將在幾天內或資金用盡前生效：）玩得開心！GitHub 鏈接：
 * [AutoGPT-FR](https://github.com/mikiane/autogpt-fr) - Auto GPT 的法語版本
 * [DeepSpeedExamples](https://github.com/microsoft/deepspeedexamples) - 使用 DeepSpeed 的範例模型
 * [Caption-Anything](https://github.com/ttengwang/caption-anything) - 標題-Anything是一個多功能工具，結合圖像分割、視覺標題和ChatGPT，生成定制的標題，並提供多樣化的控制，以滿足用戶的偏好。
 * [AudioGPT](https://github.com/aigc-audio/audiogpt) - AudioGPT：理解和生成語音、音樂、聲音和說話人頭像
 * [Machine-Learning-Goodness](https://github.com/aurimas13/machine-learning-goodness) - 機器學習項目包括ML / DL項目，筆記本，ML / DL的作弊代碼，有關AI / AGI的有用信息以及帶有提示的代碼或片段/腳本/任務。
 * [data-winners](https://github.com/frontanalyticsinc/data-winners) - 一系列免費的Python和R腳本，用於網站開發、分析和優化。包括用於主題權威和語義內容優化的高級資源。
 * [critique-apps](https://github.com/inspired-cognition/critique-apps) - 使用Inspired Cognition的Critique建立的應用程式。
 * [deep-rl-class](https://github.com/huggingface/deep-rl-class) - 這個存儲庫包含了 Hugging Face 深度強化學習課程的課程大綱。
 * [deep-RL-elements](https://github.com/amazingang/deep-rl-elements) - 使用PyTorch的深度強化學習演算法
 * [viper](https://github.com/cvlab-columbia/viper) - 「ViperGPT：通過Python執行進行推理的視覺推論」論文代碼
 * [ChatCaptioner](https://github.com/vision-cair/chatcaptioner) - ChatCaptioner 官方儲存庫
 * [galai](https://github.com/paperswithcode/galai) - GALACTICA 模型 API
 * [gost-install.ipynb](https://github.com/lewangdev/gost-install.ipynb) - 通過 Jupyter Notebook 安裝 GOST
 * [chatgpt-desktop](https://github.com/sonnylazuardi/chatgpt-desktop) - 在Flappy Bird遊戲中與你的Facebook朋友對決
 * [yobulkdev](https://github.com/yobulkdev/yobulkdev) - 🔥 🔥 🔥開源和AI驅動的數據上傳平台：免費的flatfile.com替代方案
 * [WTF-JavaScript](https://github.com/wtfacademy/wtf-javascript) - 我最近在重新學 JavaScript，鞏固一下細節，也寫一個「WTF JavaScript極簡入門」，供新人學習。
 * [gpt3-email](https://github.com/danimelchor/gpt3-email) - 使用 GPT-3 幫助您撰寫電子郵件。
 * [chatgpt-action](https://github.com/kxxt/chatgpt-action) - 讓ChatGPT為您審查公關稿件。
 * [scalene](https://github.com/plasma-umass/scalene) - Scalene：一款高性能、高精度的Python CPU、GPU和內存分析器，具有AI驅動的優化建議。
 * [BingGPT](https://github.com/dice2o/binggpt) - 新的Bing AI聊天桌面應用程式（Windows、macOS和Linux）
 * [ChatGPT-Feishu](https://github.com/bestony/chatgpt-feishu) - 為飛書準備的 ChatGPT 機器人
 * [ARC](https://github.com/fchollet/arc) - 抽象和推理語料庫
 * [pdf.js](https://github.com/mozilla/pdf.js) - JavaScript PDF閱讀器
 * [adrenaline](https://github.com/shobrook/adrenaline) - 與你的程式碼庫對話
 * [lorem-chatum-for-indesign](https://github.com/twardoch/lorem-chatum-for-indesign) - 使用ChatGPT的Lorem Chatum腳本，以產生更好的Lorem ipsum的Adobe InDesign。
 * [monocle-rizz](https://github.com/acui51/monocle-rizz) - rizzGPT
 * [gptrpg](https://github.com/dzoba/gptrpg) - 一個基於GPT的代理人在類似RPG環境中的演示
 * [ChattyCaty](https://github.com/cyberark/chattycaty) - chattycaty - 使用gpt模型創建多態程序的oss工具。
 * [appwrite](https://github.com/appwrite/appwrite) - 安全的後端伺服器，適用於網頁、行動裝置和Flutter開發人員🚀，也就是100％開源的Firebase替代方案。
 * [wechat-chatgpt](https://github.com/fuergaosi233/wechat-chatgpt) - 透過 wechaty 在微信上使用 ChatGPT
 * [roomGPT](https://github.com/nutlope/roomgpt) - 上傳你房間的照片，使用人工智慧生成你的夢想房間。
 * [noobnooc](https://github.com/noobnooc/noobnooc) - 我的個人資料、部落格和主頁（https://www.nooc.ink）的內容。
 * [code-gpt](https://github.com/vaibhavacharya/code-gpt) - 隨時理解任何程式碼。🚀
 * [Portal](https://github.com/lxfater/portal) - protal 發布：系統托盤模式支持 API 聊天模式歷史可選聊天 GPT 網絡斷開問題的解決方案自動遠程更新。
 * [commitgpt](https://github.com/romanhotsiy/commitgpt) - 使用ChatGPT自動生成提交訊息
 * [chatgpt-md](https://github.com/bramses/chatgpt-md) - 將ChatGPT幾乎無縫地整合到Obsidian中。
 * [paul-graham-gpt](https://github.com/mckaywrigley/paul-graham-gpt) - AI 搜尋和聊天，搜尋所有 Paul Graham 的文章。
 * [colorGPT](https://github.com/sonnylazuardi/colorgpt) - 利用人工智慧從現實世界中捕捉顏色名稱的生成
 * [novu](https://github.com/novuhq/novu) - 具有完全功能的嵌入式通知中心的開源通知基礎設施
 * [chatapi-single](https://github.com/bytemate/chatapi-single) - 簡單而強大的ChatGPT-API-伺服器
 * [kindle-gpt](https://github.com/mckaywrigley/kindle-gpt) - 在您的Kindle亮點上進行AI搜索和聊天。
 * [gpt-4-for-code](https://github.com/anysphere/gpt-4-for-code) - GPT-4 的一些代碼示例！
 * [M5Core2ImageAvatarLiteChatGPT](https://github.com/robo8080/m5core2imageavatarlitechatgpt) - M5Stack Core2 的 ImageAvatarLiteChatGPT
 * [gpt4all-chat](https://github.com/nomic-ai/gpt4all-chat) - gpt4all-j 聊天
 * [ggml](https://github.com/ggerganov/ggml) - 機器學習的張量庫
 * [blindvisaidgpt](https://github.com/justanotherlad/blindvisaidgpt) - 一個使用Microsoft/Visual-ChatGPT的互動輔助工具，專為視障人士設計。
 * [cformers](https://github.com/nolanoorg/cformers) - 使用C後端的SoTA Transformers，可在您的CPU上進行快速推論。
 * [Pake](https://github.com/tw93/pake) - 🤱🏻 使用 Rust 將任何網頁轉換為桌面應用程式非常簡單。 🤱🏻
 * [run-wild](https://github.com/refcell/run-wild) - 增強GPT-4環境訪問能力
 * [gpt-macro](https://github.com/retrage/gpt-macro) - ChatGPT 是由 Rust proc 宏驅動的，可以在編譯時生成代碼的工具。
 * [nofwl](https://github.com/lencx/nofwl) - NoFWL 桌面應用程式
 * [gwipt](https://github.com/benwr/gwipt) - 使用GPT-3提交訊息自動將所有編輯提交到wip分支。
 * [whatsapp-gpt](https://github.com/danielgross/whatsapp-gpt) - 請將以下內容翻譯成繁體中文。#8 chatgpt for whatsapp and telegramadd chatgpt to your groupchats:• whatsappgpt: • telegramgpt: 將chatgpt添加到您的群聊中：• whatsappgpt：• telegramgpt：
 * [chatgpt-web](https://github.com/869413421/chatgpt-web) - 基於ChatGPT3.5 API實現的私有化web程式
 * [legitify](https://github.com/legit-labs/legitify) - 檢測並修復您所有 GitHub 和 GitLab 資產中的配置錯誤和安全風險。
 * [wechatgpt](https://github.com/houko/wechatgpt) - wechatgpt golang版 chatgpt機器人(可docker部署)，目前支持wechat，telegram
 * [xiaogpt.git](https://github.com/yihong0618/xiaogpt.git) - bilibili後台源碼
 * [wechat-chatGPT](https://github.com/gtoxlili/wechat-chatgpt) - 實現微信公眾號被動返回接口的ChatGPT
 * [dnscrypt-proxy](https://github.com/dnscrypt/dnscrypt-proxy) - dnscrypt-proxy 2 - 一個靈活的 DNS 代理，支援加密 DNS 協議。
 * [review-gpt](https://github.com/vibovenkat123/review-gpt) - 一個使用gpt-3、gpt-3.5和gpt-4的自動代碼審查工具。
 * [kube-ovn](https://github.com/kubeovn/kube-ovn) - SDN和Cloud Native之間的橋樑（CNCF項目）
 * [gpt-takes-the-bar-exam](https://github.com/mjbommar/gpt-takes-the-bar-exam) - GPT 參加律師考試
 * [offensive-chatgpt](https://github.com/payloadartist/offensive-chatgpt) - ChatGPT 的攻擊性安全使用案例
 * [ChatGPT-Saver](https://github.com/billionshields/chatgpt-saver) - 聊天GPT聊天GPT儲存器
 * [ChatGPT-Simple](https://github.com/logankilpatrick/chatgpt-simple) - 以不到100行的程式碼建立一個簡單的本地主機版ChatGPT。
 * [LongReadBenchmark](https://github.com/xueyidong/longreadbenchmark) - 基準測試長讀取RNA-seq分析工具
 * [GptMedCode](https://github.com/rohit43/gptmedcode) - 從 #ehr 分析的角度來看，我想知道是否可以使用 #chatgpt 後端自動獲取代碼。但是返回的代碼質量並不可靠。質量 ~ icd > loinc > snomed @zakkohane @arjunmanrai
 * [AISisterAIChan](https://github.com/manju-summoner/aisisteraichan) - 這是搭載了ChatGPT3.5的伺か鬼「AI妹妹愛醬」。使用需要另外準備ChatGPT的API金鑰。
 * [Entrepreneur-GPT](https://github.com/torantulino/entrepreneur-gpt) - 2017年GUJAM
 * [ChatGPTforRhino](https://github.com/4kk11/chatgptforrhino) - 將chatgptforrhino加入GUI並進行了相應的設置！還將其放在了GitHub上！
 * [OutlineStormingGPT](https://github.com/mayaenomoto/outlinestorminggpt) - 只是一個與GPT輕聲交談的工具。
 * [Auto-GPT.git](https://github.com/torantulino/auto-gpt.git) - 高級遊戲工程項目 - 立方體像素遊戲製作器
 * [ChatGPT-Bypass](https://github.com/grimoutlaw/chatgpt-bypass) - 簡單的腳本，可通過API繞過ChatGPT中的內容過濾。
 * [robustlearn](https://github.com/microsoft/robustlearn) - MDATP PowerBI模板儲存庫
 * [check](https://github.com/yeahwu/check) - 串流媒體解鎖測試
 * [haoel.github.io](https://github.com/haoel/haoel.github.io) - 前兩天看到耗子哥更新了上網的文檔，也來說一下我是怎麼解決 chatgpt 和 new bing 就算掛了梯子還是無法登錄或者使用問題的：gost + cloudflare warp，配置起來也比較簡單。 (1/n)
 * [FlexGen](https://github.com/ying1123/flexgen) - 一款景觀規劃遊戲
 * [chatgpt-web](https://github.com/chanzhaoyu/chatgpt-web) - 使用 Express 和 Vue3 搭建的 ChatGPT 演示網頁
 * [SPTH](https://github.com/spthvx/spth) - 地獄藝術的第二部分：人工（生命/進化/智能）
 * [whatsapp-chatgpt](https://github.com/navopw/whatsapp-chatgpt) - 程序性噪音地圖生成器 :霧:
 * [MathGPT](https://github.com/meiyulee/mathgpt) - 免費數字驅動的數學模型人工智能 | 為您的數字建立數學模型 |
 * [ChatGPT.el](https://github.com/joshcho/chatgpt.el) - 在Emacs中使用ChatGPT
 * [flutter_chatgpt_api](https://github.com/coskuncay/flutter_chatgpt_api) - 使用Flutter / Dart中的ChatGPT
 * [chatchan-dist](https://github.com/easychen/chatchan-dist) - Chat醬獨立部署版，docker方案自帶代理
 * [MaterialGPT](https://github.com/dylanakp/materialgpt) - MaterialGPT是使用API的ChatGPT的克隆版本。
 * [chatwire](https://github.com/theokafadaris/chatwire) - 使用Laravel自行託管的ChatGPT克隆版
 * [ChatGPTForTelegram](https://github.com/kylelin1998/chatgptfortelegram) - 目前機器人基於ChatGPT進行開發。使用機器人可以讓你輕鬆進行對話，後續機器人的更新升級一個命令即可搞定，無需再上伺服器進行升級機器人。
 * [GPTstudio](https://github.com/michelnivard/gptstudio) - 一個基於R和FORTRAN的優化器，專門用於估計遺傳變異成分模型，其中允許固定效應和調節效應。
 * [binary-dist](https://github.com/poslogithub/binary-dist) - 可執行二進制發布用
 * [GPTeacher](https://github.com/teknium1/gpteacher) - 由GPT-4生成的模塊化數據集合，包括通用指令、角色扮演指令、代碼指令和工具形式。
 * [AI-Toolbox](https://github.com/enbifa/ai-toolbox) - 建立一個全面的資源庫，為人工智慧愛好者和專業人士服務。
 * [following-instructions-human-feedback](https://github.com/openai/following-instructions-human-feedback) - @rachel_l_woods 這是我用來指導 GPT 不要幻覺的慣用紙張。
 * [Audits-Smart-Contracts](https://github.com/audit-ace/audits-smart-contracts) - 🚀宣布審計報告恭喜聊天GPT🎉審計DM-
 * [Malware](https://github.com/objective-see/malware) - macOS 惡意軟件收集
 * [inPars](https://github.com/zetaalphavector/inpars) - VOSviewer Online是一個網絡可視化工具。它是VOSviewer的網絡版，VOSviewer是一個流行的構建和可視化文獻計量網絡的工具。
 * [ai-review.vim](https://github.com/yuki-yano/ai-review.vim) - 快速計算你的程式碼。
 * [gayolGate](https://github.com/gayolgate/gayolgate) - 關於我的 GitHub 個人資料的資訊
 * [minlora](https://github.com/cccntu/minlora) - 🚀 令人興奮的消息！我剛剛發布了我的新庫，minlora 🎉 這個強大的庫讓你可以在幾行代碼中將lora應用到*任何*pytorch模型中。從@huggingface的transformers、diffusers到@karpathy的nanogpt。現在就去看看吧：
 * [EOSIO-Vulnerability-Scanner](https://github.com/sentnl/eosio-vulnerability-scanner) - 在第一層區塊鏈協議上發現P0網絡安全問題的漏洞賞金
 * [paytm-movies](https://github.com/hedcet/paytm-movies) - #比姆比薩拉 #1月9日星期一收藏 1,852₹，佔座率77％（1,852/2,400），5場演出，#testcinemaocl #waterland。
 * [chatgpt-vscode](https://github.com/ai-genie/chatgpt-vscode) - 您在 VS Code 中最好的 AI 配對程式設計師
 * [PolyglotSiri-Apple-Shortcut](https://github.com/munntein/polyglotsiri-apple-shortcut) - PolyglotSiri基於[ChatGPT-Siri](https://github.com/Yue-Yang/ChatGPT-Siri)，並增強了其多語言和語音功能。
 * [M5Burner_M5Unified_StackChan_ChatGPT_README](https://github.com/robo8080/m5burner_m5unified_stackchan_chatgpt_readme) - 這是M5Burner版M5Unified_StackChan_ChatGPT的README。
 * [stableLM](https://github.com/stability-ai/stablelm) - 與stability.ai API（例如穩定擴散推理）互動的SDK
 * [AI-Twitter-History](https://github.com/jtmuller5/ai-twitter-history) - ChatGPT很好，但你不知道如何使用它。
 * [gpt-legion](https://github.com/eumemic/gpt-legion) - Radiant Blockchain Node（RXD）- SHA512/256 工作量证明
 * [JinJinLeDao_QA_Dataset](https://github.com/tech-podcasts/jinjinledao_qa_dataset) - 該數據集包含從281集中提取的超過18,000個中文問答對，這些集來自中文播客“金金樂道”。
 * [AlitaAI](https://github.com/alita-ai/alitaai) - #notion #chatgpt #AlitaAI 肝了一個月終於出來了，和 ChatGPT 一起產品/設計/前後端，新人求關注Alita AI（save to notion）是一款基於 Notion、ChatGPT 的人工智能助手，能幫你漸進式學習、自動化高效錄入知識片段抢先版：
 * [2048](https://github.com/inishchith/2048) - 又一個2048，但這次由GPT控制
 * [VardaGPT](https://github.com/ixaxaar/vardagpt) - 關聯記憶增強的GPT-2模型
 * [gpt-json](https://github.com/piercefreeman/gpt-json) - 在Python中結構化和類型提示的GPT回應
 * [gptneox](https://github.com/dfalbel/gptneox) - 套件功能（一行，標題大小寫）
 * [babyagi4all](https://github.com/kroll-software/babyagi4all) - BabyAGI 與 GPT4All 一起運行
 * [open-chat-video-editor](https://github.com/scutlihaoyu/open-chat-video-editor) - 開源短視頻自動生成工具
 * [AIXP](https://github.com/davila7/aixp) - AI-Exchange Protocol（AIXP）：人工智慧代理人的通訊標準
 * [chat-ui](https://github.com/huggingface/chat-ui) - 開源代碼庫驅動HuggingChat應用程式
 * [pandora](https://github.com/pengzhile/pandora) - 潘朵拉，一個讓你呼吸順暢的ChatGPT。
 * [ChatWaifu_Mobile](https://github.com/voine/chatwaifu_mobile) - 移動版二次元 AI 老婆聊天器
 * [ChatALL](https://github.com/sunner/chatall) - 同時與ChatGPT、Bing Chat、bard、Alpaca、Vincuna、Claude、ChatGLM、MOSS、iFlytek Spark、ERNIE等人聊天，發現最佳答案。
 * [fastGPT](https://github.com/certik/fastgpt) - 使用Fortran編寫的快速GPT-2推論
 * [menubar](https://github.com/smol-ai/menubar) - 一個帶有零延遲訪問ChatGPT/Bard/Claude的菜單！進行A/B測試，或在背景中使用它們。我每天使用這個20次。
 * [quivr](https://github.com/stangirard/quivr) - 將所有的檔案和想法傾倒到你的生成AI第二大腦中，並與它聊天。
 * [GPTeam](https://github.com/101dotxyz/gpteam) - GPTeam：一個開源的多智能體模擬系統
 * [learnGPT](https://github.com/dadukhankevin/learngpt) - 一個免費、開源、由人工智慧驅動的Quizlet替代方案。
 * [GirlfriendGPT](https://github.com/eniascailliau/girlfriendgpt) - 女友GPT是一個Python項目，使用ChatGPT4.0建立自己的人工智能女友。
 * [Mr.trans](https://github.com/illumine-labs/mr.trans) - 啟迪心靈，超越學習
 * [chat_gpt_error_handler](https://github.com/schwad/chat_gpt_error_handler) - 今天試試我的新寶石「chat_gpt_error_handler」吧！它會在你的錯誤堆疊之前彈出（希望有用的）ChatGPT片段。
 * [PandaGPT](https://github.com/yxuansu/pandagpt) - PandaGPT：一個模型，指令跟隨無所不包
 * [rinna_gpt-neox_ggml-lora](https://github.com/yukaryavka/rinna_gpt-neox_ggml-lora) - 該存儲庫包含已修改的腳本和合併腳本，以適應Alpaca-Lora適配器進行LoRA調試，假定使用轉換為ggml的“rinna / japanese-gpt-neox…” [gpt-neox]模型。
 * [gptlink](https://github.com/gptlink/gptlink) - 10分鐘搭建自己可免費商用的ChatGPT環境，搭建簡單，包含用戶，訂單，任務，付費等功能。
 * [tell-me-a-story-ai](https://github.com/kiki-le-singe/tell-me-a-story-ai) - 「講個故事」是一個小應用程式，可以使用ChatGPT和React Native來撰寫故事。
 * [chatgpt-yaml-generator](https://github.com/robusta-dev/chatgpt-yaml-generator) - 讓 ChatGPT 具備 Kubernetes 模式和驗證能力的完整知識
 * [ComposeAI](https://github.com/ebfvince/composeai) - 一個使用Compose Multiplatform製作的Android和iOS應用程式ChatGPT。
 * [GreatMaster](https://github.com/illumine-labs/greatmaster) - 大師，請幫助我們覺醒和開悟。
 * [SAIL](https://github.com/luohongyin/sail) - SAIL：搜尋增強式指令學習
 * [PodcastCopilot](https://github.com/microsoft/podcastcopilot) - 可擴展、快速、輕量級的大規模主題建模系統
 * [gpt-aggregated-edition](https://github.com/1595901624/gpt-aggregated-edition) - 聚合ChatGPT官方版、ChatGPT免費版、文心一言、Poe、chatchat等多平台，支援自訂導入平台。
 * [larc_gpt4](https://github.com/evanthebouncy/larc_gpt4) - 使用GPT-4進行LARC求解
 * [go-proxy-bingai](https://github.com/adams549659584/go-proxy-bingai) - 使用 Vue3 和 Go 構建的微軟 New Bing 示範站點，擁有一致的 UI 體驗，支援 ChatGPT 提示詞，國內可用。
 * [slack-knowledgebase-chatgpt-responder](https://github.com/nearform/slack-knowledgebase-chatgpt-responder) - ChatGPT 驅動的 Slack 回覆器，用於回答關於 NearForm 知識庫的問題。
 * [simpleaichat](https://github.com/minimaxir/simpleaichat) - Python套件，可輕鬆與聊天應用程式進行接口，具有強大的功能和最小的代碼複雜性。
 * [instruction-tuned-sd](https://github.com/huggingface/instruction-tuned-sd) - 指令調整穩定擴散的程式碼。
 * [gpt-engineer](https://github.com/antonosika/gpt-engineer) - 指定您想要建造的內容，人工智慧會詢問澄清問題，然後進行建造。
 * [FalconStreaming](https://github.com/andrewgcodes/falconstreaming) - Falcon40B和7B（指令）具有流式傳輸、前k個、和波束搜索功能。
 * [lightspeedGPT](https://github.com/andrewgcodes/lightspeedgpt) - 使用GPT4和GPT3.5處理無限大小的輸入。使用多線程並行處理多個塊，對於命名實體識別、大型書籍、數據集等信息提取任務非常有用。
 * [bloop](https://github.com/bloopai/bloop) - bloop 是一個用 Rust 編寫的快速代碼搜索引擎。
 * [obsidian-copilot](https://github.com/logancyang/obsidian-copilot) - 黑曜石中的ChatGPT副駕駛員
 * [thinkgpt](https://github.com/alaeddine-13/thinkgpt) - 突尼西亞航空公司應用程式 REST API
 * [babyagi-ui](https://github.com/miurla/babyagi-ui) - BabyAGI UI 的設計旨在使在 Web 應用程序中運行和開發 BabyAGI 變得更加容易，就像 ChatGPT 一樣。
 * [GPT4Company](https://github.com/easychen/gpt4company) - Gpt4Company 是一個用來避免三星式洩漏的請求轉發器。
 * [chatgpt-spring-boot-starter](https://github.com/linux-china/chatgpt-spring-boot-starter) - Spring Boot ChatGPT 開始者
 * [nuclei_gpt](https://github.com/sf197/nuclei_gpt) - 聊天自動化核心模板生成
 * [sample-app-aoai-chatGPT](https://github.com/microsoft/sample-app-aoai-chatgpt) - [預覽] 透過AOAI針對chatGPT的簡單網路聊天體驗的範例程式碼。
 * [GENIUS](https://github.com/mingkai-zheng/genius) - GPT-4能夠進行神經架構搜索嗎？
 * [chatgpt-source-watch](https://github.com/0xdevalias/chatgpt-source-watch) - 通過精選的檔案和腳本分析ChatGPT代碼庫的演變。
 * [PROFILEGPT](https://github.com/odiks/profilegpt) - PROFILEGPT 是一個用於分析 Twitter 上的個人資料和標籤的工具。該應用程式利用各種技術和 API 收集數據，為用戶生成信息。
 * [chatgpt-auto-continue](https://github.com/adamlui/chatgpt-auto-continue) - ⏩ 自動繼續生成多個ChatGPT回應
 * [a1gpt](https://github.com/a1k0n/a1gpt) - 一次性使用的GPT推理
 * [freegpt-webui](https://github.com/ramonvc/freegpt-webui) - 具有聊天網頁界面的GPT 3.5/4。無需API密鑰。
 * [commavq](https://github.com/commaai/commavq) - commaVQ 是一個壓縮的駕駛視頻數據集。
 * [chatgpt-localfiles](https://github.com/samrawal/chatgpt-localfiles) - 將本地文件設置為ChatGPT可訪問的。
 * [SlashGPT](https://github.com/snakajima/slashgpt) - 在 @snakajima さん解說完SlashGPT之後，請確認程式碼。
 * [nba-cba-ai-chat](https://github.com/mckaywrigley/nba-cba-ai-chat) - 使用人工智慧來詢問有關新的676頁NBA CBA的問題。
 * [Taqyim](https://github.com/arbml/taqyim) - 用於評估ChatGPT模型的Python介面
 * [gpt-code-search](https://github.com/wolfia-app/gpt-code-search) - GitHub Action 可以自動上傳您的應用程式，以自動化應用程式的分發。GitHub Action 可以自動上傳您的應用程式，以自動化應用程式的分發。
 * [Callisto](https://github.com/jetp1ane/callisto) - Callisto - 一個智能的二進制漏洞分析工具
 * [OpenELM](https://github.com/carperai/openelm) - 透過大型模型的演化
 * [chatgpt-to-api](https://github.com/acheong08/chatgpt-to-api) - 高級HTTP庫
 * [chatgpt-web-share](https://github.com/moeakwak/chatgpt-web-share) - 一個功能齊全的多用戶ChatGPT網絡系統，提供Plus帳戶或API作為服務提供者。
 * [poe-api](https://github.com/ading2210/poe-api) - 一個逆向工程的Python API封裝器，用於Quora的Poe，提供免費訪問ChatGPT、GPT-4和Claude。
 * [leetcode](https://github.com/azl397985856/leetcode) - 推薦免費ChatGPT網站：www.lintcode.com/chat-gpt?utm_source=tf-github-lucifer  LeetCode解題方案：一個我解題之旅的記錄。
 * [chatgpt-business](https://github.com/garyvalue/chatgpt-business) - 已匯總41個Chatgpt商業版及提供更多的變現方式，商業源碼程序，帳號API渠道，支付收款渠道，伺服器渠道，課程配套服務，CHATGPT知識星球，開發定制外包
 * [chapyter](https://github.com/chapyter/chapyter) - Chapyter：在Jupyter筆記本中的ChatGPT代碼解釋器
 * [ChatGPT-Midjourney-Pro](https://github.com/licoy/chatgpt-midjourney-pro) - 🤖️ 基於 Golang + Vue3 + NaiveUI 的全新 ChatGPT-Midjourney 的 AIGC 應用
 * [timetask](https://github.com/haikerapples/timetask) - 一款支持自定義定時任務的chatgpt-on-wechat插件
 * [chatgpt-mirror-server-deploy](https://github.com/xyhelper/chatgpt-mirror-server-deploy) - chatgpt-mirror-server快速部署庫文件
 * [gpt-react-designer](https://github.com/xd2sketch/gpt-react-designer) - ⚡️ 使用🤖 ChatGPT 生成並預覽 ⚛️ React 元件
 * [personoids-lite](https://github.com/personoids/personoids-lite) - 「每個對話中的自主權力」- 將ChatGPT轉變為一個強大的自主代理，能夠獨立完成複雜任務。
 * [AIChatWeb](https://github.com/nanjiren01/aichatweb) - 在ChatGPT-Next-Web的基礎上，增加註冊登錄，額度限制，邀請，敏感詞，支付，基於docker一鍵部署。提供後台管理系統，可配置標題、歡迎詞、額度不足提醒、公告。
 * [gptAssist](https://github.com/woheller69/gptassist) - gptAssist 是 ChatGPT 的簡單 WebView 封裝程式。
 * [personal_chatgpt](https://github.com/chunhuizhang/personal_chatgpt) - 個人聊天GPT
 * [explain-source-code-by-chatgpt](https://github.com/cuishuang/explain-source-code-by-chatgpt) - 👂🏻 chatgpt講解Go知名項目的源碼
 * [ChatGPT_principle_fine-tuning_code_paper](https://github.com/julycoding/chatgpt_principle_fine-tuning_code_paper) - 本『ChatGPT資源庫(原理/微調/代碼/論文)』的初始版本來自July CSDN博客上閱讀量高達50萬的ChatGPT系列，聯合發起人：七月ChatGPT原理課學員，6月初正式對外發布
 * [spring-chatgpt-sample](https://github.com/azure-samples/spring-chatgpt-sample) - 使用Spring / Java堆棧的ChatGPT樣本
 * [azurechatgpt](https://github.com/microsoft/azurechatgpt) - 🤖 Azure ChatGPT：私密且安全的內部企業使用聊天GPT 💼
 * [ChatGPT-Nine-Ai](https://github.com/dreamergrow/chatgpt-nine-ai) - 使用 Nestjs 和 Vue3 搭建的 商業化ChatGPT網站
 * [gptlink-web](https://github.com/gptlink/gptlink-web) - 一個使用React和Tailwind CSS開發的ChatGPT網絡應用程序，API由gptlink提供。
 * [ChatGPT-Virtual-Live](https://github.com/smallnew666/chatgpt-virtual-live) - ChatGPT虛擬主播、支持B站、抖音、視頻號
 * [chatgpt-web-plus](https://github.com/chanzhaoyu/chatgpt-web-plus) - chatgpt-web-plus
 * [MindGeniusAI](https://github.com/xianjianlf2/mindgeniusai) - 使用ChatGPT自動生成思維導圖
 * [ExcelGPT](https://github.com/asterecho/excelgpt) - chatgpt for Excel ，基於ExcelDNA開發
 * [OpenCopilot](https://github.com/newfyu/opencopilot) - ChatGPT的跨平台桌面客戶端，簡潔的使用者介面和隨時喚起的體驗。具備建立本地知識庫、網路檢索、長文本閱讀、執行本地程式碼等功能。
 * [drugchat](https://github.com/ucsd-ai4h/drugchat) - DrugChat：實現在藥物分子圖上啟用ChatGPT類似的功能
 * [ChatGPT-SDImg-Web](https://github.com/chengxs1994/chatgpt-sdimg-web) - 基於ChatGPT-Next-Web，整合SD webui AI繪圖，實現註冊登錄，次數限制，充值，分享等功能。
 * [ESP32-ChatGPT](https://github.com/techiesms/esp32-chatgpt) - 這個存儲庫包含在ESP32開發板上使用ChatGPT的代碼，並使用i2s放大模組進行音頻回應。
 * [gihyo-ChatGPT](https://github.com/gamasenninn/gihyo-chatgpt) - Gihyo ChatGPT 書籍
 * [azurechatgpt](https://github.com/dandinu/azurechatgpt) - 🤖 Azure ChatGPT：私密且安全的企業內部使用聊天機器人 💼
 * [OpenGPT-Business](https://github.com/black-fruit/opengpt-business) - chatgpt商業應用！79E/ChatGpt-Web 的1.3.9最新！本人破解，無需授權！
 * [ChatGPT-fine-tuning](https://github.com/iongpt/chatgpt-fine-tuning) - 用於訓練微調ChatGPT的實用程式類別
 * [ChatGPT-Next-Web-Pro](https://github.com/vual/chatgpt-next-web-pro) - 基於chatgpt-next-web，增加了midjourney繪畫功能。後續會接入stable-diffusion，註冊登錄，後台管理，接入知識庫等。
 * [chirp](https://github.com/rogueocelot/chirp) - 從Discord中的Relay ChatGPT問題和答案
 * [SQL-GPT](https://github.com/cl-lau/sql-gpt) - 使用ChatGPT生成SQL並執行。還可以進行SQL的優化和錯誤修正。
 * [ChatPaper2Xmind](https://github.com/masteryip/chatpaper2xmind) - 論文XMind筆記生成工具，將論文pdf通過ChatGPT轉換為帶有圖片和公式的簡要XMind筆記，提高論文閱讀效率。
 * [TIME-SEA-chatgpt](https://github.com/dulaiduwang003/time-sea-chatgpt) - 基於SpringBoot3開發的Ai平台 含雙端 網頁以及小程序 包含chatgpt newbing claude , 雙端數據同步 支持自定義預設詞,功能板塊定義,各類繪圖  web兼容手機展示
 * [Chat-CodeReview](https://github.com/nangongchengfeng/chat-codereview) - ChatGPT整合了Gitlab，可以自动审计代码并进行评论。
 * [NeuroGPT](https://github.com/em1tsan/neurogpt) - 免費的ChatGPT 3.5 / ChatGPT 4
 * [chatreview](https://github.com/specful-ai/chatreview) - ChatGPT 的程式碼審查模式
 * [pandora](https://github.com/dave1010/pandora) - ChatGPT編碼解鎖！Pandora讓ChatGPT能夠讀寫文件並在您的機器上運行命令。
 * [feishu-chatgpt](https://github.com/1130600015/feishu-chatgpt) - 一個集成ChatGPT的飛書應用
 * [midjourney_turbo](https://github.com/chazzjimel/midjourney_turbo) - chatgpt-on-wechat的mj畫圖插件，支持次數限制，GPT關鍵詞潤色，圖片合成，以圖生圖
 * [humanify](https://github.com/jehna/humanify) - 使用ChatGPT解碼未壓縮的Javascript代碼
 * [careerboost](https://github.com/dmswl98/careerboost) - 📝 chatGPT 履歷校對服務
 * [livecodingthefuture-docker-terraform](https://github.com/digitalinnovationone/livecodingthefuture-docker-terraform) - 項目創建用於保存Live Conding The Future的示例。使用Docker、Terraform、Bard和ChatGPT在雲端部署Web應用程式。
 * [chatgpt-jiezi](https://github.com/hncboy/chatgpt-jiezi) - ChatGPT 管理端-解字
 * [GPT-WEB-JAVA](https://github.com/a616567126/gpt-web-java) - 基於JDK8 AI 聊天機器人！微信公眾號 Midjourney畫圖、卡密兌換、web 支持ChatGPT、Midjourney畫圖、sd畫圖，卡密兌換，易支付，公眾號引流，郵件註冊🔥
 * [ChatGPT-Python-Applications](https://github.com/xiaowuc2/chatgpt-python-applications) - ChatGPT Python應用程式與第三方庫和模組整合
 * [ChatLog](https://github.com/thu-keg/chatlog) - ⏳ 聊天記錄：記錄和分析ChatGPT隨時間變化的對話
 * [claude-in-slack-server](https://github.com/llmkira/claude-in-slack-server) - 幫助您在slack中與Claude互動的HTTP伺服器，與ChatGPT Web API相容。
 * [chat-review](https://github.com/ikoofe/chat-review) - ChatGPT Gitlab 代碼審查
 * [ChatGPTBook](https://github.com/liucongg/chatgptbook) - 《ChatGPT原理與實戰：大型語言模型的算法、技術和私有化》
 * [nvim-gpt](https://github.com/archibate/nvim-gpt) - 整合ChatGPT + Bing AI於NeoVim，專為像您這樣的新先鋒而設 :)
 * [ChatReviewer](https://github.com/nishiwen1214/chatreviewer) - ChatReviewer: 使用ChatGPT分析論文優缺點，提出改進建議
 * [ChatGLM-Tuning](https://github.com/mymusise/chatglm-tuning) - 一種平價的chatgpt實現方案，基於ChatGLM-6B + LoRA
 * [chatgpt](https://github.com/emacs-openai/chatgpt) - 使用ChatGPT在Emacs中
 * [Using-ChatGPT-to-Learn-Programming](https://github.com/blackstar1453/using-chatgpt-to-learn-programming) - 學習如何使用ChatGPT來增強你的編程學習
 * [Apilot](https://github.com/6vision/apilot) - 基於chatgpt_on_wechat項目的一個API調用插件
 * [ChatGPT_Custom_Instructions](https://github.com/daveshap/chatgpt_custom_instructions) - 您可以在ChatGPT中使用的自定義指令存儲庫
 * [chatnio](https://github.com/deeptrain-community/chatnio) - 👋 輕量級 ChatGPT 聊天平台，實現 ChatGPT 聯網功能，多帳戶均衡負載，緩存，鑒權系統，支持 Stream 實時響應，圖像生成，對話記憶功能 👋
 * [talk](https://github.com/proxoar/talk) - 與ChatGPT對話輕而易舉
 * [brain-reply](https://github.com/caidukai/brain-reply) - 更優雅的ChatGPT客戶端
 * [wechat_gpt_laf](https://github.com/husanr/wechat_gpt_laf) - 使用Laf雲平台，兩步將ChatGPT接入微信公眾號
 * [bionicgpt](https://github.com/purton-tech/bionicgpt) - BionicGPT 是 ChatGPT 的本地替代方案，提供了生成式人工智能的优势，同时保持严格的数据保密性。
 * [ChatGPT-Next-Web-PRO](https://github.com/llboo/chatgpt-next-web-pro) - ChatGPT-Next-Web 接入管理後台，包括：key管理、使用者驗證、公眾號註冊/掃碼登錄、支付管理、卡密管理等
 * [ChatGPT-AutoExpert](https://github.com/spdustin/chatgpt-autoexpert) - 🚀🧠💬 ChatGPT（非編碼）和ChatGPT高級數據分析（編碼）的超強定制指令。
 * [muchat-aio](https://github.com/panyanyany/muchat-aio) - 團隊版 ChatGPT Web 應用，多使用者，免登錄。適合公司、組織或小團體內部使用。
 * [chatgpt-web-go](https://github.com/heimeropen/chatgpt-web-go) - 一個用於ChatGPT應用程序的Golang服務
 * [reddit-profile-analyzer](https://github.com/grays42/reddit-profile-analyzer) - ChatGPT基於Reddit個人資料分析器。請自備API金鑰。
 * [bionic-gpt](https://github.com/bionic-gpt/bionic-gpt) - BionicGPT 是 ChatGPT 的本地替代方案，提供了生成式人工智能的优势，同时保持严格的数据保密性。
 * [chatgpt-token](https://github.com/croissanteth/chatgpt-token) - 完全自動化的ETH代幣部署，使用ChatGPT和DALL-E。
 * [RickAndMortai](https://github.com/code-bullet/rickandmortai) - 一個有瑞克和莫蒂角色、傳送門和史瑞克的聊天GPT東西，我不知道。
 * [sd-webui-chatgpt](https://github.com/non906/sd-webui-chatgpt) - 這是在Stable Diffusion web UI中使用ChatGPT的儲存庫。
 * [pictureChange](https://github.com/yanyutin753/picturechange) - 適用於chatgpt-on-wechat專案插件
 * [ChatGPT_Agent](https://github.com/liyucheng09/chatgpt_agent) - 一個由ChatGPT代理驅動的遊戲演示
 * [gin-vue-admin](https://github.com/flipped-aurora/gin-vue-admin) - 基於vite+vue3+gin搭建的開發基礎平台（支持TS,JS混用），集成jwt鑒權，權限管理，動態路由，顯隱可控組件，分頁封裝，多點登錄攔截，資源權限，上傳下載，代碼生成器，表單生成器，chatGPT自動查表等開發必備功能。
 * [LMFlow](https://github.com/optimalscale/lmflow) - 一個可擴展的工具包，用於對大型基礎模型進行微調和推論。為所有人提供大型模型。
 * [reloadium](https://github.com/reloadware/reloadium) - 熱重新加載、性能分析和Python的AI調試
 * [chatgpt-java](https://github.com/plexpt/chatgpt-java) - ChatGPT Java SDK。支援 GPT3.5、 GPT4 API。開箱即用。
 * [alldata](https://github.com/alldatacenter/alldata) - 🔥🔥 AllData大數據產品是可定義數據中台，以數據平台為底座，以數據中台為橋樑，以機器學習平台，GPT平台為框架，提供全鏈路數字化解決方案。微信群：https://docs.qq.com/doc/DVHlkSEtvVXVCdEFo
 * [SuperCLUE](https://github.com/cluebenchmark/superclue) - SuperCLUE: 中文通用大模型综合性基准 | 一個針對中文基礎模型的基準測試
 * [worktool](https://github.com/gallonyin/worktool) - 【企業微信】企業微信機器人 聊天機器人、自動加好友、自動拉群、自動群發機器人 免Root零封號 集成ChatGPT
 * [next-enterprise](https://github.com/blazity/next-enterprise) - 💼 一個適用於高效能、易於維護的企業級 Next.js 樣板，內含豐富功能，如 Tailwind CSS、TypeScript、ESLint、Prettier、測試工具等，可加速您的開發流程。
 * [HydraLab](https://github.com/microsoft/hydralab) - 智能雲端測試變得輕鬆。
 * [vectordb](https://github.com/epsilla-cloud/vectordb) - Epsilla 是一個高效能的向量資料庫管理系統。請在 https://cloud.epsilla.com/ 嘗試使用托管的 Epsilla。
 * [WeChatMsg](https://github.com/lc044/wechatmsg) - 提取微信聊天記錄，將其導出成HTML、Word、CSV文件永久保存，對聊天記錄進行分析生成年度聊天報告
 * [gpts-works](https://github.com/all-in-aigc/gpts-works) - 第三方GPT存儲
 * [gpt-researcher](https://github.com/assafelovic/gpt-researcher) - 基於GPT的自主代理人，可以對任何給定的主題進行在線綜合研究。
 * [ChatGPT-Next-Web](https://github.com/chatgptnextwebteam/chatgpt-next-web) - 一個設計精良的跨平台 ChatGPT 用戶界面（Web / PWA / Linux / Win / MacOS）。
 * [ChatGLM-Finetuning](https://github.com/liucongg/chatglm-finetuning) - 基於ChatGLM-6B、ChatGLM2-6B、ChatGLM3-6B模型，進行下游具體任務微調，涉及Freeze、Lora、P-tuning、全參微調等。
 * [ChatGPT-Next-Web](https://github.com/chatgptnextweb/chatgpt-next-web) - 一個設計精良的跨平台 ChatGPT 用戶界面（Web / PWA / Linux / Win / MacOS）。
 * [gpt-crawler](https://github.com/builderio/gpt-crawler) - 爬取網站以生成知識文件，從URL創建自己的定制GPT
 * [vimGPT](https://github.com/ishan0102/vimgpt) - 使用GPT-4V和Vimium瀏覽網頁
 * [modelscope-agent](https://github.com/modelscope/modelscope-agent) - ModelScope-Agent（開源版GPTs）：一個連接ModelScope中的模型與世界的代理框架。
 * [chatgpt-wechat](https://github.com/whyiyhw/chatgpt-wechat) - 企業微信/微信 安全使用的 ChatGPT 個人助手應用
 * [jan](https://github.com/janhq/jan) - Jan是一個開源的替代方案，可以在您的電腦上完全離線運行，用於替代ChatGPT。
 * [gerev](https://github.com/gerevai/gerev) - 🧠 AI 強化的企業搜尋引擎 🔎
 * [Replit-Xray](https://github.com/yonggekkk/replit-xray) - Replit容器部署xray代理，支持自定義偽裝網頁，一鍵五協議共存，支持搭建vless、vmess、trojan、shadowsocks、socks，支持本地上傳與replit平台fork兩種模式部署
 * [GPTSecurity](https://github.com/mo-xiaoxi/gptsecurity) - 塑造未來的安全領域智能革命
 * [auto_job__find__chatgpt__rpa](https://github.com/frrrrrrrrank/auto_job__find__chatgpt__rpa) - 這是一個工具，使用 chatgpt 根據您的簡歷和職位描述自動生成求職信，並發送給中國的老闆。
 * [hamulete](https://github.com/hoochanlon/hamulete) - 🏔️國立臺灣大學、新加坡國立大學、早稻田大學、東京大學，中央研究院（臺灣）以及中國重點高校及科研機構，社科、經濟、數學、博弈論、哲學、系統工程類學術論文等知識庫。
 * [GPT-4V-Act](https://github.com/ddupont808/gpt-4v-act) - AI代理使用GPT-4V（視覺）能夠使用滑鼠/鍵盤與網頁使用者介面進行互動
 * [Generative_Deep_Learning_2nd_Edition](https://github.com/davidadsp/generative_deep_learning_2nd_edition) - 《O'Reilly書籍生成式深度學習第二版：教機器繪畫、寫作、作曲和遊戲的官方程式庫》。
 * [smart-ide](https://github.com/airuikun/smart-ide) - 在vscode插件中結合chatgpt能力，實現智能研發提效
 * [comfyui-mixlab-nodes](https://github.com/shadowcz007/comfyui-mixlab-nodes) - 工作流程至應用程式、螢幕分享和浮動視訊、GPT和3D、語音辨識和語音合成
 * [smart-excel-ai](https://github.com/weijunext/smart-excel-ai) - 使用ChatGPT，在幾秒內生成您所需的Excel公式。
 * [zotero-gpt](https://github.com/muisedestiny/zotero-gpt) - GPT 遇見 Zotero。
 * [gpt4v-browsing](https://github.com/unconv/gpt4v-browsing) - 使用GPT-4 Vision API和Puppeteer进行网络爬虫
 * [inke](https://github.com/yesmore/inke) - 📖 一個具有AI輔助寫作和即時協作功能的所見即所得筆記本。支援自主託管。一個所見即所得的Markdown筆記本，支援AI輔助寫作和多人協作，支援自部署，使用IndexedDB存儲筆記。
 * [twitterbio](https://github.com/nutlope/twitterbio) - 使用Mixtral和GPT-3.5生成您的Twitter簡介。
 * [SeeAct](https://github.com/osu-nlp-group/seeact) - SeeAct是一個針對一般網頁代理人的系統，能夠自主地在任何給定的網站上執行任務，尤其關注於大型多模態模型（LMMs），如GPT-4V(ision)。
 * [AI-Infinity](https://github.com/meetpateltech/ai-infinity) - 一套AI工具，將幫助您探索人工智慧的無限可能性。
 * [ChatGPT-Proxy](https://github.com/dqzboy/chatgpt-proxy) - ChatGPT 代理
 * [flutter_chat_box](https://github.com/bravekingzhang/flutter_chat_box) - Flutter開發的和ChatGPT聊天的App，全平台支援
 * [composum-AI](https://github.com/ist-dresden/composum-ai) - 為Composum Pages CMS和Adobe AEM提供的人工智能服務
 * [council](https://github.com/chain-ml/council) - Council是一個開源平台，用於快速開發和強大部署定制的生成式人工智能應用。
 * [ChatGemini](https://github.com/bclswl0827/chatgemini) - ✨ ChatGemini 是一個基於 Google Gemini 的網頁客戶端，對標 ChatGPT 3.5，操作邏輯同 ChatGPT 3.5 一致，同時支持在聊天中上傳圖片，應用會自動調用 Gemini-Pro-Vision 模型進行識圖。
 * [yakGPT](https://github.com/yakgpt/yakgpt) - 本地運行，無需手動操作的ChatGPT使用者界面
 * [GalTransl](https://github.com/cx2333-gt/galtransl) - 支持GPT-3.5/GPT-4/Newbing/Sakura等大型語言模型的Galgame自動化翻譯解決方案
 * [MoneyPrinter](https://github.com/fujiwarachoki/moneyprinter) - 使用MoviePy自動創建YouTube Shorts。
 * [ChatGPT-DeMod](https://github.com/4as/chatgpt-demod) - 請將以下內容翻譯成繁體中文：Tampermonkey/Greasemonkey腳本，用於在與ChatGPT通信時隱藏審核結果。
 * [gpt-newspaper](https://github.com/rotemweiss57/gpt-newspaper) - 基於GPT的自主代理設計，旨在創建根據用戶偏好定制的個性化報紙。
 * [CoGPT](https://github.com/geniucker/cogpt) - 嗯，Copilot還是GPT？誰知道呢。通過Copilot獲取對gpt-4的訪問。
 * [rome](https://github.com/kmeng01/rome) - 定位和編輯GPT（NeurIPS 2022）中的事實關聯
 * [chatgpt-next](https://github.com/xcatliu/chatgpt-next) - 微信風格的 ChatGPT，使用 Next.js 構建，私有化部署的最佳選擇！
 * [wechatSDK](https://github.com/kawika-git/wechatsdk) - 微信機器人是一個創新的基於Python 3.11開發的項目，通過結合ChatGPT模型和微信原生API，為用戶提供智能聊天、自動繪畫、自動發朋友圈、自動發視頻號等多樣的API集成服務，旨在提升日常溝通效率和趣味性。
 * [Bunny](https://github.com/baai-dcai/bunny) - 一個輕量級多模型家族。
 * [ChatGPT-API-Faucet](https://github.com/terobox/chatgpt-api-faucet) - AI 圈的水龍頭網站，每24小時可領取一個令牌用於開發測試 AI 產品。
 * [WELearnHelper](https://github.com/ssmjae/welearnhelper) - 顯示WE Learn隨行課堂題目答案；支持班級測驗；自動答題；刷時長；基於生成式AI(ChatGPT)的答案生成
 * [devchat](https://github.com/devchat-ai/devchat) - 使用AI驅動的腳本自動化您的開發任務，從您的IDE的聊天面板開始。
 * [ChatGPTSwiftUI](https://github.com/alfianlosari/chatgptswiftui) - 一個 ChatGPT 原生的 iOS、macOS、watchOS、tvOS SwiftUI 應用程式
 * [qcg-installer](https://github.com/rockchinq/qcg-installer) - ChatGPT QQ 機器人的自動安裝器，自動化部署，適用於QChatGPT項目: https://github.com/RockChinQ/QChatGPT
 * [wechatSDK](https://github.com/wechatapis/wechatsdk) - 微信機器人是一個創新的基於Python 3.11開發的項目，通過結合ChatGPT模型和微信原生API，為用戶提供智能聊天、自動繪畫、自動發朋友圈、自動發視頻號等多樣的API集成服務，旨在提升日常溝通效率和趣味性。
 * [FreeGPT35](https://github.com/missuo/freegpt35) - 使用由ChatGPT Web提供的無限免費GPT-3.5-Turbo API服務。
 * [SWE-agent](https://github.com/princeton-nlp/swe-agent) - SWE代理接收GitHub问题，并尝试使用GPT-4或您选择的LM自动修复它。它在SWE-bench评估集中解决了12.29%的错误，并仅需1.5分钟运行。
 * [GalTransl](https://github.com/xd2333/galtransl) - 支援GPT-3.5/GPT-4/Newbing/Sakura等大型語言模型的視覺小說自動翻譯解決方案
 * [VAR](https://github.com/foundationvision/var) - [GPT擊敗擴散🔥] [視覺生成中的比例定律📈] 官方實現"視覺自回歸建模：通過下一尺度預測實現可擴展圖像生成"
 * [ChatWaifu](https://github.com/cjyaddone/chatwaifu) - 將ChatGPT與Moegoe TTS結合，創建一個聊天妻子。
 * [AutoAgents](https://github.com/link-agi/autoagents) - [IJCAI 2024] 生成不同角色的GPT，形成協作實體，以應對複雜任務。
 * [suno-api](https://github.com/gcui-art/suno-api) - 使用API調用suno.ai的音樂生成AI，並輕鬆集成到像GPTs這樣的代理程序中。
 * [ChatGPT-miniprogram](https://github.com/leon-fong/chatgpt-miniprogram) - 🤖 ChatGPT 小程式
 * [99AI](https://github.com/vastxie/99ai) - 99AI 穩定版：基於 NineAI 二開的可商業化 AI Web 應用（免授權，無後門，支持快速部署）。目標 ALL-IN-CHAT
 * [geekai](https://github.com/yangjian102621/geekai) - AI 助手全套開源解決方案，自帶運營管理後台，開箱即用。集成了 ChatGPT, Azure, ChatGLM,訊飛星火，文心一言等多個平台的大語言模型。支持 MJ AI 繪畫，Stable Diffusion AI 繪畫，微博熱搜等插件工具。採用 Go + Vue3 + element-plus 實現。
 * [ChatGPT-on-WeChat](https://github.com/kx-huang/chatgpt-on-wechat) - 🤖️ 在您的微信上部署ChatGPT只需2个步骤！兩步在雲端部署您的微信ChatGPT聊天機器人！🤖️
 * [ai-to-pptx](https://github.com/chatbookai/ai-to-pptx) - Ai-to-pptx是一個使用AI技術(ChatGpt和Gemini)製作PPTX的助手，支持線上修改和匯出PPTX。 主要功能: 1 使用ChatGPT等大語言模型來生成大綱 2 生成的內容允許用戶再次修改 3 生成PPTX的時候可以選擇不同的模板 4 支持線上修改PPTX的文字內容，樣式，圖片等 5 支持匯出PPTX，PDF，PNG等多種格式
 * [DAIL-SQL](https://github.com/beachwang/dail-sql) - 一種高效且有效的少樣本NL2SQL方法在GPT-4上。
 * [auto-playwright](https://github.com/lucgagan/auto-playwright) - 使用ChatGPT自動化Playwright步驟。
 * [mi-gpt](https://github.com/idootop/mi-gpt) - 🏠 將小愛音箱接入 ChatGPT 和豆包，改造成你的專屬語音助手。
 * [hostedgpt](https://github.com/allyourbot/hostedgpt) - 一個開放版本的ChatGPT，您可以在任何地方主持或在本地運行。
 * [typingmind](https://github.com/typingmind/typingmind) - AI聊天的最先進Web UI
 * [reflex-chat](https://github.com/reflex-dev/reflex-chat) - 在 Reflex 中构建的 ChatGPT 克隆
 * [gptpdf](https://github.com/cosmosshadow/gptpdf) - 使用GPT解析PDF
 * [vectorhub](https://github.com/guangzhengli/vectorhub) - 快速且輕鬆地使用嵌入式技術來建立人工智慧網站或應用程式！
 * [chatgpt-artifacts](https://github.com/ozgrozer/chatgpt-artifacts) - 將克勞德的文物功能帶到ChatGPT
 * [Protofy](https://github.com/protofy-xyz/protofy) - AI 強化的 LowCode 平台 CMS 和框架 🚀🚀
 * [go2coding.github.io](https://github.com/go2coding/go2coding.github.io) - AI工具導航，免費chatgpt，chatgpt4，midjourney，notion ai，tome.app
 * [chatgpt](https://github.com/putyy/chatgpt) - Input: uniapp、hyperf MineAdmin 實現的 chatgpt應用，支持小程序、h5、app！Output: uniapp、hyperf MineAdmin 實現的 chatgpt應用，支持小程序、h5、app！
 * [vscode-chatgpt-reborn](https://github.com/christopher-hayes/vscode-chatgpt-reborn) - 在VSCode中使用GPT-3和GPT-4重構、改進和除錯您的代碼。
 * [Chatgpt-Makes-Money](https://github.com/xiaoming2028/chatgpt-makes-money) - ChatGPT副業賺錢技巧必看, ChatGPT副業賺錢秘笈, ChatGPT從入門到精通
 * [sendbird-uikit-react](https://github.com/sendbird/sendbird-uikit-react) - 使用Sendbird UIKit開源代碼，幾分鐘內建立聊天功能。
 * [sol-mate-eink](https://github.com/blixt/sol-mate-eink) - 在您的電子紙顯示器上使用Sol Mate GPT！
 * [gptstore-data-backup](https://github.com/ainativelab/gptstore-data-backup) - GPT Store每日熱門數據存檔
 * [ChatGPT-airport-tizi-fanqiang](https://github.com/axiba053/chatgpt-airport-tizi-fanqiang) - ChatGPT科學上網梯子機場推薦，GPT4升級教程，Claude-3免費使用教程
 * [vscode-reborn-ai](https://github.com/vscode-reborn-ai/vscode-reborn-ai) - 在VSCode中使用GPT-3和GPT-4重構、改進和除錯您的代碼。
 * [gpts](https://github.com/ruvnet/gpts) - rUv創建的GPT集合
 * [zerox](https://github.com/getomni-ai/zerox) - 使用gpt-4o-mini进行零射击pdf OCR
 * [gpt-games](https://github.com/jimliu/gpt-games) - 使用GPT建立遊戲
 * [DecodingTrust](https://github.com/ai-secure/decodingtrust) - GPT模型信任度的全面評估
 * [TalkingHeads](https://github.com/ugorsahin/talkingheads) - 一個與ChatGPT、Claude、Copilot、Gemini、HuggingChat和Pi通信的圖書館
 * [ChatGPT-Mirror](https://github.com/dairoot/chatgpt-mirror) - 🚀 一鍵部署自己的 ChatGPT 鏡像站
 * [WiNGPT2](https://github.com/winninghealth/wingpt2) - WiNGPT是一個基於GPT的醫療垂直領域大模型，旨在將專業的醫學知識、醫療信息、數據融會貫通，為醫療行業提供智能化的醫療問答、診斷支持和醫學知識等信息服務，提高診療效率和醫療服務質量。
 * [modded-nanogpt](https://github.com/kellerjordan/modded-nanogpt) - GPT-2（124M）在5B令牌中的質量GPT-2（124M）在5B令牌中的質量
 * [minimind](https://github.com/jingyaogong/minimind) - 【大模型】3小時完全從0訓練一個僅有26M的小參數GPT，最低僅需2G顯卡即可推理訓練！
 * [AI-Youtube-Shorts-Generator](https://github.com/samuraigpt/ai-youtube-shorts-generator) - 一個使用GPT-4、FFmpeg和OpenCV的Python工具，可以自動分析視頻，提取最有趣的部分並對其進行裁剪，以提供更好的觀看體驗。
 * [miniperplx](https://github.com/zaidmukaddam/miniperplx) - 一個極簡主義的AI動力搜索引擎，幫助您在互聯網上找到信息。使用像GPT-4o mini、Claude 3.5 Sonnet和o1-mini這樣的模型進行搜索！
 * [ai-commit](https://github.com/insulineru/ai-commit) - ✨ 使用ChatGPT、Gitmoji和傳統提交，使提交更加容易 🚀
 * [show-me](https://github.com/marlaman/show-me) - 一個視覺透明的替代方案，比開源ChatGPT O1更好。
 * [chatgpt-api-server](https://github.com/xyhelper/chatgpt-api-server) - 基於chatgpt官網帳號轉接對外實現API服務
 * [ChatALL](https://github.com/ai-shifu/chatall) - 同時與ChatGPT、Bing Chat、Bard、Alpaca、Vicuna、Claude、ChatGLM、MOSS、訊飛星火、文心一言等進行聊天，發現最佳答案。
 * [shadcn-nextjs-boilerplate](https://github.com/horizon-ui/shadcn-nextjs-boilerplate) - Shadcn UI NextJS 樣板 ⚡️ 免費開源 ChatGPT UI 管理員儀表板模板 - Horizon AI 樣板
 * [TaskWeaver](https://github.com/microsoft/taskweaver) - 在Visual Studio Code中集成CMake


