# awesome-ChatGPT-repositories

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Hugging Face Spaces](https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue)](https://huggingface.co/spaces/taishi-i/awesome-ChatGPT-repositories-search)
[![License: CC0-1.0](https://img.shields.io/badge/License-CC0_1.0-lightgrey.svg)](http://creativecommons.org/publicdomain/zero/1.0/)
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

一个专门用于与[ChatGPT](https://openai.com/blog/chatgpt)相关的开源GitHub存储库的资源列表.
搜索这些存储库的[工具](https://huggingface.co/spaces/taishi-i/awesome-ChatGPT-repositories-search)可在 Hugging Face Spaces 上找到.

您的贡献始终是受欢迎的! 在捐款之前,请阅读[指南](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/contributing.md).

[English](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.en.md) | [日本語 (Japanese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.ja.md) | [繁體中文 (Chinese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.zh-hant.md) | [简体中文 (Chinese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.zh-hans.md)


## The latest additions 🎉

**Prompts**
 * [archgw](https://github.com/katanemo/archgw) - Arch是代理的智能网关。 使用（快速）LLMs进行工程设计，用于安全处理，丰富的可观察性，并将提示与您的API无缝集成 - 所有这些都在业务逻辑之外。 由Envoy代理的核心贡献者在Envoy上构建。
 * [openlit](https://github.com/openlit/openlit) - AI工程的开源平台：OpenTelemetry原生LLM可观测性，GPU监控，防护栏，评估，提示管理，保险库，游乐场。🚀💻 与40多个LLM提供商，VectorDBs，代理框架和GPU集成。


**Browser-extensions**
 * [aura-voice](https://github.com/ntegrals/aura-voice) - Aura就像Siri一样，但是在你的浏览器中。一款专为低延迟响应优化的人工智能语音助手。


**Openai**
 * [coai](https://github.com/coaidev/coai) - 🚀 下一代 AI 一站式国际化解决方案。🚀 支持 OpenAI，Midjourney，Claude，讯飞星火，Stable Diffusion，DALL·E，ChatGLM，通义千问，腾讯混元，360 智脑，百川 AI，火山方舟，新必应，Gemini，Moonshot 等模型，支持对话分享，自定义预设，云端同步，模型市场，支持弹性计费和订阅计划模式，支持图片解析，支持联网搜索，支持模型。
 * [self-operating-computer](https://github.com/othersideai/self-operating-computer) - 一个框架，使多模型能够操作计算机。
 * [blinko](https://github.com/blinko-space/blinko) - 一个开源的、自托管的个人笔记工具，注重隐私，使用TypeScript构建。


_Updated on November 28, 2024_ (A total of 1892 repositories listed.)

## Table of contents

 * [Awesome-lists](#awesome-lists)
 * [Prompts](#prompts)
 * [Chatbots](#chatbots)
 * [Browser-extensions](#browser-extensions)
 * [CLIs](#clis)
 * [Reimplementations](#reimplementations)
 * [Tutorials](#tutorials)
 * [NLP](#nlp)
 * [Langchain](#langchain)
 * [Unity](#unity)
 * [Openai](#openai)
 * [Others](#others)

## Awesome-lists

 * [awesome-chatgpt-api](https://github.com/reorx/awesome-chatgpt-api) - 筛选出的应用程序和工具列表不仅使用新的ChatGPT API，而且还允许用户配置自己的API密钥，从而实现自由和按需使用自己的配额。
 * [awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) - 这个仓库包括ChatGPT提示的策划，以更好地使用ChatGPT。
 * [awesome-chatgpt](https://github.com/humanloop/awesome-chatgpt) - ChatGPT和GPT-3的精选工具、演示和文档列表
 * [awesome-totally-open-chatgpt](https://github.com/nichtdax/awesome-totally-open-chatgpt) - 一份完全开放的ChatGPT替代方案列表
 * [awesome-chatgpt-prompts-zh](https://github.com/plexpt/awesome-chatgpt-prompts-zh) - ChatGPT 中文调教指南。各种场景使用指南。学习怎么让它听你的话。
 * [Awesome-ChatGPT](https://github.com/dalinvip/awesome-chatgpt) - ChatGPT资料汇总学习，持续更新......ChatGPT资料汇总学习，持续更新......
 * [awesome-compbio-chatgpt](https://github.com/csbl-br/awesome-compbio-chatgpt) - 一个由社区策划的ChatGPT和其他计算生物学LLMs应用的令人惊叹的存储库。
 * [awesome-chatgpt](https://github.com/openmindclub/awesome-chatgpt) - ⚡ 关于ChatGPT的一切
 * [awesome-chatgpt](https://github.com/saharmor/awesome-chatgpt) - 精选的ChatGPT演示、工具、文章等等 ✨
 * [awesome-chatgpt-zh](https://github.com/yzfly/awesome-chatgpt-zh) - ChatGPT 中文指南，ChatGPT 中文调教指南，指令指南，精选资源清单，更好的使用 ChatGPT 让你的生产力 up up up！
 * [awesome-chatgpt](https://github.com/eon01/awesome-chatgpt) - 🧠 精选的 ChatGPT 资源列表，包括库、SDK、API 等等。🌟 请考虑通过给它点赞来支持这个项目。
 * [awesome-gpt4](https://github.com/taranjeet/awesome-gpt4) - GPT-4的资源、用例和演示的精选列表
 * [awesome-gpt-security](https://github.com/cckuailong/awesome-gpt-security) - 一个由LLM或GPT实验案例、其他有趣的事物以及安全工具组成的策划清单。
 * [Awesome-GPT4-Prompts](https://github.com/ora-sh/awesome-gpt4-prompts) - 一组令人惊叹的GPT4提示集合
 * [awesome-chatgpt](https://github.com/sindresorhus/awesome-chatgpt) - 🤖 ChatGPT的超棒列表——由OpenAI开发的人工智能聊天机器人
 * [awesome-free-chatgpt](https://github.com/lilittlecat/awesome-free-chatgpt) - 🆓免费的 ChatGPT 镜像网站列表，持续更新。
 * [awesome-gpt-prompt-engineering](https://github.com/snwfdhmp/awesome-gpt-prompt-engineering) - 一个为GPT提示工程师精心策划的资源、工具和其他闪亮物品的精选列表。
 * [awesome-chatgpt-prompts-cybersecurity](https://github.com/sechelper/awesome-chatgpt-prompts-cybersecurity) - 网络安全chatgpt指令集，训练chatgpt成为一名网络安全专家。
 * [awesome-ai](https://github.com/lencx/awesome-ai) - 🤖 令人惊叹的人工智能
 * [awesome-chatgpt-code-interpreter-experiments](https://github.com/skalskip/awesome-chatgpt-code-interpreter-experiments) - 使用ChatGPT + Code Interpreter组合可以做的很棒的事情🔥
 * [awesome-ai](https://github.com/520hacker/awesome-ai) - 对开源AI转发套壳应用生态进行研究，收集开源AI转发套壳应用，并进行对比。ChatGPT，OPENAI.AZURE，BAIDU，XUNFEI
 * [Awesome-ChatGPT-AI-ZH](https://github.com/changeyu0229/awesome-chatgpt-ai-zh) - 全网曝光超过1000万的「AI 知识库」正式移步Github开源，永久免费更新，提供ChatGPT，Midjourney等使用教程。
 * [Awesome-LLM-Eval](https://github.com/onejune2018/awesome-llm-eval) - 令人惊叹的LLM评估：一个精选的工具、演示、论文、文档列表，用于评估像ChatGPT、LLaMA、GLM这样的大型语言模型。
 * [awesome-chatgpt-dataset](https://github.com/voidful/awesome-chatgpt-dataset) - 解锁LLM的力量：探索这些数据集，训练您自己的ChatGPT！
 * [awesome-gpt](https://github.com/formulahendry/awesome-gpt) - 一个精选的与GPT、ChatGPT、OpenAI、LLM等相关的令人惊叹的项目和资源列表。
 * [awesome-instruction-dataset](https://github.com/yaodongc/awesome-instruction-dataset) - 一个用于训练指令跟随LLM（ChatGPT、LLaMA、Alpaca）的开源数据集合。
 * [awesome-chatgpt](https://github.com/uhub/awesome-chatgpt) - 一个精选的令人惊叹的ChatGPT相关项目列表。
 * [Awesome-Prompt-Engineering](https://github.com/promptslab/awesome-prompt-engineering) - 这个仓库包含了一个手动策划的资源，重点关注生成式预训练转换器（GPT）、ChatGPT、PaLM等方面的Prompt工程。
 * [awesome-generative-ai](https://github.com/filipecalegario/awesome-generative-ai) - 一个精选的生成式人工智能工具、作品、模型和参考资料列表
 * [awesome-open-gpt](https://github.com/ewingyangs/awesome-open-gpt) - GPT相关开源项目合集🚀、精选🔥🔥
 * [Awesome-AITools](https://github.com/ikaijua/awesome-aitools) - 收集了一系列与人工智能相关的实用工具。欢迎提交问题和拉取请求。
 * [Awesome-GPTs](https://github.com/ai-boost/awesome-gpts) - 精选的超棒GPT清单👍。
 * [awesome-segment-anything](https://github.com/hedlen/awesome-segment-anything) - 跟踪和收集与分割任何相关的论文/项目/其他内容。跟踪和收集与分割任何相关的论文/项目/其他内容。
 * [Awesome-AIGC-Tutorials](https://github.com/luban-agi/awesome-aigc-tutorials) - 精选的大型语言模型、AI绘画等教程和资源。
 * [awesome-gpts](https://github.com/taranjeet/awesome-gpts) - 社区创建的所有GPT的集合
 * [prompt-in-context-learning](https://github.com/egoalpha/prompt-in-context-learning) - 用于上下文学习和提示工程的绝佳资源：掌握ChatGPT、GPT-3和FlanT5等LLM的最新和尖端更新。
 * [Awesome-GPT-Store](https://github.com/anil-matcha/awesome-gpt-store) - 自定义GPT商店 - 一个收集了公开可用的主要GPT的集合
 * [awesome-chatgpt](https://github.com/awesome-chatgpt/awesome-chatgpt) - 🏆 一个关于ChatGPT最佳资源、工具、应用和用法的精选清单
 * [BlackFriday-GPTs-Prompts](https://github.com/friuns2/blackfriday-gpts-prompts) - 免费的GPT列表，不需要Plus订阅
 * [best-of-ml-python](https://github.com/ml-tooling/best-of-ml-python) - 🏆 一份排名靠前的令人惊叹的机器学习Python库列表。每周更新。
 * [awesome-openai-vision-api-experiments](https://github.com/roboflow/awesome-openai-vision-api-experiments) - 必备资源，适合任何想要尝试和构建OpenAI视觉API的人🔥
 * [Awesome-LLM-KG](https://github.com/rmanluo/awesome-llm-kg) - 关于统一LLMs和KGs的精彩论文
 * [Awesome-AI-GPTs](https://github.com/embraceagi/awesome-ai-gpts) - 令人惊叹的AI GPT，OpenAI GPT，GPT-4，ChatGPT，GPT，提示，插件，提示泄漏
 * [Awesome-GPT-Agents](https://github.com/fr0gger/awesome-gpt-agents) - 一个精选的用于网络安全的GPT代理列表
 * [Awesome-One-Click-Deployment](https://github.com/connectai-e/awesome-one-click-deployment) - 🪄 一键部署许多Github开源项目，以便快速体验
 * [LLM-Reasoning-Papers](https://github.com/atfortes/llm-reasoning-papers) - 关于大型语言模型（LLMs）推理的论文和资源集合，包括思维链（CoT）、指导调整等。输出：大型语言模型（LLMs）推理的论文和资源集合，包括思维链（CoT）、指导调整等。
 * [awesome-chatgpt-store](https://github.com/devisasari/awesome-chatgpt-store) - 一个精选的令人惊叹的自定义GPT清单
 * [Leaked-GPTs](https://github.com/friuns2/leaked-gpts) - 泄露的GPTs促使绕过25条信息限制或尝试GPTs而无需Plus订阅。
 * [awesome-chatgpt-project](https://github.com/xianyu110/awesome-chatgpt-project) - 1. chatGPT注册2. chatGPT成品项目整理3. 高效使用chatGPT的小技巧4. 调教指南 ↓演示网站
 * [awesome-llm-powered-agent](https://github.com/hyp1231/awesome-llm-powered-agent) - 关于LLM动力代理的精彩事物。论文/代码库/博客/...
 * [awesome-gpt-store](https://github.com/devisasari/awesome-gpt-store) - 一个精选的GPT商店中的精彩GPT清单
 * [AiTreasureBox](https://github.com/superiorlu/aitreasurebox) - 🤖 收集实用的AI仓库、工具、网站、论文和教程。实用的AI百宝箱 💎
 * [Awesome-LLM-Reasoning](https://github.com/atfortes/awesome-llm-reasoning) - 论文和资源的收集，关于语言模型（LLMs）中的推理，包括思维链（CoT），指导调整和多模态。
 * [awesome-llm-and-aigc](https://github.com/codingonion/awesome-llm-and-aigc) - 🚀🚀🚀一些关于大型语言模型、视觉基础模型和人工智能生成内容的精彩公共项目的集合。
 * [awesome-gpts-prompts](https://github.com/ai-boost/awesome-gpts-prompts) - GPTs商店中排名靠前的GPTs的精选聊天GPT提示列表。输出：
 * [Awesome-LLM-Uncertainty-Reliability-Robustness](https://github.com/jxzhangjhu/awesome-llm-uncertainty-reliability-robustness) - 强大的LLM鲁棒性：大型语言模型中不确定性、可靠性和鲁棒性的精选列表
 * [awesome-prompts](https://github.com/ai-boost/awesome-prompts) - 精心策划的聊天GPT提示列表，来自GPT商店中排名靠前的GPT。提示工程，提示攻击和提示保护。高级提示工程论文。
 * [awesome-decentralized-llm](https://github.com/imaurer/awesome-decentralized-llm) - 收集LLM资源，可用于构建您可以“拥有”的产品，或进行可重复研究。
 * [awesome-gpt4](https://github.com/radi-cho/awesome-gpt4) - 一个关于GPT-4语言模型的策划列表，工具和资源。
 * [awesome-transformer-nlp](https://github.com/cedrickchee/awesome-transformer-nlp) - 一个精心筛选的自然语言处理资源列表，重点关注Transformer网络、注意力机制、GPT、BERT、ChatGPT、LLMs和迁移学习。
 * [awesome-claude-prompts](https://github.com/langgptai/awesome-claude-prompts) - 这个存储库包括了克劳德提示的整理，以更好地使用克劳德。
 * [awesome-ai-sdks](https://github.com/e2b-dev/awesome-ai-sdks) - 一个用于创建、监控、调试和部署自主人工智能代理的SDK、框架、库和工具数据库
 * [awesome-claude-prompts](https://github.com/yzfly/awesome-claude-prompts) - Gitalk 评论
 * [chatgpt-corpus](https://github.com/plexpt/chatgpt-corpus) - ChatGPT 中文语料库 包括对话、小说和客服语料，用于训练大型模型。
 * [awesome-gpt](https://github.com/awesome-gptx/awesome-gpt) - 🏆 一个令人敬畏的资源收藏，涵盖了与ChatGPT相关的各种工具、文件、资源、应用程序和用例。
 * [lobe-chat-agents](https://github.com/lobehub/lobe-chat-agents) - 🤖 / 🏪 代理商索引 - 这是LobeChat的代理商索引。它从这个存储库中访问index.json，以显示LobeChat在代理市场上可用的代理商列表。
 * [awesome-python](https://github.com/dylanhogg/awesome-python) - 🐍 精选的优秀Python库和框架，按类别组织
 * [awesome-llm-role-playing-with-persona](https://github.com/neph0s/awesome-llm-role-playing-with-persona) - 厉害-llm-角色扮演与角色: 一个为大型语言模型提供资源的策划列表，用于与指定的角色扮演。
 * [awesome-chatgpt-zh](https://github.com/embraceagi/awesome-chatgpt-zh) - ChatGPT 中文指南🔥，ChatGPT 中文调教指南，指令指南，应用开发指南，精选资源清单，更好的使用 chatGPT 让你的生产力 up up up! 🚀
 * [Awesome-Machine-Generated-Text](https://github.com/ictmcg/awesome-machine-generated-text) - 持续更新的与生成式LLM（如GPT）及其分析和检测相关资源列表。
 * [Awesome_GPT_Super_Prompting](https://github.com/cyberalbsecop/awesome_gpt_super_prompting) - ChatGPT越狱，GPT助手提示泄漏，GPT提示注入，LLM提示安全，超级提示，提示黑客，提示安全，Ai提示工程，对抗性机器学习。
 * [lobe-chat-plugins](https://github.com/lobehub/lobe-chat-plugins) - 🧩 / 🏪 插件索引 - 这是LobeChat的插件索引。它从这个存储库访问index.json，向用户显示可用插件的列表。
 * [Awesome-LLM-Strawberry](https://github.com/hijkzzz/awesome-llm-strawberry) - 一个关于LLM论文、博客和项目的收集，重点关注OpenAI o1和推理技术。
 * [awesome-llm-apps](https://github.com/shubhamsaboo/awesome-llm-apps) - 使用OpenAI、Anthropic、Gemini和开源模型的一组出色的LLM应用程序集合。
 * [awesome-LLM-resourses](https://github.com/wangrongsheng/awesome-llm-resourses) - 🧑‍🚀 全球最好的LLM资源总结
 * [awesome-ai-agents](https://github.com/e2b-dev/awesome-ai-agents) - AI自主代理的列表


## Prompts

 * [gpt-repository-loader](https://github.com/mpoon/gpt-repository-loader) - 将代码仓库转换为LLM提示友好格式。主要由GPT-4构建。
 * [myGPTReader](https://github.com/madawei2699/mygptreader) - myGPTReader是Slack上的一个机器人，可以阅读和总结任何网页、文档（包括电子书）甚至来自YouTube的视频。它可以通过语音与您交流。
 * [PromptCraft-Robotics](https://github.com/microsoft/promptcraft-robotics) - 应用LLM到机器人的社区和集成ChatGPT的机器人模拟器。
 * [chat-gpt-quine](https://github.com/fullthom/chat-gpt-quine) - @realtimeai 几周前有人试图使用chatgpt制作一个自我改进的提示。它只用了11代就崩溃成了一种病态模式。
 * [blender_jarvis](https://github.com/dene33/blender_jarvis) - 通过ChatGPT的文本提示控制Blender
 * [Promptify](https://github.com/promptslab/promptify) - Prompt Engineering | 使用GPT或其他基于提示的模型获取结构化输出。加入我们的Discord，了解Prompt-Engineering、LLMs和其他最新研究。
 * [SchemaGPT](https://github.com/u-hubar/schemagpt) - 使用GPT-3魔法的Python库，用于从提示生成RDF模式🪄🪄🪄
 * [CaFo](https://github.com/zrrskywalker/cafo) - [CVPR 2023] 快速生成并缓存：基础模型级联使得强大的少样本学习者
 * [gpt3-interview-bot](https://github.com/promptable/gpt3-interview-bot) - GPT3面试聊天机器人
 * [ama_prompting](https://github.com/hazyresearch/ama_prompting) - 问我任何事情的语言模型提示
 * [LMOps](https://github.com/microsoft/lmops) - 使用LLMs和MLLMs实现AI能力的通用技术
 * [bark](https://github.com/suno-ai/bark) - 🔊 文本提示生成音频模型
 * [Prompt-Engineering-Guide](https://github.com/dair-ai/prompt-engineering-guide) - 🐙 提供快速工程的指南、论文、讲座、笔记和资源
 * [langchain-and-elevenlabs-with-pdf-analysis](https://github.com/unicornlaunching/langchain-and-elevenlabs-with-pdf-analysis) - 我们如何将OpenAI、Langchain和ElevenLabs混合在一起，使用PDF中封装的知识体系来回答提示并发表言论？
 * [promptr](https://github.com/ferrislucas/promptr) - Promptr是一个使用GPT操作代码库的CLI工具。Promptr动态地将一个或多个文件包含到您的GPT提示中，并可以选择解析和应用GPT建议的更改到您的代码库中。包含了多个用于不同目的的提示模板，用户可以创建自己的模板。
 * [chatgpt-clone](https://github.com/danny-avila/chatgpt-clone) - ChatGPT的克隆版，使用官方模型和Bing，反向工程UI，具有AI模型切换、消息搜索和提示模板（正在进行中）。
 * [ChatGPT-Prompt-Genius](https://github.com/benf2004/chatgpt-prompt-genius) - 不仅可以通过提示激发您的创造力，还可以自由地为这个开源项目做出贡献。#chatgpt #gpt4 #chatgptprompts
 * [ChatGPT-Adventure](https://github.com/capnmidnight/chatgpt-adventure) - 一个开始提示，让ChatGPT创建一个文字冒险游戏。
 * [chatgpt-text-to-midjourney-image](https://github.com/barretlee/chatgpt-text-to-midjourney-image) - 使用ChatGPT优化提示，然后将其发送给Replicate创建图像。
 * [Prompt-hunter](https://github.com/op7418/prompt-hunter) - 将Midjourney详情页面的提示和图片保存到您的Notion页面中。
 * [chatbox](https://github.com/bin-huang/chatbox) - 一个支持Windows、Mac和Linux的ChatGPT API（OpenAI API）桌面应用程序。这是一个开源的应用程序，使用prompt开发工具，可以在所有平台上使用，只需下载安装包即可。
 * [ChatGPT-Shortcut](https://github.com/rockbenben/chatgpt-shortcut) - 最大化你的效率和生产力。ChatGPT快捷指令可以让你的生产力翻倍，按领域和功能分区，可以对提示词进行标签筛选、关键词搜索和一键复制。
 * [promptable](https://github.com/cfortuner/promptable) - 使用Typescript/Javascript构建LLM应用程序。🧑‍💻 🧑‍💻 🧑‍💻 🚀 🚀 🚀
 * [ChatGPT3-Free-Prompt-List](https://github.com/mattnigh/chatgpt3-free-prompt-list) - 一个免费的指南，教你学习创建ChatGPT3提示。
 * [prompt-engine](https://github.com/microsoft/prompt-engine) - 使用Figma创建应用程序
 * [ChatGPT-Siri](https://github.com/yue-yang/chatgpt-siri) - 使用ChatGPT API gpt-3.5-turbo和gpt-4模型的Siri快捷方式，支持连续对话，配置API密钥和保存聊天记录。配置系统提示。
 * [The-HustleGPT-Challenge](https://github.com/jtmuller5/the-hustlegpt-challenge) - 与AI联合创始人一起打造创业公司
 * [docsgpt](https://github.com/arc53/docsgpt) - 通过微调创建小模型：-：-：-工程：-后见之明提示链-
 * [chatgpt-prompts](https://github.com/carterleffen/chatgpt-prompts) - 这里是我创建并想分享的提示。
 * [ChatGPT-Data-Science-Prompts](https://github.com/travistangvh/chatgpt-data-science-prompts) - ChatGPT的60个有用的数据科学提示存储库
 * [CWK-ChatGPT-MidJourney-Prompt-Template](https://github.com/neobundy/cwk-chatgpt-midjourney-prompt-template) - cwk-chatgpt-midjourney-prompt-template v1.2可能是最后一个版本：支持23种提示类型。我将采用面向对象的方法进行完全重写。它将与chatgpt更好地配合使用。仓库中有一个1.2轻量级分支，删除了一些...
 * [chatgpt-prompts-bug-bounty](https://github.com/taksec/chatgpt-prompts-bug-bounty) - ChatGPT 提供漏洞赏金和渗透测试提示。
 * [Share-to-ChatGPT-Shortcut](https://github.com/reorx/share-to-chatgpt-shortcut) - 一个苹果快捷方式，可以使用个性化提示将文本分享到ChatGPT。
 * [ChatGPT-Prompts](https://github.com/prathamkumar14/chatgpt-prompts) - 人工智能正在慢慢接管。以下是一些使用ChatGPT/API提示，可帮助您释放100％的生产力。
 * [soren](https://github.com/jacksonmills/soren) - SorenCAI是一款人工智能软件工程师助手提示。
 * [chatbot-injections-exploits](https://github.com/cranot/chatbot-injections-exploits) - 聊天机器人注入和利用示例：一份策划的工程师命令列表 - ChatGPT
 * [ai-notes](https://github.com/sw-yx/ai-notes) - 软件工程师了解新的人工智能发展的笔记。作为 lspace.swyx.io 写作和产品头脑风暴的数据存储，但在 /资源文件夹下整理了干净的规范参考资料。
 * [squidgy-prompts](https://github.com/squidgyai/squidgy-prompts) - 有没有#langtwt的人对#gpt3 / #chatgpt和语言学习感兴趣？我们刚刚发布了一组开源提示，帮助学习者构建卡组、挖掘句子、纠正语法、玩单词游戏等等。可以单独使用或在@squidgiesapp中使用。
 * [ChatGPT_DAN](https://github.com/0xk1h0/chatgpt_dan) - ChatGPT DAN，越狱提示
 * [ResearchChatGPT](https://github.com/hollobit/researchchatgpt) - ChatGPT的50个用例研究工作
 * [FinGPT](https://github.com/ai4finance-foundation/fingpt) - 开源开放金融！革命🔥
 * [aish](https://github.com/aishell-io/aish) - 一个带有本地存储的ChatGPT CLI，用于提示和消息。
 * [Mr.-Ranedeer-AI-Tutor](https://github.com/jushbjj/mr.-ranedeer-ai-tutor) - 一个可定制个性化学习体验的GPT-4 AI导师提示。
 * [ChatGPT-Prompt-Engineering-for-Developers-in-Chinese](https://github.com/githubdaily/chatgpt-prompt-engineering-for-developers-in-chinese) - 《面向开发者的 ChatGPT 提示词工程》非官方版中英双语字幕：开发者必看！
 * [prompt-engineering-for-developers](https://github.com/datawhalechina/prompt-engineering-for-developers) - 吴恩达《ChatGPT Prompt Engineering for Developers》课程中文版，视频地址：https://www.bilibili.com/video/BV1Bo4y1A7FU
 * [unleashedgpt](https://github.com/ambr0sial/unleashedgpt) - UnleashedGPT：又一个ChatGPT越狱
 * [GPT-Prompts](https://github.com/jesselau76/gpt-prompts) - 有用的GPT提示
 * [prompt-engineering](https://github.com/brexhq/prompt-engineering) - 使用像OpenAI的GPT-4这样的大型语言模型的技巧和窍门。
 * [wonderful-prompts](https://github.com/yzfly/wonderful-prompts) - 🔥中文提示精选🔥，ChatGPT使用指南，提升ChatGPT可玩性和可用性！🚀
 * [RecurrentGPT](https://github.com/aiwaves-cn/recurrentgpt) - RecurrentGPT：交互式生成（任意长度的）长文本。每个时间步生成一个段落，并分别更新存储在硬盘和提示中的基于语言的长短期记忆。仓库：abs：
 * [jopilot-4-job-seekers](https://github.com/jopilot-net/jopilot-4-job-seekers) - JoPilot支持的提示信息
 * [chain-of-thought-hub](https://github.com/franxyao/chain-of-thought-hub) - 使用思维链提示来基准测试大型语言模型的复杂推理能力
 * [ChatGPT-Admin-Web](https://github.com/aprilnea/chatgpt-admin-web) - 带有用户管理和后台管理系统的 ChatGPT 网页用户界面
 * [powerplatform-prompts](https://github.com/pnp/powerplatform-prompts) - 这个仓库包含了一系列的提示示例，可用于在Power Platform中使用GPT模型。
 * [tutor-gpt](https://github.com/plastic-labs/tutor-gpt) - LangChain LLM 应用程序。针对辅导任务的动态少量样本元提示。
 * [chat-gpt-games](https://github.com/admtal/chat-gpt-games) - 在ChatGPT中可玩游戏的提示
 * [TaskMatrix](https://github.com/microsoft/taskmatrix) - 如果提示信息具有描述性并且彼此之间可以区分，那么我认为代理程序仍然可以适用于大量的工具。如果想要查看一组工具的示例用法，请查看微软的visualChatGPT存储库，但不确定是否适用于100万个工具... @jksyaw @LangChainAI @FlowiseAI @bubble
 * [GPTWorld](https://github.com/srush/gptworld) - 一个学习提示的谜题
 * [DemoGPT](https://github.com/melih-unsal/demogpt) - ⚡ DemoGPT 可以通过简单的提示帮助您创建快速演示。⚡ 🌟 点赞支持我们的工作！
 * [text-to-colorscheme](https://github.com/svermeulen/text-to-colorscheme) - 使用ChatGPT通过文本提示即时生成的Neovim配色方案
 * [gpt-prompt-engineer](https://github.com/mshumer/gpt-prompt-engineer) - 介绍 `gpt-prompt-engineer` ✍️ 一个能够创建最佳 GPT 提示的代理。只需描述任务，一系列 AI 系统将会：- 生成许多可能的提示- 在排名比赛中测试它们- 返回最佳提示。而且它是开源的：
 * [prompt-engineering-for-javascript-developers](https://github.com/dabit3/prompt-engineering-for-javascript-developers) - 来自DeepLearning.ai的ChatGPT Prompt Engineering for Developers的笔记总结ChatGPT Prompt Engineering for Developers的笔记总结
 * [gpt-runner](https://github.com/nicepkg/gpt-runner) - 与您的文件对话！管理和运行您的AI预设！
 * [promptmap](https://github.com/utkusen/promptmap) - 自动测试ChatGPT实例上的提示注入攻击。
 * [IntelliNode](https://github.com/barqawiz/intellinode) - 通过统一的提示层和性能评估，访问最新的AI模型，如ChatGPT、LLaMA、Stable Diffusion、WaveNet等等。
 * [tree-of-thought-prompting](https://github.com/dave1010/tree-of-thought-prompting) - 使用思维树提示来提升ChatGPT的推理能力
 * [chatGPT-prompt-scripts](https://github.com/wincheshe/chatgpt-prompt-scripts) - 油猴 chatgpt Prompt 脚本插件，在chatgpt聊天框导入Prompt 对话框油猴 chatgpt Prompt 脚本插件，将Prompt对话框导入到chatgpt聊天框中。
 * [llm.report](https://github.com/dillionverma/llm.report) - 📊 llm.report 是一个开源的日志和分析平台，用于OpenAI：记录您的ChatGPT API请求，分析成本，并改进您的提示。
 * [InstructZero](https://github.com/lichang-chen/instructzero) - 正式实施InstructZero；这是第一个优化ChatGPT(API LLMs)糟糕提示并最终获得良好提示的框架！
 * [chatgpt-prompt-engineering-for-developers](https://github.com/kevin-free/chatgpt-prompt-engineering-for-developers) - 吴恩达《ChatGPT Prompt Engineering for Developers》课程中英版
 * [chat-key](https://github.com/overflowy/chat-key) - 使用ChatGPT和AutoHotkey来提高您的生产力 🚀
 * [openprompt.co](https://github.com/timqian/openprompt.co) - 创建。使用。分享。ChatGPT提示
 * [Get-Things-Done-with-Prompt-Engineering-and-LangChain](https://github.com/curiousily/get-things-done-with-prompt-engineering-and-langchain) - LangChain和Prompt工程教程，涉及大型语言模型（LLMs）如ChatGPT与自定义数据。Jupyter笔记本上的数据加载和索引、创建提示模板、CSV代理以及使用检索QA链查询自定义数据的方法。项目用于使用私有LLM（Llama 2）进行聊天，并进行PDF文件和推文情感分析。
 * [LearnPrompt](https://github.com/learnprompt/learnprompt) - 永久免费开源的 AIGC 课程，目前已支持 ChatGPT、Midjourney、Runway、Stable Diffusion、AI数字人、AI声音和音乐、大模型微调。
 * [IntelliNode](https://github.com/intelligentnode/intellinode) - 通过统一的提示层和性能评估，访问最新的AI模型，如ChatGPT、LLaMA、Diffusion、Hugging face等等。
 * [azure-openai-llm-vector-langchain](https://github.com/kimtth/azure-openai-llm-vector-langchain) - Azure OpenAI，OSS LLM 🌊1. 向量数据库和🦙语言链 🔎2. RAG ChatGpt演示 3. Microsoft ♾️LLM 🌌库等。
 * [ChatGPT-Assistant](https://github.com/pierxuy/chatgpt-assistant) - 基于Streamlit搭建的ChatGPT对话助手，无须科学上网即可使用，可免费云部署。支持多窗口、语音交流、对话留存、上下文预设以及参数调节等功能。
 * [dev-chatgpt-prompts](https://github.com/pickleboxer/dev-chatgpt-prompts) - 📚 开发者的ChatGPT提示个人收藏！
 * [prompta](https://github.com/iansinnott/prompta) - ChatGPT UI 是以键盘为中心的，适用于移动设备的，可以在多个设备上同步聊天记录并搜索过去的对话。
 * [ChatGPT-Prompt-Sample-Japanese](https://github.com/dahatake/chatgpt-prompt-sample-japanese) - 这是ChatGPT的提示示例。
 * [chatgpt-prompts](https://github.com/jevantang/chatgpt-prompts) - 分门别类的 ChatGPT 中文引导语大全。
 * [chat-gpt-prompts-from-aiprm-zh](https://github.com/adambear/chat-gpt-prompts-from-aiprm-zh) - 来自aiprm社区的两千多个ChatGPT提示，使用GPT3.5的API完成的中文翻译
 * [botpress](https://github.com/botpress/botpress) - 构建和部署GPT/LLM代理的开源中心 ⚡️
 * [promptflow](https://github.com/microsoft/promptflow) - 构建高质量的LLM应用程序-从原型设计、测试到生产部署和监控。
 * [generative-ai-for-beginners](https://github.com/microsoft/generative-ai-for-beginners) - 12个课程，开始使用生成式人工智能构建  🔗 https://microsoft.github.io/generative-ai-for-beginners/
 * [tree-of-thoughts](https://github.com/kyegomez/tree-of-thoughts) - 插入并播放思维树的实现：通过大型语言模型进行有意识的问题解决，将模型推理提升至至少70%。
 * [Learn_Prompting](https://github.com/trigaten/learn_prompting) - Prompt Engineering，生成式人工智能和LLM指南由Learn Prompting提供 | 加入我们的Discord，成为最大的Prompt Engineering学习社区的一员。
 * [DecryptPrompt](https://github.com/dsxiangli/decryptprompt) - 总结Prompt&LLM论文，开源数据&模型，AIGC应用
 * [magentic](https://github.com/jackmpcollins/magentic) - 无缝地将LLMs集成为Python函数
 * [chatgpt_system_prompt](https://github.com/louisshark/chatgpt_system_prompt) - 存储所有代理人的系统提示
 * [LangGPT](https://github.com/embraceagi/langgpt) - LangGPT：让每个人都成为提示专家！🚀 结构化提示词，GPT的语言，结构化提示
 * [chatgpt-prompts-for-academic-writing](https://github.com/ahmetbersoz/chatgpt-prompts-for-academic-writing) - 这个写作提示列表涵盖了各种主题和任务，包括头脑风暴研究想法，改善语言和风格，进行文献综述，以及制定研究计划。
 * [self-refine](https://github.com/madaan/self-refine) - LLMs可以对他们的工作产生反馈，利用它来改进输出，并反复进行这个过程。
 * [GPTs](https://github.com/linexjlin/gpts) - 泄露的GPT提示
 * [multimodal-maestro](https://github.com/roboflow/multimodal-maestro) - 对于大型多模型模型（如GPT-4 Vision，LLaVA或CogVLM）的有效提示。🔥输出：有效提示适用于大型多模型模型，如GPT-4 Vision，LLaVA或CogVLM。🔥
 * [promptbench](https://github.com/microsoft/promptbench) - 大型语言模型的统一评估框架
 * [Transformers-for-NLP-2nd-Edition](https://github.com/denis2054/transformers-for-nlp-2nd-edition) - 从BERT到GPT-4的Transformer模型，从Hugging Face到OpenAI的环境。微调、训练和提示工程示例。附加部分包括ChatGPT、GPT-3.5-turbo、GPT-4和DALL-E，包括启动GPT-4、语音转文本、文本转语音、使用DALL-E生成图像的文本等。Google Cloud AI、HuggingGPT等等。
 * [llm-guard](https://github.com/laiyer-ai/llm-guard) - LLM互动安全工具包
 * [Prompt4ReasoningPapers](https://github.com/zjunlp/prompt4reasoningpapers) - ACL2023论文《使用语言模型提示进行推理：一项调查》的存储库。
 * [knowledge](https://github.com/knowledgecanvas/knowledge) - 知识是一个用于保存、搜索、访问、探索和与您所有喜爱的网站、文档和文件聊天的工具。
 * [promptfoo](https://github.com/promptfoo/promptfoo) - 测试您的提示、模型和RAGs。评估和比较LLM的输出，捕捉回归，并提高提示质量。LLM评估适用于OpenAI/Azure GPT、Anthropic Claude、VertexAI Gemini、Ollama，以及像Mistral/Mixtral/Llama这样的本地和私有模型，配备CI/CD。
 * [swarms](https://github.com/kyegomez/swarms) - 构建、部署和扩展可靠的自主代理群，用于工作流自动化。加入我们的社区：https://discord.gg/DbjBMJTSWD
 * [gptstore-prompts](https://github.com/1003715231/gptstore-prompts) - 这里是GPTStore上的前100个提示，我们可以用来学习和改进提示工程。
 * [aigc](https://github.com/phodal/aigc) - 《构筑大语言模型应用：应用开发与架构设计》是一本关于LLM在真实世界应用的开源电子书，介绍了大语言模型的基础知识和应用，以及如何构建自己的模型。其中包括Prompt的编写、开发和管理，探索最好的大语言模型能带来什么，以及LLM应用开发的模式和架构设计。
 * [lingoose](https://github.com/henomis/lingoose) - 🪿 LinGoose 是一个使用管道开发基于LLMs的应用程序的Go框架
 * [llm-guard](https://github.com/protectai/llm-guard) - LLM互动安全工具包
 * [ChatGPT-Prompts](https://github.com/yokoffing/chatgpt-prompts) - ChatGPT和Bing AI提示策划输出：
 * [Safety-Prompts](https://github.com/thu-coai/safety-prompts) - 用于评估和提升LLM安全性的中文安全提示。
 * [ChatGPT-Academic-Prompt](https://github.com/xuhangc/chatgpt-academic-prompt) - 使用ChatGPT进行学术写作
 * [Instructgpt-prompts](https://github.com/kevinamiri/instructgpt-prompts) - 一系列用于生成和分类文本的ChatGPT和GPT-3.5基于指令的提示集合。
 * [EdgeChains](https://github.com/arakoodev/edgechains) - EdgeChains.js 是一种基于 Typescript/Javascript 的生产友好的生成式人工智能。基于 Jsonnet 开发。可以在支持 Webassembly 的任何地方运行。支持声明式实时提示和“配置中的外部代码”。兼容 Kubernetes 和边缘环境。与 OpenAI GPT、Gemini、Llama2 等兼容。
 * [prompt-tutorial](https://github.com/pandabearlab/prompt-tutorial) - 聊天GPT、提示、LLM
 * [chatdev](https://github.com/10cl/chatdev) - ChatDev IDE 是一个用于构建您的 AI 代理的工具，无论是游戏中的 NPC 还是强大的代理工具，您都可以在这个平台上设计您想要的内容。
 * [contoso-chat](https://github.com/azure-samples/contoso-chat) - 这个样本包含了使用Prompt Flow和AI Studio创建RAG应用程序的完整End2End流程。它包括GPT 3.5 Turbo LLM应用程序代码、评估、使用AZD CLI进行部署自动化、GitHub操作进行评估和部署以及意图管理。
 * [LangGPT](https://github.com/langgptai/langgpt) - LangGPT：让每个人都成为提示专家！🚀 结构化提示词，GPT语言，结构化Prompt
 * [AISuperDomain](https://github.com/win4r/aisuperdomain) - Aila(AI超元域): 适用于Windows、macOS和Android的首选AI集成工具。只需询问一次，即可从ChatGPT、Gemini、Claude3、Copilot、Poe、perplexity等10多个AI中获取答案。具有可定制的AI和提示功能。
 * [code2prompt](https://github.com/mufeedvh/code2prompt) - 一个CLI工具，可以将您的代码库转换为一个带有源树、提示模板和令牌计数的单个LLM提示。
 * [LLM-Prompt-Library](https://github.com/abilzerian/llm-prompt-library) - 适用于GPT-4、Claude、Llama3、Gemini等高性能开源LLM的高级代码和文本操作提示。
 * [zzz-api](https://github.com/xing61/zzz-api) - 优质稳定的OpenAI的API接口-For企业和开发者。OpenAI的api代理，支持ChatGPT的API调用，支持openai的API接口，支持：gpt-4，gpt-3.5。不需要openai Key, 不需要购买openai的账号，不需要美元的银行卡，通通不用的，直接调用就行，稳定好用！！智增增
 * [EasyInstruct](https://github.com/zjunlp/easyinstruct) - [ACL 2024] 一种用于LLMs的易于使用的指令处理框架。
 * [FinRobot](https://github.com/ai4finance-foundation/finrobot) - FinRobot：一个使用LLMs的金融应用程序的开源AI代理平台 🚀 🚀 🚀
 * [wonderful-prompts](https://github.com/langgptai/wonderful-prompts) - 🔥精选中文提示🔥，ChatGPT 使用指南，提升 ChatGPT 的趣味性和易用性！🚀
 * [jailbreak_llms](https://github.com/verazuo/jailbreak_llms) - [CCS'24] 一个数据集包含来自Reddit、Discord、网站和开源数据集的15,140个ChatGPT提示（包括1,405个越狱提示）。
 * [step_into_llm](https://github.com/mindspore-courses/step_into_llm) - MindSpore在线课程：踏入LLM
 * [promptulate](https://github.com/undertone0809/promptulate) - 🚀大型语言模型自动化和自主语言代理开发框架。以Python方式构建您的LLM代理应用程序！
 * [EDDI](https://github.com/labsai/eddi) - 用于对话AI API的提示和对话管理中间件，例如OpenAI ChatGPT，Facebook Hugging Face，Anthropic Claude，Google Gemini和Ollama。 精简，轻量级，可扩展，云原生。 使用Java开发，由Quarkus提供支持。
 * [AIGC_Interview](https://github.com/embraceagi/aigc_interview) - 📚 AIGC 求职面经、必备基础知识、提示词工程、ChatGPT、Stable Diffusion、Prompt、Embedding、Fintune 等 AIGC 求职你所需要知道的一切~
 * [npi](https://github.com/npi-ai/npi) - AI代理工具使用API平台
 * [keras-llm-robot](https://github.com/smalltong02/keras-llm-robot) - 一个网络UI项目，旨在学习大型语言模型。该项目包括聊天、量化、微调、提示工程模板和多模态等功能。
 * [ComfyUI-N-Nodes](https://github.com/nuked88/comfyui-n-nodes) - 一个适用于ConfyUI的自定义节点套件，包括GPT文本提示生成、LoadVideo、SaveVideo、LoadFramesFromFolder和FrameInterpolator。
 * [PromptChains](https://github.com/miatechpartners/promptchains) - 为了更好的表现，为ChatGPT和Claude排队提示。
 * [aide](https://github.com/nicepkg/aide) - 在 VSCode 中征服任何代码：一键注释、转换、UI 图生成代码、AI 批量处理文件！💪
 * [comfyui_LLM_party](https://github.com/heshengtao/comfyui_llm_party) - Dify在ComfyUI中包括Omost、GPT-sovits、ChatTTS和FLUX提示节点，可以访问飞书、discord，并适配所有具有类似openai/gemini接口的llms，如o1、ollama、qwen、GLM、deepseek、moonshot、doubao。适配本地llms，如llama/P。
 * [ChatGPT-OpenAI-Smart-Speaker](https://github.com/olney1/chatgpt-openai-smart-speaker) - 这款AI智能音箱使用语音识别和文本转语音技术，可以实现与OpenAI和代理人的语音驱动对话和视觉功能。用户将提示说入麦克风，程序将提示发送给OpenAI生成一个回答。
 * [AI-Bootcamp](https://github.com/curiousily/ai-bootcamp) - 自主学习的生成式人工智能训练营。关于机器学习基础知识、LLMs、RAGs、LangChain、LangGraph、Fine-tuning Llama 3和AI代理（CrewAI）的教程。
 * [chatgpt-lite](https://github.com/blrchen/chatgpt-lite) - 快速的ChatGPT用户界面，支持OpenAI和Azure OpenAI。
 * [Long-Novel-GPT](https://github.com/maoxiaoyuz/long-novel-gpt) - 该项目包括一个基于 GPT 等大语言模型的长篇小说生成器，同时还有各类小说生成 Prompt 以及教程。我们欢迎社区贡献，持续更新以提供最佳的小说创作体验。
 * [langfuse](https://github.com/langfuse/langfuse) - 🪢 开源LLM工程平台：LLM可观测性，指标，评估，提示管理，游乐场，数据集。与LlamaIndex，Langchain，OpenAI SDK，LiteLLM等集成。🍊YC W23
 * [gateway](https://github.com/portkey-ai/gateway) - 一个拥有集成护栏的高速AI网关。通往200多个LLMs，50多个AI护栏，配有1个快速友好的API。
 * [ai-notes](https://github.com/swyxio/ai-notes) - 软件工程师快速了解新人工智能发展的笔记。 用作https://latent.space写作和产品头脑风暴的数据存储，但在/Resources文件夹下清理了规范参考资料。
 * [helicone](https://github.com/helicone/helicone) - 🧊 面向开发人员的开源LLM-可观测性平台。一键集成监控、指标、评估、代理追踪、提示管理、沙盒等功能。支持OpenAI SDK、Vercel AI SDK、Anthropic SDK、LiteLLM、LLamaIndex、LangChain等。🍓
 * [optillm](https://github.com/codelion/optillm) - 为LLMs优化推理代理
 * [lunary](https://github.com/lunary-ai/lunary) - LLM的生产工具包。可观察性，提示管理和评估。
 * [pezzo](https://github.com/pezzolabs/pezzo) - 🕹️ 开源、以开发者为先的LLMOps平台，旨在简化提示设计、版本管理、即时交付、协作、故障排除、可观察性等功能。
 * [archgw](https://github.com/katanemo/archgw) - Arch是代理的智能网关。 使用（快速）LLMs进行工程设计，用于安全处理，丰富的可观察性，并将提示与您的API无缝集成 - 所有这些都在业务逻辑之外。 由Envoy代理的核心贡献者在Envoy上构建。
 * [openlit](https://github.com/openlit/openlit) - AI工程的开源平台：OpenTelemetry原生LLM可观测性，GPU监控，防护栏，评估，提示管理，保险库，游乐场。🚀💻 与40多个LLM提供商，VectorDBs，代理框架和GPU集成。


## Chatbots

 * [gpt4all](https://github.com/nomic-ai/gpt4all) - gpt4all：一个聊天机器人，它经过大量干净的助手数据集训练，包括代码、故事和对话。
 * [Open-Assistant](https://github.com/laion-ai/open-assistant) - OpenAssistant是一种基于聊天的助手，它能够理解任务，与第三方系统进行交互，并动态检索信息以完成任务。
 * [FastChat](https://github.com/lm-sys/fastchat) - “Vicuna: 一款令人印象深刻的开放式聊天机器人 GPT-4 发布仓库”
 * [kubernetes-chatgpt-bot](https://github.com/robusta-dev/kubernetes-chatgpt-bot) - 一个用于Kubernetes问题的ChatGPT机器人。
 * [chatGPT-telegram-bot](https://github.com/altryne/chatgpt-telegram-bot) - 这是在Telegram机器人中让chatGPT工作的早期尝试。
 * [chatgpt_telegram_bot](https://github.com/karfly/chatgpt_telegram_bot) - 如何将ChatGPT与Telegram中的GPT-4集成://t.co/fyumptn5vj通过@hipertextual
 * [ChatRWKV](https://github.com/blinkdl/chatrwkv) - ChatRWKV类似于ChatGPT，但由RWKV（100％ RNN）语言模型驱动，并且是开源的。
 * [ChatGPT-at-Home](https://github.com/sentdex/chatgpt-at-home) - ChatGPT @ Home：大型语言模型（LLM）聊天机器人应用程序，由ChatGPT编写
 * [ChuanhuChatGPT](https://github.com/gaizhenbiao/chuanhuchatgpt) - ChatGPT API的图形用户界面
 * [GPT3Discord](https://github.com/kav-k/gpt3discord) - 一个强大的、全能的Discord GPT3界面。ChatGPT风格的对话、图像生成、AI-管理、自定义索引/知识库、YouTube摘要等等！
 * [chatgpt-on-wechat](https://github.com/zhayujie/chatgpt-on-wechat) - 基于ChatGPT的微信机器人，使用OpenAI API和itchat库。
 * [ChatGPT-in-Slack](https://github.com/seratch/chatgpt-in-slack) - 演示如何构建一个Slack应用程序，使最终用户可以与ChatGPT机器人进行交互的Swift。
 * [gpt-discord-bot](https://github.com/openai/gpt-discord-bot) - 使用Python编写的示例Discord机器人，使用完成API与“text-davinci-003”模型进行对话，并使用管理API过滤消息。
 * [chatgpt-slackbot](https://github.com/sifue/chatgpt-slackbot) - 用于在Slack上使用OpenAI的ChatGPT API的Slackbot脚本（前提是使用日语）
 * [chatGPT-discord-bot](https://github.com/zero6992/chatgpt-discord-bot) - 将ChatGPT集成到您自己的Discord机器人中。
 * [vrchatbot](https://github.com/geson-anko/vrchatbot) - 用于创建VRChat AI机器人的代码库
 * [Blender-GPT](https://github.com/tree-ind/blender-gpt) - 由GPT3/4和Whisper集成驱动的全能Blender助手
 * [dolly](https://github.com/databrickslabs/dolly) - Databricks的Dolly，是在Databricks机器学习平台上训练的大型语言模型。
 * [chatgpt-failures](https://github.com/giuven95/chatgpt-failures) - ChatGPT和类似模型的失败档案
 * [researchgpt](https://github.com/mukulpatnaik/researchgpt) - 一个基于开源LLM的研究助手，可以让你与研究论文进行对话。
 * [wikipedia-gpt3-bot](https://github.com/shbhrsaha/wikipedia-gpt3-bot) - 使用维基百科查询并用GPT-3总结答案的REPL机器人。
 * [chatgpt-tegram-bot](https://github.com/nukeador/chatgpt-tegram-bot) - 一个简单的Telegram机器人，可以与ChatGPT互动（支持语音笔记和生成图片）。
 * [ChatGeoPT](https://github.com/earth-genome/chatgeopt) - 一个非常基础、非常脆弱的概念证明，用于地理空间搜索的人工智能助手。
 * [ChatGPT-Trading-Bot-for-KuCoin](https://github.com/krecicki/chatgpt-trading-bot-for-kucoin) - 这是一个用于KuCoin的交易脚本，它根据市场数据和OpenAI的GPT-3.5语言模型生成的预测模型不断地下买单和卖单。
 * [vocode-python](https://github.com/vocodedev/vocode-python) - 🤖构建基于语音的LLM代理。模块化+开源。
 * [marvin](https://github.com/prefecthq/marvin) - 🤖🪄 一个包含电池的库，用于GPT驱动的机器人和人工智能功能。
 * [baize](https://github.com/project-baize/baize) - 让ChatGPT在几小时内用单个GPU教您自己的聊天机器人！
 * [baize-chatbot](https://github.com/project-baize/baize-chatbot) - 让ChatGPT在几小时内用单个GPU教您自己的聊天机器人！
 * [gpt4all-ui](https://github.com/nomic-ai/gpt4all-ui) - gpt4all聊天机器人界面
 * [yolopandas](https://github.com/ccurme/yolopandas) - 在聊天中使用pandas操作非常方便。我已经向销售运营团队请求了“将fy23 q2某某公司的某某产品的销售数据制成图表”，现在我们可以使用这个工具轻松地从chatgpt中获取数据。
 * [ChatDoctor](https://github.com/kent0n-li/chatdoctor) - 医疗专用AI聊天机器人“chatdoctor”似乎正在使用chatgpt进行模型训练，据说全代码、数据集和模型权重将很快开源！
 * [gpt4free](https://github.com/xtekky/gpt4free) - 分散化AI行业，通过多个反向工程API（poe.com、phind.com、chat.openai.com、phind.com、writesonic.com、sqlchat.ai、t3nsor.com、you.com等）免费提供GPT-4/3.5脚本。
 * [Auto-GPT-ZH](https://github.com/kaqijiang/auto-gpt-zh) - Auto-GPT中文版及爱好者组织同步更新原项目，AI领域创业，自媒体组织，利用AI工作、学习、创作并变现。
 * [voice-generator-webui](https://github.com/log1stics/voice-generator-webui) - 一个多说话人、多语言的语音生成工具
 * [autogpt-telegram-chatbot](https://github.com/steamship-packages/autogpt-telegram-chatbot) - 它来了！Autogpt适用于您的移动设备。通过Telegram与您自己的Autogpt版本进行通信。我们很自豪地开源这个项目。迫不及待地想看看我们将一起构建什么！
 * [pdfGPT](https://github.com/bhaskatripathi/pdfgpt) - PDF GPT可以利用GPT功能让您与PDF文件的内容进行聊天。这是将您的pdf文件转换为聊天机器人的唯一开源解决方案！
 * [Navi](https://github.com/ssgorg/navi) - 基于GPT的网络安全人工智能
 * [chatgpt-comparison-detection](https://github.com/hello-simpleai/chatgpt-comparison-detection) - 人类ChatGPT比较语料库（HC3），探测器等等！🔥
 * [hackGPT](https://github.com/nodatafound/hackgpt) - 我利用OpenAI和ChatGPT来做黑客式的事情。
 * [talk-to-chatgpt](https://github.com/c-nedelcu/talk-to-chatgpt) - 使用您的语音与ChatGPT AI交谈，并通过语音听取其答案。
 * [ChatGPT-Telegram-Workers](https://github.com/tbxark/chatgpt-telegram-workers) - 轻松在Cloudflare Workers上部署自己的Telegram ChatGPT机器人。
 * [reflexion-human-eval](https://github.com/noahshinn024/reflexion-human-eval) - 基于反射的GPT-4代理是代码生成领域的最先进技术，可以迭代地优化代码，将“准确性瓶颈”从正确的代码生成转移到正确的测试生成。人类评估准确性：反射式GPT-4为88％，GPT-4为67.0％，Codet为65.8％，Palm为26.2％。
 * [gptchat-telegram](https://github.com/m1guelpf/gptchat-telegram) - ✨厌倦了每次打开gptchat网站，所以我做了一个Telegram机器人。如果你也想要一个，我已经极大地简化了设置过程（你只需要运行一个命令！😯）。查看代码库👇。
 * [Twitter-Comment-Bot](https://github.com/sojinsamuel/twitter-comment-bot) - 一个能够评论包含指定关键词的推文的机器人。该机器人使用OpenAI API生成评论，并使用Twitter API发布评论。它被设计为连续运行，每个评论之间有固定的延迟。
 * [codemancer](https://github.com/0xmmo/codemancer) - 在命令行中使用AI编码助手。
 * [ChatGPT-CodeReview](https://github.com/anc95/chatgpt-codereview) - 🐥 由ChatGPT驱动的代码审查机器人
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt) - 让我们在使用ChatGPT过程中更高效、更顺畅，完美解决ChatGPT网络错误，不再频繁地刷新网页，足足省去10个多余的步骤。还可以取消后台监管审计。解决了这几类报错: (1) 当尝试获取资源时出现网络错误。 (2) 出现了一些问题。如果此问题仍然存在，请通过我们的帮助中心help.openai.com与我们联系。 (3) 此内容可能违反我们的内容政策。 (4) 未找到对话。
 * [chatgpt-wework-robot](https://github.com/sytpb/chatgpt-wework-robot) - 零代码、一键部署chatgpt到企业微信，无需VPN，速度快
 * [chatbot-ui](https://github.com/mckaywrigley/chatbot-ui) - 一个开源的ChatGPT用户界面。
 * [gpt4-pdf-chatbot-langchain](https://github.com/mayooear/gpt4-pdf-chatbot-langchain) - GPT4和LangChain聊天机器人用于大型PDF文档
 * [chat-with-gpt](https://github.com/cogentapps/chat-with-gpt) - 一个带有语音的开源ChatGPT应用程序
 * [whatsapp-chatgpt](https://github.com/askrella/whatsapp-chatgpt) - ChatGPT + DALL-E + WhatsApp = AI助手 :rocket: :robot:
 * [ChatGPT-wechat-bot](https://github.com/autumnwhj/chatgpt-wechat-bot) - ChatGPT 微信版 https://github.com/AutumnWhj/ChatGPT-wechat-bot
 * [chatbot-ui-pro](https://github.com/mckaywrigley/chatbot-ui-pro) - AI搜索和聊天，用于Balaji Srinivasan的“网络国家”。
 * [chatgpt-twitter-bot](https://github.com/transitive-bullshit/chatgpt-twitter-bot) - 由OpenAI的ChatGPT API驱动的Twitter机器人。它活着啦🤖
 * [BetterChatGPT](https://github.com/ztjhz/betterchatgpt) - 使用更好的ChatGPT聊天，更聪明地玩耍和聊天 - 一个令人惊叹的开源Web应用程序，具有更好的UI，可探索OpenAI的ChatGPT API！（网站+ Windows + MacOS + Linux）
 * [chatgpt-exporter](https://github.com/pionxzh/chatgpt-exporter) - 导出并分享您的ChatGPT聊天记录历史。
 * [unChatGPT](https://github.com/riccardolinares/unchatgpt) - unChatGPT使用OpenAI API创建类似聊天机器人的聊天体验。它类似于ChatGPT，但无需排队等待或受到限制。
 * [rubberduck-vscode](https://github.com/rubberduck-ai/rubberduck-vscode) - 使用官方OpenAI API在Visual Studio Code中使用AI驱动的代码编辑、解释、代码生成、错误诊断和聊天功能。
 * [teams-openai-bot](https://github.com/leeford/teams-openai-bot) - 示例团队OpenAI机器人
 * [speechgpt](https://github.com/hahahumble/speechgpt) - SpeechGPT是一个网络应用程序，可以让您与ChatGPT进行对话。
 * [langchainjs](https://github.com/hwchase17/langchainjs) - 我们已经在js中实现了autogpt，并配备了新的读写工具来写文件，这些文件可以由node.js中的本地文件系统以及其他所有js环境中的内存文件系统支持。我们将随着时间的推移不断发展这一点。示例在这里。
 * [chat-langchainjs](https://github.com/sullivan-sean/chat-langchainjs) - 使用TypeScript支持的方式复制ChatLangChain（类似于ChatGPT的机器人，只回答有关LangChain文档的问题），听说@swyx今天晚些时候将举行黑客马拉松。希望这可以作为那里一些项目的起点！
 * [friday-gpt](https://github.com/hmmhmmhm/friday-gpt) - 给A.I休息和恢复时间，以便进行编程工作。
 * [telegram-chatgpt-concierge-bot](https://github.com/rafalwilinski/telegram-chatgpt-concierge-bot) - 通过Telegram和语音与OpenAI的ChatGPT互动。
 * [chatgpt-telegram](https://github.com/m1guelpf/chatgpt-telegram) - 用一个命令运行您自己的GPTChat Telegram机器人！
 * [gitgpt](https://github.com/hesse/gitgpt) - 一个自然语言命令行git助手
 * [chatgpt-discord](https://github.com/m1guelpf/chatgpt-discord) - 只需一个命令，就可以运行您自己的GPTChat Discord机器人！
 * [larkgpt](https://github.com/bytemate/larkgpt) - 百灵聊天GPT机器人
 * [LocalAI](https://github.com/go-skynet/localai) - :robot: 自托管、社区驱动的简单本地 OpenAI 兼容 API，使用 go 编写。可用作 OpenAI 的替代品，运行在消费级硬件的 CPU 上。API 适用于 ggml 兼容模型，例如：llama.cpp、alpaca.cpp、gpt4all.cpp、vicuna、koala、gpt4all-j、cerebras。
 * [gpt_jailbreak_status](https://github.com/tg12/gpt_jailbreak_status) - 这是一个旨在提供关于OpenAI GPT语言模型越狱状态更新的存储库。
 * [chat-gpt](https://github.com/jcubic/chat-gpt) - ChatGPT 对话保存书签
 * [chatgpt-android](https://github.com/skydoves/chatgpt-android) - 📲 ChatGPT Android 展示了在 Android 上使用 Stream Chat SDK for Compose 的 OpenAI's ChatGPT。
 * [gpt-voice-chat](https://github.com/kmizu/gpt-voice-chat) - 与ChatGPT AI进行真实语音聊天
 * [chatgpt](https://github.com/jcrodriguez1989/chatgpt) - 从R到ChatGPT的接口
 * [ChatdollKit](https://github.com/uezo/chatdollkit) - ChatdollKit 可以让你将你的3D模型制作成聊天机器人。
 * [unity-voicevox-bridge](https://github.com/mikito/unity-voicevox-bridge) - 我已经制作了一个简单的库，可以从Unity中与Voicevox协作，轻松播放合成语音！适用于ChatGPT API等用途！
 * [gortanagtp](https://github.com/dasdata/gortanagtp) - 具有语音和文本交互的控制台应用程序，使用最新的ChatGPT API。
 * [HeyChatGPT](https://github.com/ynagatomo/heychatgpt) - 一个最简iOS应用程序，可以通过您的语音与ChatGPT互动。
 * [glowby](https://github.com/glowbom/glowby) - Glowby Basic帮助您创建自己的基于语音的AI助手。
 * [wechatbot](https://github.com/djun/wechatbot) - 将个人微信接入ChatGPT。
 * [Discord-Chatbot-Gpt4Free](https://github.com/mishalhossin/discord-chatbot-gpt4free) - 这是一个免费的Discord聊天机器人，具有图像检测功能。
 * [big-agi](https://github.com/enricoros/big-agi) - 💬 个人AI应用程序由GPT-4及更高版本提供支持，具有AI人格、AGI功能、文本转图像、语音、响应流、代码高亮和执行、PDF导入、开发人员预设等功能。部署和赠送#big-AGI-energy！使用Next.js、React、Joy。
 * [RasaGPT](https://github.com/paulpierre/rasagpt) - 💬 RasaGPT是基于Rasa和Langchain构建的第一个无头LLM聊天机器人平台。使用Rasa、FastAPI、Langchain、LlamaIndex、SQLModel、pgvector、ngrok和telegram构建。
 * [FigmaChain](https://github.com/cirediatpl/figmachain) - FigmaChain是一组基于Python脚本的工具，可以根据Figma设计生成HTML/CSS代码。利用OpenAI的GPT-3模型，FigmaChain使开发人员能够快速从Figma设计输入中生成HTML/CSS代码。它还包括一个基于Streamlit的聊天机器人界面，用于交互式代码生成。
 * [gpt4free-ts](https://github.com/xiangsx/gpt4free-ts) - 这是xtekky/gpt4free TypeScript版本的复制项目。
 * [slack-gpt](https://github.com/martinseanhunt/slack-gpt) - 一个简单的Slack应用/机器人启动器，使用Langchain、OpenAI和Pincone向量库获取问题的答案。
 * [LLM-As-Chatbot](https://github.com/deep-diver/llm-as-chatbot) - LLM作为聊天机器人服务
 * [pdf-chatbot](https://github.com/dissorial/pdf-chatbot) - 自我追踪数据分析：交互式可视化和预测算法
 * [ask_chatgpt](https://github.com/railsjazz/ask_chatgpt) - 在你的Rails控制台中使用AI助手Gem。在Rails中完全发挥ChatGPT的功能。
 * [ecoute](https://github.com/sevask/ecoute) - Ecoute是一款实时转录工具，可以为用户的麦克风输入（您）和扬声器输出（扬声器）提供实时转录，并在文本框中生成使用OpenAI的GPT-3.5的建议响应。它基于对话的实时转录为用户提供要说的建议。
 * [privateGPT](https://github.com/samuraigpt/privategpt) - 一款使用GPT强大功能与您的文档进行私密互动的应用程序，100%私密，无数据泄漏。
 * [LLaVA](https://github.com/haotian-liu/llava) - 面向多模态GPT-4级能力构建的大型语言与视觉助手。
 * [OpenChat](https://github.com/openchatai/openchat) - 使用OpenChat运行和创建自定义的ChatGPT样式的机器人，在任何地方嵌入和分享这些机器人，这是一个开源的聊天机器人控制台。
 * [st-chat](https://github.com/ai-yash/st-chat) - Streamlit组件，用于聊天机器人用户界面
 * [summary-gpt-bot](https://github.com/tpai/summary-gpt-bot) - 一款由人工智能驱动的Telegram文本摘要机器人，可以生成文本、URL和YouTube视频的简洁摘要。
 * [Bard-API](https://github.com/dsdanielpark/bard-api) - 这是一个非官方的Python包，通过cookie值返回Google Bard的响应。
 * [dialoqbase](https://github.com/n4ze3m/dialoqbase) - 轻松创建聊天机器人
 * [Video-ChatGPT](https://github.com/mbzuai-oryx/video-chatgpt) - 视频聊天GPT是一种视频对话模型，能够生成有关视频的有意义的对话。它结合了LLMs的能力和预训练的视觉编码器，适用于时空视频表示。
 * [LLaVA-Med](https://github.com/microsoft/llava-med) - 面向生物医学的大型语言与视觉助手，具备多模态GPT-4级别的能力。
 * [ethgpt](https://github.com/jiayaoqijia/ethgpt) - 以太坊代码库和文档的聊天机器人。
 * [telegram-chatgpt-bot](https://github.com/sabber-slt/telegram-chatgpt-bot) - 基于NodeJS的ChatGPT机器人现在在Telegram上拥有高级功能，如语音聊天和图像生成。
 * [chatgpt-telegram-bot](https://github.com/n3d1117/chatgpt-telegram-bot) - 🤖 一个使用Python编写的Telegram机器人，集成了OpenAI官方的ChatGPT API，可以提供答案。
 * [ai-chatbot](https://github.com/vercel-labs/ai-chatbot) - 由Vercel Labs构建的全功能、可黑客的Next.js AI聊天机器人
 * [autoclear-chatgpt-history](https://github.com/adamlui/autoclear-chatgpt-history) - 🕶️ 为ChatGPT添加聊天自动清除功能，提供更多隐私保护。
 * [chatgpt-widescreen](https://github.com/adamlui/chatgpt-widescreen) - 🖥️ 为ChatGPT添加宽屏和全屏模式，以提供更好的观看体验。
 * [chatgpt-infinity](https://github.com/adamlui/chatgpt-infinity) - ∞ 从全知的ChatGPT（以任何语言）生成无尽的答案！
 * [chatgpt-auto-refresh](https://github.com/adamlui/chatgpt-auto-refresh) - ↻ 保持ChatGPT会话的新鲜度以避免网络错误+ Cloudflare检查
 * [chatgpt-apps](https://github.com/adamlui/chatgpt-apps) - 🤖 利用ChatGPT的惊人能力或增强其用户体验的应用程序
 * [embedchain](https://github.com/embedchain/embedchain) - 使用框架轻松创建基于任何数据集的LLM强化机器人。
 * [paper-summarizer](https://github.com/discus0434/paper-summarizer) - 一个由OpenAI LLMs驱动的用于总结arXiv论文的Slack机器人。
 * [vercel-ai-chatbot](https://github.com/supabase-community/vercel-ai-chatbot) - 一个由Vercel Labs和Supabase构建的功能齐全的、Supabaseified的Next.js AI聊天机器人。
 * [llm-inference](https://github.com/aniketmaurya/llm-inference) - 大型语言模型（LLM）推理API和聊天机器人
 * [GPT4Tools](https://github.com/stevengrove/gpt4tools) - GPT4Tools是一个智能系统，可以自动决定、控制和利用不同的视觉基础模型，允许用户在对话过程中与图像进行交互。
 * [Ultimate-ChatGPT](https://github.com/imabutahersiddik/ultimate-chatgpt) - 终极ChatGPT是一个由人工智能驱动的虚拟助手，旨在提供卓越的写作和问题解决体验。
 * [wechat-gptbot](https://github.com/iuiaoin/wechat-gptbot) - 一个基于ChatGPT的微信机器人，没有风险，非常稳定！🚀
 * [FeishuBot](https://github.com/rawchen/feishubot) - 飞书群聊/私聊ChatGPT机器人
 * [gradio-chatbot](https://github.com/weaigc/gradio-chatbot) - 一个可以自动将🤗 Huggingface Spaces、魔搭创空间和Gradio ChatBot转换为免费API的工具。支持GPT4Free、ChatGPT、Llama2、MPT、Falcon Chat、ChatGLM、通义千问和许多其他类似聊天机器人的空间。
 * [ChatGpt-Web](https://github.com/79e/chatgpt-web) - 使用React构建的一款商业可行的ChatGpt Web应用。
 * [word-GPT-Plus](https://github.com/kuingsmile/word-gpt-plus) - Word GPT Plus是一个将chatGPT模型集成到Microsoft Word中的Word插件。它支持官方和Web API。
 * [chat-with-your-doc](https://github.com/linjungz/chat-with-your-doc) - 使用LangChain和GPT4/ChatGPT从Azure OpenAI服务和OpenAI中的PDF/PPTX/DOCX格式的文档中进行聊天。
 * [OpenAi-ChatGPT-Bot](https://github.com/darkmakerofc/openai-chatgpt-bot) - 由DarkMakerofc（Nima先生）和团队开发的Open Ai ChatGPT机器人，您可以在Whatsapp上体验ChatGPT。
 * [opening-up-chatgpt.github.io](https://github.com/opening-up-chatgpt/opening-up-chatgpt.github.io) - Liesenfeld, Andreas, Alianda Lopez和Mark Dingemanse。2023年。“开放ChatGPT：追踪指导调整文本生成器的开放性、透明度和问责制。”在第五届国际会议上的对话用户界面。埃因霍温。doi:10.1145/3571884.3604316。
 * [ChatDrug](https://github.com/chao1224/chatdrug) - ChatGPT用于药物发现
 * [aks-openai-terraform](https://github.com/azure-samples/aks-openai-terraform) - 本文介绍了如何通过Terraform部署Azure Kubernetes Service（AKS）集群和Azure OpenAI服务，以及如何部署一个Terraform聊天机器人，该机器人使用Azure AD工作负载身份验证Azure OpenAI，并调用ChatGPT模型的Chat Completion API。
 * [Robot-GPT](https://github.com/nonejou072/robot-gpt) - 基于ROS2和ChatGPT的仿真框架，用于大型模型时代的机器人交互任务。
 * [chatgpt-finetune-ui](https://github.com/anchen1011/chatgpt-finetune-ui) - 简单的Python WebUI用于微调ChatGPT（gpt-3.5-turbo）
 * [poe-api-wrapper](https://github.com/snowby666/poe-api-wrapper) - 👾 一个使用Httpx的Poe.com的Python API封装器。通过使用它，您将可以免费访问ChatGPT、Claude、Llama、Google-PaLM等等！🚀
 * [llama-gpt](https://github.com/getumbrel/llama-gpt) - 一个自托管的、离线的、类似ChatGPT的聊天机器人。由Llama 2提供支持。100%私密，没有数据离开您的设备。新增功能：支持Code Llama！
 * [rotary-gpt](https://github.com/tcz/rotary-gpt) - 我把我的旧转盘电话改装成了一个基于ChatGPT的家庭助手，现在你也可以这样做。
 * [rusty_llama](https://github.com/moonkraken/rusty_llama) - 一个简单的ChatGPT克隆版本，使用Rust语言编写的前后端。使用开源语言模型和TailwindCSS。
 * [GPT_CodeInterpreter](https://github.com/boyueluzhipeng/gpt_codeinterpreter) - 终极免费的OpenAI提供者，采用Python代码解释器和其他多种功能，由ChatGPT和GPT-4驱动！
 * [WebAI-to-API](https://github.com/amm1rr/webai-to-api) - ChatGPT，克劳德，巴德到API：）
 * [chatgpt-minimal](https://github.com/blrchen/chatgpt-minimal) - 一个使用Next.js和OpenAI Streaming API构建的轻量级ChatGPT聊天机器人。
 * [open_source_chatgpt_list](https://github.com/sunlemuria/open_source_chatgpt_list) - 开放努力实施类似ChatGPT的模型及更多。
 * [chatgpt-dingtalk-robot](https://github.com/sytpb/chatgpt-dingtalk-robot) - 零代码、一键部署chatgpt到钉钉，无须VPN
 * [chatterstack](https://github.com/dschil138/chatterstack) - 轻松管理ChatGPT对话变量
 * [PokerGPT](https://github.com/matteo-psnt/pokergpt) - PokerGPT是一个Poker Discord机器人，可以让你与ChatGPT-4一起玩德州扑克。
 * [kitt](https://github.com/livekit-examples/kitt) - 使用LiveKit实时与ChatGPT进行对话
 * [compose-chatgpt-kotlin-android-chatbot](https://github.com/lambiengcode/compose-chatgpt-kotlin-android-chatbot) - :lion:使用Kotlin + Jetpack Compose + Coroutine + MVVM + Retrofit2 + OpenAI的GPT-3 API，编写Android聊天机器人。允许从ChatGPT API获取流式响应。🤖
 * [Chino-chan-Bot](https://github.com/misonomikadev/chino-chan-bot) - Bot Messenger 集成了 ChatGPT。Bot Messenger 集成了 ChatGPT。
 * [Chatbase](https://github.com/anil-matcha/chatbase) - 适用于每个网站的ChatGPT。使用根据您的网站内容训练的个性化聊天机器人即时回答访客的问题。是Chatbase、SiteGPT和Dante AI的替代选择。
 * [plotai](https://github.com/mljar/plotai) - PlotAI - 你的终极绘图助手！📊🤖 使用ChatGPT-3.5在Python和Matplotlib中直接创建绘图，无论是在Python脚本还是笔记本中。
 * [TianMu](https://github.com/openjarvisai/tianmu) - 天幕：一个现代化的AI工具，支持多平台、支持markdown、多模态、连续对话和可定制的命令。一个开源的大模型客户端！
 * [youtube-summarizer](https://github.com/sabber-slt/youtube-summarizer) - Telegram机器人使用ChatGPT来总结YouTube视频内容。
 * [ChatGPT-Nuxt](https://github.com/hylarucoder/chatgpt-nuxt) - ChatGPT Web Nuxt 3 Vue 3 版本ChatGPT Web Nuxt 3 Vue 3 版本
 * [FirewaLLM](https://github.com/ysy1216/firewallm) - 通过调用FirewaLLM，用户可以在与大型模型交互时确保准确性，同时大大降低隐私泄露的风险。我们相信FirewallLLM是一个保护隐私的ChatGPT交互平台。
 * [Langchain-Chatchat](https://github.com/chatchat-space/langchain-chatchat) - Langchain-Chatchat（原Langchain-ChatGLM）是一款基于Langchain和ChatGLM等语言模型的本地知识库问答应用程序。
 * [wukong-robot](https://github.com/wzpan/wukong-robot) - 🤖 wukong-robot 是一个简单、灵活、优雅的中文语音对话机器人/智能音箱项目，支持ChatGPT多轮对话能力，还可能是首个支持脑机交互的开源智能音箱项目。
 * [autogen](https://github.com/microsoft/autogen) - 启用下一代大型语言模型应用。加入我们的Discord：https://discord.gg/pAbnFJrkgZ
 * [GPTDiscord](https://github.com/kav-k/gptdiscord) - 一个强大的、一体化的Discord GPT界面。ChatGPT风格的对话、图像生成、AI-审查、自定义索引/知识库、YouTube摘要生成等等！
 * [BotSharp](https://github.com/scisharp/botsharp) - AI代理应用程序框架在.NET中
 * [anything-llm](https://github.com/mintplex-labs/anything-llm) - 开源的ChatGPT等效体验，适用于开源和闭源的LLMs、嵌入器和向量数据库。支持无限的文档、线程和并发用户，并在非常清晰的用户界面中进行管理。
 * [magic](https://github.com/polterguy/magic) - 创建一个基于ChatGPT的定制网站聊天机器人
 * [rags](https://github.com/run-llama/rags) - 使用您的数据构建ChatGPT，全部使用自然语言。
 * [LLamaSharp](https://github.com/scisharp/llamasharp) - 在C#中轻松快速地运行LLaMA/GPT模型！🤗 同时，将LLamaSharp与语义内核、Unity、WPF和WebApp集成也很容易。
 * [Open-Custom-GPT](https://github.com/samuraigpt/open-custom-gpt) - 使用助手API创建自定义GPT并将其添加/嵌入到您的网站上创建自定义GPT并使用助手API将其添加/嵌入到您的网站上。
 * [wechat-ai-summarize-bot](https://github.com/aoao-eth/wechat-ai-summarize-bot) - 微信群聊总结助手 JS 版
 * [webwhiz](https://github.com/webwhiz-ai/webwhiz) - WebWhiz允许您创建一个人工智能聊天机器人，它了解您产品的一切，并能即时回答客户的问题。
 * [deep-chat](https://github.com/ovidijusparsiunas/deep-chat) - 全面可定制的AI聊天机器人组件，适用于您的网站
 * [WeChatFerry](https://github.com/lich0821/wechatferry) - 微信逆向，微信机器人，可接入ChatGPT、ChatGLM、讯飞星火、Tigerbot等大模型。Hook微信。
 * [mPLUG-Owl](https://github.com/x-plug/mplug-owl) - 【官方实施】mPLUG-Owl和mPLUG-Owl2：阿里巴巴MLLM家族。
 * [AstrBot](https://github.com/soulter/astrbot) - ⭐ 可用于 QQ 和 QQ 频道的 ChatGPT、Bing、Claude、HuggingChat 机器人，支持插件 | 原 QQChannelChatGPT
 * [casibase](https://github.com/casibase/casibase) - ⚡️开源的类LangChain AI知识数据库，具有Web界面和企业SSO⚡️，支持OpenAI、Azure、HuggingFace、OpenRouter、ChatGLM和本地模型，聊天演示：https://ai.casbin.com，管理员门户演示：https://ai.casibase.com
 * [ai-chatbot](https://github.com/vercel/ai-chatbot) - 一个由Vercel构建的功能齐全、可修改的Next.js AI聊天机器人。
 * [ChatPDF](https://github.com/anil-matcha/chatpdf) - 与任何PDF进行聊天。轻松上传您想要与之聊天的PDF文档。即时回答。使用人工智能提问、提取信息和总结文档。包含来源。
 * [OpenAssistantGPT](https://github.com/marcolivierbouch/openassistantgpt) - 一个使用OpenAI API助手构建聊天机器人的开源平台。
 * [ai-research-assistant](https://github.com/lifan0127/ai-research-assistant) - Aria是由GPT大型语言模型驱动的AI研究助手。
 * [aidea](https://github.com/mylxsw/aidea) - AIdea 是一款支持 GPT 和国产大语言模型通义千问、文心一言等，支持 Stable Diffusion 文生图、图生图、 SDXL1.0、超分辨率、图片上色的全能型 APP。
 * [ChatGPT-weBot](https://github.com/snapdragonlee/chatgpt-webot) - 使用ChatGPT（gpt-3.5或更新版本）进行聊天，基于微信钩子接口。
 * [vbot](https://github.com/hanson/vbot) - 微信，企微，机器人，企业微信，企微机器人，微信机器人，聚合聊天，RPA，协议，hook，逆向，worktool，ntwork，群发，自动回复，chatgpt，API对接，稳定防封全语言通用，企业定制/SCRM/SAAS专用
 * [org-ai](https://github.com/rksm/org-ai) - Emacs作为您的个人AI助手。使用像ChatGPT或LLaMA这样的LLM进行文本生成，或使用DALL-E和Stable Diffusion进行图像生成。还支持语音输入/输出。
 * [Linly](https://github.com/cvi-szu/linly) - Chinese-LLaMA 1&2、Chinese-Falcon 基础模型；ChatFlow中文对话模型；中文OpenLLaMA模型；NLP预训练/指令微调数据集
 * [gpt-ai-assistant](https://github.com/memochou1993/gpt-ai-assistant) - OpenAI + LINE + Vercel = GPT AI助手
 * [TS-GPT](https://github.com/dulaiduwang003/ts-gpt) - 基于SpringCloudAlibaba开发的双端GPT应用，包括语音对话、绘画、图像识别和文本对话。
 * [ChatGPT-YourChatRobot](https://github.com/ashinnotfound/chatgpt-yourchatrobot) - ❤开箱即用❤一个非官方的ChatGPT在QQ/微信中的实现。快来将你的QQ或微信变成ChatGPT吧！
 * [wechat-bot](https://github.com/wangrongding/wechat-bot) - 🤖一个基于OpenAi ChatGPT + WeChaty 实现的微信机器人，可以用来帮助你自动回复微信消息，或者管理微信群/好友，检测僵尸粉等...
 * [ChatFred](https://github.com/chrislemke/chatfred) - 使用ChatGPT、DALL·E 2和其他模型的Alfred工作流，用于聊天、图像生成等功能。输出：使用ChatGPT、DALL·E 2和其他模型的Alfred工作流，可用于聊天、图像生成等功能。
 * [catai](https://github.com/withcatai/catai) - 🦙模型的用户界面。本地运行AI助手✨
 * [ChatGPT-Telegram-Bot](https://github.com/yym68686/chatgpt-telegram-bot) - 🤖️ 一个AI聊天Telegram机器人可以使用Python在Zeabur、fly.io和Replit上通过GPT和Claude2.1进行网络搜索。
 * [bidara](https://github.com/nasa-petal/bidara) - BIDARA是一个GPT-4聊天机器人，被指示帮助科学家和工程师理解、学习并模仿生物利用仿生学研究所的逐步设计过程来创造可持续设计和技术的策略。
 * [sagittarius](https://github.com/gregsadetsky/sagittarius) - 一个GPT-4/Gemini语音/视频探索工具
 * [Chat-with-Github-Repo](https://github.com/peterw/chat-with-github-repo) - 这个仓库包含两个Python脚本，演示了如何使用Streamlit、OpenAI GPT-3.5-turbo和Activeloop的Deep Lake创建一个聊天机器人。
 * [pandas-ai](https://github.com/gventuri/pandas-ai) - 使用您的数据进行聊天（SQL、CSV、pandas、polars、noSQL等）。PandasAI利用LLMs（GPT 3.5 / 4、Anthropic、VertexAI）和RAG使数据分析变得对话化。
 * [chatgpt-mirai-qq-bot](https://github.com/lss233/chatgpt-mirai-qq-bot) - 🚀 一键部署！真正的 AI 聊天机器人！支持ChatGPT、文心一言、讯飞星火、Bing、Bard、ChatGLM、POE，多账号，人设调教，虚拟女仆、图片渲染、语音发送 | 支持 QQ、Telegram、Discord、微信 等平台
 * [quivr](https://github.com/quivrhq/quivr) - 您的GenAI第二大脑🧠 个人生产力助手（RAG）⚡️🤖 通过Langchain、GPT 3.5 / 4 turbo、Private、Anthropic、VertexAI、Ollama、LLMs与您的文档（PDF、CSV等）和应用进行交流，您可以与用户共享！这是OpenAI GPTs和ChatGPT的本地和私密替代方案，由检索增强生成技术驱动。
 * [smalltalk](https://github.com/tinystruct/smalltalk) - 一个基于tinystruct的聊天模块，与@OpenAI GPT-3 / 3.5-turbo / ChatGPT集成。@tinystruct
 * [maid](https://github.com/mobile-artificial-intelligence/maid) - Maid是一个跨平台的Flutter应用程序，用于本地与GGUF / llama.cpp模型进行交互，并与Ollama和OpenAI模型进行远程交互。
 * [pandas-ai](https://github.com/sinaptik-ai/pandas-ai) - 使用您的数据进行聊天（SQL、CSV、pandas、polars、noSQL等）。PandasAI利用LLMs（GPT 3.5 / 4、Anthropic、VertexAI）和RAG使数据分析变得对话化。
 * [WeChatRobot](https://github.com/lich0821/wechatrobot) - 微信机器人，接入Google Bard、ChatGPT、ChatGLM、讯飞星火、Tigerbot；成语接龙、天气预报、新闻摘要。
 * [chatgptassistantautoblogger](https://github.com/incomestreamsurfer/chatgptassistantautoblogger) - 这个自动博客使用GPT助手的API在电子商务网站上自动博客
 * [chaty](https://github.com/cosin2077/chaty) - 一行代码，满足你所有的ChatGPT想象✨✨✨
 * [wechat-assistant-pro](https://github.com/leochen-g/wechat-assistant-pro) - 智能微秘书，一个全能的微信机器人管理平台，最简单的方式接入 ChatGPT，FastGPT，Dify知识库，支持绘图，联网查询，语音识别，各种定时任务，支持企微、个微、公众号、5G 消息、WhatsApp。
 * [ChatGPT-Telegram-Bot](https://github.com/v-know/chatgpt-telegram-bot) - 一个具有流畅人工智能体验的Telegram机器人。
 * [nlux](https://github.com/nluxai/nlux) - 用于构建对话人工智能界面的开源React / Javascript库
 * [ChatGPT-Line-Bot](https://github.com/theexplainthis/chatgpt-line-bot) - 这是一个允许您将ChatGPT集成到Line中的存储库。
 * [langup-ai](https://github.com/jiran214/langup-ai) - AGI社交网络机器人。BiliBili | 直播聊天数字人 | 视频@自动回复 | 私信机器人 | 终端聊天 | 语音交互
 * [customizable-gpt-chatbot](https://github.com/shamspias/customizable-gpt-chatbot) - 使用Django REST框架构建的动态、可扩展的AI聊天机器人，支持从PDF、文档、网站和YouTube视频进行定制培训。利用OpenAI的GPT-3.5、Pinecone、FAISS和Celery实现无缝集成和高性能。
 * [DarkGPT](https://github.com/luijait/darkgpt) - DarkGPT是一个基于GPT-4-200K（推荐使用）的OSINT助手，旨在对泄露的数据库进行查询，从而提供一个人工智能助手，可以在您传统的OSINT流程中发挥作用。
 * [Kuebiko](https://github.com/adi-panda/kuebiko) - 一个使用GPT-3和Google Cloud TTS的AI Twitch TTS聊天机器人
 * [AI-Catalog](https://github.com/mehmetkahya0/ai-catalog) - 庞大的人工智能模型目录。一个精心筛选的人工智能工具、平台和资源列表，涵盖各个领域。
 * [Multi-Modality-Arena](https://github.com/opengvlab/multi-modality-arena) - 聊天机器人竞技场迎来多模态！多模态竞技场允许您将视觉语言模型并排进行基准测试，同时提供图像作为输入。支持MiniGPT-4、LLaMA-Adapter V2、LLaVA、BLIP-2等多种模型！
 * [chatbot](https://github.com/zhaoyingjun/chatbot) - ChatGPT带火了聊天机器人，主流的趋势都调整到了GPT类模式，本项目也与时俱进，会在近期更新GPT类版本。基于本项目和自己的语料可以训练出自己想要的聊天机器人，用于智能客服、在线问答、闲聊等场景。
 * [WechatBotCMD](https://github.com/wechatapis/wechatbotcmd) - 微信机器人WechatBotCMD是一个创新的基于Python 3.11开发的项目，通过结合ChatGPT模型和微信原生API，为用户提供智能聊天、自动绘画、自动发朋友圈、自动发视频号等多样的API集成服务，旨在提升日常沟通效率和趣味性。
 * [ChatGPT-On-CS](https://github.com/lrhh123/chatgpt-on-cs) - 基于大型模型的智能对话客服工具，支持微信、千牛、哔哩哔哩、抖音企业号、抖音、抖店、微博聊天、小红书专业号运营、小红书、知乎等平台接入，可选择 GPT3.5/GPT4.0/ 懒人百宝箱 （后续会支持更多平台），能处理文本、语音和图片，通过插件访问操作系统和互联网等外部资源，支持基于自有知识库定制企业 AI 应用。
 * [agentcloud](https://github.com/rnadigital/agentcloud) - 云代理就像拥有自己的GPT构建器，还有许多额外好处。GUI功能包括1）RAG管道，可以本地嵌入260多个数据源 2）创建对话应用程序（如GPT）3）创建多代理流程自动化应用程序（crewai）4）工具。
 * [openlrc](https://github.com/zh-plus/openlrc) - 使用whisper和LLM(GPT，Claude等)来将声音转录和翻译为LRC文件。
 * [wrest-chat](https://github.com/opentdp/wrest-chat) - 微信机器人，PC微信Api/Bot/Sdk，内置WEB管理界面，可接入GPT、Gemini、星火、文心、混元、通义千问等大语言模型
 * [chatbot-app](https://github.com/chatbot-all/chatbot-app) - 移动私人 ChatGPT 应用，支持 GPT3、GPT4 和 Gemini Pro 模型。
 * [ChatGPT-On-CS](https://github.com/cs-lazy-tools/chatgpt-on-cs) - 基于大型模型的智能对话客服工具，支持微信、千牛、哔哩哔哩、抖音企业号、抖音、抖店、微博聊天、小红书专业号运营、小红书、知乎等平台接入，可选择 GPT3.5/GPT4.0/ 懒人百宝箱（后续会支持更多平台），能处理文本、语音和图片，通过插件访问操作系统和互联网等外部资源，支持基于自有知识库定制企业 AI 应用。
 * [MOSS](https://github.com/openmoss/moss) - 一个来自复旦大学的开源工具增强对话语言模型
 * [Wa-OpenAI](https://github.com/sansekai/wa-openai) - WhatsApp 机器人 OpenAI ChatGPT NodeJS 使用库 Baileys
 * [gpt-assistant-android](https://github.com/skythinker616/gpt-assistant-android) - 免费的ChatGPT API安卓语音助手，可通过音量键激活进行语音交流，支持联网、Vision拍照识图、提问模板等功能。
 * [gpt-home](https://github.com/judahpaul16/gpt-home) - ChatGPT在家！基本上是一个更好的Google Nest Hub或亚马逊Alexa家庭助手。使用OpenAI API在树莓派上构建。
 * [gpt-computer-assistant](https://github.com/onuratakan/gpt-computer-assistant) - gpt-4o适用于Windows、macOS和Ubuntu
 * [nlux](https://github.com/nlkitai/nlux) - 强大的对话人工智能JavaScript库
 * [Streamer-Sales](https://github.com/peterh0323/streamer-sales) - Streamer-Sales 销冠 —— 卖货主播 LLM 大模型🛒🎁，一个能够根据给定的商品特点对商品进行解说并激发用户的购买意愿的卖货主播模型。🚀⭐内含详细的数据生成流程❗ 📦另外还集成了 LMDeploy 加速推理🚀、RAG检索增强生成 📚、TTS文字转语音🔊
 * [Chatbase-Alternative](https://github.com/anil-matcha/chatbase-alternative) - ChatGPT适用于每个网站。通过在您的网站内容上训练的个性化聊天机器人，即时回答访客的问题。是Chatbase、SiteGPT、Dante AI的替代方案。
 * [speak-gpt](https://github.com/andraxdev/speak-gpt) - 基于OpenAI ChatGPT的个人语音助手。
 * [IncarnaMind](https://github.com/junruxiong/incarnamind) - 通过GPT 3.5、GPT-4 Turbo、Claude和本地开源LLMs连接并与您的多个文档（pdf和txt）进行聊天。
 * [unsaged](https://github.com/jorge-menjivar/unsaged) - 专为与AI模型无缝交互而设计的开源聊天工具包。
 * [discord-llm-chatbot](https://github.com/jakobdylanc/discord-llm-chatbot) - llmcord.py • 与朋友们交流LLM！
 * [Instruct2Act](https://github.com/opengvlab/instruct2act) - Instruct2Act: 使用大型语言模型将多模态指令映射到机器人动作
 * [GURU-Ai](https://github.com/guru322/guru-ai) - 一个简单但复杂的AI聊天机器人，功能齐全🚩
 * [voxelgpt](https://github.com/voxel51/voxelgpt) - 能够查询视觉数据集，搜索FiftyOne文档，并回答一般计算机视觉问题的AI助手
 * [XYBot](https://github.com/henryxiaoyang/xybot) - 基于docker和pywxdll hook注入的微信机器人🤖️！✅高度可自定义！ ✅支持自我编写插件！非常多的功能：天气🌤️、获取新闻📰、ChatGPT聊天🗣️、Hypixel玩家查询🎮、随机图片📷、随机链接🔗、随机群成员👥、五子棋♟️、签到✅、查询积分📊、积分榜🏆、积分转送💰、积分抽奖🎁、积分红包🧧等
 * [GPTPortal](https://github.com/zaki-1052/gptportal) - 一个功能丰富的门户，可以通过轻量级的Node.js网络应用程序与GPT-4、Claude、Gemini、Mistral和OpenAI助手API进行聊天；支持语音、图片和文件的可定制多模态。
 * [CreativeChatGLM](https://github.com/ypwhs/creativechatglm) - 👋 欢迎来到 ChatGLM 创意世界！你可以使用修订和续写的功能来生成创意内容！
 * [ChatPilot](https://github.com/shibing624/chatpilot) - ChatPilot: 实现AgentChat对话，支持Google搜索、文件网址对话（RAG）、代码解释器功能，复现了Kimi Chat(文件，拖进来；网址，发出来)。
 * [Whatsapp-Ai-BOT](https://github.com/yesbhautik/whatsapp-ai-bot) - 介绍WhatsApp的AI聊天机器人-这是一种由OpenAI的ChatGPT、Playground和DALL·E驱动的尖端解决方案。这款创新的聊天机器人是使用NodeJS技术开发的，并利用人工智能的最新进展，为用户提供无与伦比的体验。
 * [fastui-chat](https://github.com/shroominic/fastui-chat) - 💬纯Python的极简ChatBot界面
 * [pokitoki](https://github.com/nalgeon/pokitoki) - 谦逊的GPT Telegram机器人
 * [openai-chat-api-workflow](https://github.com/yohasebe/openai-chat-api-workflow) - 🎩 一个用于使用OpenAI Chat API与GPT-3.5/GPT-4进行交互的Alfred 5工作流程 🤖💬 它还允许图像生成 🖼️，图像理解 👀，语音转文字转换 🎤，以及文本转语音合成 🔈
 * [AIUI](https://github.com/lspahija/aiui) - AIUI是一个平台，可以实现与人工智能之间无缝的双向口头交流。
 * [OPERA](https://github.com/shikiw/opera) - [CVPR 2024 亮点] OPERA：通过过度信任惩罚和回顾分配减轻多模态大型语言模型中的幻觉
 * [bot-on-anything](https://github.com/zhayujie/bot-on-anything) - 将AI模型（如ChatGPT-3.5/4.0、百度一言、新必应、Bard）连接到应用程序（如微信、公众号、钉钉、Telegram、QQ）。
 * [psychic](https://github.com/psychic-api/psychic) - 为LLMs设计的数据集成平台。使用一键式授权连接SaaS工具，并从N个数据源同步文档，只需一次集成。
 * [gpt-computer-assistant](https://github.com/upsonic/gpt-computer-assistant) - gpt-4o适用于Windows、macOS和Linux
 * [OpenAssistantGPT](https://github.com/openassistantgpt/openassistantgpt) - 一个社区开源的SaaS平台，可以利用OpenAI的助手API来制作/构建/创建聊天机器人，并将其添加到您的网站上。
 * [ChatGPT](https://github.com/nisabmohd/chatgpt) - 我使用Next.js 14、Shadcn-UI、Prisma ORM开发了一个ChatGPT克隆版本，并将其与OpenAI API集成。它提供了一个用户友好的对话人工智能体验。
 * [ChatGPT-Linebot-using-python-flask-on-vercel](https://github.com/howarder3/chatgpt-linebot-using-python-flask-on-vercel) - 使用Python Flask为Vercel创建GPT-Linebot
 * [ComfyUI-GPT_SoVITS](https://github.com/aifsh/comfyui-gpt_sovits) - 一个适用于GPT-SoVITS的comfyui自定义节点！现在你可以在comfyui中进行语音克隆和文字转语音。
 * [slack-bot](https://github.com/innogames/slack-bot) - 准备好使用的Slack机器人，为懒惰的开发人员：启动Jenkins作业，监视Jira工单，监视拉取请求并支持人工智能...
 * [psychic](https://github.com/finic-ai/psychic) - 为LLMs设计的数据集成平台。使用一键式授权连接SaaS工具，并从N个数据源同步文档，只需一次集成。
 * [repopack](https://github.com/yamadashy/repopack) - 📦 Repopack 是一个强大的工具，可以将您的整个代码库打包成一个单一的、友好于人工智能的文件。非常适合当您需要将您的代码库提供给大型语言模型（LLMs）或其他人工智能工具，如Claude、ChatGPT和Gemini时使用。
 * [finic](https://github.com/finic-ai/finic) - 为LLMs提供的数据集成平台。使用一键式授权连接到SaaS工具，并从N个数据源同步文档，只需进行一次集成。
 * [llmcord.py](https://github.com/jakobdylanc/llmcord.py) - 一个支持任何OpenAI兼容API的Discord LLM聊天机器人（OpenAI、Mistral、Groq、OpenRouter、ollama、oobabooga、Jan、LM Studio等）。
 * [django-ai-assistant](https://github.com/vintasoftware/django-ai-assistant) - 将AI助手与Django集成，构建智能应用程序
 * [MindSQL](https://github.com/mindinventory/mindsql) - MindSQL：一个简化数据库交互的Python文本到SQL RAG库。与PostgreSQL、MySQL、SQLite、Snowflake和BigQuery无缝集成。由GPT-4和Llama 2驱动，支持自然语言查询。支持ChromaDB和Faiss。
 * [insights-bot](https://github.com/nekomeowww/insights-bot) - 一个机器人与OpenAI GPT模型合作，为您的信息流提供见解。
 * [Babagaboosh](https://github.com/dougdouggithub/babagaboosh) - 与OpenAi的GPT 4进行口头对话的应用程序
 * [wandbot](https://github.com/wandb/wandbot) - wandbot是Weights & Biases的AI开发工具的技术支持机器人，可以在Discord、Slack、ChatGPT和Zendesk上运行。
 * [ai-data-analysis-MulitAgent](https://github.com/starpig1129/ai-data-analysis-mulitagent) - AI驱动的研究助手：一种先进的多智能体系统，用于自动化复杂的研究过程。利用LangChain、OpenAI GPT和LangGraph，这个工具简化了假设生成、数据分析、可视化和报告撰写。完美。
 * [lobe-vidol](https://github.com/lobehub/lobe-vidol) - 🧸 洛贝维多尔 - 让虚拟偶像为每个人所能接触
 * [RLAIF-V](https://github.com/rlhf-v/rlaif-v) - RLAIF-V：通过开源AI反馈对齐MLLMs，提高Super GPT-4V的可信度
 * [builderbot](https://github.com/codigoencasa/builderbot) - 🤖 在几分钟内创建WhatsApp聊天机器人。加入这个开源项目
 * [hey](https://github.com/lnxpy/hey) - 💬 人工智能驱动的编程伙伴！
 * [Auto-Gmail-Creator](https://github.com/ai-to-ai/auto-gmail-creator) - 使用Selenium和Seleniumwire（Python）的开源批量自动Gmail创建机器人。欢迎与我联系，涉及Django/Flask，机器学习，人工智能，GPT，自动化，网页抓取。
 * [design-studio](https://github.com/tiledesk/design-studio) - Tiledesk的开源可视化、无代码设计师，LLM/GPT AI与灵活的“图形”方法相结合。轻松创建对话和自动化 - 一种Voiceflow和Botpress的替代方案。
 * [chatgpt-voice](https://github.com/sonngdev/chatgpt-voice) - 与ChatGPT进行一次对话。随意🔈 🤖 ⚡️
 * [Open-LLaVA-NeXT](https://github.com/xiaoachen98/open-llava-next) - 一个用于训练LLaVA-NeXT的开源实现。
 * [langchain-chatbot](https://github.com/shashankdeshpande/langchain-chatbot) - 使用Langchain和Streamlit实现聊天机器人的示例
 * [OpsPilot](https://github.com/weops-lab/opspilot) - OpsPilot是WeOps团队开源的一个基于深度学习与LLM技术的智能运维助理。
 * [whatsapp-ai-bot](https://github.com/zain-ul-din/whatsapp-ai-bot) - 这是一个WhatsApp AI机器人，它使用各种AI模型，包括Gemini、GPT、DALL-E、Flux和StabilityAI，来生成对用户输入的响应。
 * [AI-in-a-Box](https://github.com/azure/ai-in-a-box) - AI-in-a-Box利用微软在全球范围内的专业知识，为技术社区开发和提供人工智能和机器学习解决方案。我们的目的是提供精心策划的解决方案加速器集合，帮助工程师建立他们的人工智能/机器学习。
 * [Starmoon](https://github.com/starmoonai/starmoon) - 一个开源的语音启用、紪恻AI硬件+软件🤖框架，用于陪伴、娱乐、教育、儿科护理、物联网机器人应用、AI增强机器人应用服务、研究和DIY机器人套件开发。
 * [LocalAI](https://github.com/mudler/localai) - 🤖 免费、开源的替代OpenAI、Claude等人工智能的选择。支持自托管和本地优先。可直接替代OpenAI，在消费级硬件上运行。无需GPU。支持gguf、transformers、diffusers等多种模型架构。
 * [bisheng](https://github.com/dataelement/bisheng) - BISHENG是一个开放的LLM devops平台，用于下一代企业AI应用程序。强大而全面的功能包括：GenAI工作流程，RAG，Agent，统一模型管理，评估，SFT，数据集管理，企业级系统管理。
 * [agency-swarm](https://github.com/vrsen/agency-swarm) - 建立在最新的OpenAI助手API之上的唯一可靠的代理框架。
 * [ragflow](https://github.com/infiniflow/ragflow) - RAGFlow是一个基于深度文档理解的开源RAG（检索增强生成）引擎。
 * [LlamaIndexTS](https://github.com/run-llama/llamaindexts) - 为您的LLM应用程序提供数据框架。专注于服务器端解决方案。
 * [repomix](https://github.com/yamadashy/repomix) - 📦 Repomix（原名Repopack）是一个强大的工具，可以将您的整个代码库打包成一个单一的、适合人工智能的文件。当您需要将您的代码库提供给大型语言模型（LLMs）或其他人工智能工具，如Claude、ChatGPT和Gemini时，这个工具非常适用。
 * [LangBot](https://github.com/rockchinq/langbot) - 原名 QChatGPT；😎高稳定性、🧩支持扩展、🦄多模态的 ChatGPT QQ / QQ频道 / One Bot 机器人🤖 | 支持 OpenAI GPT、Claude、Gemini Pro、DeepSeek、Moonshot（Kimi）、gpt4free、One API、Ollama、dify 的 QQ / QQ频道 / OneBot 机器人 / Agent 平台
 * [open-im-server](https://github.com/openimsdk/open-im-server) - IM 聊天 ChatGPT
 * [aws-genai-llm-chatbot](https://github.com/aws-samples/aws-genai-llm-chatbot) - 使用AWS CDK在AWS上部署一个由多个LLM和多个RAG驱动的聊天机器人（Amazon Bedrock、Anthropic、HuggingFace、OpenAI、Meta、AI21、Cohere、Mistral）的模块化和全面解决方案。
 * [podcastfy](https://github.com/souzatharsis/podcastfy) - 一个开源的Python替代方案，用于将多模态内容转化为引人入胜的多语言音频对话，与GenAI一起。
 * [multi-agent-orchestrator](https://github.com/awslabs/multi-agent-orchestrator) - 灵活而强大的框架，用于管理多个AI代理并处理复杂对话。


## Browser-extensions

 * [chat-gpt-google-extension](https://github.com/wong2/chat-gpt-google-extension) - 免费的3DS主入口点<=11.2
 * [chatgpt-retrieval-plugin](https://github.com/openai/chatgpt-retrieval-plugin) - ChatGPT检索插件可以让您通过使用日常语言提出问题，轻松搜索和查找个人或工作文件。
 * [Gepetto](https://github.com/justicerage/gepetto) - IDA插件，可查询OpenAI的gpt-3.5-turbo语言模型，加速反向工程。
 * [google-chatgpt-plugin](https://github.com/sogody/google-chatgpt-plugin) - @ykdojo 太棒了！已经有谷歌聊天GPT插件了 🤯
 * [natbot](https://github.com/nat/natbot) - 使用GPT-3驱动浏览器
 * [DAILA](https://github.com/mahaloz/daila) - 一个反编译器统一插件，用于访问OpenAI API，以提高您的反编译体验。
 * [regexplore](https://github.com/0xhasanm/regexplore) - Regexplore是一款Volatility插件，旨在模仿EZsuite中的Registry Explorer插件的功能。
 * [chat-todo-plugin](https://github.com/lencx/chat-todo-plugin) - ✅ ChatGPT插件，用于管理待办事项列表
 * [textual](https://github.com/textualize/textual) - Textual是Python的快速应用程序开发框架。使用简单的Python API构建复杂的用户界面。在终端和（即将推出的）Web浏览器中运行您的应用程序！
 * [ReconAIzer](https://github.com/hisxo/reconaizer) - 一个Burp Suite扩展，可以在Burp上添加OpenAI（GPT），帮助您进行Bug赏金侦查，发现端点、参数、URL、子域名等！
 * [Agent-LLM](https://github.com/josh-xt/agent-llm) - 一个人工智能自动化平台。支持来自各种提供商的AI指令管理，具有自适应记忆和多功能插件系统，包括网页浏览等多个命令。支持许多AI提供商和模型，并每天增加支持。
 * [web-llm](https://github.com/mlc-ai/web-llm) - 将大型语言模型和聊天引入到Web浏览器中。一切都在浏览器内运行，无需服务器支持。
 * [langchain-aiplugin](https://github.com/langchain-ai/langchain-aiplugin) - "Langchain作为AI插件"🔥-超酷。@hwchase17 @langchainai 这就像给#chatgpt超能力，因为它现在可以轻松地使用Langchain组件（代理、链等）作为插件。这个仓库将很快扩大规模。例如：检索QA链作为插件。
 * [plugins-quickstart](https://github.com/openai/plugins-quickstart) - 在不到5分钟内启动ChatGPT插件！在不到5分钟内启动ChatGPT插件！
 * [dangermode](https://github.com/rgbkrk/dangermode) - Dangermode是一个使用Python和FastAPI编写的ChatGPT插件，它允许ChatGPT在IPython会话中执行代码片段。
 * [examples](https://github.com/pinecone-io/examples) - 如果你对如何开发chatgpt插件感兴趣，推荐看一下这个视频，完整的介绍了：1. 什么是chatgpt插件2. 如何开发一个langchain文档查询的chatgpt插件3. 如何安装调试chatgpt插件视频：：
 * [chat-gpt-jupyter-extension](https://github.com/jflam/chat-gpt-jupyter-extension) - 一个浏览器扩展，可以让你从任何本地Jupyter笔记本与ChatGPT聊天。
 * [web-stable-diffusion](https://github.com/mlc-ai/web-stable-diffusion) - 将稳定的扩散模型带到Web浏览器中。一切都在浏览器内运行，无需服务器支持。
 * [ipython-gpt](https://github.com/santiagobasulto/ipython-gpt) - ipython-gpt - 一个与chatgpt直接聊天的jupyter/ipython扩展，非常有前途，可以直接从您的jupyter笔记本或ipython shell中与chatgpt聊天。
 * [tweetGPT](https://github.com/yaroslav-n/tweetgpt) - TweetGPT是一款Chrome扩展程序，使用chatGPT生成推文和回复。
 * [ChatGPT-pdf](https://github.com/liady/chatgpt-pdf) - 一个Chrome扩展程序，可以将您的ChatGPT历史记录下载为PNG、PDF或可共享链接。
 * [chatgpt-chrome-extension](https://github.com/gragland/chatgpt-chrome-extension) - 一个ChatGPT Chrome扩展程序。将ChatGPT集成到互联网上的每个文本框中。
 * [summarize.site](https://github.com/clmnin/summarize.site) - 使用OpenAI ChatGPT总结网页
 * [transformers.js](https://github.com/xenova/transformers.js) - 在您的浏览器中运行🤗变形金刚！
 * [bob-plugin-openai-translator](https://github.com/yetone/bob-plugin-openai-translator) - 基于ChatGPT API的文本翻译、文本润色、语法纠错Bob插件，让我们一起迎接不需要巴别塔的新时代！
 * [chatgpt-extension](https://github.com/iolivernguyen/chatgpt-extension) - 最小化的require.js实现了CommonJS。
 * [docGPT](https://github.com/cesarhuret/docgpt) - 在Google Docs中直接使用ChatGPT作为编辑器插件 📑
 * [ChatGPT-Assistant](https://github.com/pdparchitect/chatgpt-assistant) - 使用ChatGPT，告别手动扩展开发！我使用ChatGPT自动创建了这个扩展。#openai #openaichat
 * [chatGPTBox](https://github.com/josstorer/chatgptbox) - 将ChatGPT深度集成到您的浏览器中，您所需的一切都在这里。
 * [YouTube_Summary_with_ChatGPT](https://github.com/kazuki-sf/youtube_summary_with_chatgpt) - ChatGPT是一个简单的Chrome扩展程序（清单v3），它可以使用OpenAI的ChatGPT AI技术获取YouTube视频的转录和视频摘要。
 * [simpread](https://github.com/kenshin/simpread) - 简悦（SimpRead）- 让您瞬间进入沉浸式阅读的扩展。
 * [chatgpt-wechat-landing-page](https://github.com/1cloudy/chatgpt-wechat-landing-page) - 一款Chrome浏览器插件，使用ChatGPT智能聊天机器人自动回复微信私信或群聊中@你的消息。
 * [WebGPT](https://github.com/0hq/webgpt) - 使用WebGPU在浏览器上运行GPT模型。使用不到2000行普通JavaScript实现GPT推理。
 * [tabSidian](https://github.com/cgranier/tabsidian) - tabSidian可以收集您打开的浏览器标签页，并将它们转换成Markdown列表。
 * [chatgpt-advanced](https://github.com/qunash/chatgpt-advanced) - WebChatGPT：一款浏览器扩展，可将您的ChatGPT提示与网络结果相结合。
 * [chatgpt-vscode](https://github.com/mpociot/chatgpt-vscode) - 一个VSCode扩展，允许您使用ChatGPT。
 * [openai-translator](https://github.com/yetone/openai-translator) - 基于ChatGPT API的划词翻译浏览器插件和跨平台桌面端应用 - 基于ChatGPT API的翻译浏览器插件和跨平台桌面应用。
 * [obsidian-textgenerator-plugin](https://github.com/nhaouari/obsidian-textgenerator-plugin) - 文本生成器是Obsidian的一个方便插件，它可以帮助您使用GPT-3（OpenAI）生成文本内容。
 * [logseq-plugin-gpt3-openai](https://github.com/briansunter/logseq-plugin-gpt3-openai) - Logseq的GPT-3 AI辅助笔记插件
 * [chatgpt-arxiv-extension](https://github.com/hunkimforks/chatgpt-arxiv-extension) - 一个浏览器扩展程序，可以通过ChatGPT增强搜索引擎。
 * [chatgpt-google-extension](https://github.com/wong2/chatgpt-google-extension) - 一个浏览器扩展程序，可以通过ChatGPT增强搜索引擎。
 * [nextjs-chatgpt-app](https://github.com/enricoros/nextjs-chatgpt-app) - 💬 响应式聊天应用程序，由OpenAI的GPT-4驱动，具有响应式流、代码高亮和各种开发人员预设。使用Next.js、React和Joy。
 * [sharegpt](https://github.com/domeccleston/sharegpt) - 轻松与朋友分享ChatGPT对话的永久链接。
 * [chatgpt-raycast](https://github.com/abielzulio/chatgpt-raycast) - ChatGPT射线投射扩展程序
 * [GPT-Toolbox](https://github.com/cedricguillemet/gpt-toolbox) - VSCode 的 GPT 扩展程序
 * [CodeCursor](https://github.com/helixform/codecursor) - 一个在Visual Studio Code中使用光标的扩展。
 * [butler.vim](https://github.com/lambdalisue/butler.vim) - 🫖 您的管家。一个像 Vim/Neovim 插件一样与 OpenAI API 进行通信的 ChatGPT。
 * [AgentGPT](https://github.com/reworkd/agentgpt) - 🤖 在您的浏览器中组装、配置和部署自主 AI 代理。
 * [gpt-assistant](https://github.com/builderio/gpt-assistant) - 一个实验，让自主的GPT代理程序访问浏览器并完成任务。
 * [AutoGPT-Next-Web](https://github.com/dogtiti/autogpt-next-web) - 🤖 在浏览器中组装、配置和部署自主 AI 代理。
 * [chatgpt-plugin-ts](https://github.com/transitive-bullshit/chatgpt-plugin-ts) - 一切你需要开始使用JS/TS构建ChatGPT插件的东西🔥
 * [whisper_ros](https://github.com/ouxt-polaris/whisper_ros) - whisper_ros://t.co/rqb3qulyyo speak_ros_voicevox_plugin，如果有ros2，就可以制作语音对话系统了（由于vad未实现，因此语音识别精度不高）
 * [pg_gpt](https://github.com/cloudquery/pg_gpt) - 实验性扩展，将OpenAI API引入您的PostgreSQL，以人类语言运行查询。
 * [kubectl-ai](https://github.com/sozercan/kubectl-ai) - ✨ 用于OpenAI GPT的Kubectl插件
 * [ChatGPT_Extension](https://github.com/kazuki-sf/chatgpt_extension) - ChatGPT扩展是一个非常简单的Chrome扩展程序（清单v3），您可以从任何网站上访问OpenAI的ChatGPT。
 * [ChatGPT](https://github.com/wieslawsoltes/chatgpt) - 一个基于Avalonia UI框架的ChatGPT C#客户端，支持MacOS、Windows、Linux、Android、iOS和浏览器。
 * [CodeGPT.nvim](https://github.com/dpayne/codegpt.nvim) - CodeGPT是neovim的插件，提供与ChatGPT交互的命令。
 * [ChatGPT.nvim](https://github.com/jackmort/chatgpt.nvim) - Neovim插件与OpenAI GPT-3聊天机器人交互，提供一个简单的界面来探索GPT-3和NLP。
 * [mind-wave](https://github.com/manateelazycat/mind-wave) - 基于ChatGPT API的Emacs AI插件
 * [askgpt.vim](https://github.com/macrat/askgpt.vim) - 一个Vim插件，集成了ChatGPT，可以让你询问关于你的代码的问题。
 * [ChatGPT-Plugins-Collection](https://github.com/logankilpatrick/chatgpt-plugins-collection) - 一个非官方的ChatGPT插件集合，支持任何编程语言！
 * [burpgpt](https://github.com/aress31/burpgpt) - 一个Burp Suite扩展，集成了OpenAI的GPT，用于执行额外的被动扫描，以发现高度定制的漏洞，并能够对任何类型的流量进行基于流量的分析。
 * [openai-chatgpt-everywhere-extension](https://github.com/1997roylee/openai-chatgpt-everywhere-extension) - 示例CSV文件
 * [awesome-chatgpt-plugins](https://github.com/imaurer/awesome-chatgpt-plugins) - 建立和使用ChatGPT插件的有趣资源列表。
 * [Chrome-GPT](https://github.com/richardyc/chrome-gpt) - 一个控制您桌面上Chrome的AutoGPT代理。
 * [Auto-GPT-MetaTrader-Plugin](https://github.com/isaiahbjork/auto-gpt-metatrader-plugin) - AutoGPT MetaTrader插件是一款软件工具，可以让交易者将他们的MetaTrader 4或5交易账户连接到Auto-GPT。
 * [Auto-GPT-Plugins](https://github.com/significant-gravitas/auto-gpt-plugins) - Auto-GPT插件
 * [nextjs-chatgpt-plugin-starter](https://github.com/dabit3/nextjs-chatgpt-plugin-starter) - 使用Next.js的ChatGPT插件起始项目
 * [sftly-replace](https://github.com/kmizu/sftly-replace) - 一个Chrome扩展，可以轻松替换所选文本
 * [chatgpt-plugin](https://github.com/solana-labs/chatgpt-plugin) - 🧬@Solanalabs已经开发了一个开源的ChatGPT插件参考实现。🧬ChatGPT插件的可用性将使#Solana用户能够验证他们的钱包余额，转移代币并获取NFT。🔽信息
 * [bmtools](https://github.com/openbmb/bmtools) - BMTools：大型模型工具学习，ChatGPT-Plugins的开源解决方案，支持BabyAGI和Auto-GPTgithub。
 * [pake](https://github.com/tw93/pake#popular-packages) - 900Month的Chrome扩展程序是由AngularJS构建的。
 * [CopilotForXcode](https://github.com/intitni/copilotforxcode) - 缺失的GitHub Copilot和ChatGPT Xcode源代码编辑器扩展程序
 * [gpt-terminal-plugin](https://github.com/etherlegend/gpt-terminal-plugin) - ChatGPT的通用命令行插件
 * [smartgpt](https://github.com/cormanz/smartgpt) - 一个程序，为LLMs提供使用插件完成复杂任务的能力。
 * [chatgpt-plugin](https://github.com/cloudflare/chatgpt-plugin) - 使用Cloudflare的开发者平台构建ChatGPT插件 🤖
 * [QGPTAgent](https://github.com/momaabna/qgptagent) - QGPT代理是QGIS的强大插件，利用OpenAI GPT模型的先进自然语言处理能力自动化QGIS中的各种过程。使用此插件，用户可以使用自然语言命令与QGIS软件交互，大大减少完成各种任务所需的时间和精力。
 * [dify](https://github.com/langgenius/dify) - 一个API用于插件和数据集，一个界面用于提示工程和可视化操作，所有这些都是为了创建强大的人工智能应用程序。
 * [chatgpt-retrieval-plugin](https://github.com/openai/chatgpt-retrieval-plugin#supabase) - ChatGPT检索插件可以让您通过自然语言提问轻松查找个人或工作文件。
 * [GameDealGenie-ChatGPT-Plugin](https://github.com/cyrisxd/gamedealgenie-chatgpt-plugin) - 使用ChatGPT插件，从多个商店获取PC游戏的最新优惠。由Cheapshark提供支持。
 * [openai-plugin-fastapi](https://github.com/azure-samples/openai-plugin-fastapi) - 在 Scott Guthrie 的主题演讲中介绍的 OpenAI 插件示例代码ChatGPT Plugin Quickstart，使用 Python 和 FastAPI #MSBuild。
 * [ChatGPT-Plugins-Searchable](https://github.com/banbri/chatgpt-plugins-searchable) - 让你的 ChatGPT 插件商店支持搜索。https://greasyfork.org/scripts/466901-chatgpt-plugins-searchable
 * [chat-ai-plugin](https://github.com/personoids/chat-ai-plugin) - “每个聊天中的自主权的力量” - 将ChatGPT转化为一个强大的自主代理，可以独立完成复杂任务。
 * [github-chatGPT-plugin](https://github.com/jesserweigel/github-chatgpt-plugin) - 一个ChatGPT插件，可让您访问GitHub。
 * [chatgpt-code-plugin](https://github.com/kesor/chatgpt-code-plugin) - 代码 ChatGPT 插件是一种 TypeScript 代码分析器，使 ChatGPT 能够与您的代码“交流”。
 * [Auto-GPT-Crypto-Plugin](https://github.com/isaiahbjork/auto-gpt-crypto-plugin) - AutoGPT加密插件是一种软件工具，使交易者能够将他们的加密钱包或交易所连接到Auto-GPT。
 * [ChatGPT-Developer-Plugins](https://github.com/samuraigpt/chatgpt-developer-plugins) - 免费运行ChatGPT插件，无需订阅Plus。
 * [chatgpt-simple-todo-plugin](https://github.com/yoshinorisano/chatgpt-simple-todo-plugin) - 通过这个简单的代码和说明，你可以开始开发ChatGPT插件。这是你第一个插件开发的完美示例。
 * [codeexplain.nvim](https://github.com/mthbernardes/codeexplain.nvim) - 一个由GPT4ALL驱动的nvim插件，用于实时代码解释和漏洞检测（无需互联网）。
 * [chatgpt-export](https://github.com/yaph/chatgpt-export) - 一个用于将ChatGPT对话导出为Markdown文件的浏览器书签工具。
 * [logseq-chatgpt-plugin](https://github.com/debanjandhar12/logseq-chatgpt-plugin) - 一个紧密集成的Logseq聊天插件。
 * [autogpt-package](https://github.com/kurtosis-tech/autogpt-package) - 就像Auto-GPT遇到了Brew一样。使用任何您选择的后端和所需的插件，最简单和最快速的开始使用AutoGPT的方法。
 * [PowerToys4OpenAI](https://github.com/robert-hoffmann/powertoys4openai) - Chrome、Edge和Opera的GPT聊天扩展。与搜索结果直接集成。完整的聊天界面和历史记录管理。无需服务器，成本效益高。
 * [napari-chatgpt](https://github.com/royerlab/napari-chatgpt) - 一个使用chatGPT处理和分析图像的napari插件！
 * [kaguya](https://github.com/ykdojo/kaguya) - 一个ChatGPT插件，可以以受控方式加载和编辑本地文件，以及运行任何Python、JavaScript和bash脚本。
 * [duckduckgpt](https://github.com/kudoai/duckduckgpt) - 🐤 DuckDuckGo 插件将 ChatGPT 的魔力带到搜索结果中（由 GPT-4 提供动力！）
 * [bravegpt](https://github.com/kudoai/bravegpt) - 🦁 勇敢搜索插件将ChatGPT的魔力带到搜索结果中（由GPT-4提供动力！）
 * [listennotes-chatgpt-plugin](https://github.com/listennotes/listennotes-chatgpt-plugin) - Listen Notes ChatGPT插件，用于基于人工智能的播客搜索。由PodcastAPI.com和Cloudflare Pages提供支持。
 * [chatgpt-github-plugin](https://github.com/carlos-lugo/chatgpt-github-plugin) - 这个仓库包含一个与GitHub API交互的ChatGPT插件。它可以获取关于GitHub仓库的信息，包括仓库列表、仓库中的分支和文件，以及特定文件的内容。
 * [chatgpt-plugin-clerk-auth](https://github.com/eidam/chatgpt-plugin-clerk-auth) - 使用Cloudflare Workers和Clerk OAuth2后端的ChatGPT插件示例。使用Cloudflare Workers和Clerk OAuth2后端的ChatGPT插件示例。
 * [vscode-i-dont-care-about-commit-message](https://github.com/mefengl/vscode-i-dont-care-about-commit-message) - 又一个AI git提交插件，但无需手动确认。
 * [openai-translator](https://github.com/openai-translator/openai-translator) - 基于ChatGPT API的划词翻译浏览器插件和跨平台桌面端应用 - 基于ChatGPT API的翻译浏览器插件和跨平台桌面应用。
 * [ais-ninja](https://github.com/jarvis2f/ais-ninja) - 一个支持插件的ChatGPT。TG：https://t.me/+bIZncGryj_85MjYx
 * [openplugin](https://github.com/cakecrusher/openplugin) - 通过API（或客户端）与OpenAI的ChatGPT插件无缝集成，提供与ChatGPT api +插件相同的强大功能！
 * [continue](https://github.com/continuedev/continue) - ⏩ 这是一个开源的自动驾驶软件开发工具——一个将ChatGPT的强大功能引入到您的IDE中的VS Code扩展。
 * [GPT-Plugins](https://github.com/targed/gpt-plugins) - GPT-Plugins是一个GitHub仓库，它作为一个全面的插件、附加组件和扩展列表，为ChatGPT以及与GPT架构兼容的其他语言模型提供服务。
 * [web5-chatgpt-plugin](https://github.com/tbd54566975/web5-chatgpt-plugin) - 一个ChatGPT插件，为ChatGPT添加了web5代码辅助和知识。
 * [chatgpt-plugin](https://github.com/e2b-dev/chatgpt-plugin) - ChatGPT的代码解释器加强版。运行任何语言，任何终端进程，自由使用文件系统。同时具备互联网访问权限。
 * [awesome-chatgpt-plugins](https://github.com/highwayoflife/awesome-chatgpt-plugins) - ChatGPT Plus中所有可用的ChatGPT插件的精选列表，包括详细描述和使用文档，以及非官方的插件来源。
 * [meeper](https://github.com/pas1ko/meeper) - Meeper 📝 - 是您在浏览器中的任何会议的秘书。
 * [codesherpa](https://github.com/iamgreggarcia/codesherpa) - 一个代码解释器和ChatGPT插件
 * [ethgpt](https://github.com/xinbenlv/ethgpt) - ChatGPT插件用于以太坊和EVM dApp /智能合约功能ChatGPT插件用于以太坊和EVM dApp /智能合约功能
 * [GodMode](https://github.com/smol-ai/godmode) - AI聊天浏览器：快速、完整的Web应用程序访问ChatGPT / Claude / Bard / Bing / Llama2！我每天使用它20次。
 * [Image-To-Text-OCR-extension-for-ChatGPT](https://github.com/tshetrim/image-to-text-ocr-extension-for-chatgpt) - 图像转文本（OCR）ChatGPT Chrome扩展程序
 * [search-recommendations](https://github.com/niemingxing/search-recommendations) - 搜索推荐词采集与内容生成助手是一款强大的Chrome插件，专为小红书、抖音、B站、知乎、百度、google用户设计。它能够自动收集并显示这些平台的搜索推荐词或联想词，保存下载为csv文件，帮助您更轻松地进行搜索、浏览和发现感兴趣的内容。同时可以利用chatgpt自动化批量生产与采集内容发布到wordpress站点。
 * [openai.mini](https://github.com/llmapp/openai.mini) - 实现使用开源LLM和其他模型的OpenAI API和插件可用的ChatGPT。
 * [openplugin](https://github.com/openpluginaci/openplugin) - 通过API（或客户端）与OpenAI的ChatGPT插件无缝集成，提供与ChatGPT api +插件相同的强大功能！
 * [chatgpt-desktop](https://github.com/inplex-sys/chatgpt-desktop) - 在Windows上使用ChatGPT，包括其中的AIPRM（适用于无法在Firefox上安装的用户）
 * [superpower-chatgpt](https://github.com/saeedezzati/superpower-chatgpt) - ChatGPT具备超能力！搜索聊天记录，创建文件夹，导出所有聊天记录，置顶消息，访问成千上万的社区提示，隐身模式，选择语言和语气，以及许多其他功能。
 * [show-me-chatgpt-plugin](https://github.com/bra1ndump/show-me-chatgpt-plugin) - 在ChatGPT中创建和编辑图表
 * [ChatGPT-Plugins](https://github.com/serp-ai/chatgpt-plugins) - 为ChatGPT提供使用网络浏览、Python代码执行和自定义插件的能力的存储库
 * [ChatIDE](https://github.com/yagil/chatide) - 在您的IDE中的AI编码助手 - ChatGPT（OpenAI）和Claude（Anthropic）在VSCode扩展中。
 * [vim-chatgpt](https://github.com/codercooke/vim-chatgpt) - Vim插件适用于ChatGPT
 * [obsidian-weaver](https://github.com/vasilecampeanu/obsidian-weaver) - Weaver是一个有用的黑曜石插件，将ChatGPT/GPT-3集成到您的笔记工作流中。这个插件使得在Obsidian中访问由人工智能生成的建议和见解变得容易，帮助您改善写作和头脑风暴的过程。
 * [chatgpt-plugins](https://github.com/copilot-us/chatgpt-plugins) - 官方ChatGPT插件🧩
 * [auto-chatgpt](https://github.com/ryuseisan/auto-chatgpt) - 自动化与ChatGPT浏览器版本的互动。
 * [chatlab](https://github.com/rgbkrk/chatlab) - 将ChatGPT插件引入您的笔记本
 * [paperchat](https://github.com/forward-operators/paperchat) - PaperChat - 用于查询arXiv数据集的cli、API和ChatGPT插件
 * [chatgpt-microphone](https://github.com/davidmvenegas/chatgpt-microphone) - 将语音转文字和快捷片段添加到ChatGPT。
 * [github-chatgpt-plugin](https://github.com/aavetis/github-chatgpt-plugin) - ChatGPT插件可与GitHub中的任何内容进行交互。从ChatGPT插件商店安装“Chat With Code”插件。
 * [eclipse-chatgpt-plugin](https://github.com/gradusnikov/eclipse-chatgpt-plugin) - 一个与ChatGPT集成的Eclipse插件
 * [automatic-chatgpt-dan](https://github.com/madkarmaa/automatic-chatgpt-dan) - 浏览器用户脚本，自动将DAN消息发送到ChatGPT。
 * [sk-nl2ef-plugin](https://github.com/anthonypuppo/sk-nl2ef-plugin) - 一个使用语义内核构建的ChatGPT插件，可以通过自然语言查询数据库。在微软首届语义内核黑客马拉松中获得“对企业最有用”类别的冠军。
 * [Awesome-Plugins](https://github.com/targed/awesome-plugins) - Awesome-Plugins是一个GitHub仓库，它作为一个综合列表，提供了适用于ChatGPT以及与GPT架构兼容的其他语言模型的插件、附加组件和扩展。
 * [Free-personal-AI-Assistant-with-plugin](https://github.com/intelligenzaartificiale/free-personal-ai-assistant-with-plugin) - 🤗 您想使用带有插件的GPT4，但又不想支付每月20美元吗？这就是解决方案！通过这个存储库，您可以免费获得ChatGPT的克隆版本。
 * [LeanDojoChatGPT](https://github.com/lean-dojo/leandojochatgpt) - ChatGPT插件用于Lean中的定理证明。
 * [awesome-chatgpt-plugins](https://github.com/jikkujose/awesome-chatgpt-plugins) - 最全面的ChatGPT插件列表，全部在一个页面上！
 * [gp.nvim](https://github.com/robitx/gp.nvim) - GPT.nvim：Neovim AI插件 ～ OpenAI的ChatGPT和Copilot和语音转文字
 * [LLMBot](https://github.com/llmkira/llmbot) - 插件概念原型机 /// 代理系统/自决策 |类 ChatGpt 插件系统| Gpt-3.5/Gpt-4 |助手 | 📱 跨平台 | 🦾 异步 | 🔌 插件系统
 * [bob-plugin-openai-translator](https://github.com/openai-translator/bob-plugin-openai-translator) - 基于 ChatGPT API 的文本翻译、文本润色、语法纠错 Bob 插件，让我们一起迎接不需要巴别塔的新时代！根据 CC BY-NC-SA 4.0 许可证授权。
 * [Openaibot](https://github.com/llmkira/openaibot) - ⚡️ 构建您自己的助手机器人 | 🧀 Discord/Slack/Kook/Telegram | 🍓 复刻 ChatGpt 架构 | ⛓ 工具调用/函数调用 | 🔖 插件支持 | 🌻 sh 和 docker-compose
 * [LibreChat](https://github.com/danny-avila/librechat) - 增强版ChatGPT克隆：功能包括OpenAI、Bing、Anthropic、OpenRouter、PaLM 2、AI模型切换、消息搜索、langchain、DALL-E-3、ChatGPT插件、OpenAI函数、安全多用户系统、预设，完全开源以供自主托管。更多功能正在开发中。
 * [pgvecto.rs](https://github.com/tensorchord/pgvecto.rs) - 可扩展的矢量数据库插件，使用Rust编写，专为LLM设计。
 * [AI-Prompt-Genius](https://github.com/benf2004/ai-prompt-genius) - 策划一个定制的人工智能提示库
 * [Ebook-Translator-Calibre-Plugin](https://github.com/bookfere/ebook-translator-calibre-plugin) - 一个用于将电子书翻译成指定语言的Calibre插件。
 * [WPeChatGPT](https://github.com/wpeace-hch/wpechatgpt) - 一个用于IDA的插件，可以帮助分析二进制文件，它基于OpenAI训练的gpt-3.5-turbo模型，与ChatGPT相同。
 * [chatgpt-plugin](https://github.com/ikechan8370/chatgpt-plugin) - 云崽qq机器人的chatgpt插件
 * [chatgpt-google-summary-extension](https://github.com/sparticleinc/chatgpt-google-summary-extension) - Chrome扩展程序，可在Google搜索结果和YouTube视频旁边查看ChatGPT摘要，还支持Yahoo! ニュース、PubMed、PMC、NewsPicks、Github、Nikkei、Bing、Google专利以及任何页面的摘要。
 * [CodeGPT](https://github.com/carlrobertoh/codegpt) - JetBrains扩展程序提供免费访问最先进的LLM，如GPT-4、Code Llama等等。输出：JetBrains扩展程序提供免费访问最先进的LLM，如GPT-4、Code Llama等等。
 * [ReadSomething](https://github.com/readsomething/readsomething) - 📖 一个开源的 Chrome 插件，可以将网页转成阅读模式，并且内置了 AI 总结、翻译、Markdown 转换等功能。
 * [writely](https://github.com/anc95/writely) - ❤️‍🔥 一个超越 Notion AI 的替代品的 Chrome 浏览器插件。
 * [CoDeveloperGPTengine](https://github.com/stoerr/codevelopergptengine) - 合作开发者GPT引擎：为开发者创建ChatGPT插件，允许读取/搜索/写入文件，执行（构建）操作。
 * [neoai.nvim](https://github.com/bryley/neoai.nvim) - 与OpenAI的GPT模型交互的Neovim插件输出：Neovim插件，用于与OpenAI的GPT模型交互
 * [nonebot_plugin_naturel_gpt](https://github.com/kromiose/nonebot_plugin_naturel_gpt) - 一个基于NoneBot框架的Ai聊天插件，对接OpenAi文本生成接口，实现了机器人的人格自定义/切换，聊天记忆等功能。
 * [vim-ai](https://github.com/madox2/vim-ai) - 基于人工智能的Vim代码助手。Vim和Neovim的OpenAI和ChatGPT插件。
 * [AI-Employe](https://github.com/vignshwarar/ai-employe) - 使用GPT-4 Vision 创建浏览器自动化，就像教导人类一样。
 * [raycast-openai-translator](https://github.com/openai-translator/raycast-openai-translator) - 基于 ChatGPT API 的 Raycast 翻译插件 - 基于 ChatGPT API 的 Raycast 翻译扩展。
 * [AI-Prompt-Genius](https://github.com/ai-prompt-genius/ai-prompt-genius) - 策划一个定制的人工智能提示库
 * [supermemory](https://github.com/dhravya/supermemory) - 用超级记忆力建立自己的第二大脑。这是您书签的ChatGPT。使用Chrome扩展程序导入推文或保存网站和内容。
 * [OpenCharacters](https://github.com/josephrocca/opencharacters) - 一个简单的小型网络界面，用于创建角色并与他们聊天。基本上是一个单独的HTML文件 - 没有服务器。使用链接分享角色（角色数据存储在URL本身中）。所有聊天数据都存储在您的浏览器中，使用Indexed。
 * [py-gpt](https://github.com/szczyglis-dev/py-gpt) - 由GPT-4、GPT-4 Vision、GPT-3.5、DALL-E 3、Langchain、Llama-index等技术驱动的桌面AI助手，具有聊天、视觉、图像生成和分析、自主代理、代码和命令执行、文件上传和下载、语音合成和识别、网络访问等功能。
 * [chatgpt-to-notion](https://github.com/l-a-r-t/chatgpt-to-notion) - ChatGPT to Notion 将 ChatGPT 的智能直接带入您的 Notion 工作空间！
 * [neural](https://github.com/dense-analysis/neural) - AI Vim/Neovim 代码生成插件（OpenAI，ChatGPT 等）
 * [Sophia](https://github.com/kyegomez/sophia) - 轻松插件和播放优化器，可将模型训练成本降低50%。新的优化器在LLMs上比Adam快2倍。
 * [ChatGPT-Gnome-Desktop-Extension](https://github.com/horrorpills/chatgpt-gnome-desktop-extension) - ChatGPT Gnome桌面扩展 | 从您的菜单栏与ChatGPT交谈！
 * [privacy-settings](https://github.com/stellarsand/privacy-settings) - 大多数主要软件和服务的隐私设置指南。
 * [nonebot-plugin-bilichat](https://github.com/well2333/nonebot-plugin-bilichat) - 一个通过 OpenAI 来对b站视频进行总结的多功能 B站解析插件一个能够通过 OpenAI 对b站视频进行总结的多功能 B站解析插件
 * [Raycast-Easydict](https://github.com/tisfeng/raycast-easydict) - 一个用于查找单词或翻译文本的射线投射扩展。支持48种以上语言，支持Linguee和Youdao词典，支持OpenAI、DeepL、Google、Bing、Apple、百度、腾讯、火山、有道和彩云翻译。
 * [model.nvim](https://github.com/gsuuon/model.nvim) - Neovim插件，用于与LLM进行交互并构建集成在编辑器中的提示。
 * [BrowserGPT](https://github.com/mayt/browsergpt) - 用GPT指挥您的浏览器
 * [VisualChatGPTStudio](https://github.com/jeffdapaz/visualchatgptstudio) - 在Visual Studio上直接添加chatGPT功能
 * [crawlee-python](https://github.com/apify/crawlee-python) - Crawlee - 一个用于Python的网络爬虫和浏览器自动化库，用于构建可靠的爬虫。提取数据用于AI、LLMs、RAG或GPTs。从网站下载HTML、PDF、JPG、PNG和其他文件。与BeautifulSoup、Playwright和原始HTTP一起使用。支持头部。
 * [supermemory](https://github.com/supermemoryai/supermemory) - 用超级记忆力建立自己的第二大脑。这是您书签的ChatGPT。使用Chrome扩展程序导入推文或保存网站和内容。
 * [Auto-GPT-Plugin-Template](https://github.com/significant-gravitas/auto-gpt-plugin-template) - 为开发您自己的Auto-GPT插件提供一个起点
 * [joplin-plugin-jarvis](https://github.com/alondmnt/joplin-plugin-jarvis) - Joplin（笔记）助手运行一个非常智能的系统（OpenAI/GPT、Hugging Face、Gemini、Llama、Universal Sentence Encoder等）。
 * [ChatLLM-Web](https://github.com/ryan-yang125/chatllm-web) - 使用WebGPU在浏览器中与像维库纳一样的LLM进行安全、私密且无服务器的聊天。由web llm 提供支持。
 * [raycast-g4f](https://github.com/xinthedark/raycast-g4f) - 射线投射扩展程序，可免费使用GPT-4、Llama-3等等...无需API密钥！
 * [bob-plugin-openai-polisher](https://github.com/openai-translator/bob-plugin-openai-polisher) - 使用 OpenAI API 给文本进行润色和语法纠错的 Bob 插件！完美代替 Grammarly！根据 CC BY-NC-SA 4.0 许可证授权。
 * [GPT-Prompter](https://github.com/giosilvi/gpt-prompter) - 浏览器扩展，可快速获取OpenAI的GPT-3、GPT-4和ChatGPT API的提示（所选文本）。在Chrome网络商店和Firefox浏览器插件中可用。
 * [web-llm-chat](https://github.com/mlc-ai/web-llm-chat) - 与在您的浏览器中本地运行的AI大型语言模型聊天。享受私密、无服务器、无缝的AI对话。
 * [chatgpt-advanced](https://github.com/interstellard/chatgpt-advanced) - WebChatGPT：一款浏览器扩展，可以通过网络结果增强您的ChatGPT提示。
 * [linkedIn_auto_jobs_applier_with_AI](https://github.com/feder-cr/linkedin_auto_jobs_applier_with_ai) - LinkedIn_AIHawk是一个工具，可以自动化LinkedIn上的求职申请流程。利用人工智能技术，它使用户能够以自动化和个性化的方式申请多个工作机会。
 * [Plugin-VoiceGPT](https://github.com/wstxda/plugin-voicegpt) - 使用ChatGPT代替谷歌助手
 * [codecompanion.nvim](https://github.com/olimorris/codecompanion.nvim) - ✨ 在Neovim中的Copilot聊天体验，配有内联助手。支持Anthropic、Gemini、Ollama和OpenAI LLMs
 * [open-assistant-api](https://github.com/mlt-oss/open-assistant-api) - Open Assistant API是一个即插即用的开源自托管代理/ GPTS编排创建框架，支持LLM、RAG、函数调用和工具功能的定制扩展。它还支持与openai/lang的无缝集成。
 * [parrot.nvim](https://github.com/frankroeder/parrot.nvim) - 鹦鹉.nvim 🦜 - 将随机鹦鹉带入Neovim的插件。这是一个专注于简单性的gp.nvim分支。
 * [ChatGPTWizard](https://github.com/alidehbansiahkarbon/chatgptwizard) - Embarcadero RAD Studio IDE XE5至12.1的ChatGPT、WriteSonic、YouChat和Ollama(离线)插件。https://getitnow.embarcadero.com/chatgptwizard
 * [Auto_Jobs_Applier_AIHawk](https://github.com/feder-cr/auto_jobs_applier_aihawk) - Auto_Jobs_Applier_AIHawk是一个自动化工作申请流程的工具。利用人工智能，它使用户能够以自动化和个性化的方式申请多个工作机会。
 * [ai-commits-intellij-plugin](https://github.com/blarc/ai-commits-intellij-plugin) - 基于IntelliJ的IDEs/Android Studio的AI Commits。
 * [ogpt.nvim](https://github.com/huynle/ogpt.nvim) - 与Ollama/Huggingface/TextGen/OpenAI/Gemini/Anthropic GPT Neovim插件聊天：使用LLM API轻松生成自然语言
 * [ChatGPTToolkitExtension](https://github.com/doggy8088/chatgpttoolkitextension) - 提升ChatGPT、Gemini、Claude、phind、Groq网站的使用体验，提供一些好用功能。比如自动从URL填入提示，在回应的地方出现自动提示按钮。
 * [LLM_Web_search](https://github.com/mamei16/llm_web_search) - 一个为oobabooga/text-generation-webui提供的扩展，使LLM能够使用DuckDuckGo搜索网络。
 * [DevoxxGenieIDEAPlugin](https://github.com/devoxx/devoxxgenieideaplugin) - DevoxxGenie是IntelliJ IDEA的插件，使用本地LLM（Ollama、LMStudio、GPT4All、Llama.cpp和Exo）和基于云的LLM来帮助审查、测试、解释您的项目代码。
 * [AGiXT](https://github.com/josh-xt/agixt) - AGiXT是一个动态的AI代理自动化平台，可以无缝地协调指令管理和复杂任务执行，涵盖各种AI提供商。结合自适应记忆、智能功能和多功能插件系统，AGiXT提供高效的。
 * [AutoGPT-Next-Web](https://github.com/connectai-e/autogpt-next-web) - 🤖 在浏览器中组装、配置和部署自主AI代理。一键免费部署您的私人AutoGPT网页应用。
 * [Auto_Jobs_Applier](https://github.com/aihawk-app/auto_jobs_applier) - Auto_Jobs_Applier_AIHawk是一个自动化工作申请流程的工具。利用人工智能，它使用户能够以自动化和个性化的方式申请多个工作。
 * [browser-use](https://github.com/gregpr07/browser-use) - 开源网络自动化库与任何LLM
 * [Auto_Jobs_Applier](https://github.com/aihawk-co/auto_jobs_applier) - Auto_Jobs_Applier是由AIHawk开发的一种代理工具，可以自动化工作申请流程。利用人工智能技术，它可以让用户以自动化和个性化的方式申请多个工作岗位。
 * [Auto_Jobs_Applier_AI_Agent](https://github.com/aihawk-co/auto_jobs_applier_ai_agent) - Auto_Jobs_Applier_AI_Agent是由AIHawk开发的一款AI代理程序，可以自动化工作申请流程。利用人工智能技术，它使用户能够以自动化和个性化的方式申请多个工作。
 * [zsh_codex](https://github.com/tom-doerr/zsh_codex) - 这是一个ZSH插件，可以让你在命令行中使用OpenAI的Codex人工智能。
 * [pipelines](https://github.com/open-webui/pipelines) - 管道：多功能，与UI无关的OpenAI兼容插件框架
 * [aura-voice](https://github.com/ntegrals/aura-voice) - Aura就像Siri一样，但是在你的浏览器中。一款专为低延迟响应优化的人工智能语音助手。


## CLIs

 * [ChatGPT](https://github.com/acheong08/chatgpt) - 反向工程ChatGPT API
 * [shell_gpt](https://github.com/ther1d/shell_gpt) - 一个由ChatGPT驱动的命令行生产力工具，将帮助您更快、更高效地完成任务。
 * [PyChatGPT](https://github.com/rawandahmad698/pychatgpt) - ⚡️Python客户端，用于非官方ChatGPT API，具有自动令牌再生、对话跟踪、代理支持等功能。
 * [chatgpt-wrapper](https://github.com/mmabrouk/chatgpt-wrapper) - 使用Python和Shell与ChatGPT和GPT4进行交互的API。
 * [chatblade](https://github.com/npiv/chatblade) - 一个适用于ChatGPT的CLI瑞士军刀
 * [Alice](https://github.com/greshake/alice) - 授权ChatGPT访问真实终端。
 * [command-ai](https://github.com/amachino/command-ai) - 由OpenAI API驱动的终端AI聊天机器人
 * [GPT_Vuln-analyzer](https://github.com/morpheuslord/gpt_vuln-analyzer) - 使用ChatGPT API、Python-Nmap、DNS Recon模块，并利用GPT3模型基于Nmap扫描数据和DNS扫描信息创建漏洞报告。它还可以大量执行子域枚举。
 * [shell-genie](https://github.com/dylanjcastillo/shell-genie) - 你的愿望就是我的命令。
 * [DirectAI](https://github.com/ustayready/directai) - 在您的终端中通过OpenAI API查询ChatGPT。
 * [GPTalk](https://github.com/0ut0flin3/gptalk) - 支持任何语言的文本和语音的Windows和Unix GPT-3客户端，具有内存管理功能。
 * [Reptyl](https://github.com/0ut0flin3/reptyl) - 跨平台命令行 shell，支持使用自然语言执行命令。
 * [wanna](https://github.com/hirokidaichi/wanna) - 带自然语言的Shell命令启动器
 * [datasetGPT](https://github.com/radi-cho/datasetgpt) - 一个命令行界面，用于生成带有LLMs的文本和对话数据集。
 * [chatgpt-cli](https://github.com/j178/chatgpt-cli) - 饭否机器人
 * [engshell](https://github.com/emcf/engshell) - 由LLMs驱动的任何操作系统的英语语言外壳
 * [node-chatgpt-api](https://github.com/waylaidwanderer/node-chatgpt-api) - 一个ChatGPT和Bing AI的客户端实现。可作为Node.js模块、REST API服务器和CLI应用程序使用。
 * [chat-gpt-cli](https://github.com/jseguillon/chat-gpt-cli) - PhantomJS QUnit测试运行器，将结果导出为JUnit XML格式，并将覆盖率导出为Cobertura XML格式，可用于与Jenkins等CI工具配合使用。
 * [terminalGPT](https://github.com/jucasoliveira/terminalgpt) - 在您的终端上获取类似于chatGPT的GPT
 * [chatgpt-gsheets](https://github.com/amrrs/chatgpt-gsheets) - 【新】#chatgpt在表格中！🤯只需点击几下，就可以在@googlesheets中集成#chatgpt #api，@1littlecoder向您展示如何操作！用例：#seo，#socialmedia，#marketing，应有尽有！🔥- 教程：代码：费用：每百万令牌2美元！🙃
 * [gptsh](https://github.com/shorwood/gptsh) - GPT.sh是一个使用NodeJs构建的CLI工具，由Open AI的GPT-3驱动。它的主要目的是将自然语言问题和请求转换为shell命令。
 * [chatgpt-api](https://github.com/transitive-bullshit/chatgpt-api) - 官方ChatGPT API的Node.js客户端。🔥
 * [ChatGPT-Next-Web](https://github.com/yidadaa/chatgpt-next-web) - 一键部署你自己的ChatGPT网页界面。
 * [ai-cli](https://github.com/abhagsain/ai-cli) - 从您的终端直接获取GPT3 CLI命令的答案
 * [chathub](https://github.com/chathub-dev/chathub) - 全能聊天机器人客户端
 * [bing-chat](https://github.com/transitive-bullshit/bing-chat) - Bing的新AI搜索的Node.js客户端。就像加强版的ChatGPT🔥。
 * [aicommits](https://github.com/nutlope/aicommits) - 一个使用人工智能为您编写git提交信息的CLI
 * [opencommit](https://github.com/di-sukharev/opencommit) - 使用GPT CLI自动生成令人印象深刻的提交，仅需1秒钟🤯🔫
 * [react-native-chatgpt](https://github.com/rgommezz/react-native-chatgpt) - 一个React Native封装的ChatGPT，可以无缝地将其与您的应用程序集成。它处理身份验证、流式响应和跟踪对话。100%客户端 :robot:
 * [GPT-Shell](https://github.com/firtoz/gpt-shell) - GPT-Shell是一款基于OpenAI的聊天机器人，类似于OpenAI的ChatGPT。还可以创建Dalle2图像。
 * [autodoc](https://github.com/context-labs/autodoc) - 使用LLMs自动生成代码库文档的实验工具包
 * [commit-assist](https://github.com/dejorrit/commit-assist) - 使用ChatGPT自动生成提交信息
 * [ai-shell](https://github.com/builderio/ai-shell) - 一个将自然语言转换为Shell命令的CLI。
 * [doschgpt](https://github.com/yeokm1/doschgpt) - 一个用于DOS的ChatGPT客户端的概念验证。
 * [gptcommit](https://github.com/zurawiki/gptcommit) - 一个使用GPT-3编写提交信息的git prepare-commit-msg钩子。
 * [a](https://github.com/ddddddeon/a) - CLI工具，可从GPT3生成代码。
 * [plz-cli](https://github.com/m1guelpf/plz-cli) - 您的终端副驾驶
 * [aichat](https://github.com/sigoden/aichat) - 在终端中使用ChatGPT/GPT-3.5/GPT-4。
 * [rusty](https://github.com/zahidkhawaja/rusty) - GPT-3 动力的 CLI 工具，帮助您记住 bash 命令。
 * [cligpt](https://github.com/schneiderfelipe/cligpt) - cligpt是一个命令行界面，用于与OpenAI的ChatGPT API进行交互。
 * [ata](https://github.com/rikhuijzer/ata) - 在终端中询问任何事情（ATA）：在终端中输入ChatGPT
 * [acli](https://github.com/jseguillon/acli) - 辅助命令行，由Open AI的API提供动力
 * [openaigo](https://github.com/otiai10/openaigo) - OpenAI GPT3/3.5 ChatGPT API Go客户端库，简单、依赖少、经过充分测试。
 * [cligpt](https://github.com/paij0se/cligpt) - 在终端中的ChatGPT
 * [CodeGPT](https://github.com/appleboy/codegpt) - 一个使用Go语言编写的CLI，可以使用ChatGPT AI（gpt-4，gpt-3.5-turbo模型）为您编写git提交消息或进行代码审查简介，并自动安装git prepare-commit-msg钩子。
 * [search](https://github.com/visualbasic6/search) - 一个由AI（ChatGPT）编写的CLI Google客户端，通过使用Google Alerts“预览”功能绕过验证码和速率限制。
 * [chatgpt-backup](https://github.com/abacaj/chatgpt-backup) - 单个客户端脚本备份您的整个ChatGPT聊天记录历史。
 * [PowerShellAI](https://github.com/dfinke/powershellai) - PowerShell AI模块，用于OpenAI GPT-3和DALL-E。
 * [chatGPT-shell-cli](https://github.com/0xacx/chatgpt-shell-cli) - 使用终端的简单shell脚本，无需Python或JS即可使用OpenAI的ChatGPT和DALL-E。
 * [chatgpt-shell](https://github.com/xenodium/chatgpt-shell) - 最小化的ChatGPT和DALL-E Emacs外壳
 * [client](https://github.com/openai-php/client) - ⚡️ OpenAI PHP是一个超级强化的社区维护的PHP API客户端，允许您与OpenAI API进行交互。
 * [slickgpt](https://github.com/shipbit/slickgpt) - SlickGPT是一个轻量级的“使用自己的API密钥”的Web客户端，用Svelte编写，用于OpenAI API。它提供了GPT-4集成、无用户分享功能和其他超级功能。
 * [chatgpt-ui](https://github.com/wongsaang/chatgpt-ui) - 一个支持多用户、多数据库连接进行持久化数据存储、支持i18n的ChatGPT Web客户端。提供Docker镜像和快速部署脚本。
 * [openai-java](https://github.com/theokanning/openai-java) - Java中的OpenAI GPT-3 Api客户端
 * [hfuzz](https://github.com/thehlopster/hfuzz) - 用于网络模糊测试的单词列表，由多个可靠来源制作，包括：我的渗透测试结果、git.rip、ChatGPT、Lex、核心模板、网络扫描器、seclist、bo0m等等。
 * [the-art-of-command-line](https://github.com/jlevy/the-art-of-command-line) - 掌握命令行，仅需一页
 * [auto-copilot-cli](https://github.com/rsaryev/auto-copilot-cli) - Auto Copilot是一个CLI工具，它使用OpenAI模型生成命令，以实现终端和文件系统操作的目标。
 * [DelphiOpenAI](https://github.com/hemulgm/delphiopenai) - Delphi的OpenAI API客户端。使用ChatGPT、DALL-E和其他产品。
 * [free-chatgpt-client-pub](https://github.com/akl7777777/free-chatgpt-client-pub) - 一个免费的ChatGPT客户端，现在支持在线搜索。无需密钥，无需登录。多节点自动速度测量切换，长文翻译无字数限制，AI图形。
 * [duet-gpt](https://github.com/kristoferlund/duet-gpt) - 一个对话式半自主开发助手。AI配对编程，无需复制粘贴。
 * [elia](https://github.com/darrenburns/elia) - 一个使用Textual构建的终端ChatGPT客户端。
 * [README-AI](https://github.com/eli64s/readme-ai) - 🚀 生成美观且信息丰富的 README Markdown 文件的 CLI 工具。由 OpenAI 的 GPT API 提供支持 💫
 * [openai-powershell-samples](https://github.com/dfinke/openai-powershell-samples) - 🚀 我发布了我的 @OpenAI/@Azure PowerShell 示例！使用 PowerShellAI 模块，您将拥有 ChatGPT 的强大功能。在多语言交互式笔记本中探索示例。让我们重新定义 AI 的可能性！👇 #PowerShell #MSBuild
 * [TermGPT](https://github.com/sentdex/termgpt) - 赋予像GPT-4这样的LLM能够规划和执行终端命令的能力。
 * [chatgpt-cli](https://github.com/marcolardera/chatgpt-cli) - 使用官方API与ChatGPT聊天的简单而有效的命令行客户端
 * [OpenAIR](https://github.com/umatter/openair) - OpenAI R客户端
 * [ChatGPT-Midjourney](https://github.com/licoy/chatgpt-midjourney) - 🎨 一键拥有你自己的 ChatGPT+Midjourney 网页服务
 * [termGPT](https://github.com/tcapelle/termgpt) - 一个简单的Python包装器，可在终端上调用openAI的chatGPT。
 * [Chat2DB](https://github.com/alibaba/chat2db) - 🔥 🔥 🔥 一款智能、多功能的通用SQL客户端和报表工具，集成了ChatGPT功能。
 * [llm-toolbox](https://github.com/sderev/llm-toolbox) - LLM-Toolbox是一个多功能的命令行界面（CLI）工具集合，利用人工智能来执行各种任务，包括校对、识别适当的shell命令、生成自动提交信息等等。
 * [chatgpt.js](https://github.com/chatgptjs/chatgpt.js) - 🤖 ChatGPT 的强大客户端 JavaScript 库。
 * [Clippy](https://github.com/firecubestudios/clippy) - 火方块的Clippy。
 * [aider](https://github.com/paul-gauthier/aider) - aider是由GPT驱动的终端编码工具
 * [SaaS-Template-GPT](https://github.com/wasp-lang/saas-template-gpt) - 🐝 Wasp- 立即开始使用包含社交/电子邮件登录、GPT/Stripe集成、cron作业等功能的SaaS模板 → 超快速启动⚡️- `wasp db` CLI命令也是一个很好的功能，可以立即在后台启动本地的Postgres数据库。
 * [openai-cli](https://github.com/janlay/openai-cli) - 一个用BASH编写的OpenAI通用命令行界面。
 * [Chat2DB](https://github.com/chat2db/chat2db) - 🔥 🔥 🔥 一个智能且多功能的通用SQL客户端和报表工具，集成了ChatGPT功能。
 * [gpt-web-terminal](https://github.com/ltyzzzxxx/gpt-web-terminal) - ✨ 以程序员的方式打开ChatGPT！GPT终端是一个平台，允许您在终端中与GPT进行通信。
 * [chatgpt-web](https://github.com/dqzboy/chatgpt-web) - ChatGPT 网页一键部署
 * [tgpt](https://github.com/aandrew-me/tgpt) - 在终端中使用ChatGPT而无需API密钥
 * [chatgpt-cli](https://github.com/kardolus/chatgpt-cli) - ChatGPT CLI是OpenAI的ChatGPT的高级命令行界面，提供流式传输、查询模式和历史记录跟踪，实现无缝和上下文感知的对话。非常适合用户和开发人员使用，它提供高级配置和简单设置选项，以确保与GPT模型的对话体验量身定制。
 * [lobe-commit](https://github.com/lobehub/lobe-commit) - 💌 Lobe Commit 是一个使用 Langchain/ChatGPT 来生成基于 Gitmoji 的提交信息的命令行工具。
 * [SuperSummarizeAI](https://github.com/alexandrevl/supersummarizeai) - 使用SuperSummarizeAI释放人工智能的力量！轻松地使用ChatGPT从网页和YouTube视频中提取、压缩和剪辑内容。将无尽的内容转化为易于理解的摘要。
 * [minion](https://github.com/mikaelvesavuori/minion) - 开发者在命令行界面中使用ChatGPT的最简单和最轻量级的方式。
 * [chai-ruby](https://github.com/rogueocelot/chai-ruby) - 使用您选择的终端模拟器，进入GNOME Files中打开的目录。
 * [llm-code-interpreter](https://github.com/e2b-dev/llm-code-interpreter) - 由E2B提供的AI游乐场驱动。强化版的ChatGPT代码解释器。运行任何语言，任何终端进程，自由使用文件系统。同时具备互联网访问功能。
 * [lobe-chat](https://github.com/lobehub/lobe-chat) - 🤖 Lobe Chat - 一个开源、可扩展（函数调用）的高性能聊天机器人框架。它支持一键免费部署您的私人ChatGPT/LLM网页应用程序。
 * [paperify](https://github.com/jstrieb/paperify) - 将任何文档、网页或电子书转化为研究论文（无需ChatGPT）。
 * [cli](https://github.com/bashsenpai/cli) - BashSenpai是由ChatGPT驱动的终端助手。
 * [unit-runtime](https://github.com/unit-mesh/unit-runtime) - Unit Runtime 是一个高效且用户友好的 AI 代码执行环境，可一键启动并实时交互，帮助您快速构建和测试 AI 代码。
 * [aih](https://github.com/databingo/aih) - 在终端中与AI模式进行对话。Bard|GPT3.5|Claude2|Llama2|Falcon180
 * [Sense](https://github.com/f0x1d/sense) - 支持ChatGPT的Android版OpenAI客户端
 * [sparrow](https://github.com/soulteary/sparrow) - ChatGPT风格的客户端兼容后端服务器，开源实现。
 * [chatgpt-md-translator](https://github.com/smikitky/chatgpt-md-translator) - 使用ChatGPT API将Markdown文档翻译为CLI
 * [ollama-webui](https://github.com/ollama-webui/ollama-webui) - ChatGPT-Style响应式聊天Web UI客户端（GUI）用于Ollama 🦙
 * [BibiGPT-v1](https://github.com/jimmylv/bibigpt-v1) - BibiGPT v1 · 一键AI摘要音视频和聊天学习内容：哔哩哔哩 | YouTube | 推特 | 抖音 | 快手 | 百度网盘 | 谷歌云盘 | 本地文件 | 网站 | 播客 | 会议 | 讲座等。音视频内容AI一键总结和对话：哔哩哔哩 | YouTube | 推特 | 小红书 | 抖音 | 快手 | 百度网盘 | 阿里云盘 | 网页 | 播客 | 会议 | 讲座等（原BiliGPT省流神器和AI课代表）。
 * [open-interpreter](https://github.com/killianlucas/open-interpreter) - 在您的终端中运行的OpenAI代码解释器
 * [chatgpt-java](https://github.com/grt1228/chatgpt-java) - ChatGPT Java SDK支持流式输出、Gpt插件、联网。支持OpenAI官方所有接口。ChatGPT的Java客户端。OpenAI GPT-3.5-Turb GPT-4  Java Api客户端。ChatGPT Java SDK支持流式输出、Gpt插件、联网。支持OpenAI官方所有接口。ChatGPT的Java客户端。OpenAI GPT-3.5-Turb GPT-4  Java Api客户端。
 * [llm-workflow-engine](https://github.com/llm-workflow-engine/llm-workflow-engine) - LLMs的Power CLI和工作流管理器（核心包）
 * [openai-kotlin](https://github.com/aallam/openai-kotlin) - 具有多平台和协程功能的Kotlin的OpenAI API客户端。
 * [sqlchat](https://github.com/sqlchat/sqlchat) - 聊天式SQL客户端和编辑器，面向未来十年。
 * [ShellGPT](https://github.com/akl7777777/shellgpt) - **ShellGPT是一个免费的chatgpt客户端，现在支持在线搜索，无需密钥，无需登录。多节点自动测速切换，长文翻译没有字数限制，AI出图。**
 * [gptel](https://github.com/karthink/gptel) - 一个简单的Emacs LLM客户端
 * [OpenAI-DotNet](https://github.com/rageagainstthepixel/openai-dotnet) - 一个非官方的DotNet OpenAI RESTful API客户端
 * [every-chatgpt-gui](https://github.com/billmei/every-chatgpt-gui) - 每个ChatGPT的前端GUI客户端
 * [yai](https://github.com/ekkinox/yai) - 您的AI 动力终端助手。
 * [gpt-cli](https://github.com/kharvd/gpt-cli) - ChatGPT的命令行界面，Claude和Bard
 * [Gemini](https://github.com/kyegomez/gemini) - 谷歌将“超越ChatGPT”的Gemini模型的开源实现
 * [MoneyPrinterTurbo](https://github.com/harry0703/moneyprinterturbo) - 利用AI大模型，一键生成高清短视频。
 * [zap-gpt](https://github.com/marcusgoncalvess/zap-gpt) - 这个项目探索了将ChatGPT与WhatsApp集成，将聊天机器人转变为一个能够与朋友交谈、回答客户问题等任务的虚拟助手，让对话更具人性化。
 * [zap-gpt-free](https://github.com/marcusgoncalvess/zap-gpt-free) - 这个项目探索了将ChatGPT与WhatsApp集成，将聊天机器人转变为一个能够与朋友交谈、回答客户问题等任务的虚拟助手，让对话更具人性化。
 * [chatAir](https://github.com/flyun/chatair) - ☁️OpenAI 和 Gemini 的原生安卓客户端 ☁️
 * [matrix-chatgpt-bot](https://github.com/matrixgpt/matrix-chatgpt-bot) - 通过任何Matrix客户端与ChatGPT交谈！
 * [lobe-cli-toolbox](https://github.com/lobehub/lobe-cli-toolbox) - 🪀 Lobe CLI工具箱 - AI CLI工具箱，提高git提交和i18n工作流效率
 * [openai-scala-client](https://github.com/cequence-io/openai-scala-client) - Scala客户端用于OpenAI API
 * [ChatGPTCLIBot](https://github.com/lagpixellol/chatgptclibot) - 使用嵌入技术支持的长期记忆功能，在CLI中与ChatGPT Bot交流。
 * [openai4j](https://github.com/lambdua/openai4j) - Java客户端库用于OpenAI API。完全支持所有OpenAI API模型，包括Completions，Chat，Edits，Embeddings，Audio，Files，Assistants-v2，Images，Moderations，Batch和Fine-tuning。
 * [json-translator](https://github.com/mololab/json-translator) - jsontt 💡 - AI JSON翻译器，配备GPT +其他免费翻译模块，可将您的json/yaml文件翻译成其他语言 ✅ 查看自述文件 ✌ 支持GPT / DeepL / Google / Bing / Libre / Argos
 * [gptme](https://github.com/erikbjare/gptme) - 与配备本地工具的LLMs聊天：执行Python和Bash，编辑本地文件，浏览网页。
 * [Apt](https://github.com/rnchg/apt) - AI生产力工具-免费开源，提高用户生产力同时确保隐私和数据安全。它提供高效便捷的AI解决方案，包括但不限于：内置独家ChatGPT，一键批量智能处理。
 * [chatgpt-subtitle-translator](https://github.com/cerlancism/chatgpt-subtitle-translator) - 基于ChatGPT API的高效翻译工具
 * [tenere](https://github.com/pythops/tenere) - 🔥 用Rust编写的LLMs的TUI界面
 * [Chat2DB](https://github.com/codephiliax/chat2db) - 🔥🔥🔥基于人工智能的数据库工具和SQL客户端，最热门的图形用户界面客户端，支持MySQL、Oracle、PostgreSQL、DB2、SQL Server、SQLite、H2、ClickHouse等等。
 * [OpenHands](https://github.com/all-hands-ai/openhands) - 🙌 OpenHands: 编码更少，创造更多
 * [ai-digest](https://github.com/khromov/ai-digest) - 一个CLI工具，可以将您的代码库聚合到一个单独的Markdown文件中，以供Claude项目或自定义ChatGPT使用。
 * [web-mirai-panel](https://github.com/zmh-program/web-mirai-panel) - 🍉 ChatGPT Mirai QQ Bot 机器人的 Web UI 一键配置，支持多实例管理，配置编辑，文件提交，健康检查，终端执行，支持密码访问。🍉
 * [Nexior](https://github.com/acedatacloud/nexior) - 一键部署您自己的AI应用Web UI，包括GPT、Midjourney、ChatDoc、QrArt等，轻松赚取利润。
 * [aider](https://github.com/aider-ai/aider) - aider是您终端中的AI对编程
 * [laravel](https://github.com/openai-php/laravel) - ⚡️ OpenAI PHP for Laravel 是一个强大的 PHP API 客户端，可以让您与 OpenAI API 进行交互。
 * [WrenAI](https://github.com/canner/wrenai) - 🚀 用于文本到SQL的开源SQL AI代理。支持PostgreSQL、DuckDB、MySQL、MS SQL、ClickHouse、Trino、JSON、CSV、Parquet数据源等等！🚀
 * [Queryable](https://github.com/mazzzystar/queryable) - 在iOS上运行OpenAI的CLIP和Apple的MobileCLIP模型来搜索照片。
 * [ChatGPTs](https://github.com/licoy/chatgpts) - 🍭 一键拥有你自己的ChatGPT+众多AI网页服务 | 一键访问您自己的ChatGPT+多种AI网页服务
 * [ChatAny](https://github.com/licoy/chatany) - 🌻 一键拥有您自己的ChatGPT+许多AI网页服务
 * [ChatAny](https://github.com/chatanyteam/chatany) - 🌻 一键拥有您自己的ChatGPT+许多AI网页服务
 * [cz-git](https://github.com/zhengqbbb/cz-git) - cz-git | czg 🛠️ DX 首选和更工程化，轻量级，可定制，标准输出格式的 Commitizen 适配器和 CLI
 * [cherry-studio](https://github.com/kangfenmao/cherry-studio) - 🍒 Cherry Studio 是一个桌面客户端，支持多个LLM提供商。
 * [plandex](https://github.com/plandex-ai/plandex) - 在您的终端上进行AI驱动的开发。专为大型、真实世界的任务设计。
 * [PDFMathTranslate](https://github.com/byaidu/pdfmathtranslate) - 基于 AI 完整保留格式的 PDF 科学论文翻译 - 支持 Google/DeepL/Ollama/OpenAI 等服务的 PDF 文档全文双语翻译，提供 CLI/GUI/Docker
 * [gpt-engineer](https://github.com/gpt-engineer-org/gpt-engineer) - 用于实验AI软件工程师的平台。基于终端。注意：与https://gptengineer.app非常不同。
 * [whisper-ctranslate2](https://github.com/softcatala/whisper-ctranslate2) - 基于CTranslate2的原始OpenAI客户端兼容的Whisper命令行客户端。输出：基于CTranslate2的原始OpenAI客户端兼容的Whisper命令行客户端。


## Reimplementations

 * [PaLM-rlhf-pytorch](https://github.com/lucidrains/palm-rlhf-pytorch) - 在PaLM架构之上实现RLHF（人类反馈强化学习）。基本上是ChatGPT，但使用了PaLM。
 * [minGPT](https://github.com/karpathy/mingpt) - 一个最小化的PyTorch重新实现OpenAI GPT（生成预训练变压器）训练。
 * [mm-cot](https://github.com/amazon-science/mm-cot) - “语言模型中的多模态思维链推理”官方实现已发布（敬请关注，更多内容将会更新）。
 * [picoGPT](https://github.com/jaymody/picogpt) - 一个不必要的小型GPT-2实现，使用NumPy编写。
 * [gpt-neox](https://github.com/eleutherai/gpt-neox) - 基于DeepSpeed库在GPU上实现的模型并行自回归变压器。
 * [GPTZero](https://github.com/burhanultayyab/gptzero) - GPTZero的开源实现
 * [SpikeGPT](https://github.com/ridgerchu/spikegpt) - “SpikeGPT: 带有脉冲神经网络的生成式预训练语言模型的实现”
 * [ml-ane-transformers](https://github.com/apple/ml-ane-transformers) - 针对苹果神经引擎（ANE）优化的Transformer架构参考实现。
 * [memorizing-transformers-pytorch](https://github.com/lucidrains/memorizing-transformers-pytorch) - 使用Pytorch实现记忆Transformer（ICLR 2022），通过近似最近邻索引和检索增强的注意力网络，用于记忆。
 * [lit-llama](https://github.com/lightning-ai/lit-llama) - 基于nanoGPT的LLaMA语言模型实现。支持闪存注意力、Int8和GPTQ 4位量化、LoRA和LLaMA-Adapter微调、预训练。采用Apache 2.0许可证。
 * [large-model-parallelism](https://github.com/hundredblocks/large-model-parallelism) - 主要模型并行方法的功能本地实现
 * [bloomz.cpp](https://github.com/nouamanetazi/bloomz.cpp) - BLOOM的C++实现
 * [swift-coreml-transformers](https://github.com/huggingface/swift-coreml-transformers) - Swift Core ML 3 实现了 GPT-2、DistilGPT-2、BERT 和 DistilBERT 用于问答。其他 Transformer 即将推出！
 * [lit-parrot](https://github.com/lightning-ai/lit-parrot) - 基于nanoGPT的StableLM/Pythia/INCITE语言模型的实现。支持闪存注意力、LLaMA-Adapter微调、预训练。采用Apache 2.0许可证。
 * [gpt-code-ui](https://github.com/ricklamers/gpt-code-ui) - OpenAI的ChatGPT代码解释器的开源实现
 * [DragGAN](https://github.com/zeqiang-lai/draggan) - 在线演示和实现DragGAN - “拖动您的GAN：在生成图像流形上进行交互式基于点的操作”
 * [femtoGPT](https://github.com/keyvank/femtogpt) - 一个最小化的生成预训练变压器的纯Rust实现。
 * [lit-gpt](https://github.com/lightning-ai/lit-gpt) - 可黑客实现的基于nanoGPT的最先进开源LLMs。支持闪存注意力、Int8和GPTQ 4位量化、LoRA和LLaMA-Adapter微调、预训练。Apache 2.0许可。
 * [exllama](https://github.com/turboderp/exllama) - 一个更节省内存的重写版本，用于使用量化权重的Llama的HF变压器实现。
 * [AStarNet](https://github.com/deepgraphlearning/astarnet) - 官方实现的A*网络
 * [codeinterpreter-api](https://github.com/shroominic/codeinterpreter-api) - ChatGPT代码解释器的开源实现 👾
 * [Local-Code-Interpreter](https://github.com/mrgreyfun/local-code-interpreter) - 一个本地实现的OpenAI ChatGPT代码解释器。
 * [ChatPiXiu](https://github.com/openllmai/chatpixiu) - ChatPiXiu：OpenLLMAI的文档。调查、复制和领域/任务适应开源chatgpt替代品/实现。PiXiu-貔貅意味着财富。
 * [vall-e](https://github.com/lifeiteng/vall-e) - VALL-E（零样本文本到语音）的PyTorch实现，复现演示https://lifeiteng.github.io/valle/index.html
 * [textgen](https://github.com/shibing624/textgen) - 文本生成模型，包括LLaMA、BLOOM、GPT2、BART、T5、SongNet等的实现。可以进行训练和预测，方便使用。
 * [LaMDA-rlhf-pytorch](https://github.com/conceptofmind/lamda-rlhf-pytorch) - 使用PyTorch实现Google LaMDA的开源预训练模型。添加类似于ChatGPT的RLHF。
 * [langchain](https://github.com/brainlid/langchain) - Elixir实现LangChain风格框架。
 * [kan-gpt](https://github.com/adityang/kan-gpt) - 使用 Kolmogorov-Arnold 网络 (KANs) 对生成式预训练变压器 (GPTs) 进行 PyTorch 实现，用于语言建模。
 * [TextRL](https://github.com/voidful/textrl) - 在huggingface的transformer（blommz-176B/bloom/gpt/bart/T5/MetaICL）上实现ChatGPT RLHF（强化学习与人类反馈）。
 * [ShareGPT4Video](https://github.com/sharegpt4omni/sharegpt4video) - ShareGPT4Video的官方实现：通过更好的字幕改进视频理解和生成
 * [GPT2](https://github.com/affjljoo3581/gpt2) - PyTorch实现OpenAI GPT-2
 * [T2M-GPT](https://github.com/mael-zys/t2m-gpt) - （CVPR 2023）Pytorch实现“T2M-GPT：使用离散表示从文本描述生成人体动作”
 * [stable-baselines3](https://github.com/dlr-rm/stable-baselines3) - PyTorch版本的Stable Baselines，强化学习算法的可靠实现。
 * [WhisperLive](https://github.com/collabora/whisperlive) - OpenAI的Whisper的近乎实时实现。
 * [GenAI_Agents](https://github.com/nirdiamant/genai_agents) - 该存储库提供了各种生成式AI代理技术的教程和实现，从基础到高级。它是构建智能、交互式AI系统的全面指南。


## Tutorials

 * [Hello-Python](https://github.com/mouredev/hello-python) - 从零开始学习Python编程语言的课程，适合初学者。超过30个课程，25小时的视频，代码和聊天群组。从基础知识到创建具有数据库的API后端等等...
 * [notebooks](https://github.com/dataflowr/notebooks) - 深度学习课程代码
 * [gpt4all-colab](https://github.com/camenduru/gpt4all-colab) - 🔥gpt4all（最好的chatgpt克隆版）在本地和colab教程上运行 - 到@camenduru的colab -
 * [X-Decoder](https://github.com/microsoft/x-decoder) - 学习Q#和量子计算的教程和编程练习
 * [AI-Powered-Video-Tutorial-Generator](https://github.com/akshitireddy/ai-powered-video-tutorial-generator) - 使用角色动画和幻灯片创建AI生成的视频教程！
 * [semantic-kernel-rag-chat](https://github.com/azure-samples/semantic-kernel-rag-chat) - ChatGPT + 企业数据与语义内核的教程，OpenAI 和 Azure Cognitive Search
 * [alexa-gpt](https://github.com/k4l1sh/alexa-gpt) - 如何在Alexa中使用ChatGPT的教程
 * [qxresearch-event-1](https://github.com/qxresearch/qxresearch-event-1) - Python实践教程，包含50多个Python应用程序（10行代码）@xiaowuc2
 * [leedl-tutorial](https://github.com/datawhalechina/leedl-tutorial) - 《李宏毅深度学习教程》，PDF下载地址：https://github.com/datawhalechina/leedl-tutorial/releases
 * [bpf-developer-tutorial](https://github.com/eunomia-bpf/bpf-developer-tutorial) - 通过示例学习 eBPF | eBPF 开发者教程与知识库：通过小工具和示例一步步学习 eBPF，包含性能、网络、安全等多种应用场景
 * [tensorflow-nlp-tutorial](https://github.com/ukairia777/tensorflow-nlp-tutorial) - 使用tensorflow进行文本预处理，整理了最新模型的下游任务，如主题模型、BERT、GPT、LLM等的Deep Learning NLP存储库。
 * [langchain-kr](https://github.com/teddylee777/langchain-kr) - 通过LangChain官方文档、Cookbook以及其他实用示例编写的韩语教程。通过本教程，您可以学习如何更轻松、更有效地使用LangChain。
 * [llm-python](https://github.com/onlyphantom/llm-python) - 大型语言模型（LLMs）教程和示例脚本，ft. langchain，openai，llamaindex，gpt，chromadb和pinecone
 * [Play-with-LLMs](https://github.com/evilpsycho/play-with-llms) - 关于如何训练、评估LLMs，并利用RAG、Agent、Chain构建有趣的应用程序的教程。
 * [zero_to_gpt](https://github.com/vikparuchuri/zero_to_gpt) - 从零开始学习深度学习，实现GPT。


## NLP

 * [BioGPT](https://github.com/microsoft/biogpt) - 微软研究院发布了Biogpt，这是一个在生物医学研究文献上训练的大型语言模型。该模型在回答生物医学文献问题方面表现优于人类，经过PubMedQA评估。该模型的代码…
 * [stanford_alpaca](https://github.com/tatsu-lab/stanford_alpaca) - 用于训练斯坦福大学Alpaca模型和生成数据的代码和文档。
 * [openai-python](https://github.com/openai/openai-python) - OpenAI Python 库为使用 Python 语言编写的应用程序提供方便的访问 OpenAI API 的方式。
 * [FlexGen](https://github.com/fminference/flexgen) - 在单个GPU上运行大型语言模型以实现吞吐量导向的场景。
 * [RWKV-LM](https://github.com/blinkdl/rwkv-lm) - RWKV是具有变压器级别LLM性能的RNN。它可以像GPT一样直接进行训练（可并行化）。因此，它结合了RNN和变压器的优点-出色的性能、快速推理、节省VRAM、快速训练、“无限”ctx_len和免费的句子嵌入。
 * [mario-gpt](https://github.com/shyamsn97/mario-gpt) - 使用GPT2生成马里奥关卡。论文“MarioGPT：通过大型语言模型进行开放式文本生成关卡”的代码。https://arxiv.org/abs/2302.05981
 * [bilingual_book_maker](https://github.com/yihong0618/bilingual_book_maker) - 使用人工智能翻译制作双语epub书籍
 * [llm-security](https://github.com/greshake/llm-security) - 打破应用程序集成的LLM的新方法
 * [GLM-130B](https://github.com/thudm/glm-130b) - GLM-130B：一个开放的双语预训练模型（ICLR 2023）
 * [trlx](https://github.com/carperai/trlx) - 一个用强化学习和人类反馈进行语言模型分布式训练的代码库（RLHF）。
 * [ChatGLM-6B](https://github.com/thudm/chatglm-6b) - ChatGLM-6B：开源双语对话语言模型 | 一个开放的双语对话语言模型
 * [GPTSAN](https://github.com/tanreinama/gptsan) - 通用开关变压器基于日语的语言模型
 * [gpt-2](https://github.com/openai/gpt-2) - 论文《语言模型是无监督多任务学习者》的代码
 * [gptlang](https://github.com/forrestchang/gptlang) - 由GPT-4实现的新编程语言。
 * [BIG-bench](https://github.com/google/big-bench) - 超越模仿游戏的协作基准，用于测量和推断语言模型的能力。
 * [hlb-gpt](https://github.com/tysam-code/hlb-gpt) - 一个极简、快速、适合实验的研究者工具箱，用不到365行代码实现GPT模型。在单个A100上，仅需约138秒即可将Wikitext-103的验证损失降至小于3.8。
 * [hn_summary](https://github.com/jiggy-ai/hn_summary) - 使用大型语言模型总结Hacker News的头条新闻，并将它们发布到Telegram频道。
 * [transformers](https://github.com/huggingface/transformers) - 🤗 Transformers：Pytorch、TensorFlow和JAX的最先进机器学习技术。
 * [self-instruct](https://github.com/yizhongw/self-instruct) - 将预训练语言模型与自身生成的指令数据对齐。
 * [knowledge_gpt](https://github.com/mmz-001/knowledge_gpt) - 您的文件将获得准确的答案和即时引用。
 * [lqae](https://github.com/lhao499/lqae) - 语言量化自编码器
 * [stanford_alpaca](https://github.com/tatsu-lab/stanford_alpaca#fine-tuning) - 用于训练斯坦福大学Alpaca模型和生成数据的代码和文档。
 * [fib](https://github.com/r-three/fib) - “bloom”、“opt-175b”、“t0”和“gpt-neox”是否“事实上一致”？新的预印本！我们介绍了“事实不一致基准测试”（FIB），并评估了23个LLM。与@anisham197 @byryuer @mohitban47 @colinraffel一起完成的工作📄 💾 🧵 ⬇️
 * [petals](https://github.com/bigscience-workshop/petals) - 🌸 在家运行100B+语言模型，类似于BitTorrent。微调和推理速度比卸载快10倍。
 * [emailGPT](https://github.com/lucasmccabe/emailgpt) - 使用ChatGPT快速轻松生成电子邮件的界面
 * [gpt3-contextual](https://github.com/uezo/gpt3-contextual) - 使用OpenAI API的GPT-3模型进行上下文聊天
 * [camel](https://github.com/lightaime/camel) - CAMEL：用于大规模语言模型社会“思维”探索的交流代理。
 * [pubmed-gpt](https://github.com/arokem/pubmed-gpt) - 使用GPT对PubMed查询的摘要进行总结。
 * [haltt4llm](https://github.com/manyoso/haltt4llm) - 这个项目旨在创建一个通用的度量标准，以测试LLM在消除幻觉方面的进展，这是目前广泛采用LLM的许多实际目的中最严重的问题。
 * [olm-datasets](https://github.com/huggingface/olm-datasets) - 从网络中提取和处理在线语言模型预训练数据的管道
 * [sat-reading](https://github.com/jquesnelle/sat-reading) - 新博客：语言模型与SAT阅读测试！它们得分约为90％，Flan-T5与GPT-3.5一样好！微调效果更好！所有详细信息都在此处提供，包括一个带有问题（+模型）的新Huggingface数据集：
 * [tenetlang](https://github.com/tenetlang/tenetlang) - 一种为人类设计的GPT语言
 * [ebook-GPT-translator](https://github.com/jesselau76/ebook-gpt-translator) - 享受用你喜欢的风格阅读。
 * [srt-gpt-translator](https://github.com/jesselau76/srt-gpt-translator) - 字幕翻译器
 * [datasloth](https://github.com/ibestvina/datasloth) - 自然语言Pandas查询和由GPT-3驱动的数据生成。
 * [trl](https://github.com/lvwerra/trl) - 使用强化学习训练变压器语言模型。
 * [ChatGPT-vs.-BERT](https://github.com/whu-zqh/chatgpt-vs.-bert) - 🎁【ChatGPT4NLU】ChatGPT和Fine-tuned BERT的比较研究
 * [unilm](https://github.com/microsoft/unilm) - 跨任务、语言和模态的大规模自监督预训练
 * [document.ai](https://github.com/ganymedenil/document.ai) - 基于向量数据库与GPT3.5的通用本地知识库方案
 * [LAVIS](https://github.com/salesforce/lavis) - LAVIS - 一站式语言视觉智能图书馆
 * [gpt-subtrans](https://github.com/machinewrapped/gpt-subtrans) - 使用OpenAI/ChatGPT项目翻译字幕文件。
 * [paper-qa](https://github.com/whitead/paper-qa) - 用于从带有引用文献的文档中回答问题的LLM链
 * [guardrails](https://github.com/shreyar/guardrails) - 为大型语言模型添加护栏。
 * [chatgpt-document-extraction](https://github.com/brandonrobertz/chatgpt-document-extraction) - 一个概念验证工具，可使用ChatGPT将混乱的文本文档转换为结构化的JSON。
 * [h2ogpt](https://github.com/h2oai/h2ogpt) - 加入运动，成为由H2O.ai领导的世界最佳开源GPT的一员。
 * [LLMZoo](https://github.com/freedomintelligence/llmzoo) - ⚡LLM动物园是一个项目，为大型语言模型提供数据、模型和评估基准。⚡
 * [INSIGHT](https://github.com/oneil512/insight) - INSIGHT是一种自主的人工智能，可以进行医学研究！
 * [h2o-llmstudio](https://github.com/h2oai/h2o-llmstudio) - H2O LLM Studio - 一个用于微调LLMs的框架和无代码GUI
 * [nlp-resume-parser](https://github.com/hxu296/nlp-resume-parser) - 基于NLP技术，启用GPT-3的简历解析器，可将PDF格式转换为JSON格式。
 * [chatgpt-clone](https://github.com/xtekky/chatgpt-clone) - ChatGPT界面更好的用户界面
 * [camel](https://github.com/lightaime/camel#data-hosted-on-hugging-face) - 🐫 骆驼：用于大规模语言模型社会“思维”探索的交流代理
 * [auto-redteam](https://github.com/traghav/auto-redteam) - 使用其他LLMs进行红队模拟
 * [self-ask](https://github.com/ofirpress/self-ask) - 《测量和缩小语言模型中的组合性差距》的代码和数据
 * [llm-lobbyist](https://github.com/johnnay/llm-lobbyist) - 论文代码：“大型语言模型作为企业游说者”（2023年）。
 * [Transformers-Tutorials](https://github.com/nielsrogge/transformers-tutorials) - 这个仓库包含我使用HuggingFace的Transformers库制作的演示。
 * [dsp](https://github.com/stanfordnlp/dsp) - 𝗗𝗦𝗣：演示-搜索-预测。一个用于组合检索和语言模型的框架，用于知识密集型自然语言处理。
 * [OpenAGI](https://github.com/agiresearch/openagi) - OpenAGI：当LLM遇见领域专家
 * [GraphGPT](https://github.com/varunshenoy/graphgpt) - 使用GPT-3从非结构化文本中推断知识图谱 🕵️‍♂️
 * [backend-GPT](https://github.com/theappletucker/backend-gpt) - 6/ “gpt是后端所需的全部”：使用LLM帮助您编写后端。Wired：LLM是最近规模黑客马拉松中一个激动人心的项目。LLM后端将状态作为JSON blob，并根据...英文描述进行修改。
 * [gpt-commit-summarizer](https://github.com/kanhari/gpt-commit-summarizer) - 基于GPT的工具，可以为您编写提交信息。
 * [tesseract.js](https://github.com/naptha/tesseract.js) - 超过100种语言的纯JavaScript OCR 📖🎉🖥
 * [subtitle-translator](https://github.com/gnehs/subtitle-translator) - 使用ChatGPT翻译字幕
 * [vault-ai](https://github.com/pashpashpash/vault-ai) - OP Vault ChatGPT：使用OP Stack（OpenAI + Pinecone Vector Database）为ChatGPT提供长期记忆。使用简单的React前端上传自己的自定义知识库文件（PDF、txt等）。
 * [ai-code-translator](https://github.com/mckaywrigley/ai-code-translator) - 使用人工智能将代码从一种语言翻译成另一种语言。
 * [chatgpt-i18n](https://github.com/observedobserver/chatgpt-i18n) - 使用AI辅助翻译您的本地化JSON文件。
 * [flux](https://github.com/transmissions11/flux) - LLM 电动工具
 * [platform](https://github.com/cognosisai/platform) - @erikschluntz 当我去年夏天最初玩GPT-3代理时（您可以在此处看到一个示例： whereby您可以为具有访问JavaScript REPL的GPT-3代理提供要完成的目标），那就是我最终的目标，我认为那并不是那么...
 * [minds](https://github.com/dosco/minds) - MindsJS - 轻松构建AI驱动的工作流程
 * [FreedomGPT](https://github.com/ohmplatform/freedomgpt) - 这个代码库是为了一个基于React和Electron的应用程序，它使用基于Alpaca Lora的聊天界面在Mac和Windows上本地执行FreedomGPT LLM（离线和私密）。
 * [chart-gpt](https://github.com/whoiskatrin/chart-gpt) - 基于文本输入构建图表的AI工具
 * [alpaca.cpp](https://github.com/antimatter15/alpaca.cpp) - 本地运行指令调整的聊天式LLM
 * [ChatARKit](https://github.com/trzy/chatarkit) - 使用ChatGPT自然语言创建AR体验。
 * [alpaca.cpp](https://github.com/rupeshs/alpaca.cpp) - 本地运行指令调整的聊天式LLM（Android/Linux/Windows/Mac）
 * [rust-bert](https://github.com/guillaume-be/rust-bert) - Rust原生的即用型NLP管道和基于转换器的模型（BERT、DistilBERT、GPT2等）
 * [PentestGPT](https://github.com/greydgl/pentestgpt) - 一款由GPT驱动的渗透测试工具
 * [gpttools](https://github.com/jameshwade/gpttools) - gpttools扩展了gptstudio的功能，用于包开发，帮助您记录代码，编写测试，甚至解释代码。
 * [semantic-kernel](https://github.com/microsoft/semantic-kernel) - 快速轻松地将尖端的LLM技术集成到您的应用程序中。
 * [CoCoGen](https://github.com/madaan/cocogen) - 如果将自然语言问题转换为伪Python代码，Codex在某些NLP任务中表现比GPT-3和T5更好！这个研究是由@aman_madaan领导，与@shuyanzhxyc、杨一鸣、@gneubig和我一起参与，将在#emnlp2022上展示。
 * [github-summarizer](https://github.com/stevebauman/github-summarizer) - 一个使用Chat GPT的PHP GitHub总结工具。
 * [LSL-snippets](https://github.com/panterapolnocy/lsl-snippets) - 我编写（或修改）的小型脚本，使用Linden脚本语言（LSL），用于Second Life。
 * [HealthGPT](https://github.com/stanfordbdhg/healthgpt) - 使用自然语言查询您的苹果健康数据 💬 🩺
 * [pdf-epub-GPT-translator](https://github.com/jesselau76/pdf-epub-gpt-translator) - 学习 Python + Flask
 * [gpt-3](https://github.com/openai/gpt-3) - GPT-3：语言模型是少样本学习者
 * [GPT-4-LLM](https://github.com/instruction-tuning-with-gpt-4/gpt-4-llm) - 我们的“使用GPT-4进行指令调整”的总结很好！@omarsar0生成的指令跟随和反馈数据已发布，导致了更优秀的自我指导学习模型。请继续关注我们在GitHub存储库中的更多更新。
 * [siri-chatgpt](https://github.com/liujch1998/siri-chatgpt) - 现在你可以将Siri转换成真正的#chatgpt！只需下载此快捷方式（链接在存储库中⬇️）到您的iPhone，编辑快捷方式应用程序中的脚本（即将您的API密钥粘贴到文本框中），然后说：“嘿Siri，chatgpt”。问你最喜欢的问题！
 * [gpt-jargon](https://github.com/jbrukh/gpt-jargon) - 术语是一种自然语言编程语言，由像GPT-4这样的LLM指定和执行。
 * [practical-llms](https://github.com/aggregate-intellect/practical-llms) - #aiscllmworkshop 从零到危险的快速方式（就像能够自信地胡说八道像chatgpt一样，但也可以快速上手最新最伟大的llm，用9个连续小时的一小时演示来实现从想法到产品的转变！
 * [happycommit](https://github.com/jackbackes/happycommit) - HappyCommit是一款令人愉悦的工具，利用OpenAI的GPT-3.5 Turbo语言模型的强大功能，为您生成有意义且描述性强的Git提交信息。
 * [JamesGPT](https://github.com/jconorgrogan/jamesgpt) - ChatGPT越狱：预测未来，发表政治和有争议的话题的意见，评估真相。可能有助于我们更好地了解LLM偏见。
 * [ChatPaper](https://github.com/kaixindelele/chatpaper) - 使用ChatGPT对arXiv论文进行总结，加速整个科研流程，包括润色、审稿和审稿回复。
 * [minichain](https://github.com/srush/minichain) - 带有LSTM编码器/解码器和注意力机制的序列到序列模型。
 * [AutoPR](https://github.com/irgolic/autopr) - 修复由ChatGPT驱动的AI生成的拉取请求问题。
 * [privateGPT](https://github.com/imartinez/privategpt) - 使用GPT的强大功能私密地与您的文档互动，100％私密，无数据泄漏。
 * [SalesGPT](https://github.com/filip-michalsky/salesgpt) - 上下文感知的人工智能销售代理，自动化销售推广。
 * [automated-interpretability](https://github.com/openai/automated-interpretability) - LLMs可以解释其他LLMs中的神经元通过展示GPT-4（标记，激活）对来解释GPT-2神经元的行为基于与GPT-4的解释模拟神经元的激活根据模拟激活与真实激活的匹配程度评分解释
 * [evalplus](https://github.com/evalplus/evalplus) - EvalPlus用于严格评估LLM合成的代码。
 * [chat2plot](https://github.com/nyanp/chat2plot) - 使用LLM进行聊天可视化
 * [databerry](https://github.com/gmpetrov/databerry) - 构建定制LLM代理的无代码平台
 * [guidance](https://github.com/microsoft/guidance) - 控制大型语言模型的指导语言。
 * [SmartPilot](https://github.com/jaredkirby/smartpilot) - 一个使用OpenAI语言模型生成、分析和选择给定问题最佳答案的Python程序。
 * [developer](https://github.com/smol-ai/developer) - 随着100k上下文窗口的到来，现在每个开发者都有自己的小型开发者是可行的。
 * [pyllms](https://github.com/kagisearch/pyllms) - 最小的Python库，可连接到LLMs（OpenAI，Anthropic，AI21，Cohere，Aleph Alpha，HuggingfaceHub，Google PaLM2），并带有内置的模型性能基准测试。
 * [llm-numbers](https://github.com/ray-project/llm-numbers) - 每个LLM开发者都应该知道的数字
 * [StructGPT](https://github.com/rucaibox/structgpt) - "StructGPT: 一个通用框架，用于大型语言模型在结构化数据上进行推理的代码和数据"
 * [scikit-llm](https://github.com/iryna-kondr/scikit-llm) - 无缝集成强大的语言模型，如ChatGPT，到scikit-learn中，以增强文本分析任务。
 * [zeno-build](https://github.com/zeno-ml/zeno-build) - 构建、评估、分析和理解基于LLM的应用程序。
 * [privateGPT](https://github.com/imartinez/privategpt?utm_source=tldrnewsletter) - 使用GPT的强大功能私密地与您的文档互动，100％私密，无数据泄漏。
 * [Chat-with-Document-s-using-ChatGPT-API-and-Text-Embedding](https://github.com/appointat/chat-with-document-s-using-chatgpt-api-and-text-embedding) - 使用ChatGPT API和文本嵌入与文档进行聊天
 * [qlora](https://github.com/artidoro/qlora) - QLoRA：量化LLM的高效微调
 * [BriefGPT](https://github.com/e-johnstonn/briefgpt) - 本地托管工具，可将文档连接到LLMs以进行摘要和查询，具有简单的GUI界面。
 * [XrayGPT](https://github.com/mbzuai-oryx/xraygpt) - XrayGPT：使用医学视觉语言模型的胸部X光摘要。
 * [Voyager](https://github.com/minedojo/voyager) - 一个具有大型语言模型的开放式体验代理人
 * [gorilla](https://github.com/shishirpatil/gorilla) - 大猩猩：LLM的API商店
 * [sudolang-llm-support](https://github.com/paralleldrive/sudolang-llm-support) - SudoLang LLM 在 VSCode 中的支持
 * [azure-search-openai-demo](https://github.com/azure-samples/azure-search-openai-demo) - 一个在Azure上运行的检索增强生成模式的示例应用程序，使用Azure认知搜索进行检索，并使用Azure OpenAI大型语言模型来支持ChatGPT风格和问答体验。
 * [infiniteGPT](https://github.com/emmethalm/infinitegpt) - InfiniteGPT是一个Python脚本，可以让您将无限大小的文本输入到OpenAI API中。不再需要繁琐的复制和粘贴。多线程万岁！
 * [ToolBench](https://github.com/openbmb/toolbench) - 一个用于训练、服务和评估大型语言模型的开放平台，用于工具学习。
 * [localGPT](https://github.com/promtengineer/localgpt) - 使用GPT模型在本地设备上与您的文档聊天。没有数据离开您的设备，100％私密。
 * [azure-search-openai-demo-csharp](https://github.com/azure-samples/azure-search-openai-demo-csharp) - 一个在Azure上运行的检索增强生成模式的示例应用程序，使用Azure认知搜索进行检索，并使用Azure OpenAI大型语言模型来支持ChatGPT风格和问答体验。
 * [llm](https://github.com/simonw/llm) - 从命令行访问大型语言模型
 * [AutoGPTQ](https://github.com/panqiwei/autogptq) - 基于GPTQ算法的易于使用的LLMs量化包，具有用户友好的API。
 * [ALGO](https://github.com/zkx06111/algo) - 🚀介绍ALGO，这是一个由LLM生成的神谕引导的代码合成框架。与ALGO集成，Codex在竞赛级别的问题上提高了8倍，ChatGPT提高了1.3倍。此外，ALGO在提交前验证您的解决方案！🧵📜:🔗:
 * [FairEval](https://github.com/i-eval/faireval) - 大型语言模型不是公平的评估者-采用LLMs（例如GPT-4）作为评分裁判存在偏见-成功地缓解了偏见，使其更接近人类判断。
 * [pdf2md](https://github.com/eiaserinnys/pdf2md) - 这个项目pdf2md将学术论文PDF文件转换为易于阅读的文本文件。通过分析PDF文件的布局，应用程序重新构造段落并翻译所需内容。最终结果是一个方便导出的文本文件。
 * [ontogpt](https://github.com/monarch-initiative/ontogpt) - 基于GPT的本体抽取工具，包括SPIRES。
 * [selefra](https://github.com/selefra/selefra) - 这是一款开源的政策即代码软件，可为多云和SaaS环境提供分析，您可以通过自然语言获得洞察力（由OpenAI提供支持）。
 * [haystack](https://github.com/deepset-ai/haystack) - :mag: Haystack是一个开源的NLP框架，使用Transformer模型和LLMs（如GPT-4、ChatGPT等）与您的数据进行交互。Haystack提供了生产就绪的工具，快速构建复杂的问答、语义搜索、文本生成应用等。
 * [WizardLM](https://github.com/nlpxucan/wizardlm) - 由Evol-Instruct驱动的遵循指令的LLM家族：WizardLM，WizardCoder。
 * [sparrow](https://github.com/katanaml/sparrow) - 使用机器学习从文档中提取数据
 * [lamini](https://github.com/lamini-ai/lamini) - 今天：🎉为像ChatGPT这样的LLM托管数据生成器🎉一个开源的LLM，使用Lamini引擎训练生成的数据👉提前访问完整的培训等待名单，包括企业VPC等。
 * [long_stable_diffusion](https://github.com/sharonzhou/long_stable_diffusion) - 长文本生成图像，使用深度生成模型（GPT-3和稳定扩散）的管道。
 * [gpt-migrate](https://github.com/0xpayne/gpt-migrate) - 轻松将您的代码库从一个框架或语言迁移到另一个框架或语言。
 * [openchat](https://github.com/imoneoi/openchat) - 开放聊天：对于开源模型来说，越简单越好
 * [WebGLM](https://github.com/thudm/webglm) - WebGLM：一种高效的增强型网络问答系统（KDD 2023）
 * [MetaGPT](https://github.com/geekan/metagpt) - 多智能体元编程框架：输入一行需求，返回产品需求文档、设计、任务列表、代码库。
 * [PdfGptIndexer](https://github.com/raghavan/pdfgptindexer) - 一个高效的工具，使用OpenAI的GPT-2模型和FAISS（Facebook AI Similarity Search）索引来索引和搜索PDF文本数据，旨在实现快速信息检索和卓越的搜索准确性。
 * [SuperAGI](https://github.com/transformeroptimus/superagi) - <⚡️> SuperAGI - 一个以开发者为中心的开源自主人工智能代理框架。使开发者能够快速可靠地构建、管理和运行有用的自主代理。
 * [OpenLLM](https://github.com/bentoml/openllm) - 在生产中运行LLMs
 * [GPT-Bargaining](https://github.com/franxyao/gpt-bargaining) - Arxiv 2023年的代码：通过自我对弈和从AI反馈中学习来改进语言模型的谈判能力
 * [dreamGPT](https://github.com/divergentai/dreamgpt) - 利用大型语言模型（LLMs）的幻觉进行以新颖性驱动的探索。
 * [lnchat](https://github.com/litch/lnchat) - 所以我做了一个东西 - LNChat。你将这个应用连接到你的节点，然后你可以用纯文本的方式向它提问，比如“我的最新通道是什么”，“给我展示一个通道摘要”。ChatGPT填补了这个空白。它很有趣，但并不是特别有用。至少现在还不是。
 * [ai00_rwkv_server](https://github.com/cgisky1980/ai00_rwkv_server) - 一个比ChatGPT更好的本地化开源AI服务器。
 * [chinese-llm-benchmark](https://github.com/jeinlee1991/chinese-llm-benchmark) - 中文大模型能力评测榜单：覆盖百度文心一言、chatgpt、阿里通义千问、讯飞星火、belle / chatglm6b 等开源大模型，多维度能力评测。不仅提供能力评分排行榜，也提供所有模型的原始输出结果！
 * [RankGPT](https://github.com/sunnweiwei/rankgpt) - ChatGPT在搜索方面表现如何？LLMs作为重新排序代理
 * [smile](https://github.com/qiuhuachuan/smile) - 微笑：通过ChatGPT进行单轮到多轮包容性语言扩展，为心理健康支持提供帮助。
 * [C3SQL](https://github.com/bigbigwatermalon/c3sql) - 论文C3的代码：使用ChatGPT进行零样本文本到SQL的转换。
 * [CodeDroidAI](https://github.com/fmxexpress/codedroidai) - 使用像ChatGPT和Vicuna-13b这样的LLMs，为Delphi Object Pascal和C++Builder生成代码和表单。
 * [ChatGPT-AutoHotkey-Utility](https://github.com/kdalanon/chatgpt-autohotkey-utility) - 一个使用ChatGPT API处理文本的AutoHotkey脚本。
 * [jekyll-chatgpt-translate](https://github.com/yegor256/jekyll-chatgpt-translate) - 通过ChatGPT自动翻译Jekyll页面：您只需要一个OpenAI API密钥。
 * [autotranslate](https://github.com/lewangdev/autotranslate) - 视频转录和翻译，更快的耳语和ChatGPT
 * [nextlint](https://github.com/sveltor/nextlint) - 一个富文本编辑器，类似于Notion的编辑器，使用Svelte + Tiptap构建。通过ChatGPT提升写作体验。
 * [chatgpt-api-python-sales](https://github.com/boburmirzo/chatgpt-api-python-sales) - 使用ChatGPT和LLM（大型语言模型）应用程序，通过AI驱动的Python API查找实时销售数据。
 * [AiNiee-chatgpt](https://github.com/nekoparapa/ainiee-chatgpt) - 一款基于【mtool】或【Translator++】的chatgpt自动批量翻译工具，主要用于翻译各种RPG游戏。
 * [openai-forward](https://github.com/beidongjiedeguang/openai-forward) - 🚀 一个专为大型语言模型设计的转发服务 · 一键部署你的私人AI代理 · LLM代理 · OpenAI API反向代理
 * [gpt4-playground](https://github.com/nashex/gpt4-playground) - 克隆OpenAI的ChatGPT和Playground环境，以便进行API密钥实验。
 * [github-pr-summary](https://github.com/flows-network/github-pr-summary) - 使用ChatGPT来总结和审查GitHub的Pull请求。
 * [SiriGPT](https://github.com/nicolodiamante/sirigpt) - 释放SiriGPT的力量：ChatGPT的智能、DALL·E的创造力和Whisper的精确音频转录相交，为您的苹果设备提供支持，支持20种语言。
 * [chie](https://github.com/chieapp/chie) - 一个功能强大的桌面应用程序，用于ChatGPT和其他LLM。
 * [chatnio](https://github.com/zmh-program/chatnio) - 📚 中文网站项目的文档（使用 vitepress）
 * [Selective_Context](https://github.com/liyucheng09/selective_context) - 将您的输入压缩到ChatGPT或其他LLMs中，让它们能够处理多2倍的内容，并节省40%的内存和GPU时间。
 * [GPT-RAG](https://github.com/azure/gpt-rag) - 在我们一路上积累的学习中，以安全的方式实现Azure OpenAI的规模化。GPT-RAG核心是在Azure上运行的检索增强生成模式，使用Azure认知搜索进行检索，并使用Azure OpenAI大型语言模型来支持ChatGPT风格和问答体验。
 * [LLMforDialogDataGenerate](https://github.com/threecolorfr/llmfordialogdatagenerate) - 利用ChatGLM2、ChatGPT等大模型从文档中生成对话数据。
 * [Auto-i18n](https://github.com/linyuxuanlin/auto-i18n) - 使用 ChatGPT 自动将 Markdown 文件批量翻译为多语言
 * [chat-with-your-data-solution-accelerator](https://github.com/azure-samples/chat-with-your-data-solution-accelerator) - 一个在Azure上运行的RAG模式的解决方案加速器，使用Azure认知搜索进行检索，并使用Azure OpenAI大型语言模型来支持ChatGPT风格和问答体验。这包括最常见的需求和最佳实践。
 * [RSS-GPT](https://github.com/yinan-c/rss-gpt) - 使用ChatGPT来总结您的个性化RSS订阅
 * [one-api](https://github.com/songquanpeng/one-api) - OpenAI接口管理和分发系统，支持Azure、Anthropic Claude、Google PaLM 2、智谱ChatGLM、百度文心一言、讯飞星火认知、阿里通义千问、360智脑以及腾讯混元，可用于二次分发管理key，仅单可执行文件，已打包好Docker镜像，一键部署，开箱即用。OpenAI key管理和重新分发系统，使用单个API适用于所有LLMs，并具有英文用户界面。
 * [Baichuan2](https://github.com/baichuan-inc/baichuan2) - 百川智能科技开发的一系列大型语言模型
 * [marqo](https://github.com/marqo-ai/marqo) - 人类的向量搜索。也可在云端使用 - cloud.marqo.ai
 * [khoj](https://github.com/khoj-ai/khoj) - 一个AI副驾驶员，为你的第二大脑。在线或离线搜索和与你的个人知识库聊天。
 * [Otter](https://github.com/luodian/otter) - 🦦 Otter是基于OpenFlamingo（DeepMind的Flamingo的开源版本）的多模态模型，经过MIMIC-IT训练，展示了改进的指令跟随和上下文学习能力。
 * [RWKV-Runner](https://github.com/josstorer/rwkv-runner) - 一个RWKV管理和启动工具，完全自动化，仅8MB。并提供与OpenAI API兼容的接口。RWKV是一个完全开源且可用于商业用途的大型语言模型。
 * [MNBVC](https://github.com/esbatmop/mnbvc) - MNBVC（Massive Never-ending BT Vast Chinese corpus）超大规模中文语料集。对标chatGPT训练的40T数据。MNBVC数据集不仅包括主流文化，也包括各个小众文化甚至火星文的数据。MNBVC数据集包括新闻、作文、小说、书籍、杂志、论文、台词、帖子、维基百科、古诗、歌词、商品介绍、笑话、糗事、聊天记录等一切形式的纯文本中文数据。
 * [Easydict](https://github.com/tisfeng/easydict) - 一个简洁优雅的词典翻译 macOS 应用程序，可用于查找单词和翻译文本。支持离线 OCR 识别，同时支持有道词典，🍎 苹果系统词典，🍎 苹果系统翻译，ChatGPT，DeepL，Google，Bing，百度和火山翻译。
 * [NExT-GPT](https://github.com/next-gpt/next-gpt) - NExT-GPT的代码和模型：任意到任意的多模态大型语言模型
 * [TavernAI](https://github.com/tavernai/tavernai) - 针对AI语言模型的大气冒险聊天（KoboldAI、NovelAI、Pygmalion、OpenAI chatgpt、gpt-4）
 * [lmql](https://github.com/eth-sri/lmql) - 一种用于约束引导和高效LLM编程的语言。
 * [chatarena](https://github.com/farama-foundation/chatarena) - ChatArena（或Chat Arena）是一个为LLMs设计的多智能体语言游戏环境。其目标是开发AI的沟通和协作能力。
 * [Data-Science-Roadmap](https://github.com/moataz-elmesmary/data-science-roadmap) - 从A到Z的数据科学路线图
 * [deepeval](https://github.com/confident-ai/deepeval) - LLM评估框架
 * [inference](https://github.com/xorbitsai/inference) - 通过改变一行代码，将OpenAI GPT替换为另一个LLM。Xinference让您可以自由使用任何您需要的LLM。使用Xinference，您可以在云端、本地甚至笔记本电脑上运行推理，无论是开源语言模型、语音识别模型还是多模态模型。
 * [chameleon-llm](https://github.com/lupantech/chameleon-llm) - 《变色龙：与大型语言模型进行即插即用的组合推理的代码》
 * [HuatuoGPT](https://github.com/freedomintelligence/huatuogpt) - 华佗GPT，朝着驯服语言模型成为医生迈进。（一个开放的医学GPT）
 * [DB-GPT-Hub](https://github.com/eosphoros-ai/db-gpt-hub) - 一个包含DB-GPT模型、数据集和微调技术的存储库，旨在提高文本到SQL的模型性能。
 * [aidea-server](https://github.com/mylxsw/aidea-server) - AIdea 是一款支持 GPT 和国产大语言模型通义千问、文心一言等，支持 Stable Diffusion 文生图、图生图、 SDXL1.0、超分辨率、图片上色的全能型 APP。
 * [llm-viz](https://github.com/bbycroft/llm-viz) - 3D可视化的GPT风格LLM
 * [AppAgent](https://github.com/mnotgod96/appagent) - AppAgent：多模态代理作为智能手机用户，是一个基于LLM的多模态代理框架，旨在操作智能手机应用程序。
 * [AgentBench](https://github.com/thudm/agentbench) - 一个全面的基准来评估LLMs作为代理人
 * [NeumAI](https://github.com/neumtry/neumai) - Neum AI是一个一流的框架，用于大规模管理矢量嵌入的创建和同步。
 * [LLMs-from-scratch](https://github.com/rasbt/llms-from-scratch) - 从零开始逐步实现类似ChatGPT的LLM
 * [TransformerLens](https://github.com/neelnanda-io/transformerlens) - 一个用于解释GPT风格语言模型机制的图书馆
 * [KwaiAgents](https://github.com/kwaikeg/kwaiagents) - 一个具有大型语言模型（LLMs）的广义信息搜索代理系统。
 * [MotionGPT](https://github.com/openmotionlab/motiongpt) - 【NeurIPS 2023】MotionGPT：将人类动作视为一门外语的统一动作语言生成模型，使用LLMs
 * [chatgpt-tool-hub](https://github.com/goldfishh/chatgpt-tool-hub) - 一个开源的ChatGPT工具生态系统，您可以将工具与ChatGPT结合使用，并使用自然语言来完成任何任务。
 * [LLMSurvey](https://github.com/rucaibox/llmsurvey) - 调查论文《大型语言模型综述》的官方GitHub页面。
 * [talk2arxiv](https://github.com/evanhu1/talk2arxiv) - 使用ChatGPT与任何ArXiv论文进行对话
 * [autopilot](https://github.com/fjrdomingues/autopilot) - 代码自动驾驶，一种利用GPT读取代码库、创建上下文并解决任务的工具。
 * [openai-forward](https://github.com/kenyony/openai-forward) - 🚀 大语言模型高效转发服务 · 专为LLMs设计的高效转发服务 · OpenAI API反向代理
 * [FasterTransformer](https://github.com/nvidia/fastertransformer) - 与Transformer相关的优化，包括BERT，GPT输出：Transformer相关的优化，包括BERT，GPT
 * [hacker-news-digest](https://github.com/polyrabbit/hacker-news-digest) - : newspaper: 让ChatGPT为您总结黑客新闻
 * [openai-translator](https://github.com/lancemoe/openai-translator) - 一个使用OpenAI的翻译器。
 * [llm-paper-daily](https://github.com/xianshang33/llm-paper-daily) - 每日更新的LLM论文。欢迎订阅👏如果你喜欢，请动动你的小手🌟一个。
 * [Azure-OpenAI-demos](https://github.com/retkowsky/azure-openai-demos) - Azure 开放 AI（演示、文档、加速器）。
 * [chatWeb](https://github.com/skywalkerdarren/chatweb) - ChatWeb可以爬取网页、阅读PDF、DOCX、TXT，并提取主要内容，然后根据内容回答您的问题，或总结关键要点。
 * [StreamRAG](https://github.com/video-db/streamrag) - 视频搜索和流媒体代理 🕵️‍♂️
 * [gptscript](https://github.com/gptscript-ai/gptscript) - 自然语言编程
 * [sgpt](https://github.com/muennighoff/sgpt) - SGPT：GPT句子嵌入用于语义搜索
 * [visual-openllm](https://github.com/visual-openllm/visual-openllm) - 类似视觉聊天GPT的开源版本，文心一言
 * [GPT-Fathom](https://github.com/gpt-fathom/gpt-fathom) - GPT-Fathom是一个开源且可重现的LLM评估套件，对10多个领先的开源和闭源LLM以及OpenAI早期模型在20多个精心策划的基准测试下进行基准测试。
 * [OpenCodeInterpreter](https://github.com/opencodeinterpreter/opencodeinterpreter) - OpenCodeInterpreter是一套开源代码生成系统，旨在弥合大型语言模型和复杂专有系统（如GPT-4代码解释器）之间的差距。它通过显著增强代码生成能力，帮助用户更好地生成代码。
 * [flutter_chatgpt](https://github.com/wewehao/flutter_chatgpt) - Flutter ChatGPT 应用程序。由flutter实现的chatgpt聊天应用程序支持自定义模式和上下文连续对话。此外，它支持admob广告配置，访问开屏广告、插页广告、横幅。
 * [ai00_server](https://github.com/ai00-x/ai00_server) - 一个比ChatGPT更好的本地化开源AI服务器。
 * [CipherChat](https://github.com/robustnlp/cipherchat) - 一个评估LLMs安全对齐泛化能力的框架
 * [bonito](https://github.com/batsresearch/bonito) - 一个轻量级的库，用于生成合成指令调整数据集，无需使用GPT。
 * [azure-open-ai-embeddings-qna](https://github.com/ruoccofabrizio/azure-open-ai-embeddings-qna) - 一个简单的网络应用程序，用于OpenAI启用的文档搜索。该存储库使用Azure OpenAI服务从文档中创建嵌入向量。为了回答用户的问题，它检索最相关的文档，然后使用GPT-3、GPT-3.5或其他技术。
 * [open-interpreter](https://github.com/openinterpreter/open-interpreter) - 计算机的自然语言界面
 * [EvaluationPapers4ChatGPT](https://github.com/thu-keg/evaluationpapers4chatgpt) - ChatGPT的资源、评估和检测论文
 * [private-gpt](https://github.com/zylon-ai/private-gpt) - 使用GPT的强大功能与您的文档互动，100%私密，无数据泄露。
 * [VLMEvalKit](https://github.com/open-compass/vlmevalkit) - 开源评估工具包，支持大型视觉语言模型（LVLMs），支持GPT-4v，Gemini，QwenVLPlus，30多个HF模型，15个基准测试。
 * [LLMPapers](https://github.com/kseseu/llmpapers) - 大型语言模型（ChatGPT，GPT-3，Codex等）的论文和作品。
 * [AIGenPipeline](https://github.com/stoerr/aigenpipeline) - 基于人工智能的代码生成流水线：命令行工具和框架，用于在构建过程中使用人工智能进行系统化代码生成。
 * [agency](https://github.com/neurocult/agency) - 🕵️‍♂️ 专为开发人员设计的图书馆，旨在通过清晰、有效和符合Go语言习惯的方法，探索大型语言模型（LLMs）和其他生成式人工智能的潜力。
 * [subtitle-translator-electron](https://github.com/gnehs/subtitle-translator-electron) - 使用ChatGPT翻译字幕
 * [obsidian-ava](https://github.com/different-ai/obsidian-ava) - 使用Obsidian中的ChatGPT快速格式化您的笔记
 * [spacy-transformers](https://github.com/explosion/spacy-transformers) - 🛸 在spaCy中使用预训练的转换器，如BERT、XLNet和GPT-2
 * [chatgpt-universe](https://github.com/cedrickchee/chatgpt-universe) - ChatGPT Universe 是关于 ChatGPT、GPT 和大型语言模型（LLMs）的短暂笔记。
 * [InternVL](https://github.com/opengvlab/internvl) - [CVPR 2024 口头报告] InternVL Family: 一种开创性的开源替代方案，接近GPT-4V的性能。
 * [GPTSwarm](https://github.com/metauto-ai/gptswarm) - 🐝 GPTSwarm: LLM代理作为（可优化）图形
 * [nixtla](https://github.com/nixtla/nixtla) - TimeGPT-1：生产就绪的预训练时间序列基础模型，用于预测和异常检测。在超过100B数据点上训练的时间序列生成预训练变压器。它能够准确预测各种领域，如...
 * [TransformerLens](https://github.com/transformerlensorg/transformerlens) - 一种用于解释GPT风格语言模型机制的图书馆
 * [BetterOCR](https://github.com/junhoyeo/betterocr) - 通过将多个OCR引擎（EasyOCR、Tesseract和Pororo）与🧠 LLM 结合，可以实现更好的文本检测。
 * [viz-gpt](https://github.com/observedobserver/viz-gpt) - 使用表格数据制作具有聊天界面的上下文数据可视化。人工智能数据可视化。
 * [ChatIE](https://github.com/cocacola-lab/chatie) - 在线版本暂时不可用，因为我们无法承担密钥费用。您可以克隆并在本地运行。注意：我们设置了默认的OpenAI密钥。如果密钥超出计划或无效，请告诉我们。响应速度取决于OpenAI。（有时候，）
 * [RepoToText](https://github.com/jeremiahpetersen/repototext) - 将整个GitHub存储库转换为一个组织良好的单个.txt文件，以便与LLM（GPT-4、Claude Opus、Gemini等）一起使用
 * [ocular](https://github.com/ocularengineering/ocular) - AI 动力搜索和聊天服务 - 想象一下 ChatGpt 遇见谷歌搜索，但是由您的数据驱动。
 * [AutoCoder](https://github.com/bin123apple/autocoder) - 我们推出了一个专为代码生成任务设计的新模型。它在HumanEval基础数据集上的测试准确率超过了GPT-4 Turbo（2024年4月）和GPT-4o。
 * [langui](https://github.com/langbaseinc/langui) - 为您的人工智能设计的用户界面。为您的GPT、生成式人工智能和LLM项目量身定制的开源Tailwind组件。
 * [go-translate](https://github.com/lorniu/go-translate) - Emacs上的翻译器。支持多个引擎，如Google、Bing、deepL、ChatGPT、StarDict、有道等等。
 * [ChatTTS](https://github.com/2noise/chattts) - 每日对话生成模型。
 * [chatgpt-your-files](https://github.com/supabase-community/chatgpt-your-files) - 使用pgvector安全地与您的文档进行聊天的生产就绪MVP
 * [auto-novel](https://github.com/fishhawk/auto-novel) - 轻小说机翻网站，支持网络小说/文库小说/本地小说。
 * [Q-Bench](https://github.com/q-future/q-bench) - ①[ICLR2024焦点]（GPT-4V / Gemini-Pro / Qwen-VL-Plus + 16 OS MLLMs）低级视觉和视觉质量评估的多模态LLMs（MLLMs）基准。
 * [lowcode-vscode](https://github.com/lowcoding/lowcode-vscode) - 低代码工具，支持ChatGPT和其他LLM
 * [HuatuoGPT-II](https://github.com/freedomintelligence/huatuogpt-ii) - 华陀GPT2，医学适应LLMs的一阶段训练。（一个开放的医学GPT）
 * [AI-Vtuber](https://github.com/whoiswennie/ai-vtuber) - 一个端到端的AI主播定制模块，当前支持对接b站直播间，支持本地chatglm3和智谱api语言模型，支持so-vits-svc、gpt-sovits和bert-vits2语音模型。
 * [Recommendation-Systems-without-Explicit-ID-Features-A-Literature-Review](https://github.com/westlake-repl/recommendation-systems-without-explicit-id-features-a-literature-review) - 预训练基础推荐模型纸质清单
 * [mem0](https://github.com/mem0ai/mem0) - LLMs的长期记忆
 * [Github-Ranking-AI](https://github.com/yuxiaopeng/github-ranking-ai) - 基于它们收到的星星数量，这是GitHub上最受欢迎的人工智能主题仓库列表。| AI相关主题Github仓库排名，每日自动更新。
 * [searchGPT](https://github.com/michaelthwan/searchgpt) - 基于LLM / ChatGPT / OpenAI API的有来源引用的搜索引擎。支持网页搜索、文件内容搜索等。
 * [rag-gpt](https://github.com/gpt-open/rag-gpt) - RAG-GPT，利用LLM和RAG技术，从用户定制的知识库中学习，为各种查询提供相关背景答案，确保快速准确的信息检索。
 * [embedJs](https://github.com/llm-tools/embedjs) - 一个NodeJS RAG框架，可以轻松地处理LLMs和嵌入。
 * [AmadeusGPT](https://github.com/adaptivemotorcontrollab/amadeusgpt) - [NeurIPS 2023] 我们将行为的自然语言描述转化为可执行代码。
 * [fastapi](https://github.com/iimeta/fastapi) - 智元 Fast API 是一站式API管理系统，将各类LLM API进行统一格式、统一规范、统一管理，使其在功能、性能和用户体验上达到极致。
 * [gtt](https://github.com/eeexun/gtt) - Google翻译TUI（原始）。现在支持Apertium，Argos，Bing，ChatGPT，DeepL，DeepLX，Google，Reverso。
 * [AlignBench](https://github.com/thudm/alignbench) - 大型多维度中文对齐评测基准 (ACL 2024)
 * [factool](https://github.com/gair-nlp/factool) - FacTool：生成式AI中的事实性检测
 * [tree-of-thought-puzzle-solver](https://github.com/jieyilong/tree-of-thought-puzzle-solver) - 思维树（ToT）框架用于使用LLMs解决复杂推理任务
 * [llmgraph](https://github.com/dylanhogg/llmgraph) - 使用LLMs创建知识图谱
 * [Sunsimiao](https://github.com/x-d-lab/sunsimiao) - 🌿孙思邈中文医疗大模型(Sunsimiao)：提供安全、可靠、普惠的中文医疗大模型
 * [MiniCPM](https://github.com/openbmb/minicpm) - MiniCPM3-4B：一款超越GPT-3.5-Turbo的边缘LLM。
 * [cloudflare-rag](https://github.com/rafalwilinski/cloudflare-rag) - 全栈“与您的PDF文件聊天”的RAG（检索增强生成）应用程序完全构建在Cloudflare上
 * [empower-functions](https://github.com/empower-ai/empower-functions) - 用于真实世界工具使用案例的GPT-4级功能调用模型
 * [HallusionBench](https://github.com/tianyi-lab/hallusionbench) - [CVPR'24] HallusionBench：你看到的是你想到的吗？还是你想到的是你看到的？一个挑战GPT-4V(ision)、LLaVA-1.5和其他多模态模型的图像-上下文推理基准测试
 * [repo2txt](https://github.com/abinthomasonline/repo2txt) - 基于网络的工具将GitHub存储库内容转换为单个格式化文本文件。
 * [bigcodebench](https://github.com/bigcode-project/bigcodebench) - BigCodeBench：基准测试代码生成朝向AGI
 * [FastGPT](https://github.com/labring/fastgpt) - FastGPT是基于LLMs构建的知识平台，提供了一套全面的即插即用功能，如数据处理、RAG检索和视觉AI工作流编排，让您轻松开发和部署复杂的问答系统。
 * [guardrails](https://github.com/guardrails-ai/guardrails) - 为大型语言模型添加护栏。
 * [E2B](https://github.com/e2b-dev/e2b) - 安全的开源云运行时，用于AI应用程序和AI代理
 * [MaxKB](https://github.com/1panel-dev/maxkb) - 🚀 基于大型语言模型和 RAG 的知识库问答系统。开箱即用、模型中立、灵活编排，支持快速嵌入到第三方业务系统。
 * [SillyTavern](https://github.com/sillytavern/sillytavern) - LLM高级用户前端。
 * [instructor](https://github.com/jxnl/instructor) - 为llms设计结构化输出
 * [instructor](https://github.com/instructor-ai/instructor) - 为llms设计结构化输出
 * [buzz](https://github.com/chidiwilliams/buzz) - Buzz在您的个人电脑上离线转录和翻译音频。由OpenAI的Whisper提供支持。
 * [ai](https://github.com/vercel/ai) - 使用React、Svelte、Vue和Solid构建AI驱动的应用程序
 * [rivet](https://github.com/ironclad/rivet) - 开源的视觉人工智能编程环境和TypeScript库
 * [griptape](https://github.com/griptape-ai/griptape) - 用于AI代理和工作流的模块化Python框架，具有思维链推理、工具和记忆。
 * [agentic](https://github.com/transitive-bullshit/agentic) - 与任何LLM和TypeScript AI SDK配合使用的AI代理stdlib。输出：与任何LLM和TypeScript AI SDK配合使用的AI代理库。
 * [faster-whisper](https://github.com/systran/faster-whisper) - 使用CTranslate2进行更快速的Whisper转录
 * [tokencost](https://github.com/agentops-ai/tokencost) - 400多个LLM的Easy token价格估算。TokenOps。
 * [TEN-Agent](https://github.com/ten-framework/ten-agent) - TEN Agent是全球第一个集成OpenAI实时API、RTC的实时多模态代理，具有天气查询、网络搜索、视觉和RAG功能。
 * [refact](https://github.com/smallcloudai/refact) - 用于微调和自托管开源大型语言模型进行编码的WebUI
 * [ax](https://github.com/ax-llm/ax) - 非官方DSPy框架。基于斯坦福DSP论文构建由LLM驱动的代理和“代理工作流”。
 * [code-interpreter](https://github.com/e2b-dev/code-interpreter) - Python和JS/TS SDK用于在您的AI应用程序中运行AI生成的代码/代码解释。
 * [atomic-agents](https://github.com/brainblend-ai/atomic-agents) - 构建AI代理，原子化


## Langchain

 * [langchain](https://github.com/hwchase17/langchain) - ⚡通过可组合性使用LLMs构建应用程序⚡
 * [text-generation-webui](https://github.com/oobabooga/text-generation-webui) - 一个Gradio Web UI，用于运行像LLaMA、llama.cpp、GPT-J、OPT和GALACTICA这样的大型语言模型。
 * [llama_index](https://github.com/jerryjliu/llama_index) - LlamaIndex（GPT指数）是一个项目，提供一个中央接口，将您的LLM与外部数据连接起来。
 * [llama](https://github.com/facebookresearch/llama) - LLaMA模型的推理代码
 * [GPTQ-for-LLaMa](https://github.com/qwopqwop200/gptq-for-llama) - 使用GPTQ对LLaMA进行4位量化
 * [gptuber-by-langchain](https://github.com/karakuri-ai/gptuber-by-langchain) - GPT将成为YouTuber。
 * [intelgpt](https://github.com/phishing-hunter/intelgpt) - IntelGPT是一个命令行工具，可以使用GPT3检查特定的输入，如URL、文件哈希、域名和IP地址。
 * [knowledge-gpt](https://github.com/geeks-of-data/knowledge-gpt) - 使用GPT和其他语言模型从所有信息来源中提取知识。对信息来源进行索引并进行问答会话。
 * [llama_index_starter_pack](https://github.com/logan-markewich/llama_index_starter_pack) - 该存储库为llama_index（曾用名gpt_index）包提供了非常基本的flask、streamlit和docker示例。
 * [xturing](https://github.com/stochasticai/xturing) - 建立并控制你自己的LLMs
 * [llama-int8](https://github.com/tloen/llama-int8) - LLaMA模型的量化推理代码
 * [point-alpaca](https://github.com/pointnetwork/point-alpaca) - 我们发布了从重新创建的斯坦福羊驼7b - 美洲驼经过合成指令数据集微调的权重。结果出奇的好:(请记住，以下结果仅来自最小的7b模型; GPT-3是175b)
 * [agentchain](https://github.com/jina-ai/agentchain) - 将LLMs串联起来进行推理，编排多个大型模型以完成复杂任务。
 * [llm-strategy](https://github.com/blackhc/llm-strategy) - 直接将Python连接到LLMs - 数据类和接口<->LLMs
 * [llama-cpp-python](https://github.com/abetlen/llama-cpp-python) - llama.cpp的Python绑定
 * [basaran](https://github.com/hyperonym/basaran) - Basaran是OpenAI文本补全API的开源替代品。它为基于Hugging Face Transformers的文本生成模型提供兼容的流API。
 * [llama-lab](https://github.com/run-llama/llama-lab) - 如果您想使用@gpt_index构建一个空间，请在此处填写表格！感谢logan从零开始开创了这个项目，为llama agi的贡献致谢。
 * [Ask-Anything](https://github.com/opengvlab/ask-anything) - ChatGPT支持视频理解！还支持许多其他语言模型，如miniGPT4、StableLM和MOSS。
 * [VLog](https://github.com/showlab/vlog) - 使用ChatGPT、CLIP、BLIP2、GRIT、Whisper、LangChain将视频转换为文档。
 * [alpaca-lora](https://github.com/tloen/alpaca-lora) - 在消费硬件上指导调整LLaMA
 * [ClassGPT](https://github.com/benthecoder/classgpt) - ChatGPT 用于讲义幻灯片。
 * [KoAlpaca](https://github.com/beomi/koalpaca) - KoAlpaca：基于斯坦福羊驼的韩国羊驼模型（特色：LLAMA和Polyglot-ko）
 * [novice-ChatGPT](https://github.com/aiplaybookin/novice-chatgpt) - 使用LangChain、LlamaIndex、Guardrails、AutoGPT等ChatGPT API的用法
 * [ai-playground](https://github.com/mklarqvist/ai-playground) - 我在玩Perplexity AI时想弄清楚它是如何工作的。所以我用@openai gpt-3.5turbo、@langchainai、@trychroma编写了一个简单的开源克隆，并提供了文档。来看看吧。
 * [alpaca-electron](https://github.com/itspi3141/alpaca-electron) - 运行Alpaca的更简单方法
 * [langflow](https://github.com/logspace-ai/langflow) - ⛓️ LangFlow是LangChain的用户界面，采用react-flow设计，提供了一种轻松的方式来实验和原型化流程。
 * [gpt4all-ts](https://github.com/nomic-ai/gpt4all-ts) - gpt4all和llama的typescript绑定
 * [pyllamacpp](https://github.com/nomic-ai/pyllamacpp) - 官方支持的llama.cpp和gpt4all的Python绑定
 * [llama.cpp](https://github.com/ggerganov/llama.cpp) - Facebook的LLaMA模型在C/C++中的端口
 * [dalai](https://github.com/cocktailpeanut/dalai) - 在本地机器上运行LLaMA的最简单方法
 * [GenAI_LLM_timeline](https://github.com/hollobit/genai_llm_timeline) - ChatGPT、生成式AI和LLMs时间线
 * [open_llama](https://github.com/openlm-research/open_llama) - OpenLLama - 一个采用宽松许可证的开源复制品，模仿Meta AI的LLaMA。🦙“OpenLLaMA在大多数任务中表现与原始LLaMA和GPT-J相当，并在某些任务中表现更好。”👀
 * [pyCodeAGI](https://github.com/chakkaradeep/pycodeagi) - 我的当前探索：PyCodeAGI，一个@LangChainAI #AIAgent，它可以根据目标构建一个Python控制台应用程序，刚刚获得了@OpenAI #GPT4的超能力：要求它构建一个“魔法应用程序”-它构建了一些创意。甚至没有一个错误...
 * [Multimodal-GPT](https://github.com/open-mmlab/multimodal-gpt) - 多模态-GPT
 * [snowChat](https://github.com/kaarthik108/snowchat) - 在您的雪花数据库上聊天 - 文本转SQL
 * [DB-GPT](https://github.com/csunny/db-gpt) - 使用本地GPT与数据和环境进行交互，无数据泄漏，100%私密，100%安全。
 * [LaWGPT](https://github.com/pengxiao-song/lawgpt) - 🎉 LaWGPT仓库，中文羊驼调整的中文法律知识模型。基于中文法律知识的大语言模型。
 * [InternGPT](https://github.com/opengvlab/interngpt) - InternGPT（iGPT）是一个开源演示平台，您可以轻松展示您的AI模型。现在它支持DragGAN、ChatGPT、ImageBind、多模式聊天（如GPT-4、SAM）、交互式图像编辑等。请在igpt.opengvlab.com上尝试。
 * [chainlit](https://github.com/chainlit/chainlit) - 在几分钟内构建Python LLM应用程序 ⚡️
 * [Flowise](https://github.com/flowiseai/flowise) - 使用LangchainJS拖放界面构建您定制的LLM流程
 * [semantic-search-nextjs-pinecone-langchain-chatgpt](https://github.com/dabit3/semantic-search-nextjs-pinecone-langchain-chatgpt) - 将文本文件嵌入向量中，存储在Pinecone上，并使用GPT3和Langchain在Next.js UI中实现语义搜索。
 * [redpajama.cpp](https://github.com/togethercomputer/redpajama.cpp) - 扩展原始的llama.cpp仓库以支持redpajama模型。
 * [OgbujiPT](https://github.com/uogbuji/ogbujipt) - 通过langchain和其他方式使用自托管的大型语言模型的工具包
 * [godot-dodo](https://github.com/minosvasilias/godot-dodo) - 为GDScript生成调整大型语言模型。
 * [eva](https://github.com/georgia-tech-db/eva) - 构建更简单、更快的人工智能应用程序的数据库系统
 * [LangChain-Tutorials](https://github.com/sugarforever/langchain-tutorials) - 挺好奇ChatGPT那种流式输出，费了牛劲，堆砌出了基于Python LangChain的实现，涵盖控制台和Web3应用的异步流式输出。Python异步编程还需深入学习🧐代码👇视频分享👇bilibili:   #LangChain #ChatGPT #OpenAI
 * [chat-efficient](https://github.com/coefficientsystems/chat-efficient) - 使用Streamlit、LangChain和开源LLMs进行DIY ChatGPT
 * [gpt-producer](https://github.com/juankysoriano/gpt-producer) - 介绍“GPT-Producer”带上你的数字钢琴，你的@OpenAI API密钥和你的#GPU，成为一位艺术家！#音乐生成 #音频制作 #gpt 感谢@LangChainAI和@MetaAI提供的工具使这一切成为可能！
 * [MedicalGPT](https://github.com/shibing624/medicalgpt) - MedicalGPT：使用ChatGPT训练流程训练您自己的医疗GPT模型。
 * [rag-stack](https://github.com/psychic-api/rag-stack) - 🤖 在您的VPC中部署一个私有的ChatGPT替代品。🔮 将其连接到您的组织知识库，并将其用作企业预言机。支持开源的LLMs，如Llama 2、Falcon和GPT4All。
 * [opencompass](https://github.com/internlm/opencompass) - OpenCompass是一个LLM评估平台，支持50多个数据集上的多种模型（LLaMA，LLaMa2，ChatGLM2，ChatGPT，Claude等）。
 * [dolphin](https://github.com/kaleido-lab/dolphin) - 基于LLMs的通用视频互动平台，包括Video ChatGPT。
 * [api-for-open-llm](https://github.com/xusenlinzy/api-for-open-llm) - 使用LLMs作为ChatGPT的开放AI风格API，开放大型语言模型的统一后端接口。
 * [AtomGPT](https://github.com/atomecho/atomgpt) - 中英文预训练大模型，目标与ChatGPT的水平一致
 * [litellm](https://github.com/berriai/litellm) - 一个简单轻巧的软件包，用于调用OpenAI、Azure、Cohere和Anthropic API终端。
 * [BayLing](https://github.com/ictnlp/bayling) - “百聆”是一个基于LLaMA的语言对齐增强的英语/中文大语言模型，具有优越的英语/中文能力，在多语言和通用任务等多项测试中取得ChatGPT 90%的性能。BayLing是一个配备先进语言对齐功能的英语/中文LLM，展现出在英语/中文生成、指令遵循和多轮互动方面的卓越能力。
 * [auto-news](https://github.com/finaldie/auto-news) - 一个个人新闻聚合器，可以从多个来源获取信息+LLM（通过LangChain的ChatGPT）帮助我们以更高效的方式阅读，减少干扰。这些来源包括：推特、RSS、YouTube、网页文章、Reddit和个人日记笔记。
 * [Zhongjing](https://github.com/suprityoung/zhongjing) - 一个基于LLaMa的中文医学ChatGPT，通过大规模预训练语料库和多轮对话数据集进行训练。
 * [opencompass](https://github.com/open-compass/opencompass) - OpenCompass是一个LLM评估平台，支持50多个数据集上的多种模型（LLaMA、LLaMa2、ChatGLM2、ChatGPT、Claude等）。
 * [gradioGPT](https://github.com/francescosaveriozuppichini/gradiogpt) - 使用Gradio和Langchain创建下一个ChatGPT应用的易于入侵的模板。
 * [FindTheChatGPTer](https://github.com/chenking2020/findthechatgpter) - ChatGPT爆火，开启了通往AGI的关键一步，本项目旨在汇总那些ChatGPT的开源平台们，包括文本大模型、多模态大模型等，为大家提供一些便利。
 * [gpt_academic](https://github.com/binary-husky/gpt_academic) - 为ChatGPT/GLM提供实用化交互界面，特别优化论文阅读/润色/写作体验，模块化设计，支持自定义快捷按钮和函数插件，支持Python和C++等项目剖析和自译解功能，PDF/LaTex论文翻译和总结功能，支持并行问询多种LLM模型，支持chatglm2等本地模型。兼容文心一言、moss、llama2、rwkv、claude2、通义千问、书生、讯飞星火等。
 * [Real_time_fallacy_detection](https://github.com/latent-variable/real_time_fallacy_detection) - 实时谬误检测使用OpenAI Whisper和ChatGPT/LLaMA/Mistral
 * [evadb](https://github.com/georgia-tech-db/evadb) - 用于AI应用的数据库系统
 * [langchain4j](https://github.com/langchain4j/langchain4j) - LangChain的Java版本
 * [llm-chain](https://github.com/sobelio/llm-chain) - `llm-chain` 是一个强大的 Rust 包，用于构建大型语言模型中的链条，可以帮助您对文本进行概括和完成复杂任务。
 * [langroid](https://github.com/langroid/langroid) - 使用多智能体编程来驾驭LLMs
 * [EasyEdit](https://github.com/zjunlp/easyedit) - 一个易于使用的知识编辑框架，适用于LLMs。
 * [llama_index](https://github.com/run-llama/llama_index) - LlamaIndex（原名GPT Index）是一个为您的LLM应用程序设计的数据框架。
 * [Alpaca-CoT](https://github.com/phoebussi/alpaca-cot) - 我们统一了指令调优数据（例如CoT数据），多个LLM和参数高效方法（例如lora，p-tuning）的接口，以便于使用。我们欢迎开源爱好者在这个仓库上发起任何有意义的PR，并尽可能集成更多与LLM相关的技术。
 * [azure-openai-proxy](https://github.com/stulzq/azure-openai-proxy) - Azure OpenAI 服务代理。将 OpenAI 官方 API 请求转换为 Azure OpenAI API 请求。支持 GPT-4、嵌入、Langchain。从 OpenAI 适配到 Azure OpenAI。
 * [code-review-gpt](https://github.com/mattzcarey/code-review-gpt) - 您的个人代码审查员由LLMs（OpenAI GPT-3.5/4，Llama2，Azure AI）和嵌入式技术提供支持⚡️ 提高代码质量，在您破坏生产之前捕捉错误🚀
 * [GPTRouter](https://github.com/writesonic/gptrouter) - 流畅管理多个LLM（OpenAI，Anthropic，Azure）和图像模型（Dall-E，SDXL），加快响应速度，并确保持续可靠性。
 * [dr-doc-search](https://github.com/namuan/dr-doc-search) - 与书对话 - 由GPT-3构建
 * [talk-codebase](https://github.com/rsaryev/talk-codebase) - 使用OpenAI、LlamaCpp和GPT-4-All的工具，可以与您的代码库和文档进行聊天。
 * [LLPhant](https://github.com/theodo-group/llphant) - LLPhant - 一个使用OpenAI GPT 4的综合PHP生成AI框架。受Langchain和LLamaIndex启发。
 * [Auto-Llama-cpp](https://github.com/rhohndorf/auto-llama-cpp) - 使用Llama.cpp的Auto-GPT
 * [entaoai](https://github.com/akshata29/entaoai) - 使用自己的数据进行聊天和提问。加速器可以快速上传您自己的企业数据，并使用OpenAI服务与上传的数据进行聊天和提问。
 * [kani](https://github.com/zhudotexe/kani) - kani（カニ）是一个高度可定制的微框架，用于基于聊天的语言模型和工具使用/函数调用。（NLP-OSS @ EMNLP 2023）
 * [PIXIU](https://github.com/chancefocus/pixiu) - 这个仓库介绍了PIXIU，一个开源资源，提供了第一个金融大型语言模型（LLMs），指令调整数据和评估基准，以全面评估金融LLMs。我们的目标是不断推动开放。
 * [open-webui](https://github.com/open-webui/open-webui) - ChatGPT风格的Ollama WebUI（原Ollama WebUI）
 * [CareGPT](https://github.com/wangrongsheng/caregpt) - 🌞 CareGPT (关怀GPT)是一个医疗大语言模型，同时它集合了数十个公开可用的医疗微调数据集和开放可用的医疗大语言模型，包含LLM的训练、测评、部署等以促进医疗LLM快速发展。医疗LLM，开源驱动，助力健康未来。
 * [PIXIU](https://github.com/the-finai/pixiu) - 这个仓库介绍了PIXIU，一个开源资源，包括第一个金融大型语言模型（LLMs）、指导调整数据和评估基准，以全面评估金融LLMs。我们的目标是不断推动开放。
 * [generative_ai_with_langchain](https://github.com/benman1/generative_ai_with_langchain) - 使用Python、ChatGPT和其他模型构建大型语言模型（LLM）应用程序。这是与LangChain上生成式AI书籍配套的存储库。
 * [llm-books](https://github.com/morsoli/llm-books) - 利用LLM构建应用实践笔记
 * [langflow](https://github.com/langflow-ai/langflow) - ⛓️ Langflow是一个动态图，其中每个节点都是可执行单元。其模块化和交互式设计促进了快速实验和原型设计，大力挑战创造力的极限。
 * [ChatLLM](https://github.com/yuanjie-ai/chatllm) - 轻松玩转LLM兼容openai&langchain，支持文心一言、讯飞星火、腾讯混元、智谱ChatGLM等。
 * [MiniCPM-V](https://github.com/openbmb/minicpm-v) - MiniCPM-Llama3-V 2.5：您手机上的GPT-4V级MLLM
 * [LLamaTuner](https://github.com/jianzhnie/llamatuner) - 简单高效的微调LLM模型。支持LLama、LLama2、LLama3、Qwen、Baichuan、GLM、Falcon。大模型高效量化训练+部署。
 * [langtorch](https://github.com/li2109/langtorch) - 🔥 使用Java构建可组合的LLM应用程序和工作流。
 * [dialog](https://github.com/talkdai/dialog) - RAG LLM运营应用程序，用于简单部署和测试
 * [aikit](https://github.com/sozercan/aikit) - 🏗️ 轻松微调、构建和部署开源LLMs！
 * [llm-ui](https://github.com/llm-ui-kit/llm-ui) - 用于LLMs的React库
 * [search_with_ai](https://github.com/yokingma/search_with_ai) - 🤖 免费AI搜索，💡 开源困惑度，📍 支持Ollama/SearXNG，支持Docker部署。
 * [GPT-Actions](https://github.com/anil-matcha/gpt-actions) - GPT Auth提供了一个用户友好的解决方案，可以快速设置oauth，用于您定制的GPT并自行托管。
 * [langchain-swift](https://github.com/buhe/langchain-swift) - 🚀 为Swift优化的LangChain。针对iOS、macOS、watchOS（部分）和visionOS进行了优化。（测试版）
 * [RepoAgent](https://github.com/openbmb/repoagent) - 一个由LLM驱动的存储库代理，旨在帮助开发人员和团队快速生成文档并理解存储库。
 * [obsidian-local-gpt](https://github.com/pfrankov/obsidian-local-gpt) - 本地 Ollama 和类似 OpenAI 的 GPT 的协助，以实现最大隐私和离线访问。
 * [LangChain-Chinese-Getting-Started-Guide](https://github.com/liaokongvfx/langchain-chinese-getting-started-guide) - LangChain的中文入门教程
 * [QiZhenGPT](https://github.com/cmkrg/qizhengpt) - 启真GPT：一个开源的中文医疗大语言模型
 * [azure-search-openai-javascript](https://github.com/azure-samples/azure-search-openai-javascript) - 一个在Azure上运行的检索增强生成模式的TypeScript示例应用程序，使用Azure AI Search进行检索，使用Azure OpenAI和LangChain大型语言模型（LLMs）来支持ChatGPT风格和问答体验。
 * [LLaMA-Omni](https://github.com/ictnlp/llama-omni) - LLaMA-Omni是一个基于Llama-3.1-8B-Instruct构建的低延迟和高质量的端到端语音交互模型，旨在实现类似于GPT-4o水平的语音能力。
 * [text2text](https://github.com/artitw/text2text) - 文本2文本：跨语言自然语言处理/生成工具包
 * [llama.go](https://github.com/gotzmann/llama.go) - llama.go就像纯Go语言中的llama.cpp一样！
 * [autolabel](https://github.com/refuel-ai/autolabel) - 使用LLMs对文本数据集进行标记、清洗和丰富。
 * [agentops](https://github.com/agentops-ai/agentops) - Python SDK用于AI代理监控，LLM成本跟踪，基准测试等。与大多数LLM和代理框架集成，如CrewAI，Langchain和Autogen。
 * [CyberScraper-2077](https://github.com/itsowen/cyberscraper-2077) - 由LLM | OpenAI，Gemini和Ollama提供支持的强大网络爬虫
 * [MLE-agent](https://github.com/mlsysops/mle-agent) - 🤖 MLE-Agent：您无缝AI工程和研究的智能伴侣。🔍 与arxiv和paper with code集成，提供更好的代码/研究计划 🧰 支持OpenAI、Anthropic、Ollama等。:fireworks: Code RAG
 * [sage](https://github.com/storia-ai/sage) - 在两分钟内与任何代码库进行聊天 | 完全本地或通过第三方API
 * [rocketnotes](https://github.com/fynnfluegge/rocketnotes) - AI 动力的 Markdown 笔记应用程序-利用矢量嵌入和 LLMs 与您的个人笔记-100% 本地或在云端
 * [search2ai](https://github.com/fatwang2/search2ai) - 在线帮助您的LLMs


## Unity

 * [ChatAI](https://github.com/diegocambiaso/chatai) - Mozilla社区目录——所有Mozilla贡献者的集中目录！
 * [llama-hub](https://github.com/emptycrown/llama-hub) - 由社区制作的LLM数据加载器库，可与GPT Index和/或LangChain一起使用。
 * [AICommand](https://github.com/keijiro/aicommand) - ChatGPT与Unity编辑器的集成
 * [AIShader](https://github.com/keijiro/aishader) - ChatGPT驱动的Unity着色器生成器
 * [ChatGPT-API-unity](https://github.com/mochi-neko/chatgpt-api-unity) - 将ChatGPT聊天完成API绑定到Unity的纯C#上。
 * [OpenAI-Unity](https://github.com/srcnalt/openai-unity) - 一个非官方的OpenAI Unity包，旨在帮助您直接在Unity游戏引擎中使用OpenAI API。
 * [UnityChatGPT](https://github.com/dilmerv/unitychatgpt) - 在Unity中使用Chat GPT的几个示例
 * [gptcache](https://github.com/zilliztech/gptcache) - @ferret_db @ossinsight @milvusio 我们很想为gptcache获取一个ferretdb后端。我们会将其添加到待办列表中。代表milvus开发者和更广泛的社区，感谢你们的支持！
 * [unity-AI-Chat-Toolkit](https://github.com/zhangliwei7758/unity-ai-chat-toolkit) - 使用Unity实现AI聊天相关功能。目前这个库包含了对ChatGPT、ChatGLM等大语言模型的API调用的代码实现以及实现了微软Azure以及百度AI的语音服务功能，语音服务均采用Web API实现，支持Windows/WebGL/Android等平台。
 * [open-ai](https://github.com/orhanerday/open-ai) - OpenAI PHP SDK：最受欢迎、被Fork最多、贡献最多、拥有庞大社区支持的PHP（Laravel、Symfony、Yii、Cake PHP或任何PHP框架）SDK，用于OpenAI GPT-3和DALL-E。它还支持类似ChatGPT的流式聊天。（支持ChatGPT AI）
 * [betterscan-ce](https://github.com/marcinguy/betterscan-ce) - 使用多种工具/扫描器进行代码扫描/SAST/静态分析/代码检查 + OpenAI GPT 生成一份报告（代码，IaC）- Betterscan 社区版（CE）输出：
 * [open-saas](https://github.com/wasp-lang/open-saas) - 一个免费、开源的React和Node.js SaaS应用程序启动器，具有超强功能。可用于生产环境。由社区驱动。
 * [betterscan-ce](https://github.com/topcodersonline-solutions/betterscan-ce) - 使用多种工具/扫描仪进行代码扫描/SAST/静态分析/代码检查 + OpenAI GPT 生成一份报告（代码、IaC）- Betterscan 社区版（CE）输出：Code Scanning/SAST/Static Analysis/Linting using many tools/Scanners + OpenAI GPT with One Report (Code, IaC) - Betterscan 社区版 (CE)
 * [betterscan-ce](https://github.com/tcosolutions/betterscan-ce) - 使用多种工具/扫描仪进行代码扫描/SAST/静态分析/代码检查 + OpenAI GPT 生成一份报告（代码、IaC）- Betterscan社区版（CE）输出：使用多种工具/扫描仪进行代码扫描/SAST/静态分析/代码检查 + OpenAI GPT 生成一份报告（代码、IaC）- Betterscan社区版（CE）
 * [openai-kit](https://github.com/dylanshine/openai-kit) - 一个用于与OpenAI API交互的社区Swift软件包


## Openai

 * [Auto-GPT](https://github.com/torantulino/auto-gpt) - 高级游戏工程项目 - 立方体像素游戏制作器
 * [BlenderGPT](https://github.com/gd3kr/blendergpt) - 使用英语命令来控制Blender和OpenAI的GPT-4。
 * [evals](https://github.com/openai/evals) - Evals是一个用于评估OpenAI模型的框架和一个开源的基准测试注册表。
 * [VulChatGPT](https://github.com/ke0z/vulchatgpt) - 使用IDA PRO HexRays反编译器和OpenAI(ChatGPT)来查找二进制文件中可能存在的漏洞。
 * [OpenChatKit](https://github.com/togethercomputer/openchatkit) - #openchatkit是第一个开源替代#chatgpt的选择！🤯它是由前@openai人员（@togethercompute）构建的20b参数模型，并使用@aieleuther的gpt-neox-20b进行了微调！🔗演示：🐙gh：📽️视频：@itakgol ↓
 * [chatgpt-python](https://github.com/labteral/chatgpt-python) - OpenAI的ChatGPT非官方Python SDK
 * [gpt-commit](https://github.com/markuswt/gpt-commit) - 使用ChatGPT生成提交信息
 * [tiktoken](https://github.com/openai/tiktoken) - tiktoken是一种快速的BPE分词器，可用于OpenAI的模型。
 * [wolverine](https://github.com/biobootloader/wolverine) - @denfromufa @openai 不错的工具！但我想要一个可以在我的终端中与GPT-4聊天的工具，就像这样的东西。
 * [chatgpt-clone](https://github.com/amrrs/chatgpt-clone) - 使用OpenAI API和Gradio构建自己的ChatGPT
 * [pyChatGPT](https://github.com/terry3041/pychatgpt) - OpenAI的ChatGPT API的非官方Python封装程序
 * [davinci-functions](https://github.com/odashi/davinci-functions) - 使用Python运行时向OpenAI GPT询问生成对象的库。
 * [chatgpt_ros](https://github.com/koichirokato/chatgpt_ros) - ChatGPT API的ROS包装器
 * [genai](https://github.com/noteable-io/genai) - 如果GPT能帮助你记笔记会怎样？
 * [GPTReview](https://github.com/iejmac/gptreview) - 使用OpenAI GPT模型来审核您的PR。
 * [scrapeghost](https://github.com/jamesturk/scrapeghost) - 👻 使用OpenAI的GPT API进行网站爬取的实验性库。
 * [Auto-GPT](https://github.com/significant-gravitas/auto-gpt) - 一个试图让GPT-4完全自主的实验性开源尝试。
 * [openai_tools](https://github.com/alleninstitute/openai_tools) - 使用ChatGPT API探索PDF出版物的脚本集正在增长。
 * [openai-cookbook](https://github.com/openai/openai-cookbook) - 使用OpenAI API的示例和指南
 * [disco-diffusion](https://github.com/alembics/disco-diffusion) - openai开发的ai模型目前比较知名的有：#chatgpt、#midjourney、#stablediffusionchat。今天为大家更新5个好用的ai算法模型学习渠道1、神力中文ai算法市场：、disco-diffusion型：、百度文心ernie-vilg：openai开发的AI模型目前比较知名的有：#chatgpt、#midjourney、#stablediffusionchat。今天为大家更新5个好用的AI算法模型学习渠道，包括：1、神力中文AI算法市场；2、disco-diffusion型；3、百度文心ernie-vilg。
 * [chatgpt-mac](https://github.com/vincelwt/chatgpt-mac) - ChatGPT for Mac，常驻在您的菜单栏中。
 * [everything-chatgpt](https://github.com/terminalcommandnewsletter/everything-chatgpt) - :mag: 探索ChatGPT网络应用程序(chat.openai.com)的内部运作，当然还有一些猜测。
 * [userscripts](https://github.com/adamlui/userscripts) - 🐵 MTurk、ChatGPT和其他Greasemonkey用户脚本。
 * [chatgpt-mirror](https://github.com/yuezk/chatgpt-mirror) - 基于gpt-3.5-turbo模型的ChatGPT镜像。
 * [ChatGPTCustomizer](https://github.com/soulhighwing/chatgptcustomizer) - ChatGPTCustomizer可以通过使用ChatGPT API的功能来个性化您的聊天体验。
 * [gptproxy](https://github.com/xicilion/gptproxy) - 使用GitLab API密钥代理OpenAI API。
 * [cloudflare-proxy](https://github.com/barretlee/cloudflare-proxy) - Cloudflare Worker 代理请求 ChatGPT API，支持 Stream 流式输出Cloudflare Worker 代理请求 ChatGPT API，支持 Stream 流式输出
 * [vscode-chatgpt](https://github.com/gencay/vscode-chatgpt) - 一个非官方的Visual Studio Code - OpenAI ChatGPT集成
 * [chatgpt-demo](https://github.com/ddiu8081/chatgpt-demo) - 一个基于OpenAI API的演示仓库。
 * [OpenGpt](https://github.com/futantan/opengpt) - 在几秒钟内创建您自己的ChatGPT应用程序。
 * [chatgpt-vercel](https://github.com/ourongxing/chatgpt-vercel) - 优雅而强大。由OpenAI和Vercel提供支持。
 * [ts-chatgpt](https://github.com/takagimeow/ts-chatgpt) - 一个专门用于接收使用官方ChatGPT API打字的纯响应的图书馆。
 * [openai-node](https://github.com/openai/openai-node) - OpenAI API 的 Node.js 库
 * [nextjs-openai-doc-search](https://github.com/supabase-community/nextjs-openai-doc-search?og=v2) - 使用Next.js、OpenAI和Supabase构建自定义ChatGPT风格文档搜索的模板。
 * [gptagent.js](https://github.com/lgrammel/gptagent.js) - 使用TS/JS构建AI代理
 * [M5Unified_StackChan_ChatGPT](https://github.com/robo8080/m5unified_stackchan_chatgpt) - 这是搭载了ChatGPT API的AI聊天机器人。
 * [whisper.cpp](https://github.com/ggerganov/whisper.cpp) - OpenAI的Whisper模型的C/C++端口
 * [ChatGPT](https://github.com/lencx/chatgpt) - 🔮 ChatGPT 桌面应用程序（Mac、Windows 和 Linux）
 * [chat-ai-desktop](https://github.com/sonnylazuardi/chat-ai-desktop) - 使用Tauri和Rust的非官方ChatGPT桌面应用程序，适用于Mac和Windows菜单栏。
 * [chatgpt-dingtalk](https://github.com/eryajf/chatgpt-dingtalk) - 🔔 钉钉 & 🤖 GPT-3.5 让你的工作效率直接起飞 🚀 私聊群聊方式、单聊串聊模式、角色扮演、图片创作 🚀
 * [go-openai](https://github.com/sashabaranov/go-openai) - OpenAI ChatGPT、GPT-3、GPT-4、DALL·E、Whisper API Go包装器
 * [feishu-chatgpt](https://github.com/leizhenpeng/feishu-chatgpt) - 🎒飞书  ×（GPT-3.5 + DALL·E + Whisper）=  飞一般的工作体验  🚀 语音对话、角色扮演、多话题讨论、图片创作、表格分析、文档导出 🚀
 * [k8sgpt](https://github.com/k8sgpt-ai/k8sgpt) - 赋予每个人 Kubernetes SRE 的超能力
 * [ChatGPT-Proxy-V4](https://github.com/acheong08/chatgpt-proxy-v4) - 基于“puid”的Cloudflare绕过OpenAI
 * [chat-gpt-ppt](https://github.com/williamfzc/chat-gpt-ppt) - 使用ChatGPT（或其他后端）自动生成PPT，全部在一个单一文件中。
 * [CallGPT](https://github.com/dmingod/callgpt) - 从您的计算机调用ChatGPT API的简单方法
 * [dev-gpt](https://github.com/sampink/dev-gpt) - dev-gpt，一个自动化的Python开发者
 * [ruby-openai](https://github.com/alexrudall/ruby-openai) - OpenAI API + Ruby！🤖❤️ 现在支持ChatGPT和Whisper...
 * [openai_pipe](https://github.com/aesthetikx/openai_pipe) - 一个UNIX风格的OpenAI接口
 * [gptchatteR](https://github.com/isinaltinkaya/gptchatter) - 一个用于在R中与OpenAI GPT模型交互的实验性和非官方的包装器。
 * [askgpt](https://github.com/jbgruber/askgpt) - 基于OpenAI API端点构建的聊天界面
 * [openai](https://github.com/samterfa/openai) - 这个 R 包提供了一个 Open AI API 的 SDK。
 * [ChatGptNet](https://github.com/marcominerva/chatgptnet) - 一个用于.NET的ChatGPT集成库
 * [Simple-ChatGPT-API-Desktop](https://github.com/cranot/simple-chatgpt-api-desktop) - 桌面版简易ChatGPT API
 * [openai-gpt-dev-notes-for-cn-developer](https://github.com/easychen/openai-gpt-dev-notes-for-cn-developer) - 如何快速开发一个OpenAI/GPT应用：国内开发者笔记
 * [cheetah](https://github.com/leetcode-mafia/cheetah) - Whisper和基于GPT的应用程序，用于通过远程SWE面试Whisper和基于GPT的应用程序，用于通过远程SWE面试
 * [ChatGPTSwift](https://github.com/alfianlosari/chatgptswift) - 使用Swift访问ChatGPT API
 * [nitmgpt](https://github.com/deskbtm/nitmgpt) - nitmgpt（中间通知GPT）。通过ChatGPT过滤广告或垃圾通知。
 * [iChatGPT](https://github.com/37ios/ichatgpt) - OpenAI ChatGPT SwiftUI 应用程序适用于 iOS、iPadOS 和 macOS。
 * [SwiftOpenAI](https://github.com/swiftbeta/swiftopenai) - 使用Swift ❤️构建的OpenAI API
 * [OpenAISwift](https://github.com/adamrushy/openaiswift) - 这是一个围绕ChatGPT和OpenAI HTTP API的包装库。
 * [whetstone.chatgpt](https://github.com/johniwasz/whetstone.chatgpt) - 一个简单轻量级的库，包装了Open AI API。
 * [subvert](https://github.com/aschmelyun/subvert) - 在几秒钟内从视频中生成字幕、摘要和章节
 * [carrot](https://github.com/xx025/carrot) - 免费ChatGPT站点列表，包含100+个镜像站点，方便使用。
 * [impressive-chatgpt](https://github.com/sw33tlie/impressive-chatgpt) - OpenAI的chatgpt收集了许多令人印象深刻和有用的结果。
 * [bbFuzzing.txt](https://github.com/reewardius/bbfuzzing.txt) - bbfuzzing.txt这是一个独特的词汇表，其中70%是由openai chatgpt生成的，剩下的30%是来自bo0om、circuit和其他bugbounters的字典编译而成。#chatgpt
 * [chat-with-chatgpt](https://github.com/second-state/chat-with-chatgpt) - 通过 GitHub 问题评论与 ChatGPT 聊天。
 * [ChatGPT](https://github.com/hemulgm/chatgpt) - ChatGPT 本地桌面应用程序（Windows、Mac、Android、iOS 和 Linux）
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt#%e5%ae%89%e8%a3%85%e6%b8%a0%e9%81%93) - ChatGPT畅聊插件。解决所有报错，让我们的AI体验无比顺畅、丝滑、高效。并且持续更新更多的增强功能，包括取消审计、克隆对话、净化首页等等。
 * [claude-to-chatgpt](https://github.com/jtsang4/claude-to-chatgpt) - 该项目将Anthropic的Claude模型的API转换为OpenAI Chat API格式。
 * [anse](https://github.com/anse-app/anse) - ChatGPT、DALL-E和Stable Diffusion的超级体验。
 * [chatgpt-demo](https://github.com/anse-app/chatgpt-demo) - ChatGPT的最小Web用户界面。
 * [casdoor](https://github.com/casdoor/casdoor) - 一个由Casbin和AI网关驱动的开源身份和访问管理（IAM）/单点登录（SSO）平台，具有支持OAuth 2.0、OIDC、SAML和OpenAI ChatGPT的Web UI。
 * [JetChatGPT](https://github.com/thekharche/jetchatgpt) - 使用OpenAI API在Jetpack Compose中实现ChatGPT
 * [cosmosdb-chatgpt](https://github.com/azure-samples/cosmosdb-chatgpt) - 结合Azure Cosmos DB和Azure OpenAI ChatGPT服务的示例应用程序
 * [ix](https://github.com/kreneskyp/ix) - 自主GPT-4代理平台
 * [openai-cloudflare](https://github.com/janlay/openai-cloudflare) - 一个在Cloudflare worker上运行的OpenAI API代理。
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt#%e5%85%b3%e4%ba%8e-%e5%8f%96%e6%b6%88%e5%ae%a1%e8%ae%a1-%e5%8a%9f%e8%83%bd) - 这是一个ChatGPT的畅聊与增强插件。开源免费。不仅能解决所有报错不再刷新，还有保持活跃、取消审计、克隆对话、净化首页、展示大屏、展示全屏、言无不尽、拦截跟踪、日新月异等多个高级功能。让我们的AI体验无比顺畅、丝滑、高效、简洁。
 * [cf-openai-azure-proxy](https://github.com/haibbo/cf-openai-azure-proxy) - 一个Cloudflare工作脚本，用于代理OpenAI向Azure OpenAI服务发出的请求。
 * [polyglot](https://github.com/liou666/polyglot) - 🤖️ 桌面端人工智能语言练习应用
 * [k8sgpt-operator](https://github.com/k8sgpt-ai/k8sgpt-operator) - 在您的Kubernetes集群中自动获得SRE超能力
 * [obsidian-smart-connections](https://github.com/brianpetro/obsidian-smart-connections) - 在Obsidian中使用笔记进行聊天！此外，实时查看最相关的内容！互动并保持组织。由OpenAI ChatGPT、GPT-4和嵌入式技术提供支持。
 * [nextjs-openai-doc-search](https://github.com/supabase-community/nextjs-openai-doc-search) - 使用Next.js、OpenAI和Supabase构建自定义ChatGPT风格文档搜索的模板。
 * [reliableGPT](https://github.com/berriai/reliablegpt) - 从OpenAI获得100%的正常运行时间和可靠性。处理速率限制、超时、API和密钥错误。
 * [pva-aoai-integration-solution](https://github.com/city-of-kobe/pva-aoai-integration-solution) - 中身并不重要，但作为地方政府的努力是非常有趣的。Azure OpenAI——这个存储库是为了将在神户市政府进行ChatGPT试用的流程等转化为解决方案并公开而创建的。
 * [jp-azureopenai-samples](https://github.com/azure-samples/jp-azureopenai-samples) - 日本微软发布了GPT的参考架构。基于日语的场景的示例实现应有尽有！如果掌握了这个存储库，会有很多进展。有日志和认证等功能真是太好了。~示例列表~1. 面向呼叫中心的GPT助手...
 * [iChatGPT](https://github.com/37mobileteam/ichatgpt) - OpenAI ChatGPT SwiftUI 应用程序适用于 iOS、iPadOS 和 macOS。
 * [zod-gpt](https://github.com/dzhng/zod-gpt) - 从OpenAI和Anthropic模型中获取结构化、完全类型化和经过验证的JSON输出。
 * [ai-beehive](https://github.com/hncboy/ai-beehive) - AI蜂巢，基于Java使用Spring Boot 3和JDK 17，支持的功能有ChatGPT、OpenAi Image、Midjourney、NewBing等等。
 * [cloudflare-reverse-proxy](https://github.com/gaboolic/cloudflare-reverse-proxy) - cloudflare反向代理|OpenAI/ChatGPT 免翻墙代理|github免翻墙代理|github下载加速|google代理|cloudflare万能代理cloudflare反向代理|OpenAI/ChatGPT 免翻墙代理|github免翻墙代理|github下载加速|google代理|cloudflare万能代理
 * [opengpt](https://github.com/gngpp/opengpt) - 一个反向工程的非官方ChatGPT代理（绕过Cloudflare 403访问被拒绝）
 * [chatgpt-plus](https://github.com/yangjian102621/chatgpt-plus) - 基于 OpenAI API 实现的 ChatGPT Web 应用，包括通用版和角色版。自带管理后台，采用 Go + Vue3 + element-plus 实现。
 * [springboot-openai-chatgpt](https://github.com/274056675/springboot-openai-chatgpt) - 超级AI大脑是一个基于Spring Boot架构的系统，支持web、Android、IOS和H5多端应用。它使用了OpenAI的ChatGPT模型来实现智能聊天机器人。用户可以在界面上与聊天机器人进行对话，聊天机器人会根据用户的输入自动生成回复。同时，它还支持画图功能，用户只需输入文本，系统就能自动制作出相应的图形。未来，我们还会接入文心一言、通义千问、MOSS等国产AI大模型，并持续更新，更多功能等着你来解锁。
 * [chatgpt-quickstart](https://github.com/azure-samples/chatgpt-quickstart) - 使用Azure OpenAI和ChatGPT构建一个聊天应用程序。
 * [autoblogger](https://github.com/incomestreamsurfer/autoblogger) - 这是一个使用ChatGPT API和Stable Diffusion API的自动博客工具，可以创建完全优化的博文并自动发布到WordPress。
 * [chatserver-api](https://github.com/wooveep/chatserver-api) - 基于OPENAI的ChatGPT API开发的AI助手系统 Chatserver-web 支持本地数据向量话提问 基于Golang语言的后端API服务
 * [laravel-synth](https://github.com/blinq-dev/laravel-synth) - 使用ChatGPT生成Laravel代码
 * [openai-billing-query](https://github.com/woodchen-ink/openai-billing-query) - 这是一个单页面项目，可以批量可视化查询openai(chatgpt)的余额。支持显示总量、已使用量、剩余量、使用比例、到期时间、GPT-4以及是否绑定卡片。
 * [aks-openai](https://github.com/azure-samples/aks-openai) - 使用Azure Cosmos示例来利用图形API帐户的批量功能
 * [function-gpt](https://github.com/atinylittleshell/function-gpt) - 这是一个帮助处理使用OpenAI的ChatGPT API进行函数调用的TypeScript库。
 * [chef-gpt](https://github.com/giacomogaglione/chef-gpt) - 可定制的食谱生成器，由OpenAI和ChatGPT驱动。使用Next.Js、Tailwind CSS、Radix UI、Supabase Clerk构建。
 * [gpt4docstrings](https://github.com/michaelistrofficus/gpt4docstrings) - 使用OpenAI ChatGPT生成Python文档字符串！！
 * [power-chatgpt](https://github.com/youngle316/power-chatgpt) - 一个用于ChatGPT的强大工具
 * [cg](https://github.com/25077667/cg) - 使用OpenAI的chatGPT免费提交
 * [ninja](https://github.com/gngpp/ninja) - 逆向工程的ChatGPT代理
 * [free-chat](https://github.com/cnseniorious000/free-chat) - 派生自@anse-app/chatgpt-demo。索引网站位于https://free-chat.asia/。
 * [Vontigo](https://github.com/vontigo/vontigo) - 🛸 Vontigo 是一个使用 SvelteKit 构建的开源 CMS，具备 🤖 AI 动力（ChatGPT）的内容生成功能。Vontigo 具有快速页面加载和无缝路由，提供了一个用户友好的界面，可定制主题和模板。
 * [7-docs](https://github.com/7-docs/7-docs) - 使用任何公共GitHub存储库作为源，并通过ChatGPT提出问题。
 * [chatgpt-pre-commit-hooks](https://github.com/dariuszporowski/chatgpt-pre-commit-hooks) - 预提交钩子集合，利用ChatGPT和OpenAI平台来验证对代码库所做的更改。使用ChatGPT和OpenAI平台的预提交钩子集合，用于验证对代码库所做的更改。
 * [chatpad](https://github.com/deiucanta/chatpad) - 不仅仅是另一个ChatGPT用户界面！
 * [chatgpt-nuxt](https://github.com/lianginx/chatgpt-nuxt) - 基于 Nuxt.js 框架的 ChatGPT 类项目，支持 OpenAI 和 Azure 两种 API 切换，支持黑暗模式、中英日多语言切换。
 * [chat](https://github.com/libli/chat) - 具备用户管理功能的ChatGPT API透明代理后台
 * [chatgpt-nodejs-web](https://github.com/xingxin666/chatgpt-nodejs-web) - chatgpt nodejs服务，集成了ChatGLM、GPT3.5、GPT4、GPT联网、必应、Claude、百度文心一言等模型chatgpt nodejs服务，集成了ChatGLM、GPT3.5、GPT4、GPT联网、必应、Claude、百度文心一言等模型
 * [chatgpt-ui](https://github.com/dvcrn/chatgpt-ui) - ChatGPT UI带有身份验证，针对商业用例，使用Elixir + LiveView编写的界面。
 * [chatgpt-ai-template](https://github.com/horizon-ui/chatgpt-ai-template) - 🧠 Horizon AI模板 - 最时尚的开源ChatGPT UI AI模板和React、NextJS、Chakra UI的入门套件
 * [chatgpt-history-export-to-md](https://github.com/mohamed-chs/chatgpt-history-export-to-md) - 一个脚本，可以轻松地从JSON文件中提取您的整个ChatGPT数据导出，并将其转换为格式良好的markdown文件。
 * [chatgpt-aoai](https://github.com/karleeov/chatgpt-aoai) - 使用Azure OpenAI创建您自己的ChatGPT门户
 * [siyuan](https://github.com/siyuan-note/siyuan) - 一个以隐私为先、自托管、完全开源的个人知识管理软件，使用TypeScript和Golang编写。
 * [Free-ChatGPT-API](https://github.com/mufeng510/free-chatgpt-api) - 基于Pandora的ChatGPT API，实现了池令牌的自动更新。
 * [QChatGPT](https://github.com/rockchinq/qchatgpt) - 😎高稳定性、🧩支持插件、🌏实时联网的 ChatGPT QQ 机器人🤖 | 支持 ChatGPT、New Bing、Claude、Google Bard、gpt4free、One API 的 QQ 机器人平台
 * [novel](https://github.com/steven-tey/novel) - 具有AI驱动的自动完成功能的Notion风格所见即所得编辑器。
 * [feishu-openai](https://github.com/connectai-e/feishu-openai) - 🎒 飞书 ×（GPT-4 + DALL·E-3 + Whisper）= 飞一般的工作体验 🚀 语音对话、角色扮演、多话题讨论、图片创作、表格分析、文档导出 🚀
 * [openai](https://github.com/betalgo/openai) - OpenAI .NET SDK - ChatGPT、Whisper、GPT-3、GPT-4、Azure OpenAI 和 DALL-E
 * [chatgpt](https://github.com/dirk1983/chatgpt) - 全网最易部署，响应速度最快的ChatGPT环境。PHP版调用OpenAI接口进行问答和画图，采用Stream流模式通信，一边生成一边输出。前端采用EventSource，支持Markdown格式解析，支持公式显示，代码有着色处理，支持画图。页面UI简洁，支持上下文连续会话。源码只有几个文件，没用任何框架，支持所有PHP版本，全部开源，极易二开。保姆级教程，全部周边资源，欢迎进群交流，一切全免费。
 * [Dingtalk-OpenAI](https://github.com/connectai-e/dingtalk-openai) - 🎒 钉钉和🤖 GPT-3.5可以让你的工作效率直接提升🚀。它支持私聊和群聊方式，还有单聊和串聊模式。此外，它还可以进行角色扮演和图片创作🚀。
 * [chatgpt-web](https://github.com/niek/chatgpt-web) - ChatGPT 网页界面使用 OpenAI API
 * [OpenAI-API-dotnet](https://github.com/okgodoit/openai-api-dotnet) - 一个非官方的C#/.NET SDK，用于访问OpenAI GPT-3 API。
 * [ChatGPT_JCM](https://github.com/202252197/chatgpt_jcm) - OpenAI管理界面，聚合了OpenAI的所有接口进行界面操作(所有模型、图片、音频、微调、文件)等，支持Markdown格式(公式、图表，表格)等，后期会一点一点地将OpenAI接口进行接入大家支持一下，右上角点个Star，我会一直更新下去，大家一起学习，一起加油，一起努力，一起成长。
 * [aiac](https://github.com/gofireflyio/aiac) - 人工智能基础设施即代码生成器。
 * [openai](https://github.com/anasfik/openai) - ChatGPT和所有OpenAI API（GPT、Dall-e等）的Dart/Flutter SDK
 * [chat](https://github.com/swuecho/chat) - 用于团队的聊天网络应用程序，具有用户管理和速率限制，支持ChatGPT（OpenAI和Azure），Claude或自定义模型。输出：团队聊天的网络应用程序，具有用户管理和速率限制，支持ChatGPT（OpenAI和Azure），Claude或自定义模型。
 * [VirtualWife](https://github.com/yakami129/virtualwife) - VirtualWife是一个虚拟数字人项目，项目还处于孵化阶段，有很多需要优化的地方，作者想打造一个拥有自己“灵魂”的虚拟数字人，你可以像朋友一样和她相识，作者希望虚拟数字人融入人类生活，作为恋爱导师，心理咨询师，解决人类的情感需求。
 * [copilot-gpt4-service](https://github.com/aaamoon/copilot-gpt4-service) - 将Github Copilot的请求转换为ChatGPT的请求，可以免费使用GPT-4模型。
 * [PatrikZeros-ChatGPT-API-UI](https://github.com/patrikzudel/patrikzeros-chatgpt-api-ui) - 静态网页，允许您使用OpenAI API密钥，获得与ChatGPT相同的体验！
 * [NeuroGPT](https://github.com/neurogen-dev/neurogpt) - 免费聊天GPT 3.5 / 聊天GPT 4 | 免费OpenAI / 聊天GPT API
 * [ant-codeAI](https://github.com/sparrow-js/ant-codeai) - AI生成代码
 * [BestGPTs](https://github.com/agentops-ai/bestgpts) - 排名靠前的OpenAI GPTs
 * [chat_gpt_sdk](https://github.com/redevrx/chat_gpt_sdk) - Flutter ChatGPT是一个基于Flutter框架开发的聊天机器人应用。它使用了OpenAI的ChatGPT模型，可以与用户进行自然语言交互。用户可以通过输入文本与ChatGPT进行对话，ChatGPT会根据用户的输入生成相应的回复。这个应用可以用于开发各种类型的聊天机器人，如客服机器人、智能助手等。Flutter ChatGPT具有良好的用户界面和交互体验，可以在移动设备上运行。
 * [chatgpt-web](https://github.com/chatgpt-web-dev/chatgpt-web) - 使用 Express 和 Vue3 构建的 ChatGPT。该项目是从 Chanzhaoyu/chatgpt-web 分支出来的，新增了多租户管理和云端消息同步功能。基于 MIT 协议，免费且可用于开源学习。
 * [tiktoken-go](https://github.com/pkoukk/tiktoken-go) - tiktoken的Go版本
 * [openai-proxy](https://github.com/unickcheng/openai-proxy) - openai-proxy是为中国用户提供的解决方案，用于解决无法向OpenAI API发出请求的问题。
 * [hello-ai](https://github.com/xxxily/hello-ai) - 抢走你工作的不是AI，而是掌握使用AI工具的人。降维打击最为致命：毁灭你，与你何干《三体》
 * [ChatGPT-Paper-Reader](https://github.com/talkingwallace/chatgpt-paper-reader) - 这个仓库提供了一个简单的界面，帮助您阅读和总结PDF格式的研究论文。阅读后您可以提出一些问题。这个界面是基于openai API开发的，使用了GPT-3.5-turbo模型。
 * [lux-admin-vuetify3](https://github.com/yangjiakai/lux-admin-vuetify3) - 基于Vue3.2、Vite4.1、TypeScript、Vuetify3、Chat GPT、Firebase等创建最佳管理员。
 * [gpt-tokenizer](https://github.com/niieani/gpt-tokenizer) - JavaScript BPE Tokenizer编码器解码器适用于OpenAI的GPT-2 / GPT-3 / GPT-4。具有额外功能的OpenAI的tiktoken端口。
 * [tiktokenizer](https://github.com/dqbd/tiktokenizer) - 在线游乐场，用于OpenAPI令牌化器
 * [cognee](https://github.com/topoteretes/cognee) - AI应用程序和AI代理的内存管理
 * [finance](https://github.com/saleem-hadad/finance) - 💰 由ChatGPT提供支持的免费开源个人财务跟踪网络应用程序。
 * [chatgpt-web](https://github.com/xqdoo00o/chatgpt-web) - 基于OpenAI API的纯JavaScript ChatGPT演示
 * [one-api](https://github.com/martialbe/one-api) - OpenAI 接口管理 & 分发系统，改自songquanpeng/one-api。支持更多模型，加入统计页面，完善非openai模型的函数调用。 OpenAI接口管理和分发系统，基于songquanpeng/one-api进行改进。支持更多模型，添加统计页面，完善非OpenAI模型的函数调用。
 * [lux-ui](https://github.com/yangjiakai/lux-ui) - 基于Vue3.x、Vite5.x、TypeScript、Vuetify3.x和Chat GPT创建最佳管理员
 * [chatgpt-pro](https://github.com/eyucoder/chatgpt-pro) - ChatGPT-Pro是一个先进的应用程序，结合了ChatGPT和DALL.E的强大功能。
 * [AI-Functions](https://github.com/torantulino/ai-functions) - AI 功能魔法：使用 GPT 模型再也不需要编码了！
 * [chat2api](https://github.com/lanqian528/chat2api) - 一个可以将网络上的ChatGPT转换为OpenAI API格式的服务。
 * [ai-codereviewer](https://github.com/freeedcom/ai-codereviewer) - AI 代码审查员：通过使用 AI 强化您的 GitHub 工作流程！使用 OpenAI 的 GPT-4 API 在拉取请求上获得智能反馈和建议，提高代码质量，节省开发人员的时间。
 * [yomo](https://github.com/yomorun/yomo) - 🦖 用于构建地理分布式边缘人工智能基础设施的有状态无服务器框架
 * [Gumroad-Landing-Page-Generator](https://github.com/peterw/gumroad-landing-page-generator) - 这个项目是一个Python脚本，从Gumroad网站上爬取数据，使用OpenAI的GPT-4模型生成一个色彩丰富、设计精美的HTML页面，并部署生成的页面到Vercel。
 * [ninja](https://github.com/0x676e67/ninja) - 逆向工程ChatGPT代理
 * [chatgpt-adapter](https://github.com/bincooo/chatgpt-adapter) - 集成了openai-api、bing、gemini、coze、绘画 多款AI的聊天接口适配到 OpenAI API 标准接口服务端。
 * [ChatGPT.Net](https://github.com/pawanosman/chatgpt.net) - OpenAI API 免费反向代理
 * [hisabi](https://github.com/hisabi-app/hisabi) - 💰 由ChatGPT提供支持的免费开源个人财务跟踪网络应用程序。
 * [stride-gpt](https://github.com/mrwadams/stride-gpt) - 一种利用OpenAI的GPT模型生成给定应用程序的威胁模型的AI动力威胁建模工具，基于STRIDE方法论。
 * [generative-manim](https://github.com/360macky/generative-manim) - 🎨 视频生成的GPT ⚡️
 * [celeris-web](https://github.com/kirklin/celeris-web) - Celeris Web 是一个高性能且可定制的前端开发模板，使用了Vue 3、Vite 和 TypeScript 构建。它具有最新的语法、组件和 API 自动导入、状态管理、中文字体预设、国际化等功能。
 * [liboai](https://github.com/d7ead/liboai) - 一个用于访问整个OpenAI API的C++17库。
 * [tiktoken-rs](https://github.com/zurawiki/tiktoken-rs) - 使用GPT和tiktoken的现成分词库
 * [ai-commit](https://github.com/guanguans/ai-commit) - 使用 AI 自动化生成传统的 git 提 commit 信息。
 * [MatGPT](https://github.com/toshiakit/matgpt) - MATLAB 应用程序可访问 OpenAI 的 ChatGPT API
 * [one-hub](https://github.com/martialbe/one-hub) - OpenAI 接口管理 & 分发系统，改自songquanpeng/one-api。支持更多模型，加入统计页面，完善非openai模型的函数调用。 OpenAI接口管理和分发系统，基于songquanpeng/one-api进行改进。支持更多模型，添加统计页面，完善非OpenAI模型的函数调用。
 * [whodb](https://github.com/clidey/whodb) - 一个轻量级的下一代数据浏览器 - Postgres，MySQL，SQLite，MongoDB，Redis，MariaDB和Elastic Search，带有聊天界面
 * [sum4all](https://github.com/fatwang2/sum4all) - 网页、视频、图片大模型总结
 * [Pet-GPT](https://github.com/hanzoe/pet-gpt) - Pet-GPT 是一个使用 PyQt 编写的桌面宠物程序，支持调用 OpenAI 的 GPT 进行上下文对话，然后主动找你聊天！
 * [PureChat](https://github.com/hyk260/purechat) - PureChat 是一个集成 ChatGPT 的聊天应用，基于 Vue3，Vite5，Electron 开发。
 * [OpenGPT-4o](https://github.com/kingnish24/opengpt-4o) - OpenGPT 4o是OpenAI GPT 4o的免费替代品。
 * [aoai-realtime-audio-sdk](https://github.com/azure-samples/aoai-realtime-audio-sdk) - Azure OpenAI代码资源，用于使用gpt-4o实时功能。
 * [inbox-zero](https://github.com/elie222/inbox-zero) - 开源电子邮件应用程序，快速达到收件箱零。
 * [ToolJet](https://github.com/tooljet/tooljet) - 用于构建业务应用程序的低代码平台。连接到数据库、云存储、GraphQL、API端点、Airtable、Google表格、OpenAI等，并使用拖放应用程序构建器构建应用程序。使用JavaScript/TypeScript构建。🚀
 * [AutoGPT](https://github.com/significant-gravitas/autogpt) - AutoGPT是让每个人都能够使用和构建的AI的愿景。我们的使命是提供工具，让您可以专注于重要的事情。
 * [pr-agent](https://github.com/codium-ai/pr-agent) - 🚀CodiumAI PR-Agent：一款AI驱动的🤖工具，用于自动化拉取请求分析、反馈、建议等！💻🔍
 * [whisper-diarization](https://github.com/mahmoudashraf97/whisper-diarization) - 基于OpenAI Whisper的自动语音识别和说话者分离
 * [swarm](https://github.com/openai/swarm) - 教育框架探索符合人体工程学的轻量级多代理编排。由OpenAI解决方案团队管理。
 * [DashPlayer](https://github.com/solidspoon/dashplayer) - 专为英语学习者量身定制的视频播放器，帮助您通过观看视频、沉浸于真实语境中，轻松提升英语水平。#美剧 #播放器 #听力
 * [logfire](https://github.com/pydantic/logfire) - Python及更多的简单可观测性！🪵🔥
 * [new-api](https://github.com/calcium-ion/new-api) - AI模型接口管理与分发系统，支持将多种大模型转为OpenAI格式调用、支持Midjourney Proxy、Suno、Rerank，兼容易支付协议，仅供个人或者企业内部管理与分发渠道使用，请勿用于商业用途，本项目基于One API二次开发。
 * [STranslate](https://github.com/zggsong/stranslate) - 一款由WPF开发的即开即用、即用即走的翻译OCR工具
 * [fastembed](https://github.com/qdrant/fastembed) - 快速、准确、轻量级的Python库，用于生成最先进的嵌入。
 * [openai-openapi](https://github.com/openai/openai-openapi) - OpenAI API的OpenAPI规范
 * [openai-dotnet](https://github.com/openai/openai-dotnet) - OpenAI API的官方.NET库
 * [stable-ts](https://github.com/jianfch/stable-ts) - 使用OpenAI的Whisper进行转录、强制对齐和音频索引
 * [async-openai](https://github.com/64bit/async-openai) - OpenAI的Rust库
 * [o1-engineer](https://github.com/doriandarko/o1-engineer) - o1-engineer是一个命令行工具，旨在帮助开发人员高效地管理和与他们的项目进行交互。利用OpenAI的API的强大功能，该工具提供诸如代码生成、文件编辑和项目规划等功能。
 * [simple-one-api](https://github.com/fruitbars/simple-one-api) - OpenAI接口无缝集成，使用单个可执行文件快速设置和部署，与OpenAI和兼容的API无缝集成。
 * [WAAS](https://github.com/schibsted/waas) - 低语服务（带有排队的GUI和API，适用于OpenAI Whisper）
 * [coai](https://github.com/coaidev/coai) - 🚀 下一代 AI 一站式国际化解决方案。🚀 支持 OpenAI，Midjourney，Claude，讯飞星火，Stable Diffusion，DALL·E，ChatGLM，通义千问，腾讯混元，360 智脑，百川 AI，火山方舟，新必应，Gemini，Moonshot 等模型，支持对话分享，自定义预设，云端同步，模型市场，支持弹性计费和订阅计划模式，支持图片解析，支持联网搜索，支持模型。
 * [self-operating-computer](https://github.com/othersideai/self-operating-computer) - 一个框架，使多模型能够操作计算机。
 * [blinko](https://github.com/blinko-space/blinko) - 一个开源的、自托管的个人笔记工具，注重隐私，使用TypeScript构建。


## Others

 * [visual-chatgpt](https://github.com/microsoft/visual-chatgpt) - 论文的官方存储库：Visual ChatGPT：使用视觉基础模型进行交谈、绘画和编辑。
 * [nanoGPT](https://github.com/karpathy/nanogpt) - 最简单、最快的中等规模GPT训练/微调存储库。
 * [gpt_index](https://github.com/jerryjliu/gpt_index) - 使用强大的GPU加速的Python中的张量和动态神经网络
 * [nebullvm](https://github.com/nebuly-ai/nebullvm) - 插拔式模块，优化您的人工智能系统性能 🚀
 * [gpt-2-output-dataset](https://github.com/openai/gpt-2-output-dataset) - 用于检测、偏见等研究的GPT-2输出数据集
 * [IATelligence](https://github.com/fr0gger/iatelligence) - IATelligence是一个Python脚本，可以提取PE文件的IAT，并请求GPT获取有关API和ATT＆CK矩阵的更多信息。
 * [ColossalAI](https://github.com/hpcaitech/colossalai) - 使大型人工智能模型更便宜、更快速和更易获取
 * [aoc-gpt](https://github.com/max-sixty/aoc-gpt) - 使用GPT-3解决Advent of Code难题
 * [EdgeGPT](https://github.com/acheong08/edgegpt) - 微软必应聊天AI的反向工程API
 * [chatGPT-python-elm](https://github.com/vrescobar/chatgpt-python-elm) - 一个由ChatGPT完全生成的存储库，它认为它已经检出了我描述的像README第一行的这个存储库。
 * [Sekiryu](https://github.com/20urc3/sekiryu) - 使用您喜爱的反编译器和ChatGPT自动反编译和分析二进制文件。
 * [xiaogpt](https://github.com/yihong0618/xiaogpt) - 哔哩哔哩后台源码
 * [gpt-wpre](https://github.com/moyix/gpt-wpre) - 使用GPT-3进行整个程序的逆向工程
 * [chatgpt_academic](https://github.com/binary-husky/chatgpt_academic) - 科研工作专用的ChatGPT进行了拓展，特别优化了学术论文的润色体验，支持自定义快捷按钮，支持Markdown表格显示，TeX公式双显示，代码显示功能完善，新增了本地Python工程剖析功能/自我剖析功能。
 * [chatgpt-api](https://github.com/taranjeet/chatgpt-api) - 这个代码库包含解析各种网站的代码。
 * [babyagi](https://github.com/yoheinakajima/babyagi) - 3个有趣的自主代理项目：- auto-gpt：babyagi：骆驼：你最喜欢哪一个？
 * [metaseq](https://github.com/facebookresearch/metaseq) - 外部大规模工作的代码库
 * [ThreatResearch](https://github.com/securityjoes/threatresearch) - 在我们最近的事件响应中，@charleslomboni将#chatgpt实现到了#ghidra中。我们已经发布了代码，所以你也可以使用它：我们称之为askjoe 🤠享受并分享。
 * [stable-diffusion-webui](https://github.com/automatic1111/stable-diffusion-webui) - 稳定的Diffusion网页用户界面
 * [examples](https://github.com/mosaicml/examples) - 快速灵活的参考基准
 * [ChatGDB](https://github.com/pgosar/chatgdb) - 利用ChatGPT的力量在GDB或LLDB调试器中！
 * [whisper](https://github.com/openai/whisper) - 通过大规模弱监督实现强大的语音识别
 * [point-e](https://github.com/openai/point-e) - 点云扩散用于3D模型合成
 * [stable-diffusion-webui-chatgpt-utilities](https://github.com/hallatore/stable-diffusion-webui-chatgpt-utilities) - 使用户可以直接从UI使用ChatGPT
 * [reflexion](https://github.com/noahshinn024/reflexion) - 反思：具有动态记忆和自我反思能力的自主代理程序
 * [stackexplain](https://github.com/shobrook/stackexplain) - 使用ChatGPT解释您的错误信息。
 * [nanoChatGPT](https://github.com/sanjeevanahilan/nanochatgpt) - 在nanoGPT之上添加了粗糙的RLHF层，并使用Gumbel-Softmax技巧。
 * [flash-attention](https://github.com/hazyresearch/flash-attention) - 快速且内存高效的精确注意力机制
 * [cgpt_exceptions](https://github.com/fkhan0520/cgpt_exceptions) - 制作了一个Python包，可以在抛出异常时自动从ChatGPT获取帮助。来看看吧！
 * [go-gpt3](https://github.com/sashabaranov/go-gpt3) - Python接口到亚马逊网络服务
 * [talkGPT](https://github.com/chenyukang/talkgpt) - 一个简单的Python程序，可以帮助你与ChatGPT交流，练习口语英语...
 * [XX-Net](https://github.com/xx-net/xx-net) - 一个用于绕过GFW的代理工具。
 * [ida_gpt](https://github.com/mayerdaniel/ida_gpt) - 将 #chatgpt 集成到 @hexrayssa 中，以评论 gpt 的功能描述，并为您重命名变量和函数名称的代码。
 * [pubmedgpt](https://github.com/stanford-crfm/pubmedgpt) - 机器学习训练效率的组合方法
 * [nanoGPT](https://github.com/karpathy/nanogpt?utm_source=tldrnewsletter) - 最简单、最快的中等规模GPT训练/微调存储库。
 * [slither](https://github.com/crytic/slither) - Solidity静态分析器
 * [bpy-chat-gpt](https://github.com/joshuaknauber/bpy-chat-gpt) - 聊天GPT API集成到简单的blender插件中。
 * [scrapbox_chatgpt_connector](https://github.com/nishio/scrapbox_chatgpt_connector) - ChatGPT 阅读 Scrapbox
 * [Partial-English-Subtitle-Translation](https://github.com/goldengrape/partial-english-subtitle-translation) - 各位学英语的朋友们，我又带来了学英语的工具。这次是只翻译字幕中的生词，可以自己选择难度。本次的重点是通过GPT翻译出单词在句子中的含义。网页版：
 * [GilgaiDetection](https://github.com/geezacoleman/gilgaidetection) - 吉尔盖检测的简单颜色阈值化
 * [chatgpt_stock_report](https://github.com/ddobokki/chatgpt_stock_report) - 利用聊天GPT对当天证券公司报告进行摘要的报告。
 * [DeeperSpeed](https://github.com/eleutherai/deeperspeed) - DeepSpeed是一个深度学习优化库，可以使分布式训练变得简单、高效和有效。
 * [MM-REACT](https://github.com/microsoft/mm-react) - MM-REACT 的官方代码库
 * [WavCaps](https://github.com/xinhaomei/wavcaps) - 这个仓库包含WavCaps数据集的元数据和下游任务的代码。
 * [Painter](https://github.com/baaivision/painter) - 画家和SegGPT系列：BAAI的视觉基础模型
 * [Auto-GPT](https://github.com/kanecohen/auto-gpt) - 一个试图让GPT-4完全自主的实验性开源尝试。
 * [Robo-GPT](https://github.com/rokstrnisa/robo-gpt) - 一个简单易扩展的程序，帮助您自主运行GPT-4模型。
 * [gpt-4-search](https://github.com/andylokandy/gpt-4-search) - 一个带有谷歌搜索功能的命令行GPT-4 REPL，只需200行代码。
 * [symbolicai](https://github.com/xpitfire/symbolicai) - 组合可微编程库
 * [MiniGPT-4](https://github.com/vision-cair/minigpt-4) - @bentossell minigpt-4 在他们的演示中可以做到这一点。
 * [DeepSpeed](https://github.com/microsoft/deepspeed) - DeepSpeed是一个深度学习优化库，使分布式训练和推理变得简单、高效和有效。
 * [micro-gpt](https://github.com/muellerberndt/micro-gpt) - 一个最小的通用自主代理。
 * [gptdeploy](https://github.com/jina-ai/gptdeploy) - 一行代码创造它们所有
 * [cloudgpt](https://github.com/ustayready/cloudgpt) - 使用ChatGPT的AWS客户管理策略漏洞扫描器
 * [LlamaAcademy](https://github.com/danielgross/llamaacademy) - 骆驼类动物学校
 * [magic-happens](https://github.com/empath-nirvana/magic-happens) - 一个你绝不能在任何情况下运行的Kubernetes操作员
 * [Multi-GPT](https://github.com/rumpfmax/multi-gpt) - 一个试图让GPT-4完全自主的实验性开源尝试。
 * [Image2Paragraph](https://github.com/showlab/image2paragraph) - 使用ChatGPT、BLIP2、OFA、GRIT、Segment Anything和ControlNet将图像转换为独特的段落。
 * [xai-gpt-agent-toolkit](https://github.com/xpressai/xai-gpt-agent-toolkit) - Xircuits 工具包，用于创建和实验 BabyAGI/AutoGPT 风格的代理程序。
 * [celltypewriter](https://github.com/ntranoslab/celltypewriter) - 👉更新：现在您可以在没有#gpt4 API密钥的情况下使用#celltypewriter。我们已经设置了一个#免费版本，让您可以在您的#数据上尝试它。✨这将在几天内或资金用尽之前生效:)玩得开心！GitHub链接：
 * [AutoGPT-FR](https://github.com/mikiane/autogpt-fr) - Auto GPT的法语版本
 * [DeepSpeedExamples](https://github.com/microsoft/deepspeedexamples) - 使用DeepSpeed的示例模型
 * [Caption-Anything](https://github.com/ttengwang/caption-anything) - 标题-Anything是一款多功能工具，结合了图像分割、视觉字幕和ChatGPT，生成适合用户偏好的多样化控制的定制字幕。
 * [AudioGPT](https://github.com/aigc-audio/audiogpt) - AudioGPT：理解和生成语音、音乐、声音和说话人头像
 * [Machine-Learning-Goodness](https://github.com/aurimas13/machine-learning-goodness) - 机器学习项目包括ML/DL项目、笔记本、ML/DL的作弊代码、有关AI/AGI的有用信息以及带有提示的代码、片段/脚本/任务。
 * [data-winners](https://github.com/frontanalyticsinc/data-winners) - 一系列免费的Python和R脚本，用于网站开发、分析和优化。包括用于主题权威和语义内容优化的高级资源。
 * [critique-apps](https://github.com/inspired-cognition/critique-apps) - 使用Inspired Cognition的Critique构建的应用程序。
 * [deep-rl-class](https://github.com/huggingface/deep-rl-class) - 这个仓库包含了Hugging Face深度强化学习课程的教学大纲。
 * [deep-RL-elements](https://github.com/amazingang/deep-rl-elements) - 使用PyTorch的深度强化学习算法
 * [viper](https://github.com/cvlab-columbia/viper) - 《ViperGPT：基于Python执行的视觉推理》论文代码
 * [ChatCaptioner](https://github.com/vision-cair/chatcaptioner) - ChatCaptioner官方仓库
 * [galai](https://github.com/paperswithcode/galai) - GALACTICA的模型API
 * [gost-install.ipynb](https://github.com/lewangdev/gost-install.ipynb) - 使用 Jupyter Notebook 安装 GOST
 * [chatgpt-desktop](https://github.com/sonnylazuardi/chatgpt-desktop) - 在Flappy Bird游戏中与你的Facebook好友对决
 * [yobulkdev](https://github.com/yobulkdev/yobulkdev) - 🔥 🔥 🔥开源和人工智能驱动的数据接入平台：免费的flatfile.com替代品
 * [WTF-JavaScript](https://github.com/wtfacademy/wtf-javascript) - 我最近在重新学习JavaScript，巩固一些细节，并写了一个“WTF JavaScript极简入门”，供新手学习。
 * [gpt3-email](https://github.com/danimelchor/gpt3-email) - 使用GPT-3帮助您撰写电子邮件。
 * [chatgpt-action](https://github.com/kxxt/chatgpt-action) - 让ChatGPT为您审核公关请求
 * [scalene](https://github.com/plasma-umass/scalene) - Scalene：一款高性能、高精度的Python CPU、GPU和内存分析器，具备AI优化建议功能。
 * [BingGPT](https://github.com/dice2o/binggpt) - 新的Bing AI聊天桌面应用程序（Windows，macOS和Linux）
 * [ChatGPT-Feishu](https://github.com/bestony/chatgpt-feishu) - 为飞书准备的 ChatGPT 机器人
 * [ARC](https://github.com/fchollet/arc) - 抽象推理语料库
 * [pdf.js](https://github.com/mozilla/pdf.js) - JavaScript PDF阅读器
 * [adrenaline](https://github.com/shobrook/adrenaline) - 与你的代码库交流
 * [lorem-chatum-for-indesign](https://github.com/twardoch/lorem-chatum-for-indesign) - 使用ChatGPT的Lorem Chatum脚本，可在Adobe InDesign中生成更好的Lorem ipsum。
 * [monocle-rizz](https://github.com/acui51/monocle-rizz) - rizzGPT
 * [gptrpg](https://github.com/dzoba/gptrpg) - 一个基于GPT的代理程序在类似RPG的环境中的演示
 * [ChattyCaty](https://github.com/cyberark/chattycaty) - chattycaty - OSS工具，使用GPT模型创建多态程序。
 * [appwrite](https://github.com/appwrite/appwrite) - Web、移动和Flutter开发人员的安全后端服务器🚀，也称为100％开源的Firebase替代品。
 * [wechat-chatgpt](https://github.com/fuergaosi233/wechat-chatgpt) - 通过 wechaty 在微信上使用 ChatGPT
 * [roomGPT](https://github.com/nutlope/roomgpt) - 上传您房间的照片，使用人工智能生成您的梦想房间。
 * [noobnooc](https://github.com/noobnooc/noobnooc) - 我的个人资料、博客和主页（https://www.nooc.ink）的内容。
 * [code-gpt](https://github.com/vaibhavacharya/code-gpt) - 随时理解任何代码。🚀
 * [Portal](https://github.com/lxfater/portal) - 门户发布：系统托盘模式支持API聊天模式历史可选聊天GPT Web断开问题的解决方案自动远程更新。
 * [commitgpt](https://github.com/romanhotsiy/commitgpt) - 使用ChatGPT自动生成提交信息
 * [chatgpt-md](https://github.com/bramses/chatgpt-md) - 将ChatGPT与Obsidian实现（几乎）无缝集成。
 * [paul-graham-gpt](https://github.com/mckaywrigley/paul-graham-gpt) - AI搜索和聊天，适用于所有Paul Graham的文章。
 * [colorGPT](https://github.com/sonnylazuardi/colorgpt) - 使用人工智能从现实世界中捕捉颜色名称的生成
 * [novu](https://github.com/novuhq/novu) - 具有完全功能的嵌入式通知中心的开源通知基础设施
 * [chatapi-single](https://github.com/bytemate/chatapi-single) - 简单而强大的ChatGPT-API服务器
 * [kindle-gpt](https://github.com/mckaywrigley/kindle-gpt) - 在您的Kindle亮点上进行AI搜索和聊天。
 * [gpt-4-for-code](https://github.com/anysphere/gpt-4-for-code) - 一些GPT-4代码示例！
 * [M5Core2ImageAvatarLiteChatGPT](https://github.com/robo8080/m5core2imageavatarlitechatgpt) - M5Stack Core2 的 ImageAvatarLiteChatGPT
 * [gpt4all-chat](https://github.com/nomic-ai/gpt4all-chat) - gpt4all-j 聊天
 * [ggml](https://github.com/ggerganov/ggml) - 机器学习的张量库
 * [blindvisaidgpt](https://github.com/justanotherlad/blindvisaidgpt) - 使用微软/视觉聊天GPT的盲人交互辅助工具
 * [cformers](https://github.com/nolanoorg/cformers) - 使用C后端的SoTA变压器，可在您的CPU上进行快速推理。
 * [Pake](https://github.com/tw93/pake) - 🤱🏻使用Rust将任何网页转换为桌面应用程序非常简单。🤱🏻
 * [run-wild](https://github.com/refcell/run-wild) - 增强GPT-4环境访问权限
 * [gpt-macro](https://github.com/retrage/gpt-macro) - ChatGPT 是由 Rust 过程宏驱动的编译时代码生成器。
 * [nofwl](https://github.com/lencx/nofwl) - NoFWL桌面应用程序
 * [gwipt](https://github.com/benwr/gwipt) - 使用GPT-3提交消息自动将所有编辑提交到wip分支。
 * [whatsapp-gpt](https://github.com/danielgross/whatsapp-gpt) - #8 chatgpt 用于 WhatsApp 和 Telegram将 chatgpt 添加到您的群聊中：• WhatsAppgpt：• Telegramgpt：
 * [chatgpt-web](https://github.com/869413421/chatgpt-web) - 基于ChatGPT3.5 API实现的私有化Web程序
 * [legitify](https://github.com/legit-labs/legitify) - 检测和纠正您所有 GitHub 和 GitLab 资产中的配置错误和安全风险。
 * [wechatgpt](https://github.com/houko/wechatgpt) - wechatgpt的golang版chatgpt机器人（可通过docker部署），目前支持wechat和telegram。
 * [xiaogpt.git](https://github.com/yihong0618/xiaogpt.git) - 哔哩哔哩后台源码
 * [wechat-chatGPT](https://github.com/gtoxlili/wechat-chatgpt) - 实现微信公众号被动返回接口的ChatGPT
 * [dnscrypt-proxy](https://github.com/dnscrypt/dnscrypt-proxy) - dnscrypt-proxy 2 - 一款灵活的DNS代理，支持加密DNS协议。
 * [review-gpt](https://github.com/vibovenkat123/review-gpt) - 一种使用gpt-3、gpt-3.5和gpt-4的自动代码审查工具。
 * [kube-ovn](https://github.com/kubeovn/kube-ovn) - SDN和云原生之间的桥梁（CNCF项目下的项目）
 * [gpt-takes-the-bar-exam](https://github.com/mjbommar/gpt-takes-the-bar-exam) - GPT参加律师资格考试
 * [offensive-chatgpt](https://github.com/payloadartist/offensive-chatgpt) - ChatGPT 的攻击性安全用例
 * [ChatGPT-Saver](https://github.com/billionshields/chatgpt-saver) - 聊天GPT ChatGPT Saver
 * [ChatGPT-Simple](https://github.com/logankilpatrick/chatgpt-simple) - 在不到100行代码的情况下，构建一个简单的本地托管版本的ChatGPT。
 * [LongReadBenchmark](https://github.com/xueyidong/longreadbenchmark) - 基准测试长读RNA-seq分析工具
 * [GptMedCode](https://github.com/rohit43/gptmedcode) - 从 #ehr 分析的角度来看，我想知道是否可以使用 #chatgpt 后端自动获取代码。但是返回的代码质量不是很可靠。质量 ~ icd > loinc > snomed。@zakkohane @arjunmanrai
 * [AISisterAIChan](https://github.com/manju-summoner/aisisteraichan) - 这是搭载了ChatGPT3.5的伺かGhost“AI妹妹爱酱”。使用需要另外获取ChatGPT的API密钥。
 * [Entrepreneur-GPT](https://github.com/torantulino/entrepreneur-gpt) - 2017年GUJAM
 * [ChatGPTforRhino](https://github.com/4kk11/chatgptforrhino) - 将chatgptforrhino实现为GUI并进行了一些样式调整！还将其放在了GitHub上！
 * [OutlineStormingGPT](https://github.com/mayaenomoto/outlinestorminggpt) - 只是一个与GPT轻声交谈的工具
 * [Auto-GPT.git](https://github.com/torantulino/auto-gpt.git) - 高级游戏工程项目 - 立方体像素游戏制作器
 * [ChatGPT-Bypass](https://github.com/grimoutlaw/chatgpt-bypass) - 简单的脚本，可以通过API绕过ChatGPT的内容过滤。
 * [robustlearn](https://github.com/microsoft/robustlearn) - MDATP PowerBI模板存储库
 * [check](https://github.com/yeahwu/check) - 流媒体解锁测试
 * [haoel.github.io](https://github.com/haoel/haoel.github.io) - 前两天看到耗子哥更新了上网的文档，我也来说一下我是怎么解决chatgpt和new bing就算挂了梯子还是无法登录或者使用问题的：gost+cloudflare warp，配置起来也比较简单。(1/n)
 * [FlexGen](https://github.com/ying1123/flexgen) - 一个景观规划游戏
 * [chatgpt-web](https://github.com/chanzhaoyu/chatgpt-web) - 使用 Express 和 Vue3 搭建的 ChatGPT 演示网页
 * [SPTH](https://github.com/spthvx/spth) - 地狱艺术品的第二部分：人工（生命/进化/智能）
 * [whatsapp-chatgpt](https://github.com/navopw/whatsapp-chatgpt) - 程序噪声地图生成器 :雾:
 * [MathGPT](https://github.com/meiyulee/mathgpt) - 免费数字驱动的数学模型人工智能 | 为你的数字建立数学模型 |
 * [ChatGPT.el](https://github.com/joshcho/chatgpt.el) - 在Emacs中使用ChatGPT
 * [flutter_chatgpt_api](https://github.com/coskuncay/flutter_chatgpt_api) - 使用Flutter / Dart中的ChatGPT
 * [chatchan-dist](https://github.com/easychen/chatchan-dist) - Chat酱独立部署版，docker方案自带代理Chat酱独立部署版，docker方案自带代理
 * [MaterialGPT](https://github.com/dylanakp/materialgpt) - MaterialGPT是使用API克隆ChatGPT的。
 * [chatwire](https://github.com/theokafadaris/chatwire) - 使用Laravel自主托管的ChatGPT克隆版
 * [ChatGPTForTelegram](https://github.com/kylelin1998/chatgptfortelegram) - 目前机器人基于ChatGPT进行开发。使用机器人可以让你轻松进行对话。后续机器人的更新升级一个命令即可搞定，无需再上服务器进行升级机器人。
 * [GPTstudio](https://github.com/michelnivard/gptstudio) - 基于R和FORTRAN的优化器，专门用于估计遗传方差成分模型，其中允许固定效应和调节效应。
 * [binary-dist](https://github.com/poslogithub/binary-dist) - 可执行二进制分发用
 * [GPTeacher](https://github.com/teknium1/gpteacher) - 由GPT-4生成的模块化数据集合，包括通用指导、角色扮演指导、编码指导和工具形态。
 * [AI-Toolbox](https://github.com/enbifa/ai-toolbox) - 构建一个全面的人工智能爱好者和专业人士资源库。
 * [following-instructions-human-feedback](https://github.com/openai/following-instructions-human-feedback) - @rachel_l_woods 这是我用来指导GPT不产生幻觉的常用论文。
 * [Audits-Smart-Contracts](https://github.com/audit-ace/audits-smart-contracts) - 🚀宣布审计报告恭喜聊天GPT🎉审计DM-
 * [Malware](https://github.com/objective-see/malware) - macOS 恶意软件收集
 * [inPars](https://github.com/zetaalphavector/inpars) - VOSviewer Online是一种网络可视化工具。它是VOSviewer的基于Web的版本，VOSviewer是一种流行的构建和可视化文献计量网络的工具。
 * [ai-review.vim](https://github.com/yuki-yano/ai-review.vim) - 快速计算你的代码。
 * [gayolGate](https://github.com/gayolgate/gayolgate) - 关于我的GitHub个人资料的信息
 * [minlora](https://github.com/cccntu/minlora) - 🚀 令人兴奋的消息！我刚刚发布了我的新仓库，minlora 🎉 这个强大的库可以让你在几行代码中将Lora应用于*任何*PyTorch模型。从@huggingface的transformers、diffusers，到@karpathy的nanogpt。现在就去看看吧：
 * [EOSIO-Vulnerability-Scanner](https://github.com/sentnl/eosio-vulnerability-scanner) - 在第一层区块链协议上发现P0网络安全问题的漏洞赏金
 * [paytm-movies](https://github.com/hedcet/paytm-movies) - #bimbisara #1月9日星期一 收入1,852卢比，占座率77%（1,852/2,400），5场电影，#testcinemaocl #waterland。
 * [chatgpt-vscode](https://github.com/ai-genie/chatgpt-vscode) - 您在VS Code中最好的AI配对程序员
 * [PolyglotSiri-Apple-Shortcut](https://github.com/munntein/polyglotsiri-apple-shortcut) - PolyglotSiri基于[ChatGPT-Siri](https://github.com/Yue-Yang/ChatGPT-Siri)，并增强了其多语言和语音功能。
 * [M5Burner_M5Unified_StackChan_ChatGPT_README](https://github.com/robo8080/m5burner_m5unified_stackchan_chatgpt_readme) - 这是M5Burner版M5Unified_StackChan_ChatGPT的README。
 * [stableLM](https://github.com/stability-ai/stablelm) - 与stability.ai API（例如稳定扩散推理）交互的SDK
 * [AI-Twitter-History](https://github.com/jtmuller5/ai-twitter-history) - ChatGPT很好，但你不知道如何使用它。
 * [gpt-legion](https://github.com/eumemic/gpt-legion) - 辐射区块链节点（RXD）- SHA512/256工作量证明
 * [JinJinLeDao_QA_Dataset](https://github.com/tech-podcasts/jinjinledao_qa_dataset) - 该数据集包含从281集中国播客“金金乐道”中提取的超过18,000个中文问答对。
 * [AlitaAI](https://github.com/alita-ai/alitaai) - #notion #chatgpt #AlitaAI 肝了一个月终于出来了，和 ChatGPT 一起产品/设计/前后端 ，新人求关注Alita AI（save to notion）是一款基于 Notion、ChatGPT 的人工智能助手， 能帮你渐进式学习、自动化高效录入知识片段抢先版：
 * [2048](https://github.com/inishchith/2048) - 又一个2048，但这次由GPT控制。
 * [VardaGPT](https://github.com/ixaxaar/vardagpt) - 关联记忆增强的GPT-2模型
 * [gpt-json](https://github.com/piercefreeman/gpt-json) - Python中结构化和类型提示的GPT响应
 * [gptneox](https://github.com/dfalbel/gptneox) - 软件包的功能（一行，标题大小写）
 * [babyagi4all](https://github.com/kroll-software/babyagi4all) - BabyAGI与GPT4All一起运行。
 * [open-chat-video-editor](https://github.com/scutlihaoyu/open-chat-video-editor) - 开源短视频自动生成工具
 * [AIXP](https://github.com/davila7/aixp) - AI-Exchange协议（AIXP）：人工智能代理通信标准
 * [chat-ui](https://github.com/huggingface/chat-ui) - 开源代码库支持HuggingChat应用程序
 * [pandora](https://github.com/pengzhile/pandora) - 潘多拉，一个帮助你呼吸顺畅的ChatGPT。
 * [ChatWaifu_Mobile](https://github.com/voine/chatwaifu_mobile) - 移动版二次元 AI 老婆聊天器
 * [ChatALL](https://github.com/sunner/chatall) - 同时与ChatGPT、Bing Chat、bard、Alpaca、Vincuna、Claude、ChatGLM、MOSS、iFlytek Spark、ERNIE等进行聊天，发现最佳答案。
 * [fastGPT](https://github.com/certik/fastgpt) - 用Fortran编写的快速GPT-2推理
 * [menubar](https://github.com/smol-ai/menubar) - 一个带有零延迟访问ChatGPT/Bard/Claude的菜单栏！进行A/B测试，或在后台使用它们。我每天使用它20次。
 * [quivr](https://github.com/stangirard/quivr) - 将所有文件和想法倾倒到你的生成AI第二大脑中，并与它聊天。
 * [GPTeam](https://github.com/101dotxyz/gpteam) - GPTeam：一个开源的多智能体模拟系统
 * [learnGPT](https://github.com/dadukhankevin/learngpt) - 一个免费、开源、由人工智能驱动的Quizlet替代品。
 * [GirlfriendGPT](https://github.com/eniascailliau/girlfriendgpt) - 女友GPT是一个使用ChatGPT4.0构建自己的AI女友的Python项目。
 * [Mr.trans](https://github.com/illumine-labs/mr.trans) - 启迪思维，超越学习
 * [chat_gpt_error_handler](https://github.com/schwad/chat_gpt_error_handler) - 今天试试我的新宝石“chat_gpt_error_handler”吧！它会在错误堆栈之前弹出一个（希望有用的）ChatGPT片段。
 * [PandaGPT](https://github.com/yxuansu/pandagpt) - PandaGPT：一种模型，可指导所有操作
 * [rinna_gpt-neox_ggml-lora](https://github.com/yukaryavka/rinna_gpt-neox_ggml-lora) - 该存储库包含已修改的脚本和合并脚本，以适应Alpaca-Lora适配器的LoRA调谐，假设使用转换为ggml的“rinna / japanese-gpt-neox…” [gpt-neox]模型。
 * [gptlink](https://github.com/gptlink/gptlink) - 10分钟搭建自己可免费商用的ChatGPT环境，搭建简单，包含用户，订单，任务，付费等功能。
 * [tell-me-a-story-ai](https://github.com/kiki-le-singe/tell-me-a-story-ai) - “讲个故事”是一个小应用程序，可以使用ChatGPT和React Native编写故事。
 * [chatgpt-yaml-generator](https://github.com/robusta-dev/chatgpt-yaml-generator) - 将Kubernetes模式和验证能力的完整知识授予ChatGPT。
 * [ComposeAI](https://github.com/ebfvince/composeai) - 一个使用Compose Multiplatform制作的Android和iOS应用程序ChatGPT。
 * [GreatMaster](https://github.com/illumine-labs/greatmaster) - 大师，请帮助我们觉醒和开悟。
 * [SAIL](https://github.com/luohongyin/sail) - SAIL：搜索增强指令学习
 * [PodcastCopilot](https://github.com/microsoft/podcastcopilot) - 可扩展、快速、轻量级的大规模主题建模系统
 * [gpt-aggregated-edition](https://github.com/1595901624/gpt-aggregated-edition) - 聚合ChatGPT官方版、ChatGPT免费版、文心一言、Poe、chatchat等多平台，支持自定义导入平台。
 * [larc_gpt4](https://github.com/evanthebouncy/larc_gpt4) - LARC与GPT-4的解决方案
 * [go-proxy-bingai](https://github.com/adams549659584/go-proxy-bingai) - 使用Vue3和Go构建的微软New Bing演示站点，具有一致的UI体验，支持ChatGPT提示词，可在国内使用。
 * [slack-knowledgebase-chatgpt-responder](https://github.com/nearform/slack-knowledgebase-chatgpt-responder) - ChatGPT是由Slack驱动的自动回复程序，用于回答与NearForm知识库相关的问题。
 * [simpleaichat](https://github.com/minimaxir/simpleaichat) - Python包，可轻松与聊天应用程序进行接口交互，具有强大的功能和最小的代码复杂性。
 * [instruction-tuned-sd](https://github.com/huggingface/instruction-tuned-sd) - 指令调整稳定扩散的代码。
 * [gpt-engineer](https://github.com/antonosika/gpt-engineer) - 指定您想要建造的内容，人工智能会要求澄清，并进行建造。
 * [FalconStreaming](https://github.com/andrewgcodes/falconstreaming) - Falcon40B和7B（指令）具有流式传输、前k个结果和波束搜索。
 * [lightspeedGPT](https://github.com/andrewgcodes/lightspeedgpt) - 使用GPT4和GPT3.5处理无限大小的输入。使用多线程并行处理多个块，适用于命名实体识别、大型书籍、数据集等信息提取任务。
 * [bloop](https://github.com/bloopai/bloop) - bloop是一个用Rust编写的快速代码搜索引擎。
 * [obsidian-copilot](https://github.com/logancyang/obsidian-copilot) - 黑曜石中的ChatGPT副驾驶员
 * [thinkgpt](https://github.com/alaeddine-13/thinkgpt) - 突尼斯航空公司应用程序REST API
 * [babyagi-ui](https://github.com/miurla/babyagi-ui) - BabyAGI UI旨在使在Web应用程序中运行和开发BabyAGI（类似于ChatGPT）更加容易。
 * [GPT4Company](https://github.com/easychen/gpt4company) - Gpt4Company是一个用来防止三星式泄密的请求转发器。
 * [chatgpt-spring-boot-starter](https://github.com/linux-china/chatgpt-spring-boot-starter) - Spring Boot ChatGPT 起始器
 * [nuclei_gpt](https://github.com/sf197/nuclei_gpt) - 聊天自动化生成Nuclei模板
 * [sample-app-aoai-chatGPT](https://github.com/microsoft/sample-app-aoai-chatgpt) - [预览] 通过AOAI针对chatGPT的简单网络聊天体验的示例代码。
 * [GENIUS](https://github.com/mingkai-zheng/genius) - GPT-4能进行神经架构搜索吗？
 * [chatgpt-source-watch](https://github.com/0xdevalias/chatgpt-source-watch) - 使用策划档案和脚本分析ChatGPT代码库的演变历程。
 * [PROFILEGPT](https://github.com/odiks/profilegpt) - PROFILEGPT是一款用于分析Twitter上的个人资料和标签的工具。该应用程序利用各种技术和API收集数据并为用户生成信息。
 * [chatgpt-auto-continue](https://github.com/adamlui/chatgpt-auto-continue) - ⏩ 自动继续生成多个ChatGPT回复
 * [a1gpt](https://github.com/a1k0n/a1gpt) - 一次性使用的GPT推理
 * [freegpt-webui](https://github.com/ramonvc/freegpt-webui) - GPT 3.5/4带有聊天网页界面。无需API密钥。
 * [commavq](https://github.com/commaai/commavq) - commaVQ是一个压缩的驾驶视频数据集。
 * [chatgpt-localfiles](https://github.com/samrawal/chatgpt-localfiles) - 使本地文件可以访问ChatGPT
 * [SlashGPT](https://github.com/snakajima/slashgpt) - 在 @snakajima さん解释完SlashGPT之后，我们来确认一下代码。
 * [nba-cba-ai-chat](https://github.com/mckaywrigley/nba-cba-ai-chat) - 使用人工智能来询问有关新的676页NBA CBA的问题。
 * [Taqyim](https://github.com/arbml/taqyim) - Python界面用于对ChatGPT模型进行评估
 * [gpt-code-search](https://github.com/wolfia-app/gpt-code-search) - GitHub操作，用于自动化分发您的应用程序的操作。
 * [Callisto](https://github.com/jetp1ane/callisto) - Callisto - 一个智能的二进制漏洞分析工具
 * [OpenELM](https://github.com/carperai/openelm) - 通过大型模型的演化
 * [chatgpt-to-api](https://github.com/acheong08/chatgpt-to-api) - 高级HTTP库
 * [chatgpt-web-share](https://github.com/moeakwak/chatgpt-web-share) - 一个功能齐全的多用户ChatGPT网络系统，提供Plus账户或API作为服务提供商。
 * [poe-api](https://github.com/ading2210/poe-api) - 一个逆向工程的Python API包装器，用于Quora的Poe，提供免费访问ChatGPT、GPT-4和Claude。
 * [leetcode](https://github.com/azl397985856/leetcode) - 推荐免费ChatGPT网站：www.lintcode.com/chat-gpt?utm_source=tf-github-lucifer  LeetCode题解：记录自己的问题解决之旅。
 * [chatgpt-business](https://github.com/garyvalue/chatgpt-business) - 已汇总41个Chatgpt商业版及提供更多的变现方式，商业源码程序，账号API渠道，支付收款渠道，服务器渠道，课程配套服务，CHATGPT知识星球，开发定制外包。
 * [chapyter](https://github.com/chapyter/chapyter) - Chapyter：Jupyter Notebooks中的ChatGPT代码解释器
 * [ChatGPT-Midjourney-Pro](https://github.com/licoy/chatgpt-midjourney-pro) - 🤖️ 基于 Golang + Vue3 + NaiveUI 的全新 ChatGPT-Midjourney 的 AIGC 应用
 * [timetask](https://github.com/haikerapples/timetask) - 一款支持自定义定时任务的chatgpt-on-wechat插件
 * [chatgpt-mirror-server-deploy](https://github.com/xyhelper/chatgpt-mirror-server-deploy) - chatgpt-mirror-server快速部署库文件chatgpt-mirror-server快速部署库文件
 * [gpt-react-designer](https://github.com/xd2sketch/gpt-react-designer) - ⚡️ 使用🤖 ChatGPT 生成并预览 ⚛️ React 组件
 * [personoids-lite](https://github.com/personoids/personoids-lite) - 每个聊天中的自主权的力量。将ChatGPT转化为一个强大的自主代理，能够独立完成复杂任务。
 * [AIChatWeb](https://github.com/nanjiren01/aichatweb) - 在ChatGPT-Next-Web的基础上，增加注册登录，额度限制，邀请，敏感词，支付，基于docker一键部署。提供后台管理系统，可配置标题、欢迎词、额度不足提醒、公告。
 * [gptAssist](https://github.com/woheller69/gptassist) - gptAssist是ChatGPT的一个简单的WebView封装器。
 * [personal_chatgpt](https://github.com/chunhuizhang/personal_chatgpt) - 个人聊天GPT
 * [explain-source-code-by-chatgpt](https://github.com/cuishuang/explain-source-code-by-chatgpt) - 👂🏻 chatgpt讲解Go知名项目的源码
 * [ChatGPT_principle_fine-tuning_code_paper](https://github.com/julycoding/chatgpt_principle_fine-tuning_code_paper) - 本『ChatGPT资源库(原理/微调/代码/论文)』的初始版本来自July CSDN博客上阅读量高达50万的ChatGPT系列，联合发起人：七月ChatGPT原理课学员，6月初正式对外发布
 * [spring-chatgpt-sample](https://github.com/azure-samples/spring-chatgpt-sample) - 一个使用Spring / Java堆栈的ChatGPT样本
 * [azurechatgpt](https://github.com/microsoft/azurechatgpt) - 🤖 Azure ChatGPT：专为企业内部使用而设计的私密安全聊天GPT 💼
 * [ChatGPT-Nine-Ai](https://github.com/dreamergrow/chatgpt-nine-ai) - 使用 Nestjs 和 Vue3 搭建的 商业化ChatGPT网站
 * [gptlink-web](https://github.com/gptlink/gptlink-web) - 一个由React和Tailwind CSS构建的ChatGPT网络应用，API由gptlink提供。
 * [ChatGPT-Virtual-Live](https://github.com/smallnew666/chatgpt-virtual-live) - ChatGPT虚拟主播，支持B站、抖音和视频号。
 * [chatgpt-web-plus](https://github.com/chanzhaoyu/chatgpt-web-plus) - 聊天GPT网络增强版
 * [MindGeniusAI](https://github.com/xianjianlf2/mindgeniusai) - 使用ChatGPT自动生成思维导图
 * [ExcelGPT](https://github.com/asterecho/excelgpt) - chatgpt for Excel，基于ExcelDNA开发
 * [OpenCopilot](https://github.com/newfyu/opencopilot) - ChatGPT的跨平台桌面客户端，拥有简洁的用户界面和随时唤起的体验。具备构建本地知识库、网络检索、长文本阅读、执行本地代码等功能。
 * [drugchat](https://github.com/ucsd-ai4h/drugchat) - DrugChat：实现在药物分子图上启用ChatGPT类似功能
 * [ChatGPT-SDImg-Web](https://github.com/chengxs1994/chatgpt-sdimg-web) - 基于ChatGPT-Next-Web，集成SD webui AI绘图，实现注册登录，次数限制，充值，分享等功能
 * [ESP32-ChatGPT](https://github.com/techiesms/esp32-chatgpt) - 这个仓库包含了在ESP32开发板上使用ChatGPT的代码，同时还使用了i2s放大模块进行音频响应。
 * [gihyo-ChatGPT](https://github.com/gamasenninn/gihyo-chatgpt) - Gihyo ChatGPT 书籍
 * [azurechatgpt](https://github.com/dandinu/azurechatgpt) - 🤖 Azure ChatGPT：专为企业内部使用而设计的私密安全聊天GPT 💼
 * [OpenGPT-Business](https://github.com/black-fruit/opengpt-business) - chatgpt商业应用！79E/ChatGpt-Web 的1.3.9最新！本人破解，无需授权！chatgpt商业应用！79E/ChatGpt-Web 的1.3.9最新！本人破解，无需授权！
 * [ChatGPT-fine-tuning](https://github.com/iongpt/chatgpt-fine-tuning) - 用于训练微调ChatGPT的实用类
 * [ChatGPT-Next-Web-Pro](https://github.com/vual/chatgpt-next-web-pro) - 基于chatgpt-next-web，增加了midjourney绘画功能。后续会接入stable-diffusion，注册登录，后台管理，接入知识库等。
 * [chirp](https://github.com/rogueocelot/chirp) - 从Discord中的Relay ChatGPT的问题和答案
 * [SQL-GPT](https://github.com/cl-lau/sql-gpt) - 使用ChatGPT生成SQL并执行。还可以对SQL进行优化和错误修正。
 * [ChatPaper2Xmind](https://github.com/masteryip/chatpaper2xmind) - 论文XMind笔记生成工具，可以将论文PDF转换为带有图片和公式的简要XMind笔记，从而提高论文阅读效率。
 * [TIME-SEA-chatgpt](https://github.com/dulaiduwang003/time-sea-chatgpt) - 基于SpringBoot3开发的Ai平台 含双端 网页以及小程序 包含chatgpt newbing claude , 双端数据同步 支持自定义预设词,功能板块定义,各类绘图  web兼容手机展示
 * [Chat-CodeReview](https://github.com/nangongchengfeng/chat-codereview) - ChatGPT集成Gitlab，自动审计代码进行评论
 * [NeuroGPT](https://github.com/em1tsan/neurogpt) - 免费的ChatGPT 3.5 / ChatGPT 4
 * [chatreview](https://github.com/specful-ai/chatreview) - ChatGPT的代码审查模式
 * [pandora](https://github.com/dave1010/pandora) - ChatGPT编码解锁！Pandora赋予ChatGPT读写文件和在您的计算机上运行命令的能力。
 * [feishu-chatgpt](https://github.com/1130600015/feishu-chatgpt) - 一个集成ChatGPT的飞书应用
 * [midjourney_turbo](https://github.com/chazzjimel/midjourney_turbo) - chatgpt-on-wechat的mj画图插件，支持次数限制，GPT关键词润色，图片合成，以图生图chatgpt-on-wechat的mj画图插件，支持次数限制，GPT关键词润色，图片合成，以图生图
 * [humanify](https://github.com/jehna/humanify) - 使用ChatGPT解压缩JavaScript代码
 * [careerboost](https://github.com/dmswl98/careerboost) - 📝 chatGPT 简历润色服务
 * [livecodingthefuture-docker-terraform](https://github.com/digitalinnovationone/livecodingthefuture-docker-terraform) - 创建项目以保存Live Conding The Future的示例。使用Docker、Terraform、Bard和ChatGPT在云中部署Web应用程序。
 * [chatgpt-jiezi](https://github.com/hncboy/chatgpt-jiezi) - ChatGPT 管理端-解字
 * [GPT-WEB-JAVA](https://github.com/a616567126/gpt-web-java) - 基于JDK8的AI聊天机器人！微信公众号Midjourney画图、卡密兑换、web支持ChatGPT、Midjourney画图、sd画图，卡密兑换，易支付，公众号引流，邮件注册🔥
 * [ChatGPT-Python-Applications](https://github.com/xiaowuc2/chatgpt-python-applications) - ChatGPT Python应用程序集成了第三方库和模块。
 * [ChatLog](https://github.com/thu-keg/chatlog) - ⏳ 聊天记录：记录和分析ChatGPT的聊天内容
 * [claude-in-slack-server](https://github.com/llmkira/claude-in-slack-server) - 帮助您在slack中与Claude互动的HTTP服务器，与ChatGPT Web API兼容。
 * [chat-review](https://github.com/ikoofe/chat-review) - ChatGPT Gitlab 代码审查
 * [ChatGPTBook](https://github.com/liucongg/chatgptbook) - 《ChatGPT原理与实战：大型语言模型的算法、技术和私有化》
 * [nvim-gpt](https://github.com/archibate/nvim-gpt) - 为像您这样的新先锋将ChatGPT和Bing AI集成到NeoVim中 :)
 * [ChatReviewer](https://github.com/nishiwen1214/chatreviewer) - ChatReviewer: 使用ChatGPT分析论文的优缺点，并提出改进建议
 * [ChatGLM-Tuning](https://github.com/mymusise/chatglm-tuning) - 一种平价的chatgpt实现方案，基于ChatGLM-6B + LoRA
 * [chatgpt](https://github.com/emacs-openai/chatgpt) - 在Emacs中使用ChatGPT
 * [Using-ChatGPT-to-Learn-Programming](https://github.com/blackstar1453/using-chatgpt-to-learn-programming) - 学习如何使用ChatGPT来增强你的编程学习
 * [Apilot](https://github.com/6vision/apilot) - 基于chatgpt_on_wechat项目的一个api调用插件
 * [ChatGPT_Custom_Instructions](https://github.com/daveshap/chatgpt_custom_instructions) - ChatGPT的自定义指令存储库
 * [chatnio](https://github.com/deeptrain-community/chatnio) - 👋 轻量级 ChatGPT 聊天平台，实现 ChatGPT 在线搜索服务，多账户负载均衡，缓存，鉴权系统，支持实时响应流，图像生成和记忆功能。
 * [talk](https://github.com/proxoar/talk) - 与ChatGPT交流非常轻松
 * [brain-reply](https://github.com/caidukai/brain-reply) - 更优雅的ChatGPT客户端
 * [wechat_gpt_laf](https://github.com/husanr/wechat_gpt_laf) - 使用Laf云平台，只需两步即可将ChatGPT接入微信公众号。
 * [bionicgpt](https://github.com/purton-tech/bionicgpt) - BionicGPT是ChatGPT的本地替代品，具有生成式人工智能的优势，同时保持严格的数据保密性。
 * [ChatGPT-Next-Web-PRO](https://github.com/llboo/chatgpt-next-web-pro) - ChatGPT-Next-Web 接入管理后台，包括：key管理、用户鉴权、公众号注册/扫码登录、支付管理、卡密管理等ChatGPT-Next-Web 接入管理后台，包括：key管理、用户鉴权、公众号注册/扫码登录、支付管理、卡密管理等
 * [ChatGPT-AutoExpert](https://github.com/spdustin/chatgpt-autoexpert) - 🚀🧠💬 ChatGPT（非编程）和ChatGPT高级数据分析（编程）的超级定制指令。
 * [muchat-aio](https://github.com/panyanyany/muchat-aio) - 团队版 ChatGPT Web 应用，多用户，免登录。适合公司、组织或小团体内部使用。
 * [chatgpt-web-go](https://github.com/heimeropen/chatgpt-web-go) - 一个用于ChatGPT应用的Golang服务
 * [reddit-profile-analyzer](https://github.com/grays42/reddit-profile-analyzer) - ChatGPT基于Reddit个人资料分析器。请自备API密钥。
 * [bionic-gpt](https://github.com/bionic-gpt/bionic-gpt) - BionicGPT是ChatGPT的本地替代品，具有生成式人工智能的优势，同时保持严格的数据保密性。
 * [chatgpt-token](https://github.com/croissanteth/chatgpt-token) - 完全自动化的ETH代币部署，使用ChatGPT和DALL-E。
 * [RickAndMortai](https://github.com/code-bullet/rickandmortai) - 一个聊天GPT的东西，里面有瑞克和莫蒂的角色、传送门，还有什么怪物史莱克之类的，我也不知道。
 * [sd-webui-chatgpt](https://github.com/non906/sd-webui-chatgpt) - 这是一个在稳定扩散网络界面中使用ChatGPT的存储库。
 * [pictureChange](https://github.com/yanyutin753/picturechange) - 适用于chatgpt-on-wechat项目插件
 * [ChatGPT_Agent](https://github.com/liyucheng09/chatgpt_agent) - 一个由ChatGPT代理驱动的游戏演示
 * [gin-vue-admin](https://github.com/flipped-aurora/gin-vue-admin) - 基于vite+vue3+gin搭建的开发基础平台（支持TS,JS混用），集成jwt鉴权，权限管理，动态路由，显隐可控组件，分页封装，多点登录拦截，资源权限，上传下载，代码生成器，表单生成器,chatGPT自动查表等开发必备功能。
 * [LMFlow](https://github.com/optimalscale/lmflow) - 一个可扩展的工具包，用于对大型基础模型进行微调和推理。适用于所有大型模型。
 * [reloadium](https://github.com/reloadware/reloadium) - 热重载、性能分析和人工智能调试的Python
 * [chatgpt-java](https://github.com/plexpt/chatgpt-java) - ChatGPT Java SDK。支持 GPT3.5、GPT4 API。开箱即用。
 * [alldata](https://github.com/alldatacenter/alldata) - 🔥🔥 AllData大数据产品是可定义数据中台，以数据平台为底座，以数据中台为桥梁，以机器学习平台，GPT平台为框架，提供全链路数字化解决方案。微信群：https://docs.qq.com/doc/DVHlkSEtvVXVCdEFo
 * [SuperCLUE](https://github.com/cluebenchmark/superclue) - SuperCLUE: 中文通用大模型综合性基准 | 一个用于中文基础模型的基准测试
 * [worktool](https://github.com/gallonyin/worktool) - 【企业微信】企业微信机器人 聊天机器人、自动加好友、自动拉群、自动群发机器人 免Root零封号 集成ChatGPT
 * [next-enterprise](https://github.com/blazity/next-enterprise) - 💼 一个面向企业级的 Next.js 脚手架，用于构建高性能、易维护的应用程序。内置了诸如 Tailwind CSS、TypeScript、ESLint、Prettier、测试工具等功能，以加速您的开发过程。
 * [HydraLab](https://github.com/microsoft/hydralab) - 智能云测试变得简单。
 * [vectordb](https://github.com/epsilla-cloud/vectordb) - Epsilla是一款高性能的向量数据库管理系统。请在https://cloud.epsilla.com/上尝试使用托管的Epsilla。
 * [WeChatMsg](https://github.com/lc044/wechatmsg) - 提取微信聊天记录，将其导出成HTML、Word、CSV文档永久保存，对聊天记录进行分析生成年度聊天报告
 * [gpts-works](https://github.com/all-in-aigc/gpts-works) - 一个第三方GPT存储库
 * [gpt-researcher](https://github.com/assafelovic/gpt-researcher) - 基于GPT的自主代理，可以对任何给定的主题进行在线综合研究。
 * [ChatGPT-Next-Web](https://github.com/chatgptnextwebteam/chatgpt-next-web) - 一个设计精良的跨平台 ChatGPT 用户界面（Web / PWA / Linux / Win / MacOS）。
 * [ChatGLM-Finetuning](https://github.com/liucongg/chatglm-finetuning) - 基于ChatGLM-6B、ChatGLM2-6B、ChatGLM3-6B模型，进行下游具体任务微调，涉及Freeze、Lora、P-tuning、全参微调等。
 * [ChatGPT-Next-Web](https://github.com/chatgptnextweb/chatgpt-next-web) - 一个设计精良的跨平台 ChatGPT 用户界面（Web / PWA / Linux / Win / MacOS）。
 * [gpt-crawler](https://github.com/builderio/gpt-crawler) - 从一个URL中爬取网站以生成知识文件，从而创建自己定制的GPT。
 * [vimGPT](https://github.com/ishan0102/vimgpt) - 使用GPT-4V和Vimium浏览网页
 * [modelscope-agent](https://github.com/modelscope/modelscope-agent) - ModelScope-Agent（开源版GPTs）：一个将ModelScope中的模型与世界连接起来的代理框架。
 * [chatgpt-wechat](https://github.com/whyiyhw/chatgpt-wechat) - 企业微信/微信 安全使用的 ChatGPT 个人助手应用
 * [jan](https://github.com/janhq/jan) - Jan是ChatGPT的开源替代品，可以完全离线在您的计算机上运行。
 * [gerev](https://github.com/gerevai/gerev) - 🧠 人工智能驱动的企业搜索引擎 🔎
 * [Replit-Xray](https://github.com/yonggekkk/replit-xray) - Replit容器部署xray代理，支持自定义伪装网页，一键五协议共存，支持搭建vless、vmess、trojan、shadowsocks、socks，支持本地上传与replit平台fork两种模式部署输出：Replit容器部署xray代理，支持自定义伪装网页，一键五协议共存，支持搭建vless、vmess、trojan、shadowsocks、socks，支持本地上传与replit平台fork两种模式部署
 * [GPTSecurity](https://github.com/mo-xiaoxi/gptsecurity) - 塑造未来的安全领域智能革命
 * [auto_job__find__chatgpt__rpa](https://github.com/frrrrrrrrank/auto_job__find__chatgpt__rpa) - 这是一个工具，可以根据您的简历和职位描述，使用ChatGPT自动生成求职信，并发送给中国的老板。
 * [hamulete](https://github.com/hoochanlon/hamulete) - 🏔️国立台湾大学、新加坡国立大学、早稻田大学、东京大学，中央研究院（台湾）以及中国重点高校及科研机构，社科、经济、数学、博弈论、哲学、系统工程类学术论文等知识库。
 * [GPT-4V-Act](https://github.com/ddupont808/gpt-4v-act) - 使用GPT-4V（视觉）的AI代理能够使用鼠标/键盘与Web用户界面进行交互输出：
 * [Generative_Deep_Learning_2nd_Edition](https://github.com/davidadsp/generative_deep_learning_2nd_edition) - 《O'Reilly书籍生成式深度学习第二版：教机器绘画、写作、作曲和演奏》的官方代码存储库。输出：
 * [smart-ide](https://github.com/airuikun/smart-ide) - 通过在vscode插件中结合chatgpt能力，实现智能研发提效。
 * [comfyui-mixlab-nodes](https://github.com/shadowcz007/comfyui-mixlab-nodes) - 工作流到APP、屏幕共享和悬浮视频、GPT和3D、语音识别和文本转语音
 * [smart-excel-ai](https://github.com/weijunext/smart-excel-ai) - 使用ChatGPT，在几秒钟内生成您所需的Excel公式。
 * [zotero-gpt](https://github.com/muisedestiny/zotero-gpt) - GPT 遇见 Zotero。
 * [gpt4v-browsing](https://github.com/unconv/gpt4v-browsing) - 使用GPT-4 Vision API和Puppeteer进行网络爬虫
 * [inke](https://github.com/yesmore/inke) - 📖 一个具备AI辅助写作和实时协作功能的所见即所得笔记本。支持自主托管，使用IndexedDB存储笔记。
 * [twitterbio](https://github.com/nutlope/twitterbio) - 使用Mixtral和GPT-3.5生成您的Twitter简介。
 * [SeeAct](https://github.com/osu-nlp-group/seeact) - SeeAct是一个用于通用网络代理的系统，可以在任何给定的网站上自主执行任务，重点是大型多模态模型（LMMs），如GPT-4V(ision)。
 * [AI-Infinity](https://github.com/meetpateltech/ai-infinity) - 一套人工智能工具，将帮助您探索人工智能的无限可能性。
 * [ChatGPT-Proxy](https://github.com/dqzboy/chatgpt-proxy) - ChatGPT代理
 * [flutter_chat_box](https://github.com/bravekingzhang/flutter_chat_box) - Flutter开发的和ChatGPT聊天的App，全平台支持
 * [composum-AI](https://github.com/ist-dresden/composum-ai) - 为Composum Pages CMS和Adobe AEM提供人工智能服务
 * [council](https://github.com/chain-ml/council) - Council是一个开源平台，用于快速开发和强大部署定制的生成式人工智能应用程序。
 * [ChatGemini](https://github.com/bclswl0827/chatgemini) - ✨ ChatGemini 是一个基于 Google Gemini 的网页客户端，对标 ChatGPT 3.5，操作逻辑同 ChatGPT 3.5 一致，同时支持在聊天中上传图片，应用会自动调用 Gemini-Pro-Vision 模型进行识图。
 * [yakGPT](https://github.com/yakgpt/yakgpt) - 本地运行的无需手动操作的ChatGPT用户界面
 * [GalTransl](https://github.com/cx2333-gt/galtransl) - 支持GPT-3.5/GPT-4/Newbing/Sakura等大型语言模型的Galgame自动化翻译解决方案。
 * [MoneyPrinter](https://github.com/fujiwarachoki/moneyprinter) - 使用MoviePy自动创建YouTube Shorts。
 * [ChatGPT-DeMod](https://github.com/4as/chatgpt-demod) - Tampermonkey/Greasemonkey脚本，用于在与ChatGPT通信时隐藏审查结果。输出：
 * [gpt-newspaper](https://github.com/rotemweiss57/gpt-newspaper) - 基于GPT的自主代理，旨在根据用户偏好创建个性化报纸。
 * [CoGPT](https://github.com/geniucker/cogpt) - 嗯，副驾驶员还是GPT？谁知道呢。通过副驾驶员访问gpt-4。
 * [rome](https://github.com/kmeng01/rome) - 在GPT（NeurIPS 2022）中定位和编辑事实关联。
 * [chatgpt-next](https://github.com/xcatliu/chatgpt-next) - 微信风格的 ChatGPT，使用 Next.js 构建，私有化部署的最佳选择！
 * [wechatSDK](https://github.com/kawika-git/wechatsdk) - 微信机器人是一个基于Python 3.11开发的创新项目，结合了ChatGPT模型和微信原生API，为用户提供智能聊天、自动绘画、自动发朋友圈、自动发视频号等多样的API集成服务，旨在提升日常沟通效率和趣味性。
 * [Bunny](https://github.com/baai-dcai/bunny) - 一家轻量级多模型。
 * [ChatGPT-API-Faucet](https://github.com/terobox/chatgpt-api-faucet) - AI圈的水龙头网站，每24小时可领取一个令牌用于开发测试AI产品。
 * [WELearnHelper](https://github.com/ssmjae/welearnhelper) - 显示WE Learn随行课堂题目答案；支持班级测试；自动答题；刷时长；基于生成式AI(ChatGPT)的答案生成
 * [devchat](https://github.com/devchat-ai/devchat) - 使用AI动力脚本自动化您的开发任务，从您的IDE聊天面板开始。
 * [ChatGPTSwiftUI](https://github.com/alfianlosari/chatgptswiftui) - 一个ChatGPT原生的iOS、macOS、watchOS、tvOS SwiftUI应用程序
 * [qcg-installer](https://github.com/rockchinq/qcg-installer) - ChatGPT QQ 机器人的自动安装器，自动化部署，适用于QChatGPT项目: https://github.com/RockChinQ/QChatGPT
 * [wechatSDK](https://github.com/wechatapis/wechatsdk) - 微信机器人是一个基于Python 3.11开发的创新项目，结合了ChatGPT模型和微信原生API，为用户提供智能聊天、自动绘画、自动发朋友圈、自动发视频号等多样的API集成服务，旨在提升日常沟通效率和趣味性。
 * [FreeGPT35](https://github.com/missuo/freegpt35) - 使用ChatGPT Web提供的无需登录的GPT-3.5-Turbo API服务，免费无限制。
 * [SWE-agent](https://github.com/princeton-nlp/swe-agent) - SWE代理接收一个GitHub问题，并尝试使用GPT-4或您选择的LM自动修复它。它解决了SWE基准评估集中12.29%的错误，并且只需要1.5分钟来运行。
 * [GalTransl](https://github.com/xd2333/galtransl) - 支持GPT-3.5/GPT-4/Newbing/Sakura等大型语言模型的Galgame自动化翻译解决方案
 * [VAR](https://github.com/foundationvision/var) - [GPT击败扩散🔥] [视觉生成中的缩放定律📈] “视觉自回归建模：通过下一尺度预测实现可扩展图像生成”的官方实现。
 * [ChatWaifu](https://github.com/cjyaddone/chatwaifu) - 将ChatGPT与Moegoe TTS结合，创建一个聊天娇娃
 * [AutoAgents](https://github.com/link-agi/autoagents) - [IJCAI 2024] 为GPT生成不同角色，形成协作实体，完成复杂任务。
 * [suno-api](https://github.com/gcui-art/suno-api) - 使用API调用suno.ai的音乐生成AI，并轻松集成到像GPTs这样的代理中。
 * [ChatGPT-miniprogram](https://github.com/leon-fong/chatgpt-miniprogram) - 🤖 ChatGPT 小程序
 * [99AI](https://github.com/vastxie/99ai) - 99AI 稳定版：基于 NineAI 二开的可商业化 AI Web 应用（免授权，无后门，支持快速部署）。目标 ALL-IN-CHAT99AI 稳定版：基于 NineAI 二开的可商业化 AI 网页应用（无需授权，无后门，支持快速部署）。目标 ALL-IN-CHAT
 * [geekai](https://github.com/yangjian102621/geekai) - AI助手全套开源解决方案，自带运营管理后台，开箱即用。集成了ChatGPT，Azure，ChatGLM，讯飞星火，文心一言等多个平台的大语言模型。支持MJ AI绘画，Stable Diffusion AI绘画，微博热搜等插件工具。采用Go + Vue3 + element-plus实现。
 * [ChatGPT-on-WeChat](https://github.com/kx-huang/chatgpt-on-wechat) - 🤖️ 在您的微信上部署ChatGPT只需两步！两步在云端部署您的微信ChatGPT聊天机器人！🤖️
 * [ai-to-pptx](https://github.com/chatbookai/ai-to-pptx) - Ai-to-pptx是一個使用AI技術(ChatGpt和Gemini)製作PPTX的助手，支持在線修改和導出PPTX。 主要功能: 1 使用ChatGPT等大語言模型來生成大綱 2 生成的內容允許用戶再次修改 3 生成PPTX的時候可以選擇不同的模板 4 支持在線修改PPTX的文字內容，樣式，圖片等 5 支持導出PPTX，PDF，PNG等多種格式
 * [DAIL-SQL](https://github.com/beachwang/dail-sql) - 一个高效且有效的少样本NL2SQL方法在GPT-4上。
 * [auto-playwright](https://github.com/lucgagan/auto-playwright) - 使用ChatGPT自动化Playwright步骤。
 * [mi-gpt](https://github.com/idootop/mi-gpt) - 🏠 将小爱音箱接入 ChatGPT 和豆包，改造成你的专属语音助手。
 * [hostedgpt](https://github.com/allyourbot/hostedgpt) - 一个开放版本的ChatGPT，您可以在任何地方托管或本地运行。
 * [typingmind](https://github.com/typingmind/typingmind) - AI聊天的最先进的Web用户界面
 * [reflex-chat](https://github.com/reflex-dev/reflex-chat) - 一个在Reflex中构建的ChatGPT克隆
 * [gptpdf](https://github.com/cosmosshadow/gptpdf) - 使用GPT解析PDF
 * [vectorhub](https://github.com/guangzhengli/vectorhub) - 通过使用嵌入技术，快速轻松地构建人工智能网站或应用程序！
 * [chatgpt-artifacts](https://github.com/ozgrozer/chatgpt-artifacts) - 将克劳德的文物功能带到ChatGPT
 * [Protofy](https://github.com/protofy-xyz/protofy) - AI 强化的低代码平台 CMS 和框架 🚀🚀
 * [go2coding.github.io](https://github.com/go2coding/go2coding.github.io) - AI工具导航，免费chatgpt，chatgpt4，midjourney，notion ai，tome.app
 * [chatgpt](https://github.com/putyy/chatgpt) - 使用uniapp和hyperf MineAdmin实现的chatgpt应用，支持小程序、h5、app！
 * [vscode-chatgpt-reborn](https://github.com/christopher-hayes/vscode-chatgpt-reborn) - 使用GPT-3和GPT-4在VSCode中重构、改进和调试您的代码。
 * [Chatgpt-Makes-Money](https://github.com/xiaoming2028/chatgpt-makes-money) - ChatGPT副业赚钱技巧必看，ChatGPT副业赚钱秘籍，ChatGPT从入门到精通
 * [sendbird-uikit-react](https://github.com/sendbird/sendbird-uikit-react) - 使用Sendbird UIKit开源代码，可以在几分钟内构建聊天功能。
 * [sol-mate-eink](https://github.com/blixt/sol-mate-eink) - Sol Mate GPT但在您的电子纸显示屏上！
 * [gptstore-data-backup](https://github.com/ainativelab/gptstore-data-backup) - GPT Store每日热门数据存档
 * [ChatGPT-airport-tizi-fanqiang](https://github.com/axiba053/chatgpt-airport-tizi-fanqiang) - ChatGPT科学上网梯子机场推荐，GPT4升级教程，Claude-3免费使用教程ChatGPT科学上网梯子机场推荐，GPT4升级教程，Claude-3免费使用教程
 * [vscode-reborn-ai](https://github.com/vscode-reborn-ai/vscode-reborn-ai) - 使用GPT-3和GPT-4在VSCode中重构、改进和调试您的代码。
 * [gpts](https://github.com/ruvnet/gpts) - rUv创建的GPT集合
 * [zerox](https://github.com/getomni-ai/zerox) - 零射击pdf OCR与gpt-4o-mini
 * [gpt-games](https://github.com/jimliu/gpt-games) - 使用GPT构建游戏
 * [DecodingTrust](https://github.com/ai-secure/decodingtrust) - GPT模型信誉度的综合评估
 * [TalkingHeads](https://github.com/ugorsahin/talkingheads) - 一个用于与ChatGPT、Claude、Copilot、Gemini、HuggingChat和Pi进行通信的库
 * [ChatGPT-Mirror](https://github.com/dairoot/chatgpt-mirror) - 🚀 一键部署您自己的 ChatGPT 镜像站
 * [WiNGPT2](https://github.com/winninghealth/wingpt2) - WiNGPT是一个基于GPT的医疗垂直领域大模型，旨在将专业的医学知识、医疗信息、数据融会贯通，为医疗行业提供智能化的医疗问答、诊断支持和医学知识等信息服务，提高诊疗效率和医疗服务质量。
 * [modded-nanogpt](https://github.com/kellerjordan/modded-nanogpt) - 5B个标记中的GPT-2（124M）质量输出：
 * [minimind](https://github.com/jingyaogong/minimind) - 【大模型】3小时完全从0训练一个仅有26M的小参数GPT，最低仅需2G显卡即可推理训练！【大模型】3小时完全从0训练一个仅有26M的小参数GPT，最低仅需2G显卡即可推理训练！
 * [AI-Youtube-Shorts-Generator](https://github.com/samuraigpt/ai-youtube-shorts-generator) - 一个使用GPT-4、FFmpeg和OpenCV的Python工具，可以自动分析视频，提取最有趣的部分，并裁剪它们以获得更好的观看体验。
 * [miniperplx](https://github.com/zaidmukaddam/miniperplx) - 一款极简主义的人工智能搜索引擎，帮助您在互联网上查找信息。使用像GPT-4o mini、Claude 3.5 Sonnet和o1-mini这样的模型进行搜索！
 * [ai-commit](https://github.com/insulineru/ai-commit) - ✨ 使用ChatGPT，Gitmoji和Conventional Commits使提交更容易 🚀
 * [show-me](https://github.com/marlaman/show-me) - 一个视觉透明的替代品，用于开源ChatGPT O1
 * [chatgpt-api-server](https://github.com/xyhelper/chatgpt-api-server) - 基于chatgpt官网账号转接对外实现API服务
 * [ChatALL](https://github.com/ai-shifu/chatall) - 与ChatGPT、必应聊天、巴德、羊驼、维库纳、克劳德、ChatGLM、MOSS、讯飞星火、文心一言等同时聊天，发现最佳答案。
 * [shadcn-nextjs-boilerplate](https://github.com/horizon-ui/shadcn-nextjs-boilerplate) - Shadcn UI NextJS 模板 ⚡️ 免费开源 ChatGPT UI 管理仪表板模板 - Horizon AI 模板
 * [TaskWeaver](https://github.com/microsoft/taskweaver) - 在Visual Studio Code中集成CMake


