# awesome-ChatGPT-repositories

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Hugging Face Spaces](https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue)](https://huggingface.co/spaces/taishi-i/awesome-ChatGPT-repositories-search)
[![License: CC0-1.0](https://img.shields.io/badge/License-CC0_1.0-lightgrey.svg)](http://creativecommons.org/publicdomain/zero/1.0/)
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

[ChatGPT](https://openai.com/blog/chatgpt)に関連するオープンソースのGitHubリポジトリを厳選したリストです。
これらのリポジトリを[検索するためのツール](https://huggingface.co/spaces/taishi-i/awesome-ChatGPT-repositories-search)はHugging Face Spacesで利用できます。

あなたの貢献をいつでも歓迎します！貢献する前に、[ガイドライン](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/contributing.md)をお読みください。

[English](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.en.md) | [日本語 (Japanese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.ja.md) | [繁體中文 (Chinese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.zh-hant.md) | [简体中文 (Chinese) ](https://github.com/taishi-i/awesome-ChatGPT-repositories/blob/main/docs/README.zh-hans.md)


## The latest additions 🎉

**Prompts**
 * [archgw](https://github.com/katanemo/archgw) - Archはエージェント向けのインテリジェントなゲートウェイです。安全な処理、豊富な観測性、およびAPIとのシームレスな統合を実現するために、(高速な)LLMが使用されています - すべてはビジネスロジックの外側で行われます。Envoyプロキシのコアコントリビューターによって構築され、Envoy上で動作します。
 * [openlit](https://github.com/openlit/openlit) - AIエンジニアリングのためのオープンソースプラットフォーム：OpenTelemetryネイティブLLMオブザーバビリティ、GPUモニタリング、ガードレール、評価、プロンプト管理、ボールト、プレイグラウンド。🚀💻 40以上のLLMプロバイダー、VectorDB、エージェントフレームワーク、GPUと統合されています。


**Browser-extensions**
 * [aura-voice](https://github.com/ntegrals/aura-voice) - AuraはSiriのようなものですが、ブラウザ内で動作します。低遅延応答に最適化されたAI音声アシスタントです。


**Openai**
 * [coai](https://github.com/coaidev/coai) - 🚀 次世代AIワンストップ国際化ソリューション。🚀 下一代AI一站式B/C端解决方案，支持OpenAI，Midjourney，Claude，讯飞星火，Stable Diffusion，DALL·E，ChatGLM，通义千问，腾讯混元，360 智脑，百川 AI，火山方舟，新必应，Gemini，Moonshot 等模型，支持对话分享，自定义预设，云端同步，模型市场，支持弹性计费和订阅计划模式，支持图片解析，支持联网搜索，支持模型
 * [self-operating-computer](https://github.com/othersideai/self-operating-computer) - コンピュータを操作するためのマルチモーダルモデルを可能にするフレームワーク
 * [blinko](https://github.com/blinko-space/blinko) - オープンソースで、プライバシーを重視した、自己ホスト型の個人用ノートツール。TypeScriptを使用して構築されています。


_Updated on November 28, 2024_ (A total of 1892 repositories listed.)

## Table of contents

 * [Awesome-lists](#awesome-lists)
 * [Prompts](#prompts)
 * [Chatbots](#chatbots)
 * [Browser-extensions](#browser-extensions)
 * [CLIs](#clis)
 * [Reimplementations](#reimplementations)
 * [Tutorials](#tutorials)
 * [NLP](#nlp)
 * [Langchain](#langchain)
 * [Unity](#unity)
 * [Openai](#openai)
 * [Others](#others)

## Awesome-lists

 * [awesome-chatgpt-api](https://github.com/reorx/awesome-chatgpt-api) - ChatGPT APIを使用するだけでなく、ユーザーが独自のAPIキーを設定して、自分のクオータを無料でオンデマンドで使用できるようにするアプリやツールのキュレーションリスト。
 * [awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) - このリポジトリには、ChatGPTをより効果的に使用するためのChatGPTプロンプトのキュレーションが含まれています。
 * [awesome-chatgpt](https://github.com/humanloop/awesome-chatgpt) - ChatGPTとGPT-3の素晴らしいツール、デモ、ドキュメントの厳選リスト
 * [awesome-totally-open-chatgpt](https://github.com/nichtdax/awesome-totally-open-chatgpt) - ChatGPTの完全にオープンな代替リスト
 * [awesome-chatgpt-prompts-zh](https://github.com/plexpt/awesome-chatgpt-prompts-zh) - ChatGPTの中国語調教ガイド。様々なシーンでの使用ガイド。あなたの言葉を聞かせる方法を学ぶ。
 * [Awesome-ChatGPT](https://github.com/dalinvip/awesome-chatgpt) - ChatGPTの情報をまとめた学習資料、継続的に更新中...
 * [awesome-compbio-chatgpt](https://github.com/csbl-br/awesome-compbio-chatgpt) - コミュニティがキュレーションしたChatGPTや他のLLMsの計算生物学アプリケーションの素晴らしいリポジトリ。
 * [awesome-chatgpt](https://github.com/openmindclub/awesome-chatgpt) - ⚡ ChatGPTについてのすべて
 * [awesome-chatgpt](https://github.com/saharmor/awesome-chatgpt) - 選択されたChatGPTのデモ、ツール、記事、その他 ✨
 * [awesome-chatgpt-zh](https://github.com/yzfly/awesome-chatgpt-zh) - ChatGPTの中国語ガイド、ChatGPTの中国語調教ガイド、指示ガイド、厳選されたリソースリスト、ChatGPTをより効果的に使用して生産性を向上させましょう！
 * [awesome-chatgpt](https://github.com/eon01/awesome-chatgpt) - 🧠 ChatGPTの素晴らしいリソースの厳選リストです。ライブラリ、SDK、APIなどが含まれます。🌟このプロジェクトをサポートするために、スターをつけてください。
 * [awesome-gpt4](https://github.com/taranjeet/awesome-gpt4) - GPT-4の素晴らしいリソース、ユースケース、デモの厳選リスト
 * [awesome-gpt-security](https://github.com/cckuailong/awesome-gpt-security) - LLMまたはGPTを使用した、素晴らしいセキュリティツール、実験的なケース、またはその他の興味深いものの厳選リスト。
 * [Awesome-GPT4-Prompts](https://github.com/ora-sh/awesome-gpt4-prompts) - 素晴らしいGPT4プロンプトのコレクション
 * [awesome-chatgpt](https://github.com/sindresorhus/awesome-chatgpt) - 🤖 OpenAIによって開発された人工知能チャットボットChatGPTの素晴らしいリスト
 * [awesome-free-chatgpt](https://github.com/lilittlecat/awesome-free-chatgpt) - 🆓無料のChatGPTミラーサイトのリスト、常に更新中。
 * [awesome-gpt-prompt-engineering](https://github.com/snwfdhmp/awesome-gpt-prompt-engineering) - GPTプロンプトエンジニアリングのための素晴らしいリソース、ツール、その他の輝くものの厳選リスト。
 * [awesome-chatgpt-prompts-cybersecurity](https://github.com/sechelper/awesome-chatgpt-prompts-cybersecurity) - ネットワークセキュリティchatgptコマンドセット、chatgptをネットワークセキュリティ専門家にトレーニングする。
 * [awesome-ai](https://github.com/lencx/awesome-ai) - 🤖 素晴らしい人工知能
 * [awesome-chatgpt-code-interpreter-experiments](https://github.com/skalskip/awesome-chatgpt-code-interpreter-experiments) - ChatGPT + Code Interpreterコンボでできる素晴らしいこと 🔥
 * [awesome-ai](https://github.com/520hacker/awesome-ai) - オープンソースAI転送シェルアプリのエコシステムについて研究し、オープンソースAI転送シェルアプリを収集し、比較します。ChatGPT、OPENAI.AZURE、BAIDU、XUNFEI
 * [Awesome-ChatGPT-AI-ZH](https://github.com/changeyu0229/awesome-chatgpt-ai-zh) - 全ネットで1000万以上の露出を受けた「AI知識ベース」が正式にGithubでオープンソース化され、永久に無料で更新され、ChatGPT、Midjourneyなどの使用方法が提供されています。
 * [Awesome-LLM-Eval](https://github.com/onejune2018/awesome-llm-eval) - Awesome-LLM-Eval：ChatGPT、LLaMA、GLMなどの大規模言語モデルの評価に関するツール、デモ、論文、ドキュメントの厳選リスト
 * [awesome-chatgpt-dataset](https://github.com/voidful/awesome-chatgpt-dataset) - LLMの力を解放しましょう：これらのデータセットを使って独自のChatGPTをトレーニングしましょう！
 * [awesome-gpt](https://github.com/formulahendry/awesome-gpt) - GPT、ChatGPT、OpenAI、LLMなどに関連する素晴らしいプロジェクトとリソースの厳選リスト。GPT、ChatGPT、OpenAI、LLMなどに関連する素晴らしいプロジェクトとリソースの厳選リスト。
 * [awesome-instruction-dataset](https://github.com/yaodongc/awesome-instruction-dataset) - 指示に従うためのオープンソースデータセットのコレクション（ChatGPT、LLaMA、Alpaca）
 * [awesome-chatgpt](https://github.com/uhub/awesome-chatgpt) - 素晴らしいChatGPT関連プロジェクトの厳選リスト。
 * [Awesome-Prompt-Engineering](https://github.com/promptslab/awesome-prompt-engineering) - このリポジトリには、Prompt Engineeringに焦点を当てたGenerative Pre-trained Transformer（GPT）、ChatGPT、PaLMなどの手動で選別されたリソースが含まれています。
 * [awesome-generative-ai](https://github.com/filipecalegario/awesome-generative-ai) - 選りすぐりの生成AIツール、作品、モデル、参考文献のリスト
 * [awesome-open-gpt](https://github.com/ewingyangs/awesome-open-gpt) - GPTに関連するオープンソースプロジェクトのコレクション、GPT関連のオープンソースプロジェクトのまとめ🚀、厳選🔥🔥
 * [Awesome-AITools](https://github.com/ikaijua/awesome-aitools) - AI関連のユーティリティのコレクションです。問題やプルリクエストの提出を歓迎します。
 * [Awesome-GPTs](https://github.com/ai-boost/awesome-gpts) - 素晴らしいGPTの厳選リスト 👍。
 * [awesome-segment-anything](https://github.com/hedlen/awesome-segment-anything) - セグメントアニシングに関連する論文、プロジェクト、その他の情報を追跡して収集します。
 * [Awesome-AIGC-Tutorials](https://github.com/luban-agi/awesome-aigc-tutorials) - 大規模言語モデル、AI絵画などのための厳選されたチュートリアルとリソース。
 * [awesome-gpts](https://github.com/taranjeet/awesome-gpts) - コミュニティによって作成されたすべてのGPTのコレクション
 * [prompt-in-context-learning](https://github.com/egoalpha/prompt-in-context-learning) - コンテキストに基づいた学習とプロンプトエンジニアリングのための素晴らしいリソース：ChatGPT、GPT-3、FlanT5などのLLMのマスタリーには最新かつ最先端のアップデートがあります。コンテキストに基づいた学習とプロンプトエンジニアリングのための素晴らしいリソース：ChatGPT、GPT-3、FlanT5などのLLMのマスタリーには最新かつ最先端のアップデートがあります。
 * [Awesome-GPT-Store](https://github.com/anil-matcha/awesome-gpt-store) - カスタムGPTストア - 公開されている主要なGPTのコレクション
 * [awesome-chatgpt](https://github.com/awesome-chatgpt/awesome-chatgpt) - 🏆 ChatGPTの最高のリソース、ツール、アプリケーション、使用法の素晴らしいリスト
 * [BlackFriday-GPTs-Prompts](https://github.com/friuns2/blackfriday-gpts-prompts) - 無料のGPT（Generative Pre-trained Transformer）のリスト（プラスのサブスクリプションが必要ないもの）
 * [best-of-ml-python](https://github.com/ml-tooling/best-of-ml-python) - 🏆 週ごとに更新される、素晴らしい機械学習Pythonライブラリのランク付けリスト。
 * [awesome-openai-vision-api-experiments](https://github.com/roboflow/awesome-openai-vision-api-experiments) - OpenAIビジョンAPIを試してみたり、構築したりしたい人にとって必須のリソースです🔥
 * [Awesome-LLM-KG](https://github.com/rmanluo/awesome-llm-kg) - LLMとKGを統合する素晴らしい論文
 * [Awesome-AI-GPTs](https://github.com/embraceagi/awesome-ai-gpts) - 素晴らしいAI GPT、OpenAI GPT、GPT-4、ChatGPT、GPT、プロンプト、プラグイン、プロンプトの漏洩
 * [Awesome-GPT-Agents](https://github.com/fr0gger/awesome-gpt-agents) - サイバーセキュリティのための厳選されたGPTエージェントのリスト
 * [Awesome-One-Click-Deployment](https://github.com/connectai-e/awesome-one-click-deployment) - 🪄 多くのGitHubオープンソースプロジェクトをワンクリックで展開し、迅速な体験を促進します。
 * [LLM-Reasoning-Papers](https://github.com/atfortes/llm-reasoning-papers) - チェーンオブソート（CoT）、インストラクションチューニングなど、大規模言語モデル（LLM）に関する論文やリソースのコレクション。大規模言語モデル（LLM）に関する論文やリソース、チェーンオブソート（CoT）、インストラクションチューニングなどのコレクション。
 * [awesome-chatgpt-store](https://github.com/devisasari/awesome-chatgpt-store) - 素晴らしいカスタムGPTの厳選リスト
 * [Leaked-GPTs](https://github.com/friuns2/leaked-gpts) - リークされたGPTsによって、25メッセージ制限を回避したり、PlusサブスクリプションなしでGPTsを試すことができます。
 * [awesome-chatgpt-project](https://github.com/xianyu110/awesome-chatgpt-project) - 1.chatGPTの登録 2.chatGPTの完成プロジェクトの整理 3.chatGPTを効果的に使用するための小技 4.調整ガイド ↓デモサイト
 * [awesome-llm-powered-agent](https://github.com/hyp1231/awesome-llm-powered-agent) - LLMパワードエージェントの素晴らしい点。論文/リポジトリ/ブログ/...
 * [awesome-gpt-store](https://github.com/devisasari/awesome-gpt-store) - GPTストアの素晴らしいGPTの厳選リスト
 * [AiTreasureBox](https://github.com/superiorlu/aitreasurebox) - 🤖 AIに関する実用的なリポジトリ、ツール、ウェブサイト、論文、チュートリアルを収集します。実用的なAIの宝箱 💎
 * [Awesome-LLM-Reasoning](https://github.com/atfortes/awesome-llm-reasoning) - チェーンオブソート（CoT）、インストラクションチューニング、およびマルチモダリティを含む、言語モデル（LLM）に関する論文とリソースのコレクション。チェーンオブソート（CoT）、インストラクションチューニング、およびマルチモダリティに関する論文とリソースのコレクション。
 * [awesome-llm-and-aigc](https://github.com/codingonion/awesome-llm-and-aigc) - 🚀🚀🚀大規模言語モデル、ビジョン基盤モデル、AI生成コンテンツに関する素晴らしいパブリックプロジェクトのコレクションです。
 * [awesome-gpts-prompts](https://github.com/ai-boost/awesome-gpts-prompts) - GPTストアのトップ評価GPTからのチャットGPTプロンプトの厳選リスト。
 * [Awesome-LLM-Uncertainty-Reliability-Robustness](https://github.com/jxzhangjhu/awesome-llm-uncertainty-reliability-robustness) - 素晴らしい-LLM-頑健性：大規模言語モデルにおける不確実性、信頼性、および頑健性の厳選されたリスト素晴らしい-LLM-頑健性：大規模言語モデルにおける不確実性、信頼性、および頑健性の厳選されたリスト
 * [awesome-prompts](https://github.com/ai-boost/awesome-prompts) - GPTストアのトップ評価を受けたGPTからのチャットGPTプロンプトのキュレーションリスト。プロンプトエンジニアリング、プロンプト攻撃＆プロンプト保護。高度なプロンプトエンジニアリング論文。
 * [awesome-decentralized-llm](https://github.com/imaurer/awesome-decentralized-llm) - 所有可能なLLMリソースのコレクション。これらを使用して、所有できる製品を作成したり、再現可能な研究を行ったりすることができます。
 * [awesome-gpt4](https://github.com/radi-cho/awesome-gpt4) - GPT-4言語モデルに関する厳選されたプロンプト、ツール、リソースのリスト。
 * [awesome-transformer-nlp](https://github.com/cedrickchee/awesome-transformer-nlp) - Transformerネットワーク、注意機構、GPT、BERT、ChatGPT、LLMs、および転移学習に焦点を当てたNLPリソースの厳選リスト。
 * [awesome-claude-prompts](https://github.com/langgptai/awesome-claude-prompts) - このリポジトリには、クロードをより効果的に使用するためのクロードプロンプトのキュレーションが含まれています。
 * [awesome-ai-sdks](https://github.com/e2b-dev/awesome-ai-sdks) - 自律型AIエージェントを作成、監視、デバッグ、展開するためのSDK、フレームワーク、ライブラリ、ツールのデータベース
 * [awesome-claude-prompts](https://github.com/yzfly/awesome-claude-prompts) - Gitalk コメント
 * [chatgpt-corpus](https://github.com/plexpt/chatgpt-corpus) - ChatGPT 中文コーパス ダイアログコーパス 小説コーパス カスタマーサポートコーパス 大規模モデルのトレーニングに使用
 * [awesome-gpt](https://github.com/awesome-gptx/awesome-gpt) - 🏆 ChatGPTに関連する幅広いツール、文書、リソース、アプリケーション、使用例を網羅した感動的なコレクション。
 * [lobe-chat-agents](https://github.com/lobehub/lobe-chat-agents) - 🤖 / 🏪 エージェントインデックス - これはLobeChatのエージェントインデックスです。 これはこのリポジトリからindex.jsonにアクセスして、LobeChatのエージェントマーケットに利用可能なエージェントのリストを表示します。
 * [awesome-python](https://github.com/dylanhogg/awesome-python) - 🐍 カテゴリ別に整理された、厳選された素晴らしいPythonライブラリとフレームワーク
 * [awesome-llm-role-playing-with-persona](https://github.com/neph0s/awesome-llm-role-playing-with-persona) - 素晴らしいLLM（Large Language Models）を使用した役割演技とペルソナに関する厳選されたリソースのリスト: 割り当てられたペルソナと一緒に役割演技をするためのリソースのリスト
 * [awesome-chatgpt-zh](https://github.com/embraceagi/awesome-chatgpt-zh) - ChatGPTの中国語ガイド🔥、ChatGPTの中国語調教ガイド、指示ガイド、アプリ開発ガイド、厳選されたリソースリスト、ChatGPTをより効果的に活用して生産性を向上させましょう！🚀
 * [Awesome-Machine-Generated-Text](https://github.com/ictmcg/awesome-machine-generated-text) - GPTなどの生成LLMに関連するリソースの連続的に更新されるリストとその分析および検出。GPTなどの生成LLMに関連するリソースの連続的に更新されるリストとその分析および検出。
 * [Awesome_GPT_Super_Prompting](https://github.com/cyberalbsecop/awesome_gpt_super_prompting) - ChatGPTジェイルブレイク、GPTアシスタントプロンプトリーク、GPTプロンプトインジェクション、LLMプロンプトセキュリティ、スーパープロンプト、プロンプトハック、プロンプトセキュリティ、AIプロンプトエンジニアリング、敵対的機械学習。
 * [lobe-chat-plugins](https://github.com/lobehub/lobe-chat-plugins) - 🧩 / 🏪 プラグインインデックス - これはLobeChatのプラグインインデックスです。 これは、このリポジトリからindex.jsonにアクセスして、LobeChatの利用可能なプラグインのリストをユーザーに表示します。
 * [Awesome-LLM-Strawberry](https://github.com/hijkzzz/awesome-llm-strawberry) - OpenAI o1および推論技術に焦点を当てたLLM論文、ブログ、およびプロジェクトのコレクション。
 * [awesome-llm-apps](https://github.com/shubhamsaboo/awesome-llm-apps) - OpenAI、Anthropic、Gemini、およびオープンソースモデルを使用した素晴らしいLLMアプリのコレクション。
 * [awesome-LLM-resourses](https://github.com/wangrongsheng/awesome-llm-resourses) - 🧑‍🚀 世界最高のLLMリソースの要約
 * [awesome-ai-agents](https://github.com/e2b-dev/awesome-ai-agents) - AI自律エージェントのリスト


## Prompts

 * [gpt-repository-loader](https://github.com/mpoon/gpt-repository-loader) - コードリポジトリをLLMプロンプトに適した形式に変換します。主にGPT-4によって構築されています。
 * [myGPTReader](https://github.com/madawei2699/mygptreader) - myGPTReaderは、Slack上のボットで、電子書籍を含む任意のウェブページ、ドキュメント、さらにはYouTubeの動画を読み取り、要約することができます。音声を通じてあなたとコミュニケーションすることもできます。
 * [PromptCraft-Robotics](https://github.com/microsoft/promptcraft-robotics) - LLMをロボットに応用するコミュニティと、ChatGPT統合のロボットシミュレーター。
 * [chat-gpt-quine](https://github.com/fullthom/chat-gpt-quine) - @realtimeai 数週間前に誰かがChatGPTを使って自己改善型のプロンプトを作ろうとしました。それはわずか11世代で病的なモードに崩壊しました。
 * [blender_jarvis](https://github.com/dene33/blender_jarvis) - ChatGPTの助けを借りて、テキストプロンプトを介してBlenderを制御します。
 * [Promptify](https://github.com/promptslab/promptify) - Prompt Engineering | GPTや他のプロンプトベースのモデルを使用して構造化された出力を取得します。Prompt-Engineering、LLMs、およびその他の最新の研究については、私たちのDiscordに参加してください。Prompt Engineering | GPTまたは他のプロンプトベースのモデルを使用して構造化された出力を取得します。Prompt-Engineering、LLMs、およびその他の最新の研究については、私たちのDiscordに参加してください。
 * [SchemaGPT](https://github.com/u-hubar/schemagpt) - GPT-3の魔法を使ってプロンプトからRDFスキーマを生成するPythonライブラリ 🪄🪄🪄
 * [CaFo](https://github.com/zrrskywalker/cafo) - [CVPR 2023] プロンプト、生成、そしてキャッシュ：ファウンデーションモデルのカスケードは強力なフューショット学習者を作り出す
 * [gpt3-interview-bot](https://github.com/promptable/gpt3-interview-bot) - GPT3 インタビュー チャットボット
 * [ama_prompting](https://github.com/hazyresearch/ama_prompting) - 何でも聞いてください言語モデルのプロンプト
 * [LMOps](https://github.com/microsoft/lmops) - LLMsとMLLMsを使用したAI機能を可能にする一般的な技術
 * [bark](https://github.com/suno-ai/bark) - 🔊 テキストに促された生成音声モデル
 * [Prompt-Engineering-Guide](https://github.com/dair-ai/prompt-engineering-guide) - 🐙 迅速なエンジニアリングのためのガイド、論文、講義、ノートブック、およびリソース
 * [langchain-and-elevenlabs-with-pdf-analysis](https://github.com/unicornlaunching/langchain-and-elevenlabs-with-pdf-analysis) - OpenAIとLangchain、ElevenLabsをどのように組み合わせて、PDFに包まれた知識の体系を使ってプロンプトに対する回答を発話させることができるでしょうか？
 * [promptr](https://github.com/ferrislucas/promptr) - Promptrは、GPTを使用してコードベースを操作するためのCLIツールです。Promptrは、GPTのプロンプトに1つ以上のファイルを動的に含め、必要に応じてGPTが提案する変更をコードベースに解析して適用することができます。さまざまな目的のためにいくつかのプロンプトテンプレートが含まれており、ユーザーは独自のテンプレートを作成することができます。
 * [chatgpt-clone](https://github.com/danny-avila/chatgpt-clone) - ChatGPTのクローンで、公式モデルとBingを使用し、リバースエンジニアリングされたUI、AIモデルの切り替え、メッセージ検索、プロンプトテンプレート（WIP）を備えています。
 * [ChatGPT-Prompt-Genius](https://github.com/benf2004/chatgpt-prompt-genius) - プロンプトだけでなく、このオープンソースプロジェクトにも自由に貢献して、創造力を刺激してください。 #chatgpt #gpt4 #chatgptprompts
 * [ChatGPT-Adventure](https://github.com/capnmidnight/chatgpt-adventure) - ChatGPTにテキストアドベンチャーゲームを作成するための開始プロンプトを入力してください。
 * [chatgpt-text-to-midjourney-image](https://github.com/barretlee/chatgpt-text-to-midjourney-image) - ChatGPTを使用してプロンプトを最適化し、Replicateに送信して画像を作成してください。
 * [Prompt-hunter](https://github.com/op7418/prompt-hunter) - 中間旅程の詳細ページからプロンプトと画像をあなたのNotionページに保存してください。
 * [chatbox](https://github.com/bin-huang/chatbox) - Windows、Mac、Linuxに対応したChatGPT API（OpenAI API）のデスクトップアプリ。開発者向けの神器であるpromptをサポートし、全プラットフォームに対応しています。ダウンロードしてインストールするだけで利用可能です。
 * [ChatGPT-Shortcut](https://github.com/rockbenben/chatgpt-shortcut) - 効率と生産性を最大化しましょう。ChatGPTは生産力を倍増させるための便利なコマンドです。領域や機能に応じて分類され、キーワード検索や一括コピーなどが可能です。提示語にタグを付けて絞り込むこともできます。
 * [promptable](https://github.com/cfortuner/promptable) - TypeScript / JavaScriptでLLMアプリを構築してください。🧑‍💻 🧑‍💻 🧑‍💻 🚀 🚀 🚀
 * [ChatGPT3-Free-Prompt-List](https://github.com/mattnigh/chatgpt3-free-prompt-list) - ChatGPT3プロンプトの作成方法を学ぶための無料ガイド
 * [prompt-engine](https://github.com/microsoft/prompt-engine) - Figmaを使用してアプリを作成する
 * [ChatGPT-Siri](https://github.com/yue-yang/chatgpt-siri) - ChatGPT API gpt-3.5-turboとgpt-4モデルを使用したSiriのショートカット。連続的な会話をサポートし、APIキーを設定してチャット記録を保存できます。システムプロンプトを設定することもできます。
 * [The-HustleGPT-Challenge](https://github.com/jtmuller5/the-hustlegpt-challenge) - AI共同創業者とスタートアップを立ち上げる
 * [docsgpt](https://github.com/arc53/docsgpt) - 微調整を施した小さなモデルを作成する：エンジニアリング：後見プロンプトの連鎖-
 * [chatgpt-prompts](https://github.com/carterleffen/chatgpt-prompts) - 以下は私が作成したプロンプトで、共有したいものです。
 * [ChatGPT-Data-Science-Prompts](https://github.com/travistangvh/chatgpt-data-science-prompts) - ChatGPTのための有用なデータサイエンスのプロンプト60のリポジトリ
 * [CWK-ChatGPT-MidJourney-Prompt-Template](https://github.com/neobundy/cwk-chatgpt-midjourney-prompt-template) - cwk-chatgpt-midjourney-prompt-template v1.2おそらく最後のバージョン：23のプロンプトタイプがサポートされています。オブジェクト指向のアプローチに切り替えます：完全な書き直しです。ChatGPTとの互換性が向上します。リポジトリに1.2ライトブランチがあり、いくつかの機能が削除されています...
 * [chatgpt-prompts-bug-bounty](https://github.com/taksec/chatgpt-prompts-bug-bounty) - ChatGPTのバグバウンティとペンテストのプロンプト
 * [Share-to-ChatGPT-Shortcut](https://github.com/reorx/share-to-chatgpt-shortcut) - 個人的なプロンプトを使用して、テキストをChatGPTに共有するためのAppleショートカット
 * [ChatGPT-Prompts](https://github.com/prathamkumar14/chatgpt-prompts) - AIが徐々に支配しています。以下は、ChatGPT/APIプロンプトの使用例であり、あなたの生産性を100％引き出すのに役立ちます。
 * [soren](https://github.com/jacksonmills/soren) - SorenCAIはAIソフトウェアエンジニアのアシスタントプロンプトです。
 * [chatbot-injections-exploits](https://github.com/cranot/chatbot-injections-exploits) - チャットボットのインジェクションとエクスプロイトの例：プロンプトエンジニアコマンドのキュレーションリスト - ChatGPT
 * [ai-notes](https://github.com/sw-yx/ai-notes) - 新しいAIの開発に追いつくためのソフトウェアエンジニア向けのノート。lspace.swyx.ioのライティングや製品のブレストに役立つデータストアとして機能しますが、/Resourcesフォルダーの下にクリーンアップされた標準的な参照があります。
 * [squidgy-prompts](https://github.com/squidgyai/squidgy-prompts) - #langtwt の皆さん、#gpt3 / #chatgpt と言語学習に興味はありますか？私たちは、学習者がデッキを構築し、文をマイニングし、文法を修正し、単語ゲームをプレイするためのオープンソースのプロンプトセットをリリースしました。単独で使用することも、@squidgiesapp で使用することもできます。
 * [ChatGPT_DAN](https://github.com/0xk1h0/chatgpt_dan) - ChatGPT DAN、Jailbreaksのプロンプト
 * [ResearchChatGPT](https://github.com/hollobit/researchchatgpt) - 研究作業のためのChatGPTの50のユースケース
 * [FinGPT](https://github.com/ai4finance-foundation/fingpt) - オープンファイナンスのためのオープンソース！革命を起こそう🔥
 * [aish](https://github.com/aishell-io/aish) - プロンプトとメッセージのためのローカルストレージを備えたChatGPT CLI。
 * [Mr.-Ranedeer-AI-Tutor](https://github.com/jushbjj/mr.-ranedeer-ai-tutor) - カスタマイズ可能な個人に合わせた学習体験のためのGPT-4 AIチュータープロンプト。
 * [ChatGPT-Prompt-Engineering-for-Developers-in-Chinese](https://github.com/githubdaily/chatgpt-prompt-engineering-for-developers-in-chinese) - 「開発者向けのChatGPTプロンプトエンジニアリング」の非公式版英中字幕
 * [prompt-engineering-for-developers](https://github.com/datawhalechina/prompt-engineering-for-developers) - 吴恩达の「ChatGPT Prompt Engineering for Developers」の中国語版コース、ビデオアドレス：https://www.bilibili.com/video/BV1Bo4y1A7FU
 * [unleashedgpt](https://github.com/ambr0sial/unleashedgpt) - UnleashedGPT：もう一つのChatGPTジェイルブレイク
 * [GPT-Prompts](https://github.com/jesselau76/gpt-prompts) - 有用なGPTプロンプト
 * [prompt-engineering](https://github.com/brexhq/prompt-engineering) - OpenAIのGPT-4のような大規模言語モデルを扱うためのヒントやトリック。
 * [wonderful-prompts](https://github.com/yzfly/wonderful-prompts) - 🔥中文プロンプト精選🔥、ChatGPT使用ガイド、ChatGPTのプレイ性と利用性を向上させよう！🚀
 * [RecurrentGPT](https://github.com/aiwaves-cn/recurrentgpt) - RecurrentGPT：（任意に）長いテキストのインタラクティブ生成各タイムステップで段落を生成し、それぞれハードドライブとプロンプトに保存された言語ベースの長期・短期メモリを更新します。リポジトリ：abs：
 * [jopilot-4-job-seekers](https://github.com/jopilot-net/jopilot-4-job-seekers) - JoPilotがサポートするプロンプト
 * [chain-of-thought-hub](https://github.com/franxyao/chain-of-thought-hub) - チェーン・オブ・ソート・プロンプティングを用いた大規模言語モデルの複雑な推論能力のベンチマーク化
 * [ChatGPT-Admin-Web](https://github.com/aprilnea/chatgpt-admin-web) - ChatGPT WebUIには、ユーザー管理とバックエンド管理システムが含まれています。
 * [powerplatform-prompts](https://github.com/pnp/powerplatform-prompts) - このリポジトリには、Power Platformで使用するためのGPTモデルのプロンプト例のコレクションが含まれています。
 * [tutor-gpt](https://github.com/plastic-labs/tutor-gpt) - LangChain LLMアプリケーション。チュータリングのタスクに対するダイナミックなフューショットメタプロンプティング。
 * [chat-gpt-games](https://github.com/admtal/chat-gpt-games) - ChatGPTでプレイ可能なゲームのプロンプト
 * [TaskMatrix](https://github.com/microsoft/taskmatrix) - @jksyaw @LangChainAI @FlowiseAI @bubble プロンプトが説明的で互いに区別できる場合、エージェントは多数のツールでまだ正常に動作すると理解しています。ツールのリストのサンプル使用については、MicrosoftのvisualChatGPTリポジトリをチェックしてください。100万個については確信が持てません...
 * [GPTWorld](https://github.com/srush/gptworld) - 促進について学ぶためのパズル
 * [DemoGPT](https://github.com/melih-unsal/demogpt) - ⚡ DemoGPTは、プロンプトを使用するだけで簡単にクイックデモを作成することができます。⚡ 🌟 星をつけて私たちの活動をサポートしてください！
 * [text-to-colorscheme](https://github.com/svermeulen/text-to-colorscheme) - ChatGPTを使用してテキストプロンプトで生成されたNeovimのカラースキーム
 * [gpt-prompt-engineer](https://github.com/mshumer/gpt-prompt-engineer) - `gpt-prompt-engineer`をご紹介します✍️最適なGPTプロンプトを作成するエージェントです。タスクを説明するだけで、AIシステムの連鎖が以下の手順で行います：- 多くの可能なプロンプトを生成します- ランキングトーナメントでそれらをテストします- 最も優れたプロンプトを返しますしかも、これはオープンソースです。
 * [prompt-engineering-for-javascript-developers](https://github.com/dabit3/prompt-engineering-for-javascript-developers) - DeepLearning.aiによるChatGPTプロンプトエンジニアリングの要約メモ
 * [gpt-runner](https://github.com/nicepkg/gpt-runner) - ファイルとの会話！ AIプリセットを管理して実行しましょう！
 * [promptmap](https://github.com/utkusen/promptmap) - ChatGPTインスタンスに対して自動的にプロンプトインジェクション攻撃をテストします。
 * [IntelliNode](https://github.com/barqawiz/intellinode) - 統一されたプロンプトレイヤーとパフォーマンス評価を通じて、ChatGPT、LLaMA、Stable Diffusion、WaveNetなどの最新のAIモデルにアクセスします。
 * [tree-of-thought-prompting](https://github.com/dave1010/tree-of-thought-prompting) - ツリーオブソートプロンプティングを使用して、ChatGPTの推論力を向上させる
 * [chatGPT-prompt-scripts](https://github.com/wincheshe/chatgpt-prompt-scripts) - 油猴 chatgpt Prompt 脚本插件，在chatgpt聊天框导入Prompt 对话框油猿 chatgpt Prompt スクリプトプラグインを使用して、chatgptチャットボックスにPromptダイアログをインポートします。
 * [llm.report](https://github.com/dillionverma/llm.report) - 📊 llm.reportは、OpenAIのためのオープンソースのログと分析プラットフォームです：ChatGPT APIのリクエストを記録し、コストを分析し、プロンプトを改善します。
 * [InstructZero](https://github.com/lichang-chen/instructzero) - 公式実装：InstructZeroの導入。ChatGPT（API LLMs）の悪いプロンプトを最適化し、最終的に良いプロンプトを得るための最初のフレームワークです！
 * [chatgpt-prompt-engineering-for-developers](https://github.com/kevin-free/chatgpt-prompt-engineering-for-developers) - 吴恩达《ChatGPT Prompt Engineering for Developers》コース中英版
 * [chat-key](https://github.com/overflowy/chat-key) - ChatGPTとAutoHotkeyで生産性を大幅に向上させましょう 🚀
 * [openprompt.co](https://github.com/timqian/openprompt.co) - 作成する。使用する。共有する。ChatGPTのプロンプト
 * [Get-Things-Done-with-Prompt-Engineering-and-LangChain](https://github.com/curiousily/get-things-done-with-prompt-engineering-and-langchain) - LangChain＆Promptエンジニアリングチュートリアルは、ChatGPTなどの大規模言語モデル（LLM）に関するもので、カスタムデータを使用します。データのロードとインデックス作成、プロンプトテンプレートの作成、CSVエージェントの作成、およびカスタムデータへのクエリにリトリーバルQAチェーンを使用するためのJupyterノートブックがあります。PDFファイルを使用したチャット用のプライベートLLM（Llama 2）を使用したプロジェクトや、ツイートの感情分析に関するプロジェクトもあります。
 * [LearnPrompt](https://github.com/learnprompt/learnprompt) - 永久無料のオープンソースのAIGCコース、現在はChatGPT、Midjourney、Runway、Stable Diffusion、AI数字人、AI声音＆音楽、大模型微調をサポートしています。
 * [IntelliNode](https://github.com/intelligentnode/intellinode) - 統一されたプロンプトレイヤーとパフォーマンス評価を介して、ChatGPT、LLaMA、Diffusion、Hugging faceなどの最新のAIモデルにアクセスします。
 * [azure-openai-llm-vector-langchain](https://github.com/kimtth/azure-openai-llm-vector-langchain) - Azure OpenAI、OSS LLM 🌊1. ベクトルデータベースと🦙langchain 🔎2. RAG ChatGptデモ 3. Microsoft ♾️LLM 🌌ライブラリなど。
 * [ChatGPT-Assistant](https://github.com/pierxuy/chatgpt-assistant) - Streamlitを使用して構築されたChatGPTの対話アシスタントは、科学的なインターネット接続なしで使用でき、無料でクラウドに展開できます。複数のウィンドウ、音声通信、対話の保存、コンテキストのプリセット、およびパラメータの調整などの機能をサポートしています。
 * [dev-chatgpt-prompts](https://github.com/pickleboxer/dev-chatgpt-prompts) - 📚 開発者向けのChatGPTプロンプトの個人コレクション！
 * [prompta](https://github.com/iansinnott/prompta) - キーボードを中心としたChatGPT UIで、モバイルにも対応し、チャット履歴をデバイス間で同期し、過去の会話を検索できます。
 * [ChatGPT-Prompt-Sample-Japanese](https://github.com/dahatake/chatgpt-prompt-sample-japanese) - ChatGPT の Prompt のサンプルです。
 * [chatgpt-prompts](https://github.com/jevantang/chatgpt-prompts) - 分類されたChatGPTの中国語ガイド全集。
 * [chat-gpt-prompts-from-aiprm-zh](https://github.com/adambear/chat-gpt-prompts-from-aiprm-zh) - aiprmコミュニティからの2000以上のChatGPTのプロンプトを使用して、GPT3.5のAPIを使って中国語に翻訳しました。
 * [botpress](https://github.com/botpress/botpress) - GPT/LLMエージェントを構築・展開するためのオープンソースハブ ⚡️
 * [promptflow](https://github.com/microsoft/promptflow) - 高品質なLLMアプリを構築します - プロトタイピング、テストから本番展開、モニタリングまで。
 * [generative-ai-for-beginners](https://github.com/microsoft/generative-ai-for-beginners) - 12のレッスン、ジェネレーティブAIを使ってビルディングを始めましょう 🔗 https://microsoft.github.io/generative-ai-for-beginners/
 * [tree-of-thoughts](https://github.com/kyegomez/tree-of-thoughts) - ツリーオブソウルのプラグインとプレイの実装：大規模言語モデルによる意図的な問題解決を70％以上向上させる
 * [Learn_Prompting](https://github.com/trigaten/learn_prompting) - Prompt Engineering、Generative AI、およびLLM Guide by Learn Prompting | 最大のPrompt Engineering学習コミュニティに参加するために、私たちのdiscordに参加してください。
 * [DecryptPrompt](https://github.com/dsxiangli/decryptprompt) - Prompt＆LLM論文のまとめ、オープンソースのデータ＆モデル、AIGCの応用
 * [magentic](https://github.com/jackmpcollins/magentic) - Python関数としてLLMsをシームレスに統合する
 * [chatgpt_system_prompt](https://github.com/louisshark/chatgpt_system_prompt) - すべてのエージェントのシステムプロンプトを保存します。
 * [LangGPT](https://github.com/embraceagi/langgpt) - LangGPT: すべての人がプロンプトのエキスパートになれるようにする！🚀  構造化されたプロンプト、GPTの言語、結構化されたプロンプト
 * [chatgpt-prompts-for-academic-writing](https://github.com/ahmetbersoz/chatgpt-prompts-for-academic-writing) - このライティングプロンプトのリストは、様々なトピックやタスクをカバーしており、研究アイデアのブレインストーミング、言語やスタイルの改善、文献レビューの実施、研究計画の立案などが含まれています。
 * [self-refine](https://github.com/madaan/self-refine) - LLMは自分の仕事にフィードバックを生成し、それを使ってアウトプットを改善し、このプロセスを反復して繰り返すことができます。
 * [GPTs](https://github.com/linexjlin/gpts) - GPTの漏洩したプロンプト
 * [multimodal-maestro](https://github.com/roboflow/multimodal-maestro) - 大規模なマルチモーダルモデル（GPT-4 Vision、LLaVA、CogVLMなど）に対する効果的なプロンプティング。🔥
 * [promptbench](https://github.com/microsoft/promptbench) - 大規模言語モデルの統一評価フレームワーク
 * [Transformers-for-NLP-2nd-Edition](https://github.com/denis2054/transformers-for-nlp-2nd-edition) - BERTからGPT-4へのTransformerモデル、Hugging FaceからOpenAIへの環境。ファインチューニング、トレーニング、プロンプトエンジニアリングの例。ChatGPT、GPT-3.5-turbo、GPT-4、およびDALL-Eを含むボーナスセクション。GPT-4のジャンプスタート、音声からテキストへの変換、テキストから音声への変換、DALL-Eによるテキストから画像生成、Google Cloud AI、HuggingGPTなども含まれます。
 * [llm-guard](https://github.com/laiyer-ai/llm-guard) - LLMインタラクションのためのセキュリティツールキット
 * [Prompt4ReasoningPapers](https://github.com/zjunlp/prompt4reasoningpapers) - ACL2023論文「言語モデルプロンプティングによる推論：サーベイ」のリポジトリ。「言語モデルプロンプティングによる推論：サーベイ」というACL2023論文のリポジトリ。
 * [knowledge](https://github.com/knowledgecanvas/knowledge) - 知識は、お気に入りのウェブサイト、ドキュメント、ファイルを保存、検索、アクセス、探索、チャットするためのツールです。
 * [promptfoo](https://github.com/promptfoo/promptfoo) - プロンプト、モデル、RAGをテストしてください。LLMの出力を評価し比較し、回帰を検出し、プロンプトの品質を向上させてください。OpenAI/Azure GPT、Anthropic Claude、VertexAI Gemini、Ollama、Mistral/Mixtral/Llamaなどのローカルおよびプライベートモデルに対するLLMの評価（CI/CDを使用）
 * [swarms](https://github.com/kyegomez/swarms) - 信頼性のある自律エージェントのスワームを構築、展開、スケーリングしてワークフローの自動化を行います。コミュニティに参加してください：https://discord.gg/DbjBMJTSWD
 * [gptstore-prompts](https://github.com/1003715231/gptstore-prompts) - 以下はGPTStoreのトップ100のプロンプトです。これらを使用して、プロンプトエンジニアリングを学び、向上させることができます。
 * [aigc](https://github.com/phodal/aigc) - 「《構築大言語モデルの応用：アプリケーション開発とアーキテクチャ設計》は、LLMの実世界での応用について紹介したオープンソースの電子書籍であり、大言語モデルの基礎知識や応用、そして自分自身のモデルを構築する方法について説明しています。その中には、Promptの作成、開発、管理、最高の大言語モデルがもたらす可能性の探求、そしてLLMアプリケーション開発のパターンとアーキテクチャ設計が含まれています。」
 * [lingoose](https://github.com/henomis/lingoose) - 🪿 LinGooseは、パイプラインを使用してLLMsベースのアプリケーションを開発するためのGoフレームワークです。
 * [llm-guard](https://github.com/protectai/llm-guard) - LLMインタラクションのためのセキュリティツールキット
 * [ChatGPT-Prompts](https://github.com/yokoffing/chatgpt-prompts) - ChatGPTとBing AIのプロンプトキュレーション
 * [Safety-Prompts](https://github.com/thu-coai/safety-prompts) - LLMの安全性を評価および向上させるための中国語の安全プロンプト。
 * [ChatGPT-Academic-Prompt](https://github.com/xuhangc/chatgpt-academic-prompt) - 学術論文の執筆にChatGPTを使用してください。
 * [Instructgpt-prompts](https://github.com/kevinamiri/instructgpt-prompts) - テキストを生成および分類するためのChatGPTとGPT-3.5の指示ベースのプロンプトのコレクション。
 * [EdgeChains](https://github.com/arakoodev/edgechains) - Input: EdgeChains.jsは、Typescript/Javascriptで作成されたプロダクション向けのGenerative AIです。Jsonnetに基づいています。Webassemblyが動作する場所ならどこでも動作します。プロンプトは宣言的にライブであり、「設定内の外部コード」です。Kubernetesおよびエッジに対応しています。OpenAI GPT、Gemini、Llama2、Aと互換性があります。
 * [prompt-tutorial](https://github.com/pandabearlab/prompt-tutorial) - chatGPT、プロンプト、LLM
 * [chatdev](https://github.com/10cl/chatdev) - ChatDev IDEは、あなたのAIエージェントを構築するためのツールです。ゲーム内のNPCや強力なエージェントツールなど、このプラットフォームで自分が望むものをデザインすることができます。
 * [contoso-chat](https://github.com/azure-samples/contoso-chat) - このサンプルには、Prompt FlowとAI Studioを使用してRAGアプリケーションを作成するEnd2Endプロセスが含まれています。GPT 3.5 Turbo LLMアプリケーションコード、評価、AZD CLIによる展開自動化、評価と展開のためのGitHubアクション、意図マのすべてが含まれています。
 * [LangGPT](https://github.com/langgptai/langgpt) - LangGPT: すべての人が迅速な専門家になるための力を与える！🚀 構造化されたプロンプト、GPTの言語、構造化されたプロンプト
 * [AISuperDomain](https://github.com/win4r/aisuperdomain) - Aila（AI超元域）：Windows、macOS、Android向けのプレミアAI統合ツール。1度質問すると、ChatGPT、Gemini、Claude3、Copilot、Poe、perplexityなど10以上のAIから回答を得ることができます。カスタマイズ可能なAIとプロンプト機能を備えています。
 * [code2prompt](https://github.com/mufeedvh/code2prompt) - コードベースを単一のLLMプロンプトに変換するためのCLIツール。ソースツリー、プロンプトテンプレート、トークン数のカウントが含まれています。
 * [LLM-Prompt-Library](https://github.com/abilzerian/llm-prompt-library) - さまざまなLLM向けの高度なコードおよびテキスト操作プロンプト。GPT-4、Claude、Llama3、Gemini、およびその他の高性能オープンソースLLMに適しています。
 * [zzz-api](https://github.com/xing61/zzz-api) - 優質で安定したOpenAIのAPIインターフェース-企業や開発者向け。OpenAIのAPIプロキシ、ChatGPTのAPI呼び出しをサポートし、openaiのAPIインターフェースをサポートします：gpt-4、gpt-3.5。OpenAIのキーは必要ありません、OpenAIのアカウントを購入する必要もありません、米ドルの銀行カードも必要ありません、すべて不要です、直接呼び出すだけで安定して使いやすいです！！智增增
 * [EasyInstruct](https://github.com/zjunlp/easyinstruct) - [ACL 2024] LLM向けの使いやすい命令処理フレームワーク。
 * [FinRobot](https://github.com/ai4finance-foundation/finrobot) - FinRobot: LLMsを使用した金融アプリケーションのためのオープンソースAIエージェントプラットフォーム 🚀 🚀 🚀
 * [wonderful-prompts](https://github.com/langgptai/wonderful-prompts) - 🔥中国語プロンプトの選択🔥、ChatGPTの使用ガイド、ChatGPTのプレイ性と利便性を向上させる方法！🚀
 * [jailbreak_llms](https://github.com/verazuo/jailbreak_llms) - [CCS'24] Reddit、Discord、ウェブサイト、オープンソースのデータセット（1,405のジェイルブレイクプロンプトを含む）からなる15,140のChatGPTプロンプトからなるデータセット。
 * [step_into_llm](https://github.com/mindspore-courses/step_into_llm) - MindSporeオンラインコース：LLMに入る
 * [promptulate](https://github.com/undertone0809/promptulate) - 🚀大規模言語モデルの自動化と自律言語エージェントの開発フレームワーク。Pythonの方法でLLMエージェントアプリケーションを構築してください！
 * [EDDI](https://github.com/labsai/eddi) - Conversational AI API（OpenAI ChatGPT、Facebook Hugging Face、Anthropic Claude、Google Gemini、Ollamaなど）向けのプロンプト＆会話管理ミドルウェア。Javaで開発され、Quarkusで動作し、Lean、restful、スケーラブル、クラウドネイティブです。提供されるwit。
 * [AIGC_Interview](https://github.com/embraceagi/aigc_interview) - 📚 AIGCの求職面接、必須の基礎知識、ヒントワードエンジニアリング、ChatGPT、Stable Diffusion、Prompt、Embedding、Fintuneなど、AIGCの求職に必要なすべてを知っておく必要があります。
 * [npi](https://github.com/npi-ai/npi) - AIエージェント向けのツール使用APIプラットフォーム
 * [keras-llm-robot](https://github.com/smalltong02/keras-llm-robot) - 大規模言語モデルを学ぶためのWeb UIプロジェクト。このプロジェクトには、チャット、量子化、ファインチューニング、プロンプトエンジニアリングテンプレート、マルチモダリティなどの機能が含まれています。
 * [ComfyUI-N-Nodes](https://github.com/nuked88/comfyui-n-nodes) - ConfyUI用のカスタムノードのスイートには、GPTテキストプロンプト生成、LoadVideo、SaveVideo、LoadFramesFromFolder、FrameInterpolatorが含まれています。
 * [PromptChains](https://github.com/miatechpartners/promptchains) - ChatGPTとClaudeのパフォーマンスを向上させるために、プロンプトをキューに並べてください。
 * [aide](https://github.com/nicepkg/aide) - VSCodeでどんなコードでも制覇：ワンクリックコメント、変換、UIからコードへ、ファイルのAIバッチ処理！💪
 * [comfyui_LLM_party](https://github.com/heshengtao/comfyui_llm_party) - Dify in ComfyUIには、Omost、GPT-sovits、ChatTTS、FLUXプロンプトノードが含まれており、Feishu、discordへのアクセスが可能であり、o1、ollama、qwen、GLM、deepseek、moonshot、doubaoなどの類似したopenai/geminiインターフェースを持つすべてのllmsに適応し、llama/Pなどのローカルllmsにも適応しています。
 * [ChatGPT-OpenAI-Smart-Speaker](https://github.com/olney1/chatgpt-openai-smart-speaker) - このAIスマートスピーカーは音声認識とテキスト読み上げを使用して、OpenAIとエージェントとの音声対話とビジョン機能を可能にします。ユーザーはマイクにプロンプトを話し、プログラムはそのプロンプトをOpenAIに送信して応答を生成します。
 * [AI-Bootcamp](https://github.com/curiousily/ai-bootcamp) - 自己ペースのジェネレーティブAIブートキャンプ。MLの基礎、LLMs、RAGs、LangChain、LangGraph、Fine-tuning Llama 3＆AIエージェント（CrewAI）に関するチュートリアル。
 * [chatgpt-lite](https://github.com/blrchen/chatgpt-lite) - Fast ChatGPT UIは、OpenAIとAzure OpenAIの両方をサポートしています。
 * [Long-Novel-GPT](https://github.com/maoxiaoyuz/long-novel-gpt) - このプロジェクトには、GPTなどの大規模言語モデルに基づいた長編小説ジェネレーターが含まれており、さまざまな小説生成プロンプトやチュートリアルも提供されています。コミュニティの貢献を歓迎し、最高の小説作成体験を提供するために継続的に更新しています。
 * [langfuse](https://github.com/langfuse/langfuse) - 🪢 オープンソースのLLMエンジニアリングプラットフォーム：LLMオブザーバビリティ、メトリクス、評価、プロンプト管理、プレイグラウンド、データセット。LlamaIndex、Langchain、OpenAI SDK、LiteLLMなどと統合されています。🍊YC W23
 * [gateway](https://github.com/portkey-ai/gateway) - 組み込みガードレールを備えた高速AIゲートウェイ。200以上のLLMへのルート、50以上のAIガードレールを1つの高速で使いやすいAPIで提供します。
 * [ai-notes](https://github.com/swyxio/ai-notes) - 新しいAIの開発に追いつくソフトウェアエンジニア向けのノート。https://latent.spaceの執筆や製品のブレインストーミングのためのデータストアとして機能しますが、/Resourcesフォルダーの下に整理された標準的な参照情報があります。
 * [helicone](https://github.com/helicone/helicone) - 🧊 開発者向けのオープンソースLLM-Observabilityプラットフォーム。監視、メトリクス、評価、エージェントトレース、プロンプト管理、プレイグラウンドなどのためのワンライン統合。OpenAI SDK、Vercel AI SDK、Anthropic SDK、LiteLLM、LLamaIndex、LangChainなどをサポート。🍓
 * [optillm](https://github.com/codelion/optillm) - LLMsの推論プロキシの最適化
 * [lunary](https://github.com/lunary-ai/lunary) - LLM向けの製作ツールキット。可観測性、プロンプト管理、評価。
 * [pezzo](https://github.com/pezzolabs/pezzo) - 🕹️ プロンプトデザイン、バージョン管理、インスタント配信、コラボレーション、トラブルシューティング、可観測性などを効率化するために設計された、オープンソースで開発者向けのLLMOpsプラットフォーム。
 * [archgw](https://github.com/katanemo/archgw) - Archはエージェント向けのインテリジェントなゲートウェイです。安全な処理、豊富な観測性、およびAPIとのシームレスな統合を実現するために、(高速な)LLMが使用されています - すべてはビジネスロジックの外側で行われます。Envoyプロキシのコアコントリビューターによって構築され、Envoy上で動作します。
 * [openlit](https://github.com/openlit/openlit) - AIエンジニアリングのためのオープンソースプラットフォーム：OpenTelemetryネイティブLLMオブザーバビリティ、GPUモニタリング、ガードレール、評価、プロンプト管理、ボールト、プレイグラウンド。🚀💻 40以上のLLMプロバイダー、VectorDB、エージェントフレームワーク、GPUと統合されています。


## Chatbots

 * [gpt4all](https://github.com/nomic-ai/gpt4all) - gpt4all：コード、ストーリー、対話を含む大量のクリーンなアシスタントデータでトレーニングされたチャットボット
 * [Open-Assistant](https://github.com/laion-ai/open-assistant) - OpenAssistantは、タスクを理解し、サードパーティシステムとやり取りし、情報を動的に取得してそれを行うことができるチャットベースのアシスタントです。
 * [FastChat](https://github.com/lm-sys/fastchat) - 「Vicuna: GPT-4に感銘を与えるオープンチャットボット」のリリースリポジトリ
 * [kubernetes-chatgpt-bot](https://github.com/robusta-dev/kubernetes-chatgpt-bot) - Kubernetesの問題に対応するChatGPTボット。
 * [chatGPT-telegram-bot](https://github.com/altryne/chatgpt-telegram-bot) - これはTelegramボット内でchatGPTを動作させるための非常に初期の試みです。
 * [chatgpt_telegram_bot](https://github.com/karfly/chatgpt_telegram_bot) - テレグラムでchatgptとgpt-4を統合する方法は？ //t.co/fyumptn5vj経由@hipertextual
 * [ChatRWKV](https://github.com/blinkdl/chatrwkv) - ChatRWKVはChatGPTのようなものですが、RWKV（100％RNN）言語モデルで動作し、オープンソースです。
 * [ChatGPT-at-Home](https://github.com/sentdex/chatgpt-at-home) - ChatGPT @ Home：ChatGPTによって書かれた大規模言語モデル（LLM）チャットボットアプリケーションChatGPT @ Home：ChatGPTによって書かれた大規模言語モデル（LLM）チャットボットアプリケーション
 * [ChuanhuChatGPT](https://github.com/gaizhenbiao/chuanhuchatgpt) - ChatGPT APIのGUI
 * [GPT3Discord](https://github.com/kav-k/gpt3discord) - Discord用の堅牢なオールインワンGPT3インターフェース。ChatGPTスタイルの会話、画像生成、AIモデレーション、カスタムインデックス/ナレッジベース、YouTubeサマライザーなどがあります！
 * [chatgpt-on-wechat](https://github.com/zhayujie/chatgpt-on-wechat) - ChatGPTをベースにしたWechatロボットで、OpenAI APIとitchatライブラリを使用しています。GPT3.5 APIに基づいています。
 * [ChatGPT-in-Slack](https://github.com/seratch/chatgpt-in-slack) - ChatGPTボットとのやり取りを可能にするSlackアプリを構築する方法のSwiftデモンストレーション
 * [gpt-discord-bot](https://github.com/openai/gpt-discord-bot) - Pythonで書かれたDiscordボットの例で、completions APIを使用して`text-davinci-003`モデルと会話し、moderations APIを使用してメッセージをフィルタリングします。
 * [chatgpt-slackbot](https://github.com/sifue/chatgpt-slackbot) - OpenAIのChatGPT APIをSlack上で利用するためのSlackbotスクリプト (日本語での利用が前提)
 * [chatGPT-discord-bot](https://github.com/zero6992/chatgpt-discord-bot) - あなた自身のDiscordボットにChatGPTを統合してください。
 * [vrchatbot](https://github.com/geson-anko/vrchatbot) - VRChatにAI Botを作るためのリポジトリ
 * [Blender-GPT](https://github.com/tree-ind/blender-gpt) - GPT3/4 + Whisper統合によるオールインワンのBlenderアシスタント
 * [dolly](https://github.com/databrickslabs/dolly) - DatabricksのDollyは、Databricks Machine Learning Platformでトレーニングされた大規模な言語モデルです。
 * [chatgpt-failures](https://github.com/giuven95/chatgpt-failures) - ChatGPTや同様のモデルの失敗アーカイブ
 * [researchgpt](https://github.com/mukulpatnaik/researchgpt) - 研究論文と会話できるオープンソースのLLMベースの研究アシスタント
 * [wikipedia-gpt3-bot](https://github.com/shbhrsaha/wikipedia-gpt3-bot) - Wikipediaをクエリして回答を要約するGPT-3を使用して質問に答えるREPLボット
 * [chatgpt-tegram-bot](https://github.com/nukeador/chatgpt-tegram-bot) - Telegram用のシンプルなボットで、ChatGPTとの対話を音声ノートで行い、画像の生成をサポートします。
 * [ChatGeoPT](https://github.com/earth-genome/chatgeopt) - 地理空間検索のためのAIアシスタントの非常に基本的で非常に脆弱なコンセプトの証明
 * [ChatGPT-Trading-Bot-for-KuCoin](https://github.com/krecicki/chatgpt-trading-bot-for-kucoin) - これはKuCoinの取引スクリプトであり、市場データとOpenAIのGPT-3.5言語モデルによって生成された予測モデルに基づいて、連続的に買い注文と売り注文を出します。
 * [vocode-python](https://github.com/vocodedev/vocode-python) - 🤖 音声ベースのLLMエージェントを構築してください。モジュラー+オープンソース。
 * [marvin](https://github.com/prefecthq/marvin) - 🤖🪄 GPTを活用したボットやAI機能のためのバッテリー付きライブラリ
 * [baize](https://github.com/project-baize/baize) - ChatGPTがあなたの独自のチャットボットを1つのGPUで数時間で教えます！
 * [baize-chatbot](https://github.com/project-baize/baize-chatbot) - ChatGPTがあなたの独自のチャットボットを1つのGPUで数時間で教えます！
 * [gpt4all-ui](https://github.com/nomic-ai/gpt4all-ui) - gpt4allチャットボットUI
 * [yolopandas](https://github.com/ccurme/yolopandas) - チャットでpandas操作これ便利。"fy23 q2のどこどこ会社の何何製品に関する売り上げデータをグラフ化してね。"ってセールスオペレーションチームにお願いしているので、これ使って簡単にchatgptにデータ取得お願いできるようにしよう。
 * [ChatDoctor](https://github.com/kent0n-li/chatdoctor) - 医療特化aiチャット「chatdoctor」chatgptも使ってモデルをトレーニングしてる様子全コードとデータセット、モデルの重みがオープンソース化する予定らしい..！
 * [gpt4free](https://github.com/xtekky/gpt4free) - AI産業の分散化、複数のリバースエンジニアリングAPI（poe.com、phind.com、chat.openai.com、phind.com、writesonic.com、sqlchat.ai、t3nsor.com、you.comなど）を介して無料のGPT-4 / 3.5スクリプトを提供します。
 * [Auto-GPT-ZH](https://github.com/kaqijiang/auto-gpt-zh) - Auto-GPTの中国語版とファン団体は、元のプロジェクトと同期して更新され、AI分野の起業、自己メディア組織、AIを使った仕事、学習、創作、収益化を目指しています。
 * [voice-generator-webui](https://github.com/log1stics/voice-generator-webui) - マルチスピーカー、多言語音声生成ツール
 * [autogpt-telegram-chatbot](https://github.com/steamship-packages/autogpt-telegram-chatbot) - ここにあります！あなたのモバイル用のautogpt。Telegramを介して独自のautogptバージョンと通信できます。このプロジェクトをオープンソース化することを誇りに思っています。一緒に何を構築するかを楽しみにしています！
 * [pdfGPT](https://github.com/bhaskatripathi/pdfgpt) - PDF GPTは、GPTの機能を使用してPDFファイルの内容とチャットすることができます。PDFファイルをチャットボットに変換するための唯一のオープンソースソリューションです！
 * [Navi](https://github.com/ssgorg/navi) - GPTに基づくサイバーセキュリティAI
 * [chatgpt-comparison-detection](https://github.com/hello-simpleai/chatgpt-comparison-detection) - 人間とChatGPTの比較コーパス（HC3）、検出器など！🔥
 * [hackGPT](https://github.com/nodatafound/hackgpt) - 私はOpenAIとChatGPTを活用して、ハッカーっぽいことをしています。
 * [talk-to-chatgpt](https://github.com/c-nedelcu/talk-to-chatgpt) - あなたの声でChatGPT AIと話し、その回答を声で聞くために入力してください。
 * [ChatGPT-Telegram-Workers](https://github.com/tbxark/chatgpt-telegram-workers) - 簡単にCloudflare Workers上に自分自身のTelegram ChatGPTボットを展開してください。
 * [reflexion-human-eval](https://github.com/noahshinn024/reflexion-human-eval) - 反射型のGPT-4エージェントは、コード生成において最先端であり、コードを反復的に洗練し、正しいコード生成から正しいテスト生成への「精度のボトルネック」を移行させます。人間の評価精度：反射型GPT-4 88％-GPT-4 67.0％-Codet 65.8％-Palm 26.2％コード：
 * [gptchat-telegram](https://github.com/m1guelpf/gptchat-telegram) - ✨毎回gptchatのウェブサイトを開くのが疲れたので、テレグラムボットを作りました。あなたも欲しい場合は、非常に簡単にセットアップできるようにしました（1つのコマンドを実行するだけです！😯）。リポジトリをチェックしてください👇
 * [Twitter-Comment-Bot](https://github.com/sojinsamuel/twitter-comment-bot) - 指定されたキーワードを含むツイートにコメントするボットです。ボットはOpenAI APIを使用してコメントを生成し、Twitter APIを使用して投稿します。コメント間に固定の遅延を設けて、連続して実行されるように設計されています。
 * [codemancer](https://github.com/0xmmo/codemancer) - コマンドラインでのAIコーディングアシスタント。
 * [ChatGPT-CodeReview](https://github.com/anc95/chatgpt-codereview) - 🐥 ChatGPTで動作するコードレビューボット
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt) - ChatGPTをより効率的かつスムーズに使用し、ChatGPTネットワークのエラーを完全に解決し、ウェブページを頻繁に更新する必要がなく、10以上の余分な手順を省くことができます。また、バックグラウンド監査をキャンセルすることもできます。以下のエラーを解決しました：（1）リソースの取得時にNetworkErrorが発生しました。 （2）何かが間違っています。この問題が解決しない場合は、help.openai.comのヘルプセンターを通じてお問い合わせください。 （3）このコンテンツは当社のコンテンツポリシーに違反する場合があります。 （4）会話が見つかりません。
 * [chatgpt-wework-robot](https://github.com/sytpb/chatgpt-wework-robot) - Zero code, one-click deployment of ChatGPT to WeChat Work, no need for VPN, fast speed. 零コード、企業微信へのChatGPTのワンクリック展開、VPN不要、高速。
 * [chatbot-ui](https://github.com/mckaywrigley/chatbot-ui) - オープンソースのChatGPT UI。
 * [gpt4-pdf-chatbot-langchain](https://github.com/mayooear/gpt4-pdf-chatbot-langchain) - 大規模なPDFドキュメント用のGPT4＆LangChainチャットボット
 * [chat-with-gpt](https://github.com/cogentapps/chat-with-gpt) - 音声付きのオープンソースのChatGPTアプリ
 * [whatsapp-chatgpt](https://github.com/askrella/whatsapp-chatgpt) - ChatGPT + DALL-E + WhatsApp = AIアシスタント :rocket: :robot:
 * [ChatGPT-wechat-bot](https://github.com/autumnwhj/chatgpt-wechat-bot) - WeChatのためのChatGPT https://github.com/AutumnWhj/ChatGPT-wechat-bot
 * [chatbot-ui-pro](https://github.com/mckaywrigley/chatbot-ui-pro) - バラジ・スリニバサン氏の「ネットワーク国家」に対するAI検索とチャット。
 * [chatgpt-twitter-bot](https://github.com/transitive-bullshit/chatgpt-twitter-bot) - OpenAIのChatGPT APIを利用したTwitterボットです。生きています🤖
 * [BetterChatGPT](https://github.com/ztjhz/betterchatgpt) - 「Better ChatGPT」でよりスマートにプレイ＆チャットしましょう。OpenAIのChatGPT APIを探索するためのUIが改善された素晴らしいオープンソースのWebアプリです！（ウェブサイト+Windows+MacOS+Linux）
 * [chatgpt-exporter](https://github.com/pionxzh/chatgpt-exporter) - ChatGPTの会話履歴をエクスポートして共有する。
 * [unChatGPT](https://github.com/riccardolinares/unchatgpt) - unChatGPTはOpenAI APIを使用して、チャットボットのようなチャット体験を作成します。ChatGPTと似ていますが、待ち行列に並ぶ必要がなく、制限されたアクセスもありません。
 * [rubberduck-vscode](https://github.com/rubberduck-ai/rubberduck-vscode) - 公式OpenAI APIを使用して、Visual Studio CodeでAIによるコード編集、説明、コード生成、エラー診断、チャットを行います。
 * [teams-openai-bot](https://github.com/leeford/teams-openai-bot) - サンプルチームのOpenAIボット
 * [speechgpt](https://github.com/hahahumble/speechgpt) - SpeechGPTは、ChatGPTと会話することができるWebアプリケーションです。
 * [langchainjs](https://github.com/hwchase17/langchainjs) - 私たちは、autogptをJSに実装し、新しい読み書きツールをファイルに書き込むために追加しました。これは、node.jsのローカルファイルシステムと、他のすべてのJS環境でのインメモリファイルシステムの両方でバックアップできます。今後も進化させていきます。例はこちらです。
 * [chat-langchainjs](https://github.com/sullivan-sean/chat-langchainjs) - typescriptをバックエンドに使用したchatgptのようなbotで、langchainドキュメンテーションに関する質問にのみ答えるchatlangchainを複製することを入力しました。@swyxさんが今日後半にハッカソンを開催すると聞いています。そこでこのプロジェクトがいくつかのプロジェクトの出発点となることを願っています！
 * [friday-gpt](https://github.com/hmmhmmhm/friday-gpt) - A.IにR&Rを与えてプログラミング業務を進めます。
 * [telegram-chatgpt-concierge-bot](https://github.com/rafalwilinski/telegram-chatgpt-concierge-bot) - Telegramや音声を通じてOpenAIのChatGPTと対話する。
 * [chatgpt-telegram](https://github.com/m1guelpf/chatgpt-telegram) - たった1つのコマンドで、自分自身のGPTChatテレグラムボットを実行してください！
 * [gitgpt](https://github.com/hesse/gitgpt) - 自然言語のコマンドラインgitアシスタント
 * [chatgpt-discord](https://github.com/m1guelpf/chatgpt-discord) - たった1つのコマンドで、自分自身のGPTChat Discordボットを実行しましょう！
 * [larkgpt](https://github.com/bytemate/larkgpt) - ラークチャットGPTボット
 * [LocalAI](https://github.com/go-skynet/localai) - :robot: Goで書かれた、コミュニティ主導のシンプルなローカルOpenAI互換API。消費者向けのハードウェアでCPU上で実行されるOpenAIの代替として使用できます。ggml互換モデル用のAPI。例えば、llama.cpp、alpaca.cpp、gpt4all.cpp、vicuna、koala、gpt4all-j、cerebras。
 * [gpt_jailbreak_status](https://github.com/tg12/gpt_jailbreak_status) - これは、OpenAI GPT言語モデルのジェイルブレイクの状況に関する最新情報を提供することを目的としたリポジトリです。
 * [chat-gpt](https://github.com/jcubic/chat-gpt) - ChatGPTの会話保存ブックマーク
 * [chatgpt-android](https://github.com/skydoves/chatgpt-android) - 📲 ChatGPT Androidは、Compose用のStream Chat SDKを使用してAndroid上でOpenAIのChatGPTをデモンストレーションしています。
 * [gpt-voice-chat](https://github.com/kmizu/gpt-voice-chat) - ChatGPT AIとの実際の音声チャット
 * [chatgpt](https://github.com/jcrodriguez1989/chatgpt) - RからChatGPTへのインターフェース
 * [ChatdollKit](https://github.com/uezo/chatdollkit) - ChatdollKitを使用すると、あなたの3Dモデルをチャットボットに変換できます。
 * [unity-voicevox-bridge](https://github.com/mikito/unity-voicevox-bridge) - unity上からvoicevoxと連携して合成音声を簡単に再生できるシンプルなライブラリ作ってみました！chatgpt apiとかのお供に！
 * [gortanagtp](https://github.com/dasdata/gortanagtp) - 音声とテキストのインタラクションを備えたコンソールアプリケーション、最新のChatGPT API。
 * [HeyChatGPT](https://github.com/ynagatomo/heychatgpt) - あなたの声でChatGPTとやり取りする最小限のiOSアプリ。
 * [glowby](https://github.com/glowbom/glowby) - Glowby Basicは、あなた自身の音声ベースのAIアシスタントを作成するのを手助けします。
 * [wechatbot](https://github.com/djun/wechatbot) - 個人のWeChatにChatGPTを接続する。
 * [Discord-Chatbot-Gpt4Free](https://github.com/mishalhossin/discord-chatbot-gpt4free) - これは無料の画像検出機能を備えたDiscordチャットボットです。
 * [big-agi](https://github.com/enricoros/big-agi) - 💬 GPT-4以上のAIパーソナリティを備えた個人用AIアプリケーション。AIパーソナリティ、AGI機能、テキストから画像への変換、音声、レスポンスストリーミング、コードのハイライトと実行、PDFのインポート、開発者向けのプリセットなどがあります。Next.js、React、Joyを使用して展開し、#big-AGI-energyを贈りましょう！
 * [RasaGPT](https://github.com/paulpierre/rasagpt) - 💬 RasaGPTは、RasaとLangchainの上に構築された最初のヘッドレスLLMチャットボットプラットフォームです。Rasa、FastAPI、Langchain、LlamaIndex、SQLModel、pgvector、ngrok、telegramで構築されています。
 * [FigmaChain](https://github.com/cirediatpl/figmachain) - FigmaChainは、Figmaデザインに基づいてHTML/CSSコードを生成するPythonスクリプトのセットです。OpenAIのGPT-3モデルを使用することで、FigmaChainは開発者がFigmaデザイン入力から素早くHTML/CSSコードを生成することを可能にします。また、インタラクティブなコード生成のためのStreamlitベースのチャットボットインターフェイスも含まれています。
 * [gpt4free-ts](https://github.com/xiangsx/gpt4free-ts) - これは、xtekky/gpt4freeのTypeScriptバージョンの複製プロジェクトです。
 * [slack-gpt](https://github.com/martinseanhunt/slack-gpt) - Langchain、OpenAI、およびPinconeベクトルストアを使用して質問に答えを取得するシンプルなSlackアプリ/ボットスターター。
 * [LLM-As-Chatbot](https://github.com/deep-diver/llm-as-chatbot) - チャットボットサービスとしてのLLM
 * [pdf-chatbot](https://github.com/dissorial/pdf-chatbot) - 自己追跡データの分析：インタラクティブな可視化と予測アルゴリズム
 * [ask_chatgpt](https://github.com/railsjazz/ask_chatgpt) - AIパワードアシスタントGemがあなたのRailsコンソールに直接組み込まれています。ChatGPTのフルパワーをRailsで利用できます。
 * [ecoute](https://github.com/sevask/ecoute) - Ecouteは、ユーザーのマイク入力（You）とスピーカー出力（Speaker）の両方に対して、リアルタイムのテキストトランスクリプトを提供するライブトランスクリプションツールです。また、会話のライブトランスクリプションに基づいて、OpenAIのGPT-3.5を使用してユーザーが言うべき推奨応答を生成します。
 * [privateGPT](https://github.com/samuraigpt/privategpt) - GPTの力を使って、100％プライベートでドキュメントとやり取りするアプリ。データ漏洩はありません。
 * [LLaVA](https://github.com/haotian-liu/llava) - マルチモーダルなGPT-4レベルの機能に向けて構築された大規模な言語とビジョンアシスタント。
 * [OpenChat](https://github.com/openchatai/openchat) - OpenChatでカスタムChatGPTのようなボットを実行して作成し、どこでも埋め込んで共有できるオープンソースのチャットボットコンソールです。
 * [st-chat](https://github.com/ai-yash/st-chat) - チャットボットUIのためのStreamlitコンポーネント
 * [summary-gpt-bot](https://github.com/tpai/summary-gpt-bot) - テキスト、URL、YouTubeビデオの簡潔な要約を生成するAIパワードのテキスト要約Telegramボット。
 * [Bard-API](https://github.com/dsdanielpark/bard-api) - クッキー値を通じてGoogle Bardの応答を返す非公式のPythonパッケージ。
 * [dialoqbase](https://github.com/n4ze3m/dialoqbase) - 簡単にチャットボットを作成する
 * [Video-ChatGPT](https://github.com/mbzuai-oryx/video-chatgpt) - ビデオチャットGPTは、ビデオに関する意味のある会話を生成することができるビデオ会話モデルです。LLMsの機能と、時空間ビデオ表現に適応された事前学習された視覚エンコーダーの能力を組み合わせています。
 * [LLaVA-Med](https://github.com/microsoft/llava-med) - バイオメディシン向けの大規模言語・ビジョンアシスタントで、マルチモーダルなGPT-4レベルの機能に向けて構築されました。
 * [ethgpt](https://github.com/jiayaoqijia/ethgpt) - Ethereumのコードベースとドキュメントのためのチャットボット。
 * [telegram-chatgpt-bot](https://github.com/sabber-slt/telegram-chatgpt-bot) - Telegramで動作するNodeJSベースのChatGPTボットは、音声チャットや画像生成などの高度な機能を備えています。
 * [chatgpt-telegram-bot](https://github.com/n3d1117/chatgpt-telegram-bot) - 🤖 Pythonで書かれた、OpenAIの公式ChatGPT APIと統合して回答を提供するTelegramボット。
 * [ai-chatbot](https://github.com/vercel-labs/ai-chatbot) - Vercel Labsによって構築された、フル機能を備えた、ハッキング可能なNext.js AIチャットボット。
 * [autoclear-chatgpt-history](https://github.com/adamlui/autoclear-chatgpt-history) - 🕶️ プライバシーをより保護するために、ChatGPTにチャット自動クリア機能を追加しました。
 * [chatgpt-widescreen](https://github.com/adamlui/chatgpt-widescreen) - 🖥️ チャットGPTのワイドスクリーン+フルスクリーンモードを追加して、視聴を向上させます。
 * [chatgpt-infinity](https://github.com/adamlui/chatgpt-infinity) - ∞ 全知のChatGPTから無限の回答を生成します（どの言語でも可！）
 * [chatgpt-auto-refresh](https://github.com/adamlui/chatgpt-auto-refresh) - ↻ ネットワークエラーやCloudflareのチェックを回避するために、ChatGPTセッションを新鮮に保ちます。
 * [chatgpt-apps](https://github.com/adamlui/chatgpt-apps) - 🤖 ChatGPTの驚異的なパワーを活用するアプリやそのUXを向上させるアプリ
 * [embedchain](https://github.com/embedchain/embedchain) - 任意のデータセット上で簡単にLLMパワードボットを作成するためのフレームワーク。
 * [paper-summarizer](https://github.com/discus0434/paper-summarizer) - OpenAI LLMsを活用したarXiv論文の要約を行うSlackボット。
 * [vercel-ai-chatbot](https://github.com/supabase-community/vercel-ai-chatbot) - フル機能を備えた、Vercel Labs＆Supabaseによって構築されたSupabaseified Next.js AIチャットボット。
 * [llm-inference](https://github.com/aniketmaurya/llm-inference) - 大規模言語モデル（LLM）の推論APIとチャットボット
 * [GPT4Tools](https://github.com/stevengrove/gpt4tools) - GPT4Toolsは、異なるビジュアル基盤モデルを自動的に決定、制御、活用することができるインテリジェントシステムです。これにより、ユーザーは会話中に画像と対話することができます。
 * [Ultimate-ChatGPT](https://github.com/imabutahersiddik/ultimate-chatgpt) - 究極のChatGPTは、強化された文章作成と問題解決の体験を提供するために設計されたAIパワードの仮想アシスタントです。
 * [wechat-gptbot](https://github.com/iuiaoin/wechat-gptbot) - リスクのない、非常に安定したChatGPTベースのWeChatロボットです！ 🚀
 * [FeishuBot](https://github.com/rawchen/feishubot) - 飛書のグループチャット/個人チャットChatGPTロボット
 * [gradio-chatbot](https://github.com/weaigc/gradio-chatbot) - 自動的に🤗 Huggingface Spaces、魔搭創空間、およびGradio ChatBotを無料のAPIに変換するツールです。GPT4Free、ChatGPT、Llama2、MPT、Falcon Chat、ChatGLM、通義千問など、さまざまなチャットボットのようなスペースをサポートしています。
 * [ChatGpt-Web](https://github.com/79e/chatgpt-web) - Reactで構築された商業的に有益なChatGptウェブアプリケーション。
 * [word-GPT-Plus](https://github.com/kuingsmile/word-gpt-plus) - Word GPT Plusは、chatGPTモデルをMicrosoft Wordに統合するワードアドインです。公式およびWeb APIの両方がサポートされています。
 * [chat-with-your-doc](https://github.com/linjungz/chat-with-your-doc) - LangChainとGPT4/ChatGPTを使用して、Azure OpenAIサービスとOpenAIの両方でPDF/PPTX/DOCX形式のドキュメントとチャットする。
 * [OpenAi-ChatGPT-Bot](https://github.com/darkmakerofc/openai-chatgpt-bot) - DarkMakerofc（Mr Nima）とチームによるOpen Ai ChatGPTボット、WhatsappでChatGPTを体験できます。
 * [opening-up-chatgpt.github.io](https://github.com/opening-up-chatgpt/opening-up-chatgpt.github.io) - Liesenfeld、Andreas、Alianda Lopez、およびMark Dingemanse。2023年。「ChatGPTの公開：指示に調整されたテキスト生成器の公開性、透明性、および説明責任の追跡」。第5回国際会議「対話型ユーザーインターフェースに関する国際会議」の論文集。アイントホーフェン。doi：10.1145/3571884.3604316。
 * [ChatDrug](https://github.com/chao1224/chatdrug) - 薬剤探索のためのChatGPT
 * [aks-openai-terraform](https://github.com/azure-samples/aks-openai-terraform) - この記事では、Terraformを使用してAzure Kubernetes Service(AKS)クラスターとAzure OpenAIサービスを展開する方法、およびAzure ADワークロードアイデンティティを使用してAzure OpenAIに対して認証するTerraformチャットボットを展開し、ChatGPTモデルのChat Completion APIを呼び出す方法を示しています。
 * [Robot-GPT](https://github.com/nonejou072/robot-gpt) - 大型モデルの時代におけるロボットの相互作用タスクのためのROS2とChatGPTに基づくシミュレーションフレームワーク
 * [chatgpt-finetune-ui](https://github.com/anchen1011/chatgpt-finetune-ui) - ChatGPT（gpt-3.5-turbo）の微調整のためのシンプルなPython WebUI
 * [poe-api-wrapper](https://github.com/snowby666/poe-api-wrapper) - 👾 Httpxを使用したPoe.comのPython APIラッパー。これにより、ChatGPT、Claude、Llama、Google-PaLMなどに無料でアクセスできます！🚀
 * [llama-gpt](https://github.com/getumbrel/llama-gpt) - 自己ホスト型のオフラインのChatGPTのようなチャットボットです。Llama 2で動作します。データは一切デバイスから出ませんので、100%プライベートです。新機能：Code Llamaのサポートも追加されました！
 * [rotary-gpt](https://github.com/tcz/rotary-gpt) - 私は古い回転式電話をChatGPTベースの家庭用アシスタントに変えました。あなたも同じことができます。
 * [rusty_llama](https://github.com/moonkraken/rusty_llama) - フロントエンドとバックエンドの両方でRustで作られたシンプルなChatGPTクローン。オープンソースの言語モデルとTailwindCSSを使用しています。
 * [GPT_CodeInterpreter](https://github.com/boyueluzhipeng/gpt_codeinterpreter) - Pythonコードインタプリタと他の複数の機能を備えた究極で無料のOpenAIプロバイダー、ChatGPTとGPT-4によってパワーアップされました！
 * [WebAI-to-API](https://github.com/amm1rr/webai-to-api) - ChatGPT、クロード、バードからAPIへ：）
 * [chatgpt-minimal](https://github.com/blrchen/chatgpt-minimal) - 軽量なチャットGPTボットは、Next.jsとOpenAI Streaming APIを使用して構築されています。
 * [open_source_chatgpt_list](https://github.com/sunlemuria/open_source_chatgpt_list) - ChatGPTのようなモデルやそれ以上を実装するための積極的な取り組みを開始します。
 * [chatgpt-dingtalk-robot](https://github.com/sytpb/chatgpt-dingtalk-robot) - 零コード、ワンクリックでChatGPTをDingTalkにデプロイ、VPN不要
 * [chatterstack](https://github.com/dschil138/chatterstack) - ChatGPTの会話変数を簡単に管理する
 * [PokerGPT](https://github.com/matteo-psnt/pokergpt) - PokerGPTは、ChatGPT-4と一緒にテキサスホールデムポーカーをプレイすることができるPoker Discord Botです。
 * [kitt](https://github.com/livekit-examples/kitt) - リアルタイムでLiveKitを使用してChatGPTと会話してください。
 * [compose-chatgpt-kotlin-android-chatbot](https://github.com/lambiengcode/compose-chatgpt-kotlin-android-chatbot) - :lion:Compose ChatGPT Kotlin - Kotlin + Jetpack Compose + Coroutine + MVVM + Retrofit2 + OpenAIのGPT-3 APIを使用したAndroidチャットボット。ChatGPT APIからのストリームレスポンスを許可します。Compose ChatGPT Kotlin - 使用 Kotlin + Jetpack Compose + Coroutine + MVVM + Retrofit2 + OpenAI 的 GPT-3 API 的 Android 聊天机器人.允许来自 ChatGPT API 的流响应。🤖
 * [Chino-chan-Bot](https://github.com/misonomikadev/chino-chan-bot) - ボットメッセンジャーはChatGPTが統合されています。
 * [Chatbase](https://github.com/anil-matcha/chatbase) - すべてのウェブサイトに対応するChatGPT。ウェブサイトのコンテンツを学習したパーソナライズされたチャットボットで、訪問者の質問に即座に回答します。Chatbase、SiteGPT、Dante AIの代替案です。
 * [plotai](https://github.com/mljar/plotai) - プロットAI - あなたの究極のプロット補助！📊🤖 ChatGPT-3.5を使用して、PythonとMatplotlibで直接プロットを作成するためのPythonスクリプトやノートブックを使用してください。
 * [TianMu](https://github.com/openjarvisai/tianmu) - 天幕：一款现代化的AI工具，支持多平台、支持markdown、多模态、连续对话和可定制的命令。一个支持文心一言、通义千问、LLaMa、ChatGPT等功能的APP，同时也是一个开源的大模型客户端！
 * [youtube-summarizer](https://github.com/sabber-slt/youtube-summarizer) - ChatGPTを使用して、YouTube動画の内容を要約するために設計されたTelegramボット。
 * [ChatGPT-Nuxt](https://github.com/hylarucoder/chatgpt-nuxt) - ChatGPT Web Nuxt 3 Vue 3 バージョン
 * [FirewaLLM](https://github.com/ysy1216/firewallm) - FirewaLLMを呼び出すことで、ユーザーは大規模なモデルの正確性を確保しながら、それとのやり取り時のプライバシー漏洩のリスクを大幅に減らすことができます。私たちはFirewallLLMがプライバシー保護されたChatGPTインタラクションプラットフォームであると考えています。
 * [Langchain-Chatchat](https://github.com/chatchat-space/langchain-chatchat) - Langchain-Chatchat（元Langchain-ChatGLM）は、LangchainとChatGLMなどの言語モデルを利用したローカルな知識ベースの質問応答アプリです。
 * [wukong-robot](https://github.com/wzpan/wukong-robot) - 🤖 wukong-robotは、シンプルで柔軟でエレガントな中国語音声対話ロボット/スマートスピーカープロジェクトであり、ChatGPTのマルチターン対話能力をサポートしています。また、脳機インタラクションをサポートする最初のオープンソーススマートスピーカープロジェクトかもしれません。
 * [autogen](https://github.com/microsoft/autogen) - 次世代の大規模言語モデルアプリケーションを有効にする。私たちのDiscordに参加してください：https://discord.gg/pAbnFJrkgZ
 * [GPTDiscord](https://github.com/kav-k/gptdiscord) - Discord用の堅牢なオールインワンGPTインターフェース。ChatGPTスタイルの会話、画像生成、AIモデレーション、カスタムインデックス/ナレッジベース、YouTubeサマライザーなどが利用可能です！
 * [BotSharp](https://github.com/scisharp/botsharp) - .NETでのAIエージェントアプリケーションフレームワーク
 * [anything-llm](https://github.com/mintplex-labs/anything-llm) - オープンソースのChatGPTに相当する経験を、オープンソースおよびクローズドソースのLLMs、埋め込みツール、およびベクトルデータベースに提供します。非常にクリーンなUIで、無制限のドキュメント、スレッド、および同時ユーザーをサポートし、すべてを管理します。
 * [magic](https://github.com/polterguy/magic) - カスタムのChatGPTベースのウェブサイトチャットボットを作成してください。
 * [rags](https://github.com/run-llama/rags) - データを使用してChatGPTを構築し、すべて自然言語で行います。
 * [LLamaSharp](https://github.com/scisharp/llamasharp) - C#で簡単かつ高速にLLaMA/GPTモデルを実行できます！🤗 さらに、LLamaSharpをsemantic-kernel、unity、WPF、およびWebAppと簡単に統合することもできます。
 * [Open-Custom-GPT](https://github.com/samuraigpt/open-custom-gpt) - Assistants APIを使用して、カスタムGPTを作成し、サイトに追加/埋め込む。 カスタムGPTを作成し、Assistants APIを使用してサイトに追加/埋め込む。
 * [wechat-ai-summarize-bot](https://github.com/aoao-eth/wechat-ai-summarize-bot) - 微信群チャットの要約アシスタント JS バージョン
 * [webwhiz](https://github.com/webwhiz-ai/webwhiz) - WebWhizは、あなたの製品についてすべてを知っており、お客様の問い合わせに即座に応答できるAIチャットボットを作成することができます。
 * [deep-chat](https://github.com/ovidijusparsiunas/deep-chat) - ウェブサイト用の完全にカスタマイズ可能なAIチャットボットコンポーネント
 * [WeChatFerry](https://github.com/lich0821/wechatferry) - 微信のリバースエンジニアリング、微信ボット、ChatGPT、ChatGLM、讯飞星火、Tigerbotなどの大規模モデルに接続可能。WeChatをフックします。
 * [mPLUG-Owl](https://github.com/x-plug/mplug-owl) - [公式実装] mPLUG-Owl＆mPLUG-Owl2：アリババMLLMファミリー。
 * [AstrBot](https://github.com/soulter/astrbot) - ⭐ QQとQQチャンネルの両方で使用できるChatGPT、Bing、Claude、HuggingChatのボット、プラグインをサポートします | 元のQQChannelChatGPT
 * [casibase](https://github.com/casibase/casibase) - ⚡️ウェブUIとエンタープライズSSOを備えたオープンソースのLangChainのようなAI知識データベースです⚡️。OpenAI、Azure、HuggingFace、OpenRouter、ChatGLM、およびローカルモデルをサポートしています。チャットデモ：https://ai.casbin.com、管理ポータルデモ：https://ai.casibase.com
 * [ai-chatbot](https://github.com/vercel/ai-chatbot) - Vercelによって構築された、フル機能を備えた、ハッキング可能なNext.js AIチャットボット。
 * [ChatPDF](https://github.com/anil-matcha/chatpdf) - どんなPDFでもチャットできます。簡単にアップロードしてください。即座に回答します。質問をする、情報を抽出する、AIで文書を要約することができます。ソースも含まれています。
 * [OpenAssistantGPT](https://github.com/marcolivierbouch/openassistantgpt) - OpenAI APIアシスタントを使用してチャットボットを構築するためのオープンソースプラットフォーム。
 * [ai-research-assistant](https://github.com/lifan0127/ai-research-assistant) - アリアは、GPT大規模言語モデルによってパワードされたあなたのAI研究アシスタントです。
 * [aidea](https://github.com/mylxsw/aidea) - AIdeaは、GPTおよび国産の大規模言語モデルである通義千問、文心一言などをサポートし、Stable Diffusion文生図、図生図、SDXL1.0、超解像度、画像着色などをサポートするオールインワンのアプリです。
 * [ChatGPT-weBot](https://github.com/snapdragonlee/chatgpt-webot) - ChatGPT（gpt-3.5以降）とのチャット、WeChatフックインターフェースを使用
 * [vbot](https://github.com/hanson/vbot) - 微信、企微、ロボット、企業微信、企微ロボット、微信ロボット、集約チャット、RPA、プロトコル、フック、リバース、ワークツール、ネットワーク、グループ送信、自動返信、ChatGPT、API接続、安定した防止全言語対応、企業カスタマイズ/SCRM/SAAS専用
 * [org-ai](https://github.com/rksm/org-ai) - Emacsはあなたの個人的なAIアシスタントです。ChatGPTやLLaMAなどのLLMを使用してテキスト生成、DALL-EやStable Diffusionを使用して画像生成を行います。また、音声入力/出力もサポートしています。
 * [Linly](https://github.com/cvi-szu/linly) - Chinese-LLaMA 1＆2、Chinese-Falcon 基礎モデル；ChatFlow中文対話モデル；中文OpenLLaMAモデル；NLPプレトレーニング/指示微調データセット
 * [gpt-ai-assistant](https://github.com/memochou1993/gpt-ai-assistant) - オープンエーアイ + LINE + Vercel = GPT AIアシスタント
 * [TS-GPT](https://github.com/dulaiduwang003/ts-gpt) - SpringCloudAlibabaをベースに開発されたデュアルエンドのGPTアプリケーション。音声対話、描画、画像認識、テキスト対話を含んでいます。デュアルエンドのGPTアプリケーションは、音声対話、描画、画像認識、テキスト対話を含んでいます。
 * [ChatGPT-YourChatRobot](https://github.com/ashinnotfound/chatgpt-yourchatrobot) - ❤開封即使❤QQ/Wechatでの非公式ChatGPTの実装です。あなたのQQまたはWechatをChatGPTに変えてみましょう。
 * [wechat-bot](https://github.com/wangrongding/wechat-bot) - 🤖OpenAi ChatGPT + WeChatyをベースにしたWeChatのロボットです。WeChatのメッセージに自動的に返信したり、WeChatのグループ/友達を管理したり、ゾンビフォロワーを検出したりするのに使用できます...
 * [ChatFred](https://github.com/chrislemke/chatfred) - チャットGPT、DALL·E 2などを使用したAlfredワークフローによるチャット、画像生成などAlfredワークフローを使用して、チャット、画像生成などを行うためのチャットGPT、DALL·E 2などのモデルを使用します。
 * [catai](https://github.com/withcatai/catai) - 🦙モデルのためのUI。AIアシスタントをローカルで実行する✨
 * [ChatGPT-Telegram-Bot](https://github.com/yym68686/chatgpt-telegram-bot) - 🤖️ AIチャットTelegramボットは、Zeabur、fly.io、およびReplitでPythonを使用してGPTとClaude2.1によるWeb検索を行うことができます。
 * [bidara](https://github.com/nasa-petal/bidara) - BIDARAは、生物模倣学研究所の段階的な設計プロセスを使用して、持続可能なデザインと技術を作成するために生物が使用する戦略を科学者やエンジニアが理解し、学び、模倣するのを支援するように指示されたGPT-4チャットボットです。
 * [sagittarius](https://github.com/gregsadetsky/sagittarius) - GPT-4/Geminiの音声/ビデオ探索ツール
 * [Chat-with-Github-Repo](https://github.com/peterw/chat-with-github-repo) - このリポジトリには、Streamlit、OpenAI GPT-3.5-turbo、およびActiveloopのDeep Lakeを使用してチャットボットを作成する方法を示す2つのPythonスクリプトが含まれています。
 * [pandas-ai](https://github.com/gventuri/pandas-ai) - データとのチャット（SQL、CSV、pandas、polars、noSQLなど）。PandasAIは、LLMs（GPT 3.5 / 4、Anthropic、VertexAI）とRAGを使用して、データ分析を対話形式にします。
 * [chatgpt-mirai-qq-bot](https://github.com/lss233/chatgpt-mirai-qq-bot) - 🚀 ワンクリックで展開！本物のAIチャットボット！ChatGPT、文心一言、讯飞星火、Bing、Bard、ChatGLM、POEをサポートしています。複数のアカウント、キャラクターの調整、バーチャルメイド、画像レンダリング、音声送信に対応しています。QQ、Telegram、Discord、WeChatなどのプラットフォームをサポートしています。
 * [quivr](https://github.com/quivrhq/quivr) - あなたのGenAIセカンドブレイン🧠個人の生産性アシスタント（RAG）⚡️🤖Langchain、GPT 3.5 / 4 turbo、Private、Anthropic、VertexAI、Ollama、LLMsを使用して、ドキュメント（PDF、CSVなど）やアプリとチャットできます。ユーザーと共有できる！ OpenAI GPTやChatGPTに対するローカルでプライベートな代替です。検索増強生成によってパワードされています。
 * [smalltalk](https://github.com/tinystruct/smalltalk) - @tinystruct と統合された、@OpenAI GPT-3 / 3.5-turbo / ChatGPT ベースのチャットモジュールです。
 * [maid](https://github.com/mobile-artificial-intelligence/maid) - Maidは、GGUF / llama.cppモデルとローカルでインターフェースするためのクロスプラットフォームのFlutterアプリであり、また、OllamaとOpenAIモデルとリモートでインターフェースするためのものです。
 * [pandas-ai](https://github.com/sinaptik-ai/pandas-ai) - データとのチャット（SQL、CSV、pandas、polars、noSQLなど）。PandasAIは、LLMs（GPT 3.5 / 4、Anthropic、VertexAI）とRAGを使用して、データ分析を対話形式にします。
 * [WeChatRobot](https://github.com/lich0821/wechatrobot) - WeChatボット、Google Bard、ChatGPT、ChatGLM、讯飞星火、Tigerbotに接続します。四字熟語ゲーム、天気予報、ニュースの要約。
 * [chatgptassistantautoblogger](https://github.com/incomestreamsurfer/chatgptassistantautoblogger) - このオートブロガーは、GPTアシスタントのAPIを使用して、ECサイトでのオートブログを行います。
 * [chaty](https://github.com/cosin2077/chaty) - 1行のコード、すべてのChatGPTの想像力に満足✨✨✨
 * [wechat-assistant-pro](https://github.com/leochen-g/wechat-assistant-pro) - 知能ウェイシュ，オールインワンのWeChatボット管理プラットフォーム、ChatGPT、FastGPT、Difyナレッジベースに最も簡単な方法でアクセスできます。図形描画、オンライン検索、音声認識、さまざまなタイマータスクをサポートし、企業WeChat、個人WeChat、公式アカウント、5Gメッセージ、WhatsAppをサポートします。
 * [ChatGPT-Telegram-Bot](https://github.com/v-know/chatgpt-telegram-bot) - スムーズなAI体験を提供するTelegramボット。
 * [nlux](https://github.com/nluxai/nlux) - 対話型AIインターフェースを構築するためのオープンソースReact / Javascriptライブラリ
 * [ChatGPT-Line-Bot](https://github.com/theexplainthis/chatgpt-line-bot) - これは、ChatGPTをLineに統合することができるリポジトリです。
 * [langup-ai](https://github.com/jiran214/langup-ai) - AGI ソーシャルネットワークボット。BiliBili | ライブチャット数字人 | 動画@自動返信 | ダイレクトメッセージボット | 端末チャット | 音声インタラクション
 * [customizable-gpt-chatbot](https://github.com/shamspias/customizable-gpt-chatbot) - Django RESTフレームワークで構築されたダイナミックでスケーラブルなAIチャットボットは、PDF、ドキュメント、ウェブサイト、YouTubeビデオからのカスタムトレーニングをサポートしています。 OpenAIのGPT-3.5、Pinecone、FAISS、およびCeleryを活用して、シームレスな統合とパフォーマンスを実現しています。
 * [DarkGPT](https://github.com/luijait/darkgpt) - DarkGPTは、リークされたデータベースにクエリを実行するために設計されたGPT-4-200K（推奨使用）に基づくOSINTアシスタントであり、従来のOSINTプロセスで役立つ人工知能アシスタントを提供します。
 * [Kuebiko](https://github.com/adi-panda/kuebiko) - GPT-3とGoogle Cloud TTSを使用したAI Twitch TTSチャットボットAI Twitch TTSチャットボット
 * [AI-Catalog](https://github.com/mehmetkahya0/ai-catalog) - 巨大なAIモデルカタログ。さまざまなドメインにわたるAIツール、プラットフォーム、リソースの厳選リスト。
 * [Multi-Modality-Arena](https://github.com/opengvlab/multi-modality-arena) - チャットボットアリーナがマルチモダリティに対応しました！マルチモダリティアリーナでは、画像を入力として提供しながら、ビジョン言語モデルを並べてベンチマークを行うことができます。MiniGPT-4、LLaMA-Adapter V2、LLaVA、BLIP-2などをサポートしています！
 * [chatbot](https://github.com/zhaoyingjun/chatbot) - ChatGPTがチャットボットを人気にしました。主流のトレンドはすべてGPTタイプのモデルに調整されており、このプロジェクトも最新のGPTタイプのバージョンを近日中に更新する予定です。このプロジェクトと独自のコーパスを使用して、自分が望むチャットボットをトレーニングすることができ、インテリジェントカスタマーサービス、オンライン質問回答、雑談などのシーンに活用できます。
 * [WechatBotCMD](https://github.com/wechatapis/wechatbotcmd) - WechatBotCMDは、Python 3.11をベースにした革新的なプロジェクトであり、ChatGPTモデルとWechatのネイティブAPIを組み合わせることで、ユーザーにスマートなチャット、自動描画、自動的に友達に共有する、自動的に動画を共有するなど、さまざまなAPI統合サービスを提供します。日常のコミュニケーション効率と面白さを向上させることを目的としています。
 * [ChatGPT-On-CS](https://github.com/lrhh123/chatgpt-on-cs) - 大規模モデルを活用したインテリジェントなチャットボットツールで、WeChat、Taobao、Bilibili、Douyin Enterprise、Douyin、Douyin Store、Weibo Chat、Xiaohongshu Professional Operations、Xiaohongshu、Zhihuなどのプラットフォームに接続できます。GPT3.5/GPT4.0/ Lazy Man's Treasure Chest（今後、さらに多くのプラットフォームをサポート予定）を選択でき、テキスト、音声、画像を処理し、プラグインを使用してオペレーティングシステムやインターネットなどの外部リソースにアクセスできます。独自のナレッジベースに基づいた企業向けAIアプリケーションをカスタマイズすることができます。
 * [agentcloud](https://github.com/rnadigital/agentcloud) - エージェントクラウドは、自分自身のGPTビルダーを持っているような感覚で、さらにたくさんの特典が付いてきます。GUIには、1) 260以上のデータソースをネイティブに埋め込むことができるRAGパイプライン、2) 会話型アプリ（GPTのようなもの）の作成、3) マルチエージェントプロセス自動化アプリ（crewai）の作成、4) ツールがあります。
 * [openlrc](https://github.com/zh-plus/openlrc) - WhisperとLLM（GPT、Claudeなど）を使用して、音声をLRCファイルに転写し、翻訳します。
 * [wrest-chat](https://github.com/opentdp/wrest-chat) - WeChatボット、PC WeChat API/Bot/SDK、組み込みのWEB管理インターフェース、GPT、Gemini、星火、文心、混元、通義千問などの大規模言語モデルに接続可能
 * [chatbot-app](https://github.com/chatbot-all/chatbot-app) - モバイルプライベートChatGPTアプリケーション、GPT3、GPT4＆Gemini Proモデルをサポート。独自のモバイルChatGPT/Geminiアプリを持っています。
 * [ChatGPT-On-CS](https://github.com/cs-lazy-tools/chatgpt-on-cs) - 大規模モデルを活用したインテリジェントなチャットボットツールで、WeChat、Taobao、Bilibili、Douyin Enterprise、Douyin、Douyin Store、Weibo Chat、Xiaohongshu Professional Operations、Xiaohongshu、Zhihuなどのプラットフォームに接続できます。GPT3.5/GPT4.0/ Lazy Man's Treasure Chest（今後、さらに多くのプラットフォームをサポート予定）を選択でき、テキスト、音声、画像を処理できます。プラグインを使用してオペレーティングシステムやインターネットなどの外部リソースにアクセスし、独自のナレッジベースに基づいて企業向けAIアプリケーションをカスタマイズできます。
 * [MOSS](https://github.com/openmoss/moss) - 復旦大学からのオープンソースツールによる会話言語モデル復旦大学からのオープンソースツールによる会話言語モデル
 * [Wa-OpenAI](https://github.com/sansekai/wa-openai) - WhatsAppボットOpenAI ChatGPT NodeJSを使用したライブラリBaileysWhatsAppボットOpenAI ChatGPT NodeJSを使用したライブラリBaileys
 * [gpt-assistant-android](https://github.com/skythinker616/gpt-assistant-android) - 無料のChatGPT APIボイスアシスタントは、音声インタラクションのために音量キーで起動され、ネットワーク接続、Vision写真認識、質問テンプレートなどの機能をサポートしています。
 * [gpt-home](https://github.com/judahpaul16/gpt-home) - ChatGPTを家で使おう！基本的には、Google Nest HubやAmazon Alexaのホームアシスタントよりも優れています。Raspberry Piを使用して、OpenAI APIに基づいて構築されています。
 * [gpt-computer-assistant](https://github.com/onuratakan/gpt-computer-assistant) - Windows、macOS、およびUbuntu用のgpt-4o
 * [nlux](https://github.com/nlkitai/nlux) - The 𝗣𝗼𝘄𝗲𝗿𝗳𝘂𝗹 Conversational AI JavaScript Libraryパワフルな会話型AI JavaScriptライブラリ
 * [Streamer-Sales](https://github.com/peterh0323/streamer-sales) - Input: Streamer-Sales 销冠 —— 卖货主播 LLM 大模型🛒🎁，一个能够根据给定的商品特点对商品进行解说并激发用户的购买意愿的卖货主播模型。🚀⭐内含详细的数据生成流程❗ 📦另外还集成了 LMDeploy 加速推理🚀、RAG检索增强生成 📚、TTS文字转语音🔊Output: ストリーマーセールス 销冠 —— 販売主播 LLM 大モデル🛒🎁、商品の特徴に基づいて商品を説明し、ユーザーの購買意欲を刺激する販売主播モデル。🚀⭐詳細なデータ生成プロセスが含まれています❗ 📦さらに、LMDeployの高速推論🚀、RAG検索強化生成 📚、TTSテキスト読み上げ🔊
 * [Chatbase-Alternative](https://github.com/anil-matcha/chatbase-alternative) - 各ウェブサイト用のChatGPT。ウェブサイトコンテンツでトレーニングされたパーソナライズされたチャットボットで、訪問者の質問に即座に回答します。Chatbase、SiteGPT、Dante AIの代替案。
 * [speak-gpt](https://github.com/andraxdev/speak-gpt) - OpenAI ChatGPTに基づいたあなたの個人用音声アシスタント。
 * [IncarnaMind](https://github.com/junruxiong/incarnamind) - GPT 3.5、GPT-4 Turbo、Claude、およびローカルオープンソースLLMsを介して複数のドキュメント（pdfおよびtxt）を接続してチャットします。
 * [unsaged](https://github.com/jorge-menjivar/unsaged) - AIモデルとのシームレスなインタラクションを可能にするオープンソースチャットキット。
 * [discord-llm-chatbot](https://github.com/jakobdylanc/discord-llm-chatbot) - llmcord.py • 友達とLLMと話す!
 * [Instruct2Act](https://github.com/opengvlab/instruct2act) - Instruct2Act：大規模言語モデルを使用した多様なモダリティ指示のロボットアクションへのマッピング
 * [GURU-Ai](https://github.com/guru322/guru-ai) - 機能満載のシンプルで複雑なAIチャットロボット🚩
 * [voxelgpt](https://github.com/voxel51/voxelgpt) - 視覚データセットをクエリできるAIアシスタント、FiftyOneのドキュメントを検索し、一般的なコンピュータビジョンの質問に答える視覚データセットをクエリできるAIアシスタント、FiftyOneのドキュメントを検索し、一般的なコンピュータビジョンの質問に答える
 * [XYBot](https://github.com/henryxiaoyang/xybot) - Dockerとpywxdllフックインジェクションを使用したWeChatボット🤖️！✅高度にカスタマイズ可能！ ✅自作プラグインのサポート！機能がたくさんあります：天気🌤️、ニュース取得📰、ChatGPTチャット🗣️、Hypixelプレイヤー検索🎮、ランダム画像📷、ランダムリンク🔗、ランダムグループメンバー👥、五目並べ♟️、サインイン✅、ポイント検索📊、ポイントランキング🏆、ポイント送信💰、ポイント抽選🎁、ポイントお年玉🧧など
 * [GPTPortal](https://github.com/zaki-1052/gptportal) - 機能豊富なポータルを介して、軽量なNode.jsウェブアプリを使用してGPT-4、Claude、Gemini、Mistral、およびOpenAIアシスタントAPIとチャットするためのポータルを提供します。音声、画像、ファイルに対応したカスタマイズ可能なマルチモダリティをサポートしています。
 * [CreativeChatGLM](https://github.com/ypwhs/creativechatglm) - 👋 ChatGLMの創造的な世界へようこそ！修正や継続書き機能を使って創造的なコンテンツを生成することができます！
 * [ChatPilot](https://github.com/shibing624/chatpilot) - ChatPilot: AgentChatの会話を実現し、Google検索、ファイルURL会話（RAG）、コード解釈機能をサポートし、Kimi Chat（ファイル、ドラッグアンドドロップ；URL、送信）を再現しました。
 * [Whatsapp-Ai-BOT](https://github.com/yesbhautik/whatsapp-ai-bot) - WhatsApp用のAIチャットボットをご紹介します - OpenAIのChatGPT、Playground＆DALL·Eによってパワードされた最先端のソリューションです。この革新的なチャットボットは、NodeJS技術を使用して開発され、AIの最新の進歩を活用して、類を見ないユーザーエクスペリエンスを提供しています。
 * [fastui-chat](https://github.com/shroominic/fastui-chat) - 💬 純粋なPythonで作られたミニマリストなChatBotインターフェース
 * [pokitoki](https://github.com/nalgeon/pokitoki) - 謙虚なGPTテレグラムボット
 * [openai-chat-api-workflow](https://github.com/yohasebe/openai-chat-api-workflow) - 🎩 OpenAI Chat APIを使用してGPT-3.5/GPT-4とやり取りするためのAlfred 5ワークフロー 🤖💬 画像生成も可能 🖼️、画像理解 👀、音声からテキストへの変換 🎤、テキストから音声への合成 🔈
 * [AIUI](https://github.com/lspahija/aiui) - AIUIはAIとのシームレスな双方向の音声コミュニケーションを可能にするプラットフォームです。
 * [OPERA](https://github.com/shikiw/opera) - [CVPR 2024 ハイライト] OPERA: 過信ペナルティと振り返り割り当てを用いたマルチモーダル大規模言語モデルにおける幻覚の緩和
 * [bot-on-anything](https://github.com/zhayujie/bot-on-anything) - AIモデル（ChatGPT-3.5/4.0、Baidu Yiyan、New Bing、Bardなど）をアプリ（Wechat、公式アカウント、DingTalk、Telegram、QQなど）に接続します。ChatGPT、必应、文心一言、谷歌Bardなどの対話モデルをWechat、公式アカウント、QQ、Telegram、Gmail、Slack、Web、企業Wechat、飛書、DingTalkなどのさまざまなアプリに接続します。
 * [psychic](https://github.com/psychic-api/psychic) - LLM向けのデータ統合プラットフォーム。ターンキー認証でSaaSツールに接続し、Nつのデータソースからドキュメントを同期するための唯一の統合を行います。
 * [gpt-computer-assistant](https://github.com/upsonic/gpt-computer-assistant) - Windows、macOS、およびLinux用のgpt-4oWindows、macOS、およびLinux用のgpt-4o
 * [OpenAssistantGPT](https://github.com/openassistantgpt/openassistantgpt) - OpenAIのAssistant APIを使用して、ウェブサイトに追加できる、Crafting/Building/Creating Chatbots向けのコミュニティオープンソースSaaS。
 * [ChatGPT](https://github.com/nisabmohd/chatgpt) - Next.js 14、Shadcn-UI、Prisma ORMを使用してChatGPTのクローンを開発し、OpenAI APIと統合しました。ユーザーフレンドリーな会話型AI体験を提供しています。
 * [ChatGPT-Linebot-using-python-flask-on-vercel](https://github.com/howarder3/chatgpt-linebot-using-python-flask-on-vercel) - Vercel用のPython Flaskを使用したGPT-LinebotGPT-LinebotをVercelで使用するPython Flask
 * [ComfyUI-GPT_SoVITS](https://github.com/aifsh/comfyui-gpt_sovits) - GPT-SoVITS用のカスタムノード「comfyui」！今、comfyuiでボイスクローンとTTSができます。
 * [slack-bot](https://github.com/innogames/slack-bot) - 怠惰な開発者向けのSlackボットを使用準備完了：Jenkinsジョブを開始し、Jiraチケットを監視し、AIサポート付きでプルリクエストを監視...
 * [psychic](https://github.com/finic-ai/psychic) - LLM向けのデータ統合プラットフォーム。ターンキー認証でSaaSツールに接続し、Nつのデータソースからドキュメントを同期するための唯一の統合を行います。
 * [repopack](https://github.com/yamadashy/repopack) - 📦 Repopackは、あなたのリポジトリ全体を1つの、AIにとっても使いやすいファイルにパックする強力なツールです。大規模言語モデル（LLM）やClaude、ChatGPT、Geminiなどの他のAIツールにコードベースを提供する必要があるときに最適です。
 * [finic](https://github.com/finic-ai/finic) - LLM向けのデータ統合プラットフォーム。ターンキー認証でSaaSツールに接続し、Nつのデータソースからドキュメントを同期するための唯一の統合を行います。
 * [llmcord.py](https://github.com/jakobdylanc/llmcord.py) - OpenAI互換API（OpenAI、Mistral、Groq、OpenRouter、ollama、oobabooga、Jan、LM Studioなど）をサポートするDiscord LLMチャットボット
 * [django-ai-assistant](https://github.com/vintasoftware/django-ai-assistant) - DjangoとAIアシスタントを統合して、知的なアプリケーションを構築します。
 * [MindSQL](https://github.com/mindinventory/mindsql) - MindSQL：データベースの相互作用を簡素化するPython Text-to-SQL RAGライブラリ。PostgreSQL、MySQL、SQLite、Snowflake、およびBigQueryとシームレスに統合されています。GPT-4とLlama 2によって動作し、自然言語クエリを可能にします。ChromaDBとFaissをサポートしています。
 * [insights-bot](https://github.com/nekomeowww/insights-bot) - ボットはOpenAI GPTモデルと連携して、情報フローに対する洞察を提供します。ボットはOpenAI GPTモデルと連携して、情報フローに対する洞察を提供します。
 * [Babagaboosh](https://github.com/dougdouggithub/babagaboosh) - OpenAiのGPT 4との口頭会話ができるアプリ
 * [wandbot](https://github.com/wandb/wandbot) - wandbotは、Discord、Slack、ChatGPT、Zendeskで動作するWeights & BiasesのAI開発者ツールのためのテクニカルサポートボットです。
 * [ai-data-analysis-MulitAgent](https://github.com/starpig1129/ai-data-analysis-mulitagent) - AI駆動型研究アシスタント：複雑な研究プロセスを自動化するための高度なマルチエージェントシステム。LangChain、OpenAI GPT、LangGraphを活用し、このツールは仮説の生成、データ分析、可視化、レポート作成を効率化します。完璧
 * [lobe-vidol](https://github.com/lobehub/lobe-vidol) - 🧸 ロベ・ヴィドル - 仮想アイドルを誰もが利用できるようにする
 * [RLAIF-V](https://github.com/rlhf-v/rlaif-v) - RLAIF-V：オープンソースAIフィードバックを介したMLLMの整列によるSuper GPT-4Vの信頼性
 * [builderbot](https://github.com/codigoencasa/builderbot) - 🤖数分でWhatsAppチャットボットを作成します。このオープンソースプロジェクトに参加してください。
 * [hey](https://github.com/lnxpy/hey) - 💬 AIパワードのペアプログラミングフレンド！
 * [Auto-Gmail-Creator](https://github.com/ai-to-ai/auto-gmail-creator) - Selenium＆Seleniumwire（Python）を使用したオープンソースの大量自動Gmail作成ボット。Django / Flask、ML、AI、GPT、自動化、スクレイピングに関してはお気軽にお問い合わせください。
 * [design-studio](https://github.com/tiledesk/design-studio) - Tiledeskのオープンソースのビジュアルで、コード不要のデザイナー。LLM/GPT AIが柔軟な「グラフ」アプローチと出会う場所。会話や自動化を簡単に作成できます - VoiceflowやBotpressの代替手段。
 * [chatgpt-voice](https://github.com/sonngdev/chatgpt-voice) - ChatGPTと会話をしてください。カジュアルに 🔈 🤖 ⚡️
 * [Open-LLaVA-NeXT](https://github.com/xiaoachen98/open-llava-next) - LLaVA-NeXTのトレーニングのためのオープンソース実装。
 * [langchain-chatbot](https://github.com/shashankdeshpande/langchain-chatbot) - LangchainとStreamlitを使用したチャットボットの実装例
 * [OpsPilot](https://github.com/weops-lab/opspilot) - OpsPilotは、WeOpsチームによって開発された深層学習とLLM技術に基づくオープンソースのインテリジェントな運用および保守アシスタントです。OpsPilotはWeOpsチームによって開発されたオープンソースの深層学習とLLM技術に基づく運用および保守アシスタントです。
 * [whatsapp-ai-bot](https://github.com/zain-ul-din/whatsapp-ai-bot) - これは、Gemini、GPT、DALL-E、Flux、StabilityAIなどさまざまなAIモデルを使用して、ユーザーの入力に応じた応答を生成するWhatsApp AIボットです。
 * [AI-in-a-Box](https://github.com/azure/ai-in-a-box) - AI-in-a-Boxは、世界中のマイクロソフトの専門知識を活用して、技術コミュニティにAIおよびMLソリューションを開発・提供します。私たちの目的は、エンジニアがAI/MLを確立するのに役立つソリューションアクセラレータのキュレーションされたコレクションを提供することです。
 * [Starmoon](https://github.com/starmoonai/starmoon) - オープンソースの音声認識可能でコンパクトで共感的なAIハードウェア＋ソフトウェア🤖フレームワーク。仲間、エンターテイメント、教育、小児医療、IoTロボティクスアプリケーション、AI強化ロボティクスアプリケーションサービス、研究、DIYロボティクスキット開発に使用可能。
 * [LocalAI](https://github.com/mudler/localai) - 入力: :robot: OpenAI、Claudeなどの無料でオープンソースの代替品。セルフホストおよびローカルファースト。消費者向けのハードウェアで実行されるOpenAIの代替品。GPUは必要ありません。gguf、transformers、diffusersなど、多くのモデルアーキテクチャを実行します。
 * [bisheng](https://github.com/dataelement/bisheng) - BISHENGは次世代のエンタープライズAIアプリケーション向けのオープンLLM DevOpsプラットフォームです。GenAIワークフロー、RAG、エージェント、統合モデル管理、評価、SFT、データセット管理、エンタープライズレベルのシステム管理など、強力で包括的な機能が含まれています。
 * [agency-swarm](https://github.com/vrsen/agency-swarm) - 最新のOpenAI Assistants APIをベースに構築された唯一信頼できるエージェントフレームワーク。
 * [ragflow](https://github.com/infiniflow/ragflow) - RAGFlowは、深い文書理解に基づいたオープンソースのRAG（Retrieval-Augmented Generation）エンジンです。
 * [LlamaIndexTS](https://github.com/run-llama/llamaindexts) - LLMアプリケーション用のデータフレームワーク。サーバーサイドソリューションに焦点を当てる。
 * [repomix](https://github.com/yamadashy/repomix) - 📦 Repomix（以前はRepopackとして知られていました）は、リポジトリ全体を1つの、AIにとってフレンドリーなファイルにパックする強力なツールです。Large Language Models（LLMs）やClaude、ChatGPT、Geminiなどの他のAIツールにコードベースを供給する必要があるときに最適です。
 * [LangBot](https://github.com/rockchinq/langbot) - 元の名前はQChatGPTです。😎高い安定性、🧩拡張機能のサポート、🦄マルチモーダルなChatGPT QQ / QQチャンネル / One Botロボット🤖 | OpenAI GPT、Claude、Gemini Pro、DeepSeek、Moonshot（Kimi）、gpt4free、One API、Ollama、difyのQQ / QQチャンネル / OneBotロボット / Agentプラットフォームをサポート
 * [open-im-server](https://github.com/openimsdk/open-im-server) - IMチャットChatGPTIMチャットChatGPT
 * [aws-genai-llm-chatbot](https://github.com/aws-samples/aws-genai-llm-chatbot) - AWS CDKを使用して、Amazon Bedrock、Anthropic、HuggingFace、OpenAI、Meta、AI21、Cohere、Mistralを活用したMulti-LLMおよびMulti-RAG搭載のチャットボットを展開するためのモジュラーで包括的なソリューション。
 * [podcastfy](https://github.com/souzatharsis/podcastfy) - NotebookLMのポッドキャスト機能のオープンソースPython代替品：GenAIを使用して、多言語オーディオ会話に変換する魅力的なマルチモーダルコンテンツ
 * [multi-agent-orchestrator](https://github.com/awslabs/multi-agent-orchestrator) - 複数のAIエージェントを管理し、複雑な会話を処理するための柔軟で強力なフレームワーク


## Browser-extensions

 * [chat-gpt-google-extension](https://github.com/wong2/chat-gpt-google-extension) - 無料の3DSプライマリエントリーポイント<=11.2
 * [chatgpt-retrieval-plugin](https://github.com/openai/chatgpt-retrieval-plugin) - ChatGPT検索プラグインを使用すると、日常的な言葉で質問することで、個人や仕事の文書を簡単に検索して見つけることができます。
 * [Gepetto](https://github.com/justicerage/gepetto) - 逆アセンブルを高速化するためにOpenAIのgpt-3.5-turbo言語モデルをクエリするIDAプラグイン
 * [google-chatgpt-plugin](https://github.com/sogody/google-chatgpt-plugin) - @ykdojo すごい！すでにGoogle Chat GPTプラグインもあるんだって 🤯
 * [natbot](https://github.com/nat/natbot) - GPT-3を使用してブラウザを操作する。
 * [DAILA](https://github.com/mahaloz/daila) - OpenAI APIにアクセスするためのデコンパイラ統合プラグインで、デコンパイル体験を向上させます。
 * [regexplore](https://github.com/0xhasanm/regexplore) - Regexploreは、EZsuiteのRegistry Explorerプラグインの機能を模倣するように設計されたVolatilityプラグインです。
 * [chat-todo-plugin](https://github.com/lencx/chat-todo-plugin) - ✅ TODOリストを管理するためのChatGPTプラグイン
 * [textual](https://github.com/textualize/textual) - テキストは、Pythonのための高速アプリケーション開発フレームワークです。シンプルなPython APIで洗練されたユーザーインターフェースを構築してください。アプリをターミナルで実行し、（近日公開予定の）Webブラウザでも実行できます！
 * [ReconAIzer](https://github.com/hisxo/reconaizer) - Burp Suiteの拡張機能であるOpenAI（GPT）を追加し、Bug Bountyの調査に役立ち、エンドポイント、パラメータ、URL、サブドメインなどを発見するための支援をします！
 * [Agent-LLM](https://github.com/josh-xt/agent-llm) - 人工知能自動化プラットフォーム。様々なプロバイダーからのAI指示管理、適応的なメモリ、Webブラウジングを含む多機能プラグインシステムを備えています。多くのAIプロバイダーとモデルをサポートし、毎日サポートが拡大しています。
 * [web-llm](https://github.com/mlc-ai/web-llm) - 大規模言語モデルとチャットをWebブラウザに持ち込む。すべての処理はサーバーのサポートなしでブラウザ内で実行されます。
 * [langchain-aiplugin](https://github.com/langchain-ai/langchain-aiplugin) - 「langchainをAIプラグインとして使用することは、超クールです。@hwchase17 @langchainai これにより、#chatgptにスーパーパワーが与えられ、langchainのコンポーネント（エージェント、チェーンなど）を簡単にプラグインとして使用できます。このリポジトリはすぐにスケールアップします。例：プラグインとしてのretrievalqaチェーン」
 * [plugins-quickstart](https://github.com/openai/plugins-quickstart) - 5分以内にChatGPTプラグインを起動してください！
 * [dangermode](https://github.com/rgbkrk/dangermode) - DangermodeはPythonとFastAPIで書かれたChatGPTプラグインで、ChatGPTがIPythonセッションでコードスニペットを実行できるようにします。
 * [examples](https://github.com/pinecone-io/examples) - もしChatGPTプラグインの開発に興味がある場合は、このビデオを見ることをお勧めします。以下の内容が完全に紹介されています：1. ChatGPTプラグインとは何か2. Langchainドキュメント検索用ChatGPTプラグインの開発方法3. ChatGPTプラグインのインストールとデバッグ方法。ビデオ：
 * [chat-gpt-jupyter-extension](https://github.com/jflam/chat-gpt-jupyter-extension) - ローカルのJupyterノートブックからChatGPTとチャットできるブラウザ拡張機能。
 * [web-stable-diffusion](https://github.com/mlc-ai/web-stable-diffusion) - 安定した拡散モデルをWebブラウザに持ち込む。すべての処理はサーバーのサポートなしでブラウザ内で実行されます。
 * [ipython-gpt](https://github.com/santiagobasulto/ipython-gpt) - ipython-gptは、jupyter/ipythonインターフェースを介してchatgptとチャットするための非常に有望な拡張機能です。あなたのjupyterノートブックやipythonシェルから直接chatgptとチャットすることができます。
 * [tweetGPT](https://github.com/yaroslav-n/tweetgpt) - TweetGPTは、chatGPTを使用してツイートや返信を生成するChrome拡張機能です。
 * [ChatGPT-pdf](https://github.com/liady/chatgpt-pdf) - ChatGPTの履歴をPNG、PDF、または共有可能なリンクにダウンロードするためのChrome拡張機能
 * [chatgpt-chrome-extension](https://github.com/gragland/chatgpt-chrome-extension) - ChatGPTのChrome拡張機能。インターネット上のすべてのテキストボックスにChatGPTを統合します。
 * [summarize.site](https://github.com/clmnin/summarize.site) - OpenAI ChatGPTを使用してウェブページを要約する。
 * [transformers.js](https://github.com/xenova/transformers.js) - ブラウザで🤗トランスフォーマーを実行してください！
 * [bob-plugin-openai-translator](https://github.com/yetone/bob-plugin-openai-translator) - ChatGPT APIをベースにしたテキスト翻訳、テキスト修正、文法修正のBobプラグインで、バベルの塔が必要ない新しい時代を一緒に迎えましょう！
 * [chatgpt-extension](https://github.com/iolivernguyen/chatgpt-extension) - 最小限のrequire.jsはCommonJSを実装しています。
 * [docGPT](https://github.com/cesarhuret/docgpt) - Googleドキュメント内で直接ChatGPTをエディターのアドオンとして使用できます📑
 * [ChatGPT-Assistant](https://github.com/pdparchitect/chatgpt-assistant) - 「chatgptを使えば、手動での拡張機能開発にさようなら！私はこの拡張機能をchatgptで自動的に作成しました。#openai #openaichat」
 * [chatGPTBox](https://github.com/josstorer/chatgptbox) - ChatGPTをブラウザに深く統合することで、必要なすべてがここにあります。
 * [YouTube_Summary_with_ChatGPT](https://github.com/kazuki-sf/youtube_summary_with_chatgpt) - ChatGPTを使用したYouTubeサマリーは、YouTubeビデオのトランスクリプトとOpenAIのChatGPT AI技術を使用したビデオのサマリーを両方取得できるシンプルなChrome拡張機能（マニフェストv3）です。
 * [simpread](https://github.com/kenshin/simpread) - SimpRead（简悦）- あなたを瞬時に没頭型読書体験に導く拡張機能
 * [chatgpt-wechat-landing-page](https://github.com/1cloudy/chatgpt-wechat-landing-page) - ChatGPTを介して、WeChatのプライベートメッセージやグループチャットで@されたメッセージに自動応答するChromeブラウザの拡張機能によるスマートチャットボット。
 * [WebGPT](https://github.com/0hq/webgpt) - ブラウザ上でWebGPUを使用してGPTモデルを実行します。バニラJavaScriptの約2000行未満でのGPT推論の実装。
 * [tabSidian](https://github.com/cgranier/tabsidian) - tabSidianは、あなたの開いているブラウザータブを収集し、それらをマークダウンリストに変換します。
 * [chatgpt-advanced](https://github.com/qunash/chatgpt-advanced) - WebChatGPT：Web結果を含めたChatGPTのプロンプトを拡張するブラウザ拡張機能。
 * [chatgpt-vscode](https://github.com/mpociot/chatgpt-vscode) - ChatGPTを使用できるようにするVSCode拡張機能
 * [openai-translator](https://github.com/yetone/openai-translator) - ChatGPT APIをベースにした翻訳のためのブラウザ拡張機能とクロスプラットフォームのデスクトップアプリケーション。
 * [obsidian-textgenerator-plugin](https://github.com/nhaouari/obsidian-textgenerator-plugin) - テキストジェネレーターは、Obsidianの便利なプラグインであり、GPT-3（OpenAI）を使用してテキストコンテンツを生成するのに役立ちます。
 * [logseq-plugin-gpt3-openai](https://github.com/briansunter/logseq-plugin-gpt3-openai) - LogseqでGPT-3 AI支援のノート取りプラグイン
 * [chatgpt-arxiv-extension](https://github.com/hunkimforks/chatgpt-arxiv-extension) - ChatGPTを搭載した検索エンジンを強化するブラウザ拡張機能
 * [chatgpt-google-extension](https://github.com/wong2/chatgpt-google-extension) - ChatGPTを搭載した検索エンジンを強化するブラウザ拡張機能
 * [nextjs-chatgpt-app](https://github.com/enricoros/nextjs-chatgpt-app) - 💬 OpenAIのGPT-4を搭載したレスポンシブチャットアプリケーションで、レスポンスストリーミング、コードハイライト、開発者向けのさまざまなプリセットを備えています。Next.js、React、Joyを使用しています。
 * [sharegpt](https://github.com/domeccleston/sharegpt) - 簡単にChatGPTの会話の永久リンクを友達と共有できます。
 * [chatgpt-raycast](https://github.com/abielzulio/chatgpt-raycast) - ChatGPTレイキャスト拡張機能
 * [GPT-Toolbox](https://github.com/cedricguillemet/gpt-toolbox) - VSCode用のGPT拡張機能
 * [CodeCursor](https://github.com/helixform/codecursor) - Visual Studio Codeでカーソルを使用するための拡張機能。
 * [butler.vim](https://github.com/lambdalisue/butler.vim) - 🫖 あなたの執事。Vim/NeovimプラグインのようなChatGPTで、OpenAI APIと通信するものです。
 * [AgentGPT](https://github.com/reworkd/agentgpt) - 🤖 ブラウザで自律型AIエージェントを組み立て、設定、展開してください。
 * [gpt-assistant](https://github.com/builderio/gpt-assistant) - ブラウザへのアクセスを持つ自律型GPTエージェントにタスクを達成させる実験
 * [AutoGPT-Next-Web](https://github.com/dogtiti/autogpt-next-web) - 🤖 ブラウザで自律型AIエージェントを組み立て、設定、展開してください。私人AutoGPTウェブアプリを簡単にデプロイできます。
 * [chatgpt-plugin-ts](https://github.com/transitive-bullshit/chatgpt-plugin-ts) - JS/TSでChatGPTプラグインを構築するために必要なすべてが揃っています🔥
 * [whisper_ros](https://github.com/ouxt-polaris/whisper_ros) - whisper_ros://t.co/rqb3qulyyospeak_ros_voicevox_plugin、ros2があれば音声対話システムが作れますね（vad未実装なので音声認識精度はガバガバですが
 * [pg_gpt](https://github.com/cloudquery/pg_gpt) - 人間の言葉でクエリを実行するために、OpenAI APIをあなたのPostgreSQLにもたらす実験的な拡張機能。
 * [kubectl-ai](https://github.com/sozercan/kubectl-ai) - ✨ OpenAI GPTのためのKubectlプラグイン
 * [ChatGPT_Extension](https://github.com/kazuki-sf/chatgpt_extension) - ChatGPT拡張機能は、Web上のどこからでもOpenAIのChatGPTにアクセスできる非常にシンプルなChrome拡張機能（マニフェストv3）です。
 * [ChatGPT](https://github.com/wieslawsoltes/chatgpt) - Avalonia UIフレームワークを搭載したMacOS、Windows、Linux、Android、iOS、ブラウザ向けのChatGPT C#クライアント。
 * [CodeGPT.nvim](https://github.com/dpayne/codegpt.nvim) - CodeGPTは、ChatGPTとやり取りするためのコマンドを提供するneovimのプラグインです。
 * [ChatGPT.nvim](https://github.com/jackmort/chatgpt.nvim) - OpenAI GPT-3チャットボットとやり取りするためのNeovimプラグインで、GPT-3とNLPを探索するための簡単なインターフェースを提供します。
 * [mind-wave](https://github.com/manateelazycat/mind-wave) - ChatGPT APIに基づくEmacs AIプラグイン
 * [askgpt.vim](https://github.com/macrat/askgpt.vim) - Vimのプラグインで、ChatGPTを組み込んでコードに関する質問ができるようになります。
 * [ChatGPT-Plugins-Collection](https://github.com/logankilpatrick/chatgpt-plugins-collection) - ChatGPTの非公式プラグインのコレクション、どんなプログラミング言語でも対応しています！
 * [burpgpt](https://github.com/aress31/burpgpt) - OpenAIのGPTを統合したBurp Suiteの拡張機能で、高度に特殊化された脆弱性を発見するための追加のパッシブスキャンを実行し、任意のタイプのトラフィックベースの分析を実行できるようにします。
 * [openai-chatgpt-everywhere-extension](https://github.com/1997roylee/openai-chatgpt-everywhere-extension) - サンプルCSVファイル
 * [awesome-chatgpt-plugins](https://github.com/imaurer/awesome-chatgpt-plugins) - ChatGPTプラグインの構築と使用に役立つ興味深いリソースのリスト。
 * [Chrome-GPT](https://github.com/richardyc/chrome-gpt) - デスクトップ上のChromeを制御するAutoGPTエージェント
 * [Auto-GPT-MetaTrader-Plugin](https://github.com/isaiahbjork/auto-gpt-metatrader-plugin) - AutoGPT MetaTraderプラグインは、トレーダーがMetaTrader 4または5の取引口座をAuto-GPTに接続できるようにするソフトウェアツールです。
 * [Auto-GPT-Plugins](https://github.com/significant-gravitas/auto-gpt-plugins) - Auto-GPT用のプラグイン
 * [nextjs-chatgpt-plugin-starter](https://github.com/dabit3/nextjs-chatgpt-plugin-starter) - Next.jsを使用したChatGPTプラグインのスタータープロジェクト
 * [sftly-replace](https://github.com/kmizu/sftly-replace) - 選択したテキストをやさしく置き換えるためのChrome拡張機能
 * [chatgpt-plugin](https://github.com/solana-labs/chatgpt-plugin) - 🧬@Solanalabsは、ChatGPTプラグインのオープンソースのリファレンス実装を開発しました。🧬 #ChatGPTプラグインの利用により、#Solanaユーザーはウォレットの残高を確認し、トークンを送信し、NFTを取得することができます。🔽INFO
 * [bmtools](https://github.com/openbmb/bmtools) - BMTools：大規模モデルのツール学習、ChatGPT-Pluginsのオープンソースソリューションをサポートし、BabyAGIとAuto-GPTgithubをサポートしています。
 * [pake](https://github.com/tw93/pake#popular-packages) - 900MonthのChrome拡張機能はAngularJSで構築されています。
 * [CopilotForXcode](https://github.com/intitni/copilotforxcode) - GitHub CopilotとChatGPTのXcodeソースエディタ拡張機能が見つかりません。
 * [gpt-terminal-plugin](https://github.com/etherlegend/gpt-terminal-plugin) - ChatGPTのための汎用コマンドラインプラグイン
 * [smartgpt](https://github.com/cormanz/smartgpt) - LLMがプラグインを使用して複雑なタスクを完了する能力を提供するプログラム。
 * [chatgpt-plugin](https://github.com/cloudflare/chatgpt-plugin) - Cloudflareの開発者プラットフォームを使用してChatGPTプラグインを構築する 🤖
 * [QGPTAgent](https://github.com/momaabna/qgptagent) - QGPTエージェントは、OpenAI GPTモデルの高度な自然言語処理機能を活用して、QGISでさまざまなプロセスを自動化する強力なプラグインです。このプラグインを使用すると、ユーザーは自然言語コマンドを使用してQGISソフトウェアとやり取りでき、さまざまなタスクを完了するために必要な時間と労力を大幅に削減できます。
 * [dify](https://github.com/langgenius/dify) - プラグインとデータセットのための1つのAPI、プロンプトエンジニアリングとビジュアル操作のための1つのインターフェース、すべてが強力なAIアプリケーションを作成するためにあります。
 * [chatgpt-retrieval-plugin](https://github.com/openai/chatgpt-retrieval-plugin#supabase) - ChatGPT検索プラグインを使用すると、自然言語で質問することで、個人または仕事の文書を簡単に見つけることができます。
 * [GameDealGenie-ChatGPT-Plugin](https://github.com/cyrisxd/gamedealgenie-chatgpt-plugin) - 複数のストアからPCゲームの最新情報を取得するChatGPTプラグイン。Cheapsharkによって提供されます。
 * [openai-plugin-fastapi](https://github.com/azure-samples/openai-plugin-fastapi) - Scott Guthrie氏の基調講演で紹介されたOpenAIプラグインのサンプルコード、ChatGPT Plugin Quickstart using Python and FastAPI #MSBuild です。
 * [ChatGPT-Plugins-Searchable](https://github.com/banbri/chatgpt-plugins-searchable) - あなたのChatGPTプラグインストアを検索可能にしてください。https://greasyfork.org/scripts/466901-chatgpt-plugins-searchable
 * [chat-ai-plugin](https://github.com/personoids/chat-ai-plugin) - 「チャットにおける自律性の力。」- ChatGPTを強力な自律エージェントに変換し、複雑なタスクを独立して達成できるようにします。
 * [github-chatGPT-plugin](https://github.com/jesserweigel/github-chatgpt-plugin) - GitHubにアクセスするためのChatGPTプラグイン。
 * [chatgpt-code-plugin](https://github.com/kesor/chatgpt-code-plugin) - Code ChatGPTプラグインは、ChatGPTがあなたのコードと「話す」ことを可能にするTypeScriptコードアナライザーです。
 * [Auto-GPT-Crypto-Plugin](https://github.com/isaiahbjork/auto-gpt-crypto-plugin) - AutoGPT Cryptoプラグインは、トレーダーが自分の暗号通貨ウォレットまたは取引所をAuto-GPTに接続できるようにするソフトウェアツールです。
 * [ChatGPT-Developer-Plugins](https://github.com/samuraigpt/chatgpt-developer-plugins) - プラスサブスクリプションにアクセスせずに、無料でChatGPTプラグインを実行する。
 * [chatgpt-simple-todo-plugin](https://github.com/yoshinorisano/chatgpt-simple-todo-plugin) - この最小限のコードと手順で、ChatGPTプラグインの開発を始めることができます。これは、最初のプラグイン開発の例として完璧です。
 * [codeexplain.nvim](https://github.com/mthbernardes/codeexplain.nvim) - リアルタイムのコード説明と脆弱性検出のためのGPT4ALLによるnvimプラグイン（インターネット不要）
 * [chatgpt-export](https://github.com/yaph/chatgpt-export) - ChatGPTの会話をマークダウンファイルとしてエクスポートするためのブラウザブックマークレット。
 * [logseq-chatgpt-plugin](https://github.com/debanjandhar12/logseq-chatgpt-plugin) - Logseq用の密接に統合されたChatGPTプラグイン。
 * [autogpt-package](https://github.com/kurtosis-tech/autogpt-package) - それはまるでAuto-GPTがBrewと出会ったようです。あなたが選ぶバックエンドと必要なプラグインを使って、AutoGPTを始めるための最も簡単で最速の方法です。
 * [PowerToys4OpenAI](https://github.com/robert-hoffmann/powertoys4openai) - Chrome、Edge、Opera用のGPTチャット拡張機能。検索結果との直接統合。履歴管理付きの完全なチャットインターフェース。サーバー不要でコスト効果的。
 * [napari-chatgpt](https://github.com/royerlab/napari-chatgpt) - チャットGPTを使用して画像を処理および分析するためのnapariプラグイン！
 * [kaguya](https://github.com/ykdojo/kaguya) - 制御された方法でローカルファイルを読み込み、編集し、Python、JavaScript、およびbashスクリプトを実行できるChatGPTプラグイン。
 * [duckduckgpt](https://github.com/kudoai/duckduckgpt) - 🐤 DuckDuckGoのアドオンは、検索結果にChatGPTの魔法をもたらします（GPT-4によってパワーアップ！）
 * [bravegpt](https://github.com/kudoai/bravegpt) - 🦁 ブレイブサーチアドオンは、検索結果にChatGPTの魔法をもたらします（GPT-4によってパワーアップ！）
 * [listennotes-chatgpt-plugin](https://github.com/listennotes/listennotes-chatgpt-plugin) - AIパワードポッドキャスト検索のためのListen Notes ChatGPTプラグイン。PodcastAPI.comとCloudflare Pagesによって提供されています。
 * [chatgpt-github-plugin](https://github.com/carlos-lugo/chatgpt-github-plugin) - このリポジトリには、ChatGPTとGitHub APIとの連携を可能にするプラグインが含まれています。GitHubのリポジトリに関する情報を取得することができます。具体的には、リポジトリの一覧、ブランチやファイルの情報、特定のファイルの内容などを取得することができます。
 * [chatgpt-plugin-clerk-auth](https://github.com/eidam/chatgpt-plugin-clerk-auth) - Cloudflare WorkersとClerk OAuth2バックエンドを使用したChatGPTプラグインの例。
 * [vscode-i-dont-care-about-commit-message](https://github.com/mefengl/vscode-i-dont-care-about-commit-message) - もう一つのAI gitコミットプラグインですが、手動確認の必要はありません。
 * [openai-translator](https://github.com/openai-translator/openai-translator) - ChatGPT APIに基づく翻訳のためのブラウザ拡張機能とクロスプラットフォームのデスクトップアプリケーション。
 * [ais-ninja](https://github.com/jarvis2f/ais-ninja) - プラグインをサポートするChatGPTです。TG: https://t.me/+bIZncGryj_85MjYx
 * [openplugin](https://github.com/cakecrusher/openplugin) - API（またはクライアント）を介してOpenAIのChatGPTプラグインとシームレスに統合し、ChatGPT API + プラグインと同じ強力な機能を提供します！
 * [continue](https://github.com/continuedev/continue) - ソフトウェア開発のためのオープンソースの自動操縦システム-ChatGPTのパワーをあなたのIDEにもたらすVS Code拡張機能
 * [GPT-Plugins](https://github.com/targed/gpt-plugins) - GPT-Pluginsは、ChatGPTやGPTアーキテクチャと互換性のある他の言語モデルのプラグイン、アドオン、拡張機能の包括的なリストとして機能するGitHubリポジトリです。
 * [web5-chatgpt-plugin](https://github.com/tbd54566975/web5-chatgpt-plugin) - ChatGPTにWeb5コードのサポートと知識を追加するChatGPTプラグイン
 * [chatgpt-plugin](https://github.com/e2b-dev/chatgpt-plugin) - ChatGPTのためのステロイド入りコードインタプリタ。どんな言語でも実行し、どんなターミナルプロセスでも実行し、自由にファイルシステムを使用できます。すべてインターネットにアクセスできます。
 * [awesome-chatgpt-plugins](https://github.com/highwayoflife/awesome-chatgpt-plugins) - ChatGPT plus内で利用可能なChatGPTプラグインの厳選リスト。詳細な説明と使用方法のドキュメント、非公式なプラグインの情報も含まれています。
 * [meeper](https://github.com/pas1ko/meeper) - Meeper 📝 - ブラウザ内のどんなオンライン会議でもあなたの秘書です。
 * [codesherpa](https://github.com/iamgreggarcia/codesherpa) - コードインタプリターとChatGPTプラグイン
 * [ethgpt](https://github.com/xinbenlv/ethgpt) - EthereumおよびEVM dApp /スマートコントラクト機能のためのChatGPTプラグイン
 * [GodMode](https://github.com/smol-ai/godmode) - AIチャットブラウザ：ChatGPT / Claude / Bard / Bing / Llama2への高速で完全なウェブアプリアクセス！私はこれを1日に20回使用しています。
 * [Image-To-Text-OCR-extension-for-ChatGPT](https://github.com/tshetrim/image-to-text-ocr-extension-for-chatgpt) - ChatGPT用の画像からテキストへの変換（OCR）Chrome拡張機能
 * [search-recommendations](https://github.com/niemingxing/search-recommendations) - 検索推奨語収集とコンテンツ生成アシスタントは、小紅書、TikTok、Bilibili、知乎、百度、Googleのユーザー向けに設計された強力なChrome拡張機能です。この拡張機能は、これらのプラットフォームの検索推奨語や関連語を自動的に収集し表示し、CSVファイルとして保存してダウンロードすることができます。興味のあるコンテンツを検索、閲覧、発見するのをサポートします。また、chatgptを利用して、自動化された大量のコンテンツを生成し、WordPressサイトに投稿することもできます。
 * [openai.mini](https://github.com/llmapp/openai.mini) - OpenAIのAPIとプラグイン対応のChatGPTをオープンソースのLLMや他のモデルと統合する。OpenAIのAPIを実装し、オープンソースのLLMや他のモデルと連携可能なChatGPTを作成します。
 * [openplugin](https://github.com/openpluginaci/openplugin) - API（またはクライアント）を介してOpenAIのChatGPTプラグインとシームレスに統合し、ChatGPT API + プラグインと同じ強力な機能を提供します！
 * [chatgpt-desktop](https://github.com/inplex-sys/chatgpt-desktop) - AIPRMを含むWindowsのChatGPT（Firefoxにインストールできない人向け）
 * [superpower-chatgpt](https://github.com/saeedezzati/superpower-chatgpt) - 超能力を持ったChatGPT！チャット履歴の検索、フォルダの作成、すべてのチャットのエクスポート、メッセージのピン留め、数千のコミュニティプロンプトへのアクセス、インコグニートモード、言語とトーンの選択、さらに多くの機能があります。
 * [show-me-chatgpt-plugin](https://github.com/bra1ndump/show-me-chatgpt-plugin) - ChatGPTで図を作成および編集する
 * [ChatGPT-Plugins](https://github.com/serp-ai/chatgpt-plugins) - ChatGPTにウェブブラウジング、Pythonコードの実行、およびカスタムプラグインの機能を与えるためのリポジトリウェブブラウジング、Pythonコードの実行、およびカスタムプラグインの機能をChatGPTに与えるためのリポジトリ
 * [ChatIDE](https://github.com/yagil/chatide) - あなたのIDEでのAIコーディングアシスタント - ChatGPT（OpenAI）とClaude（Anthropic）を使用したVSCode拡張機能。
 * [vim-chatgpt](https://github.com/codercooke/vim-chatgpt) - ChatGPTのためのVimプラグイン
 * [obsidian-weaver](https://github.com/vasilecampeanu/obsidian-weaver) - WeaverはObsidianのプラグインであり、ChatGPT/GPT-3をノート作成のワークフローに統合することができます。このプラグインは、Obsidian内でAIによる提案や洞察を簡単に利用できるようにし、執筆やブレインストーミングのプロセスを改善するのに役立ちます。
 * [chatgpt-plugins](https://github.com/copilot-us/chatgpt-plugins) - 公式のChatGPTプラグイン🧩
 * [auto-chatgpt](https://github.com/ryuseisan/auto-chatgpt) - ブラウザ版ChatGPTとの対話を自動化します。
 * [chatlab](https://github.com/rgbkrk/chatlab) - ノートブックにChatGPTプラグインを導入する
 * [paperchat](https://github.com/forward-operators/paperchat) - PaperChat - arXivのデータセットをクエリするためのcli、API、およびChatGPTプラグイン
 * [chatgpt-microphone](https://github.com/davidmvenegas/chatgpt-microphone) - ChatGPTに音声テキスト変換とショートカットスニペットを追加してください。
 * [github-chatgpt-plugin](https://github.com/aavetis/github-chatgpt-plugin) - GitHubで何でも対話するためのChatGPTプラグイン。ChatGPTプラグインストアから「Chat With Code」をインストールしてください。
 * [eclipse-chatgpt-plugin](https://github.com/gradusnikov/eclipse-chatgpt-plugin) - ChatGPTと統合されたEclipseのプラグイン
 * [automatic-chatgpt-dan](https://github.com/madkarmaa/automatic-chatgpt-dan) - ブラウザのユーザースクリプトで、ChatGPTに自動的にDANメッセージを送信する。
 * [sk-nl2ef-plugin](https://github.com/anthonypuppo/sk-nl2ef-plugin) - 自然言語でデータベースにクエリを送信するSemantic Kernelを使用したChatGPTプラグイン。Microsoftの最初のSemantic Kernelハッカソンで、「企業にとって最も有用」というカテゴリーで優勝しました。
 * [Awesome-Plugins](https://github.com/targed/awesome-plugins) - Awesome-Pluginsは、ChatGPTに対応したプラグイン、アドオン、拡張機能の包括的なリストとして機能するGitHubリポジトリです。また、GPTアーキテクチャに対応した他の言語モデルにも対応しています。Awesome-Pluginsは、ChatGPTに対応したプラグイン、アドオン、および拡張機能の包括的なリストであり、GPTアーキテクチャと互換性のある他の言語モデルにも対応しているGitHubリポジトリです。
 * [Free-personal-AI-Assistant-with-plugin](https://github.com/intelligenzaartificiale/free-personal-ai-assistant-with-plugin) - 🤗 GPT4とプラグインを使用したいですかが、月額$20を支払いたくありませんか？ これが解決策です！ このリポジトリを使用すると、プラグイン付きの無料のChatGPTのクローンを利用できます。
 * [LeanDojoChatGPT](https://github.com/lean-dojo/leandojochatgpt) - Leanでの定理証明のためのChatGPTプラグイン
 * [awesome-chatgpt-plugins](https://github.com/jikkujose/awesome-chatgpt-plugins) - 一つのページにまとめられた、最も包括的なChatGPTプラグインのリスト！
 * [gp.nvim](https://github.com/robitx/gp.nvim) - GPT.nvim：Neovim AIプラグイン〜OpenAIのChatGPT＆Copilot＆音声テキストGPT.nvim：Neovim AIプラグイン〜OpenAIのChatGPT＆Copilot＆音声テキスト
 * [LLMBot](https://github.com/llmkira/llmbot) - 插件概念原型机 /// Agents System/自己決定 |クラスChatGptプラグインシステム| Gpt-3.5/Gpt-4 |アシスタント |📱クロスプラットフォーム|🦾非同期|🔌プラグインシステム
 * [bob-plugin-openai-translator](https://github.com/openai-translator/bob-plugin-openai-translator) - ChatGPT APIに基づくテキスト翻訳、テキストの改善、文法修正のBobプラグインで、バベルの塔を必要としない新しい時代を一緒に迎えましょう！CC BY-NC-SA 4.0のライセンスに基づいています。
 * [Openaibot](https://github.com/llmkira/openaibot) - ⚡️ 自分自身のアシスタントボットを構築する|🧀 Discord/Slack/Kook/Telegram |🍓 ChatGptアーキテクチャの複製 |⛓ ToolCall/FunctionCall|🔖 プラグインサポート | 🌻 sh & docker-compose
 * [LibreChat](https://github.com/danny-avila/librechat) - 強化されたChatGPTクローン：OpenAI、Bing、Anthropic、OpenRouter、PaLM 2、AIモデルの切り替え、メッセージ検索、langchain、DALL-E-3、ChatGPTプラグイン、OpenAI関数、セキュアなマルチユーザーシステム、プリセット、自己ホスティング用の完全なオープンソースなどの機能があります。開発中のさらなる機能もあります。
 * [pgvecto.rs](https://github.com/tensorchord/pgvecto.rs) - Rustで書かれたPostgres用のスケーラブルなベクターデータベースプラグイン、特にLLM向けに設計されています。
 * [AI-Prompt-Genius](https://github.com/benf2004/ai-prompt-genius) - AIプロンプトのカスタムライブラリを作成してください。
 * [Ebook-Translator-Calibre-Plugin](https://github.com/bookfere/ebook-translator-calibre-plugin) - 指定された言語に電子書籍を翻訳するためのCalibreプラグイン。
 * [WPeChatGPT](https://github.com/wpeace-hch/wpechatgpt) - IDAのプラグインは、バイナリファイルの解析を支援するものであり、OpenAIによって訓練されたgpt-3.5-turboモデルに基づいています。ChatGPTと同じモデルです。
 * [chatgpt-plugin](https://github.com/ikechan8370/chatgpt-plugin) - 云崽qq机器人的chatgpt插件云崽qqボットのchatgptプラグイン
 * [chatgpt-google-summary-extension](https://github.com/sparticleinc/chatgpt-google-summary-extension) - Googleの検索結果やYouTubeの動画と一緒にChatGPTの要約を表示するためのChrome拡張機能です。また、Yahoo! ニュース、PubMed、PMC、NewsPicks、Github、日経、Bing、Google特許など、どんなページの要約にも対応しています。
 * [CodeGPT](https://github.com/carlrobertoh/codegpt) - JetBrainsの拡張機能は、GPT-4、Code Llamaなどの最新のLLMに無料でアクセスできます。
 * [ReadSomething](https://github.com/readsomething/readsomething) - 📖 オープンソースのChrome拡張機能で、ウェブページを読みやすいモードに変換し、AIによる要約、翻訳、Markdown変換などの機能が組み込まれています。
 * [writely](https://github.com/anc95/writely) - ❤️‍🔥 Notion AI を超える選択肢としての Chrome 拡張機能。 | Notion AI に限らず、さらに進化した浏览器拡張機能。
 * [CoDeveloperGPTengine](https://github.com/stoerr/codevelopergptengine) - 共同開発者GPTエンジン：開発者向けのChatGPTプラグインを作成し、ファイルの読み取り/検索/書き込み、実行（ビルド）アクションを可能にします。
 * [neoai.nvim](https://github.com/bryley/neoai.nvim) - OpenAIのGPTモデルとのやり取りを行うためのNeovimプラグイン
 * [nonebot_plugin_naturel_gpt](https://github.com/kromiose/nonebot_plugin_naturel_gpt) - NoneBotフレームワークをベースにしたAIチャットプラグインで、OpenAiテキスト生成APIと連携して、ロボットのパーソナリティのカスタマイズ/切り替え、チャットの記憶などの機能を実現しています。
 * [vim-ai](https://github.com/madox2/vim-ai) - Vim用のAIパワードコードアシスタント。VimとNeovim用のOpenAIとChatGPTプラグイン。
 * [AI-Employe](https://github.com/vignshwarar/ai-employe) - GPT-4 Visionを使用して人間に教えているかのようにブラウザ自動化を作成します。
 * [raycast-openai-translator](https://github.com/openai-translator/raycast-openai-translator) - ChatGPT APIに基づいたRaycast翻訳プラグイン - ChatGPT APIに基づいたRaycast翻訳拡張機能。
 * [AI-Prompt-Genius](https://github.com/ai-prompt-genius/ai-prompt-genius) - AIプロンプトのカスタムライブラリをキュレーションする
 * [supermemory](https://github.com/dhravya/supermemory) - スーパーメモリを使って自分だけの第二の脳を構築しましょう。それはあなたのブックマーク用のChatGPTです。ツイートをインポートしたり、Chrome拡張機能を使ってウェブサイトやコンテンツを保存できます。
 * [OpenCharacters](https://github.com/josephrocca/opencharacters) - シンプルなウェブインターフェースでキャラクターを作成し、それらとチャットするためのものです。基本的には単一のHTMLファイルで、サーバーは必要ありません。キャラクターはリンクを使用して共有します（キャラクターデータはURL自体に保存されます）。すべてのチャットデータはIndexedを使用してブラウザに保存されます。
 * [py-gpt](https://github.com/szczyglis-dev/py-gpt) - GPT-4、GPT-4 Vision、GPT-3.5、DALL-E 3、Langchain、Llama-indexなどを搭載したデスクトップAIアシスタント。チャット、ビジョン、画像生成と解析、自律エージェント、コードとコマンドの実行、ファイルのアップロードとダウンロード、音声合成と認識、Webアクセスを提供します。
 * [chatgpt-to-notion](https://github.com/l-a-r-t/chatgpt-to-notion) - ChatGPT to Notionは、ChatGPTの賢さをあなたのNotionワークスペースに直接もたらします！
 * [neural](https://github.com/dense-analysis/neural) - AI Vim/Neovimコード生成プラグイン（OpenAI、ChatGPTなど）AI Vim/Neovimコード生成プラグイン（OpenAI、ChatGPT、その他）
 * [Sophia](https://github.com/kyegomez/sophia) - モデルトレーニングコストを50％削減するための簡単なプラグインとプレイ最適化ツール。LLMsにおいてAdamより2倍高速な新しい最適化ツール。
 * [ChatGPT-Gnome-Desktop-Extension](https://github.com/horrorpills/chatgpt-gnome-desktop-extension) - ChatGPTノームデスクトップ拡張機能 | メニューバーからChatGPTとお話しよう！
 * [privacy-settings](https://github.com/stellarsand/privacy-settings) - 主要なソフトウェアやサービスのプライバシー設定ガイド
 * [nonebot-plugin-bilichat](https://github.com/well2333/nonebot-plugin-bilichat) - OpenAIを使用してBilibili動画を要約する多機能なBilibili解析プラグイン
 * [Raycast-Easydict](https://github.com/tisfeng/raycast-easydict) - 簡単な方法で単語を検索したりテキストを翻訳するためのRaycast拡張機能。48以上の言語をサポートし、LingueeやYoudao辞書をサポートし、OpenAI、DeepL、Google、Bing、Apple、Baidu、Tencent、Volcano、Youdao、Caiyunの翻訳をサポートしています。
 * [model.nvim](https://github.com/gsuuon/model.nvim) - LLMとエディター統合プロンプトとのやり取りを行うためのNeovimプラグイン
 * [BrowserGPT](https://github.com/mayt/browsergpt) - GPTを使用してブラウザを操作します。
 * [VisualChatGPTStudio](https://github.com/jeffdapaz/visualchatgptstudio) - Visual Studioに直接chatGPT機能を追加します。
 * [crawlee-python](https://github.com/apify/crawlee-python) - Crawlee—Python向けの信頼性の高いクローラーを構築するためのWebスクレイピングおよびブラウザ自動化ライブラリ。AI、LLMs、RAG、またはGPTs向けのデータを抽出します。ウェブサイトからHTML、PDF、JPG、PNGなどのファイルをダウンロードします。BeautifulSoup、Playwright、および生のHTTPと連携します。両方のヘッドで動作します。
 * [supermemory](https://github.com/supermemoryai/supermemory) - スーパーメモリーを使って自分だけの第二の脳を構築しましょう。それはあなたのブックマーク用のChatGPTです。ツイートをインポートしたり、Chrome拡張機能を使ってウェブサイトやコンテンツを保存したりできます。
 * [Auto-GPT-Plugin-Template](https://github.com/significant-gravitas/auto-gpt-plugin-template) - Auto-GPTのための独自のプラグインを開発するための出発点
 * [joplin-plugin-jarvis](https://github.com/alondmnt/joplin-plugin-jarvis) - Joplin（ノートテイキング）アシスタントが非常にインテリジェントなシステム（OpenAI/GPT、Hugging Face、Gemini、Llama、Universal Sentence Encoderなど）を実行しています。
 * [ChatLLM-Web](https://github.com/ryan-yang125/chatllm-web) - 🗣️ WebGPUを使用して、安全かつプライベートに、サーバーなしでVicunaのようなLLMと完全にブラウザでチャットします。Web llmによって提供されます。
 * [raycast-g4f](https://github.com/xinthedark/raycast-g4f) - GPT-4、Llama-3などを無料で使用するRaycast拡張機能。APIキーは不要です！
 * [bob-plugin-openai-polisher](https://github.com/openai-translator/bob-plugin-openai-polisher) - OpenAI APIを使用してテキストを磨き、文法を修正するBobプラグイン！Grammarlyの完璧な代替品！CC BY-NC-SA 4.0のライセンスに基づいています。
 * [GPT-Prompter](https://github.com/giosilvi/gpt-prompter) - 選択したテキストの高速プロンプトを取得するためのブラウザ拡張機能、OpenAIのGPT-3、GPT-4、ChatGPT API用。ChromeウェブストアとFirefoxブラウザアドオンで利用可能。
 * [web-llm-chat](https://github.com/mlc-ai/web-llm-chat) - ブラウザでネイティブに実行されているAI大規模言語モデルとチャットしてください。プライベートで、サーバーレスで、シームレスなAI会話をお楽しみください。Output: ブラウザでネイティブに実行されているAI大規模言語モデルとチャットしてください。プライベートで、サーバーレスで、シームレスなAI会話をお楽しみください。
 * [chatgpt-advanced](https://github.com/interstellard/chatgpt-advanced) - WebChatGPT：ChatGPTのプロンプトをWebの結果で補完するブラウザ拡張機能。
 * [linkedIn_auto_jobs_applier_with_AI](https://github.com/feder-cr/linkedin_auto_jobs_applier_with_ai) - LinkedIn_AIHawkは、LinkedIn上の求人応募プロセスを自動化するツールです。人工知能を活用して、ユーザーが複数の求人に自動化された個人的な方法で応募できるようにします。
 * [Plugin-VoiceGPT](https://github.com/wstxda/plugin-voicegpt) - Googleアシスタントの代わりにChatGPTを使用してください。
 * [codecompanion.nvim](https://github.com/olimorris/codecompanion.nvim) - ✨ NeovimでのCopilot Chat体験、インラインアシスタント付き。Anthropic、Gemini、Ollama、OpenAI LLMsをサポートします。
 * [open-assistant-api](https://github.com/mlt-oss/open-assistant-api) - Open Assistant APIは、使用準備が整っており、オープンソースで自己ホスト型のエージェント/gptsオーケストレーション作成フレームワークであり、LLM、RAG、関数呼び出し、およびツールの機能にカスタマイズされた拡張をサポートしています。また、openai/langとのシームレスな統合もサポートしています。
 * [parrot.nvim](https://github.com/frankroeder/parrot.nvim) - Input: parrot.nvim 🦜 - the plugin that brings stochastic parrots to Neovim. This is a gp.nvim-fork focused on simplicity.Output: parrot.nvim 🦜 - ネオビムに確率的なオウムをもたらすプラグイン。これはシンプリシティに焦点を当てたgp.nvimのフォークです。
 * [ChatGPTWizard](https://github.com/alidehbansiahkarbon/chatgptwizard) - Embarcadero RAD Studio IDE XE5から12.1用のChatGPT、WriteSonic、YouChat、Ollama（オフライン）プラグイン。https://getitnow.embarcadero.com/chatgptwizard
 * [Auto_Jobs_Applier_AIHawk](https://github.com/feder-cr/auto_jobs_applier_aihawk) - Auto_Jobs_Applier_AIHawkは、仕事の応募プロセスを自動化するツールです。人工知能を活用して、ユーザーが複数の仕事に自動化された個人的な方法で応募できるようにします。
 * [ai-commits-intellij-plugin](https://github.com/blarc/ai-commits-intellij-plugin) - IntelliJベースのIDE / Android Studio向けのAIコミット。IntelliJベースのIDE / Android Studio向けのAIコミット。
 * [ogpt.nvim](https://github.com/huynle/ogpt.nvim) - Ollama/Huggingface/TextGen/OpenAI/Gemini/Anthropic GPT Neovim Pluginとチャット：LLM APIを使用した自然な言語生成の手間いらずOllama/Huggingface/TextGen/OpenAI/Gemini/Anthropic GPT Neovimプラグインとのチャット：LLM APIを使用した自然な言語生成の手間いらず
 * [ChatGPTToolkitExtension](https://github.com/doggy8088/chatgpttoolkitextension) - ChatGPT、Gemini、Claude、phind、Groqのウェブサイトの利用体験を向上させ、便利な機能を提供します。たとえば、URLから自動的に入力するヒントを提供したり、返信する際に自動的にヒントボタンが表示されるようにします。
 * [LLM_Web_search](https://github.com/mamei16/llm_web_search) - DuckDuckGoを使用してLLMがウェブを検索できるようにするoobabooga/text-generation-webuiの拡張機能
 * [DevoxxGenieIDEAPlugin](https://github.com/devoxx/devoxxgenieideaplugin) - DevoxxGenieは、IntelliJ IDEA用のプラグインで、ローカルLLM（Ollama、LMStudio、GPT4All、Llama.cpp、Exo）とクラウドベースのLLMを使用して、プロジェクトコードのレビュー、テスト、説明を支援します。
 * [AGiXT](https://github.com/josh-xt/agixt) - AGiXTは、さまざまなAIプロバイダー間で指示管理と複雑なタスク実行をシームレスにオーケストレーションするダイナミックなAIエージェント自動化プラットフォームです。適応型メモリ、スマート機能、多機能なプラグインシステムを組み合わせることで、効率的なAGiXTを提供します。
 * [AutoGPT-Next-Web](https://github.com/connectai-e/autogpt-next-web) - 🤖 ブラウザで自律型AIエージェントを組み立て、構成、展開します。あなたの個人AutoGPTウェブアプリを簡単にデプロイします。
 * [Auto_Jobs_Applier](https://github.com/aihawk-app/auto_jobs_applier) - Auto_Jobs_Applier_AIHawkは、仕事の応募プロセスを自動化するツールです。人工知能を活用して、ユーザーが複数の仕事に自動化された個人的な方法で応募できるようにします。
 * [browser-use](https://github.com/gregpr07/browser-use) - 任意のLLMを使用したオープンソースのWeb自動化ライブラリ任意のLLMを使用したオープンソースのWeb自動化ライブラリ
 * [Auto_Jobs_Applier](https://github.com/aihawk-co/auto_jobs_applier) - Auto_Jobs_Applier by AIHawkは、仕事の応募プロセスを自動化するエージェントです。人工知能を活用して、ユーザーが自動化された個人に適した方法で複数の仕事に応募できるようにします。
 * [Auto_Jobs_Applier_AI_Agent](https://github.com/aihawk-co/auto_jobs_applier_ai_agent) - Auto_Jobs_Applier_AI_Agent by AIHawkは、仕事の応募プロセスを自動化するAIエージェントです。人工知能を活用して、ユーザーが自動化された個人的な方法で複数の仕事に応募できるようにします。
 * [zsh_codex](https://github.com/tom-doerr/zsh_codex) - これは、コマンドラインでOpenAIのCodex AIを使用できるようにするZSHプラグインです。
 * [pipelines](https://github.com/open-webui/pipelines) - パイプライン：多目的、UIに依存しないOpenAI互換のプラグインフレームワーク
 * [aura-voice](https://github.com/ntegrals/aura-voice) - AuraはSiriのようなものですが、ブラウザ内で動作します。低遅延応答に最適化されたAI音声アシスタントです。


## CLIs

 * [ChatGPT](https://github.com/acheong08/chatgpt) - ChatGPT APIのリバースエンジニアリング
 * [shell_gpt](https://github.com/ther1d/shell_gpt) - ChatGPTを搭載したコマンドライン生産性ツールは、タスクをより迅速かつ効率的に達成するのに役立ちます。
 * [PyChatGPT](https://github.com/rawandahmad698/pychatgpt) - ⚡️非公式ChatGPT APIのPythonクライアント。自動トークン再生成、会話トラッキング、プロキシサポートなどがあります。
 * [chatgpt-wrapper](https://github.com/mmabrouk/chatgpt-wrapper) - PythonとシェルからChatGPTとGPT4とのやり取りを行うためのAPI。
 * [chatblade](https://github.com/npiv/chatblade) - ChatGPTのためのCLIスイスアーミーナイフ
 * [Alice](https://github.com/greshake/alice) - ChatGPTに実際の端末へのアクセスを許可する。
 * [command-ai](https://github.com/amachino/command-ai) - OpenAI APIによって動力化されたターミナル内のAIチャットボット
 * [GPT_Vuln-analyzer](https://github.com/morpheuslord/gpt_vuln-analyzer) - ChatGPT API、Python-Nmap、DNS Reconモジュールを使用し、NmapスキャンデータとDNSスキャン情報に基づいた脆弱性レポートを作成するためにGPT3モデルを使用します。また、サブドメイン列挙も大幅に実行できます。
 * [shell-genie](https://github.com/dylanjcastillo/shell-genie) - あなたの願いは私の命令です。
 * [DirectAI](https://github.com/ustayready/directai) - ターミナルでOpenAI APIを使用してChatGPTのクエリを入力してください。
 * [GPTalk](https://github.com/0ut0flin3/gptalk) - WindowsおよびUnix用のメモリ管理をサポートし、任意の言語でテキストと音声の両方をサポートするGPT-3クライアント。
 * [Reptyl](https://github.com/0ut0flin3/reptyl) - 自然言語でのコマンド実行をサポートするクロスプラットフォームのコマンドラインシェル
 * [wanna](https://github.com/hirokidaichi/wanna) - 自然言語でのシェルコマンド起動ツール
 * [datasetGPT](https://github.com/radi-cho/datasetgpt) - LLMsを使用してテキストと会話のデータセットを生成するためのコマンドラインインターフェイス。
 * [chatgpt-cli](https://github.com/j178/chatgpt-cli) - 饭否机器人
 * [engshell](https://github.com/emcf/engshell) - LLMsによって動力を得た、どんなOSでも使える英語シェル
 * [node-chatgpt-api](https://github.com/waylaidwanderer/node-chatgpt-api) - ChatGPTとBing AIのクライアント実装。Node.jsモジュール、REST APIサーバー、CLIアプリとして利用可能。
 * [chat-gpt-cli](https://github.com/jseguillon/chat-gpt-cli) - PhantomJS QUnitテストランナーは、JenkinsなどのCIツールで使用するために、結果をJUnit XML形式にエクスポートし、カバレッジをCobertura XML形式にエクスポートします。
 * [terminalGPT](https://github.com/jucasoliveira/terminalgpt) - ターミナルでchatGPTのようなGPTを取得してください。
 * [chatgpt-gsheets](https://github.com/amrrs/chatgpt-gsheets) - [新着] #chatgptがシートに！🤯 #chatgpt #apiを@googlesheetsに数クリックで統合し、@1littlecoderが手順を示します！用途：#seo、#socialmedia、#marketing、あなたが名付けるもの！🔥- チュートリアル：code：cost：$2 /百万トークン！🙃
 * [gptsh](https://github.com/shorwood/gptsh) - GPT.shはNodeJsで構築され、Open AIのGPT-3によって動力を得たCLIツールです。その主な目的は、自然言語の質問やリクエストをシェルコマンドに翻訳することです。
 * [chatgpt-api](https://github.com/transitive-bullshit/chatgpt-api) - 公式ChatGPT APIのためのNode.jsクライアント。🔥
 * [ChatGPT-Next-Web](https://github.com/yidadaa/chatgpt-next-web) - 一クリックで自分自身のChatGPTウェブUIを展開する。
 * [ai-cli](https://github.com/abhagsain/ai-cli) - ターミナルからCLIコマンドの回答をGPT3から取得する。
 * [chathub](https://github.com/chathub-dev/chathub) - オールインワンチャットボットクライアント
 * [bing-chat](https://github.com/transitive-bullshit/bing-chat) - Bingの新しいAI搭載検索のためのNode.jsクライアントです。それはステロイドを使用したChatGPTのようです🔥
 * [aicommits](https://github.com/nutlope/aicommits) - AIを使ってあなたのGitコミットメッセージを自動生成するCLI
 * [opencommit](https://github.com/di-sukharev/opencommit) - 1秒で印象的なコミットを自動生成するためのGPT CLI 🤯🔫
 * [react-native-chatgpt](https://github.com/rgommezz/react-native-chatgpt) - ChatGPTをアプリケーションにシームレスに統合するためのReact Nativeラッパーです。認証、ストリーミングレスポンス、会話の追跡を処理します。100％クライアントサイド :robot:
 * [GPT-Shell](https://github.com/firtoz/gpt-shell) - GPT-Shellは、OpenAIベースのチャットボットであり、OpenAIのChatGPTに似ています。また、Dalle2画像の作成も可能です。
 * [autodoc](https://github.com/context-labs/autodoc) - LLMsを使用してコードベースのドキュメントを自動生成するための実験的なツールキット
 * [commit-assist](https://github.com/dejorrit/commit-assist) - ChatGPTを使用して自動的にコミットメッセージを生成します。
 * [ai-shell](https://github.com/builderio/ai-shell) - 自然言語をシェルコマンドに変換するCLI。
 * [doschgpt](https://github.com/yeokm1/doschgpt) - DOS用のChatGPTクライアントの概念実証。
 * [gptcommit](https://github.com/zurawiki/gptcommit) - GPT-3を使用してコミットメッセージを作成するためのgit prepare-commit-msgフック。
 * [a](https://github.com/ddddddeon/a) - GPT3からコードを生成するCLIツール
 * [plz-cli](https://github.com/m1guelpf/plz-cli) - ターミナルのコパイロット
 * [aichat](https://github.com/sigoden/aichat) - ターミナルでChatGPT/GPT-3.5/GPT-4を使用する。
 * [rusty](https://github.com/zahidkhawaja/rusty) - Bashコマンドを覚えるのを手助けするGPT-3パワードCLIツール。
 * [cligpt](https://github.com/schneiderfelipe/cligpt) - cligptは、OpenAIのChatGPT APIとやり取りするためのコマンドラインインターフェイスです。
 * [ata](https://github.com/rikhuijzer/ata) - ターミナルに何でも聞いてください（ATA）：ターミナルでChatGPT
 * [acli](https://github.com/jseguillon/acli) - Open AIのAPIによって動力を得た支援コマンドライン
 * [openaigo](https://github.com/otiai10/openaigo) - OpenAI GPT3/3.5 ChatGPT APIのGo用クライアントライブラリー。シンプルで依存関係が少なく、よくテストされています。
 * [cligpt](https://github.com/paij0se/cligpt) - ターミナルでのChatGPT
 * [CodeGPT](https://github.com/appleboy/codegpt) - Go言語で書かれたCLIで、ChatGPT AI（gpt-4、gpt-3.5-turboモデル）を使用してgitのコミットメッセージを書いたり、コードレビューの概要を作成したりし、自動的にgitのprepare-commit-msgフックをインストールします。
 * [search](https://github.com/visualbasic6/search) - 「chatgpt」によって書かれたCLI Googleクライアントで、Googleアラートの「プレビュー」機能を使用して、CAPTCHAとレート制限をバイパスします。
 * [chatgpt-backup](https://github.com/abacaj/chatgpt-backup) - ChatGPTの全会話履歴をバックアップするための単一のクライアントサイドスクリプト
 * [PowerShellAI](https://github.com/dfinke/powershellai) - OpenAI GPT-3とDALL-EのためのPowerShell AIモジュール
 * [chatGPT-shell-cli](https://github.com/0xacx/chatgpt-shell-cli) - ターミナルからOpenAIのChatGPTとDALL-Eを使用するためのシンプルなシェルスクリプト。PythonやJSは必要ありません。
 * [chatgpt-shell](https://github.com/xenodium/chatgpt-shell) - 最小限のChatGPTとDALL-E Emacsシェル
 * [client](https://github.com/openai-php/client) - ⚡️ OpenAI PHPは、OpenAI APIとやり取りすることができる、コミュニティによってメンテナンスされた高速なPHP APIクライアントです。
 * [slickgpt](https://github.com/shipbit/slickgpt) - SlickGPTは、Svelteで書かれた軽量な「自分自身のAPIキーを使用する」Webクライアントであり、OpenAI APIに対応しています。GPT-4の統合、ユーザーレスの共有機能など、その他のスーパーパワーを提供しています。
 * [chatgpt-ui](https://github.com/wongsaang/chatgpt-ui) - 複数のユーザーをサポートするChatGPTウェブクライアントで、永続的なデータストレージのために複数のデータベース接続をサポートし、i18nをサポートしています。Dockerイメージとクイックデプロイメントスクリプトを提供します。
 * [openai-java](https://github.com/theokanning/openai-java) - JavaでのOpenAI GPT-3 APIクライアント
 * [hfuzz](https://github.com/thehlopster/hfuzz) - 私が行ったペントテストの結果、git.rip、ChatGPT、Lex、nucleiテンプレート、Webスキャナー、seclist、bo0mなど、信頼できるさまざまなソースから作成されたWebファジング用のワードリスト。
 * [the-art-of-command-line](https://github.com/jlevy/the-art-of-command-line) - 1ページでコマンドラインをマスターする
 * [auto-copilot-cli](https://github.com/rsaryev/auto-copilot-cli) - Auto Copilotは、目標を達成するために、OpenAIモデルを使用してターミナルのコマンドやファイルシステム操作を生成するCLIツールです。
 * [DelphiOpenAI](https://github.com/hemulgm/delphiopenai) - Delphi用のOpenAI APIクライアント。ChatGPT、DALL-Eなどの製品を使用します。
 * [free-chatgpt-client-pub](https://github.com/akl7777777/free-chatgpt-client-pub) - 無料のChatGPTクライアント、オンライン検索に対応。キー不要、ログイン不要。マルチノード自動速度測定スイッチ、制限なしの長文翻訳、AIグラフィックスを搭載。
 * [duet-gpt](https://github.com/kristoferlund/duet-gpt) - 会話型の半自律型開発者アシスタント。コピペなしのAIペアプログラミング。
 * [elia](https://github.com/darrenburns/elia) - Textualで構築されたターミナルのChatGPTクライアント
 * [README-AI](https://github.com/eli64s/readme-ai) - 🚀 README Markdownファイルを美しく情報豊かに生成するCLIツール。OpenAIのGPT APIによって動作します 💫
 * [openai-powershell-samples](https://github.com/dfinke/openai-powershell-samples) - 🚀 @OpenAI/@Azure PowerShellサンプルをリリースしました！PowerShellAIモジュールを使用すると、ChatGPTの力を手軽に利用できます。Polyglotインタラクティブノートブックでサンプルを探索してください。AIで可能性を再定義しましょう！👇 #PowerShell #MSBuild
 * [TermGPT](https://github.com/sentdex/termgpt) - LLMのようなGPT-4に、ターミナルコマンドの計画と実行の能力を与えること。
 * [chatgpt-cli](https://github.com/marcolardera/chatgpt-cli) - 公式APIを使用してChatGPTとチャットするためのシンプルで効果的なコマンドラインクライアント
 * [OpenAIR](https://github.com/umatter/openair) - OpenAI Rクライアント
 * [ChatGPT-Midjourney](https://github.com/licoy/chatgpt-midjourney) - 🎨 一クリックで自分のChatGPT+Midjourneyウェブサービスを所有してください。
 * [termGPT](https://github.com/tcapelle/termgpt) - Pythonで書かれたターミナルでopenAIのchatGPTを呼び出すためのシンプルなラッパー
 * [Chat2DB](https://github.com/alibaba/chat2db) - 🔥 🔥 🔥 チャットGPT機能を統合した、データベース用の知的で多目的な汎用SQLクライアントおよびレポートツール。
 * [llm-toolbox](https://github.com/sderev/llm-toolbox) - LLM-Toolboxは、AIを利用して様々なタスクを実行するための多機能なコマンドラインインターフェース（CLI）ツールの集合です。これには、校正、適切なシェルコマンドの特定、自動コミットメッセージの生成などが含まれます。
 * [chatgpt.js](https://github.com/chatgptjs/chatgpt.js) - 🤖 ChatGPTのための強力なクライアントサイドのJavaScriptライブラリ。
 * [Clippy](https://github.com/firecubestudios/clippy) - クリッピー by FireCube。
 * [aider](https://github.com/paul-gauthier/aider) - aiderはターミナルで動作するGPTパワードのコーディングです。aiderはターミナルで動作するGPTパワードのコーディングです。
 * [SaaS-Template-GPT](https://github.com/wasp-lang/saas-template-gpt) - 🐝 ワスプ- ソーシャル/メールログイン、GPT/Stripeの統合、cronジョブなどを含むSaaSテンプレートで即座に開始します⚡️- `wasp db` CLIコマンドも素敵な要素で、バックグラウンドでローカルのPostgresデータベースをすぐに開始します。
 * [openai-cli](https://github.com/janlay/openai-cli) - BASHで書かれたOpenAIのためのユニバーサルCLI。
 * [Chat2DB](https://github.com/chat2db/chat2db) - 🔥 🔥 🔥 データベース用の知識豊富で多機能な汎用SQLクライアントおよびレポートツールで、ChatGPTの機能も統合されています。
 * [gpt-web-terminal](https://github.com/ltyzzzxxx/gpt-web-terminal) - ✨ プログラマーのアプローチでChatGPTを開く！ GPT Terminalは、ターミナルでGPTとコミュニケーションを取ることができるプラットフォームです。
 * [chatgpt-web](https://github.com/dqzboy/chatgpt-web) - ChatGPT WebのワンクリックデプロイメントChatGPT Webのワンクリックデプロイメント
 * [tgpt](https://github.com/aandrew-me/tgpt) - APIキーを必要とせずにターミナルでChatGPTを使用する。
 * [chatgpt-cli](https://github.com/kardolus/chatgpt-cli) - ChatGPT CLIは、OpenAIのChatGPTのための高度なコマンドラインインターフェースであり、ストリーミング、クエリモード、および履歴追跡を提供し、シームレスでコンテキストに対応した会話を実現します。ユーザーと開発者の両方に最適であり、高度な設定と簡単なセットアップオプションを提供し、GPTモデルとのカスタマイズされた会話体験を確保します。
 * [lobe-commit](https://github.com/lobehub/lobe-commit) - 💌 Lobe Commitは、Langchain/ChatGPTを使用してGitmojiベースのコミットメッセージを生成するCLIツールです。
 * [SuperSummarizeAI](https://github.com/alexandrevl/supersummarizeai) - スーパーサマライズAIでAIの力を解き放ちましょう！ChatGPTを使用して、ウェブページやYouTubeの動画から簡単にコンテンツを抽出、要約、クリップすることができます。無限のコンテンツを消化しやすい要約に変えましょう。
 * [minion](https://github.com/mikaelvesavuori/minion) - 開発者がCLIでChatGPTを使用するための最も簡単で軽量な方法。
 * [chai-ruby](https://github.com/rogueocelot/chai-ruby) - ターミナルエミュレータを使用して、GNOME Filesで開いているディレクトリにcdしてください。
 * [llm-code-interpreter](https://github.com/e2b-dev/llm-code-interpreter) - AI Playgrounds by E2Bによって提供されています。ChatGPT用のステロイドコードインタープリター。どんな言語でも、どんなターミナルプロセスでも実行し、自由にファイルシステムを使用できます。すべてインターネットにアクセスできます。
 * [lobe-chat](https://github.com/lobehub/lobe-chat) - 🤖 Lobe Chat - オープンソースで拡張可能（関数呼び出し可能）、高性能なチャットボットフレームワークです。プライベートなChatGPT/LLMウェブアプリケーションのワンクリック無料デプロイをサポートしています。
 * [paperify](https://github.com/jstrieb/paperify) - どんなドキュメント、ウェブページ、またはeBookでも研究論文に変換します（ChatGPTは必要ありません）
 * [cli](https://github.com/bashsenpai/cli) - BashSenpaiはChatGPTによって動作するターミナルアシスタントです。
 * [unit-runtime](https://github.com/unit-mesh/unit-runtime) - Unit Runtime は、ChatGPT やその他の AI コードを実行するための効率的で使いやすい環境です。ワンクリックで起動し、リアルタイムで対話することができ、AI コードの構築とテストを迅速にサポートします。
 * [aih](https://github.com/databingo/aih) - ターミナルでAIモードと話す。Bard|GPT3.5|Claude2|Llama2|Falcon180
 * [Sense](https://github.com/f0x1d/sense) - Android対応のOpenAIクライアントで、ChatGPTをサポートしています。
 * [sparrow](https://github.com/soulteary/sparrow) - ChatGPTスタイルのクライアント互換のバックエンドサーバー、オープンソースの実装。
 * [chatgpt-md-translator](https://github.com/smikitky/chatgpt-md-translator) - ChatGPT APIを使用してMarkdownドキュメントを翻訳するためのCLI
 * [ollama-webui](https://github.com/ollama-webui/ollama-webui) - Ollama 🦙のためのChatGPTスタイルの応答性のあるチャットWeb UIクライアント（GUI）
 * [BibiGPT-v1](https://github.com/jimmylv/bibigpt-v1) - BibiGPT v1 · 音声/ビデオとチャットのためのワンクリックAI要約、学習コンテンツ付き：Bilibili | YouTube | ツイート | TikTok | Dropbox | Google Drive | ローカルファイル | ウェブサイト | ポッドキャスト | ミーティング | 講義など。音声/ビデオコンテンツのAI要約と対話：哔哩哔哩 | YouTube | ツイッター | 小红书 | 抖音 | 快手 | 百度网盘 | 阿里云盘 | ウェブサイト | ポッドキャスト | ミーティング | ローカルファイルなど（元BiliGPT省流神器＆AI代表）。
 * [open-interpreter](https://github.com/killianlucas/open-interpreter) - ローカルで実行されるターミナル上のOpenAIのコードインタプリター
 * [chatgpt-java](https://github.com/grt1228/chatgpt-java) - ChatGPT Java SDKは、ストリーミング出力、Gptプラグイン、ネットワーキングをサポートしています。OpenAI公式のすべてのインターフェースをサポートしています。ChatGPTのJavaクライアントです。OpenAI GPT-3.5-Turbo GPT-4のJava用APIクライアントです。
 * [llm-workflow-engine](https://github.com/llm-workflow-engine/llm-workflow-engine) - LLMsのPower CLIとワークフローマネージャー（コアパッケージ）
 * [openai-kotlin](https://github.com/aallam/openai-kotlin) - マルチプラットフォームとコルーチンの機能を備えたKotlin用のOpenAI APIクライアント。
 * [sqlchat](https://github.com/sqlchat/sqlchat) - 次の10年のためのチャットベースのSQLクライアントとエディタ
 * [ShellGPT](https://github.com/akl7777777/shellgpt) - シェルGPTは無料のチャットGPTクライアントで、オンライン検索がサポートされています。キーは必要ありませんし、ログインも必要ありません。マルチノードの自動速度測定スイッチ、制限なしの長文翻訳、AIグラフィックスも利用できます。
 * [gptel](https://github.com/karthink/gptel) - シンプルなEmacs用のLLMクライアント
 * [OpenAI-DotNet](https://github.com/rageagainstthepixel/openai-dotnet) - 非公式のOpenAI RESTful APIクライアント（DotNet用）
 * [every-chatgpt-gui](https://github.com/billmei/every-chatgpt-gui) - すべてのChatGPTのフロントエンドGUIクライアント
 * [yai](https://github.com/ekkinox/yai) - あなたのAIパワードターミナルアシスタント。
 * [gpt-cli](https://github.com/kharvd/gpt-cli) - ChatGPTのためのコマンドラインインターフェース、ClaudeとBard
 * [Gemini](https://github.com/kyegomez/gemini) - Googleによって「ChatGPTを凌駕する」モデルとして開発されたGeminiのオープンソース実装
 * [MoneyPrinterTurbo](https://github.com/harry0703/moneyprinterturbo) - AI LLMを使用して、ワンクリックで高品質なショートビデオを生成します。
 * [zap-gpt](https://github.com/marcusgoncalvess/zap-gpt) - このプロジェクトは、ChatGPTとWhatsAppの統合を探求し、チャットボットを友達と会話したり、顧客の質問に答えたりするなど、会話に人間味を持たせる仮想アシスタントに変えることができる能力を持つようにします。
 * [zap-gpt-free](https://github.com/marcusgoncalvess/zap-gpt-free) - このプロジェクトは、ChatGPTとWhatsAppの統合を探求し、チャットボットを友達と会話したり、顧客の質問に答えたりするなど、さまざまなタスクを実行できる仮想アシスタントに変えることを目指しています。会話に人間味を持たせる要素も取り入れています。
 * [chatAir](https://github.com/flyun/chatair) - ☁️OpenAIとGeminiのためのネイティブAndroidクライアント☁️
 * [matrix-chatgpt-bot](https://github.com/matrixgpt/matrix-chatgpt-bot) - どのMatrixクライアントを使用してもChatGPTと話すことができます！
 * [lobe-cli-toolbox](https://github.com/lobehub/lobe-cli-toolbox) - 🪀 ローブCLIツールボックス - AI CLIツールボックス、gitコミットとi18nワークフローの効率を向上
 * [openai-scala-client](https://github.com/cequence-io/openai-scala-client) - OpenAI APIのためのScalaクライアント
 * [ChatGPTCLIBot](https://github.com/lagpixellol/chatgptclibot) - 埋め込みを使用した長期メモリサポート付きのCLIでのChatGPTボット。
 * [openai4j](https://github.com/lambdua/openai4j) - OpenAI APIのJavaクライアントライブラリ。Completions、Chat、Edits、Embeddings、Audio、Files、Assistants-v2、Images、Moderations、Batch、Fine-tuningを含むすべてのOpenAI APIモデルを完全サポート。
 * [json-translator](https://github.com/mololab/json-translator) - jsontt 💡 - GPT + その他の無料翻訳モジュールを使用したAI JSON翻訳者、json/yamlファイルを他の言語に翻訳します ✅ Readmeをチェックしてください ✌ GPT / DeepL / Google / Bing / Libre / Argosに対応
 * [gptme](https://github.com/erikbjare/gptme) - ローカルツールを備えたLLMsとチャットする：PythonとBashを実行し、ローカルファイルを編集し、ウェブを閲覧します。
 * [Apt](https://github.com/rnchg/apt) - AI生産性ツール - 無料でオープンソース、ユーザーの生産性を向上させながらプライバシーとデータセキュリティを確保します。組み込みの独占的なChatGPTを含む効率的で便利なAIソリューションを提供します。
 * [chatgpt-subtitle-translator](https://github.com/cerlancism/chatgpt-subtitle-translator) - ChatGPT APIをベースにした効率的な翻訳ツール
 * [tenere](https://github.com/pythops/tenere) - Rustで書かれたLLMsのためのTUIインターフェースRustで書かれたLLMsのためのTUIインターフェース
 * [Chat2DB](https://github.com/codephiliax/chat2db) - 🔥🔥🔥AI駆動型データベースツールおよびSQLクライアント、最も人気のあるGUIクライアント、MySQL、Oracle、PostgreSQL、DB2、SQL Server、DB2、SQLite、H2、ClickHouseなどをサポート。
 * [OpenHands](https://github.com/all-hands-ai/openhands) - 🙌 OpenHands: コードを少なくして、もっと多くを作成します
 * [ai-digest](https://github.com/khromov/ai-digest) - Claude ProjectsやカスタムChatGPTと一緒に使用するためのコードベースを1つのMarkdownファイルに集約するためのCLIツール。
 * [web-mirai-panel](https://github.com/zmh-program/web-mirai-panel) - 🍉 ChatGPT Mirai QQボットロボットのWeb UI、マルチインスタンス管理、構成編集、ファイル提出、ヘルスチェック、ターミナル実行、パスワードアクセスのサポート。🍉
 * [Nexior](https://github.com/acedatacloud/nexior) - 自分自身のAIアプリケーションWeb UIを展開するためには、1クリックで、GPT、Midjourney、ChatDoc、QrArtを含めて、簡単に利益を得ることができます。
 * [aider](https://github.com/aider-ai/aider) - aiderはあなたのターミナルでのAIペアプログラミングですaiderはあなたのターミナルでのAIペアプログラミングです
 * [laravel](https://github.com/openai-php/laravel) - ⚡️ OpenAI PHP for Laravelは、OpenAI APIとやり取りすることができる強化されたPHP APIクライアントです。
 * [WrenAI](https://github.com/canner/wrenai) - 🚀 テキストからSQLへのオープンソースSQL AIエージェント。 PostgreSQL、DuckDB、MySQL、MS SQL、ClickHouse、Trino、JSON、CSV、Parquetデータソースなどをサポートしています！ 🚀
 * [Queryable](https://github.com/mazzzystar/queryable) - iOSでOpenAIのCLIPとAppleのMobileCLIPモデルを実行して写真を検索します。
 * [ChatGPTs](https://github.com/licoy/chatgpts) - 🍭 あなた自身のChatGPT+多数のAIウェブサービスにワンクリックでアクセスできます
 * [ChatAny](https://github.com/licoy/chatany) - 🌻 あなた自身のChatGPT+多くのAIウェブサービスにワンクリックでアクセスできます
 * [ChatAny](https://github.com/chatanyteam/chatany) - 🌻 ChatGPTと多くのAIウェブサービスに簡単アクセス | One click access to your own ChatGPT+Many AI web services
 * [cz-git](https://github.com/zhengqbbb/cz-git) - cz-git | czg 🛠️ DXを最優先にし、よりエンジニアリングされた、軽量でカスタマイズ可能な、標準出力形式のCommitizenアダプターおよびCLIcz-git | czg 🛠️ DXを最優先にし、よりエンジニアリングされた、軽量でカスタマイズ可能な、標準出力形式のCommitizenアダプターおよびCLI
 * [cherry-studio](https://github.com/kangfenmao/cherry-studio) - 🍒 Cherry Studioは複数のLLMプロバイダーをサポートするデスクトップクライアントです。
 * [plandex](https://github.com/plandex-ai/plandex) - ターミナルでのAI駆動開発。大規模で実世界のタスクに対応するよう設計されています。
 * [PDFMathTranslate](https://github.com/byaidu/pdfmathtranslate) - PDF科学论文翻译，保留格式 - AIを使用してPDF科学論文を翻訳し、排版を保持した全文のバイリンガル翻訳を提供します。Google/DeepL/Ollama/OpenAIなどのサービスをサポートし、CLI/GUI/Dockerを提供します。
 * [gpt-engineer](https://github.com/gpt-engineer-org/gpt-engineer) - AIソフトウェアエンジニアと実験するためのプラットフォーム。ターミナルベースです。注意：https://gptengineer.appとは非常に異なります。
 * [whisper-ctranslate2](https://github.com/softcatala/whisper-ctranslate2) - CTranslate2に基づいたオリジナルのOpenAIクライアントと互換性のあるWhisperコマンドラインクライアント。Whisperコマンドラインクライアントは、オリジナルのOpenAIクライアントと互換性があります。


## Reimplementations

 * [PaLM-rlhf-pytorch](https://github.com/lucidrains/palm-rlhf-pytorch) - PaLMアーキテクチャの上にRLHF（人間のフィードバックを用いた強化学習）の実装。基本的にはChatGPTですが、PaLMを使用しています。
 * [minGPT](https://github.com/karpathy/mingpt) - OpenAI GPT（Generative Pretrained Transformer）のトレーニングの最小限のPyTorch再実装
 * [mm-cot](https://github.com/amazon-science/mm-cot) - 「言語モデルにおける多様な思考連鎖推論」の公式実装があります（今後も更新されますのでお楽しみに）。
 * [picoGPT](https://github.com/jaymody/picogpt) - NumPyで実装されたGPT-2の不必要に小さい実装。
 * [gpt-neox](https://github.com/eleutherai/gpt-neox) - DeepSpeedライブラリに基づくGPU上のモデル並列自己回帰トランスフォーマーの実装。
 * [GPTZero](https://github.com/burhanultayyab/gptzero) - GPTZeroのオープンソース実装
 * [SpikeGPT](https://github.com/ridgerchu/spikegpt) - 「SpikeGPT：スパイキングニューラルネットワークを用いた生成事前学習言語モデルの実装」の実現
 * [ml-ane-transformers](https://github.com/apple/ml-ane-transformers) - Apple Neural Engine（ANE）に最適化されたTransformerアーキテクチャのリファレンス実装
 * [memorizing-transformers-pytorch](https://github.com/lucidrains/memorizing-transformers-pytorch) - Pytorchでの近似最近傍法を使用したメモリのインデックスと検索を増強したアテンションネットワークを実装した「Memorizing Transformers」（ICLR 2022）の実装。
 * [lit-llama](https://github.com/lightning-ai/lit-llama) - nanoGPTに基づくLLaMA言語モデルの実装。フラッシュアテンション、Int8およびGPTQ 4ビット量子化、LoRAおよびLLaMA-Adapterの微調整、事前学習をサポートしています。Apache 2.0ライセンスです。
 * [large-model-parallelism](https://github.com/hundredblocks/large-model-parallelism) - 主要なモデル並列化手法の機能的なローカル実装
 * [bloomz.cpp](https://github.com/nouamanetazi/bloomz.cpp) - BLOOMのC++実装
 * [swift-coreml-transformers](https://github.com/huggingface/swift-coreml-transformers) - GPT-2、DistilGPT-2、BERT、およびDistilBERTのSwift Core ML 3実装による質問応答。他のトランスフォーマーも近日公開予定！
 * [lit-parrot](https://github.com/lightning-ai/lit-parrot) - nanoGPTに基づくStableLM/Pythia/INCITE言語モデルの実装。フラッシュアテンション、LLaMA-アダプターの微調整、事前学習をサポート。Apache 2.0ライセンス。
 * [gpt-code-ui](https://github.com/ricklamers/gpt-code-ui) - OpenAIのChatGPTコードインタープリターのオープンソース実装
 * [DragGAN](https://github.com/zeqiang-lai/draggan) - DragGANのオンラインデモと実装 - 「Drag Your GAN：生成画像マニフォールド上のインタラクティブなポイントベースの操作」
 * [femtoGPT](https://github.com/keyvank/femtogpt) - 最小限のGenerative Pretrained Transformerの純粋なRust実装
 * [lit-gpt](https://github.com/lightning-ai/lit-gpt) - nanoGPTに基づいた最新のオープンソースLLMsのハッキング可能な実装。フラッシュアテンション、Int8およびGPTQ 4ビットの量子化、LoRAおよびLLaMA-Adapterのファインチューニング、事前トレーニングをサポートしています。Apache 2.0ライセンスです。
 * [exllama](https://github.com/turboderp/exllama) - 量子化された重みを使用するためのLlamaのHF transformers実装のメモリ効率の改善版。
 * [AStarNet](https://github.com/deepgraphlearning/astarnet) - 公式のA*ネットワークの実装
 * [codeinterpreter-api](https://github.com/shroominic/codeinterpreter-api) - ChatGPTコードインタープリターのオープンソース実装 👾
 * [Local-Code-Interpreter](https://github.com/mrgreyfun/local-code-interpreter) - OpenAIのChatGPTコードインタプリタのローカル実装。
 * [ChatPiXiu](https://github.com/openllmai/chatpixiu) - ChatPiXiu：OpenLLMAIのドキュメント。オープンソースのChatGPTの代替/実装の調査、再現、ドメイン/タスクの適応についてのドキュメントです。PiXiu-貔貅は幸運を意味します。
 * [vall-e](https://github.com/lifeiteng/vall-e) - VALL-E（ゼロショットテキストから音声へ）のPyTorch実装、再現されたデモ https://lifeiteng.github.io/valle/index.html
 * [textgen](https://github.com/shibing624/textgen) - テキスト生成モデルの実装で、LLaMA、BLOOM、GPT2、BART、T5、SongNetなどを含みます。これらのモデルのトレーニングと予測を実現し、すぐに使用できます。
 * [LaMDA-rlhf-pytorch](https://github.com/conceptofmind/lamda-rlhf-pytorch) - GoogleのLaMDAのPyTorchでのオープンソースの事前トレーニング実装。ChatGPTに類似したRLHFの追加。GoogleのLaMDAのPyTorchでのオープンソースの事前トレーニング実装。ChatGPTに類似したRLHFの追加。
 * [langchain](https://github.com/brainlid/langchain) - LangChainスタイルのフレームワークのElixir実装。
 * [kan-gpt](https://github.com/adityang/kan-gpt) - 言語モデリングのためのKolmogorov-Arnold Networks（KANs）を使用したGenerative Pre-trained Transformers（GPTs）のPyTorch実装PyTorchによるGenerative Pre-trained Transformers（GPTs）のKolmogorov-Arnold Networks（KANs）を使用した言語モデリングの実装
 * [TextRL](https://github.com/voidful/textrl) - huggingfaceのtransformer（blommz-176B/bloom/gpt/bart/T5/MetaICL）のどの世代モデルにもChatGPT RLHF（人間フィードバック付き強化学習）の実装
 * [ShareGPT4Video](https://github.com/sharegpt4omni/sharegpt4video) - ShareGPT4Videoの公式実装：より良いキャプションでビデオ理解と生成を向上させる
 * [GPT2](https://github.com/affjljoo3581/gpt2) - OpenAI GPT-2のPyTorch実装
 * [T2M-GPT](https://github.com/mael-zys/t2m-gpt) - （CVPR 2023）テキスト記述からの人間の動きの生成に関する「T2M-GPT」のPytorch実装
 * [stable-baselines3](https://github.com/dlr-rm/stable-baselines3) - PyTorchバージョンのStable Baselines、強化学習アルゴリズムの信頼性のある実装。
 * [WhisperLive](https://github.com/collabora/whisperlive) - OpenAIのWhisperのほぼライブ実装。
 * [GenAI_Agents](https://github.com/nirdiamant/genai_agents) - このリポジトリは、基本から高度なまでさまざまな生成AIエージェント技術のチュートリアルと実装を提供しています。知的でインタラクティブなAIシステムを構築するための包括的なガイドとして機能します。


## Tutorials

 * [Hello-Python](https://github.com/mouredev/hello-python) - Pythonプログラミング言語をゼロから学ぶための初心者向けコース。30以上のレッスン、25時間のビデオ、コード、チャットグループがあります。基礎からデータベースを持つAPIバックエンドの作成まで...
 * [notebooks](https://github.com/dataflowr/notebooks) - 深層学習コースのコード
 * [gpt4all-colab](https://github.com/camenduru/gpt4all-colab) - 🔥gpt4all（最高のchatgptクローン）がローカルとcolabチュートリアルで実行されています-@camenduruのcolabに-
 * [X-Decoder](https://github.com/microsoft/x-decoder) - Q#と量子コンピューティングを学ぶためのチュートリアルとプログラミング演習
 * [AI-Powered-Video-Tutorial-Generator](https://github.com/akshitireddy/ai-powered-video-tutorial-generator) - キャラクターアニメーションとスライドを使用したAI生成ビデオチュートリアルを作成しましょう！
 * [semantic-kernel-rag-chat](https://github.com/azure-samples/semantic-kernel-rag-chat) - チャットGPT + エンタープライズデータのチュートリアル、セマンティックカーネル、OpenAI、およびAzure Cognitive Searchについて
 * [alexa-gpt](https://github.com/k4l1sh/alexa-gpt) - AlexaでChatGPTを使用する方法のチュートリアル
 * [qxresearch-event-1](https://github.com/qxresearch/qxresearch-event-1) - Pythonの実践的なチュートリアルで、50以上のPythonアプリケーション（10行のコード）@xiaowuc2
 * [leedl-tutorial](https://github.com/datawhalechina/leedl-tutorial) - 《李宏毅深度学習教程》，PDFダウンロードアドレス：https://github.com/datawhalechina/leedl-tutorial/releases
 * [bpf-developer-tutorial](https://github.com/eunomia-bpf/bpf-developer-tutorial) - 学习 eBPF 的例子 | eBPF 開発者チュートリアルとナレッジベース：パフォーマンス、ネットワーク、セキュリティなど、さまざまなアプリケーションシナリオを小道具と例を使って一歩ずつ学ぶ
 * [tensorflow-nlp-tutorial](https://github.com/ukairia777/tensorflow-nlp-tutorial) - TensorFlowを使用してテキストの前処理から、Topic Models、BERT、GPT、LLMなどの最新モデルのダウンストリームタスクをまとめたDeep Learning NLPリポジトリです。
 * [langchain-kr](https://github.com/teddylee777/langchain-kr) - LangChain 公式ドキュメント、Cookbook、その他の実用例を基に作成した韓国語チュートリアルです。このチュートリアルを通じてLangChainをより簡単かつ効果的に使用する方法を学ぶことができます。
 * [llm-python](https://github.com/onlyphantom/llm-python) - 大規模言語モデル（LLMs）のチュートリアル＆サンプルスクリプト、ft. langchain、openai、llamaindex、gpt、chromadb＆pinecone
 * [Play-with-LLMs](https://github.com/evilpsycho/play-with-llms) - LLMを訓練し、評価するチュートリアル、およびRAG、Agent、Chainを活用してエンターテイニングなLLMアプリケーションを構築する方法について共有します。
 * [zero_to_gpt](https://github.com/vikparuchuri/zero_to_gpt) - 深層学習の知識がない状態からGPTの実装まで進んでください。


## NLP

 * [BioGPT](https://github.com/microsoft/biogpt) - マイクロソフトリサーチは、バイオメディカル研究文献にトレーニングされた大規模言語モデルであるBioGPTをリリースしました。このモデルは、PubMedQAで評価されたバイオメディカル文献からの質問に対して、人間以上の性能を発揮します。コードは...
 * [stanford_alpaca](https://github.com/tatsu-lab/stanford_alpaca) - スタンフォードのアルパカモデルをトレーニングするためのコードとドキュメンテーション、およびデータを生成するためのもの。
 * [openai-python](https://github.com/openai/openai-python) - OpenAI Pythonライブラリは、Python言語で書かれたアプリケーションからOpenAI APIに便利なアクセスを提供します。
 * [FlexGen](https://github.com/fminference/flexgen) - スループット志向のシナリオで単一のGPU上で大規模な言語モデルを実行する。
 * [RWKV-LM](https://github.com/blinkdl/rwkv-lm) - RWKVはトランスフォーマーレベルのLLMパフォーマンスを持つRNNです。GPTのように直接トレーニングすることができます（並列化可能）。つまり、RNNとトランスフォーマーの両方の長所を組み合わせており、優れたパフォーマンス、高速推論、VRAMの節約、高速トレーニング、"無限"のctx_len、そして無料の文埋め込みを提供しています。
 * [mario-gpt](https://github.com/shyamsn97/mario-gpt) - 「GPT2を用いたマリオレベル生成。『MarioGPT：大規模言語モデルを通じたオープンエンドのテキスト2レベル生成』の論文コード」https://arxiv.org/abs/2302.05981
 * [bilingual_book_maker](https://github.com/yihong0618/bilingual_book_maker) - AI翻訳を使用してバイリンガルのepub書籍を作成する
 * [llm-security](https://github.com/greshake/llm-security) - アプリ統合LLMを破る新しい方法
 * [GLM-130B](https://github.com/thudm/glm-130b) - GLM-130B：オープンなバイリンガル事前学習モデル（ICLR 2023）
 * [trlx](https://github.com/carperai/trlx) - 人間のフィードバックを介した強化学習による言語モデルの分散トレーニングのためのリポジトリ（RLHF）
 * [ChatGLM-6B](https://github.com/thudm/chatglm-6b) - ChatGLM-6B：オープンソースのバイリンガル対話言語モデル
 * [GPTSAN](https://github.com/tanreinama/gptsan) - 汎用スイッチトランスに基づく日本語言語モデル
 * [gpt-2](https://github.com/openai/gpt-2) - 論文「言語モデルは非監督マルチタスク学習者である」のコード
 * [gptlang](https://github.com/forrestchang/gptlang) - GPT-4によって実装された新しいプログラミング言語。
 * [BIG-bench](https://github.com/google/big-bench) - 言語モデルの能力を測定し、推測するための共同ベンチマークである「Beyond the Imitation Game」
 * [hlb-gpt](https://github.com/tysam-code/hlb-gpt) - 365行程度のコードで、ミニマリストで高速で実験に適したGPTライクなモデルの研究者用ツールベンチ。単一のA100で、wikitext-103で3.8以下の検証損失を約138秒で達成します。
 * [hn_summary](https://github.com/jiggy-ai/hn_summary) - ハッカーニュースのトップストーリーを大規模な言語モデルを使用して要約し、Telegramチャンネルに投稿します。
 * [transformers](https://github.com/huggingface/transformers) - 🤗 トランスフォーマー：Pytorch、TensorFlow、およびJAXの最新の機械学習技術。
 * [self-instruct](https://github.com/yizhongw/self-instruct) - 自己生成された指示データと事前学習済み言語モデルの整合性を取る。
 * [knowledge_gpt](https://github.com/mmz-001/knowledge_gpt) - あなたの文書に正確な回答と即座の引用を提供します。
 * [lqae](https://github.com/lhao499/lqae) - 言語量子化オートエンコーダー
 * [stanford_alpaca](https://github.com/tatsu-lab/stanford_alpaca#fine-tuning) - スタンフォードのアルパカモデルをトレーニングするためのコードとドキュメンテーション、およびデータを生成するためのもの。
 * [fib](https://github.com/r-three/fib) - 「bloom」、「opt-175b」、「t0」、そして「gpt-neox」は「事実に矛盾しない」ですか？新しいプレプリント！私たちは「事実上の不一致ベンチマーク」である「FIB」を紹介し、23のLLMを評価しました。@anisham197 @byryuer @mohitban47 @colinraffelと一緒に作業を行いました。📄 💾 🧵 ⬇️
 * [petals](https://github.com/bigscience-workshop/petals) - 🌸 自宅でBitTorrentスタイルで100B以上の言語モデルを実行します。ファインチューニングと推論はオフロードよりも最大10倍速くなります。
 * [emailGPT](https://github.com/lucasmccabe/emailgpt) - ChatGPTを使用してメールを簡単かつ迅速に生成するためのインターフェース。
 * [gpt3-contextual](https://github.com/uezo/gpt3-contextual) - OpenAI APIのGPT-3モデルを使用したコンテキストチャット
 * [camel](https://github.com/lightaime/camel) - CAMEL：大規模言語モデル社会の「心」探索のためのコミュニケーションエージェント
 * [pubmed-gpt](https://github.com/arokem/pubmed-gpt) - PubMedクエリの要約を作成するためにgptを使用してください。
 * [haltt4llm](https://github.com/manyoso/haltt4llm) - このプロジェクトは、幻覚を排除するための進歩を測定する共通のメトリックを作成する試みであり、これは多くの実際の目的においてLLMの広範な採用において最も深刻な現在の問題です。
 * [olm-datasets](https://github.com/huggingface/olm-datasets) - ウェブからのオンライン言語モデルの事前学習データを取得し、処理するためのパイプライン
 * [sat-reading](https://github.com/jquesnelle/sat-reading) - 新しいブログ：言語モデル vs SATリーディングテスト！彼らは約90％のスコアを獲得し、Flan-T5はGPT-3.5と同じくらい優れています！ファインチューニングはさらに良くなります！詳細はこちらで入手できます。新しいHuggingfaceデータセットには質問（+モデル）が含まれています。
 * [tenetlang](https://github.com/tenetlang/tenetlang) - 人間のために構築されたGPTデザイン言語
 * [ebook-GPT-translator](https://github.com/jesselau76/ebook-gpt-translator) - お気に入りのスタイルで読書をお楽しみください。
 * [srt-gpt-translator](https://github.com/jesselau76/srt-gpt-translator) - 字幕翻訳者
 * [datasloth](https://github.com/ibestvina/datasloth) - GPT-3による自然言語のPandasクエリとデータ生成。
 * [trl](https://github.com/lvwerra/trl) - 強化学習を用いて列車トランスフォーマー言語モデルを訓練する。
 * [ChatGPT-vs.-BERT](https://github.com/whu-zqh/chatgpt-vs.-bert) - 🎁[ChatGPT4NLU] ChatGPTとFine-tuned BERTの比較研究
 * [unilm](https://github.com/microsoft/unilm) - タスク、言語、モダリティを横断した大規模な自己教師あり事前学習
 * [document.ai](https://github.com/ganymedenil/document.ai) - ベクトルデータベースとGPT3.5に基づく汎用ローカル知識ベースのソリューション
 * [LAVIS](https://github.com/salesforce/lavis) - LAVIS - 言語・視覚知能のためのワンストップライブラリー
 * [gpt-subtrans](https://github.com/machinewrapped/gpt-subtrans) - OpenAI/ChatGPTを使用した字幕ファイルの翻訳プロジェクト
 * [paper-qa](https://github.com/whitead/paper-qa) - 引用文献付きドキュメントからの質問に答えるためのLLMチェーン
 * [guardrails](https://github.com/shreyar/guardrails) - 大規模言語モデルにガードレールを追加する。
 * [chatgpt-document-extraction](https://github.com/brandonrobertz/chatgpt-document-extraction) - 混沌としたテキスト文書を構造化されたJSONに変換するためのChatGPTを使用するための概念実証ツール
 * [h2ogpt](https://github.com/h2oai/h2ogpt) - H2O.aiが主導する世界最高のオープンソースGPTを作るムーブメントに参加しましょう。
 * [LLMZoo](https://github.com/freedomintelligence/llmzoo) - ⚡LLM Zooは、大規模言語モデルのデータ、モデル、評価基準を提供するプロジェクトです。⚡
 * [INSIGHT](https://github.com/oneil512/insight) - INSIGHTは医療研究ができる自律型AIです！
 * [h2o-llmstudio](https://github.com/h2oai/h2o-llmstudio) - H2O LLM Studio - LLMの微調整のためのフレームワークとノーコードGUI
 * [nlp-resume-parser](https://github.com/hxu296/nlp-resume-parser) - PDFからJSONへのNLPパワード、GPT-3対応の履歴書パーサー。
 * [chatgpt-clone](https://github.com/xtekky/chatgpt-clone) - より良いUIを備えたChatGPTインターフェース
 * [camel](https://github.com/lightaime/camel#data-hosted-on-hugging-face) - 🐫 キャメル：大規模言語モデル社会の「心」探索のためのコミュニケーションエージェント
 * [auto-redteam](https://github.com/traghav/auto-redteam) - 他のLLMsを使用してRedteaming LLMsを実行する
 * [self-ask](https://github.com/ofirpress/self-ask) - 「言語モデルにおける合成性ギャップの測定と縮小」のためのコードとデータ
 * [llm-lobbyist](https://github.com/johnnay/llm-lobbyist) - 論文「大規模言語モデルは企業ロビイストとして」（2023年）のコード：
 * [Transformers-Tutorials](https://github.com/nielsrogge/transformers-tutorials) - このリポジトリには、HuggingFaceのTransformersライブラリを使用して作成したデモが含まれています。
 * [dsp](https://github.com/stanfordnlp/dsp) - 𝗗𝗦𝗣：Demonstrate-Search-Predict。知識集約型NLPのための検索と言語モデルを組み合わせるためのフレームワーク。
 * [OpenAGI](https://github.com/agiresearch/openagi) - OpenAGI：LLMがドメインエキスパートと出会うとき
 * [GraphGPT](https://github.com/varunshenoy/graphgpt) - GPT-3を使用して非構造化テキストから知識グラフを推測する 🕵️‍♂️
 * [backend-GPT](https://github.com/theappletucker/backend-gpt) - 6/ 「バックエンドに必要なのはgptだけです」：バックエンドの作成を支援するためにLLMを使用してください。Wired：LLMは最近のスケールハッカソンからのインスピレーションプロジェクトであり、LLMバックエンドは状態をJSONブロブとして取得し、それに基づいて変更します...英語の説明。
 * [gpt-commit-summarizer](https://github.com/kanhari/gpt-commit-summarizer) - あなたのためにコミットメッセージを書くGPTベースのツール
 * [tesseract.js](https://github.com/naptha/tesseract.js) - 100以上の言語に対応した純粋なJavaScript OCR 📖🎉🖥
 * [subtitle-translator](https://github.com/gnehs/subtitle-translator) - ChatGPTを使用して字幕を翻訳する。
 * [vault-ai](https://github.com/pashpashpash/vault-ai) - OP Vault ChatGPT：OPスタック（OpenAI + Pinecone Vector Database）を使用して、ChatGPTに長期的な記憶を与えます。シンプルなReactフロントエンドを使用して、独自の知識ベースファイル（PDF、txtなど）をアップロードできます。
 * [ai-code-translator](https://github.com/mckaywrigley/ai-code-translator) - AIを使用して、1つの言語から別の言語へのコードの翻訳を行います。
 * [chatgpt-i18n](https://github.com/observedobserver/chatgpt-i18n) - AIの支援を受けて、ロケールのJSONファイルを翻訳してください。
 * [flux](https://github.com/transmissions11/flux) - LLMパワーツール
 * [platform](https://github.com/cognosisai/platform) - @erikschluntz、去年の夏に最初にGPT-3エージェントを使って遊んだとき（ここで例を見ることができます：JavaScript REPLにアクセスできるGPT-3エージェントに達成目標を与えることができます）、そこで私は終わりましたが、それほどでもないと思いました...
 * [minds](https://github.com/dosco/minds) - MindsJS - AIを活用したワークフローを簡単に構築
 * [FreedomGPT](https://github.com/ohmplatform/freedomgpt) - このコードベースは、ReactとElectronをベースにしたアプリで、MacとWindowsでオフラインかつプライベートにFreedomGPT LLMを実行するためのもので、Alpaca Loraに基づくチャットベースのインターフェースを使用します。
 * [chart-gpt](https://github.com/whoiskatrin/chart-gpt) - テキスト入力に基づいてチャートを作成するAIツール
 * [alpaca.cpp](https://github.com/antimatter15/alpaca.cpp) - ローカルで実行される指示に調整されたチャットスタイルLLM
 * [ChatARKit](https://github.com/trzy/chatarkit) - 自然言語でAR体験を作成するためにChatGPTを使用する。
 * [alpaca.cpp](https://github.com/rupeshs/alpaca.cpp) - ローカルで実行される指示に調整されたチャットスタイルLLM（Android / Linux / Windows / Mac）
 * [rust-bert](https://github.com/guillaume-be/rust-bert) - Rustネイティブの使用準備ができたNLPパイプラインとトランスフォーマーベースのモデル（BERT、DistilBERT、GPT2など）
 * [PentestGPT](https://github.com/greydgl/pentestgpt) - GPTによって強化されたペネトレーションテストツール
 * [gpttools](https://github.com/jameshwade/gpttools) - gpttoolsは、コードのドキュメント作成、テストの記述、コードの説明などを支援するために、パッケージ開発のためのgptstudioを拡張します。
 * [semantic-kernel](https://github.com/microsoft/semantic-kernel) - 最新のLLM技術を素早く簡単にアプリに統合する。
 * [CoCoGen](https://github.com/madaan/cocogen) - 「CodexがGPT-3やT5よりも優れたNLPタスクがあるが、自然言語問題を疑似Pythonに変換する必要がある」という研究結果が、@aman_madaan氏、@shuyanzhxyc氏、Yiming Yang氏、@gneubig氏らによる研究チームによって #emnlp2022 で発表されました。」
 * [github-summarizer](https://github.com/stevebauman/github-summarizer) - Chat GPTを使用したPHP GitHubサマライザー。
 * [LSL-snippets](https://github.com/panterapolnocy/lsl-snippets) - 私が書いた（または修正した）Second LifeのLinden Scripting Language（LSL）での小さなスクリプト。
 * [HealthGPT](https://github.com/stanfordbdhg/healthgpt) - 自然言語でApple Healthデータをクエリできます💬🩺
 * [pdf-epub-GPT-translator](https://github.com/jesselau76/pdf-epub-gpt-translator) - PythonとFlaskを学ぶ
 * [gpt-3](https://github.com/openai/gpt-3) - GPT-3: 言語モデルはフューショット学習者です。
 * [GPT-4-LLM](https://github.com/instruction-tuning-with-gpt-4/gpt-4-llm) - 「GPT-4による指示調整」に関する素晴らしいまとめがあります！@omarsar0が生成した指示に従うデータとフィードバックが公開され、優れた自己指導型LMSが生まれました。今後もGitHubリポジトリに追加していくので、お楽しみに！
 * [siri-chatgpt](https://github.com/liujch1998/siri-chatgpt) - 今、あなたはSiriを本物の#chatgptに変換することができます！単にこのショートカット（リポジトリ内のリンク⬇️）をあなたのiPhoneにダウンロードし、ショートカットアプリでスクリプトを編集して（つまり、APIキーをテキストボックスに貼り付ける）、そして、「ヘイSiri、chatgpt」と言ってください。お気に入りの質問をしてください！
 * [gpt-jargon](https://github.com/jbrukh/gpt-jargon) - ジャーゴンは、GPT-4のようなLLMによって指定され、実行される自然言語プログラミング言語です。
 * [practical-llms](https://github.com/aggregate-intellect/practical-llms) - #aiscllmworkshopは、チャットGPTのように自信を持って話をできるようになるための迅速な方法であり、最新かつ最高のLLMでアイデアから製品に移行する方法を迅速に学ぶための9時間連続の1時間のプレゼンテーションがあります！
 * [happycommit](https://github.com/jackbackes/happycommit) - HappyCommitは、OpenAIのGPT-3.5 Turbo言語モデルの力を活用して、意味のあるGitコミットメッセージを生成する楽しいツールです。
 * [JamesGPT](https://github.com/jconorgrogan/jamesgpt) - ChatGPTのジェイルブレイク：未来を予測し、政治や論争のあるトピックに意見を述べ、真実を評価することができます。LLMバイアスについてより理解するのに役立つかもしれません。
 * [ChatPaper](https://github.com/kaixindelele/chatpaper) - ChatGPTを使用してarXiv論文を要約する。ChatGPTを利用して論文の要約、編集、査読、査読返信を行い、研究プロセス全体を加速します。
 * [minichain](https://github.com/srush/minichain) - LSTMエンコーダ/デコーダとアテンションを使用したシーケンス・ツー・シーケンスモデル
 * [AutoPR](https://github.com/irgolic/autopr) - ChatGPTによって動力を得たAI生成のプルリクエストの問題を修正してください。
 * [privateGPT](https://github.com/imartinez/privategpt) - GPTの力を使って、100％プライベートで、データ漏洩の心配なしに文書とプライベートにやり取りできます。
 * [SalesGPT](https://github.com/filip-michalsky/salesgpt) - コンテキストに応じたAIセールスエージェントによる営業アウトリーチの自動化。
 * [automated-interpretability](https://github.com/openai/automated-interpretability) - LLMsは他のLLMsのニューロンを説明できますGPT-4（トークン、アクティベーション）ペアを示すことによってGPT-2ニューロンの振る舞いを説明するGPT-4による説明に基づいてニューロンの活性化をシミュレートするシミュレートされた活性化が実際の活性化とどの程度一致するかに基づいて説明のスコアを付ける
 * [evalplus](https://github.com/evalplus/evalplus) - LLM合成コードの厳密な評価のためのEvalPlus
 * [chat2plot](https://github.com/nyanp/chat2plot) - LLMを使用したチャットの可視化
 * [databerry](https://github.com/gmpetrov/databerry) - カスタムLLMエージェントを構築するためのノーコードプラットフォーム
 * [guidance](https://github.com/microsoft/guidance) - 大規模言語モデルを制御するためのガイダンス言語。
 * [SmartPilot](https://github.com/jaredkirby/smartpilot) - 与えられた質問に対して、OpenAIの言語モデルを活用して最適な回答を生成、分析、選択するPythonプログラム。
 * [developer](https://github.com/smol-ai/developer) - 100kコンテキストウィンドウが登場したことで、すべての開発者が自分自身のスモールデベロッパーを持つことが現実的になりました。
 * [pyllms](https://github.com/kagisearch/pyllms) - LLM（OpenAI、Anthropic、AI21、Cohere、Aleph Alpha、HuggingfaceHub、Google PaLM2）に接続するための最小限のPythonライブラリで、組み込みのモデルパフォーマンスベンチマークがあります。
 * [llm-numbers](https://github.com/ray-project/llm-numbers) - LLM開発者が知っておくべき数字
 * [StructGPT](https://github.com/rucaibox/structgpt) - 「StructGPT：構造化データに対して推論するための大規模言語モデルの一般的なフレームワーク」のコードとデータ
 * [scikit-llm](https://github.com/iryna-kondr/scikit-llm) - ChatGPTのような強力な言語モデルをscikit-learnにシームレスに統合して、テキスト分析タスクを強化します。
 * [zeno-build](https://github.com/zeno-ml/zeno-build) - LLMベースのアプリを構築し、評価し、分析し、理解する。
 * [privateGPT](https://github.com/imartinez/privategpt?utm_source=tldrnewsletter) - GPTの力を使って、100％プライベートで、データ漏洩の心配なしに文書とプライベートにやり取りできます。
 * [Chat-with-Document-s-using-ChatGPT-API-and-Text-Embedding](https://github.com/appointat/chat-with-document-s-using-chatgpt-api-and-text-embedding) - ChatGPT APIとテキスト埋め込みを使用してドキュメントとチャットする。
 * [qlora](https://github.com/artidoro/qlora) - QLoRA：量子化されたLLMの効率的なファインチューニング
 * [BriefGPT](https://github.com/e-johnstonn/briefgpt) - シンプルなGUIを備えた、文書をLLMに接続して要約やクエリを行うためのローカルホストツール。
 * [XrayGPT](https://github.com/mbzuai-oryx/xraygpt) - XrayGPT：医療ビジョン言語モデルを使用した胸部レントゲン写真の要約。
 * [Voyager](https://github.com/minedojo/voyager) - 大規模言語モデルを備えたオープンエンドの具現化エージェント
 * [gorilla](https://github.com/shishirpatil/gorilla) - ゴリラ：LLMのためのAPIストア
 * [sudolang-llm-support](https://github.com/paralleldrive/sudolang-llm-support) - VSCodeのSudoLang LLMサポート
 * [azure-search-openai-demo](https://github.com/azure-samples/azure-search-openai-demo) - Azureで実行される検索増強生成パターンのサンプルアプリで、検索にはAzure Cognitive Searchを使用し、ChatGPTスタイルやQ&A体験にはAzure OpenAIの大規模言語モデルを使用しています。
 * [infiniteGPT](https://github.com/emmethalm/infinitegpt) - InfiniteGPTは、OpenAI APIに無制限のサイズのテキストを入力できるPythonスクリプトです。もう面倒なコピー＆ペーストは不要です。マルチスレッド万歳！
 * [ToolBench](https://github.com/openbmb/toolbench) - ツール学習のための大規模言語モデルのトレーニング、提供、評価のためのオープンプラットフォーム。
 * [localGPT](https://github.com/promtengineer/localgpt) - GPTモデルを使用して、ローカルデバイス上のドキュメントとチャットできます。データはデバイスから出ることはなく、100％プライベートです。
 * [azure-search-openai-demo-csharp](https://github.com/azure-samples/azure-search-openai-demo-csharp) - Azureで実行されるRetrieval-Augmented Generationパターンのサンプルアプリで、検索にAzure Cognitive Searchを使用し、ChatGPTスタイルやQ&A体験にパワーを与えるためにAzure OpenAI大規模言語モデルを使用しています。
 * [llm](https://github.com/simonw/llm) - コマンドラインから大規模言語モデルにアクセスする。
 * [AutoGPTQ](https://github.com/panqiwei/autogptq) - GPTQアルゴリズムに基づくユーザーフレンドリーなAPIを備えた使いやすいLLMs量子化パッケージ。
 * [ALGO](https://github.com/zkx06111/algo) - 🚀ALGOをご紹介します。LLM生成のオラクルによって導かれるコード合成フレームワークです。ALGOに統合されたCodexは、コンテストレベルの問題において8倍、ChatGPTは1.3倍の性能を発揮します。さらに、ALGOは提出前にあなたの解決策を検証します！🧵📜:🔗:
 * [FairEval](https://github.com/i-eval/faireval) - 大規模言語モデルは公正な評価者ではありません- LLM（例：GPT-4）の採用の評価に偏りがあり、審判としてスコアリングすることに成功したバイアス- バイアスを軽減することにより、人間の判断により近い結果になります。repo:
 * [pdf2md](https://github.com/eiaserinnys/pdf2md) - このプロジェクト、pdf2mdは、学術論文のPDFファイルを消化しやすいテキストファイルに変換します。PDFファイルのレイアウトを分析して、アプリケーションが段落を再構成し、必要なコンテンツを翻訳します。最終的な結果は、便利にエクスポートされたテキストファイルです。
 * [ontogpt](https://github.com/monarch-initiative/ontogpt) - GPTベースのオントロジー抽出ツール、SPIRESを含む
 * [selefra](https://github.com/selefra/selefra) - マルチクラウドおよびSaaS環境の分析を提供するオープンソースのポリシーコードソフトウェアで、OpenAIによって強化された自然言語で洞察を得ることができます。
 * [haystack](https://github.com/deepset-ai/haystack) - :mag: Haystackは、TransformerモデルやLLMs（GPT-4、ChatGPTなど）を使用してデータと対話するためのオープンソースのNLPフレームワークです。Haystackは、複雑な質問応答、意味検索、テキスト生成アプリケーションなどを素早く構築するための本番用ツールを提供しています。
 * [WizardLM](https://github.com/nlpxucan/wizardlm) - Evol-Instructによって動力化された指示に従うLLMsのファミリー：WizardLM、WizardCoder
 * [sparrow](https://github.com/katanaml/sparrow) - MLによる文書からのデータ抽出
 * [lamini](https://github.com/lamini-ai/lamini) - 今日：🎉ChatGPTのようなLLMのトレーニングのためのホストされたデータジェネレータを開催しました🎉Laminiエンジンで生成されたデータでトレーニングされたオープンソースのLLM👉フルトレーニング、エンタープライズVPCなどを含む早期アクセス待ちリスト。
 * [long_stable_diffusion](https://github.com/sharonzhou/long_stable_diffusion) - 長い文章から画像を生成する、深層生成モデルのパイプラインを使用したテキストから画像生成（GPT-3とStable Diffusion）
 * [gpt-migrate](https://github.com/0xpayne/gpt-migrate) - 簡単にコードベースを別のフレームワークや言語に移行できます。
 * [openchat](https://github.com/imoneoi/openchat) - オープンチャット：オープンソースモデルにおいては、少ない方が良い
 * [WebGLM](https://github.com/thudm/webglm) - WebGLM：効率的なWeb強化型質問応答システム（KDD 2023）WebGLM：効率的なWeb強化型質問応答システム（KDD 2023）
 * [MetaGPT](https://github.com/geekan/metagpt) - マルチエージェントメタプログラミングフレームワーク：1行の要件を与えると、PRD、デザイン、タスク、リポジトリを返します。
 * [PdfGptIndexer](https://github.com/raghavan/pdfgptindexer) - OpenAIのGPT-2モデルとFAISS（Facebook AI Similarity Search）インデックスを使用したPDFテキストデータのインデックス化と検索のための効率的なツールであり、迅速な情報検索と優れた検索精度を実現するために設計されています。
 * [SuperAGI](https://github.com/transformeroptimus/superagi) - <⚡️> SuperAGI - 開発者第一のオープンソース自律型AIエージェントフレームワーク。開発者が迅速かつ信頼性の高い有用な自律エージェントを構築、管理、実行できるようにします。
 * [OpenLLM](https://github.com/bentoml/openllm) - 製造中のLLMの操作
 * [GPT-Bargaining](https://github.com/franxyao/gpt-bargaining) - アーキブ2023のコード：自己対戦とAIフィードバックからのインコンテキスト学習による言語モデルの交渉の改善
 * [dreamGPT](https://github.com/divergentai/dreamgpt) - 大規模言語モデル（LLM）からの幻覚を利用して、新奇性に基づく探索を行います。
 * [lnchat](https://github.com/litch/lnchat) - だから、私はLNChatというものを作りました。このアプリをノードに接続すると、"最新のチャネルは何ですか？"や"チャネルの概要を表示してください"などの平文の質問をすることができます。ChatGPTがそのギャップを埋めます。それはかなり楽しいですが、まだあまり役に立ちません。まだですが。
 * [ai00_rwkv_server](https://github.com/cgisky1980/ai00_rwkv_server) - ChatGPTよりも優れたローカライズされたオープンソースのAIサーバー。
 * [chinese-llm-benchmark](https://github.com/jeinlee1991/chinese-llm-benchmark) - 中文大模型能力評測ランキング：百度文心一言、chatgpt、阿里通義千問、讯飞星火、belle / chatglm6bなどのオープンソースの大規模モデルをカバーし、多次元能力評価を提供します。能力スコアのランキングだけでなく、すべてのモデルの元の出力結果も提供します！
 * [RankGPT](https://github.com/sunnweiwei/rankgpt) - ChatGPTは検索に優れていますか？LLMsは再ランキングエージェントとして優れています。
 * [smile](https://github.com/qiuhuachuan/smile) - SMILE: メンタルヘルスサポートのためのチャットGPTを介したシングルターンからマルチターンへの包括的な言語拡張
 * [C3SQL](https://github.com/bigbigwatermalon/c3sql) - 論文C3のコード：ChatGPTを用いたゼロショットテキストからSQLへの変換
 * [CodeDroidAI](https://github.com/fmxexpress/codedroidai) - ChatGPTやVicuna-13bのようなLLMを使用して、Delphi Object PascalとC++BuilderのためのコードとフォームをAIで生成します。
 * [ChatGPT-AutoHotkey-Utility](https://github.com/kdalanon/chatgpt-autohotkey-utility) - テキストを処理するためにChatGPT APIを使用するAutoHotkeyスクリプト。
 * [jekyll-chatgpt-translate](https://github.com/yegor256/jekyll-chatgpt-translate) - ChatGPTを使用したJekyllページの自動翻訳：必要なのはOpenAI APIキーだけです。
 * [autotranslate](https://github.com/lewangdev/autotranslate) - ビデオの転写と翻訳を、より速いささやき音声とChatGPTで行います。
 * [nextlint](https://github.com/sveltor/nextlint) - Svelte + tiptapで構築された、Notionのようなリッチテキストエディタ。ChatGPTを使用して、執筆体験を向上させます。
 * [chatgpt-api-python-sales](https://github.com/boburmirzo/chatgpt-api-python-sales) - AIパワードのPython APIを使用して、ChatGPTとLLM（Large Language Model）アプリを使ってリアルタイムの売上を検索してください。
 * [AiNiee-chatgpt](https://github.com/nekoparapa/ainiee-chatgpt) - 【mtool】または【Translator++】に基づく、chatgpt自動バッチ翻訳ツールで、主にさまざまなRPGゲームの翻訳に使用されます。
 * [openai-forward](https://github.com/beidongjiedeguang/openai-forward) - 🚀 大規模言語モデル向けの転送サービス · あなたのプライベートAIプロキシをワンクリックでデプロイ · LLMプロキシ · OpenAI APIリバースプロキシ
 * [gpt4-playground](https://github.com/nashex/gpt4-playground) - APIキーを使って実験を行うために、OpenAIのChatGPTとPlayground環境のクローンを作成しました。OpenAIのChatGPTとPlayground環境のクローンを作成しました。APIキーを使用して実験を行うことができます。
 * [github-pr-summary](https://github.com/flows-network/github-pr-summary) - ChatGPTを使用してGitHubのプルリクエストを要約およびレビューする
 * [SiriGPT](https://github.com/nicolodiamante/sirigpt) - SiriGPTのパワーを解き放て：ChatGPTの知能、DALL·Eの創造性、Whisperの正確な音声転写が結集したAppleデバイス向けのサポートで、20言語に対応します。
 * [chie](https://github.com/chieapp/chie) - ChatGPTや他のLLM向けの広範なデスクトップアプリ。
 * [chatnio](https://github.com/zmh-program/chatnio) - 📚 Zh-Websiteプロジェクトのドキュメント（vitepressを使用）
 * [Selective_Context](https://github.com/liyucheng09/selective_context) - ChatGPTや他のLLMに入力を圧縮して、2倍のコンテンツを処理し、メモリとGPUの時間を40％節約します。
 * [GPT-RAG](https://github.com/azure/gpt-rag) - 私たちが集めてきた学習を共有し、Azure OpenAIを安全にスケールするための方法を提供します。GPT-RAGコアは、Azureで実行される検索増強生成パターンであり、検索にはAzure Cognitive Searchを使用し、ChatGPTスタイルやQ&A体験にはAzure OpenAIの大規模言語モデルを活用しています。
 * [LLMforDialogDataGenerate](https://github.com/threecolorfr/llmfordialogdatagenerate) - 文書からChatGLM2やChatGPTのようなLLMを使用して対話データを生成します。
 * [Auto-i18n](https://github.com/linyuxuanlin/auto-i18n) - ChatGPTを使用して、Markdownファイルを複数の言語に自動翻訳します。
 * [chat-with-your-data-solution-accelerator](https://github.com/azure-samples/chat-with-your-data-solution-accelerator) - Azureで実行されるRAGパターンのためのソリューションアクセラレーターで、検索にはAzure Cognitive Searchを使用し、ChatGPTスタイルやQ&A体験にはAzure OpenAIの大規模言語モデルを活用しています。これには、最も一般的な要件とベストプラクティスが含まれています。
 * [RSS-GPT](https://github.com/yinan-c/rss-gpt) - ChatGPTを使用して、個別に設定したRSSフィードを要約するChatGPTを使用して、個別に設定したRSSフィードを要約します。
 * [one-api](https://github.com/songquanpeng/one-api) - OpenAIのキー管理および再配布システムは、Azure、Anthropic Claude、Google PaLM 2、智谱 ChatGLM、百度文心一言、讯飞星火认知、阿里通义千问、360 智脑、および腾讯混元をサポートしています。これは、二次的な配布管理キーに使用できる単一のAPIを使用しており、英語のUIを備えています。Dockerイメージがパッケージ化され、ワンクリックでデプロイできるため、すぐに使用することができます。
 * [Baichuan2](https://github.com/baichuan-inc/baichuan2) - 百川智能科技开发的一系列大型语言模型
 * [marqo](https://github.com/marqo-ai/marqo) - ヒト向けのベクトル検索。クラウド上でも利用可能 - cloud.marqo.ai
 * [khoj](https://github.com/khoj-ai/khoj) - 第2の脳のためのAIコパイロット。個人の知識ベースをオンラインまたはオフラインで検索し、チャットします。
 * [Otter](https://github.com/luodian/otter) - 🦦 オッターは、MIMIC-ITで訓練され、改善された指示の追跡能力と文脈に即した学習能力を示す、OpenFlamingo（DeepMindのFlamingoのオープンソース版）に基づくマルチモーダルモデルです。
 * [RWKV-Runner](https://github.com/josstorer/rwkv-runner) - RWKVの管理およびスタートアップツールで、完全自動化であり、わずか8MBです。また、OpenAI APIと互換性のあるインターフェースを提供します。RWKVは完全にオープンソースであり、商用利用が可能な大規模な言語モデルです。
 * [MNBVC](https://github.com/esbatmop/mnbvc) - MNBVC（Massive Never-ending BT Vast Chinese corpus）超大規模中文語料集。chatGPTのトレーニングに使用される40Tのデータに対応しています。MNBVCデータセットには、メインストリームの文化だけでなく、マイナーカルチャーやさらには火星語のデータも含まれています。MNBVCデータセットには、ニュース、作文、小説、書籍、雑誌、論文、台詞、投稿、ウィキ、古詩、歌詞、商品紹介、ジョーク、失敗談、チャットの記録など、あらゆる形式の純文本の中国語データが含まれています。
 * [Easydict](https://github.com/tisfeng/easydict) - シンプルでエレガントな辞書と翻訳のmacOSアプリ。すぐに使えるようになっており、オフラインOCR認識をサポートし、有道辞書、🍎 Appleシステム辞書、🍎 Appleシステム翻訳、ChatGPT、DeepL、Google、Bing、百度、火山翻訳に対応しています。単語の検索やテキストの翻訳に便利です。
 * [NExT-GPT](https://github.com/next-gpt/next-gpt) - NExT-GPT: あらゆるモーダルに対応した大規模言語モデルのコードとモデル
 * [TavernAI](https://github.com/tavernai/tavernai) - AI言語モデル（KoboldAI、NovelAI、Pygmalion、OpenAI chatgpt、gpt-4）の大気冒険チャット
 * [lmql](https://github.com/eth-sri/lmql) - 制約に基づいた効率的なLLMプログラミングのための言語。
 * [chatarena](https://github.com/farama-foundation/chatarena) - ChatArena（またはChat Arena）は、LLMs向けのマルチエージェント言語ゲーム環境です。目標は、AIのコミュニケーションと協力能力を開発することです。
 * [Data-Science-Roadmap](https://github.com/moataz-elmesmary/data-science-roadmap) - データサイエンスのロードマップ A から Z まで
 * [deepeval](https://github.com/confident-ai/deepeval) - LLMの評価フレームワーク
 * [inference](https://github.com/xorbitsai/inference) - 1行のコードを変更することで、OpenAI GPTを別のLLMに置き換えてください。Xinferenceを使用すると、必要なLLMを自由に使用できます。Xinferenceを使用すると、クラウド上、オンプレミス上、さらには自分のラップトップ上でも、オープンソースの言語モデル、音声認識モデル、マルチモーダルモデルを使用して推論を実行することができます。
 * [chameleon-llm](https://github.com/lupantech/chameleon-llm) - 「カメレオン：大規模言語モデルを用いたプラグアンドプレイの構成的推論のためのコード」
 * [HuatuoGPT](https://github.com/freedomintelligence/huatuogpt) - 華陀GPT、医者になるための言語モデルの飼いならしに向けて。（オープンな医療GPT）華陀GPT、医者になるための言語モデルの飼いならしに向けて。（オープンな医療GPT）
 * [DB-GPT-Hub](https://github.com/eosphoros-ai/db-gpt-hub) - 目的は、Text-to-SQLにおけるモデルのパフォーマンスを向上させるためのDB-GPTのモデル、データセット、ファインチューニング技術を含むリポジトリです。
 * [aidea-server](https://github.com/mylxsw/aidea-server) - AIdeaは、GPTおよび国産の大規模言語モデルである通義千問、文心一言などをサポートし、Stable Diffusion文生図、図生図、SDXL1.0、超解像度、画像着色などをサポートするオールインワンのアプリです。
 * [llm-viz](https://github.com/bbycroft/llm-viz) - GPTスタイルのLLMの3Dビジュアライゼーション
 * [AppAgent](https://github.com/mnotgod96/appagent) - アプリエージェント：スマートフォンユーザーとしてのマルチモーダルエージェント、スマートフォンアプリを操作するために設計されたLLMベースのマルチモーダルエージェントフレームワーク。
 * [AgentBench](https://github.com/thudm/agentbench) - エージェントとしてのLLMを評価するための包括的なベンチマーク
 * [NeumAI](https://github.com/neumtry/neumai) - Neum AIは、大規模なベクトル埋め込みの作成と同期を管理するための最高のフレームワークです。
 * [LLMs-from-scratch](https://github.com/rasbt/llms-from-scratch) - スクラッチからChatGPTのようなLLMを段階的に実装する
 * [TransformerLens](https://github.com/neelnanda-io/transformerlens) - GPTスタイルの言語モデルの機械的解釈可能性のためのライブラリ
 * [KwaiAgents](https://github.com/kwaikeg/kwaiagents) - 大規模言語モデル（LLM）を使用した一般的な情報検索エージェントシステム。
 * [MotionGPT](https://github.com/openmotionlab/motiongpt) - [NeurIPS 2023] MotionGPT：LLMを使用した統合されたモーション言語生成モデル「人間の動きは外国語のようなもの」[NeurIPS 2023] MotionGPT：LLMを使用した統合されたモーション言語生成モデル「人間の動きは外国語のようなもの」
 * [chatgpt-tool-hub](https://github.com/goldfishh/chatgpt-tool-hub) - オープンソースのChatGPTツールエコシステムで、ツールを組み合わせてChatGPTを使用し、自然言語で何でも行うことができます。
 * [LLMSurvey](https://github.com/rucaibox/llmsurvey) - 「大規模言語モデルの調査」という論文の公式GitHubページ。「大規模言語モデルの調査」という論文の公式GitHubページ。
 * [talk2arxiv](https://github.com/evanhu1/talk2arxiv) - ChatGPTを使用して、どんなArXiv論文でも話すことができます。
 * [autopilot](https://github.com/fjrdomingues/autopilot) - コードオートパイロットは、GPTを使用してコードベースを読み取り、コンテキストを作成し、タスクを解決するツールです。
 * [openai-forward](https://github.com/kenyony/openai-forward) - 🚀 大規模言語モデルの効率的な転送サービス · LLM向けの効率的な転送サービスです。 · OpenAI APIリバースプロキシ
 * [FasterTransformer](https://github.com/nvidia/fastertransformer) - トランスフォーマーに関連する最適化、BERT、GPTを含む。
 * [hacker-news-digest](https://github.com/polyrabbit/hacker-news-digest) - :newspaper: ChatGPTがハッカーニュースを要約します
 * [openai-translator](https://github.com/lancemoe/openai-translator) - OpanAIを使用する翻訳者。
 * [llm-paper-daily](https://github.com/xianshang33/llm-paper-daily) - 毎日更新されるLLM関連の論文。購読を歓迎します👏 お気に入りの場合は、ぜひ購読してください🌟 一つ
 * [Azure-OpenAI-demos](https://github.com/retkowsky/azure-openai-demos) - Azure Open AI（デモ、ドキュメンテーション、アクセラレータ）。
 * [chatWeb](https://github.com/skywalkerdarren/chatweb) - ChatWebはウェブページをクロールし、PDF、DOCX、TXTを読み取り、主要なコンテンツを抽出し、その内容に基づいて質問に答えたり、キーポイントを要約したりすることができます。
 * [StreamRAG](https://github.com/video-db/streamrag) - ビデオ検索とストリーミングエージェント 🕵️‍♂️
 * [gptscript](https://github.com/gptscript-ai/gptscript) - 自然言語プログラミング
 * [sgpt](https://github.com/muennighoff/sgpt) - SGPT：GPT文埋め込みによる意味検索SGPT：GPT文埋め込みによる意味検索
 * [visual-openllm](https://github.com/visual-openllm/visual-openllm) - 何かビジュアルチャットGPTのようなもの、文心一言のオープンソース版
 * [GPT-Fathom](https://github.com/gpt-fathom/gpt-fathom) - GPT-Fathomは、オープンソースで再現可能なLLM評価スイートであり、10以上の主要なオープンソースおよびクローズドソースのLLM、さらにはOpenAIの以前のモデルを20以上の厳選されたベンチマークで比較評価するためのものです。
 * [OpenCodeInterpreter](https://github.com/opencodeinterpreter/opencodeinterpreter) - OpenCodeInterpreterは、大規模な言語モデルとGPT-4コードインタープリターのような高度なプロプライエタリシステムとの間のギャップを埋めることを目的としたオープンソースのコード生成システムのスイートです。これにより、コード生成能力が大幅に向上します。
 * [flutter_chatgpt](https://github.com/wewehao/flutter_chatgpt) - Flutter ChatGPTアプリ。 Flutterによって実装されたchatgptチャットアプリは、カスタムモードとコンテキスト継続対話をサポートしています。 さらに、admob広告の構成、オープンスクリーン広告へのアクセス、インタースティシャル広告、バナー広告をサポートしています。
 * [ai00_server](https://github.com/ai00-x/ai00_server) - ChatGPTよりも優れたローカライズされたオープンソースAIサーバー。
 * [CipherChat](https://github.com/robustnlp/cipherchat) - LLMの安全性整合性の汎化能力を評価するためのフレームワーク
 * [bonito](https://github.com/batsresearch/bonito) - GPTなしでデータのための合成命令チューニングデータセットを生成するための軽量ライブラリ。GPTを使用せずにデータのための合成命令チューニングデータセットを生成するための軽量ライブラリ。
 * [azure-open-ai-embeddings-qna](https://github.com/ruoccofabrizio/azure-open-ai-embeddings-qna) - OpenAIを利用したドキュメント検索のためのシンプルなWebアプリケーション。このリポジトリは、ドキュメントから埋め込みベクトルを作成するためにAzure OpenAIサービスを使用しています。ユーザーの質問に回答するために、最も関連性の高いドキュメントを取得し、その後GPT-3、GPT-3.5を使用します。
 * [open-interpreter](https://github.com/openinterpreter/open-interpreter) - コンピューターのための自然言語インターフェース
 * [EvaluationPapers4ChatGPT](https://github.com/thu-keg/evaluationpapers4chatgpt) - ChatGPTのためのリソース、評価、検出論文
 * [private-gpt](https://github.com/zylon-ai/private-gpt) - GPTの力を使って、100％プライベートでデータ漏洩なしに文書とやり取りします。
 * [VLMEvalKit](https://github.com/open-compass/vlmevalkit) - 大規模なビジョン言語モデル（LVLMs）のオープンソース評価ツールキット、GPT-4v、Gemini、QwenVLPlus、30以上のHFモデル、15以上のベンチマークをサポート
 * [LLMPapers](https://github.com/kseseu/llmpapers) - 大規模言語モデル（ChatGPT、GPT-3、Codexなど）の論文や作品。
 * [AIGenPipeline](https://github.com/stoerr/aigenpipeline) - AIベースのコード生成パイプライン：AIを使用した体系的なコード生成のためのコマンドラインツールおよびフレームワーク、ビルドプロセスでの使用
 * [agency](https://github.com/neurocult/agency) - 🕵️‍♂️ 大規模言語モデル（LLM）や他の生成AIの潜在能力を探求したい開発者向けに設計されたライブラリ。クリーンで効果的、かつGo-idiomaticなアプローチを通じて。
 * [subtitle-translator-electron](https://github.com/gnehs/subtitle-translator-electron) - ↔️ ChatGPTを使用して字幕を翻訳します
 * [obsidian-ava](https://github.com/different-ai/obsidian-ava) - ObsidianでChatGPTを使用してノートを素早くフォーマットします。
 * [spacy-transformers](https://github.com/explosion/spacy-transformers) - 🛸 spaCyでBERT、XLNet、GPT-2などの事前学習済みトランスフォーマーを使用します。
 * [chatgpt-universe](https://github.com/cedrickchee/chatgpt-universe) - ChatGPT Universeは、ChatGPT、GPT、および大規模言語モデル（LLMs）に関する一時的なメモです。
 * [InternVL](https://github.com/opengvlab/internvl) - [CVPR 2024 口頭発表] InternVL Family: GPT-4Vに対する先駆的なオープンソースの代替手段。GPT-4Vに匹敵するパフォーマンスを発揮する商用利用可能なオープンソースモデル。
 * [GPTSwarm](https://github.com/metauto-ai/gptswarm) - 🐝 GPTSwarm: LLMエージェントを（最適化可能な）グラフとして
 * [nixtla](https://github.com/nixtla/nixtla) - Input: TimeGPT-1: 予測と異常検知のための本番向けの事前トレーニング済みの時系列基礎モデル。 100億以上のデータポイントでトレーニングされた時系列のための生成事前トレーニングトランスフォーマー。様々なドメインを正確に予測する能力を持っています。
 * [TransformerLens](https://github.com/transformerlensorg/transformerlens) - GPTスタイルの言語モデルの機械的解釈可能性のためのライブラリ
 * [BetterOCR](https://github.com/junhoyeo/betterocr) - 🔍 EasyOCR、Tesseract、およびPororoを🧠 LLMと組み合わせることで、より優れたテキスト検出が可能になります。
 * [viz-gpt](https://github.com/observedobserver/viz-gpt) - 表形式のデータセットからコンテキストデータの視覚化をチャットインターフェースで行う。AIデータの視覚化。
 * [ChatIE](https://github.com/cocacola-lab/chatie) - オンライン版は一時的に利用できません。キーを購入する余裕がないためです。ローカルでクローンを作成して実行することができます。注意：私たちはデフォルトのOpenAIキーを設定しています。キーがプランを超えて無効になった場合はお知らせください。応答速度はOpenAIに依存します。（時々、のように）
 * [RepoToText](https://github.com/jeremiahpetersen/repototext) - GitHubリポジトリ全体を1つの整理された.txtファイルに変換して、LLM（GPT-4、Claude Opus、Geminiなど）で使用します。
 * [ocular](https://github.com/ocularengineering/ocular) - AIパワードサーチとチャット for Orgs - ChatGptがGoogle検索と出会うと思ってくださいが、あなたのデータでパワードされています。
 * [AutoCoder](https://github.com/bin123apple/autocoder) - コード生成タスク向けに設計された新しいモデルを導入しました。そのヒューマンエバルベースデータセットでのテスト精度は、GPT-4 Turbo（2024年4月）およびGPT-4oを上回っています。
 * [langui](https://github.com/langbaseinc/langui) - あなたのAIのためのUI。あなたのGPT、生成AI、およびLLMプロジェクトに合わせたオープンソースのTailwindコンポーネント。
 * [go-translate](https://github.com/lorniu/go-translate) - Emacs上の翻訳機能。Google、Bing、deepL、ChatGPT、StarDict、Youdaoなど複数のエンジンをサポートしています。
 * [ChatTTS](https://github.com/2noise/chattts) - 日常会話のための生成型スピーチモデル。
 * [chatgpt-your-files](https://github.com/supabase-community/chatgpt-your-files) - pgvectorを使用して、ドキュメントを安全にチャットするための製品向けMVP
 * [auto-novel](https://github.com/fishhawk/auto-novel) - 軽小説機械翻訳サイト、ネット小説/ライトノベル/ローカル小説をサポート
 * [Q-Bench](https://github.com/q-future/q-bench) - ①[ICLR2024 スポットライト]（GPT-4V / Gemini-Pro / Qwen-VL-Plus + 16 OS MLLMs）低レベルビジョンと視覚品質評価におけるマルチモダリティLLM（MLLM）のベンチマーク。
 * [lowcode-vscode](https://github.com/lowcoding/lowcode-vscode) - ローコードツール、ChatGPTおよびその他のLLMをサポート
 * [HuatuoGPT-II](https://github.com/freedomintelligence/huatuogpt-ii) - 華陀GPT2、LLMsの医療適応のためのワンステージトレーニング（オープン医療GPT）
 * [AI-Vtuber](https://github.com/whoiswennie/ai-vtuber) - エンドツーエンドのAIアンカーモジュール、現在はbilibiliライブルームとの接続をサポートし、ローカルchatglm3とZhipu API言語モデルをサポートし、so-vits-svc、gpt-sovits、およびbert-vits2音声モデルをサポートしています。
 * [Recommendation-Systems-without-Explicit-ID-Features-A-Literature-Review](https://github.com/westlake-repl/recommendation-systems-without-explicit-id-features-a-literature-review) - 事前にトレーニングされた基礎推薦モデルの紙リスト
 * [mem0](https://github.com/mem0ai/mem0) - LLMsの長期記憶
 * [Github-Ranking-AI](https://github.com/yuxiaopeng/github-ranking-ai) - GitHubで最も人気のあるAIトピックのリポジトリのリストを、受け取ったスターの数に基づいてランク付けします。| AI関連トピックのGitHubリポジトリの人気ランキング、毎日自動更新。
 * [searchGPT](https://github.com/michaelthwan/searchgpt) - LLM / ChatGPT / OpenAI APIに基づいたソース参照付きのグラウンデッド検索エンジン。Web検索、ファイル内容検索などをサポートしています。
 * [rag-gpt](https://github.com/gpt-open/rag-gpt) - RAG-GPTは、LLMとRAG技術を活用して、ユーザーのカスタマイズされた知識ベースから学習し、幅広いクエリに対して文脈に即した回答を提供し、迅速かつ正確な情報検索を保証します。
 * [embedJs](https://github.com/llm-tools/embedjs) - LLMsと埋め込みを簡単に扱うためのNodeJS RAGフレームワーク
 * [AmadeusGPT](https://github.com/adaptivemotorcontrollab/amadeusgpt) - [NeurIPS 2023] 私たちは行動の自然言語の説明を機械実行可能なコードに変換します[NeurIPS 2023]私たちは行動の自然言語の説明を機械実行可能なコードに変換します
 * [fastapi](https://github.com/iimeta/fastapi) - 智元 Fast API は、さまざまなLLM APIを統一された形式、統一された規格、統一された管理で管理する、オールインワンのAPI管理システムです。これにより、機能、パフォーマンス、ユーザーエクスペリエンスの面で最高のレベルに達することができます。
 * [gtt](https://github.com/eeexun/gtt) - Google翻訳TUI（元々）。現在、Apertium、Argos、Bing、ChatGPT、DeepL、DeepLX、Google、Reversoをサポートしています。
 * [AlignBench](https://github.com/thudm/alignbench) - 大規模な多次元の中国語アライメント評価基準（ACL 2024）
 * [factool](https://github.com/gair-nlp/factool) - FacTool: 生成AIにおける事実性検出
 * [tree-of-thought-puzzle-solver](https://github.com/jieyilong/tree-of-thought-puzzle-solver) - 複雑な推論タスクを解決するための「思考の木（ToT）」フレームワークを使用したLLMs
 * [llmgraph](https://github.com/dylanhogg/llmgraph) - LLMを使用して知識グラフを作成します。
 * [Sunsimiao](https://github.com/x-d-lab/sunsimiao) - 🌿孫思邈中文医療大模型(Sunsimiao)：安全で信頼性があり、誰もが利用できる中文医療大模型を提供します。
 * [MiniCPM](https://github.com/openbmb/minicpm) - MiniCPM3-4B：GPT-3.5-Turboを凌駕するエッジサイドのLLM。
 * [cloudflare-rag](https://github.com/rafalwilinski/cloudflare-rag) - Cloudflare上で完全に構築されたフルスタック「PDFとチャットする」RAG（Retrieval Augmented Generation）アプリCloudflare上で完全に構築されたフルスタック「PDFとチャットする」RAG（Retrieval Augmented Generation）アプリ
 * [empower-functions](https://github.com/empower-ai/empower-functions) - 実世界のツールを使用するためのGPT-4レベルの関数呼び出しモデル
 * [HallusionBench](https://github.com/tianyi-lab/hallusionbench) - [CVPR'24] HallusionBench: あなたは何を考えているか見ていますか？それともあなたは何を見ているか考えていますか？GPT-4V(ision)、LLaVA-1.5、および他の多様性モデルに挑戦する画像コンテキスト推論ベンチマーク
 * [repo2txt](https://github.com/abinthomasonline/repo2txt) - Webベースのツールは、GitHubリポジトリの内容を1つのフォーマットされたテキストファイルに変換します。
 * [bigcodebench](https://github.com/bigcode-project/bigcodebench) - BigCodeBench：AGIに向けたコード生成のベンチマーク化
 * [FastGPT](https://github.com/labring/fastgpt) - FastGPTは、LLMsをベースに構築された知識ベースのプラットフォームで、データ処理、RAG検索、ビジュアルAIワークフローオーケストレーションなど、包括的な機能を提供しており、複雑な質問回答を簡単に開発および展開できます。
 * [guardrails](https://github.com/guardrails-ai/guardrails) - 大規模言語モデルにガードレールを追加する。
 * [E2B](https://github.com/e2b-dev/e2b) - AIアプリとAIエージェントのための安全なオープンソースクラウドランタイム
 * [MaxKB](https://github.com/1panel-dev/maxkb) - 🚀 大規模言語モデルとRAGに基づいたナレッジベースの質問応答システム。即座に使用可能で、モデルに中立的で柔軟な配置が可能で、第三者のビジネスシステムに迅速に組み込むことができます。
 * [SillyTavern](https://github.com/sillytavern/sillytavern) - パワーユーザー向けのLLMフロントエンド。
 * [instructor](https://github.com/jxnl/instructor) - LLMSのための構造化された出力
 * [instructor](https://github.com/instructor-ai/instructor) - LLMSのための構造化された出力
 * [buzz](https://github.com/chidiwilliams/buzz) - Buzzは、個人用コンピューターでオフラインで音声を書き起こし、翻訳します。OpenAIのWhisperによって動作します。
 * [ai](https://github.com/vercel/ai) - React、Svelte、Vue、およびSolidを使用してAI搭載アプリケーションを構築します。
 * [rivet](https://github.com/ironclad/rivet) - オープンソースのビジュアルAIプログラミング環境とTypeScriptライブラリ
 * [griptape](https://github.com/griptape-ai/griptape) - AIエージェントとワークフローのためのモジュラーPythonフレームワーク。思考の連鎖推論、ツール、メモリを備えています。
 * [agentic](https://github.com/transitive-bullshit/agentic) - どんなLLMとTypeScript AI SDKでも動作するAIエージェントの標準ライブラリ。
 * [faster-whisper](https://github.com/systran/faster-whisper) - CTranslate2を使用した高速なウィスパー転写
 * [tokencost](https://github.com/agentops-ai/tokencost) - 400以上のLLMに対する簡単なトークン価格の見積もり。TokenOps。
 * [TEN-Agent](https://github.com/ten-framework/ten-agent) - TENエージェントは、世界初のOpenAI Realtime API、RTCと統合されたリアルタイムマルチモーダルエージェントで、天気チェック、ウェブ検索、ビジョン、RAG機能を備えています。
 * [refact](https://github.com/smallcloudai/refact) - コーディング用のオープンソース大規模言語モデルの微調整と自己ホスティングのためのWebUI
 * [ax](https://github.com/ax-llm/ax) - 非公式のDSPyフレームワーク。Stanford DSP論文に基づいたLLMパワードエージェントと「エージェンティックワークフロー」を構築します。
 * [code-interpreter](https://github.com/e2b-dev/code-interpreter) - Python＆JS / TS SDKを使用して、AI生成コード/コード解釈を実行するためのAIアプリを作成します。
 * [atomic-agents](https://github.com/brainblend-ai/atomic-agents) - AIエージェントを原子的に構築します。


## Langchain

 * [langchain](https://github.com/hwchase17/langchain) - ⚡コンポーザビリティを通じてLLMsを使用したアプリケーションの構築⚡
 * [text-generation-webui](https://github.com/oobabooga/text-generation-webui) - LLaMA、llama.cpp、GPT-J、OPT、GALACTICAなどの大規模言語モデルを実行するためのグラディオWeb UI。
 * [llama_index](https://github.com/jerryjliu/llama_index) - LlamaIndex（GPTインデックス）は、あなたのLLMを外部データに接続するための中央インターフェースを提供するプロジェクトです。
 * [llama](https://github.com/facebookresearch/llama) - LLaMAモデルの推論コード
 * [GPTQ-for-LLaMa](https://github.com/qwopqwop200/gptq-for-llama) - GPTQを使用したLLaMAの4ビット量子化
 * [gptuber-by-langchain](https://github.com/karakuri-ai/gptuber-by-langchain) - GPTがYouTuberをやります
 * [intelgpt](https://github.com/phishing-hunter/intelgpt) - IntelGPTは、GPT3を使用して、URL、ファイルハッシュ、ドメイン名、IPアドレスなどの特定の入力を調べることができるコマンドラインツールです。
 * [knowledge-gpt](https://github.com/geeks-of-data/knowledge-gpt) - GPTや他の言語モデルを使用して、すべての情報源から知識を抽出します。情報源をインデックス化し、Q&Aセッションを作成します。
 * [llama_index_starter_pack](https://github.com/logan-markewich/llama_index_starter_pack) - このリポジトリは、llama_index（以前はgpt_indexと呼ばれていました）パッケージの非常に基本的なflask、streamlit、およびdockerの例を提供しています。
 * [xturing](https://github.com/stochasticai/xturing) - 自分自身のLLMsを構築し、制御してください。
 * [llama-int8](https://github.com/tloen/llama-int8) - LLaMAモデルの量子化推論コード
 * [point-alpaca](https://github.com/pointnetwork/point-alpaca) - 私たちは再現されたスタンフォードアルパカ7bから私たちの重みを解放します-合成指示データセットで微調整されたラマ。それは驚くほど良いです：（以下の結果は、最小の7bモデルからのものであることに注意してください。GPT-3は175bです）
 * [agentchain](https://github.com/jina-ai/agentchain) - 複雑なタスクを達成するために、推論のためにLLMを連鎖させ、複数の大規模モデルをオーケストレーションします。
 * [llm-strategy](https://github.com/blackhc/llm-strategy) - PythonをLLMsに直接接続する - データクラス＆インターフェース<->LLMs
 * [llama-cpp-python](https://github.com/abetlen/llama-cpp-python) - llama.cppのPythonバインディング
 * [basaran](https://github.com/hyperonym/basaran) - Basaranは、OpenAIテキスト補完APIのオープンソースの代替品です。Hugging Face Transformersベースのテキスト生成モデルに対して互換性のあるストリーミングAPIを提供します。
 * [llama-lab](https://github.com/run-llama/llama-lab) - @gpt_indexを使用してスペースを構築する場合は、こちらのフォームに記入してください！ ラマアギのクレジットは、ゼロからこのプロジェクトを立ち上げるのに役立ったローガンに与えられます。
 * [Ask-Anything](https://github.com/opengvlab/ask-anything) - ビデオ理解を備えたChatGPT！miniGPT4、StableLM、MOSSなど、さまざまなサポートされたLMもあります。
 * [VLog](https://github.com/showlab/vlog) - ChatGPT、CLIP、BLIP2、GRIT、Whisper、LangChainを使用して、ビデオをドキュメントに変換します。
 * [alpaca-lora](https://github.com/tloen/alpaca-lora) - 消費者向けハードウェアでLLaMAを指示調整してください。
 * [ClassGPT](https://github.com/benthecoder/classgpt) - 講義スライドのためのChatGPT
 * [KoAlpaca](https://github.com/beomi/koalpaca) - KoAlpaca：スタンフォードアルパカに基づく韓国のアルパカモデル（LLAMAとPolyglot-koを搭載）
 * [novice-ChatGPT](https://github.com/aiplaybookin/novice-chatgpt) - LangChain、LlamaIndex、Guardrails、AutoGPTなどを使用したChatGPT APIの使用方法
 * [ai-playground](https://github.com/mklarqvist/ai-playground) - 私はperplexityaiで遊んでいて、その仕組みを理解したかったので、@openai gpt-3.5turbo、@langchainai、@trychromaを使ってシンプルなオープンソースのクローンを作成し、ドキュメントも付けました。ぜひチェックしてください。
 * [alpaca-electron](https://github.com/itspi3141/alpaca-electron) - アルパカを実行するためのさらに簡単な方法
 * [langflow](https://github.com/logspace-ai/langflow) - ⛓️ LangFlowはLangChainのためのUIで、react-flowで設計されており、フローを実験しプロトタイプを作成するための簡単な方法を提供します。
 * [gpt4all-ts](https://github.com/nomic-ai/gpt4all-ts) - gpt4allとllamaのTypeScriptバインディング
 * [pyllamacpp](https://github.com/nomic-ai/pyllamacpp) - llama.cppとgpt4allの公式サポートされたPythonバインディング
 * [llama.cpp](https://github.com/ggerganov/llama.cpp) - C/C++でのFacebookのLLaMAモデルのポート
 * [dalai](https://github.com/cocktailpeanut/dalai) - ローカルマシンでLLaMAを実行する最も簡単な方法
 * [GenAI_LLM_timeline](https://github.com/hollobit/genai_llm_timeline) - ChatGPT、GenerativeAI、LLMsのタイムライン
 * [open_llama](https://github.com/openlm-research/open_llama) - OpenLLamaは、Meta AIのLLaMAの許可を得たオープンソースの再現版です。🦙「OpenLLaMAは、多くのタスクにおいてオリジナルのLLaMAやGPT-Jと同等の性能を発揮し、一部のタスクではそれらを上回る性能を発揮します。」👀
 * [pyCodeAGI](https://github.com/chakkaradeep/pycodeagi) - 私の現在の探求：PyCodeAGI、@LangChainAI #AIAgentは、目的に応じてPythonコンソールアプリを構築するもので、@OpenAI #GPT4との超能力を手に入れました。 「魔法のアプリ」を構築するように依頼したところ、創造的なものが構築されました。エラーは一つもありませんでした...
 * [Multimodal-GPT](https://github.com/open-mmlab/multimodal-gpt) - マルチモーダル-GPT
 * [snowChat](https://github.com/kaarthik108/snowchat) - あなたのスノーフレークデータベースでチャット - テキストからSQLへ
 * [DB-GPT](https://github.com/csunny/db-gpt) - ローカルGPTを使用して、データと環境をインタラクトし、データ漏洩なし、100％プライバシー、100％セキュリティを実現します。
 * [LaWGPT](https://github.com/pengxiao-song/lawgpt) - 🎉 LaWGPTのためのリポジトリ、中国法律知識に調整された中国ラマ。中文法律知識に基づく大規模言語モデル。
 * [InternGPT](https://github.com/opengvlab/interngpt) - InternGPT（iGPT）は、AIモデルを簡単に展示できるオープンソースのデモプラットフォームです。現在、DragGAN、ChatGPT、ImageBind、GPT-4のようなマルチモーダルチャット、SAM、インタラクティブな画像編集などをサポートしています。igpt.opengvlab.comでお試しください。
 * [chainlit](https://github.com/chainlit/chainlit) - 数分でPython LLMアプリを構築する ⚡️
 * [Flowise](https://github.com/flowiseai/flowise) - LangchainJSを使用してカスタマイズされたLLMフローを構築するためのドラッグ＆ドロップUI
 * [semantic-search-nextjs-pinecone-langchain-chatgpt](https://github.com/dabit3/semantic-search-nextjs-pinecone-langchain-chatgpt) - テキストファイルをベクトルに埋め込み、Pineconeに保存し、Next.js UIでGPT3とLangchainを使用して意味検索を可能にします。
 * [redpajama.cpp](https://github.com/togethercomputer/redpajama.cpp) - 元のllama.cppリポジトリを拡張して、redpajamaモデルをサポートするようにしてください。
 * [OgbujiPT](https://github.com/uogbuji/ogbujipt) - langchainやその他の手段を通じて、自己ホストされた大規模言語モデルを使用するためのツールキット
 * [godot-dodo](https://github.com/minosvasilias/godot-dodo) - GDScript生成のための大規模言語モデルのファインチューニング。
 * [eva](https://github.com/georgia-tech-db/eva) - よりシンプルで高速なAI搭載アプリケーションを構築するためのデータベースシステム
 * [LangChain-Tutorials](https://github.com/sugarforever/langchain-tutorials) - 挺好奇ChatGPT那种流式出力、頑張ってPythonのLangChainを使って実装しました。コンソールとWeb3アプリケーションの非同期の流れるような出力をカバーしています。Pythonの非同期プログラミングはまだ深く学ぶ必要があります🧐コード👇ビデオ共有👇bilibili:   #LangChain #ChatGPT #OpenAI
 * [chat-efficient](https://github.com/coefficientsystems/chat-efficient) - Streamlit、LangChain、オープンソースのLLMsを使用したDIY ChatGPT
 * [gpt-producer](https://github.com/juankysoriano/gpt-producer) - 「GPT-Producer」をご紹介します。デジタルピアノ、@OpenAI APIキー、そして#GPUを持って、アーティストになりましょう！ #musicgen #audiocraft #gpt @LangChainAI @MetaAI は、この可能性を実現するためのツールです！
 * [MedicalGPT](https://github.com/shibing624/medicalgpt) - MedicalGPT: ChatGPTトレーニングパイプラインを使用して独自の医療GPTモデルをトレーニングする。二次プレトレーニング、教師あり微調整、報酬モデリング、強化学習トレーニングを含む。
 * [rag-stack](https://github.com/psychic-api/rag-stack) - 🤖 VPC内にホストされたプライベートなChatGPTの代替を展開します。🔮 組織の知識ベースに接続し、企業のオラクルとして使用します。Llama 2、Falcon、GPT4AllなどのオープンソースのLLMをサポートしています。
 * [opencompass](https://github.com/internlm/opencompass) - OpenCompassは、50以上のデータセットに対応し、LLM評価プラットフォームです。さまざまなモデル（LLaMA、LLaMa2、ChatGLM2、ChatGPT、Claudeなど）をサポートしています。
 * [dolphin](https://github.com/kaleido-lab/dolphin) - LLMを基にした一般的なビデオ対話プラットフォーム、Video ChatGPTを含む。
 * [api-for-open-llm](https://github.com/xusenlinzy/api-for-open-llm) - オープンAIスタイルAPIは、チャットGPTと同様にLLM（Large Language Models）を使用して、オープンな大規模言語モデルを開くための統一されたバックエンドインターフェースです。
 * [AtomGPT](https://github.com/atomecho/atomgpt) - 中英文の事前トレーニング済みモデルは、ChatGPTと同じレベルを目指しています。
 * [litellm](https://github.com/berriai/litellm) - OpenAI、Azure、Cohere、Anthropic APIエンドポイントを呼び出すためのシンプルで軽量なパッケージ
 * [BayLing](https://github.com/ictnlp/bayling) - 「百聆」は、LLaMAに基づいた言語アライメント強化型の英語/中国語の大規模言語モデルであり、英語/中国語の能力に優れており、多言語や一般的なタスクなどのさまざまなテストでChatGPTの90%の性能を発揮します。BayLingは、英語/中国語のLLMであり、高度な言語アライメントを備えており、英語/中国語の生成、指示の追跡、マルチターンの対話において優れた能力を示します。
 * [auto-news](https://github.com/finaldie/auto-news) - 複数のソースから情報を収集する個人用ニュースアグリゲータ+ LLM（LangChain経由のChatGPT）による効率的な読書支援（ノイズを減らす）、ソースにはツイート、RSS、YouTube、ウェブ記事、Reddit、個人のジャーナルノートが含まれます。
 * [Zhongjing](https://github.com/suprityoung/zhongjing) - 大規模な事前学習コーパスとマルチターンの対話データセットからトレーニングされた、LLaMaベースの中国医学のChatGPT。LLaMaをベースにした中国医学のChatGPTは、大規模な事前学習コーパスとマルチターンの対話データセットからトレーニングされています。
 * [opencompass](https://github.com/open-compass/opencompass) - OpenCompassは、50以上のデータセットに対応し、LLM評価プラットフォームです。さまざまなモデル（LLaMA、LLaMa2、ChatGLM2、ChatGPT、Claudeなど）をサポートしています。
 * [gradioGPT](https://github.com/francescosaveriozuppichini/gradiogpt) - GradioとLangchainを使用した、次のChatGPTアプリのための簡単にハッキングできるテンプレート。
 * [FindTheChatGPTer](https://github.com/chenking2020/findthechatgpter) - ChatGPTが大人気で、AGIへの鍵となる重要な一歩を踏み出しました。このプロジェクトは、ChatGPTのオープンソースの代替品、テキストモデル、マルチモーダルモデルなどをまとめ、皆さんに便利を提供することを目的としています。
 * [gpt_academic](https://github.com/binary-husky/gpt_academic) - ChatGPT/GLMのための実用的なインタラクティブなインターフェースを提供し、論文の読み込み/校正/執筆の体験を特に最適化し、モジュール化されたデザインで、カスタムショートカットボタンと関数プラグインをサポートし、PythonやC++などのプロジェクトの解析と自動翻訳機能をサポートし、PDF/LaTex論文の翻訳と要約機能を提供し、さまざまなLLMモデルの並列問い合わせをサポートし、chatglm2などのローカルモデルにも対応しています。文心一言、moss、llama2、rwkv、claude2、通義千問、書生、讯飞星火などと互換性があります。
 * [Real_time_fallacy_detection](https://github.com/latent-variable/real_time_fallacy_detection) - リアルタイムの誤謬検出は、OpenAI WhisperとChatGPT/LLaMA/Mistralを使用して行われます。
 * [evadb](https://github.com/georgia-tech-db/evadb) - AIパワードアプリのためのデータベースシステム
 * [langchain4j](https://github.com/langchain4j/langchain4j) - LangChainのJavaバージョン
 * [llm-chain](https://github.com/sobelio/llm-chain) - 「llm-chain」は、大規模な言語モデルでチェーンを構築するための強力なRustのクレートであり、テキストの要約や複雑なタスクの完了が可能です。
 * [langroid](https://github.com/langroid/langroid) - マルチエージェントプログラミングでLLMsを活用する
 * [EasyEdit](https://github.com/zjunlp/easyedit) - LLM向けの使いやすい知識編集フレームワーク。
 * [llama_index](https://github.com/run-llama/llama_index) - LlamaIndex（旧GPT Index）は、LLMアプリケーションのためのデータフレームワークです。
 * [Alpaca-CoT](https://github.com/phoebussi/alpaca-cot) - 私たちは、指示調整データ（例：CoTデータ）、複数のLLM、およびパラメータ効率の良い手法（例：lora、p-tuning）のインターフェースを統一し、簡単に使用できるようにしました。私たちはオープンソースの愛好家に、このリポジトリで意義のあるPRを開始し、できるだけ多くのLLM関連技術を統合することを歓迎します。
 * [azure-openai-proxy](https://github.com/stulzq/azure-openai-proxy) - Azure OpenAIサービスプロキシ。OpenAI公式APIリクエストをAzure OpenAI APIリクエストに変換します。GPT-4、Embeddings、Langchainをサポートします。OpenAIからAzure OpenAIへのアダプター。
 * [code-review-gpt](https://github.com/mattzcarey/code-review-gpt) - LLMs（OpenAI GPT-3.5/4、Llama2、Azure AI）と埋め込みを活用した個人用コードレビューアー ⚡️ コードの品質を向上させ、本番環境でのバグを発生させる前にキャッチする 🚀
 * [GPTRouter](https://github.com/writesonic/gptrouter) - 複数のLLM（OpenAI、Anthropic、Azure）と画像モデル（Dall-E、SDXL）をスムーズに管理し、応答速度を向上させ、中断のない信頼性を確保します。
 * [dr-doc-search](https://github.com/namuan/dr-doc-search) - 本と対話する - GPT-3で作成された本と対話する - GPT-3で作成された
 * [talk-codebase](https://github.com/rsaryev/talk-codebase) - OpenAI、LlamaCpp、およびGPT-4-Allを使用して、コードベースとドキュメントとチャットするためのツール
 * [LLPhant](https://github.com/theodo-group/llphant) - LLPhant - OpenAI GPT 4を使用した包括的なPHP生成AIフレームワーク。LangchainとLLamaIndexに触発されました。
 * [Auto-Llama-cpp](https://github.com/rhohndorf/auto-llama-cpp) - Llama.cppを使用したAuto-GPT
 * [entaoai](https://github.com/akshata29/entaoai) - 自分のデータでチャットや質問を行う。自社のデータを迅速にアップロードし、OpenAIのサービスを使用してそのアップロードされたデータとチャットし、質問をするためのアクセラレータ。
 * [kani](https://github.com/zhudotexe/kani) - kani（カニ）は、ツールの使用/関数の呼び出しを備えたチャットベースの言語モデルのための高度にハッキング可能なマイクロフレームワークです。（NLP-OSS @ EMNLP 2023）kani（カニ）は、ツールの使用/関数の呼び出しを備えたチャットベースの言語モデルのための高度にハッキング可能なマイクロフレームワークです。（NLP-OSS @ EMNLP 2023）
 * [PIXIU](https://github.com/chancefocus/pixiu) - このリポジトリでは、初の金融向け大規模言語モデル（LLM）、調整データ、評価基準を紹介するオープンソースのリソース「PIXIU」を紹介しています。私たちの目標は、金融LLMを包括的に評価するために、常に前進し続けることです。
 * [open-webui](https://github.com/open-webui/open-webui) - Ollama用のChatGPTスタイルWebUI（以前のOllama WebUI）Ollama用ChatGPTスタイルWebUI（以前のOllama WebUI）
 * [CareGPT](https://github.com/wangrongsheng/caregpt) - 🌞 CareGPT（关怀GPT）は、医療向けの大規模言語モデルであり、数十の公開データセットとオープンソースの医療大規模言語モデルを組み合わせています。LLMのトレーニング、評価、展開などを含む医療LLMの迅速な発展を促進するために使用されています。Medical LLM、健康な未来のためのオープンソース。
 * [PIXIU](https://github.com/the-finai/pixiu) - このリポジトリは、初の金融向け大規模言語モデル（LLM）、インストラクションチューニングデータ、評価ベンチマークを特徴とするオープンソースリソースであるPIXIUを紹介しています。私たちの目標は、オープンを常に前進させることです。
 * [generative_ai_with_langchain](https://github.com/benman1/generative_ai_with_langchain) - Python、ChatGPT、およびその他のモデルを使用して大規模言語モデル（LLM）アプリを構築します。これはLangChainの生成AIに関する書籍のためのコンパニオンリポジトリです。
 * [llm-books](https://github.com/morsoli/llm-books) - LLMを使用してアプリケーションを構築する実践ノート
 * [langflow](https://github.com/langflow-ai/langflow) - ⛓️ Langflowは、各ノードが実行可能なユニットであるダイナミックグラフです。そのモジュラーでインタラクティブなデザインは、迅速な実験やプロトタイピングを促進し、創造性の限界に挑戦します。
 * [ChatLLM](https://github.com/yuanjie-ai/chatllm) - LLMとopenai＆langchainを楽しく使いこなす、文心一言、讯飞星火、腾讯混元、智谱ChatGLMなどをサポートします。
 * [MiniCPM-V](https://github.com/openbmb/minicpm-v) - MiniCPM-Llama3-V 2.5：あなたの電話でGPT-4VレベルのMLLMMiniCPM-Llama3-V 2.5：あなたの電話でGPT-4VレベルのMLLM
 * [LLamaTuner](https://github.com/jianzhnie/llamatuner) - 簡単で効率的なファインチューニングLLMs。（サポートされているLLama、LLama2、LLama3、Qwen、Baichuan、GLM、Falcon）大規模モデルの効率的な量子化トレーニング+展開。
 * [langtorch](https://github.com/li2109/langtorch) - 🔥 Javaを使用して、組み立て可能なLLMアプリケーションとワークフローを構築します。
 * [dialog](https://github.com/talkdai/dialog) - 簡単な展開とテストのためのRAG LLM Opsアプリ
 * [aikit](https://github.com/sozercan/aikit) - 🏗️オープンソースのLLMを簡単に微調整、構築、展開できます！
 * [llm-ui](https://github.com/llm-ui-kit/llm-ui) - LLMsのReactライブラリ
 * [search_with_ai](https://github.com/yokingma/search_with_ai) - 🤖 AIによる無料検索、💡 オープンソースのPerplexity、📍 Ollama/SearXNGのサポート、Dockerデプロイメントのサポート。AIモデルと検索エンジンがあなたの質問に答えることを可能にし、ローカルな大規模モデル(Ollama)や集約検索エンジンSearXNGをサポートし、Dockerデプロイメントをサポートします。
 * [GPT-Actions](https://github.com/anil-matcha/gpt-actions) - GPT Authは、カスタムGPT用のoauthを迅速にセットアップするためのユーザーフレンドリーなソリューションを提供します。
 * [langchain-swift](https://github.com/buhe/langchain-swift) - 🚀 Swift用LangChain。iOS、macOS、watchOS（一部）およびvisionOS向けに最適化されています。（ベータ版）
 * [RepoAgent](https://github.com/openbmb/repoagent) - 開発者やチームが素早くドキュメントを生成し、リポジトリを理解するのを支援するLLMパワードのリポジトリエージェント。
 * [obsidian-local-gpt](https://github.com/pfrankov/obsidian-local-gpt) - 最大限のプライバシーとオフラインアクセスのためのローカルオーラマとOpenAIのようなGPTの支援
 * [LangChain-Chinese-Getting-Started-Guide](https://github.com/liaokongvfx/langchain-chinese-getting-started-guide) - LangChainの中国語入門ガイド
 * [QiZhenGPT](https://github.com/cmkrg/qizhengpt) - QiZhenGPT：オープンソースの中国医療大規模言語モデル｜一个开源的中文医疗大语言模型
 * [azure-search-openai-javascript](https://github.com/azure-samples/azure-search-openai-javascript) - Azureで実行されるRetrieval Augmented GenerationパターンのTypeScriptサンプルアプリケーション。検索にはAzure AI Searchを使用し、ChatGPTスタイルやQ&A体験を可能にするためにAzure OpenAIとLangChainの大規模言語モデル（LLMs）を活用しています。
 * [LLaMA-Omni](https://github.com/ictnlp/llama-omni) - LLaMA-Omniは、Llama-3.1-8B-Instructをベースに構築された低遅延で高品質なエンドツーエンドの音声インタラクションモデルであり、GPT-4oレベルの音声機能を実現することを目指しています。
 * [text2text](https://github.com/artitw/text2text) - テキスト2テキスト：クロスリンガルNLP/Gツールキット
 * [llama.go](https://github.com/gotzmann/llama.go) - Input: llama.goは純粋なGolangでのllama.cppのようです！Output: llama.goは純粋なGolangでのllama.cppのようです！
 * [autolabel](https://github.com/refuel-ai/autolabel) - LLMでラベル付け、クリーニング、テキストデータセットを豊かにします。LLMでラベル付け、クリーニング、テキストデータセットを豊かにします。
 * [agentops](https://github.com/agentops-ai/agentops) - AIエージェントの監視、LLMコストの追跡、ベンチマーキングなどのためのPython SDK。CrewAI、Langchain、AutogenなどのほとんどのLLMやエージェントフレームワークと統合されています。
 * [CyberScraper-2077](https://github.com/itsowen/cyberscraper-2077) - LLM | OpenAI、Gemini＆Ollamaによって強力なウェブスクレイパーを搭載
 * [MLE-agent](https://github.com/mlsysops/mle-agent) - 🤖 MLE-Agent: シームレスなAIエンジニアリングと研究のための知的な仲間です。🔍 arxivとpaper with codeと統合して、より良いコード/研究計画を提供します🧰 OpenAI、Anthropic、Ollamaなどがサポートされています。:fireworks: Code RAG
 * [sage](https://github.com/storia-ai/sage) - 2分以内で任意のコードベースとチャット | 完全にローカルまたはサードパーティのAPIを介して
 * [rocketnotes](https://github.com/fynnfluegge/rocketnotes) - AIパワードのMarkdownノートアプリ - ベクトル埋め込みとLLMsを活用して個人のノートを作成 - 100％ローカルまたはクラウド上
 * [search2ai](https://github.com/fatwang2/search2ai) - オンラインでLLMの手助けをしてください。


## Unity

 * [ChatAI](https://github.com/diegocambiaso/chatai) - Mozillaコミュニティディレクトリー-すべてのMozilla貢献者の中央集約ディレクトリー！
 * [llama-hub](https://github.com/emptycrown/llama-hub) - コミュニティによるLLM用のデータローダーライブラリー - GPT Indexおよび/またはLangChainと一緒に使用するために
 * [AICommand](https://github.com/keijiro/aicommand) - UnityエディターとのChatGPTの統合
 * [AIShader](https://github.com/keijiro/aishader) - Unity用のChatGPTパワードシェーダージェネレーター
 * [ChatGPT-API-unity](https://github.com/mochi-neko/chatgpt-api-unity) - ChatGPTのチャット完了APIをUnity上の純粋なC#にバインドします。
 * [OpenAI-Unity](https://github.com/srcnalt/openai-unity) - OpenAI APIをUnityゲームエンジンで直接使用するための非公式なOpenAI Unityパッケージ。
 * [UnityChatGPT](https://github.com/dilmerv/unitychatgpt) - Chat GPTを使用したUnityの数例
 * [gptcache](https://github.com/zilliztech/gptcache) - @ferret_db @ossinsight @milvusio GPTキャッシュのバックエンドにferretdbを追加したいと思っています。ToDoリストに追加します。Milvusの開発者とコミュニティ全体を代表して、シャウトアウトありがとうございます！
 * [unity-AI-Chat-Toolkit](https://github.com/zhangliwei7758/unity-ai-chat-toolkit) - Unityを使用してAIチャット関連の機能を実現します。現在、このライブラリにはchatgpt、chatglmなどの大規模言語モデルのAPI呼び出しのコード実装が含まれており、また、Microsoft AzureおよびBaidu AIの音声サービス機能も実装されています。音声サービスはすべてWeb APIを使用しており、Windows/WebGL/Androidなどのプラットフォームをサポートしています。
 * [open-ai](https://github.com/orhanerday/open-ai) - OpenAI PHP SDK：最もダウンロードされ、フォークされ、貢献され、大規模なコミュニティによってサポートされ、PHP（Laravel、Symfony、Yii、Cake PHPまたは任意のPHPフレームワーク）SDKとして使用されるOpenAI GPT-3およびDALL-EのSDKです。また、chatGPTのようなストリーミングもサポートしています。（ChatGPT AIがサポートされています）
 * [betterscan-ce](https://github.com/marcinguy/betterscan-ce) - 多くのツール/スキャナーを使用したコードスキャン/ SAST/静的解析/リンティング+ One Report（コード、IaC）を使用したOpenAI GPT - Betterscan Community Edition（CE）
 * [open-saas](https://github.com/wasp-lang/open-saas) - スーパーパワーを持つReact＆Node.js用の無料のオープンソースSaaSアプリのスターター。本番環境に対応。コミュニティ主導。
 * [betterscan-ce](https://github.com/topcodersonline-solutions/betterscan-ce) - 多くのツール/スキャナーを使用したコードスキャン/ SAST/ 静的解析/リンティング + OpenAI GPT との1つのレポート（コード、IaC）- Betterscan Community Edition（CE）多くのツール/スキャナーを使用したコードスキャン/ SAST/ 静的解析/リンティング + OpenAI GPT との1つのレポート（コード、IaC）- Betterscan Community Edition（CE）
 * [betterscan-ce](https://github.com/tcosolutions/betterscan-ce) - 多くのツール/スキャナーを使用したコードスキャン/ SAST/ 静的解析/リンティング + OpenAI GPT との1つのレポート（コード、IaC）- Betterscan Community Edition（CE）多くのツール/スキャナーを使用したコードスキャン/ SAST/ 静的解析/リンティング + OpenAI GPT との1つのレポート（コード、IaC）- Betterscan Community Edition（CE）
 * [openai-kit](https://github.com/dylanshine/openai-kit) - OpenAI APIとやり取りするために使用されるコミュニティSwiftパッケージ


## Openai

 * [Auto-GPT](https://github.com/torantulino/auto-gpt) - 高度なゲームエンジニアリングプロジェクト - 立方体ボクセルゲームメーカー
 * [BlenderGPT](https://github.com/gd3kr/blendergpt) - OpenAIのGPT-4を使用してBlenderを制御するために英語のコマンドを使用してください。
 * [evals](https://github.com/openai/evals) - EvalsはOpenAIモデルの評価フレームワークであり、ベンチマークのオープンソースレジストリでもあります。
 * [VulChatGPT](https://github.com/ke0z/vulchatgpt) - バイナリ内の可能性のある脆弱性を見つけるために、IDA PRO HexRaysデコンパイラとOpenAI(ChatGPT)を使用してください。
 * [OpenChatKit](https://github.com/togethercomputer/openchatkit) - #openchatkitは、#chatgptの最初の#オープンソースの代替品です！🤯これは、元@openaiの人々（@togethercompute）によって構築された20bパラメーターモデルで、@aieleutherのgpt-neox-20bを使用してファインチューニングされました！🔗デモ：🐙gh：📽️ビデオ：@itakgol ↓
 * [chatgpt-python](https://github.com/labteral/chatgpt-python) - OpenAIのChatGPTの非公式Python SDK
 * [gpt-commit](https://github.com/markuswt/gpt-commit) - ChatGPTを使用してコミットメッセージを生成します。
 * [tiktoken](https://github.com/openai/tiktoken) - tiktokenは、OpenAIのモデルと一緒に使用するための高速なBPEトークナイザーです。
 * [wolverine](https://github.com/biobootloader/wolverine) - @denfromufa @openai 素晴らしいツールです！ ただ、私が言いたかったのは、ターミナルでgpt-4とチャットするためのツールです。つまり、次のようなものです。
 * [chatgpt-clone](https://github.com/amrrs/chatgpt-clone) - OpenAI APIとGradioを使用して、自分自身のChatGPTを構築する。
 * [pyChatGPT](https://github.com/terry3041/pychatgpt) - OpenAIのChatGPT APIの非公式Pythonラッパー
 * [davinci-functions](https://github.com/odashi/davinci-functions) - Pythonランタイム上でオブジェクトを生成するためにOpenAI GPTに問い合わせるライブラリ。
 * [chatgpt_ros](https://github.com/koichirokato/chatgpt_ros) - ChatGPT APIのためのROSラッパー
 * [genai](https://github.com/noteable-io/genai) - もしGPTがノート作成を手助けできたらどうでしょうか？
 * [GPTReview](https://github.com/iejmac/gptreview) - OpenAI GPTモデルを使用して、あなたのPRをレビューしてもらいましょう。
 * [scrapeghost](https://github.com/jamesturk/scrapeghost) - 👻 OpenAIのGPT APIを使用したウェブサイトスクレイピングのための実験的なライブラリ。
 * [Auto-GPT](https://github.com/significant-gravitas/auto-gpt) - GPT-4を完全に自律化するための実験的なオープンソースの試み。
 * [openai_tools](https://github.com/alleninstitute/openai_tools) - ChatGPT APIを使用してPDF出版物を探索するためのスクリプトの増加するセット。
 * [openai-cookbook](https://github.com/openai/openai-cookbook) - OpenAI APIの使用例とガイドの例
 * [disco-diffusion](https://github.com/alembics/disco-diffusion) - 現在OpenAI開發的AI模型中比較知名的有：#chatgpt、#midjourney、#stablediffusionchat。今天為大家更新5個好用的AI算法模型學習渠道，包括：1、神力中文AI算法市場、disco-diffusion型、百度文心ernie-vilg。
 * [chatgpt-mac](https://github.com/vincelwt/chatgpt-mac) - ChatGPT for Mac、あなたのメニューバーに住んでいます。
 * [everything-chatgpt](https://github.com/terminalcommandnewsletter/everything-chatgpt) - :mag: ChatGPTウェブアプリ（chat.openai.com）の裏側で何が起こるかを探索して、もちろんいくつかの推測も。
 * [userscripts](https://github.com/adamlui/userscripts) - 🐵 MTurk、ChatGPT、その他のGreasemonkeyユーザースクリプト。
 * [chatgpt-mirror](https://github.com/yuezk/chatgpt-mirror) - gpt-3.5-turboモデルに基づくChatGPTのミラー。
 * [ChatGPTCustomizer](https://github.com/soulhighwing/chatgptcustomizer) - ChatGPTCustomizerは、ChatGPT APIの力を使って、チャット体験をカスタマイズするのに役立ちます。
 * [gptproxy](https://github.com/xicilion/gptproxy) - GitLabのAPIキーを使用してOpenAI APIをプロキシする。
 * [cloudflare-proxy](https://github.com/barretlee/cloudflare-proxy) - Cloudflare WorkerはChatGPT APIを代理リクエストし、Streamストリーム出力をサポートしています。
 * [vscode-chatgpt](https://github.com/gencay/vscode-chatgpt) - 非公式のVisual Studio Code - OpenAI ChatGPT統合
 * [chatgpt-demo](https://github.com/ddiu8081/chatgpt-demo) - OpenAI APIをベースにしたデモリポジトリ。
 * [OpenGpt](https://github.com/futantan/opengpt) - 数秒で自分のChatGPTアプリを作成してください。
 * [chatgpt-vercel](https://github.com/ourongxing/chatgpt-vercel) - エレガントでパワフル。OpenAIとVercelによって動力を得ています。
 * [ts-chatgpt](https://github.com/takagimeow/ts-chatgpt) - 公式ChatGPT APIを使用してタイプされた純粋な応答を受け取るために作成されたライブラリ。
 * [openai-node](https://github.com/openai/openai-node) - OpenAI APIのためのNode.jsライブラリ
 * [nextjs-openai-doc-search](https://github.com/supabase-community/nextjs-openai-doc-search?og=v2) - Next.js、OpenAI、およびSupabaseによって動力化された独自のカスタムChatGPTスタイルのドキュメント検索を構築するためのテンプレート。
 * [gptagent.js](https://github.com/lgrammel/gptagent.js) - TS/JSでAIエージェントを構築する
 * [M5Unified_StackChan_ChatGPT](https://github.com/robo8080/m5unified_stackchan_chatgpt) - 「ChatGPT API搭載AIｽﾀｯｸﾁｬﾝ」です。
 * [whisper.cpp](https://github.com/ggerganov/whisper.cpp) - C/C++でのOpenAIのWhisperモデルのポート
 * [ChatGPT](https://github.com/lencx/chatgpt) - 🔮 ChatGPT デスクトップアプリケーション（Mac、Windows、Linux）
 * [chat-ai-desktop](https://github.com/sonnylazuardi/chat-ai-desktop) - TauriとRustを使用したMac＆Windowsメニューバー用非公式ChatGPTデスクトップアプリ
 * [chatgpt-dingtalk](https://github.com/eryajf/chatgpt-dingtalk) - 🔔 钉钉＆🤖 GPT-3.5であなたの仕事効率を直接向上させます🚀ダイレクトメッセージ、グループチャット、1対1のチャット、ロールプレイ、画像作成などの方法があります🚀
 * [go-openai](https://github.com/sashabaranov/go-openai) - OpenAI ChatGPT、GPT-3、GPT-4、DALL·E、Go用のWhisper APIラッパー
 * [feishu-chatgpt](https://github.com/leizhenpeng/feishu-chatgpt) - 🎒フェイシュー ×（GPT-3.5 + DALL·E + Whisper）= 飛ぶような仕事体験 🚀 音声対話、ロールプレイ、多様なトピックの議論、画像作成、表分析、文書のエクスポート 🚀
 * [k8sgpt](https://github.com/k8sgpt-ai/k8sgpt) - 誰でもKubernetes SREの超能力を与える
 * [ChatGPT-Proxy-V4](https://github.com/acheong08/chatgpt-proxy-v4) - 「puid」に基づくOpenAIのCloudflareバイパス
 * [chat-gpt-ppt](https://github.com/williamfzc/chat-gpt-ppt) - ChatGPT（または他のバックエンド）を使用して、すべてを1つの単一ファイルに自動生成するためにPPTを使用してください。
 * [CallGPT](https://github.com/dmingod/callgpt) - あなたのマシンからChatGPT APIを呼び出すための簡単な方法
 * [dev-gpt](https://github.com/sampink/dev-gpt) - dev-gpt、自動化されたPython開発者
 * [ruby-openai](https://github.com/alexrudall/ruby-openai) - OpenAI API + Ruby! 🤖❤️ 今、ChatGPTとWhisperも使えます...
 * [openai_pipe](https://github.com/aesthetikx/openai_pipe) - OpenAIへのUNIX風インターフェース
 * [gptchatteR](https://github.com/isinaltinkaya/gptchatter) - RでOpenAI GPTモデルとやり取りするための実験的で非公式なラッパー。
 * [askgpt](https://github.com/jbgruber/askgpt) - OpenAIのAPIエンドポイントをベースに構築されたチャットインターフェース
 * [openai](https://github.com/samterfa/openai) - このRパッケージは、Open AI APIへのSDKを提供します。
 * [ChatGptNet](https://github.com/marcominerva/chatgptnet) - .NET用のChatGPT統合ライブラリ
 * [Simple-ChatGPT-API-Desktop](https://github.com/cranot/simple-chatgpt-api-desktop) - デスクトップ用のシンプルなChatGPT API
 * [openai-gpt-dev-notes-for-cn-developer](https://github.com/easychen/openai-gpt-dev-notes-for-cn-developer) - OpenAI/GPTアプリを迅速に開発する方法：国内開発者のノート
 * [cheetah](https://github.com/leetcode-mafia/cheetah) - リモートSWE面接を受けるためのWhisper＆GPTベースのアプリ
 * [ChatGPTSwift](https://github.com/alfianlosari/chatgptswift) - Swiftを使用してChatGPT APIにアクセスする
 * [nitmgpt](https://github.com/deskbtm/nitmgpt) - nitmgpt（Notification-in-the-middle GPT）。ChatGPTを介して広告やスパム通知をフィルタリングします。
 * [iChatGPT](https://github.com/37ios/ichatgpt) - OpenAI ChatGPTのSwiftUIアプリ（iOS、iPadOS、macOS用）
 * [SwiftOpenAI](https://github.com/swiftbeta/swiftopenai) - Swiftで構築されたOpenAI API ❤️
 * [OpenAISwift](https://github.com/adamrushy/openaiswift) - これはChatGPTとOpenAI HTTP APIのラッパーライブラリです。
 * [whetstone.chatgpt](https://github.com/johniwasz/whetstone.chatgpt) - Open AI APIをラップするシンプルで軽量なライブラリ。
 * [subvert](https://github.com/aschmelyun/subvert) - ビデオから字幕、要約、章を数秒で生成する。
 * [carrot](https://github.com/xx025/carrot) - フリーチャットGPTサイトリスト。ここには、現在100以上のサイトが用意されており、無料で使えるChatGPTミラーサイトがたくさんあります。
 * [impressive-chatgpt](https://github.com/sw33tlie/impressive-chatgpt) - OpenAIのchatgptからの印象的で有用な結果のコレクション
 * [bbFuzzing.txt](https://github.com/reewardius/bbfuzzing.txt) - bbfuzzing.txtは、70％がopenai chatgptで生成されたユニークな語彙であり、残りの30％はbo0om、circuit、その他のbugbountersの辞書のコンピレーションです。#chatgpt
 * [chat-with-chatgpt](https://github.com/second-state/chat-with-chatgpt) - GitHubの問題コメントを介してChatGPTとチャットしてください。
 * [ChatGPT](https://github.com/hemulgm/chatgpt) - ChatGPTネイティブデスクトップアプリケーション（Windows、Mac、Android、iOS、およびLinux）
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt#%e5%ae%89%e8%a3%85%e6%b8%a0%e9%81%93) - ChatGPT畅聊プラグイン。すべてのエラーを解決し、私たちのAI体験を非常にスムーズで滑らかで効率的にします。さらに、監査のキャンセル、会話のクローン、ホームページの浄化など、さらに多くの強化機能を継続的に更新します。
 * [claude-to-chatgpt](https://github.com/jtsang4/claude-to-chatgpt) - このプロジェクトは、AnthropicのClaudeモデルのAPIをOpenAI Chat API形式に変換します。
 * [anse](https://github.com/anse-app/anse) - ChatGPT、DALL-E、Stable Diffusionのためのスーパーチャージド体験。
 * [chatgpt-demo](https://github.com/anse-app/chatgpt-demo) - ChatGPTの最小Web UI。
 * [casdoor](https://github.com/casdoor/casdoor) - CasbinとAIゲートウェイを搭載したオープンソースのIdentity and Access Management（IAM）/ Single-Sign-On（SSO）プラットフォームで、OAuth 2.0、OIDC、SAML、OpenAI ChatGPTをサポートするWeb UIがあります。
 * [JetChatGPT](https://github.com/thekharche/jetchatgpt) - OpenAI APIを使用したJetpack ComposeでのChatGPT
 * [cosmosdb-chatgpt](https://github.com/azure-samples/cosmosdb-chatgpt) - Azure Cosmos DBとAzure OpenAI ChatGPTサービスを組み合わせたサンプルアプリケーション
 * [ix](https://github.com/kreneskyp/ix) - 自律型GPT-4エージェントプラットフォーム
 * [openai-cloudflare](https://github.com/janlay/openai-cloudflare) - Cloudflareワーカーで実行されているOpenAI APIプロキシ。
 * [KeepChatGPT](https://github.com/xcanwin/keepchatgpt#%e5%85%b3%e4%ba%8e-%e5%8f%96%e6%b6%88%e5%ae%a1%e8%ae%a1-%e5%8a%9f%e8%83%bd) - これはChatGPTのスムーズなチャットと強化プラグインです。オープンソースで無料です。すべてのエラーをリフレッシュする必要がなくなるだけでなく、アクティブを維持し、監査をキャンセルし、会話をクローンし、ホームページを浄化し、大画面を表示し、フルスクリーンを表示し、言葉を尽くし、トラッキングをブロックし、日々進化するなど、多数の高度な機能があります。私たちのAI体験を非常にスムーズでシームレス、効率的、簡潔にします。
 * [cf-openai-azure-proxy](https://github.com/haibbo/cf-openai-azure-proxy) - Azure OpenAIサービスへのOpenAIのリクエストをプロキシするためのCloudflareワーカースクリプト
 * [polyglot](https://github.com/liou666/polyglot) - 🤖️ デスクトップAI言語練習アプリ
 * [k8sgpt-operator](https://github.com/k8sgpt-ai/k8sgpt-operator) - Kubernetesクラスター内の自動SREスーパーパワー
 * [obsidian-smart-connections](https://github.com/brianpetro/obsidian-smart-connections) - Obsidianでノートを使ってチャットしましょう！さらに、リアルタイムで最も関連性の高い情報を見ることができます！インタラクティブにやり取りし、整理された状態を維持しましょう。OpenAI ChatGPT、GPT-4＆Embeddingsによって動力を得ています。
 * [nextjs-openai-doc-search](https://github.com/supabase-community/nextjs-openai-doc-search) - Next.js、OpenAI、およびSupabaseによって動力化された独自のカスタムChatGPTスタイルのドキュメント検索を構築するためのテンプレート。
 * [reliableGPT](https://github.com/berriai/reliablegpt) - OpenAIから100％のアップタイムと信頼性を取得してください。レート制限、タイムアウト、API、キーエラーを処理します。
 * [pva-aoai-integration-solution](https://github.com/city-of-kobe/pva-aoai-integration-solution) - 中身は大したことないが自治体の取り組みとして興味深い。Azure OpenAIーーーこのリポジトリは、神戸市役所でのChatGPTの試行利用に向けて作成したフロー等をソリューション化し公開するものです。
 * [jp-azureopenai-samples](https://github.com/azure-samples/jp-azureopenai-samples) - 日本マイクロソフトからGPTのリファレンスアーキテクチャを公開。日本語のシナリオがベースになったサンプル実装が目白押しです！このリポジトリ押さえておけば色々捗りますね。ログとか認証周りまであるの嬉しい。～サンプル一覧～1. コールセンター向けGPTアシスタント…
 * [iChatGPT](https://github.com/37mobileteam/ichatgpt) - iOS、iPadOS、macOS用のOpenAI ChatGPT SwiftUIアプリ
 * [zod-gpt](https://github.com/dzhng/zod-gpt) - OpenAIとAnthropicモデルから、構造化され、完全に型付けされ、検証済みのJSON出力を取得してください。
 * [ai-beehive](https://github.com/hncboy/ai-beehive) - AI蜂巣は、Javaを使用したSpring Boot 3とJDK 17に基づいており、ChatGPT、OpenAi Image、Midjourney、NewBingなどの機能をサポートしています。
 * [cloudflare-reverse-proxy](https://github.com/gaboolic/cloudflare-reverse-proxy) - クラウドフレア逆プロキシ|OpenAI/ChatGPTフリーゲートプロキシ|GitHubフリーゲートプロキシ|GitHubダウンロード加速|Googleプロキシ|クラウドフレア万能プロキシ
 * [opengpt](https://github.com/gngpp/opengpt) - リバースエンジニアリングされた非公式のChatGPTプロキシ（Cloudflare 403アクセス拒否をバイパス）ChatGPTの非公式なリバースエンジニアリングプロキシ（Cloudflare 403アクセス拒否をバイパス）
 * [chatgpt-plus](https://github.com/yangjian102621/chatgpt-plus) - OpenAI APIを使用して実装されたChatGPTウェブアプリケーションです。一般版とロール版が含まれています。管理ダッシュボードが付属しており、Go + Vue3 + element-plusで実装されています。
 * [springboot-openai-chatgpt](https://github.com/274056675/springboot-openai-chatgpt) - 超級AI大脳は、Spring Bootアーキテクチャをベースにした、web、Android、IOS、H5などのマルチプラットフォームアプリケーションをサポートしています。OpenAIのChatGPTモデルを使用して、スマートなチャットボットを実現しています。ユーザーはインターフェース上でチャットボットと対話することができ、チャットボットはユーザーの入力に基づいて自動的に返信を生成します。また、絵を描くこともサポートしており、ユーザーがテキストを入力すると、自動的に図を作成することができます。将来的には、文心一言、通義千問、MOSSなどの国産AIモデルを統合し、継続的に更新しています。さらに多くの機能が解除されるのをお待ちしています。
 * [chatgpt-quickstart](https://github.com/azure-samples/chatgpt-quickstart) - Azure OpenAIとChatGPTを使用してチャットアプリケーションを構築してください。
 * [autoblogger](https://github.com/incomestreamsurfer/autoblogger) - これはChatGPT APIとStable Diffusion APIを使用して、完全に最適化されたブログ記事を作成し、自動的にWordPressに投稿する自動ブロガーです。
 * [chatserver-api](https://github.com/wooveep/chatserver-api) - OPENAIに基づいて開発されたChatGPT APIを使用したAIアシスタントシステムChatserver-web。ローカルデータベースのベクトルクエリに対応しています。バックエンドAPIサービスはGolang言語を使用しています。
 * [laravel-synth](https://github.com/blinq-dev/laravel-synth) - ChatGPTを使用してLaravelコードを生成します。
 * [openai-billing-query](https://github.com/woodchen-ink/openai-billing-query) - 単一ページのプロジェクトで、openai（chatgpt）の残高を一括で可視化クエリすることができます。総額、使用額、残高、使用比率、有効期限、GPT-4、カードとのバインドの有無を表示することができます。
 * [aks-openai](https://github.com/azure-samples/aks-openai) - グラフAPIアカウントのバルク機能を活用するためのAzure Cosmosのサンプル
 * [function-gpt](https://github.com/atinylittleshell/function-gpt) - これは、OpenAIのChatGPT APIを使用して関数呼び出しを処理するのに役立つTypeScriptライブラリです。
 * [chef-gpt](https://github.com/giacomogaglione/chef-gpt) - オープンAIとChatGPTによって動作するカスタマイズ可能なレシピジェネレーター。Next.Js、Tailwind CSS、Radix UI、Supabase Clerkで構築されています。
 * [gpt4docstrings](https://github.com/michaelistrofficus/gpt4docstrings) - OpenAI ChatGPTを使用してPythonのドックストリングを生成する！
 * [power-chatgpt](https://github.com/youngle316/power-chatgpt) - チャットGPTのためのパワーツール
 * [cg](https://github.com/25077667/cg) - 無料でOpenAIのchatGPTを使用したコミット
 * [ninja](https://github.com/gngpp/ninja) - 逆エンジニアリングされたChatGPTプロキシ
 * [free-chat](https://github.com/cnseniorious000/free-chat) - フォーク元：@anse-app/chatgpt-demoからフォークしました。インデックスサイトはhttps://free-chat.asia/です。
 * [Vontigo](https://github.com/vontigo/vontigo) - 🛸 VontigoはSvelteKitで構築されたオープンソースのCMSで、🤖 AI（ChatGPT）によるコンテンツ生成機能を備えています。高速なページ読み込みとシームレスなルーティングにより、Vontigoはカスタマイズ可能なテーマとテンプレートを備えたユーザーフレンドリーなインターフェースを提供します。
 * [7-docs](https://github.com/7-docs/7-docs) - 公開されているGitHubリポジトリをソースとして使用し、ChatGPTを通じてそれに関する質問をする
 * [chatgpt-pre-commit-hooks](https://github.com/dariuszporowski/chatgpt-pre-commit-hooks) - ChatGPTとOpenAIプラットフォームを利用して、コードベースへの変更を検証するためのプリコミットフックのコレクション。
 * [chatpad](https://github.com/deiucanta/chatpad) - ただのChatGPTのユーザーインターフェースではありません！
 * [chatgpt-nuxt](https://github.com/lianginx/chatgpt-nuxt) - Nuxt.jsフレームワークを使用したChatGPTクラスプロジェクトで、OpenAIとAzureの2つのAPIの切り替えをサポートし、ダークモード、英語、日本語の多言語切り替えをサポートしています。
 * [chat](https://github.com/libli/chat) - ユーザー管理機能を備えたChatGPT APIの透明なプロキシバックエンド
 * [chatgpt-nodejs-web](https://github.com/xingxin666/chatgpt-nodejs-web) - chatgpt nodejsサービスは、ChatGLM、GPT3.5、GPT4、GPTネットワーキング、Bing、Claude、Baidu Wenxin Yiyuなどのモデルを統合しています。
 * [chatgpt-ui](https://github.com/dvcrn/chatgpt-ui) - Elixir + LiveViewで書かれた、ビジネス向けの認証付きChatGPT UI
 * [chatgpt-ai-template](https://github.com/horizon-ui/chatgpt-ai-template) - 🧠 Horizon AI テンプレート - 最新のオープンソース ChatGPT UI AI テンプレート＆React、NextJS、Chakra UI のスターターキット
 * [chatgpt-history-export-to-md](https://github.com/mohamed-chs/chatgpt-history-export-to-md) - JSONファイルからChatGPTのデータエクスポート全体を簡単に抽出し、整形されたマークダウンファイルに変換するスクリプト。
 * [chatgpt-aoai](https://github.com/karleeov/chatgpt-aoai) - Azure OpenAIを使用して独自のChatGPTポータルを作成します。
 * [siyuan](https://github.com/siyuan-note/siyuan) - プライバシー重視、セルフホスト型、完全オープンソースの個人向け知識管理ソフトウェア。TypescriptとGolangで書かれています。
 * [Free-ChatGPT-API](https://github.com/mufeng510/free-chatgpt-api) - PandoraをベースにしたChatGPT APIにより、プールトークンの自動更新が実現されました。
 * [QChatGPT](https://github.com/rockchinq/qchatgpt) - 😎高い安定性、🧩プラグインのサポート、🌏リアルタイムのネットワーキングを備えたChatGPT QQロボット🤖 | ChatGPT、New Bing、Claude、Google Bard、gpt4free、One APIをサポートするQQロボットプラットフォーム
 * [novel](https://github.com/steven-tey/novel) - AIパワードのオートコンプリート機能を備えたNotionスタイルのWYSIWYGエディター。
 * [feishu-openai](https://github.com/connectai-e/feishu-openai) - 🎒 フェイシュー ×（GPT-4 + DALL·E-3 + Whisper）= フェイのような仕事体験 🚀 音声対話、役割演技、多様なトピックの議論、画像作成、表の分析、ドキュメントのエクスポート 🚀
 * [openai](https://github.com/betalgo/openai) - OpenAI .NET SDK - ChatGPT、Whisper、GPT-3、GPT-4、Azure OpenAI、およびDALL-E
 * [chatgpt](https://github.com/dirk1983/chatgpt) - 全ウェブ最も簡単に展開でき、最も高速な応答速度を持つChatGPT環境。PHP版はOpenAI APIを呼び出して質問と図の生成を行い、Streamストリームモード通信を採用し、生成と出力を同時に行います。フロントエンドはEventSourceを使用し、Markdown形式の解析と数式の表示をサポートし、コードには色付け処理があり、図の表示もサポートしています。ページのUIはシンプルで、コンテキストの連続した会話をサポートしています。ソースコードはわずかなファイルのみで、フレームワークは使用しておらず、すべてのPHPバージョンをサポートし、完全にオープンソースで、非常に簡単にカスタマイズできます。チュートリアルや関連リソースも完備しており、グループへの参加と交流を歓迎します。すべて無料です。
 * [Dingtalk-OpenAI](https://github.com/connectai-e/dingtalk-openai) - 🎒 钉钉 & 🤖 GPT-3.5 は、あなたの仕事の効率を直接的に向上させます 🚀 プライベートチャットやグループチャットの方法、一対一のチャットや連続チャットのモード、役割プレイ、画像作成などが可能です 🚀
 * [chatgpt-web](https://github.com/niek/chatgpt-web) - OpenAI APIを使用したChatGPTウェブインターフェース
 * [OpenAI-API-dotnet](https://github.com/okgodoit/openai-api-dotnet) - OpenAI GPT-3 APIにアクセスするための非公式なC#/.NET SDK
 * [ChatGPT_JCM](https://github.com/202252197/chatgpt_jcm) - OpenAI管理インターフェースは、OpenAIのすべてのインターフェース（モデル、画像、音声、ファインチューニング、ファイルなど）を集約し、操作することができます。Markdown形式（数式、グラフ、表など）もサポートしており、今後はOpenAIのインターフェースを少しずつ追加していきますので、皆さんのサポートをお願いします。右上のスターをクリックしていただけると嬉しいです。私はずっと更新し続けますので、一緒に学び、一緒に頑張り、一緒に成長しましょう。
 * [aiac](https://github.com/gofireflyio/aiac) - 人工知能インフラストラクチャのコード生成ツール。
 * [openai](https://github.com/anasfik/openai) - ChatGPTおよびすべてのOpenAI API（GPT、Dall-eなど）のためのDart/Flutter SDK
 * [chat](https://github.com/swuecho/chat) - チーム向けのチャットWebアプリ、ユーザー管理とレート制限を備えたSaaS、ChatGPT（OpenAI＆Azure）のサポート、Claudeまたはカスタムモデルチーム向けのチャットWebアプリで、ユーザー管理とレート制限を備えたSaaSです。ChatGPT（OpenAI＆Azure）をサポートし、Claudeまたはカスタムモデルを使用します。
 * [VirtualWife](https://github.com/yakami129/virtualwife) - VirtualWifeは、仮想的なデジタル人間のプロジェクトであり、まだ孵化段階にあり、改善が必要な点が多くあります。作者は、自分自身の「魂」を持つ仮想的なデジタル人間を作りたいと考えており、彼女と友達のように知り合うことができます。作者は、仮想的なデジタル人間が人間の生活に溶け込み、恋愛のアドバイザーや心理カウンセラーとして、人間の感情的なニーズを解決することを望んでいます。
 * [copilot-gpt4-service](https://github.com/aaamoon/copilot-gpt4-service) - Github CopilotのリクエストをChatGPTのリクエストに変換し、GPT-4モデルを無料で使用してください。Github CopilotのリクエストをChatGPTのリクエストに変換し、GPT-4モデルを無料で使用してください。
 * [PatrikZeros-ChatGPT-API-UI](https://github.com/patrikzudel/patrikzeros-chatgpt-api-ui) - OpenAI APIキーを使用して、ChatGPTと同じ体験ができる静的ウェブページです！
 * [NeuroGPT](https://github.com/neurogen-dev/neurogpt) - フリーチャットGPT 3.5 / チャットGPT 4 | フリーOpenAI / チャットGPT API
 * [ant-codeAI](https://github.com/sparrow-js/ant-codeai) - AIがコードを生成します。
 * [BestGPTs](https://github.com/agentops-ai/bestgpts) - トップランクのOpenAI GPTs
 * [chat_gpt_sdk](https://github.com/redevrx/chat_gpt_sdk) - フラッターチャットGPT
 * [chatgpt-web](https://github.com/chatgpt-web-dev/chatgpt-web) - ExpressとVue3を使用して構築されたChatGPT。このプロジェクトはChanzhaoyu/chatgpt-webからフォークされ、テナント管理とクラウドメッセージ同期機能が追加されています。MITライセンスに基づき、無料でオープンソースの学習に使用できます。
 * [tiktoken-go](https://github.com/pkoukk/tiktoken-go) - tiktokenのGoバージョン
 * [openai-proxy](https://github.com/unickcheng/openai-proxy) - openai-proxyは、OpenAI APIへのリクエストができないという問題を解決するために、中国のユーザー向けに提供されるソリューションです。
 * [hello-ai](https://github.com/xxxily/hello-ai) - 仕事を奪うのはAIではなく、AIツールの使用をマスターする人です。次元の低下は最も致命的です：あなたを破壊し、あなたに何の関係もありません。《三体》
 * [ChatGPT-Paper-Reader](https://github.com/talkingwallace/chatgpt-paper-reader) - このリポジトリは、PDF形式の研究論文を読んだり要約したりするのを手助けするシンプルなインターフェースを提供しています。読んだ後にいくつかの質問をすることができます。このインターフェースは、openai APIをベースに開発され、GPT-3.5-turboモデルを使用しています。
 * [lux-admin-vuetify3](https://github.com/yangjiakai/lux-admin-vuetify3) - Vue3.2、Vite4.1、TypeScript、Vuetify3、Chat GPT、Firebaseなどを基に最高の管理者を作成してください。
 * [gpt-tokenizer](https://github.com/niieani/gpt-tokenizer) - JavaScript BPE Tokenizer Encoder Decoder for OpenAIのGPT-2 / GPT-3 / GPT-4。OpenAIのtiktokenのポートに追加機能を備えています。
 * [tiktokenizer](https://github.com/dqbd/tiktokenizer) - OpenAPIトークナイザーのためのオンラインプレイグラウンド
 * [cognee](https://github.com/topoteretes/cognee) - AIアプリケーションとAIエージェントのためのメモリ管理
 * [finance](https://github.com/saleem-hadad/finance) - 💰 ChatGPTによって提供される無料のオープンソースの個人向けファイナンス追跡Webアプリ。
 * [chatgpt-web](https://github.com/xqdoo00o/chatgpt-web) - OpenAI APIをベースにした純粋なJavascript ChatGPTデモOpenAI APIをベースにした純粋なJavascript ChatGPTデモ
 * [one-api](https://github.com/martialbe/one-api) - Input: OpenAI interface management & distribution system, modified from songquanpeng/one-api. Supports more models, adds statistical pages, and improves function calls for non-OpenAI models.Output: OpenAI インターフェース管理＆配布システム、songquanpeng/one-apiを改良。より多くのモデルをサポートし、統計ページを追加し、OpenAI以外のモデルの関数呼び出しを改善します。
 * [lux-ui](https://github.com/yangjiakai/lux-ui) - Vue3.x、Vite5.x、TypeScript、Vuetify3.x、Chat GPTに基づいて最高の管理者を作成します。
 * [chatgpt-pro](https://github.com/eyucoder/chatgpt-pro) - ChatGPT-Proは、ChatGPTとDALL.Eのパワーを組み合わせた高度なアプリケーションです。
 * [AI-Functions](https://github.com/torantulino/ai-functions) - AIパワード機能マジック：GPTモデルを使用して再びコードを書く必要はありません！
 * [chat2api](https://github.com/lanqian528/chat2api) - Web上のChatGPTをOpenAI API形式に変換できるサービス。
 * [ai-codereviewer](https://github.com/freeedcom/ai-codereviewer) - AIコードレビュアー：AIパワードのコードレビューでGitHubのワークフローを強化しましょう！OpenAIのGPT-4 APIを使用してプルリクエストに対して知的なフィードバックや提案を受け取り、コードの品質を向上させ開発者の時間を節約します。
 * [yomo](https://github.com/yomorun/yomo) - 🦖 ジオ分散エッジAIインフラを構築するためのステートフルサーバーレスフレームワーク
 * [Gumroad-Landing-Page-Generator](https://github.com/peterw/gumroad-landing-page-generator) - このプロジェクトは、Pythonスクリプトを使用してGumroadサイトからデータをスクレイピングし、OpenAIのGPT-4モデルを使用してカラフルでデザインされたHTMLページを生成し、生成されたページをVercelにデプロイします。
 * [ninja](https://github.com/0x676e67/ninja) - 逆転させたChatGPTプロキシ
 * [chatgpt-adapter](https://github.com/bincooo/chatgpt-adapter) - OpenAI API標準インターフェースサーバーに、openai-api、bing、gemini、coze、および絵画など複数のAIを統合したチャットインターフェースを適応させました。
 * [ChatGPT.Net](https://github.com/pawanosman/chatgpt.net) - OpenAI API無料リバースプロキシ
 * [hisabi](https://github.com/hisabi-app/hisabi) - 💰 ChatGPTによって提供される無料のオープンソースの個人向け財務追跡Webアプリケーション。
 * [stride-gpt](https://github.com/mrwadams/stride-gpt) - 与えられたアプリケーションに基づいて脅威モデルを生成するためにOpenAIのGPTモデルを活用するAIパワードの脅威モデリングツール。STRIDE方法論に基づいています。
 * [generative-manim](https://github.com/360macky/generative-manim) - 🎨 ビデオ生成のためのGPT ⚡️
 * [celeris-web](https://github.com/kirklin/celeris-web) - Input: Celeris Webは、Vue 3、Vite、およびTypeScriptで構築された高性能でカスタマイズ可能なフロントエンド開発テンプレートです。最新の構文、コンポーネントおよびAPIの自動インポート、状態管理、中国語フォントのプリセット、国際化などが特徴です。 Output: Celeris Webは、Vue 3、Vite、およびTypeScriptで構築された高性能でカスタマイズ可能なフロントエンド開発テンプレートです。最新の構文、コンポーネントおよびAPIの自動インポート、状態管理、中国語フォントのプリセット、国際化などが特徴です。
 * [liboai](https://github.com/d7ead/liboai) - OpenAI API全体にアクセスするためのC++17ライブラリ。
 * [tiktoken-rs](https://github.com/zurawiki/tiktoken-rs) - GPTとtiktokenと一緒に使うための既製のトークナイザーライブラリ
 * [ai-commit](https://github.com/guanguans/ai-commit) - AIを使用して、従来のgitコミットメッセージを自動生成します。 - 使用 AI 自动生成约定式 git 提交信息。
 * [MatGPT](https://github.com/toshiakit/matgpt) - OpenAIのChatGPT APIにアクセスするためのMATLABアプリ
 * [one-hub](https://github.com/martialbe/one-hub) - OpenAI インターフェース管理＆配布システム、songquanpeng/one-api を改良。より多くのモデルをサポートし、統計ページを追加し、OpenAI以外のモデルの関数呼び出しを改善しました。
 * [whodb](https://github.com/clidey/whodb) - 軽量な次世代データエクスプローラー - Postgres、MySQL、SQLite、MongoDB、Redis、MariaDB＆Elastic Searchとチャットインターフェース
 * [sum4all](https://github.com/fatwang2/sum4all) - ウェブページ、ビデオ、画像の大規模モデルの要約
 * [Pet-GPT](https://github.com/hanzoe/pet-gpt) - Pet-GPTは、PyQtで書かれたデスクトップペットプログラムで、OpenAIのGPTを呼び出してコンテキスト対話を行い、その後自分からチャットを始めます！
 * [PureChat](https://github.com/hyk260/purechat) - PureChatは、ChatGPTを統合したチャットアプリであり、Vue3、Vite5、Electronで開発されています。
 * [OpenGPT-4o](https://github.com/kingnish24/opengpt-4o) - Input: OpenGPT 4oはOpenAI GPT 4oの無料の代替品です。
 * [aoai-realtime-audio-sdk](https://github.com/azure-samples/aoai-realtime-audio-sdk) - gpt-4oリアルタイム機能を使用するためのAzure OpenAIコードリソース
 * [inbox-zero](https://github.com/elie222/inbox-zero) - インボックスゼロに迅速に到達するためのオープンソースのメールアプリ。
 * [ToolJet](https://github.com/tooljet/tooljet) - ビジネスアプリケーションを構築するための低コードプラットフォーム。データベース、クラウドストレージ、GraphQL、APIエンドポイント、Airtable、Googleシート、OpenAIなどに接続し、ドラッグアンドドロップのアプリケーションビルダーを使用してアプリを構築します。JavaScript/TypeScriptを使用して構築されています。🚀
 * [AutoGPT](https://github.com/significant-gravitas/autogpt) - AutoGPTは、誰もが利用し、構築することができるアクセス可能なAIのビジョンです。私たちの使命は、あなたが重要なことに集中できるようにツールを提供することです。
 * [pr-agent](https://github.com/codium-ai/pr-agent) - 🚀CodiumAI PR-Agent: 自動プルリクエストの分析、フィードバック、提案などを行うAI搭載ツール！ 💻🔍
 * [whisper-diarization](https://github.com/mahmoudashraf97/whisper-diarization) - OpenAI Whisperに基づいたスピーカーダイアリゼーション付きの自動音声認識
 * [swarm](https://github.com/openai/swarm) - エルゴノミックで軽量なマルチエージェントのオーケストレーションを探求する教育フレームワーク。OpenAIソリューションチームによって管理されています。
 * [DashPlayer](https://github.com/solidspoon/dashplayer) - 英語学習者向けにカスタマイズされたビデオプレーヤー、ビデオを視聴し、リアルな文脈に没頭することで、英語力を簡単に向上させるお手伝いをします。#海外ドラマ #プレーヤー #リスニング
 * [logfire](https://github.com/pydantic/logfire) - Pythonをはじめとするシンプルな観測可能性！ 🪵🔥
 * [new-api](https://github.com/calcium-ion/new-api) - AIモデルのインターフェース管理および配布システムは、複数の大規模モデルをOpenAI形式で呼び出すことをサポートし、Midjourney Proxy、Suno、Rerankをサポートし、EasyPayプロトコルと互換性があります。個人または企業の内部管理および配布チャネルでのみ使用するために提供されており、商業目的には使用しないでください。このプロジェクトはOne APIをベースに二次開発されています。
 * [STranslate](https://github.com/zggsong/stranslate) - WPF/WPFで開発された即座に使用可能な翻訳OCRツール
 * [fastembed](https://github.com/qdrant/fastembed) - 高速で正確で軽量なPythonライブラリを使用して、最先端の埋め込みを作成します。
 * [openai-openapi](https://github.com/openai/openai-openapi) - OpenAI APIのOpenAPI仕様書
 * [openai-dotnet](https://github.com/openai/openai-dotnet) - OpenAI APIの公式.NETライブラリ
 * [stable-ts](https://github.com/jianfch/stable-ts) - OpenAIのWhisperを使用した転写、強制アラインメント、およびオーディオインデックス化
 * [async-openai](https://github.com/64bit/async-openai) - OpenAIのためのRustライブラリ
 * [o1-engineer](https://github.com/doriandarko/o1-engineer) - o1-engineerは、開発者がプロジェクトを効率的に管理および操作するために設計されたコマンドラインツールです。OpenAIのAPIの力を活用して、このツールはコード生成、ファイル編集、プロジェクト計画などの機能を提供します。
 * [simple-one-api](https://github.com/fruitbars/simple-one-api) - OpenAIと互換性のあるAPIをシームレスに統合し、素早くセットアップおよび展開するための単一の実行可能ファイルを使用します。
 * [WAAS](https://github.com/schibsted/waas) - Whisper as a Service（OpenAI Whisper用のキュー付きGUIおよびAPI）Whisper as a Service（OpenAI Whisper用のキュー付きGUIおよびAPI）
 * [coai](https://github.com/coaidev/coai) - 🚀 次世代AIワンストップ国際化ソリューション。🚀 下一代AI一站式B/C端解决方案，支持OpenAI，Midjourney，Claude，讯飞星火，Stable Diffusion，DALL·E，ChatGLM，通义千问，腾讯混元，360 智脑，百川 AI，火山方舟，新必应，Gemini，Moonshot 等模型，支持对话分享，自定义预设，云端同步，模型市场，支持弹性计费和订阅计划模式，支持图片解析，支持联网搜索，支持模型
 * [self-operating-computer](https://github.com/othersideai/self-operating-computer) - コンピュータを操作するためのマルチモーダルモデルを可能にするフレームワーク
 * [blinko](https://github.com/blinko-space/blinko) - オープンソースで、プライバシーを重視した、自己ホスト型の個人用ノートツール。TypeScriptを使用して構築されています。


## Others

 * [visual-chatgpt](https://github.com/microsoft/visual-chatgpt) - Visual ChatGPT: 視覚的な基盤モデルを用いた話し、描き、編集するための論文の公式リポジトリ。
 * [nanoGPT](https://github.com/karpathy/nanogpt) - 中規模のGPTのトレーニング/ファインチューニングに最もシンプルで最速のリポジトリ。
 * [gpt_index](https://github.com/jerryjliu/gpt_index) - Pythonでのテンソルと動的ニューラルネットワークは、強力なGPUアクセラレーションを備えています。
 * [nebullvm](https://github.com/nebuly-ai/nebullvm) - あなたのAIシステムのパフォーマンスを最適化するためのプラグアンドプレイモジュール 🚀
 * [gpt-2-output-dataset](https://github.com/openai/gpt-2-output-dataset) - 研究における検出、バイアスなどのためのGPT-2出力のデータセット
 * [IATelligence](https://github.com/fr0gger/iatelligence) - IATelligenceは、PEファイルのIATを抽出し、APIやATT＆CKマトリックスに関するより詳細な情報を取得するためにGPTにリクエストするPythonスクリプトです。
 * [ColossalAI](https://github.com/hpcaitech/colossalai) - 大規模なAIモデルをより安価で、より速く、そしてよりアクセスしやすくすること
 * [aoc-gpt](https://github.com/max-sixty/aoc-gpt) - GPT-3を使ってAdvent of Codeのパズルを解決する。
 * [EdgeGPT](https://github.com/acheong08/edgegpt) - マイクロソフトのBing Chat AIの逆解析されたAPI
 * [chatGPT-python-elm](https://github.com/vrescobar/chatgpt-python-elm) - ChatGPTによって完全に生成されたリポジトリで、READMEの最初の行のように説明されたこのリポジトリをチェックアウトしたと信じられています。
 * [Sekiryu](https://github.com/20urc3/sekiryu) - お気に入りのデコンパイラとChatGPTを使用したバイナリファイルの自動逆コンパイルと解析。
 * [xiaogpt](https://github.com/yihong0618/xiaogpt) - bilibiliのバックエンドソースコード
 * [gpt-wpre](https://github.com/moyix/gpt-wpre) - GPT-3を用いた全プログラム逆解析
 * [chatgpt_academic](https://github.com/binary-husky/chatgpt_academic) - 科学研究に特化したChatGPTの拡張機能で、学術論文の校正体験を特別に最適化し、カスタムショートカットボタンをサポートし、Markdown表の表示をサポートし、Tex式の二重表示をサポートし、コード表示機能を完備し、ローカルPythonプロジェクトの解析機能/自己解析機能を追加しました。
 * [chatgpt-api](https://github.com/taranjeet/chatgpt-api) - このリポジトリには、さまざまなサイトを解析するためのコードが含まれています。
 * [babyagi](https://github.com/yoheinakajima/babyagi) - 自律エージェントで遊ぶための3つのクールなプロジェクト：- auto-gpt：babyagi：camel：あなたのお気に入りはどれですか？
 * [metaseq](https://github.com/facebookresearch/metaseq) - 外部の大規模な作業のためのリポジトリ
 * [ThreatResearch](https://github.com/securityjoes/threatresearch) - 最新のインシデント対応中、@charleslomboniは#ghidraに#chatgptを実装しました。私たちはコードをリリースしましたので、あなたも使えます。それをaskjoeと呼んでいます🤠楽しんで共有してください。
 * [stable-diffusion-webui](https://github.com/automatic1111/stable-diffusion-webui) - 安定した拡散Web UI
 * [examples](https://github.com/mosaicml/examples) - 高速かつ柔軟なリファレンスベンチマーク
 * [ChatGDB](https://github.com/pgosar/chatgdb) - GDBまたはLLDBデバッガー内でChatGPTのパワーを利用してください！
 * [whisper](https://github.com/openai/whisper) - 大規模な弱い教師付き学習による堅牢な音声認識
 * [point-e](https://github.com/openai/point-e) - 3Dモデル合成のためのポイントクラウド拡散
 * [stable-diffusion-webui-chatgpt-utilities](https://github.com/hallatore/stable-diffusion-webui-chatgpt-utilities) - UIから直接ChatGPTを使用できるようになりました。
 * [reflexion](https://github.com/noahshinn024/reflexion) - 反省：動的なメモリと自己反省を持つ自律エージェント
 * [stackexplain](https://github.com/shobrook/stackexplain) - ChatGPTを使用してエラーメッセージを説明してください。
 * [nanoChatGPT](https://github.com/sanjeevanahilan/nanochatgpt) - ガンベル・ソフトマックスのトリックを使ったnanoGPTの上に粗いRLHF層を重ねたもの。
 * [flash-attention](https://github.com/hazyresearch/flash-attention) - 高速でメモリ効率の良い正確なアテンション
 * [cgpt_exceptions](https://github.com/fkhan0520/cgpt_exceptions) - 例外が発生した際に自動的にChatGPTからヘルプを取得するPythonパッケージを作成しました。ぜひチェックしてください！
 * [go-gpt3](https://github.com/sashabaranov/go-gpt3) - Amazon Web ServicesへのPythonインターフェース
 * [talkGPT](https://github.com/chenyukang/talkgpt) - ChatGPTと話すのを手助けする簡単なPythonプログラム、スポークン英語の練習に役立ちます...
 * [XX-Net](https://github.com/xx-net/xx-net) - GFWをバイパスするためのプロキシツール。
 * [ida_gpt](https://github.com/mayerdaniel/ida_gpt) - @hexrayssaに#chatgptを統合するためのコードを入力し、GPTの機能の説明をコメントし、変数と関数名をあなたのためにリネームします。
 * [pubmedgpt](https://github.com/stanford-crfm/pubmedgpt) - MLトレーニング効率のための構成方法
 * [nanoGPT](https://github.com/karpathy/nanogpt?utm_source=tldrnewsletter) - 中規模のGPTのトレーニング/ファインチューニングに最もシンプルで最速のリポジトリ。
 * [slither](https://github.com/crytic/slither) - Solidityの静的解析ツール
 * [bpy-chat-gpt](https://github.com/joshuaknauber/bpy-chat-gpt) - シンプルなブレンダーアドオンに統合されたチャットGPT API
 * [scrapbox_chatgpt_connector](https://github.com/nishio/scrapbox_chatgpt_connector) - ChatGPTはScrapboxを読みます。
 * [Partial-English-Subtitle-Translation](https://github.com/goldengrape/partial-english-subtitle-translation) - 各位英語學習者，我又帶來了學習英語的工具，這次是只翻譯字幕中的生詞，自己選擇難度。本次的重點是通過GPT翻譯出單詞在句子中的含義。網頁版：
 * [GilgaiDetection](https://github.com/geezacoleman/gilgaidetection) - ギルガイ検出のための単純な色閾値処理
 * [chatgpt_stock_report](https://github.com/ddobokki/chatgpt_stock_report) - その日の証券会社レポートをチャットGPTを活用して要約するレポート
 * [DeeperSpeed](https://github.com/eleutherai/deeperspeed) - DeepSpeedは、分散トレーニングを簡単、効率的、効果的にする深層学習最適化ライブラリです。
 * [MM-REACT](https://github.com/microsoft/mm-react) - MM-REACTの公式リポジトリ
 * [WavCaps](https://github.com/xinhaomei/wavcaps) - このリポジトリには、WavCapsデータセットのメタデータと、下流タスクのためのコードが含まれています。
 * [Painter](https://github.com/baaivision/painter) - ペインター＆SegGPTシリーズ：BAAIのビジョン基盤モデル
 * [Auto-GPT](https://github.com/kanecohen/auto-gpt) - GPT-4を完全に自律化するための実験的なオープンソースの試み。
 * [Robo-GPT](https://github.com/rokstrnisa/robo-gpt) - 自律的にGPT-4モデルを実行するのを支援するシンプルで拡張可能なプログラム。
 * [gpt-4-search](https://github.com/andylokandy/gpt-4-search) - 200行のコードでGoogle検索を備えたコマンドラインGPT-4 REPL
 * [symbolicai](https://github.com/xpitfire/symbolicai) - 構成可能な微分可能プログラミングライブラリ
 * [MiniGPT-4](https://github.com/vision-cair/minigpt-4) - @bentossellさん、minigpt-4はデモでこれを行います。
 * [DeepSpeed](https://github.com/microsoft/deepspeed) - DeepSpeedは、分散トレーニングと推論を簡単、効率的、効果的に行うことができる深層学習最適化ライブラリです。
 * [micro-gpt](https://github.com/muellerberndt/micro-gpt) - 最小限の汎用自律エージェント。
 * [gptdeploy](https://github.com/jina-ai/gptdeploy) - すべてを作成するための1行
 * [cloudgpt](https://github.com/ustayready/cloudgpt) - ChatGPTを使用したAWS顧客管理ポリシーの脆弱性スキャナー
 * [LlamaAcademy](https://github.com/danielgross/llamaacademy) - ラクダ科動物の学校
 * [magic-happens](https://github.com/empath-nirvana/magic-happens) - どんな状況でも実行してはいけないKubernetesオペレーター
 * [Multi-GPT](https://github.com/rumpfmax/multi-gpt) - GPT-4を完全に自律化するための実験的なオープンソースの試み。
 * [Image2Paragraph](https://github.com/showlab/image2paragraph) - ChatGPT、BLIP2、OFA、GRIT、Segment Anything、ControlNetを使用して、画像をユニークな段落に変換します。
 * [xai-gpt-agent-toolkit](https://github.com/xpressai/xai-gpt-agent-toolkit) - BabyAGI/AutoGPTスタイルのエージェントを作成し、実験するためのXircuitsツールキット
 * [celltypewriter](https://github.com/ntranoslab/celltypewriter) - 👉更新：#celltypewriterを#gpt4 apiキーなしで使用できるようになりました。私たちは#無料版を設定しましたので、あなたの#データで試すことができます。✨これは数日間有効であり、または資金が尽きるまで有効です：）楽しんでください！GitHubリンク：
 * [AutoGPT-FR](https://github.com/mikiane/autogpt-fr) - オートGPTのフランス語版
 * [DeepSpeedExamples](https://github.com/microsoft/deepspeedexamples) - DeepSpeedを使用した例のモデル
 * [Caption-Anything](https://github.com/ttengwang/caption-anything) - キャプション-Anythingは、画像セグメンテーション、ビジュアルキャプショニング、およびChatGPTを組み合わせた多目的ツールであり、ユーザーの好みに合わせた多様なコントロールを備えたカスタムキャプションを生成します。
 * [AudioGPT](https://github.com/aigc-audio/audiogpt) - AudioGPT：音声、音楽、音、および話す頭の理解と生成
 * [Machine-Learning-Goodness](https://github.com/aurimas13/machine-learning-goodness) - 機械学習プロジェクトには、ML/DLプロジェクト、ノートブック、ML/DLのチートコード、AI/AGIに関する有用な情報、コードやスニペット/スクリプト/タスクとヒントが含まれています。
 * [data-winners](https://github.com/frontanalyticsinc/data-winners) - ウェブサイト開発、分析、最適化のための無料のPythonとRスクリプトのコレクション。トピカルオーソリティと意味的コンテンツ最適化のための高度なリソースを含みます。
 * [critique-apps](https://github.com/inspired-cognition/critique-apps) - インスパイアド・コグニションのクリティークを使用して構築されたアプリ。
 * [deep-rl-class](https://github.com/huggingface/deep-rl-class) - このリポジトリには、Hugging Face Deep Reinforcement Learningコースのシラバスが含まれています。
 * [deep-RL-elements](https://github.com/amazingang/deep-rl-elements) - Pytorchでの深層強化学習アルゴリズム
 * [viper](https://github.com/cvlab-columbia/viper) - 「ViperGPT：推論のためのPython実行による視覚的推論」の論文のコード
 * [ChatCaptioner](https://github.com/vision-cair/chatcaptioner) - ChatCaptionerの公式リポジトリ
 * [galai](https://github.com/paperswithcode/galai) - GALACTICAのモデルAPI
 * [gost-install.ipynb](https://github.com/lewangdev/gost-install.ipynb) - Jupyter NotebookでGOSTをインストールする。
 * [chatgpt-desktop](https://github.com/sonnylazuardi/chatgpt-desktop) - フラッピーバードのゲームプレイでFacebookの友達とデュエルしよう。
 * [yobulkdev](https://github.com/yobulkdev/yobulkdev) - 🔥 🔥 🔥オープンソース＆AI駆動のデータオンボーディングプラットフォーム：無料のflatfile.com代替品
 * [WTF-JavaScript](https://github.com/wtfacademy/wtf-javascript) - 最近、私はJavaScriptを再学習して、細かいところを強化し、また「WTF JavaScript超入門」というものを書いて、初心者の方に学んでいただけるようにしています。
 * [gpt3-email](https://github.com/danimelchor/gpt3-email) - GPT-3を使ってメールの作成を手助けする。
 * [chatgpt-action](https://github.com/kxxt/chatgpt-action) - ChatGPTにPRのレビューをしてもらいましょう。
 * [scalene](https://github.com/plasma-umass/scalene) - Scalene：Python用の高性能、高精度のCPU、GPU、およびメモリプロファイラで、AIによる最適化提案を備えています。
 * [BingGPT](https://github.com/dice2o/binggpt) - 新しいBingのAIチャットのデスクトップアプリケーション（Windows、macOS、Linux）
 * [ChatGPT-Feishu](https://github.com/bestony/chatgpt-feishu) - フェイシューのために準備されたChatGPTロボット
 * [ARC](https://github.com/fchollet/arc) - 抽象化と推論コーパス
 * [pdf.js](https://github.com/mozilla/pdf.js) - JavaScriptでのPDFリーダー
 * [adrenaline](https://github.com/shobrook/adrenaline) - コードベースと話し合ってください。
 * [lorem-chatum-for-indesign](https://github.com/twardoch/lorem-chatum-for-indesign) - ChatGPTを使用して、より良いLorem ipsumを生成するAdobe InDesign用のLorem Chatumスクリプト
 * [monocle-rizz](https://github.com/acui51/monocle-rizz) - rizzGPT
 * [gptrpg](https://github.com/dzoba/gptrpg) - RPG風の環境に存在するGPTベースのエージェントのデモ
 * [ChattyCaty](https://github.com/cyberark/chattycaty) - chattycaty - GPTモデルを使用して多様なプログラムを作成するOSSツール。
 * [appwrite](https://github.com/appwrite/appwrite) - Web、モバイル、Flutter開発者向けの安全なバックエンドサーバー🚀、100％オープンソースのFirebase代替としても知られています。
 * [wechat-chatgpt](https://github.com/fuergaosi233/wechat-chatgpt) - Wechatyを介してWechatでChatGPTを使用してください。
 * [roomGPT](https://github.com/nutlope/roomgpt) - AIを使用してあなたの夢の部屋を生成するために、あなたの部屋の写真をアップロードしてください。
 * [noobnooc](https://github.com/noobnooc/noobnooc) - 私のプロフィール、ブログ、ホームページ（https://www.nooc.ink）の内容。
 * [code-gpt](https://github.com/vaibhavacharya/code-gpt) - いつでもどんなコードでも理解できるようになりましょう。🚀
 * [Portal](https://github.com/lxfater/portal) - ポータルリリース：システムトレイモードがサポートされ、APIチャットモードの履歴オプションソリューションが提供され、チャットGPT Web切断問題の自動リモート更新が可能になりました。
 * [commitgpt](https://github.com/romanhotsiy/commitgpt) - ChatGPTを使用してコミットメッセージを自動生成します。
 * [chatgpt-md](https://github.com/bramses/chatgpt-md) - ChatGPTをObsidianに（ほぼ）シームレスに統合。
 * [paul-graham-gpt](https://github.com/mckaywrigley/paul-graham-gpt) - ポール・グレアム氏のすべてのエッセイに対応したAI検索＆チャット。
 * [colorGPT](https://github.com/sonnylazuardi/colorgpt) - AIを使用して現実世界からキャプチャされた色名を生成する。
 * [novu](https://github.com/novuhq/novu) - 完全に機能する埋め込み通知センターを備えたオープンソースの通知インフラストラクチャー
 * [chatapi-single](https://github.com/bytemate/chatapi-single) - シンプルでパワフルなChatGPT-API-サーバー
 * [kindle-gpt](https://github.com/mckaywrigley/kindle-gpt) - あなたのKindleのハイライトに対してAI検索とチャット。
 * [gpt-4-for-code](https://github.com/anysphere/gpt-4-for-code) - コードのGPT-4のいくつかの例を教えてください！
 * [M5Core2ImageAvatarLiteChatGPT](https://github.com/robo8080/m5core2imageavatarlitechatgpt) - M5Stack Core2用のImageAvatarLiteChatGPT
 * [gpt4all-chat](https://github.com/nomic-ai/gpt4all-chat) - gpt4all-j チャット
 * [ggml](https://github.com/ggerganov/ggml) - 機械学習のためのテンソルライブラリ
 * [blindvisaidgpt](https://github.com/justanotherlad/blindvisaidgpt) - マイクロソフト/ビジュアルチャットGPTを使用した視覚障害者向けのインタラクティブ支援。
 * [cformers](https://github.com/nolanoorg/cformers) - CPU上で高速推論するためのCバックエンドを備えたSoTAトランスフォーマー。
 * [Pake](https://github.com/tw93/pake) - 🤱🏻 Rustを使って、どんなウェブページでもデスクトップアプリに変換できます。 🤱🏻 Rustを使って、簡単にウェブページをパッケージ化して、小さなデスクトップアプリを作成できます。
 * [run-wild](https://github.com/refcell/run-wild) - GPT-4環境アクセスの拡張
 * [gpt-macro](https://github.com/retrage/gpt-macro) - コンパイル時にコードを生成するRustプロセスマクロを搭載したChatGPT。
 * [nofwl](https://github.com/lencx/nofwl) - NoFWLデスクトップアプリケーション
 * [gwipt](https://github.com/benwr/gwipt) - GPT-3のコミットメッセージを使用して、すべての編集をwipブランチに自動的にコミットします。
 * [whatsapp-gpt](https://github.com/danielgross/whatsapp-gpt) - #8 WhatsAppとTelegramのためのchatgptグループチャットにchatgptを追加する：• WhatsAppgpt：• Telegramgpt：#8 WhatsAppとTelegramのためのchatgptグループチャットにchatgptを追加してください：• WhatsAppgpt：• Telegramgpt：
 * [chatgpt-web](https://github.com/869413421/chatgpt-web) - ChatGPT3.5 APIを利用したプライベートWebプログラム。
 * [legitify](https://github.com/legit-labs/legitify) - すべてのGitHubおよびGitLabアセットでのミス構成とセキュリティリスクの検出と修正
 * [wechatgpt](https://github.com/houko/wechatgpt) - wechatgptのGolang版chatgptロボット（Dockerで展開可能）は、現在WeChatとTelegramをサポートしています。
 * [xiaogpt.git](https://github.com/yihong0618/xiaogpt.git) - bilibiliのバックエンドソースコード
 * [wechat-chatGPT](https://github.com/gtoxlili/wechat-chatgpt) - ChatGPTでWeChat公式アカウントの受動的な返信インターフェースを実現する。
 * [dnscrypt-proxy](https://github.com/dnscrypt/dnscrypt-proxy) - dnscrypt-proxy 2 - 暗号化されたDNSプロトコルをサポートする柔軟なDNSプロキシ。
 * [review-gpt](https://github.com/vibovenkat123/review-gpt) - GPT-3、GPT-3.5、およびGPT-4を使用する自動コードレビューツール
 * [kube-ovn](https://github.com/kubeovn/kube-ovn) - SDNとクラウドネイティブの橋渡し（CNCFプロジェクトの一環）
 * [gpt-takes-the-bar-exam](https://github.com/mjbommar/gpt-takes-the-bar-exam) - GPTが司法試験を受ける
 * [offensive-chatgpt](https://github.com/payloadartist/offensive-chatgpt) - ChatGPTの攻撃的セキュリティの使用例
 * [ChatGPT-Saver](https://github.com/billionshields/chatgpt-saver) - チャットGPT ChatGPTセーバー
 * [ChatGPT-Simple](https://github.com/logankilpatrick/chatgpt-simple) - 100行以下のコードで簡単なローカルホスト版のChatGPTを構築してください。
 * [LongReadBenchmark](https://github.com/xueyidong/longreadbenchmark) - 長いリードRNA-seq解析ツールのベンチマークテスト
 * [GptMedCode](https://github.com/rohit43/gptmedcode) - @zakkohane @arjunmanrai #ehr分析の観点から、#chatgptバックエンドを使用してコードを自動化できるかどうかを考えていました。しかし、返されたコードの品質はあまり信頼できませんでした。品質はicd&gt;loinc&gt;snomedです。
 * [AISisterAIChan](https://github.com/manju-summoner/aisisteraichan) - ChatGPT3.5を搭載した伺かゴースト「AI妹アイちゃん」です。利用には別途ChatGPTのAPIキーが必要です。
 * [Entrepreneur-GPT](https://github.com/torantulino/entrepreneur-gpt) - 2017年GUJAM
 * [ChatGPTforRhino](https://github.com/4kk11/chatgptforrhino) - chatgptforrhinoにgui実装してそれっぽくした！あとgithubに置いといた！
 * [OutlineStormingGPT](https://github.com/mayaenomoto/outlinestorminggpt) - GPTとやわらかく話すためのツールです。
 * [Auto-GPT.git](https://github.com/torantulino/auto-gpt.git) - 高度なゲームエンジニアリングプロジェクト - 立方体ボクセルゲームメーカー
 * [ChatGPT-Bypass](https://github.com/grimoutlaw/chatgpt-bypass) - APIを介してChatGPTのコンテンツフィルタリングをバイパスするためのシンプルなスクリプト。
 * [robustlearn](https://github.com/microsoft/robustlearn) - MDATP PowerBIテンプレートのリポジトリ
 * [check](https://github.com/yeahwu/check) - ストリーミングメディアのロック解除テスト
 * [haoel.github.io](https://github.com/haoel/haoel.github.io) - 前の2日間、私はネット上での文書を更新したハオズィー氏を見ました。ChatgptとNew Bingの問題を解決する方法についても言及します。VPNを使用してもログインや使用ができない場合は、Gost + Cloudflare Warpを使用することができます。設定も比較的簡単です。(1/n)
 * [FlexGen](https://github.com/ying1123/flexgen) - 景観計画のためのゲーム
 * [chatgpt-web](https://github.com/chanzhaoyu/chatgpt-web) - ExpressとVue3を使用して構築されたChatGPTデモウェブサイト
 * [SPTH](https://github.com/spthvx/spth) - 「地獄のアートワーク」の第二部：人工的な（生命/進化/知能）
 * [whatsapp-chatgpt](https://github.com/navopw/whatsapp-chatgpt) - 手順に従ったノイズマップジェネレーター :霧:
 * [MathGPT](https://github.com/meiyulee/mathgpt) - 無料の数字駆動型数学モデル人工知能 | あなたの数字のために数学モデルを構築する |
 * [ChatGPT.el](https://github.com/joshcho/chatgpt.el) - EmacsでのChatGPT
 * [flutter_chatgpt_api](https://github.com/coskuncay/flutter_chatgpt_api) - Flutter / DartからChatGPTを使用してください。
 * [chatchan-dist](https://github.com/easychen/chatchan-dist) - Chat酱の独立部署版は、Dockerのプランにはプロキシが付属しています。
 * [MaterialGPT](https://github.com/dylanakp/materialgpt) - MaterialGPTはAPIを使用したChatGPTのクローンです。
 * [chatwire](https://github.com/theokafadaris/chatwire) - Laravelを使用した自己ホスト型のChatGPTクローン
 * [ChatGPTForTelegram](https://github.com/kylelin1998/chatgptfortelegram) - 現在、ChatGPTを基にしたロボットが開発されています。ロボットを使用することで、簡単に会話をすることができます。また、ロボットのアップデートやアップグレードは、1つのコマンドで簡単に行うことができ、サーバーにアップグレードする必要はありません。
 * [GPTstudio](https://github.com/michelnivard/gptstudio) - 固定効果と調整効果が許容される遺伝的分散成分モデルを推定するために特別に書かれたRおよびFORTRANベースの最適化プログラム。
 * [binary-dist](https://github.com/poslogithub/binary-dist) - 実行可能バイナリ配布用
 * [GPTeacher](https://github.com/teknium1/gpteacher) - GPT-4によって生成されたモジュラーデータセットのコレクション、General-Instruct - Roleplay-Instruct - Code-Instruct - Toolformer。
 * [AI-Toolbox](https://github.com/enbifa/ai-toolbox) - AI愛好家やプロフェッショナルのための包括的なリソースを構築する。
 * [following-instructions-human-feedback](https://github.com/openai/following-instructions-human-feedback) - @rachel_l_woods これは私がgptに幻覚を見せないように指示するための定番のペーパーです。
 * [Audits-Smart-Contracts](https://github.com/audit-ace/audits-smart-contracts) - 🚀監査報告書の発表をお知らせします。おめでとうございます。チャットGPT🎉監査DM-
 * [Malware](https://github.com/objective-see/malware) - macOSマルウェアコレクション
 * [inPars](https://github.com/zetaalphavector/inpars) - VOSviewer Onlineはネットワーク可視化のためのツールです。これは、文献計量ネットワークの構築と可視化に広く使われているVOSviewerのWebベース版です。
 * [ai-review.vim](https://github.com/yuki-yano/ai-review.vim) - 素早くコードを数えてください。
 * [gayolGate](https://github.com/gayolgate/gayolgate) - 私のGitHubプロフィールに関する情報
 * [minlora](https://github.com/cccntu/minlora) - 🚀 エキサイティングなニュース！私は新しいリポジトリ、minloraをリリースしました🎉 この強力なライブラリは、@huggingfaceのtransformers、diffusers、@karpathyのnanogptを含む*どんな*PyTorchモデルにも、わずか数行のコードでLoraを適用できます。今すぐチェックしてください。
 * [EOSIO-Vulnerability-Scanner](https://github.com/sentnl/eosio-vulnerability-scanner) - レイヤー1ブロックチェーンプロトコルのP0ネットワークセキュリティ問題に対するバグバウンティ
 * [paytm-movies](https://github.com/hedcet/paytm-movies) - #ビンビサラ #1月9日月曜日コレクション 1,852₹、77%の占有率（1,852/2,400）、5回上映、#テストシネマオクル #ウォーターランド
 * [chatgpt-vscode](https://github.com/ai-genie/chatgpt-vscode) - VS Codeで最高のAIペアプログラマー
 * [PolyglotSiri-Apple-Shortcut](https://github.com/munntein/polyglotsiri-apple-shortcut) - PolyglotSiriは[ChatGPT-Siri](https://github.com/Yue-Yang/ChatGPT-Siri)をベースにしており、多言語および音声機能を強化しています。
 * [M5Burner_M5Unified_StackChan_ChatGPT_README](https://github.com/robo8080/m5burner_m5unified_stackchan_chatgpt_readme) - M5Burner版M5Unified_StackChan_ChatGPTのREADMEです。
 * [stableLM](https://github.com/stability-ai/stablelm) - stability.ai APIとのやり取りを行うためのSDK（例：安定した拡散推論）
 * [AI-Twitter-History](https://github.com/jtmuller5/ai-twitter-history) - ChatGPTは良いですが、使い方がわかりません。
 * [gpt-legion](https://github.com/eumemic/gpt-legion) - 輝くブロックチェーンノード（RXD）- SHA512/256 プルーフ・オブ・ワーク
 * [JinJinLeDao_QA_Dataset](https://github.com/tech-podcasts/jinjinledao_qa_dataset) - このデータセットには、中国のポッドキャスト「JinJinLeDao」の281エピソードから抽出された18,000以上の中国語の質問と回答のペアが含まれています。
 * [AlitaAI](https://github.com/alita-ai/alitaai) - #notion #chatgpt #AlitaAI が1ヶ月かかってようやく完成しました。ChatGPTと一緒に製品/デザイン/フロントエンド/バックエンドを担当しています。新人ですが、Alita AI（notionに保存）をフォローしてください。Alita AIは、NotionとChatGPTに基づく人工知能アシスタントで、段階的に学習し、知識フラグメントを自動的に効率的に入力することができます。先行版：
 * [2048](https://github.com/inishchith/2048) - また別の2048ですが、今回はGPTによって制御されています。
 * [VardaGPT](https://github.com/ixaxaar/vardagpt) - 連想メモリ強化GPT-2モデル
 * [gpt-json](https://github.com/piercefreeman/gpt-json) - Pythonで構造化され、型ヒントが付いたGPTの応答
 * [gptneox](https://github.com/dfalbel/gptneox) - パッケージの概要（1行、タイトルケース）
 * [babyagi4all](https://github.com/kroll-software/babyagi4all) - BabyAGIをGPT4Allと一緒に実行する。
 * [open-chat-video-editor](https://github.com/scutlihaoyu/open-chat-video-editor) - オープンソースの短い動画自動生成ツール
 * [AIXP](https://github.com/davila7/aixp) - AI-Exchange Protocol（AIXP）：人工知能エージェントのための通信規格
 * [chat-ui](https://github.com/huggingface/chat-ui) - HuggingChatアプリを支えるオープンソースのコードベース
 * [pandora](https://github.com/pengzhile/pandora) - パンドラは、あなたがスムーズに呼吸できるChatGPTです。
 * [ChatWaifu_Mobile](https://github.com/voine/chatwaifu_mobile) - モバイル版二次元AI妻とのチャットボット
 * [ChatALL](https://github.com/sunner/chatall) - ChatGPT、Bing Chat、bard、Alpaca、Vincuna、Claude、ChatGLM、MOSS、iFlytek Spark、ERNIEなどと同時にチャットし、最適な回答を発見してください。
 * [fastGPT](https://github.com/certik/fastgpt) - Fortranで書かれた高速なGPT-2推論
 * [menubar](https://github.com/smol-ai/menubar) - チャットGPT/Bard/Claudeへのゼロレイテンシーアクセスが可能なメニューバー！A/Bテストを行ったり、バックグラウンドで使用したりできます。私は1日に20回使用しています。
 * [quivr](https://github.com/stangirard/quivr) - あなたのファイルや思考をすべてGenerativeAI Second Brainにダンプして、それとチャットしてください。
 * [GPTeam](https://github.com/101dotxyz/gpteam) - GPTeam：オープンソースのマルチエージェントシミュレーション
 * [learnGPT](https://github.com/dadukhankevin/learngpt) - Quizletの代替となる、無料でオープンソースで、AIを搭載したもの。
 * [GirlfriendGPT](https://github.com/eniascailliau/girlfriendgpt) - 「ガールフレンドGPT」は、ChatGPT4.0を使用して自分自身のAIガールフレンドを作成するためのPythonプロジェクトです。
 * [Mr.trans](https://github.com/illumine-labs/mr.trans) - 心を照らし、学びを超越する
 * [chat_gpt_error_handler](https://github.com/schwad/chat_gpt_error_handler) - 今日から私の新しいジェム「chat_gpt_error_handler」を試してみてください！エラースタックトレースの前に（うまくいけば）役立つChatGPTスニペットが表示されます。
 * [PandaGPT](https://github.com/yxuansu/pandagpt) - PandaGPT：すべてを指示に従うための1つのモデル
 * [rinna_gpt-neox_ggml-lora](https://github.com/yukaryavka/rinna_gpt-neox_ggml-lora) - リポジトリには、「rinna/japanese-gpt-neox...」[gpt-neox]モデルをggmlに変換した場合に、LoRAチューニングのためにAlpaca-Loraアダプタに適応するために変更されたスクリプトとマージスクリプトが含まれています。
 * [gptlink](https://github.com/gptlink/gptlink) - 自分で無料で商用可能なChatGPT環境を10分で構築できます。ユーザー、注文、タスク、支払いなどの機能が含まれ、構築は簡単です。
 * [tell-me-a-story-ai](https://github.com/kiki-le-singe/tell-me-a-story-ai) - 「ストーリーを教えて」という小さなアプリは、ChatGPTとReact Nativeを使用してストーリーを書くことができるアプリです。
 * [chatgpt-yaml-generator](https://github.com/robusta-dev/chatgpt-yaml-generator) - Kubernetesのスキーマと検証機能に関する完全な知識をChatGPTに与えてください。
 * [ComposeAI](https://github.com/ebfvince/composeai) - AndroidとiOSアプリChatGPTのようなものをCompose Multiplatformで作成しました。
 * [GreatMaster](https://github.com/illumine-labs/greatmaster) - 師匠、私たちを目覚めさせ、悟りを開かせてください。
 * [SAIL](https://github.com/luohongyin/sail) - SAIL：検索増強型インストラクション学習
 * [PodcastCopilot](https://github.com/microsoft/podcastcopilot) - 大規模トピックモデリングのためのスケーラブルで高速かつ軽量なシステム
 * [gpt-aggregated-edition](https://github.com/1595901624/gpt-aggregated-edition) - 聚合ChatGPTの公式版、ChatGPTの無料版、文心一言、Poe、chatchatなど、複数のプラットフォームを統合し、カスタムインポートプラットフォームをサポートしています。
 * [larc_gpt4](https://github.com/evanthebouncy/larc_gpt4) - larcがGPT-4で解決する
 * [go-proxy-bingai](https://github.com/adams549659584/go-proxy-bingai) - Vue3とGoを使用して構築されたMicrosoft New Bingのデモサイトは、一貫したUI体験を提供し、ChatGPTのヒントワードをサポートしています。国内でも利用可能です。
 * [slack-knowledgebase-chatgpt-responder](https://github.com/nearform/slack-knowledgebase-chatgpt-responder) - NearFormの知識ベースに関する質問に対する回答を提供するChatGPTパワードのSlack応答者。
 * [simpleaichat](https://github.com/minimaxir/simpleaichat) - Pythonパッケージは、堅牢な機能と最小限のコード複雑性を備えたチャットアプリと簡単にインターフェースを行うためのものです。
 * [instruction-tuned-sd](https://github.com/huggingface/instruction-tuned-sd) - 指示調整安定拡散のためのコード。
 * [gpt-engineer](https://github.com/antonosika/gpt-engineer) - 何を構築したいか指定し、AIが確認を求め、それを構築します。
 * [FalconStreaming](https://github.com/andrewgcodes/falconstreaming) - ストリーミング、トップ-k、ビームサーチを備えたFalcon40Bと7B（Instruct）の入力と出力。
 * [lightspeedGPT](https://github.com/andrewgcodes/lightspeedgpt) - GPT4とGPT3.5を無制限の入力に使用します。マルチスレッドを使用して複数のチャンクを並列処理します。大きな書籍、データセットなどの情報抽出や固有表現認識などのタスクに役立ちます。
 * [bloop](https://github.com/bloopai/bloop) - bloopはRustで書かれた高速なコード検索エンジンです。
 * [obsidian-copilot](https://github.com/logancyang/obsidian-copilot) - オブシディアンの中のChatGPTコパイロット
 * [thinkgpt](https://github.com/alaeddine-13/thinkgpt) - チュニジア航空アプリのREST API
 * [babyagi-ui](https://github.com/miurla/babyagi-ui) - BabyAGI UIは、ChatGPTのようなWebアプリでのBabyAGIの実行と開発をより簡単にするために設計されています。
 * [GPT4Company](https://github.com/easychen/gpt4company) - Gpt4Companyは、Samsungのような情報漏洩を防止するために使用されるリクエストフォワーダーです。
 * [chatgpt-spring-boot-starter](https://github.com/linux-china/chatgpt-spring-boot-starter) - Spring Boot ChatGPT スターター
 * [nuclei_gpt](https://github.com/sf197/nuclei_gpt) - チャットはNucleiテンプレート生成を自動化します。
 * [sample-app-aoai-chatGPT](https://github.com/microsoft/sample-app-aoai-chatgpt) - [プレビュー] AOAIを通じてchatGPTをターゲットにしたシンプルなWebチャット体験のサンプルコード。
 * [GENIUS](https://github.com/mingkai-zheng/genius) - GPT-4はニューラルアーキテクチャサーチを実行できるか？
 * [chatgpt-source-watch](https://github.com/0xdevalias/chatgpt-source-watch) - キュレーションされたアーカイブとスクリプトを使用して、ChatGPTのコードベースの進化を時間の経過とともに分析する。
 * [PROFILEGPT](https://github.com/odiks/profilegpt) - PROFILEGPTは、Twitter上のプロフィールやハッシュタグを分析するためのツールです。このアプリケーションは、さまざまな技術やAPIを活用してデータを収集し、ユーザーのために情報を生成します。
 * [chatgpt-auto-continue](https://github.com/adamlui/chatgpt-auto-continue) - ⏩ 複数のChatGPTの応答を自動的に生成し続ける
 * [a1gpt](https://github.com/a1k0n/a1gpt) - 使い捨てのGPT推論
 * [freegpt-webui](https://github.com/ramonvc/freegpt-webui) - GPT 3.5/4とチャットWeb UIを使用しています。APIキーは必要ありません。
 * [commavq](https://github.com/commaai/commavq) - commaVQは圧縮された運転映像のデータセットです。
 * [chatgpt-localfiles](https://github.com/samrawal/chatgpt-localfiles) - ChatGPTにローカルファイルへのアクセスを可能にする。
 * [SlashGPT](https://github.com/snakajima/slashgpt) - @snakajima さんによるSlashGPTの解説後でコードを確認する。
 * [nba-cba-ai-chat](https://github.com/mckaywrigley/nba-cba-ai-chat) - 新しい676ページのNBA CBAについて質問するためにAIを使用してください。
 * [Taqyim](https://github.com/arbml/taqyim) - チャットGPTモデルの評価のためのPythonインターフェース
 * [gpt-code-search](https://github.com/wolfia-app/gpt-code-search) - アプリの配布を自動化するためのGitHubアクション。
 * [Callisto](https://github.com/jetp1ane/callisto) - Callisto - インテリジェントなバイナリ脆弱性分析ツール
 * [OpenELM](https://github.com/carperai/openelm) - 大規模モデルを通じた進化
 * [chatgpt-to-api](https://github.com/acheong08/chatgpt-to-api) - 高度なHTTPライブラリ
 * [chatgpt-web-share](https://github.com/moeakwak/chatgpt-web-share) - PlusアカウントまたはAPIを提供する、完全機能を備えたマルチユーザーChatGPTウェブシステム。
 * [poe-api](https://github.com/ading2210/poe-api) - QuoraのPoeの逆解析されたPython APIラッパーで、ChatGPT、GPT-4、およびClaudeへの無料アクセスを提供します。
 * [leetcode](https://github.com/azl397985856/leetcode) - 推奨無料ChatGPTウェブサイト：www.lintcode.com/chat-gpt?utm_source=tf-github-lucifer  LeetCodeの解答：私の問題解決の旅の記録。 (leetcode解答、自分のleetcode問題解決の旅の記録。)
 * [chatgpt-business](https://github.com/garyvalue/chatgpt-business) - Chatgptビジネス版はすでに41個集められ、さらに収益化方法、ビジネスのソースコードプログラム、アカウントAPIチャネル、支払い受け取りチャネル、サーバーチャネル、コースのサポートサービス、CHATGPT知識の星、開発カスタマイズの外注を提供しています。
 * [chapyter](https://github.com/chapyter/chapyter) - Chapyter：JupyterノートブックでのChatGPTコードインタープリター
 * [ChatGPT-Midjourney-Pro](https://github.com/licoy/chatgpt-midjourney-pro) - 🤖️ Golang + Vue3 + NaiveUI をベースにした新しい ChatGPT-Midjourney の AIGC アプリ
 * [timetask](https://github.com/haikerapples/timetask) - 自分でカスタマイズ可能なタイマータスクをサポートするchatgpt-on-wechatのプラグイン
 * [chatgpt-mirror-server-deploy](https://github.com/xyhelper/chatgpt-mirror-server-deploy) - chatgpt-mirror-serverの迅速なデプロイメントライブラリファイル
 * [gpt-react-designer](https://github.com/xd2sketch/gpt-react-designer) - ⚡️ ChatGPTで⚛️ Reactコンポーネントを生成してプレビューする 🤖
 * [personoids-lite](https://github.com/personoids/personoids-lite) - 「チャットごとの自律性の力」- ChatGPTを強力な自律エージェントに変え、複雑なタスクを独立して達成できるようにします。
 * [AIChatWeb](https://github.com/nanjiren01/aichatweb) - ChatGPT-Next-Webをベースに、登録とログイン、制限額、招待、禁止ワード、支払い、Dockerを使用したワンクリックデプロイメントを追加します。バックエンド管理システムを提供し、タイトル、ウェルカムメッセージ、制限額不足の通知、お知らせを設定できます。
 * [gptAssist](https://github.com/woheller69/gptassist) - gptAssistはChatGPTのためのシンプルなWebViewラッパーです。
 * [personal_chatgpt](https://github.com/chunhuizhang/personal_chatgpt) - 個人用チャットGPT
 * [explain-source-code-by-chatgpt](https://github.com/cuishuang/explain-source-code-by-chatgpt) - 👂🏻 chatgptがGoの有名なプロジェクトのソースコードを解説します。
 * [ChatGPT_principle_fine-tuning_code_paper](https://github.com/julycoding/chatgpt_principle_fine-tuning_code_paper) - 本『ChatGPTリソースライブラリ（原理/微調/コード/論文）』の初期バージョンは、July CSDNブログで50万回以上閲覧されたChatGPTシリーズから派生しました。共同発起人：七月ChatGPT原理コースの受講生であり、6月初旬に正式に公開されました。
 * [spring-chatgpt-sample](https://github.com/azure-samples/spring-chatgpt-sample) - Spring / Javaスタックを使用したChatGPTのサンプル
 * [azurechatgpt](https://github.com/microsoft/azurechatgpt) - 🤖 Azure ChatGPT: 内部企業利用のプライベートで安全なChatGPT 💼
 * [ChatGPT-Nine-Ai](https://github.com/dreamergrow/chatgpt-nine-ai) - 使用NestjsとVue3で構築された商業化ChatGPTウェブサイト
 * [gptlink-web](https://github.com/gptlink/gptlink-web) - ReactとTailwind CSSによるChatGPTウェブアプリ、APIはgptlinkを使用しています。
 * [ChatGPT-Virtual-Live](https://github.com/smallnew666/chatgpt-virtual-live) - ChatGPTバーチャルタレント、Bilibili、TikTok、Video号をサポートしています。
 * [chatgpt-web-plus](https://github.com/chanzhaoyu/chatgpt-web-plus) - chatgpt-web-plusチャットGPTウェブプラス
 * [MindGeniusAI](https://github.com/xianjianlf2/mindgeniusai) - ChatGPTを使用してマインドマップを自動生成します。
 * [ExcelGPT](https://github.com/asterecho/excelgpt) - Input: chatgpt for Excel, developed based on ExcelDNAOutput: chatgpt for Excel、ExcelDNAをベースに開発されました。
 * [OpenCopilot](https://github.com/newfyu/opencopilot) - ChatGPTのクロスプラットフォームデスクトップクライアント。シンプルなユーザーインターフェースといつでも呼び出せる体験があります。ローカルの知識ベースの構築、ウェブ検索、長文の読み込み、ローカルのコードの実行などの機能があります。
 * [drugchat](https://github.com/ucsd-ai4h/drugchat) - ドラッグチャット：薬物分子グラフ上でのChatGPTのような機能を可能にするために
 * [ChatGPT-SDImg-Web](https://github.com/chengxs1994/chatgpt-sdimg-web) - ChatGPT-Next-Webをベースに、SD webui AI描画を統合し、登録、ログイン、回数制限、チャージ、共有などの機能を実現します。
 * [ESP32-ChatGPT](https://github.com/techiesms/esp32-chatgpt) - このリポジトリには、ESP32ボードでChatGPTを使用するためのコードが含まれており、i2sアンプモジュールを使用したオーディオ応答も行います。
 * [gihyo-ChatGPT](https://github.com/gamasenninn/gihyo-chatgpt) - 技評 ChatGPT ブック
 * [azurechatgpt](https://github.com/dandinu/azurechatgpt) - 🤖 Azure ChatGPT: 内部企業利用のためのプライベートで安全なChatGPT 💼
 * [OpenGPT-Business](https://github.com/black-fruit/opengpt-business) - chatgpt商業アプリ！79E/ChatGpt-Webの1.3.9最新版！私はクラックしました、ライセンスは必要ありません！
 * [ChatGPT-fine-tuning](https://github.com/iongpt/chatgpt-fine-tuning) - ChatGPTのファインチューニングを行うためのユーティリティクラスChatGPTのファインチューニングのためのユーティリティクラス
 * [ChatGPT-Next-Web-Pro](https://github.com/vual/chatgpt-next-web-pro) - chatgpt-next-webをベースに、midjourneyの描画機能を追加しました。今後はstable-diffusion、登録ログイン、バックエンド管理、ナレッジベースの接続などを行います。
 * [chirp](https://github.com/rogueocelot/chirp) - DiscordからのリレーチャットGPTの質問と回答
 * [SQL-GPT](https://github.com/cl-lau/sql-gpt) - ChatGPTを使用してSQLを生成し、実行を行います。SQLの最適化やエラー修正も可能です。
 * [ChatPaper2Xmind](https://github.com/masteryip/chatpaper2xmind) - 論文XMindノート生成ツールは、論文のPDFをChatGPTを通じて変換し、画像と数式を含む簡潔なXMindノートにすることで、論文の読解効率を向上させます。
 * [TIME-SEA-chatgpt](https://github.com/dulaiduwang003/time-sea-chatgpt) - SpringBoot3で開発されたAIプラットフォーム。デュアルエンド、ウェブサイトおよびミニプログラムを含み、chatgpt、newbing、claudeを含む。デュアルエンドのデータ同期、カスタムプリセットワードのサポート、機能モジュールの定義、さまざまな種類の図形描画、ウェブとモバイルの互換性を持つ。
 * [Chat-CodeReview](https://github.com/nangongchengfeng/chat-codereview) - ChatGPTはGitlabと統合され、コードを自動的に監査してコメントします。
 * [NeuroGPT](https://github.com/em1tsan/neurogpt) - 無料のChatGPT 3.5 / ChatGPT 4
 * [chatreview](https://github.com/specful-ai/chatreview) - ChatGPTのコードレビューモード
 * [pandora](https://github.com/dave1010/pandora) - ChatGPTコーディング解放！PandoraはChatGPTにマシン上でファイルの読み書きやコマンドの実行の能力を与えます。
 * [feishu-chatgpt](https://github.com/1130600015/feishu-chatgpt) - ChatGPTを統合したFeishuアプリ
 * [midjourney_turbo](https://github.com/chazzjimel/midjourney_turbo) - chatgpt-on-wechatのmj画像プラグイン、回数制限対応、GPTキーワードの磨き、画像合成、画像生成
 * [humanify](https://github.com/jehna/humanify) - ChatGPTを使用して、JavaScriptコードを非圧縮化します。
 * [careerboost](https://github.com/dmswl98/careerboost) - 📝 chatGPT履歴書校正サービス
 * [livecodingthefuture-docker-terraform](https://github.com/digitalinnovationone/livecodingthefuture-docker-terraform) - Live Conding The Futureの例を保存するために作成されたプロジェクト。Docker、Terraform、Bard、ChatGPTを使用してクラウド上にウェブアプリケーションをデプロイします。
 * [chatgpt-jiezi](https://github.com/hncboy/chatgpt-jiezi) - ChatGPT 管理端-解字チャットGPT 管理者-解読
 * [GPT-WEB-JAVA](https://github.com/a616567126/gpt-web-java) - JDK8に基づくAIチャットボット！WeChat公式アカウントMidjourney画像、カード交換、webサポートChatGPT、Midjourney画像、sd画像、カード交換、簡単な支払い、公式アカウントの誘導、メール登録🔥
 * [ChatGPT-Python-Applications](https://github.com/xiaowuc2/chatgpt-python-applications) - ChatGPT Pythonアプリケーションは、サードパーティのライブラリやモジュールと統合されています。
 * [ChatLog](https://github.com/thu-keg/chatlog) - ⏳ チャットログ：時間をかけてChatGPTの記録と分析
 * [claude-in-slack-server](https://github.com/llmkira/claude-in-slack-server) - Claudeとの対話をサポートするSlack向けのHTTPサーバーであり、ChatGPT Web APIと互換性があります。
 * [chat-review](https://github.com/ikoofe/chat-review) - ChatGPT Gitlab コードレビュー
 * [ChatGPTBook](https://github.com/liucongg/chatgptbook) - 《ChatGPT原理与実践：大規模言語モデルのアルゴリズム、技術、およびプライベート化》
 * [nvim-gpt](https://github.com/archibate/nvim-gpt) - あなたのようなネオパイオニアのために、NeoVimで統合されたChatGPT + Bing AIを提供します :)ネオパイオニアのために、NeoVimで統合されたChatGPT + Bing AIを提供します :)
 * [ChatReviewer](https://github.com/nishiwen1214/chatreviewer) - ChatReviewer: ChatGPTを使用して論文の利点と欠点を分析し、改善の提案を行います。
 * [ChatGLM-Tuning](https://github.com/mymusise/chatglm-tuning) - 出力: ChatGLM-6B + LoRAを基にした手頃な価格のChatGPTの実現方法
 * [chatgpt](https://github.com/emacs-openai/chatgpt) - Emacs内でChatGPTを使用する
 * [Using-ChatGPT-to-Learn-Programming](https://github.com/blackstar1453/using-chatgpt-to-learn-programming) - プログラミングの学習を強化するためにChatGPTの使い方を学びましょう。
 * [Apilot](https://github.com/6vision/apilot) - chatgpt_on_wechatプロジェクトに基づくAPI呼び出しプラグインchatgpt_on_wechatプロジェクトをベースにしたAPI呼び出しプラグイン
 * [ChatGPT_Custom_Instructions](https://github.com/daveshap/chatgpt_custom_instructions) - ChatGPTで使用できるカスタムインストラクションのリポジトリ
 * [chatnio](https://github.com/deeptrain-community/chatnio) - 👋 軽量なChatGPTチャットプラットフォーム、ChatGPTのオンライン検索サービスを実装し、マルチアカウントの負荷分散、キャッシュ、認証システムをサポートし、ストリームのリアルタイム応答、画像生成、対話の記憶機能をサポートします。
 * [talk](https://github.com/proxoar/talk) - ChatGPTとの会話はとても簡単です。
 * [brain-reply](https://github.com/caidukai/brain-reply) - より優雅なChatGPTクライアント
 * [wechat_gpt_laf](https://github.com/husanr/wechat_gpt_laf) - Lafクラウドプラットフォームを使用して、2つのステップでChatGPTをWeChat公式アカウントに接続します。
 * [bionicgpt](https://github.com/purton-tech/bionicgpt) - BionicGPTはChatGPTのオンプレミス版であり、生成型AIの利点を提供しながら厳格なデータの機密性を維持しています。
 * [ChatGPT-Next-Web-PRO](https://github.com/llboo/chatgpt-next-web-pro) - ChatGPT-Next-Webの管理コンソール。キーの管理、ユーザー認証、公式アカウントの登録/QRコードログイン、支払い管理、ギフトカードの管理などが含まれています。
 * [ChatGPT-AutoExpert](https://github.com/spdustin/chatgpt-autoexpert) - 🚀🧠💬 ChatGPT（非コーディング）およびChatGPTアドバンスドデータ分析（コーディング）のためのスーパーチャージカスタムインストラクション。
 * [muchat-aio](https://github.com/panyanyany/muchat-aio) - 团队版 ChatGPT Web アプリケーション、多ユーザー、ログイン不要。会社、組織、または小規模グループ内での内部利用に適しています。
 * [chatgpt-web-go](https://github.com/heimeropen/chatgpt-web-go) - チャットGPTアプリケーションのためのGolangサービス
 * [reddit-profile-analyzer](https://github.com/grays42/reddit-profile-analyzer) - ChatGPTベースのredditプロファイル分析ツール。APIキーを持参してください。
 * [bionic-gpt](https://github.com/bionic-gpt/bionic-gpt) - BionicGPTはChatGPTのオンプレミス版であり、生成型AIの利点を提供しながら厳格なデータの機密性を維持しています。
 * [chatgpt-token](https://github.com/croissanteth/chatgpt-token) - ETH上での完全自動トークン展開、ChatGPTとDALL-Eを使用しています。
 * [RickAndMortai](https://github.com/code-bullet/rickandmortai) - リックとモーティのキャラクターとポータルがあるチャットGPTのもので、シュレックもいるようですが、詳細はわかりません。
 * [sd-webui-chatgpt](https://github.com/non906/sd-webui-chatgpt) - これはStable Diffusion web UIでChatGPTを使用するためのリポジトリです。
 * [pictureChange](https://github.com/yanyutin753/picturechange) - chatgpt-on-wechatプロジェクトのプラグインに適用されます。
 * [ChatGPT_Agent](https://github.com/liyucheng09/chatgpt_agent) - チャットGPTエージェントによるゲームデモ
 * [gin-vue-admin](https://github.com/flipped-aurora/gin-vue-admin) - vite+vue3+ginをベースにした開発基盤プラットフォーム（TS、JSの混在をサポート）、jwt認証、権限管理、ダイナミックルーティング、表示/非表示可能なコンポーネント、ページネーションのラッピング、マルチログインのインターセプト、リソース権限、アップロード/ダウンロード、コードジェネレータ、フォームジェネレータ、chatGPT自動テーブル検索など、開発に必要な機能を統合しています。
 * [LMFlow](https://github.com/optimalscale/lmflow) - 大規模な基盤モデルの微調整と推論のための拡張可能なツールキット。すべてのための大規模なモデル。
 * [reloadium](https://github.com/reloadware/reloadium) - ホットリローディング、プロファイリング、およびPythonのAIデバッグ
 * [chatgpt-java](https://github.com/plexpt/chatgpt-java) - ChatGPT Java SDK。GPT3.5、GPT4 APIに対応しています。すぐに使用できます。
 * [alldata](https://github.com/alldatacenter/alldata) - 🔥🔥 AllData大数据製品は、データプラットフォームを基盤とし、データ中台を橋渡しとして、機械学習プラットフォームやGPTプラットフォームをフレームワークとして、全体のデジタル化ソリューションを提供するものです。WeChatグループ：https://docs.qq.com/doc/DVHlkSEtvVXVCdEFo
 * [SuperCLUE](https://github.com/cluebenchmark/superclue) - SuperCLUE: 中国語の基礎モデルのためのベンチマーク
 * [worktool](https://github.com/gallonyin/worktool) - 【企業微信】企業微信のロボット チャットボット、自動的に友達を追加、自動的にグループに招待、自動的にメッセージを送信するロボット ルート不要でアカウントが封鎖されない ChatGPTを統合
 * [next-enterprise](https://github.com/blazity/next-enterprise) - 💼 高性能で保守性の高いアプリケーションのためのエンタープライズグレードのNext.jsボイラープレート。Tailwind CSS、TypeScript、ESLint、Prettier、テストツールなどの機能が搭載されており、開発を加速させます。
 * [HydraLab](https://github.com/microsoft/hydralab) - インテリジェントなクラウドテストが簡単になりました。
 * [vectordb](https://github.com/epsilla-cloud/vectordb) - Epsillaは高性能なベクトルデータベース管理システムです。ホストされたEpsillaをhttps://cloud.epsilla.com/で試してみてください。
 * [WeChatMsg](https://github.com/lc044/wechatmsg) - WeChatのチャット履歴を抽出し、HTML、Word、CSV形式のドキュメントにエクスポートして永久保存し、チャット履歴を分析して年次チャットレポートを生成します。
 * [gpts-works](https://github.com/all-in-aigc/gpts-works) - サードパーティのGPTストア
 * [gpt-researcher](https://github.com/assafelovic/gpt-researcher) - 与えられた任意のトピックについてオンラインで包括的なリサーチを行うGPTベースの自律エージェント
 * [ChatGPT-Next-Web](https://github.com/chatgptnextwebteam/chatgpt-next-web) - 使いやすく設計されたクロスプラットフォームのChatGPT UI（Web / PWA / Linux / Win / MacOS）。一つのボタンで自分自身のクロスプラットフォームChatGPTアプリを手に入れましょう。
 * [ChatGLM-Finetuning](https://github.com/liucongg/chatglm-finetuning) - ChatGLM-6B、ChatGLM2-6B、ChatGLM3-6Bモデルを使用して、ダウンストリームの具体的なタスクのファインチューニングを行います。Freeze、Lora、P-tuning、全参微調などが関係しています。
 * [ChatGPT-Next-Web](https://github.com/chatgptnextweb/chatgpt-next-web) - 使いやすく設計されたクロスプラットフォームのChatGPT UI（Web / PWA / Linux / Win / MacOS）。一つのボタンで自分自身のクロスプラットフォームChatGPTアプリを手に入れましょう。
 * [gpt-crawler](https://github.com/builderio/gpt-crawler) - URLから独自のカスタムGPTを作成するための知識ファイルを生成するために、サイトをクロールします。
 * [vimGPT](https://github.com/ishan0102/vimgpt) - GPT-4VとVimiumを使用してウェブを閲覧してください。
 * [modelscope-agent](https://github.com/modelscope/modelscope-agent) - ModelScope-Agent（オープンソース版GPTs）：ModelScope内のモデルと世界をつなぐエージェントフレームワーク
 * [chatgpt-wechat](https://github.com/whyiyhw/chatgpt-wechat) - 企業微信/微信の安全な使用に適したChatGPTの個人アシスタントアプリ
 * [jan](https://github.com/janhq/jan) - Janは、コンピュータ上で完全にオフラインで動作するChatGPTのオープンソースの代替品です。
 * [gerev](https://github.com/gerevai/gerev) - 🧠 AIを搭載した企業向け検索エンジン 🔎
 * [Replit-Xray](https://github.com/yonggekkk/replit-xray) - Replitコンテナのデプロイxrayプロキシ、カスタムマスクウェブページのサポート、ワンクリックで5つのプロトコルを同時にサポート、vless、vmess、trojan、shadowsocks、socksの構築をサポート、ローカルアップロードとreplitプラットフォームのforkの2つのモードでのデプロイをサポートします。
 * [GPTSecurity](https://github.com/mo-xiaoxi/gptsecurity) - 未来を形作る安全領域のスマート革命
 * [auto_job__find__chatgpt__rpa](https://github.com/frrrrrrrrank/auto_job__find__chatgpt__rpa) - これは、あなたの履歴書と求人内容に基づいてChatGPTを使用して自動的にカバーレターを生成し、中国の上司にメッセージを送信するためのツールです。
 * [hamulete](https://github.com/hoochanlon/hamulete) - 🏔️国立台湾大学、新加坡国立大学、早稻田大学、東京大学、中央研究院（台湾）および中国の重要な大学や研究機関による、社会科学、経済学、数学、ゲーム理論、哲学、システム工学などの学術論文の知識データベース。
 * [GPT-4V-Act](https://github.com/ddupont808/gpt-4v-act) - マウス/キーボードを使用してWeb UIと対話することができるGPT-4V(ision)を使用したAIエージェント
 * [Generative_Deep_Learning_2nd_Edition](https://github.com/davidadsp/generative_deep_learning_2nd_edition) - O'Reilly書籍「Generative Deep Learning: Teaching Machines to Paint, Write, Compose and Play」第2版の公式コードリポジトリ。O'Reilly書籍「Generative Deep Learning: Teaching Machines to Paint, Write, Compose and Play」第2版の公式コードリポジトリです。
 * [smart-ide](https://github.com/airuikun/smart-ide) - VSCodeのプラグインとChatGPTの機能を組み合わせて、スマートな研究開発の効率化を実現する。
 * [comfyui-mixlab-nodes](https://github.com/shadowcz007/comfyui-mixlab-nodes) - ワークフローからアプリへ、スクリーン共有＆フローティングビデオ、GPT＆3D、音声認識＆テキスト読み上げ
 * [smart-excel-ai](https://github.com/weijunext/smart-excel-ai) - ChatGPTを使用して、必要なExcelの数式を数秒で生成します。
 * [zotero-gpt](https://github.com/muisedestiny/zotero-gpt) - GPTとZoteroの出会い。
 * [gpt4v-browsing](https://github.com/unconv/gpt4v-browsing) - GPT-4 Vision APIとPuppeteerを使用したウェブスクレイピング
 * [inke](https://github.com/yesmore/inke) - 📖 AI支援のあるリアルタイム共同作業が可能なWYSIWYGノートブック。セルフホスティングに対応しています。IndexedDBを使用してノートを保存します。
 * [twitterbio](https://github.com/nutlope/twitterbio) - ミクストラルとGPT-3.5を使って、あなたのTwitterの自己紹介を生成しましょう。
 * [SeeAct](https://github.com/osu-nlp-group/seeact) - SeeActは、大規模なマルチモーダルモデル（LMM）であるGPT-4V(ision)を中心に、任意のウェブサイトで自律的にタスクを実行する一般的なウェブエージェントのためのシステムです。
 * [AI-Infinity](https://github.com/meetpateltech/ai-infinity) - AIの無限の可能性を探求するのに役立つAIツールのセット。
 * [ChatGPT-Proxy](https://github.com/dqzboy/chatgpt-proxy) - ChatGPTプロキシ
 * [flutter_chat_box](https://github.com/bravekingzhang/flutter_chat_box) - Flutterで開発されたChatGPTとのチャットアプリ、全プラットフォーム対応
 * [composum-AI](https://github.com/ist-dresden/composum-ai) - コンポジウムページCMSとAdobe AEMのための人工知能サービス
 * [council](https://github.com/chain-ml/council) - Councilは、カスタマイズされた生成AIアプリケーションの迅速な開発と堅牢な展開のためのオープンソースプラットフォームです。
 * [ChatGemini](https://github.com/bclswl0827/chatgemini) - ✨ ChatGeminiは、Google Geminiをベースにしたウェブクライアントです。ChatGPT 3.5と同等の操作ロジックを持ち、同時にチャット中に画像をアップロードすることもサポートしています。アプリは自動的にGemini-Pro-Visionモデルを呼び出して画像認識を行います。
 * [yakGPT](https://github.com/yakgpt/yakgpt) - ローカルで実行される、ハンズフリーのChatGPT UI
 * [GalTransl](https://github.com/cx2333-gt/galtransl) - GPT-3.5/GPT-4/Newbing/Sakuraなどの大規模言語モデルをサポートするGalgame自動翻訳の解決策
 * [MoneyPrinter](https://github.com/fujiwarachoki/moneyprinter) - MoviePyを使用してYouTube Shortsの作成を自動化します。
 * [ChatGPT-DeMod](https://github.com/4as/chatgpt-demod) - ChatGPTとの通信時にモデレーション結果を非表示にするTampermonkey/Greasemonkeyスクリプト。
 * [gpt-newspaper](https://github.com/rotemweiss57/gpt-newspaper) - ユーザーの好みに合わせてカスタマイズされた個人新聞を作成するために設計されたGPTベースの自律エージェント。
 * [CoGPT](https://github.com/geniucker/cogpt) - ん〜CopilotかGPTか？誰にもわからない。Copilotを介してgpt-4にアクセスしてみて。
 * [rome](https://github.com/kmeng01/rome) - GPT（NeurIPS 2022）内の事実関連の特定と編集
 * [chatgpt-next](https://github.com/xcatliu/chatgpt-next) - 微信風のChatGPT、Next.jsで構築され、プライベートデプロイメントに最適な選択肢！
 * [wechatSDK](https://github.com/kawika-git/wechatsdk) - WeChatボットは、Python 3.11に基づいた革新的なプロジェクトであり、ChatGPTモデルとWeChatのネイティブAPIを組み合わせて、ユーザーにスマートなチャット、自動描画、自動的に友達に投稿、自動的に動画を投稿するなど、さまざまなAPI統合サービスを提供します。日常のコミュニケーション効率と面白さを向上させることを目的としています。
 * [Bunny](https://github.com/baai-dcai/bunny) - 軽量なマルチモーダルモデルのファミリー。
 * [ChatGPT-API-Faucet](https://github.com/terobox/chatgpt-api-faucet) - AIサークルの蛇口ウェブサイト、24時間ごとに1つのトークンを受け取り、AI製品の開発テストに使用できます。
 * [WELearnHelper](https://github.com/ssmjae/welearnhelper) - WE Learnの同行クラスの問題の答えを表示します。クラスのテストをサポートします。自動回答、学習時間を記録し、ChatGPTに基づいた回答生成を行います。
 * [devchat](https://github.com/devchat-ai/devchat) - AIパワードスクリプトを使用して、IDEのチャットパネルから開発タスクを自動化します。
 * [ChatGPTSwiftUI](https://github.com/alfianlosari/chatgptswiftui) - ChatGPTネイティブiOS、macOS、watchOS、tvOS SwiftUIアプリケーションChatGPTネイティブiOS、macOS、watchOS、tvOS SwiftUIアプリケーション
 * [qcg-installer](https://github.com/rockchinq/qcg-installer) - ChatGPT QQ ロボットの自動インストーラー、自動デプロイ、QChatGPTプロジェクト用に適用される：https://github.com/RockChinQ/QChatGPT
 * [wechatSDK](https://github.com/wechatapis/wechatsdk) - WeChatボットは、Python 3.11に基づいた革新的なプロジェクトであり、ChatGPTモデルとWeChatのネイティブAPIを組み合わせて、ユーザーにスマートなチャット、自動絵画、自動フレンドサークルの投稿、自動ビデオ投稿など多様なAPI統合サービスを提供します。日常のコミュニケーション効率と面白さを向上させることを目的としています。
 * [FreeGPT35](https://github.com/missuo/freegpt35) - ログイン不要のChatGPT Webが提供する無制限の無料GPT-3.5-Turbo APIサービスを活用してください。
 * [SWE-agent](https://github.com/princeton-nlp/swe-agent) - SWEエージェントは、GitHubの問題を取得し、GPT-4またはお好みのLMを使用して自動的に修正しようとします。 SWEベンチ評価セットのバグの12.29％を解決し、実行にわずか1.5分かかります。
 * [GalTransl](https://github.com/xd2333/galtransl) - GPT-3.5/GPT-4/Newbing/Sakuraなどの大規模言語モデルをサポートするビジュアルノベルの自動翻訳ソリューション
 * [VAR](https://github.com/foundationvision/var) - [GPTが拡散を打ち負かす🔥] [視覚生成におけるスケーリング法則📈] 「Visual Autoregressive Modeling: Next-Scale Predictionを介したスケーラブルな画像生成」の公式実装
 * [ChatWaifu](https://github.com/cjyaddone/chatwaifu) - ChatGPTとMoegoe TTSを組み合わせて、チャットするワイフを作成します。
 * [AutoAgents](https://github.com/link-agi/autoagents) - [IJCAI 2024] GPTの異なる役割を生成し、複雑なタスクのための協力エンティティを形成します。
 * [suno-api](https://github.com/gcui-art/suno-api) - APIを使用してsuno.aiの音楽生成AIを呼び出し、GPTなどのエージェントに簡単に統合します。
 * [ChatGPT-miniprogram](https://github.com/leon-fong/chatgpt-miniprogram) - 🤖 ChatGPT 小プログラム 出力:
 * [99AI](https://github.com/vastxie/99ai) - 99AI 安定版：NineAIをベースにした商用利用可能なAI Webアプリケーション（ライセンス不要、バックドアなし、迅速な展開をサポート）。目標はALL-IN-CHATです。
 * [geekai](https://github.com/yangjian102621/geekai) - AIアシスタントの完全なオープンソースソリューションで、運用管理用のバックエンドが付属しており、すぐに使用できます。ChatGPT、Azure、ChatGLM、讯飞星火、文心一言など、複数のプラットフォームの大規模言語モデルが統合されています。MJ AIドローイング、Stable Diffusion AIドローイング、Weibo Hot Searchなどのプラグインツールをサポートしています。Go + Vue3 + element-plusを使用して実装されています。
 * [ChatGPT-on-WeChat](https://github.com/kx-huang/chatgpt-on-wechat) - 🤖️ 2つのステップでWeChatにChatGPTを展開する方法！ 两步在云端部署你的微信ChatGPT聊天机器人！🤖️
 * [ai-to-pptx](https://github.com/chatbookai/ai-to-pptx) - Ai-to-pptxは、AI技術（ChatGptとGemini）を使用してPPTXを作成するアシスタントです。オンラインでの編集とPPTXのエクスポートをサポートしています。主な機能：1. ChatGPTなどの大規模言語モデルを使用してアウトラインを生成する。2.生成されたコンテンツをユーザーが再度編集できる。3. PPTXを生成する際に異なるテンプレートを選択できる。4.オンラインでPPTXのテキストコンテンツ、スタイル、画像などを編集できる。5. PPTX、PDF、PNGなど、さまざまな形式でエクスポートをサポートしています。
 * [DAIL-SQL](https://github.com/beachwang/dail-sql) - GPT-4上で効率的かつ効果的なフューショットNL2SQLメソッド。
 * [auto-playwright](https://github.com/lucgagan/auto-playwright) - ChatGPTを使用してPlaywrightのステップを自動化する。
 * [mi-gpt](https://github.com/idootop/mi-gpt) - 🏠 小愛音箱をChatGPTと豆包に接続し、あなた専用の音声アシスタントに改造します。
 * [hostedgpt](https://github.com/allyourbot/hostedgpt) - どこでもホストできる、またはローカルで実行できるChatGPTのオープンバージョン。
 * [typingmind](https://github.com/typingmind/typingmind) - AIチャットのための最も先進的なWeb UI
 * [reflex-chat](https://github.com/reflex-dev/reflex-chat) - Reflexで構築されたChatGPTのクローン
 * [gptpdf](https://github.com/cosmosshadow/gptpdf) - PDFを解析するためにGPTを使用します。
 * [vectorhub](https://github.com/guangzhengli/vectorhub) - 埋め込みを使用して、簡単かつ迅速にAIウェブサイトやアプリケーションを構築できます！
 * [chatgpt-artifacts](https://github.com/ozgrozer/chatgpt-artifacts) - ChatGPTにクロードの遺物機能を持ってきてください。
 * [Protofy](https://github.com/protofy-xyz/protofy) - AI スーパーチャージド ローコードプラットフォーム CMS およびフレームワーク 🚀🚀
 * [go2coding.github.io](https://github.com/go2coding/go2coding.github.io) - AIツールナビゲーション、無料のchatgpt、chatgpt4、midjourney、notion ai、tome.app
 * [chatgpt](https://github.com/putyy/chatgpt) - uniapp、hyperf MineAdmin で実装された chatgptアプリ、小プログラム、h5、アプリをサポートしています！
 * [vscode-chatgpt-reborn](https://github.com/christopher-hayes/vscode-chatgpt-reborn) - VSCodeでコードをリファクタリング、改善、デバッグするために、GPT-3とGPT-4を使用してください。
 * [Chatgpt-Makes-Money](https://github.com/xiaoming2028/chatgpt-makes-money) - Input: ChatGPT side hustle money-making tips must-see, ChatGPT side hustle money-making cheats, ChatGPT from beginner to expertOutput: ChatGPT副業でお金を稼ぐための必見のヒント、ChatGPT副業でお金を稼ぐための秘訣、ChatGPTの初心者からエキスパートまで
 * [sendbird-uikit-react](https://github.com/sendbird/sendbird-uikit-react) - Sendbird UIKitのオープンソースコードを使用して、数分でチャットを構築できます。
 * [sol-mate-eink](https://github.com/blixt/sol-mate-eink) - Sol Mate GPTをあなたの電子ペーパーディスプレイで使用できます！
 * [gptstore-data-backup](https://github.com/ainativelab/gptstore-data-backup) - GPTストアのトレンドデータの日次アーカイブ
 * [ChatGPT-airport-tizi-fanqiang](https://github.com/axiba053/chatgpt-airport-tizi-fanqiang) - ChatGPT科学上网梯子サービスのおすすめ、GPT4のアップグレード方法、Claude-3の無料利用方法
 * [vscode-reborn-ai](https://github.com/vscode-reborn-ai/vscode-reborn-ai) - VSCodeでコードをリファクタリング、改善、デバッグするために、GPT-3とGPT-4を使用してください。
 * [gpts](https://github.com/ruvnet/gpts) - rUvによって作成されたGPTのコレクション
 * [zerox](https://github.com/getomni-ai/zerox) - ゼロショットpdf OCR with gpt-4o-mini
 * [gpt-games](https://github.com/jimliu/gpt-games) - GPTを使用してゲームを作成します。
 * [DecodingTrust](https://github.com/ai-secure/decodingtrust) - GPTモデルの信頼性に関する包括的評価
 * [TalkingHeads](https://github.com/ugorsahin/talkingheads) - ChatGPT、Claude、Copilot、Gemini、HuggingChat、およびPiと通信するためのライブラリ
 * [ChatGPT-Mirror](https://github.com/dairoot/chatgpt-mirror) - 🚀 自分のChatGPTイメージサイトをワンクリックでデプロイ
 * [WiNGPT2](https://github.com/winninghealth/wingpt2) - WiNGPTは、GPTを基にした医療分野の大規模モデルであり、専門の医学知識、医療情報、データを統合し、医療業界に知識を提供するためのインテリジェントな医療質問、診断支援、医学知識などの情報サービスを提供し、診療効率と医療サービスの質を向上させることを目的としています。
 * [modded-nanogpt](https://github.com/kellerjordan/modded-nanogpt) - 5BトークンでのGPT-2（124M）品質
 * [minimind](https://github.com/jingyaogong/minimind) - 【大規模】26Mの小さなパラメータGPTを完全に0から3時間でトレーニングし、最低2Gのグラフィックカードで推論トレーニングが可能です！
 * [AI-Youtube-Shorts-Generator](https://github.com/samuraigpt/ai-youtube-shorts-generator) - GPT-4、FFmpeg、およびOpenCVを使用して自動的にビデオを分析し、最も興味深いセクションを抽出し、視聴体験を向上させるためにトリミングするPythonツール。
 * [miniperplx](https://github.com/zaidmukaddam/miniperplx) - インプット：インターネット上で情報を見つけるのを手助けする、ミニマリストのAI搭載検索エンジン。GPT-4o mini、Claude 3.5 Sonnet、o1-miniなどのモデルで検索！
 * [ai-commit](https://github.com/insulineru/ai-commit) - ✨ ChatGPT、Gitmoji、およびConventional Commitsを使用してコミットを簡単に作成しましょう 🚀
 * [show-me](https://github.com/marlaman/show-me) - オープンソースのChatGPT O1に対するビジュアルで透明な代替案
 * [chatgpt-api-server](https://github.com/xyhelper/chatgpt-api-server) - chatgpt公式ウェブサイトアカウントを使用して外部APIサービスを実現します。
 * [ChatALL](https://github.com/ai-shifu/chatall) - ChatGPT、Bing Chat、Bard、Alpaca、Vicuna、Claude、ChatGLM、MOSS、讯飞星火、文心一言などと同時にチャットし、最適な回答を見つける
 * [shadcn-nextjs-boilerplate](https://github.com/horizon-ui/shadcn-nextjs-boilerplate) - Shadcn UI NextJS ボイラープレート ⚡️ 無料オープンソース ChatGPT UI 管理ダッシュボードテンプレート - Horizon AI ボイラープレート
 * [TaskWeaver](https://github.com/microsoft/taskweaver) - Visual Studio Code での CMake 統合


