### Text Alignment

Easily realign text to components with text alignment classes.

```jsx
  <Text left>Left aligned text on all viewport sizes.</Text>
  <Text center>Center aligned text on all viewport sizes.</Text>
  <Text right>Right aligned text on all viewport sizes.</Text>
  <Text justify>
    Both aligned text on all viewport sizes. Ambitioni dedisse
    scripsisse iudicaretur. Cras mattis iudicium purus sit amet
    fermentum. Donec sed odio operae, eu vulputate felis rhoncus.
  </Text>
```

### Text Transform

Transform text in components with text capitalization classes.

```jsx
  <Text lowercase>lowercased text.</Text>
  <Text uppercase>Uppercased text.</Text>
  <Text capitalize>Capitalized text.</Text>
```

### Text Spacing

Props for controlling the tracking (letter spacing).

```jsx
  <Text trackingTight>
    Lorem ipsum dolor sit amet. Tight letter spacing.
  </Text>
  <Text trackingNormal>
    Lorem ipsum dolor sit amet. Normal letter spacing.
  </Text>
  <Text trackingWide>
    Lorem ipsum dolor sit amet. Wide letter spacing.
  </Text>
```

### Line Height

Props for controlling the leading (line height).

```jsx
  <Text leadingNone>
    Lorem ipsum dolor sit amet.<br />Dolor sit amet.
  </Text>
  <Text leadingTight>
    Lorem ipsum dolor sit amet.<br />Dolor sit amet.
  </Text>
  <Text leadingNormal>
    Lorem ipsum dolor sit amet.<br />Dolor sit amet.
  </Text>
  <Text leadingLoose>
    Lorem ipsum dolor sit amet.<br />Dolor sit amet.
  </Text>
```
