---
title: 'W3C e WHATWG: amor e ódio'
authors: Diego Eis
type: post
date: 2014-10-29
excerpt: Um quer se mover rapidamente. O outro quer estabilidade e segurança.
url: /w3c-e-whatwg-amor-e-odio/
categories:
  - Notícias
  - Opinião

---
Se você é novo na área deve entender que o desenvolvimento para internet passou por várias revoluções. O Tableless nasceu de uma delas. Uma das revoluções mais recentes e que você deve ter acompanhado de perto foi o nascimento do HTML5. Na verdade, pouca gente sabe como tudo aconteceu, mas é bem simples.

O WHATWG (The Web Hipertext Application Technology Working Group) é um grupo de desenvolvedores que não se conformavam com a velocidade que as coisas aconteciam no W3C. Portanto eles são um grupo separado do W3C. Esse grupo foi fundado por membros da Mozilla, Apple e Opera por volta de 2004. Eles resolveram iniciar a escrita de uma nova recomendação para o HTML, já que o W3C iria abandonar o HTML e focar seus esforços em linguagens baseadas em XML. É por isso que algum dia no seu passado você começou a fechar as tags BR com uma barra no final (<br />). Sugiro que leia [esse capitulo do livro HTML5 For Web Designers][1].

Hoje entendemos que esse seria um caminho bem ruim. Portanto o WHATWG resolveu, de forma independente, iniciar essa documentação de forma que os desenvolvedores e os browsers pudessem avançar o desenvolvimento web com uma tecnologia nova e totalmente focada em inovações. Deu certo. Como os membros tinham influência na comunidade e também dentro dos browsers, o HTML5 logo se tornou popular. Os browsers começaram a adotar as novidades imediatamente e os desenvolvedores começaram a implementar em seus projetos.

Só que a partir daí iniciou uma rixa entre o WHATWG e o W3C. Mas o próprio [Tim Berners-Lee tenha admitido em Outubro de 2006][2] que as tentativas deles de dirigir a web do HTML para XML não estavam funcionando muito bem. Foi aí que o W3C decidiu criar um HTML Working Group, começando do zero e usando as especificações do WHATWG como base para a futura versão do HTML. Isso foi bom e ruim: o W3C agora iniciou um grupo que vai trabalhar no HTML 5 (note o espaço antes do 5) e o WHATWG estava trabalhando na versão HTML5 (sem espaços), que seria usada pelo próprio W3C como base!

Não vamos avançar mais na história porque existem muitos detalhes e eu estaria reescrevendo um texto que você pode ler [aqui][3] e [aqui][4].

Um dos problemas é: quando há duas especificações, qual os desenvolvedores devem seguir? Aposto que você, hoje em dia, vai pouco na documentação do W3C, não é? Normalmente as informações de novidades no HTML5 vem de blogs especializados no assunto (Tipo nóis aqui). De onde esses blogs tiram essas informações? Eu gosto bastante do WHATWG porque a documentação deles é bastante ativa. Eles escrevem a documentação se baseando em pequenos pedaços e não como algo monolítico, que muda de tempos em tempos depois de muita, muita revisão. Eles são mais ágeis. 

> When there are two versions of a spec, what&#8217;s a programmer to do? There&#8217;s no one answer. &#8220;Generally we tell developers to look at the WHATWG version, which tends to be developed with better technical accuracy,&#8221; <small>advised Mozilla Chief Technology Officer Andreas Gal.</small>

Há um artigo na [C|Net][5] muito interessante que fala sobre essa picuinha entre os dois grupos. Se você quiser entender mais sobre o assunto leia: [HTML5 is done, but two groups still wrestle over Web&#8217;s future][6], escrito pelo [Stephen Shankland][7].

Mas quem decide quais as futuras novidades? O W3C está [trabalhando no HTMl 5.1][8], que inclui uma série de novidades em Canvas e drag-and-drop. Mas o WHATWG também está trabalhando em coisas assim. Há outro problema apontado pelo WHATWG, onde o W3C vive copiando partes da recomendação deles e usando nas suas documentações oficiais. No artigo que o Stephen escreveu há um exemplo falando sobre a especificação sobre os padrões de URL, onde o W3C tem um rascunho sobre o assunto, mas em alguns momentos o W3C aponta o rascunho do WHATWG como sendo a última versão.

O W3C tem tentado se mover mais rápido no processo de transformar rascunhos em recomendações. Mas isso não é tão fácil. Se você se move rápido, você precisa de desapegar algumas coisas. A ideia do W3C é que tudo seja altamente estável. Não dá para correr e entregar alguma coisa se aquilo em algum momento vai travar alguma coisa. Essa é a grande diferença entre o W3C e o WHATWG. Para mim é bastante compreensível.

> &#8220;If you&#8217;re going to burn an HTML5 browser into silicon, you want to have something that is reasonably stable, you want a good idea that features in it are interoperable and not experimental. That&#8217;s basically the heart of the friction that occurs between the WHATWG and W3C.&#8221;

Existem três pilares principais: W3C, browsers e devs. E eu sempre presto atenção nos browsers. Se os browsers acham legal uma determinada especificação, eles começam a adotar essa especificação, de forma que os devs implementam essa novidade em seus projetos. O que sobra para o W3C? O papel dele é bastante importante para regulamentar estes padrões. Não creio que o W3C vá sair de cena ou algo do tipo. Ele é imprescindível para o desenvolvimento da web. Mas precisa seguir a velocidade dos devs, assim como os browsers tem feito. Por isso é importante a atuação de representantes dos próprios browsers nos grupos de trabalho do W3C. Por isso, que é muito importante que VOCÊ participe das listas de discussão dos grupos de trabalho. Aqui tem todas as [listas de email que você pode participar do W3C][9].

Vamos ver como isso tudo se desenrola e participe. Não seja um dev passivo às mudanças.

 [1]: https://html5forwebdesigners.com/history/index.html#the_schism_whatwg_tf
 [2]: https://dig.csail.mit.edu/breadcrumbs/node/166
 [3]: https://github.com/whatwg/web-history "Um resumo da história escrita pelo próprio WHATWG"
 [4]: https://html5forwebdesigners.com/history/index.html#the_schism_whatwg_tf "A história do WHATWG contada pelo livro HTML5 para Web Designers."
 [5]: https://www.cnet.com
 [6]: https://www.cnet.com/news/html5-is-done-but-two-groups-still-wrestle-over-webs-future/
 [7]: https://twitter.com/stshank
 [8]: https://www.cnet.com/news/w3c-buttons-down-html5-opens-up-html5-1/
 [9]: https://lists.w3.org/