---
title: Web para Todos quer acabar com as barreiras de navegação na Internet no Brasil
authors: W3C Brasil
type: post
date: 2017-09-20
excerpt: Iniciativa nasce com um movimento apoiado por diversas entidades, empresas, influenciadores e indivíduos que querem sites acessíveis para qualquer pessoa.
categories:
  - acessibilidade
  - w3c
tags:
  - acessibilidade
image: https://i.imgur.com/C4QkuJm.jpg
---

Você já parou para pensar em como um cego navega na internet, ou como um surdo que tem como linguagem oficial a Língua Brasileira de Sinais assiste aos vídeos e lê notícias na Web? Você já teve a experiência de acessar um site usando apenas o teclado do computador, ou precisou ler e reler várias vezes um texto publicado on-line para entender o que ele queria dizer?

Essas e outras dificuldades são chamadas "barreiras de navegação" e estão presentes em praticamente todos os sítios do País, segundo estimativas feitas pelo escritório brasileiro do W3C, consórcio internacional que estabelece os padrões da web no mundo. Só no Brasil, 45,6 milhões de pessoas (24% da população) enfrentam esse tipo de barreira, de acordo com o Censo 2010 feito pelo IBGE. Segundo a pesquisa PNAD 2014, o percentual de pessoas com deficiência que usam com frequência a internet no Brasil é 57% - acima da média brasileira, que é de 54%.

Em uma análise feita apenas em páginas do Governo, o Núcleo de Informação e Coordenação do Ponto BR (NIC.br) - entidade que agrega as atividades do escritório do W3C no Brasil e abriga o Centro de Estudos sobre Tecnologias Web (Ceweb.br) - constatou que menos de 6% desses sites tiveram um cuidado para tentar minimizar as barreiras de acesso para pessoas com deficiência. "Se estendermos para o universo das empresas, esta porcentagem certamente é ainda menor", afirma Vagner Diniz, gerente geral do W3C Brasil e do Ceweb.br. 

Diante deste cenário, foi desenvolvida a iniciativa **[Web para Todos](https://mwpt.com.br/)**, que une entidades, empresas, universidades e diversas pessoas que defendem uma Internet mais acessível. "Esses mais de 45 milhões de pessoas têm o direito de serem incluídas no mundo digital, e é preciso muito pouco para mudar a realidade desses cidadãos", enfatiza Simone Freire, diretora geral da agência Espiral Interativa e idealizadora do projeto. "Se um site for fácil de navegar por alguém com algum tipo de limitação motora, intelectual, auditiva ou visual, certamente será melhor ainda para quem não tem", explica. A iniciativa conta com a parceria do NIC.br por meio do Ceweb.br, participando do projeto desde sua concepção e apoio institucional do W3C Brasil.

A partir disso, surgiu a plataforma digital inédita no País, totalmente colaborativa, que é a base do Web para Todos e está dividida em três grandes pilares: Mobilização, Educação e Transformação.

O objetivo inicial é mobilizar as pessoas com algum tipo de deficiência a compartilharem as experiências, positivas e negativas, que tiveram ao navegar em sites brasileiros. Com esse material, a equipe do Web para Todos analisará cada caso e encaminhará a análise à organização citada para providências, se necessário. E isso já nos leva automaticamente para o pilar Educação, onde será promovida a troca de conhecimento entre organizações (públicas e privadas), especialistas em acessibilidade digital e a sociedade em geral, por meio de cartilhas, vídeos, links de referência, fóruns, entre outras atividades. Há ainda uma seção de melhores práticas, para que as organizações entendam como adequar seus sites, contribuindo, assim, para a construção de uma internet mais inclusiva para todos. No pilar Transformação, é possível avaliar a acessibilidade da página principal de um sítio. Basta inserir o endereço e a ferramenta analisa automaticamente, em tempo real, o código e informa se a página apresenta ou não barreiras de navegação. 

Simone, empreendedora que trabalha há oito anos com a causa da acessibilidade digital, teve a ideia de dar voz às pessoas com deficiência, criando um mecanismo para que elas pudessem participar do processo de transformação da Web no Brasil. "Percebemos que não era suficiente termos uma lei a favor dessas pessoas. Precisávamos contar isso às organizações e ajudá-las a entenderem seu papel", lembra Simone. 

Vale ressaltar que, com a vigência da Lei Brasileira de Inclusão - LBI, desde janeiro de 2016, passou a ser obrigatória a acessibilidade de sítios de qualquer organização (empresas privadas, fundações e institutos, órgãos do governo) com sede ou representação comercial em território brasileiro (Lei nº 13.146, art. 63, julho de 2015).

## De olho nos setores essenciais
Como parte das ações de Mobilização, uma equipe de especialistas avaliará, semestralmente, barreiras de navegação em sites brasileiros, reunidos por segmentos de atuação, como Educação, E-commerce, Serviços Públicos, Portais de notícias, entre outros. 

A primeira análise, divulgada no dia 20 de setembro, traz o recorte da Educação. Foram verificadas páginas das 10 melhores Universidades e Escolas de Ensino Médio do País, de acordo com o último ranking divulgado pelo MEC (2015). Nenhum deles preencheu os requisitos necessários para serem considerados acessíveis a qualquer pessoa. "Todos os sites avaliados tinham barreiras de acesso que podem dificultar ou até impedir o acesso de uma pessoa com deficiência às páginas", reitera o gerente do Ceweb.br. Dos 14 critérios analisados, a média geral cumpriu apenas 30% deles. ([Veja o estudo completo no texto "Web para Todos avalia sites das melhores universidades e escolas de ensino médio do Brasil"](https://nic.br/noticia/releases/web-para-todos-avalia-sites-das-melhores-universidades-e-escolas-de-ensino-medio-do-brasil/).

Os critérios da análise foram desenvolvidos pela equipe do Web para Todos, em parceria com especialistas voluntários e o time técnico do Ceweb.br, que há mais de uma década promovem ações de conscientização para que as páginas na Web sejam acessíveis a todos. 

Para isso, foram levadas em consideração as Diretrizes de Acessibilidade para Conteúdo Web (WCAG2), desenvolvidas pelo W3C, em conjunto com especialistas do Google, Microsoft, IBM e empresas especializadas em acessibilidade.

"Nosso objetivo com a divulgação desses dados é sensibilizar a sociedade para o atual cenário da falta de acessibilidade em sites considerados essenciais para o desenvolvimento e integração social de qualquer cidadão, independentemente de ter ou não algum tipo de deficiência", explica Diniz. "Nossa equipe entrará em contato com as organizações avaliadas para compartilhar a análise, propor melhorias e sensibilizá-las para que adequem seus sites a uma navegação acessível a todos, convidando-as para o desafio da transformação digital", complementa Simone. 

Anualmente, esses mesmos sites serão reavaliados, criando parâmetros comparativos sobre a evolução da acessibilidade nos segmentos analisados.

## Vantagens da acessibilidade na web
Um site acessível é aquele que permite que qualquer pessoa (independentemente de suas dificuldades), navegue, entenda e interaja sem ajuda de ninguém. Para isso, devem seguir as diretrizes do WCAG, que, em resumo, estão divididas em quatro categorias: atende o necessário, permite o controle de navegação, é fácil de entender e feito para durar.

O que isso significa? Ao desenvolver uma página Web, é fundamental fornecer alternativas textuais para qualquer conteúdo não textual, alternativas para multimídia (audiodescrição, entre outros recursos), criar conteúdo que possa ser apresentado de modos diferentes, sem perder informação ou estrutura, tornar a visualização mais fácil (contrastes, tamanho etc). 

Também é essencial fazer com que todas as funcionalidades estejam disponíveis no teclado, além de maximizar a compatibilidade entre as interfaces utilizadas pelos usuários, incluindo os recursos de tecnologia assistiva (ou seja, ele deve ser criado para ser acessado perfeitamente de qualquer dispositivo e navegador, tanto agora quanto no futuro). Veja todas as Diretrizes de Acessibilidade para Conteúdo Web (WCAG) 2.0: [www.w3.org/Translations/WCAG20-pt-br/](https://www.w3.org/Translations/WCAG20-pt-br/).

Simone ressalta que, além de se adequar à LBI, ter um site acessível é também uma excelente oportunidade para as organizações reverem toda sua comunicação digital, inovar e contar com vários benefícios. "Entre esses ganhos, estão a ampliação e diversificação do seu público-alvo, mais facilidade e agilidade na manutenção do site, mais visibilidade em buscadores, fortalecimento da sua marca por meio de uma comunicação mais moderna e colaborativa, cumprimento do seu papel social, entre outros", destaca.
