---
title: Web Móvel e suas aplicações
authors: Giovanni Keppelen
type: post
date: 2013-01-07
excerpt: A implantação generalizada da web em dispositivos móveis torna um alvo de escolha para criadores de conteúdo.
url: /web-movel-e-suas-aplicacoes/
dsq_thread_id: 1010142253
categories:
  - HTML
  - Javascript
  - Mobile

---
Compreender os seus pontos fortes e suas limitações, e utilização de tecnologias que se encaixam nessas condições são fundamentais para criar o sucesso de conteúdo.

## O que é especifico para criação em dispositivos móveis

Idealmente, os autores de sites seriam capaz de atender à crescente demanda por uma experiência móvel de qualidade, sem mudar uma linha de código. Mas a realidade é que um site projetado especificamente com mobilidade em mente sempre nos proporciona uma experiência de usuário muito melhor para os usuários móveis.

As razões para isso incluem os desafios colocados por custos de rede e atrasos, memória e limitações de CPU, teclado e diferentes dispositivos. Como importante, eles apresentam um conjunto crescente de vantagens com a sua natureza pessoal e sempre disponível, e cada vez mais sensíveis ao contexto.

Como resultado, a experiência móvel muitas vezes merecem seu próprio conjunto de considerações de desing, como discutido em um crescente corpo de literatura, como: [Autoria Web móvel][1] e de [dispositivos independentes de autoria][2]. Os usuários móveis operam um um contexto de uso muito diferente do que os usuários de PC.

Uma série de barreiras que enfrentam os usuários móveis são semelhantes às dividas por pessoas com deficiência. Estas semelhanças tornam natural para visar o desenvolvimento de sites que são acessíveis tanto para as pessoas com deficiência e para os dispositivos móveis.

## Quais tecnologias foram desenvolvidas para os dispositivos móveis

Nos últimos anos, o W3C tem desenvolvido uma série de tecnologias que explicitamente levam em conta as especifidades dos dispositivos móveis.

&#8211; [CSS móvel][3]
  
&#8211; [SVG Tiny][4]
  
&#8211; [XHTML para celular][5]

A última geração de navegadores móveis são capazes de usar as tecnologias da web mais avançads, incluindo recursos de [HTML 5][6], [CSS 2.1 e 3][7] e claro [ricas APIs JavaScript][8]

## Saiba mais

O Mobile Web criou um [programa de treinamento][9] para ajudar os web designers e produtores de conteúdo que já estão familiarizados com o mundo ambiente de trabalho para se familiarizar com a web.

Saiba mais sobre o estado atual de especificações relativas a:

&#8211; [Mobile web Authoring][10]
  
&#8211; [CSS Móvel][3]
  
&#8211; [SVG Tiny][4]
  
&#8211; [XHTML para celuar][5]
  
&#8211; [Web móvel para o desenvolvimento social][11]

 [1]: https://www.w3.org/standards/techs/mobile
 [2]: https://www.w3.org/standards/techs/deviceindependenceauthoring
 [3]: https://www.w3.org/standards/techs/cssmobile
 [4]: https://www.w3.org/standards/techs/svgmobile
 [5]: https://www.w3.org/standards/techs/xhtmlmobile
 [6]: https://www.w3.org/standards/techs/html
 [7]: https://www.w3.org/standards/techs/css
 [8]: https://www.w3.org/standards/techs/js
 [9]: https://www.w3.org/Mobile/training/
 [10]: https://www.w3.org/standards/techs/mobile#w3c_all
 [11]: https://www.w3.org/standards/techs/mw4d