---
title: 'UX/UI & Skething nas rotas do Design'
authors: Igor Giamoniano
type: post
date: 2021-05-25
excerpt: 'Sobre a área de design com foco em suas terminologia no passado e no presente'
categories:
  - Design
tags:
  - mercado
  - opinião
--- 

Pela abrangência do termo vou me focar principalmente no Design Gráfico e Design Digital (minha primeira formação a quem devo eterna gratidão ao diretor do instituto <a href="https://www.linkedin.com/in/elwyn-correia-1235b986/"> Elwyn Correia </a>, uma pessoa incrível que nunca esqueceu o significado do termo Educação.)

> "Tudo bem, eu sei, meu dicionário é velho e se tiver no novo eu vou ligar pro Aurélio.", Atitude 67 - Saideira


Ou no nosso caso o Michaelis:

> "sm. Conceito de qualquer produto de acordo com seu ponto de vista estético e sua funcionalidade"


## Conceito x Conceito de Design

Quem nunca fez um projeto de identidade visual nos anos 90 e ficou debruçado para criar um 'conceito de Design'?

Segundo Lobach (2001), conceito de design é: 
> "...a concretização de uma ideia em forma de projetos ou modelos, mediante a construção e configuração resultando em um produto industrial passível de produção em série."

Melhor definição não conheço e na prática é realmente isso que fazemos, um bom conceito de Design é garantia (ou quase) de projeto aprovado, portanto para isso um conceito deve ser sólido em alguns aspectos principais, são eles:

- Comunicação
- Função
- Resolução

Sua peça deve Comunicar aquilo que se pretende, sua função deve ser clara e compreensivel a todos e o objetivo final deve ser resolver o problema do cliente.

O que na teoria é simples na prática pode ser extremamente desafiador , principalmente quando colocamos na fórmula algo que gostamos de chamar de "percepção do cliente" (mas isso é assunto pro futuro).


## UX
Gosto de ver o conceito de UX como um refinamento nescessário ao processo de Design altamente nescessário para o mercado atual, sua definição é bem clara; segundo o Nielsen Norman Group (NN/g) "'Experiência do Usuário' inclui todos os aspectos da interação do usuário final com a empresa, seus serviços e seus produtos."

E nesse conceito se resume o Kernel do Design que é o usuário final e sua relação com a empresa, do que adianta uma obra de arte digna de popular as melhores galerias do mundo mas que não são compreensiveis e uteis ao usuário ou que simplesmente não transmite os valores e culturas da empresa Y?

E cabe aqui lembrar que, a experiência do usuário é subjetiva, no entanto os atributos que compoem a expêriencia do usuário são objetivos e nisso a beleza!

Toda experiência subjetiva deve ser 'medida' a partir de métodos e os pilares metodológicos desse processo podem facilmente ser resumidos em:

- Utilidade
- Facilidade
- Prazer

Medir e gerar dados de quão util, facil e prazerosa é a experiência do usuário com o projeto antes do seu lançamento é uma otima forma de prever problemas evitaveis.

## UI
O UI esta voltado a áreas especificas do Design, nesse caso a criação de Interface
É nesse momento que o Design tende a especialização, como Design de Software, Web Design ou Design Industrial.
O Design de Interfaces trabalha com os dados gerados pela experiência do usuário e cria soluçoes práticas para os problemas encontrados, baseando-se principalmente na usabilidade.
Para isso temos inclusive a padronização da <a href="https://en.wikipedia.org/wiki/ISO_9241">ISO 9241</a> (que trata principalmente de objetos gráficos), sendo seus atributos:

- Clareza
- Dicriminabilidade
- Concisão
- Consistência
- Detectabilidade
- Legibilidade
- Compreensibilidade

Topicos ~~nerds~~ técnicos que você pode ler aqui! (Preferencialmente enquanto escuta <a href="https://www.youtube.com/watch?v=qqfMAf3IFE0">Tim Maia Lo-Fi</a>)


## Sketching

E seguindo um padrão a la Memórias Póstumas de Brás Cubas vamos deixar o inicio no final e falar sobre Skething (ou simplesmente esboço).

Segundo Diana Davies (1990), Sketch é: 
> "...um desenho a mão livre executado rapidamente que geralmente não é pretendido como obra acabada."

A questão é que quando falamos de esboço em Design não devemos focar em técnica ou ferramenta, como geralmente fazemos nas artes plásticas (por exemplo, vamos usar carvão ou giz seco? Tela de tecido ou papel sulfite? Tinta óleo ou guache?)

O esboço no Design deve ser encarado como um exercicio de desbloqueio mental onde expomos combinações de conceitos e padrões visuais e futuramente em um processo de reconstrução (ou desconstrução) chegamos a um conceito elaborado que a partir dai vira a se tornar o produto final.

## Conclusão
Assim como o mundo mudou nos ultimos nos ultimos 100 anos o Design como forma de compreenção e ação criativa mudou junto. Muitos foram os desafios ao longo dessa jornada e a constante evolução traz consigo ainda mais desafios, mas a diferença é que vemos um cenário mais profissional e mais focado em entregas de qualidade.

Hoje pensamos em diversas formas de Design (Design Thinking, Design Service, etc.) que a criatividade, como natureza inerente a todo ser humano, seja sempre uma constante (ainda que variavel em sua subjetividade) em um futuro cheio de variaveis (ainda que objetivo em sua posição). 
