---
title: 'UX: Como aumentar a tolerância do usuário para atrasos'
authors: Mari Coelho
type: post
date: 2017-03-01
aliases: 
  - /ux-como-aumentar-tolerancia-do-usuario-para-atrasos/
titulo_personalizado:
  - 'UX: Como aumentar a tolerância do <strong>usuário para atrasos</strong>'
categories:
  - Destaques
  - UX
tags:
  - design
  - ux

---
Vivemos em um tempo onde velocidade é diferencial. Exigimos rapidez de tudo ao nosso redor, seja em um atendimento, em uma entrega de produto, na velocidade da Internet, no feedback do cliente, na estratégia de SEO do nosso site, entre tantos outros exemplos que poderiam ser citados. A realidade é evidente: esperar é doloroso.

E em um cenário onde rapidez é fator de satisfação, a espera pode influenciar negativamente no valor de um produto ou serviço oferecido. Quando pensamos em UX temos de pensar em todo e qualquer motivo que possa atrapalhar a boa experiência do usuário, e principalmente, naqueles que possam impedir que ele chegue ao seu objetivo.

Temos inúmeros exemplos em nosso cotidiano de tentativas de minimizar a dor da espera, como por exemplo, ao invés daquela música instrumental repetitiva, alguns canais de telemarketing optam por sons de propaganda ou até dicas de como resolver problemas frequentes de consumidores enquanto aguardam na linha para falar com o atendente. Quem nunca na fila da loja ou do supermercado, enquanto esperava, decidiu pegar mais uma balinha, um chocolate, ou uma revista que ficava bem ao lado da fila do caixa?

O tempo de espera, enquanto você está fazendo outra coisa é percebido como muito mais curto do que quando esperamos estaticamente, sem qualquer tipo de distração. Os usuários esperam com menos incômodo quando se distraem com outra coisa, do que quando olham para a tela e veem somente um círculo girando continuamente.

**Quando esperar vale a pena?**
  
Apesar do constante desejo por velocidade, também precisamos de resultados de qualidade, e muitas das vezes qualidade requer mais esforço e consequentemente leva mais tempo. Sendo assim, a espera ela passa a ser justificada e compreendida pelo usuário, quando é possível para ele identificar o esforço empregado.

Mas como identificar o esforço de uma ferramenta online, de um site, de um app, de um computador, de um celular ou de qualquer outro produto ou serviço cujo esforço não é visível?

**Desafio de UX**

Como podemos projetar interfaces que são percebidas como sendo mais rápidas do que realmente são? Como aumentar a tolerância do usuário para atrasos na entrega dos resultados?

O esforço empregado para qualidade e que deve ser identificado pelo usuário para compreensão da espera, em ambiente digital é o equivalente à transparência do que está sendo feito.

O usuário precisa ver o andamento, precisa identificar o que está sendo feito e encontrar uma justificativa do porquê ele está esperando. Quando abrimos o Photoshop, por exemplo, ele abre sua tela de inicialização e começa a me mostrar informações como: “Inicializando&#8230;”, “Lendo o arquivo x&#8230;”, “Incluindo y&#8230;” e estes dados me confortam muito mais do que se fosse algo estático. Vejo que algo está sendo feito e quanto mais rápidas as informações são mostradas, tenho a real sensação que não vou ter de esperar tanto tempo para utilizá-lo.

Em um experimento da Harvard Business School, os participantes tinham de escolher a melhor experiência entre dois sites com resultados idênticos e experiências diferentes. Um site devolvia o resultado instantaneamente, já o segundo site demorava cerca de 30 a 60 segundos e variava entre mostrar a transparência do processo ou não. Como resultado, 62% dos participantes preferiram a experiência de usuário com transparência no processo.

Vale ressaltar também um caso polêmico para a área, onde o UX Designer Graeme Pyle, publicou um vídeo sobre uma progress bar falsa que ele encontrou. No vídeo, Pyle mostra que o andamento da barra evolui mesmo sem conexão com a Internet, e que ainda tenta ser realista dando pequenas pausas durante o progresso. Vale a pena uma transparência falsa? Pense no impacto negativo de uma falsa experiência para os usuários.

Link do vídeo: <https://www.youtube.com/watch?v=gpBWwl-Ngak>

**A transparência é sempre a solução?**

Sabemos que nem toda solução convém para todos os projetos. A transparência ela é útil sim, mas de nada adianta se o tempo de espera for muito grande. Mesmo não havendo um tempo uma regra sobre o tempo tolerável de espera, é necessário estudar e ver qual a duração ideal. Sendo assim, caso o atraso esteja fora do tempo favorável devo encarar reduzir o tempo como prioritário em relação a implementação da transparência.

Outra informação importante é que os resultados oferecidos têm de ser úteis e de qualidade, em relação ao que foi solicitado, pois mesmo com uma experiência adequada durante o tempo de espera, se o usuário não receber resultados satisfatórios, a experiência volta a ser péssima.

Deve se considerar que nenhuma demonstração de esforço supera um mal funcionamento. Se o produto ou serviço não funciona bem posso implementar milhões de alternativas mas no fim, a experiência nunca será agradável.