---
title: Usabilidade de interfaces para dispositivos móveis – parte II
authors: Talita Pagani
type: post
date: 2011-11-23
excerpt: Adequar aplicações ao contexto de dispositivos móveis apresenta determinados vieses de desenvolvimento.
url: /usabilidade-interfaces-dispositivos-moveis-parte2/
categories:
  - Design
tags:
  - usabilidade
  - Acessibilidade
  - Mercado
  - Mobile
  - Tecnologia e Tendências
  - UX
  - desenvolvimento web
  - design de interação
  - dispositivos moveis
  - qualidade em uso
---
Como vimos na primeira parte do artigo, as diretrizes existentes de usabilidade continuam valendo no contexto mobile, mas precisam ser revistas e interpretadas de outra forma. Podemos perceber que o gargalo é conseguir manter as informações e funcionalidades que fazem sentido neste cenário. Adequar aplicações ao contexto de dispositivos móveis apresenta determinados vieses de desenvolvimento.

<div id="attachment_4585" style="width: 310px" class="wp-caption aligncenter">
  <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/11/Prototipação2.jpg"><img class="size-medium wp-image-4585" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/11/Prototipação2-300x225.jpg" alt="Variedade de Dispositivos" width="300" height="225" srcset="uploads/2011/11/Prototipação2-300x225.jpg 300w, uploads/2011/11/Prototipação2.jpg 960w" sizes="(max-width: 300px) 100vw, 300px" /></a>
  
  <p class="wp-caption-text">
    Variedade de Dispositivos
  </p>
</div>

## Variação de hardware (muito maior do que computadores convencionais)

Dispositivos móveis têm uma grande variedade de displays (tamanhos, cores, resolução), de forma de entrada de dados (touchscreen, teclado físico &#8211; QWERTY ou convencional -, microfone, câmera) e também de capacidade (processamento, armazenamento, etc.). Com essas combinações, é possível imaginar uma combinação vasta de dispositivos. Como um site pode ser ajustável para proporcionar uma interação similar mediante esta diversidade? Como ele irá aparecer? O conceito de [Responsive Web Design][1] e a técnica de media queries são soluções que visam minimizar este fator.

## Convenções de interface e interação em plataformas

Compatibilidade de ícones, comandos e ações não é uma diretriz recente em ergonomia de software. Mas em ambientes mobile, este é um ponto que ainda não está bem adequado. Basta observarmos como cada plataforma disponibiliza convenções distintas de interface, sem contar a variação de navegadores, que geralmente são nativos de cada plataforma, o que acaba &#8220;amarrando&#8221; o usuário.

## (Comportamento do usuário no) ambiente

Dispositivos móveis geralmente não são utilizados em um ambiente estável, como uma mesa. O ambiente externo onde o usuário se encontra influencia a sua interação com o sistema. É dia ou noite? O usuário está parado ou em movimento? Com as duas mãos livres? Ocupado? Todos estes fatores externos têm impacto na interação e é da alçada da equipe de desenvolvimento analisar todas estas variáveis para compor o cenário de uso da sua aplicação. Já vimos aqui no Tableless que o ambiente do usuário influencia na qualidade da interação.

## Novas perspectivas

É interessante ver que há um movimento por parte da comunidade de desenvolvedores para construir aplicações web cada vez mais parecidas com aplicações nativas do dispositivo.

O que podemos extrair disso é um esforço em reproduzir o modelo de interação familiar às pessoas com relação à estes dispositivos.

De certa forma, é uma tentativa de adequar as interfaces e o funcionamento das aplicações ao que os usuários esperam e também ao que se ajusta melhor ao contexto mobile, para facilitar a precisão da área de toque, o feedback das ações, a visualização de informações, a densidade informacional, entre muitos outros fatores.

Para atender a este novo cenário de tecnologias emergentes, os métodos e técnicas de usabilidade precisam de uma reciclagem e uma reflexão sobre até que ponto eles estão prontos para guiar e avaliar o desenvolvimento de aplicações destinadas a estas tecnologias. Este é o mote da Nova Usabilidade. Aguardem os próximos dois artigos.

## Referências

Marcus, A. “Mobile User Interface Design: For Work, Home, and On the Way”. In ACM SIGCHI 2004. ACM, Viena, Austria, 2004.

Apple. iOS Human Interface Guidelines. Disponível em <https://bit.ly/rp2HZh>.

IHC 2006. Workshop de Usabilidade de Aplicações e Tecnologias Emergentes: a Necessidade de uma “Nova Usabilidade”?. Disponível em: <https://www.dimap.ufrn.br/ihc2006/workshop.php>

Peter Thomas and Robert D. Macredie. 2002. Introduction to the new usability. ACM Trans. Comput.-Hum. Interact. 9, 2 (June 2002), 69-73. <https://doi.acm.org/10.1145/513665.513666>

Peter Thomas and Harold Thimbleby. 2002. The new usability: the challenge of designing for pervasive computing. In Proceedings of the 15th international conference on Computer communication (ICCC &#8217;02), S. V. Raghavan and Sudhir P. Mudur (Eds.). International Council for Computer Communication, Washington, DC, USA, 382-388.

Kelma Madeira et al. Uma Avaliação do Orkut utilizando Personas sob a ótica da Nova Usabilidade. In: VIII Simpósio Brasileiro de Fatores Humanos em Sistemas Computacionais (IHC 2008), Porto Alegre, 2008.

 [1]: https://tableless.com.br/introducao-ao-responsive-web-design/