---
title: Usabilidade e a Utilidade dos Elementos
authors: Lenilson Nascimento
type: post
date: 2014-07-02
excerpt: A utilidade dos objetos na vida real, e dos elementos na web, vão muito além do que o criador imaginou. Já parou pra pensar nisso?
url: /usabilidade-e-utilidade-dos-elementos/
dsq_thread_id: 2765360165
categories:
  - Tecnologia e Tendências
  - UX
tags:
  - design
  - usabilidade

---
A Usabilidade está completamente ligada à utilidade e ao propósito de cada elemento ou objetos que criamos. Na verdade a própria palavra já nos traz logo em mente o método como algo é usado, e nos remete diretamente à facilidade deste uso.

Há poucos dias, andava eu pesquisando sobre o assunto e vi este vídeo de Donald Norman: Obs: O vídeo tem legendas 🙂

[youtube https://www.youtube.com/watch?v=NK1Zb_5VxuM]

Posso dizer que não me seria necessário acrescentar mais nada neste momento, pois, assistindo ao vídeo, o leitor já está totalmente inteirado do que estou querendo mostrar, mas para não ficar vago o texto, vamos há alguns conceitos.

## Affordances

O conceito de affordance(s) é:

> **Affordance** é a qualidade de um objeto, ou de um ambiente, que permite que o indivíduo realize uma ação.

Já foi falado um pouco sobre isso [neste post do Raphael Fabeni][1].

Em suma, podemos dizer que Affordance, é uma propriedade, ou uma característica de um determinado objeto ou elemento, que permita com que seu usuário possa realizar uma ação.

Tomemos como exemplo o vídeo acima.

Nele, Donald Norman nos mostra como ele pode utilizar um objeto de vários formas diferente, como, por exemplo o livro.

Você pode utilizar o livro para ler, ou simplesmente, cobrir-se da chuva com ele. Você pode também arrancar uma página dele e usar para escrever algo. (O livro é seu, utilize-o como quiser!)

Da mesma forma, em nossos sistemas, devemos tomar em consideração, que um elemento pode proporcionar diversas possibilidades de ações para o usuário, ou também pode ter apenas uma ação.

## Indo um pouco além

Com os conceitos de affordances em mãos, vamos ao nosso real objetivo: Usabilidade.

É interessando pensarmos que, o usuário, mesmo não sendo tão experiente, sabe que um botão é para ser clicado e realizar determinada ação. Seja ela enviar um formulário, ou completar um cadastro em um site.

Então devemos em nosso Design, pensar de maneira que, um botão se pareça com um botão, e que as partes que são clicáveis em nosso sistema ou site, se diferencie da demais, como no exemplo à seguir:

<img class="alignnone size-full wp-image-43022" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/06/wikipedia.jpg" alt="Wikipedia" width="1150" height="453" srcset="uploads/2014/06/wikipedia.jpg 1150w, uploads/2014/06/wikipedia-400x157.jpg 400w" sizes="(max-width: 1150px) 100vw, 1150px" />

<img class="alignnone size-full wp-image-43024" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/06/publicopt.jpg" alt="publicopt" width="781" height="504" srcset="uploads/2014/06/publicopt.jpg 781w, uploads/2014/06/publicopt-400x258.jpg 400w" sizes="(max-width: 781px) 100vw, 781px" />

Note que, no site do Wikipedia, todos os links estão em Azul, então é simples para o usuário perceber que em qualquer elemento azul no meio do texto em que ele clicar, será submetido à uma outra página falando algo sobre aquele assunto.

Em contrapartida, no site <a title="publico.pt" href="https://www.publico.pt/" target="_blank">publico.pt</a> temos vários links, porém estes não são tão perceptíveis. Eles estão: No título da notícia, no nome do autor e em vários outros elementos.

Chamamos o primeiro conceito de Affordance percebida, onde temos um elemento que você logo percebe sua utilidade e sabe que poderá realizar determinada ação. E o segundo de Affordance escondida, onde podemos realizar determinada ação, mas não percebemos logo de cara.

A melhor prática, é que você tenha quase sempre, Affordances Percebidas, para que o usuário identifique imediatamente a real utilidade para aquele elemento. Como é o caso do bootstrap, onde um botão realmente parece um botão, e logo da vontade clicar nele.

## O usuário nem sempre usará da forma que esperamos

Como Donald Norman diz no vídeo, um mesmo objeto ou elemento pode ter Affordances que o Designer nunca imaginou.

Muitas vezes, desenvolvemos um elemento, ou até mesmo um sistema completo, com um propósito definido em nossa mente, ou pelo cliente que nos pediu esse determinado fim para o projeto. Porém, o usuário utiliza o sistema de formas que nunca imaginamos.

Como é o caso citado no [post do Manoel Netto][2]. Onde ele fala sobre o DropBox.

A real utilidade do DropBox é fornecer um espaço onde você fará backups de seus arquivos em nuvem para ter a segurança de que, se você perder este arquivo localmente, basta acessar sua conta no DropBox e baixar novamente o arquivo.

Simples e objetivo, mas o usuário às vezes nos surpreende.

Como o Manoel Netto explica, muitos usuários utilizam o DropBox como uma ferramenta para hospedar imagens e gerar links para utilizá-las em sites e sistemas. Ou até mesmo para hospedar um site!

São Affordances que a equipe por trás do DropBox talvez nunca tenha pensado, e que, pode abrir um novo horizonte de mercado à ser atacado, como por exemplo, uma ferramente voltada totalmente para hospedagem de imagens e sites!

## Conclusão

Creio que não tenho mais nada à falar sobre o assunto, visto que a este ponto o leitor já deve ter entendido bem o que eu queria mostrar.

Pense nesta questão das Affordances, e passe a aplicar este conceito em seus elementos, para que estes, possam atrair à atenção do usuário para si.

E para finalizar, um slide falando um pouco mais sobre o tema:

<a title="Slide Affordances" href="https://pt.slideshare.net/ivogomes/affordance-5740794" target="_blank"> Slide Affordances</a>

 [1]: https://tableless.com.br/transicoes-inteligentes-na-experiencia-usuario/ "neste post do Raphael Fabeni"
 [2]: https://tableless.com.br/cinco-tipos-de-aplicativos-que-voce-deveria-usar-corretamente/ "Cinco tipos de aplicativos que você deveria usar corretamente"