---
title: URLs Amigáveis, Design Responsivo e o SEO
authors: Douglas Faria
type: post
date: 2013-08-28
excerpt: Conheça algumas práticas legais para você não fazer feio nas buscas feitas por mobile.
url: /urls-amigaveis-design-responsivo-e-o-seo/
dsq_thread_id: 1652335084
categories:
  - SEO
tags:
  - design responsivo
  - Otimização para mobile
  - URLs Amigáveis

---
Recentemente, o <a title="Google e as mudanças para Mobile" href="https://googlewebmastercentral.blogspot.com/2013/06/changes-in-rankings-of-smartphone_11.html" target="_blank">Google anunciou</a> mudanças em seu algoritmo para o rankeamento de dispositivos móveis. O intuito é penalizar aqueles sites que ainda não aderiram ao design responsivo e beneficiar os que já estão com a tecnologia implementada. Confira aqui alguns pontos considerados chave pelo Google para aprimorar os resultados mobile.

## URL Amigável e Design Responsivo

Essa é uma relação bem interessante. Antigamente os sites mobile ficavam armazenados em um diretório à parte, geralmente um subdomínio (m.seusite.com.br). Hoje o design responsivo nos dá muito mais liberdade para desenvolver e possibilitar ao usuário uma experiência melhor.

Você deve estar se perguntando: Ok, mas e o Google? O que acontece é que quando fazemos nosso site com design responsivo, a URL de acesso de uma página para desktop é a mesma para o mobile. Se você relacionar isso com a URL amigável (O que é essencial) você ganhará uma estrelinha do Tio Google.

Isso porque o Google já disse que <a title="Google prefere URL Amigável e design responsivo para mobile" href="https://googlewebmastercentral.blogspot.ca/2012/06/recommendations-for-building-smartphone.html" target="_blank">prefere soluções móveis que mantêm a mesma URL em todas as plataformas</a>. E em junho deste ano ele se posicionou de forma oficial, dizendo que sites que trabalham dessa forma serão favorecidos nas buscas móveis.

## Porque o Google valoriza essa prática? 

### Motivo 1: Compartilhamento

Quando sua URL é única, o compartilhamento fica mais viável pois os plug-ins das Redes Sociais passam a informação com mais eficiência e, de quebra, você ganha autoridade para desktop, smartphones, tablets e afins.

### Motivo 2: Redirects são mais lentos

Um quesito que o Google tem dado muita importância é a velocidade do site. Quanto tempo seu site demora para passar a informação ao seus visitantes? Isso é ruim para o seu negócio, pois o usuário decide muito rápido se fica ou não em uma página, e para a sua busca, uma vez que o <a title="SEO com foco no Usuário" href="https://tableless.com.br/o-seo-moderno-e-o-foco-no-usuario/" target="_blank">Google foca sua experiência no usuário</a> e ele vai te penalizar se o seu site não for rápido.

O que acontece nesse caso é que os Redirects reduzem o desempenho, tanto no redirecionamento quanto na análise do conteúdo por meio dos motores. Uma vez que a URL é única, ele vai verificar uma vez só.

Outro ponto é o nosso glorioso (!) 3G. Pense se o site é um e-commerce. O usuário vai gastar mais tempo, dinheiro e bateria para navegar no seu site. Além disso, há a questão do servidor, que pode não ser lá grandes coisas. O fato é que um simples delay, na visão do Google, pode custar algumas posições ao seu site.

### Evite os erros comuns

O Google listou alguns <a title="Erros comuns no Mobile, segundo o Google" href="https://developers.google.com/webmasters/smartphone-sites/common-mistakes" target="_blank">erros comuns</a> que podem e devem ser evitados. Abaixo, a lista:

  * Vídeo que não se reproduzem
  * Problemas de redirecionamento
  * Mensagens 404 somente para Smartphone
  * Intersticiais de download de aplicativos
  * Links cruzados Irrelevantes
  * Page Speed

Não deixe de passar na <a title="Erros em sites mobile, segundo o Google" href="https://developers.google.com/webmasters/smartphone-sites/common-mistakes" target="_blank">página do Google </a>para trabalhar em cima desses erros (caso seu site apresente algum!).

## Conclusão

É importante se preocupar com as buscas de mobile, uma vez que esses usuários crescem muito, a cada dia e o fato de o Google ter se posicionado é um bom motivo para nos atentarmos e rever as práticas de otimização para as buscas mobile. Ficando atento à esses pontos você estará seguindo por um bom caminho, mas não se esqueça, seja criativo. Quando trabalhamos com SEO, isso é um diferencial!