---
title: Um pensamento sobre design para web
authors: Diego Eis
type: post
date: 2012-01-19
excerpt: Um pensamento sobre design impresso, desenvolvimento e design para web.
url: /um-pensamento-sobre-design-para-web/
tweetbackscheck:
  - 1356399315
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=5229";s:7:"tinyurl";s:26:"https://tinyurl.com/6wo3xqp";s:4:"isgd";s:19:"https://is.gd/s4ARj9";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 545047342
categories:
  - Artigos
  - Mercado
  - Mobile
  - Tecnologia e Tendências
tags:
  - 2012
  - Browsers
  - cotidiano
  - desenvolvimento web
  - design
  - dispositivos moveis

---
É engraçado quando designers de peças offline tentam migrar para web e ficam assustados com as diferenças no processo de criação e produção. O controle que o design para impresso tem sobre a posição dos elementos e a forma final da arte nunca (nunca?) será a mesma na web. No impresso você define precisamente as medidas, posicionando dos elementos, o tamanho das letras, entrelinhas e cores (mesmo brigando bastante nas gráficas por aí). Já na web você briga porque um determinado elemento está deslocado para a direita em um browser ou outro, porque determinada fonte é maior em uma tela e até pouco tempo só tinha um punhado de fonts para criar. Mesmo quando definimos tudo em pixels, há variações inesperadas entre browsers e dispositivos. Também lembro quando havia muita diferença de cores de monitor para monitor. Graças a Deus temos monitores LCD/LED.
  
E agora ainda temos que prestar atenção aos dispositivos que [comprimem mais pixels por ponto do que antigamente][1].

A boa experiência no design de impresso depende muito da arte inspiradora do designer, qual o papel usado, que tipo de impressão, da gráfica&#8230; em web dependemos muito do tamanho da tela, do dispositivo utilizado, do browser, da configuração do texto, velocidade da internet e do computador. São muitas variações para tentarmos manter o controle de cada detalhe.

Quando um designer faz peças para uma campanha ou algum projeto offline, dependendo do caso é necessário criar peças para diversos formatos de veiculação em outdoors, revistas, posters etc. Em relação a web, nós temos todos os formatos de telas que envolvem tablets, notebooks, monitores, TVs e celulares&#8230; Com um diferencial: cada uma dessas telas tem um tipo de comportamento diferente dependendo da manipulação do dispositivo e também do usuário. Em alguns dispositivos como tablets e mobiles em uma tela temos dois formatos: retrato e paisagem. Já no impresso não há manipulação pelo usuário. A estimulo é totalmente visual e muitas vezes tátil. Mesmo assim, a experiência que a web entrega é totalmente outra.

No design impresso, [quanto mais proporcional, harmoniosa e equilibrada][2] for a peça, melhor será recebida. No design para web também: os layouts precisam ser proporcionais em cada um dos dispositivos e harmoniosos em cada navegador, além da acessibilidade para alcançar usuário distantes.

Mas em ambas a [personalidade é a plataforma para a emoção][3] do usuário. Seja online ou offline, o layout, a forma com que o usuário o consome deve leva-lo para uma experiência diferente do normal. E não estou falando de hotsites feitos em flashs ordinários puramente comerciais.

Eu queria ser designer para entender melhor os conceitos que envolvem esse assunto e talvez explicar tudo isso com mais propriedade.

Assim como não é possível escrever uma linha de código sem saber os porquês da importância do código semântico e acessível, não é possível desenhar um website sem ter a plena certeza de que qualquer usuário terá uma experiência envolvente e agradável.

O design para web está mudando de novo outra vez por causa da explosão de novos dispositivos. Se você ainda não parou para pensar, pense: faça as contas das telas: notebooks, monitores, tablets e smartphones. Sendo que cada uma destes tipos de telas tem diversas variações de tamanho e principalmente de resoluções. Já disse que a [experiência do usuário precisa ser cross-device][4], caso contrário, algo se perde.

Eu [queria mesmo era fazer um carro][5].

 [1]: https://www.alistapart.com/articles/a-pixel-identity-crisis/?utm_source=TablelessComBr&utm_medium=postLink&utm_campaign=citacaoTexto
 [2]: https://www.luli.com.br/2009/02/02/design-e-uma-conversa-revista-webdesign/?utm_source=TablelessComBr&utm_medium=link&utm_campaign=citacaoTexto
 [3]: https://www.alistapart.com/articles/personality-in-design/?utm_source=TablelessComBr&utm_medium=postLink&utm_campaign=citacaoTexto
 [4]: https://tableless.com.br/experiencia-cross-device/
 [5]: https://www.bmwblog.com/2008/08/08/behind-the-design-of-the-bmw-7-series/