---
title: Um novo mundo com Big Data
authors: João Paulo de Almeida
type: post
date: 2013-07-24
excerpt: Entendendo um pouco sobre informações e big data.
url: /um-novo-mundo-com-big-data/
dsq_thread_id: 1472881481
categories:
  - Artigos
  - Geral
tags:
  - BigData
  - DataScience
  - Hadoop
  - PageRank

---
Nos últimos 3 anos foram criados cerca de 93% de todo conhecimento web que possuímos atualmente. O que fazer com tanta informação? Onde armazenar tudo isso?

Muitos de nós colocamos em duvida o futuro da informação, principalmente quando se fala em armazenamento de conteúdo. Eis algumas informações que talvez você não saiba:

  * Em 2049 um computador de aproximadamente 1000 reais irá exceder toda a espécie humana em capacidade de computação.
  * Ainda neste século, os dados tornarão preciosos valendo muito dinheiro.
  * Em 5 anos toda quantidade de informação que possuímos hoje irá crescer 800%
  * Em 2020 teremos o equivalente a 35 zetabytes de informação
  * 90% dos dados são desestruturados ou seja, as empresas não conseguem gerenciar ou extrair informações deles.
  * O número de SMS enviados por dia ultrapassa a quantidade de pessoas no planeta.
  * 294 bilhões de emails são enviados por dia cerca de 1 a cada .00000015 segundos.
  * 97000 tweets a cada segundo
  * Mais de 400 tweets por minuto contém link do youtube
  * Mais de 250 milhões de fotos são postados no facebook por dia
  * Os internautas gastam o equivalente a 2.9 bilhões de horas no youtube por mês
  * Temos cerca de 5.3 bilhões de celulares no mundo, 22% deles são smartphones
  * Os números de smartphones irão ultrapassar o número de pcs instalados ainda neste ano de 2013
  * Apenas 4% dos smartphones estão protegidos com softwares de segurança
  * Possuímos mais de 200 milhões de blogs ativos
  * 34% desses blogs postam opiniões sobre produtos e marcas
  * 90% dos consumidores confiam nas opiniões postadas nos blogs
  * As empresas tomam decisões com base nos dados estruturados, que totalizam 10% apenas do cenário de dados.

Tudo isso pode ser visto como um grande problema ou como uma grande oportunidade?

### Você já ouviu falar em Big Data? E DataScience?

Big Data são metodologias de armazenamento e consumo dos dados produzidos mundialmente, que visa dar um destino para toda essa informação, seja este fim apenas de armazenamento como também em grandes oportunidades de negócio.

Com o Big Data podemos prever por exemplo os padrões de comportamento e consumo humano e propor compras, marcas e produtos.

Você pode se perguntar agora: Isto não são os anúncios que os sites me propõe? O que tem de novo nisso?

Big Data não é tão simples quanto um recomendador de produtos online, ele é muito mais que isso, podemos dizer que big data é a união entre Estatística, matemática e arranjo de dados, que através de fórmulas complexas gera-se tendências de dados que podem ajudar a prever comportamentos humanos.

**No que isso pode ser útil?**

Nos EUA está se testando um sistema que prevê possíveis cenários de crimes e envia alertas para a policia local para se dirigir até o local. Essa previsão é feita por uma série de sobreposições de históricos de crimes locais agregados a técnicas de média e de mediana capazes de criar padrões de ocorrência de crimes alertando as autoridades de um possível problema prestes a ocorrer.

Possuímos também outro caso real onde um smartphone munido de um software com algoritmos de DataScience prevê padrões de desvios de batimentos cardíacos que representa riscos de infartos por exemplo e avisa o médico responsável antes que o problema se agrave. Este padrão é criado pela leitura dos batimentos cardíacos que são mapeados e comparados com os padrões criados pelo software, caso os padrões se tornem semelhantes, indica que a pessoa está entrando numa possível crise cardíaca.

Estes são casos reais onde demonstram que a correta manipulação das informações podem trazer benefícios as pessoas que não necessariamente precisam estar vinculadas a saúde. Vamos para outro caso real:

Uma grande empresa de vendas nos EUA contratou uma consultoria de Big Data para encontrar padrões de compras entre as mulheres que estão no inicio da gravidez. Com base no estudo que levou alguns meses, identificaram uma lista de 20 produtos que as mulheres grávidas compravam logo no inicio da gestação. Com base neste padrão de comportamento a empresa de vendas começava a disparar e-mail marketings para suas possíveis e futuras mamães oferecendo talcos, fraldas, mamadeiras etc. O incrível de tudo isso, é que eles conseguiam acertar com 94% de precisão as futuras mães. Com isso as vendas se intensificaram e hoje expandiram a pesquisa para outros setores oferecendo produtos para diversos tipos de consumidores.

Existem várias ferramentas e técnicas no mercado capaz de ajudar o DataScientist a encontrar esses padrões como:

  * Hadoop, banco de dados dedicado a armazenar e gerenciar grandes volumes de dados
  * Técnicas de Map Reduce
  * PageRank e TrustRank
  * Clustering e Machine Learning entre outros.

Para que você possa se aventurar por esta área se faz importante o gosto por estatística e matemática, assim como conhecimentos avançados em JAVA e ambientes linux.

A Revista Harvard Business publicou em outubro do ano passado que a área de DataScience se tornará até 2015 a profissão mais procurada de todas, pagando muito bem por ótimos cientistas capazes de organizar e extrair informações valiosas da montanha de dados produzidos diariamente.

Algumas referências para vocês aprenderem mais:

  * [Curso de Data Science Coursera.][1]
  * <a href="https://www-01.ibm.com/software/data/infosphere/data-scientist/" target="_blank">IBM Data Scientist </a>

Isto foi apenas uma amostra de uma área incrível e promissora. Espero que tenham curtido e ficado curiosos a respeito. Até uma próxima.

 [1]: https://www.coursera.org/#course/datasci