---
title: Um guia completo de tipografia para a web
authors: Dani Guerrato
paid: true
type: post
date: 2012-12-12
excerpt: Entenda os princípios da tipografia na web e saiba como melhorar a leitura dos usuários.
url: /um-guia-completo-de-tipografia-para-a-web/
tweetbackscheck:
  - 1356469473
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=7500";s:7:"tinyurl";s:26:"https://tinyurl.com/ac4b65d";s:4:"isgd";s:19:"https://is.gd/G54CyQ";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 970541542
categories:
  - Design
  - O Básico
  - Técnicas e Práticas
tags:
  - 2012
  - font
  - tipografia

---
Mesmo que você seja exclusivamente desenvolvedor front-end ou programador e passe bem longe de qualquer assunto relativo a design é importante saber um pouco sobre tipografia. Afinal, a maior parte do conteúdo da web é texto. Alguns até argumentam que [95% da informação disponível na internet está em linguagem escrita][1]&#8230; Estatísticas polêmicas a parte, o fato é que é fundamental começarmos a tratar a tipografia não apenas como algo bonitinho e sim como uma parte fundamental da user interface.

Se a maior parte do tempo que um usuário gasta em um site é lendo o conteúdo é nossa obrigação fazer disto uma tarefa fácil e agradável. A regra fundamental de &#8220;não faça o usuário pensar&#8221; deve também ser estendida a tipografia. Podemos adicionar &#8220;não faça o usuário forçar a vista&#8221;, &#8220;não faça o usuário colar a cara no monitor para entender o seu conteúdo&#8221;&#8230; Um site deve ser fácil de usar e para isto ele precisa ser fácil de ler. E usar desculpas do tipo &#8220;Ah, mas ele pode aumentar o tamanho do texto pelo browser&#8221; é demagogia pura. Imaginar que todo usuário final sabe configurar o tamanho do texto é uma ilusão confortável. Minha tia demora para encontrar o ícone do jogo de paciência na área de trabalho e me liga toda vez que precisa espetar o pen drive na entrada USB&#8230; Conhecer tipografia é garantir que o seu usuário tenha uma boa experiência de navegação independente de seu nível de conhecimento técnico e, consequentemente, que seu cliente não perca visitas. Para isto é necessário conhecer alguns conceitos básicos. E pode ser até divertido&#8230; Não vou vomitar regras neste artigo nem ensinar como criar e escolher fontes. A minha intenção aqui é fornecer algumas dicas teóricas e práticas sobre como melhorar a experiência de leitura na internet. Vamos a elas!

(E não. Simplesmente [ficar longe da Comics Sans][2] não te faz um expert em tipografia para a internet.)

## Alinhamento

A nossa direção natural de leitura no ocidente começa pelo canto superior esquerdo e depois caminha para a direita. Este é um dos motivos pelos quais textos alinhados a esquerda ou justificados são mais fáceis de ler, já que todas as linhas são iniciadas em um mesmo ponto.

Blocos de texto alinhados a direita são difíceis de ler já que o ponto inicial de cada linha é completamente irregular. Textos centralizados também possuem o mesmo problema, mas podem ser usados para destacar blocos curtos de informações como títulos e citações.

<img class="alignnone size-full wp-image-7518" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/alinhamento.png" alt="" width="720" height="480" srcset="uploads/2012/12/alinhamento.png 720w, uploads/2012/12/alinhamento-300x200.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

O caso de textos justificados é um pouco mais complexo. O problema principal aqui é que na internet não existe hifenização. Por conta disto lacunas (também conhecidas como rios) são criadas entre as palavras o que torna a leitura muito desagradável. Ou seja, justifique apenas textos bem curtos que você possui um controle total. Palavra por palavra. Se é algo dinâmico esqueça pois muitas vezes o cliente final não vai ter este tipo de cuidado&#8230;.

<img class="alignnone size-full wp-image-7525" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/lacunas.png" alt="" width="720" height="480" srcset="uploads/2012/12/lacunas.png 720w, uploads/2012/12/lacunas-300x200.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

É claro que nenhuma destas regras é inquebrável. Mas para quebrar regras é necessário primeiro conhece-las bem. Então se estiver na dúvida sobre qual alinhamento escolher faça o seguro e alinhe à esquerda sem justificar.

## Classificação de Tipos

A tipografia para internet é dividida em 5 famílias genéricas de fonte. Existem outras divisões e categorias utilizadas em design. Mas como o foco aqui é internet, só vou destrinchar o que está valendo para a web. As imagens dos exemplos abaixo foram retiradas da documentação da W3C no esboço [CSS Font Modules Level 3][3].

#### Serif

São os tipos que contem serifas, ou seja, pequenos traços, ornamentos e/ou prolongamentos que ocorrem no fim das hastes das letras.
  
**Exemplos de tipos:** Times New Roman, Baskerville, Bookman, Century, Georgia, Garamond e Rockwell.

<img class="alignnone size-full wp-image-7538" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipos-serifados.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipos-serifados.png 720w, uploads/2012/12/tipos-serifados-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

#### Sans-serif

Literalmente &#8220;sem serifa&#8221;. Este conjunto de tipos possui caracteres com hastes simples, sem nenhum tipo de ornamento.
  
**Exemplos de tipos:** Helvetica, Arial, Futura, Gill Sans, Univers e Frutiger

<img class="alignnone size-full wp-image-7539" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipos-sem-serifa.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipos-sem-serifa.png 720w, uploads/2012/12/tipos-sem-serifa-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

#### Cursive

As fontes desta familia possuem caracteres inclinados, ligados e/ou conectados remetendo a escrita manuscrita. Também conhecida como Script ou Brush.
  
**Exemplos de tipos:** Comic Sans MS, Blackadder ITC, Lucida Handwriting, Brush Script

<img class="alignnone size-full wp-image-7540" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipos-cursivos.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipos-cursivos.png 720w, uploads/2012/12/tipos-cursivos-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

#### Fantasy

São fontes puramente decorativas, mas que ainda representam caracteres. Normalmente não possuem uma boa legibilidade.
  
**Exemplos de tipos:** Papyrus, Impact, Haettenschweiler, Copperplate

<img class="alignnone size-full wp-image-7541" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipos-fantasy.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipos-fantasy.png 720w, uploads/2012/12/tipos-fantasy-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

#### Monospace

Todos os caracteres das fontes monospace possuem a mesma largura fixa. Este tipo é frequentemente utilizado para códigos de computador.
  
**Exemplos de tipos:** Courier, Prestige Elite, Fixedsys e Monaco

<img class="alignnone size-full wp-image-7548" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipos-monospace.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipos-monospace.png 720w, uploads/2012/12/tipos-monospace-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

Algumas fontes podem entrar em mais de uma categoria. Por exemplo a Courier é monospace E serifada.

#### Qual família escolher

Não vou entrar muito neste mérito por que isto já seria conteúdo suficiente para não apenas um artigo mais livros inteiros sobre o assunto&#8230; Mas, considerando a internet como meio, muitas vezes a escolha recai entre as duas principais categorias serifa e sem-serifa. Afinal, ninguém em sã consciência vai utilizar um tipo fantasy ou cursive para longos blocos de texto na web. Eu espero. Por um tempo existiu um mito de que fontes sem serifa tem a legibilidade melhor na internet por que os browsers renderizam as serifas com menos nitidez&#8230; Mas isto só é valido se você for considerar um font-size menor que 12 pontos. Em tamanhos maiores as duas categorias ficam empatadas e o que deve ditar a escolha é o estilo geral do design da página. Se você não é designer e não faz ideia como escolher, o tipógrafo [Oliver Reichestein criou uma analogia interessante][4]: Os tipos serifados são como padres e os sem serifa são como hackers. Vou explicar melhor&#8230; Um não é exatamente melhor que o outro, mas padres possuem uma visão de mundo mais autoritária, enquanto hackers são mais democráticos. É uma dica interessante, mas não leve isto tão a sério. Não da para resumir toda a história da tipografia em uma analogia. Combinar os dois tipos de fonte também pode causar um efeito de contraste interessante.

## Tamanho

Se você fez trabalhos para escola ou faculdade provavelmente se lembra daquelas regrinhas da ABNT para diagramação de texto como tipo Times New Roman, tamanho 12, espaçamento entrelinha 1.5. E isto é bom. Para um papel. O computador não é um papel. O tamanho padrão de texto de um browser é 16px. Este não é um número aleatorio. Ele foi escolhido por uma razão. Quando lemos um livro ou um trabalho acadêmico seguramos o papel a uma distância bem próxima dos olhos. Quando mexemos em um computador desktop ou notebook a distância em relação a tela é muito maior. Por isto é necessário que o texto esteja em um tamanho confortável em relação a esta distância. E isto deve ser customizado de acordo com a mídia, afinal, esta distância de leitura também vai variar em um smartphone, tablet, televisão&#8230; E todos estes fatores devem ser levados em conta. No geral, quanto maior a distancia do leitor em relação ao meio maior deverá ser o tamanho da letra. Se estiver na dúvida faça o seguro e utilize 16 px.

#### A unidade de medida ideal

Existem diversas medidas para texto aceitas para tipografia na internet. São elas ponto (1/72 de uma polegada), pica (12 pontos), milímetro, porcentagem, EM e pixel. Vou me focar nas duas últimas já que são as mais utilizadas para a web.

Para quem não sabe 1 EM (ou um quadratim) é uma medida relativa e corresponde ao tamanho do corpo quadrado da letra M de uma fonte. Já um pixel é uma medida absoluta e corresponde ao menor ponto possível em uma tela digital (a densidade de pixels pode variar de acordo com a mídia, mas isto é papo para outra hora).

Em todos os meus trabalhos para internet eu utilizo a medida EM para textos. Isto pode ser encarado como uma questão pessoal, mas eu tenho alguns argumentos a favor do EM. E não muitos em favor dos pixels&#8230;

**Usabilidade.** Pode ser minoria mas existe sim quem queira alterar o tamanho do texto pelo browser. Principalmente pessoas com algum tipo de deficiência visual. Você não quer que o seu layout quebre nesta hora, certo? E no caso de zoom? O texto fatalmente ficará rasterizado se você utilizar qualquer medida absoluta como é o caso dos pixels.

**Design responsivo.** Sempre surge um aparelho novo para complicar a vida dos devs. Por mais que estejamos preparados para smarthphones, tablets e computadores, o que fazer quando surge algo fora destes padrões? Sair por aí editando o código de todos os sites que você já desenvolveu? Largar o cliente na mão? Ficar caçando break points em pixels é um trabalho sem fim e desnecessário&#8230; Utiizar EM é garantir que seu texto possuirá boa legibilidade independente do tamanhos de tela.

**Proporção.** Eu sou designer e desenvolvedora front-end. Mas existem pessoas que dedicam suas vidas inteiras a tipografia e não é a toa. É uma ciência complexa e não tão subjetiva assim. Principalmente quando o assunto é proporção e distância, a questão deixa de ser gosto pessoal e passa a ser matemática. Por isso, mesmo no caso de paddings e margens, quando se trata de textos é melhor utilizar EM. Isto acontece por que 1 EM é exatamente igual ao valor quadrado da fonte ou seja, sua margem vai ficar simétrica e proporcional. E mesmo que você altere a família tipográfica, não será necessário também alterar as distâncias.

#### E uma dica

Esta regrinha é meio manjada mas é sempre bom relembrar. Você está com preguiça de calcular? Finja que EMs são pixels com um ponto no meio! Padronize para o CSS a regra { font-size: 62.5%; }. Desta maneira 1 EM equivalerá a 10 pixels. Com a base decimal fica muito mais fácil de realizar a conversão. Se você precisar de 12 pixels, por exemplo, é só colocar 1.2em, 16 pixels serão 1.6 em, etc&#8230;

<pre>html {
font-size: 62.5%;
}</pre>

## Largura dos blocos de texto

É necessário também um cuidado especial com a composição do texto. Se o tamanho das linhas for muito largo ou muito estreito isto dificulta a leitura e cansa o olho mais rápido. De 10 a 15 palavras por linha é a quantidade ideal. Ou cerca de 65 caracteres (incluindo espaçamento).

O escritor e tipógrafo Robert Bringhurst criou uma regra útil que você pode utilizar se se você quiser uma medida ainda mais precisa para a largura. Basta multiplicar o tamanho da sua fonte em pixels por 30 que você terá a largura ideal. Por exemplo se o tamanho do texto é 16px multiplique por 30 que você terá a largura certa para a sua coluna (no caso 480px). Considerando um font-size de 62.5% o resultado final ficaria assim:

<pre>p {
font-size: 1.6em;
max-width: 480px;
}</pre>

## Peso

O peso é a grossura dos caracteres de um tipo. Este atributo é definido pela propriedade font-weight. Pode ser normal, bold (negrito), bolder (mais negrito) e lighter (mais fino). Ou ainda, se estas opções estiverem disponíveis na fonte que você escolheu, variar entre um valor numérico de 100 a 900. Sendo a correspondência:

  * 100 &#8211; Thin
  * 200 &#8211; Extra Light (Ultra Light)
  * 300 &#8211; Light
  * 400 &#8211; Normal
  * 500 &#8211; Medium
  * 600 &#8211; Semi Bold (Demi Bold)
  * 700 &#8211; Bold
  * 800 &#8211; Extra Bold (Ultra Bold)
  * 900 &#8211; Black (Heavy)

<img class="alignnone size-full wp-image-7545" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipos-pesos.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipos-pesos.png 720w, uploads/2012/12/tipos-pesos-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

Cuidado aqui. Principalmente se você for usar uma fonte não web-safe. Se o peso da fonte estiver em numerais e você utilizar &#8220;bold&#8221; o seu browser irá automaticamente criar um falso negrito em torno da fonte. E isto vai atrapalhar bastante o design dela, que ficará com um aspecto grosseiro e com diferenças sutis, porém perceptíveis, na renderização de cada navegador&#8230; Verifique com cuidado quais opções de peso estão disponíveis ao escolher uma fonte. Famílias gratuitas normalmente tem opções limitadas, enquanto fontes pagas possuem uma variedade maior de pesos. Para evitar este problemas utilize a regra font-weight: normal em seu reset. Principalmente se você estiver utilizando um normatizador como o HTML5 boilerplate.

<pre>h1, h2, h3, h4, h5, h6 {
font-weight: normal;
}</pre>

<img class="alignnone size-full wp-image-7547" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/fake-bold.png" alt="" width="720" height="240" srcset="uploads/2012/12/fake-bold.png 720w, uploads/2012/12/fake-bold-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

## Contraste

Ler em um monitor é cansativo. Isto acontece por que as telas são iluminadas e ficar olhando muito tempo para fontes de luz é incomodo. Para minizar esta condição é fundamental tomar um cuidado com o contraste de cores do texto.

Ah, o contraste 100% no caso de monitores também não é recomendável. Quando a cor do fundo for completamente branca um cinza bem escuro como #333 ou #444 é mais confortável para leitura do que o preto total (#000).

Lembre-se que contraste não é apenas cor. Contraste é tamanho, peso, distancia&#8230; É necessário que os links, por exemplo, possuam algum elemento que os diferencie dos demais elementos. E isto também é uma questão de usabilidade.

## Ritmo Vertical

O ritmo de um texto é definido pela hierarquia de tamanho da fonte, distancias de margens, espaçamento e entrelinhas. O ideal aqui é criar um grid horizontal para manter o ritmo equilibrado.

<img class="alignnone size-full wp-image-7522" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/baseline-grid.png" alt="" width="720" height="480" srcset="uploads/2012/12/baseline-grid.png 720w, uploads/2012/12/baseline-grid-300x200.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

Ritmo vertical é um assunto complexo que poderia render [um artigo inteiro][5]&#8230; Mas se você for levar daqui apenas uma informação se preocupe com o valor entrelinha (line-height). Algo como 140% da altura da fonte é uma boa medida padrão. Se você quiser ser ainda mais preciso pode utilizar alguma ferramenta de calculo com base na proporção aurea como a [Golden Ratio Typography Calculator][6].

Usar números múltiplos para o tamanho das fontes também é uma boa pedida (por exemplo: 16 pixels para o texto e 32 pixels para um titulo). Manter margens e espaçamentos proporcionais também é uma ótima prática.

## Ligaturas

Ligatura ou ligadura em tipografia é quando uma ou mais letras (ou sinais gráficos) são ligadas e passam a ser representadas em um único caractere. A partir do CSS3 já é possível utilizar essa feature para web no caso de fontes Open Type. Para isto basta avisar o browser que você deseja ativar esta opção.

<pre>h1 {
font-feature-settings: 'liga';
-webkit-font-feature-settings: 'liga';
-moz-font-feature-settings: 'liga';
-o-font-feature-settings: 'liga';
}</pre>

<img class="alignnone size-full wp-image-7535" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/12/tipografia-ligatura1.png" alt="" width="720" height="240" srcset="uploads/2012/12/tipografia-ligatura1.png 720w, uploads/2012/12/tipografia-ligatura1-300x100.png 300w" sizes="(max-width: 720px) 100vw, 720px" />

## Conclusão

Agora é só aplicar o que você aprendeu, pequeno padawan. Você pode utilizar a regra do @font-face (se não sabe como tem um [artigo aqui no próprio Tableless sobre isto][7]) ou alguma biblioteca de fontes como [Google Fonts][8] ou [Typekit][9]. Você pode até mesmo fazer o seguro e utilizar os nossas boas e velhas amigas web safes. Mas não importa qual fonte você escolha, o importante é ter em mente que texto é interface e não decoração.

Capitalização, kerning, condensamento, estilo, extenção, altura x, font-stacks, fallbacks&#8230; existem muitos temas sobre tipografia web que não foram cobertos neste artigo. É um mundo inteiro de possibilidades e este é apenas um ponto de partida para criar layouts com boa legibilidade e leiturabilidade. E deixar a web um lugar um pouco mais amigável.

## Dicas de Leitura

[CSS Fonts Module Level 3][10]
  
[The 100% Easy-2-Read Standard][11]
  
[Web Design is 95% Typography][1]
  
[Reactions to 95% Typography][12]
  
[Five simple steps to better typography][13]
  
[The Perfect Paragraph][14]
  
[On Web Typography][15]
  
[CSS Typography: Techniques and Best Practices][16]
  
[Oliver Reichenstein: We are the Medium][4]
  
[Compose to a vertical rhythm][5]

 [1]: https://informationarchitects.net/blog/the-web-is-all-about-typography-period/
 [2]: https://www.comicsanscriminal.com/ "Comic Sans Criminal"
 [3]: https://dev.w3.org/csswg/css3-fonts/ "CSS Font Modules Level 3"
 [4]: https://typotalks.com/berlin/de/blog/2011/05/19/oliver-reichenstein-we-are-the-medium/
 [5]: https://24ways.org/2006/compose-to-a-vertical-rhythm/
 [6]: https://www.pearsonified.com/typography/
 [7]: https://tableless.com.br/font-face-fonts-externas-na-web/ "Propriedade @font-face CSS – Fonts externas na web"
 [8]: https://www.google.com/webfonts "Google Fonts"
 [9]: https://typekit.com/ "Typekit"
 [10]: https://dev.w3.org/csswg/css3-fonts/
 [11]: https://informationarchitects.net/blog/100e2r/
 [12]: https://informationarchitects.net/blog/webdesign-is-95-typography-partii/
 [13]: https://www.markboulton.co.uk/journal/five-simple-steps-to-better-typography
 [14]: https://uxdesign.smashingmagazine.com/2011/11/29/the-perfect-paragraph/
 [15]: https://www.alistapart.com/articles/on-web-typography/
 [16]: https://sixrevisions.com/css/css-typography-02/