---
type: post
authors: Diego Eis
date: 2017-04-23T16:17:47-03:00
title: Um comentário sobre a desnecessária fragmentação da profissão designer
categories:
  - Design
  - UX
excerpt: Discutindo um pouco sobre a separação das disciplinas que compõe a profissão de Designer para Web
image: https://cdn-images-1.medium.com/max/2000/1*quLF0Gnxe2dt3Jd0rxXQQg.jpeg
---

Eu estava pra escrever um artigo comentando como a pulverização do trabalho do
Designer está atrapalhando profissionais e empresas, criando profissões cada vez
mais fragmentadas e tão especializadas que chega a ser uma piada. Até que eu li
o artigo do [Jonas Downey](https://medium.com/@jonasdowney), escrito no canal do
[Signal v. Noise](https://m.signalvnoise.com/), que descreveu tudo o que eu
gostaria de falar e mais um pouco.

O artigo é esse aqui: [The Unnecessary Fragmentation of Design
Job](https://m.signalvnoise.com/the-unnecessary-fragmentation-of-design-jobs-d5b9c8621082)

Em conjunto com esse artigo, sugiro que você ouça [o episódio do Podcast
Movimento UX](https://movimentoux.com/work/felipememoria/), onde o
[Felipe](https://medium.com/@memo) conta um pouco sobre o processo que eles
praticam na Work & Co. Nesse episódio (por volta do **1h09**), o Felipe fala que
houve um momento que por algum motivo, o mercado quebrou a disciplina do
designer em duas funções: designer visual e designer de experiência.

> "Essencialmente essa disciplina, qualquer que seja o nome que a gente dê para
> ela, é uma disciplina que foca muito nas pessoas, no lado humano da coisa. Você
tenta realmente humanizar a experiência, fazendo uma coisa para um público
especifico, entendendo esse público e realmente focando nisso." — F**elipe
Memória**

Eu nunca entendi a separação entre as disciplinas de UX e Visual Designer. Esse
é até um assunto bastante sensível para alguns. Geralmente a galera não gosta de
entrar em polêmica e acabam deixando discussões como essa para depois. Mas, na
minha humilde opinião, UX nunca fez sentido. O nome UX é para mim [um nome muito
ruim](https://medium.com/tableless/o-nome-ux-estÃ¡-errado-8d5095a6755b), que dá
a entender que a experiência do usuário é responsabilidade de apenas um
profissional, o que é uma grande bobeira. Infelizmente esse nome fixou no
mercado. O [Felipe Memória](https://medium.com/u/bec57f323414) comenta que a
experiência do usuário é um tema muito mais amplo, que contempla uma série de
fases na produção de um projeto. Ele diz que lá na Work & Co não existe o cargo
de UX, mas todos são Designers, exatamente porque Designer é uma disciplina que
não vai morrer daqui 5, 10, 100 anos… O termo UX pode morrer daqui um tempo,
assim como os nomes Web Designer, Arquiteto de Informação e tantos outros nomes
morreram dando lugar para um outro termo da moda e que também tem grandes
chances de não perdurar.

Uma pergunta: é uma boa prática trabalhar a **função** e **forma**
separadamente? Um bom design precisa ser bonito e funcional. É estranho ter
alguém que pensa na função primeiro pra depois uma outra pessoa pensar na forma.
Alguém que equilibre essas duas funções é o verdadeiro Designer. É esse
profissional que tem o bom senso aguçado, e que vai conseguir pesar a
importância da função e da forma nos momentos certos no desenho de um layout.

> "What’s the difference between UX and UX/UI and UI? Isn’t Product also UX/UI?
> Isn’t a Front End a UI? What’s a Graphic Designer with UX & UI Focus? And isn’t
*all* of this Visual/Digital design? "— Jonas Downey

A profissão de UX é muito mais do que fazer um simples Wireframe. Na verdade o
Wireframe é apenas um resultado de um tempo gigante de pesquisas e entrevistas.
Mas entender o problema, pensar em soluções alternativas, quebrar a cabeça
fazendo protótipos, pesquisar e entrevistar pessoas são tarefas que um Designer
precisa fazer para dar a luz à uma interface que seja realmente bonita (forma) e
também resolva um determinado problema (função). Isso não é UX, isso é apenas
Design. São dois momentos, em uma mesma tarefa, de um mesmo profissional.

Quem nunca presenciou um atrito básico entre o UX, que faz uma tela super
burocrática, levando em consideração apenas a função, com todos os requisitos
necessários para o usuário executar uma ação, enquanto o designer briga porque
essa tela nunca vai ficar bonita, puxando a sardinha apenas para o lado da
forma. Os dois não conseguem encontrar um equilíbrio e o resultado pode ser
desastroso para o usuário, que ganha um design bonito, mas oco e ordinário ou
uma tela feia, sem atrativo nenhum, mas que tem um fluxo agradável.

> “Na Work & Co, a gente coloca o time de design inteiro pra pensar na única coisa
> que importa durante a maior quantidade de tempo possível. Nos concentramos no
principal caso de uso e redesenhamos infinitamente, na base da tentativa e erro,
até chegar em algo interessante.” — Felipe Memória

Eu não estou dizendo que apenas uma pessoa pode solucionar a fome do mundo. Mas
eu também aposto muito no [Perfil
T](https://medium.com/@diegoeis/desenvolvedor-full-stack-t-shaped-valve-7bcf67f2e011),
não apenas para desenvolvedores, mas também para Designers. Você pode ter um
Designer que tenha uma facilidade maior para lidar com usuários, outro que com
capacidade acima da média para estruturar e organizar a arquitetura da
informação, outro que tem skills avançadas no desenho da interface etc etc etc.
Aceitar e respeitar a especialidade de cada profissional é importante para
montar um time que tenha integrantes que se complementem, de acordo com o
talento e a facilidade de cada um.

Mas por favor, não diga que apenas um personagem é responsável pela experiência
do usuário, por que isso não é real. É exatamente por isso que o nome UX e
também a profissão isolada de UX não faz sentido nenhum.

* [Design](https://medium.com/tag/design?source=post)
* [UX](https://medium.com/tag/ux?source=post)
* [Web Design](https://medium.com/tag/web-design?source=post)


