---
title: Uber é 8 ou 80
authors: Tiago Dória
paid: true
type: post
date: 2015-07-14
excerpt: A história é quase sempre a mesma. Grupos profissionais estabelecidos não aceitam a concorrência do Uber.
url: /uber-e-8-ou-80/
categories:
  - Mercado
  - Tecnologia e Tendências
---

Ou você ama ou detesta o Uber.

Com a mesma rapidez que contrata executivos e desenvolvedores de Google e Facebook, o aplicativo, que conecta motoristas e passageiros, sofre processos.

A história é quase sempre a mesma. Grupos profissionais estabelecidos não aceitam a concorrência do Uber.

Entretanto, como empresa, o Uber está fazendo algo bem mais interessante: transformar os seus usuários em &#8220;ciberativistas&#8221;. Basta o Uber ser ameaçado com algum processo ou tentativa de regulamentação, que logo a empresa dispara um email convocando seus usuários a participarem de abaixo-assinados online e a promoverem hashtags em plataformas de redes sociais.

Para cada cidade que tenta bani-lo, o Uber aponta outras que permitem o serviço e tenta angariar o suporte de milhões de usuários de regiões que defendem as suas operações.

Não há novidade em transformar consumidores em defensores de sua marca. A diferença é que o Uber vai além ao transformar a empresa em uma espécie de movimento contra as forças que tentam regulamentar o que poderia ser um livre mercado.

Talvez aí esteja uma das dificuldades de se ir contra o Uber. O aplicativo não oferece somente conveniência, segurança e custo mais baixo, mas se apresenta como um [movimento][1]. Fornece, enfim, uma forma de identificação e de ação coletiva.

> Não é à toa que a chamada economia compartilhada, da qual o Uber faz parte, entrou na pauta das eleições americanas.

O Uber lembra o Google de quase 20 anos atrás. Era 8 ou 80. Se você estivesse contra o Google, estava contra a internet. Aliás, ambas as empresas surgiram na época e nos lugares certos. O Uber aparece num momento pós-crise (2008) em que a economia americana ainda se recupera e os empregos de meio período ou os chamados “bicos” são comuns. Assim como o Google há alguns anos, o Uber é a empresa que melhor representa os tempos atuais.

Não é à toa que a chamada economia compartilhada, da qual o Uber faz parte, entrou na [pauta das eleições americanas][2]. Não faltam motivos para isso &#8211; empresas como o Uber ajudam a levantar questões políticas profundas e atuais sobre como vivemos. Uma delas diz respeito a como lidar com a atual demanda pela redistribuição da economia das cidades. Por exemplo, ao descentralizar a hospedagem nas cidades, o Airbnb, serviço que conecta hospedes e residências, não estaria ajudando a descongestionar a densidade urbana e a economia das cidades, antes restrita aos grandes centros?

[Rodrigo Davies][3], ex-colega de MIT, chamou a atenção para essa ideia. Seria o Airbnb uma empresa de transformação social uma vez que incentiva as pessoas a se hospedarem na casa de estranhos de outras culturas? Para Davies, a resposta é positiva. Redistribuir a economia e promover a quebra de barreiras entre pessoas de diferentes origens não são, por certo, os objetivos visados por essas empresas, mas, no final das contas, é o que acaba por acontecer.

Ainda no campo da economia compartilhada, os pesquisadores [David Schleicher e Daniel E. Rauch][4], da Universidade de Yale, se debruçaram sobre o futuro do Uber junto a governos e empresas já estabelecidas no mercado. Relação que ainda estaria no começo.

Para os pesquisadores, o Uber e outras empresas da chamada economia compartilhada não estarão livres da regulamentação governamental. Entretanto, essa regulamentação estará voltada unicamente à proteção dos usuários. Uma das tendências levantadas pela dupla de pesquisadores é que os governos passem a enxergar as empresas da economia compartilhada como ferramentas de redistribuição da economia, chegando até mesmo a fechar parcerias com elas.

Na realidade, essas parcerias já existem. Aqui, em Boston, a [prefeitura tem uma cooperação][5] com o serviço de compartilhamento de carros Zipcar. Afinal de contas, a cidade não precisa de uma frota gigantesca de carros oficiais 24horas/7dias por semana.

Entretanto, segundo Schleicher e Rauch, essa cooperação poderia ir além. O Zipcar poderia desempenhar o papel de atender a demanda por transporte privado nas regiões menos favorecidas. Ao estabelecer um contrato de fornecimento de serviço, ficaria até mais fácil para uma empresa como o Zipcar acatar regulamentações postas pela prefeitura. Ou seja, na visão de Schleicher e Rauch, a relação entre governos e a chamada economia compartilhada caminha para um ganha-ganha.

Todavia, a conclusão mais realista da dupla de pesquisadores está no final do estudo – empresas como o Uber já fazem parte em definitivo do cenário econômico.

Em se tratando de empresas da economia compartilhada, você pode amá-las ou detestá-las, mas não pode ignorá-las.

 [1]: https://www.inc.com/magazine/201307/christine-lagorio/uber-the-car-service-explosive-growth.html
 [2]: https://www.cnbc.com/2015/07/13/in-economic-address-hillary-clinton-calls-out-gig-economy.html
 [3]: https://rodrigodavies.com/blog/2015/04/28/is-airbnb-a-civic-peace-tech-company.html
 [4]: https://papers.ssrn.com/sol3/papers.cfm?abstract_id=2549919
 [5]: https://www.zipcar.com/press/releases/zipcar-launches-new-boston-fleethub-program