---
title: Tudo sobre Favicon e como instalar ele em seu site 
authors: Tableless
type: post
date: 2017-10-14
excerpt: Você tem um favicon personalizado para o seu site? Se ainda não, realmente deveria ter um. Ele dá o toque final ao branding e ao design do seu site.
categories:
  - Favicon
  - publieditorial
tags:
  - publieditorial
  - favicon
  - Na prática
image: https://i.imgur.com/pnDV3Ov.jpg
sponsor: schoolofnet
---

## O que é um Favicon?

Na verdade, a palavra favicon significa "ícone favorito". Um favicon é um pequeno arquivo com a imagem de um ícone que é associado ao seu site. Quando alguém acessa o seu site, o navegador do visitante procura automaticamente em segundo plano pelo favicon do seu site. O favicon então é exibido em vários locais, como nas guias do seu navegador e na lista de favoritos. Geralmente, o favicon é armazenado na raiz do seu site.

![](https://i.imgur.com/UVG19KK.png)

## Principais aspectos de um Favicon

Um favicon é um pequeno ícone em forma quadrada de apenas 16 pixels de altura e 16 pixels de largura. Este ícone, muitas vezes, se assemelha ao seu logotipo e até mesmo pode ser o seu logotipo. É um arquivo no formato .ico ou .png.

No entanto, ele não serve apenas para os navegadores de desktop ou laptop. Os dispositivos iOS, dispositivos Android, dispositivos Windows 10 e todos os demais, possuem as suas próprias dimensões de tamanho e formato de arquivo para o favicon. Os dispositivos iOS usam um ícone em alta resolução para exibir o favicon dos sites marcados como favoritos e atalhos da tela inicial. Um iPhone precisa de uma imagem de 57 × 57, enquanto o novo iPad com tela Retina requer uma imagem de 152 × 152. O Android Chrome também usa essas imagens se as encontrar. E o Windows 10 usa uma maneira específica com um conjunto dedicado de ícones e declarações HTML.

## A Importância de Usar um Favicon

Você precisa de um favicon? A resposta é sim. Todo site deve ter um favicon associado a ele. Devido ao fato de que todo navegador faz uma requisição por esse arquivo, você verá um erro 404 se ele não estiver presente. O favicon.ico reside na raiz do servidor, portanto, cada vez que o navegador faz uma requisição por esse arquivo, os cookies para a raiz do servidor são enviados.

Os favicons são muito importantes para o marketing visual e para criar um vínculo com os visitantes do seu site. A adição de um favicon permitirá que o seu público subconscientemente identifique de forma instantânea o seu site que estará no meio de um mar de aplicativos ou páginas da web.

Essa familiaridade com o seu favicon ajudará o seu público a encontrar o seu site rapidamente e facilmente. Também lembrará aos usuários da existência do seu site, resultando em um aumento no tráfego e no retorno dos números de visitantes.

Por fim, um favicon ajudará o seu site a se destacar de sua concorrência e estabelecerá o seu site como uma fonte respeitável.

Como você pode ver, os benefícios de usar um favicon são enormes. Descubra agora como você pode criar um favicon e adicioná-lo ao seu site.

## Como Criar um Favicon

Olhe nas abas do seu navegador, analise o que está sendo usado como favicon. Alguns estão usando o ícone que é parte do logotipo, outros usam um ícone que representa a seção de seu aplicativo e outros usam letras.

Agora, analise o seu próprio logotipo e experimente as diferentes opções para ver o que melhor se adequa ao quadradinho. Vejo o que fica legível e o que não fica. Se o seu logo é composto apenas por um nome e se ele for longo e cheio de letras diferentes, você deve considerar incorporar um ícone em sua estratégia visual para usá-lo ou talvez criar um emblema de suas iniciais para usar como favicon. Quando você possuir um emblema ou símbolo, você também poderá usá-lo em outros lugares, como cartões de visitas ou carimbos.

Um favicon geralmente deve ter dimensões de 16 × 16 pixels ou 32 × 32 pixels. Também é recomendável mantê-lo com o tamanho menor de 1 KB ou o mais pequeno quanto possível. Você pode criar o seu favicon através de algum programa que você prefere, por exemplo, através de criadores de favicon online, programas gráficos profissionais, etc. Simplesmente salve o arquivo em formato .ico quando terminar. O ideal é que o nome dele seja favicon.ico. (Sugestão: Ao criar um favicon de seu logotipo, tente sempre usar vetores para que a qualidade não seja perdida.)

Então, como criar um favicon? Se você não possui habilidades de design ou não sabe como criar um favicon, tente criar ele usando um software online, como por exemplo, o Criador de Favicon do Logaster:

1\. Acesse o [Logaster](https://www.logaster.com.br/favicon/) e clique em "Criar um favicon”.

![](https://i.imgur.com/d9mPfQn.png)

2\. Crie um logotipo. O Logaster é um gerador online de logos, que também é um gerador de favicon, portanto, primeiro é preciso criar um logotipo para depois criar o favicon. O Logaster irá fornecer o favicon que você precisa baseado em seu logotipo. Mas não se preocupe, não leva muito tempo e nem exige esforço.

![](https://i.imgur.com/dhAEl01.png)

3\. Digite o nome do seu site, escolha o tipo de negócio e escolha o logotipo que você mais gosta. O Logaster irá gerar várias dezenas de logotipos. Contudo, você deve entender que o logotipo servirá como base para o seu favicon. Nosso objetivo é criar um favicon, então não gaste muito tempo com o logotipo, pois ele pode ser modificado mais tarde.

![](https://i.imgur.com/lCH2tRw.png) 

4\. Crie um favicon. Quando você tiver um logotipo, pressione "Criar favicon com este logo" na página do logotipo.

![](https://i.imgur.com/WqH9gtE.png)

5\. Escolha o design desejado do favicon. O Logaster gera dezenas de belos favicons prontos para usar. Selecione o design que mais lhe agrada. A pré-visualização permite que você veja como o seu favicon ficará no site.

![](https://i.imgur.com/VLXkLjb.png)

6\. Baixe o favicon e instale ele em seu site. Dependendo do seu tema ou da plataforma que você usa, a técnica de instalação pode ser diferente.

No final, você receberá o favicon no formato .ico e PNG em tamanhos diferentes. O ícone para o Apple Touch também estará disponível.

![](https://i.imgur.com/P2EeKU8.png)

## Como adicionar o favicon ao seu site

Como fazer para adicionar o favicon ao site? Basta enviá-lo via FTP para o diretório raiz do seu site e os navegadores web que oferecem suporte ao favicon irão encontrá-lo. Se você precisa ou deseja colocar seu favicon em um diretório diferente, basta adicionar o seguinte na seção &lt;head&gt; do seu site alterando o caminho do diretório. Por exemplo, no código abaixo o arquivo do favicon se encontra no diretório chamado de "imagens".

```
<link rel="shortcut icon" href="/images/favicon.ico" type="image/x-icon" />
```

## Conclusão

Os favicons pode não ser o elemento mais importante de branding para o seu site, mas eles são rápidos e fáceis de implementar e tem os seus benefícios. Eles darão ao seu site o valor adicional necessário para torná-lo profissional e se destacar em um navegador que possui várias abas abertas. Se você leu este tutorial, você está agora em uma melhor posição do que você estava antes.
