---
title: Como se tornar um dev front-end
authors: Diego Eis
type: post
date: 2013-10-09
excerpt: Alguns assuntos importantes que você, futuro dev front-end deve saber e conhecer.
url: /tornar-dev-front-end/
dsq_thread_id: 1834589356
categories:
  - Artigos
  - Código
  - Mercado
  - O Básico
tags:
  - basico
  - codigo
  - front-end
---
Esse artigo inspirou um livro, mais completo, com mais assuntos e detalhes. Olha só: [Guia Front-end][1].

* * *

Estava navegando por aí e acabei encontrando um artigo bem legal do [Leandro Oriente][2], que fala sobre um assunto muito interessante e que sempre me perguntam por aí. Decidi então escrever minha versão do artigo, colocando meus pontos de vista sobre como se tornar um desenvolvedor front-end.

Entrar na área de front-end é algo muito fácil. Você não precisa ter habilidades técnicas muito avançadas. É por isso que durante muito tempo o mercado andou saturado e muito, muito prostituído por gente que entregava trabalhos sem qualidade e que cobravam barato demais. Hoje o mercado está aquecido. É muito difícil encontrar um dev Front-end dando sopa por aí.

Eu não organizei os tópicos abaixo em ordem de dificuldade, mas dividi os assuntos na ordem que eu acho, particularmente, mais importante você aprender para atuar no mercado de trabalho. Portanto esqueça o nível de dificuldade.

O objetivo aqui é que pelo menos você conheça o caminho das pedras e tenha um checklist com assuntos mais importantes para estudar e pesquisar.

## Editores de código

Não use editores WYSIWYG. Dizendo com todas as palavras: fique longe de coisas como o Dreamweaver.

O Dreamweaver é um símbolo. Qualquer editor ou ferramenta que vire uma muleta para o dev é algo ruim. Você precisa digitar e entender de cabo a rabo o significado do código escrito. Se você tem uma ferramenta que faz tudo sozinha, você não é um desenvolvedor, você é apenas um operador de software.

Por isso procure aprender a digitar código na mão sempre. Se você está começando e tem algum editor como o [Sublime Text][3], que fica auto-completando tudo o que você escreve, desabilite essa função, pelo menos por enquanto. Isso vai te obrigar a pesquisar, a procurar a resposta, vai te forçar a lembrar daquele negócio que você esqueceu. Isso vai te fazer pensar.

## HTML

HTML é parte essencial da web. Sem HTML a web não existe. Por isso, aprenda HTML e todo o seu contexto de semântica e organização de informação. Não fique preso a versões do HTML, como: &#8220;Hoje vou aprender HTML5&#8221;. Esquece, esse negócio de versões. Você vai aprender HTML.

## CSS

Eu li não sei aonde e não consegui encontrar o link, mas um dos ban-ban-bans gringos disse mais ou menos assim: &#8220;você leva algumas horas para aprender CSS, mas uma vida para se tornar um mestre.&#8221;

CSS é simples. A maioria das propriedades você vai acabar decorando. Na verdade você não vai usar mais do que umas 15 propriedades todos os dias. É fácil encontrar algum lugar que explique o que é CSS e que lista todas as suas propriedades. Na pior das hipóteses sempre existe a [documentação do W3C para consulta][4]. O importante é que você precisa aprender algo novo de CSS todos os dias. Não importa o que, não importa como, mas você precisa aprender um truque, uma nova propriedade, uma novidade que só vai se popularizar dali alguns anos…

## Esqueça o FTP e aprenda um controle de versão

Eu não sei quantas vezes eu ouvi de devs que não usavam o Sublime Text por que não tinha FTP acoplado (!). Deixa eu dizer uma coisa e vou ser bem duro: Se você ainda edita seu código usando FTP, você é júnior. Se você baixa o arquivo pro seu computador, edita e depois sobe pro FTP, você é Júnior.

> O Dreamweaver é um símbolo. Qualquer editor ou ferramenta que vire uma muleta para o dev é algo ruim.

Um desenvolvedor que se preze aprende um controle de versão. Se você não sabe o que é um controle de versão veja [este][5], [este][6] e [este][7] link. Não é nada difícil e isso vai te salvar a vida.

Controlar seu código fonte deve ser uma premissa. Um princípio. Se você acha que o undo do seu editor predileto salva sua vida, imagina ter um undo do seu projeto inteiro. Imagine ter o histórico de edição de cada um dos arquivos do seu projeto.

Usar um controle de versão, como o [GIT][6], é pré-requisito para trabalhar em qualquer grande empresa. Algumas usam SVN, mas se você aprender a usar um deles, vai ser fácil aprender a usar o outro.

Imagine você não precisar passar horas no FTP para atualizar código, arquivos e etc. Imagine com 1 comando, você clonar seu projeto inteirinho para o servidor, exatamente do jeito que você deixou. Nada de ficar se matando por que o FTP travou, por que a conexão perdeu pacotes, por que o servidor matou a conexão, nenhum destes problemas fará mais parte da sua vida.

## O básico do terminal

Se você vai aprender GIT ou qualquer outro controle de versão, você vai precisar mexer um pouquinho no terminal. Claro, existem programas cheio de botões que facilitam as principais tarefas, mas se você tiver que atualizar o projeto direto no servidor, não tem jeito, vai precisar usar o terminal para atualizar o projeto lá.

Outro motivo é que dependendo do projeto que você se envolver, principalmente se for em Ruby, Python e coisas desse tipo, você vai precisar aprender a iniciar o projeto, parar o projeto, atualizar as dependências e algumas outras tarefas recorrentes via terminal.

> Um desenvolvedor que se preze aprende um controle de versão.

Sem falar que uma série de ferramentas essenciais para os devs front-end como [Grunt][8], [Bower][9], [Yeoman][10], [Middleman][11], [Jekyll][12] e etc, são feitos em Ruby e você vai precisar usar o terminal para fazer a mágica acontecer.

## Acessibilidade

[Acessibilidade não é altruísmo][13]. Você não faz um site acessível por que você está com pena de alguém cego ou por que não tem os dois braços. Você faz um site acessível por que você precisa que seu site seja visto por TODOS. É a mesma coisa se você não fizer um site responsivo hoje em dia. Como assim seu site não consegue ser bem visto via mobile?

Acessibilidade é algo que ainda está engatinhando aqui no Brasil, mas algo me diz que não demora muito e esse assunto vai cair na boca do povo, vai virar moda e aí todo mundo vai passar a fazer pra não ficar de fora do grupinho. Por isso, seja pioneiro e comece fazendo desde o princípio em seus projetos.

Veja aqui uma pequena [seleção de slides de palestras sobre acessibilidade][14].

Nós temos uma [categoria sobre acessibilidade][15] aqui no Tableless. Dá uma sapeada por lá.

## Javascript

O Leandro Oriente [falou no seu artigo][2] que ter uma base sólida em Javascript é um requisito essencial. É uma das únicas partes que me diferencio do artigo dele.

Javascript tem que saber sim, não estou dizendo o contrário. Mas se você sentir que não tem o menor dom (sem trocadilhos) para isso, não fique preocupado, você não precisa ser alguém avançado em Javascript para ser um bom front-end. Mas precisa entender o básico e principalmente as boas práticas. Mas se você quiser se destacar da média, e ser um ÓTIMO MOTHER-FUCKER front-end, vai ter que aprender muito, muito bem essa linguagem.

Geralmente existem dois tipos de front-ends: aqueles que ficam mais pro lado do design e outro grupo que fica mais do lado da programação. Geralmente, quem está mais perto do design tem mais dificuldades para assuntos ligados à programação. Se você for um desses, não se preocupe. Entenda qual o seu perfil, saiba no que você é forte e foque-se em melhorar sua fraqueza. Se for em Javascript, tente concentrar mais as suas forças para começar a aprender bem essa linguagem.

Para ficar claro: todo o dev front-end precisa saber pelo menos o básico de Javascript. Você vai usá-lo sempre. Por outro lado, nem todos precisam saber o que é Node, Backbone, Ember e etc&#8230; Dependendo do lugar que você trabalhar, por exemplo em agências, você só precisa saber o básico/intermediário de Javascript. Agora, se você for para algum lugar que produz seus próprios produtos, muito provavelmente você vai precisar ser rato nessas tecnologias.

### JQuery

JQuery não é Javascript. Pelamordedeus. JQuery é uma biblioteca que abstrai a liguagem original, tornando muito mais fácil seu controle.

Você precisa saber pelo menos o básico de Javascript para começar a aprender JQuery. Isso é importante!

Mesmo assim o JQuery é a biblioteca Javascript mais usada no mundo todo. Você precisa dele para rodar plugins que usamos todos os dias, para rodar outros frameworks como o Bootstrap, por exemplo. JQuery é requisito básico em algumas empresas.

## Performance

[80% da performance de um website está do lado do client-side][16]. Client-side também é responsável pro 90% da performance de um site mobile.

Você prejudica a performance se escreve um javascript ruim, se usa muitas imagens, se você não minifica seu código, se você não serve bem seus assets e uma série de outros pontos.

O Google tem um site que mostra muitos destes pontos e te ajuda a melhorar a performance do seu código. [Dá uma olhada][17].

Já falamos sobre performance [aqui][18] e [aqui][19].

## SEO

Ao contrário do que muitos acham, SEO não é feito por apenas uma iniciativa, mas várias. Não adianta nada você escrever um texto cheio de palavras chaves e a estrutura do HTML não ser semântica. Ou você ter um ótimo código HTML, mas fazer seu menu em flash (ok, eu abusei, ninguém faz mais menus em flash).

> Todo o dev front-end precisa saber pelo menos o básico de Javascript.

SEO é um trabalho que você precisa ter em várias frentes. É necessário usar as tags corretas, melhorar a performance, medir a prioridade dos links na página e várias outras coisas. O responsável por isso é o dev front-end. Não se preocupe, pesquisa de palavras chaves, relevância do texto e qualquer coisa ligada ao conteúdo não são de sua responsabilidade. Você precisa fazer com que o conteúdo seja &#8220;encontrável&#8221; e principalmente seja fácil dos sistemas de busca consumirem esse conteúdo por meio de um bom código client-side.

## WordPress

Falo para aprender WordPress por que é o mais badalado. Você pode aprender Joomla! ou Drupal, não tem problema. Mas não tem como, o WordPress é o CMS mais usado no mundo. E pessoalmente eu acho muito melhor que os outros dois.

A boa notícia é que você não precisa aprender PHP para fazer websites em WordPress. Ele está tão maduro que você consegue fazer sites relativamente complexos usando sem muitos problemas as funções que o WordPress dispõe. Se você é um freelancer, é interessante saber WordPress para poder vender o pacotinho &#8220;código client-side + wordpress&#8221;.

## Pré-processadores

Aprenda algum pré-processador. Eu, particularmente, [não gosto muito][20]. Mas eu uso bastante. E algumas grandes empresas os pré-processadores facilitam a manutenção do código CSS e o deixam escalável. O SASS é o mais utilizado. LESS é o segundo. Para se ter uma ideia LESS é usado pelo pessoal que faz o framework [Bootstrap][21].

Não importa qual pré-processador você decida usar, mas entenda que você precisa saber exatamente como eles geram o código final. Se um pré-processador for mal usado, ele pode acabar com o seu projeto. [Eu ecrevi algo sobre isso aqui][20].

## Manipulação de JSon e etc

Em algumas empresas programadores back-end não encostam no front-end. Eles não editam o HTML, nem tão pouco o Javascript. Isso acontece por que ele passa mais tempo construindo e melhorando uma API do que qualquer outra tarefa. O dev front-end por sua vez consome essa API e então começa a popular as páginas com as informações encontradas nela. Suponha que você precise fazer uma listagem em uma determinada página do projeto. As informações serão requisitadas via Javascript, que consumirá um JSon, promovido pela API. Neste JSon haverá todas as informações que você precisa exibir na página. O resto é definir o HTML e formatar com CSS. As informações virão do Javascript.

> Acessibilidade não é altruísmo.

[Para você ser um front-end top de linha][22], entender essa dinâmica é essencial. Esse tópico ficou por último por que não é algo trivial. Você precisa entender muito bem sobre boas práticas de escrita e de código e performance. Você também consegue sobreviver em muitas empresas sem ter essa skill. Normalmente isso é necessário em empresas que trabalham com sistemas. Quase nunca uma agência web terá uma necessidade assim.

## Estude a teoria

Nunca, nunca comece pela parte prática. Eu sei que praticar e colocar a mão na massa é a parte mais esperada por qualquer pessoa que está começando na área. Mas acredite em mim: se você quer ser um front-end acima da média, procure entender o &#8220;por que&#8221; das coisas.

Não basta sentar, abrir um PSD e começar escrever HTML. Há uma série de conceitos que vão te ajudar a escrever código acessível, escalável e semântico. Tem que saber que seu código vai ser consumido muitas vezes por robôs de busca, leitores de tela, browsers, scripts e etc. É responsabilidade sua entender que HTML é tudo sobre organizar e dar significado à informação.

## Concluindo

Você pode saber todos estes assuntos ou apenas alguns, não importa, você sempre terá mais informações para aprender. Existem uma série de outros assuntos que eu não abordei como por exemplo aprender Jekyll ou Middleman, entender como se usa o Grunt, RequireJS, Yeoman, Bower e etc. O artigo iria ficar gigantesco e você ficaria assustado. Por isso, eu estou escrevendo um livro que poderá te ajudar nesses assuntos todos. 🙂

Esse é o universo que os devs front-ends devem enfrentar.

Mais do mesmo:

  * [A baseline fro front-end developers][23]
  * [Como se tornar um desenvolvedor front-end][2]

 [1]: https://www.casadocodigo.com.br/products/livro-guia-frontend
 [2]: https://leandrooriente.com/como-me-tornar-um-desenvolvedor-front-end/
 [3]: https://sublimetext.com
 [4]: https://www.w3.org/Style/CSS/
 [5]: https://tableless.com.br/introducao-das-premissas-dos-controles-de-versao/
 [6]: https://tableless.com.br/iniciando-no-git-parte-1/
 [7]: https://campus.tableless.com.br/2012/10/controle-de-versão-com-git/
 [8]: https://tableless.com.br/grunt-voce-deveria-estar-usando/
 [9]: https://simplesideias.com.br/gerenciando-dependencias-client-side-com-bower
 [10]: https://yeoman.io
 [11]: https://middlemanapp.com
 [12]: https://jekyllrb.com
 [13]: https://brunotorres.net/acessibilidade-nao-e-altruismo
 [14]: https://tableless.com.br/slides-para-devs-9-acessibilidade-na-web/
 [15]: https://tableless.com.br/categoria/acessibilidade-2/
 [16]: https://developer.yahoo.com/blogs/ydn/high-performance-sites-importance-front-end-performance-7160.html
 [17]: https://developers.google.com/speed/pagespeed/
 [18]: https://tableless.com.br/performance-frontend-parte1/
 [19]: https://tableless.com.br/performance-frontend-parte2/
 [20]: https://tableless.com.br/pre-processadores-usar-ou-nao-usar/
 [21]: https://getbootstrap.com
 [22]: https://www.devmedia.com.br/revista-front-end-magazine
 [23]: https://rmurphey.com/blog/2012/04/12/a-baseline-for-front-end-developers/