---
title: Tendências Web 2015 para desenvolvedores
authors: Paula Berrocal
type: post
date: 2015-04-09
excerpt: Algumas tendências fortes que ainda veremos em 2015 e que podem perdurar ainda mais.
url: /tendencias-web-2015-para-desenvolvedores/
categories:
  - Design
  - Responsive Web Design (RWD)
  - Técnicas e Práticas
  - Tecnologia e Tendências
  - UX
tags:
  - design
  - design responsivo
  - flat
  - responsive
  - single page
  - ui
  - ux
  - video
  - web

---
O mundo dos desenvolvedores web está cada vez mais inovador e fantástico. Em 2015 teremos ferramentas mais qualificadas e conceitos que nos ajudarão na jornada de desenvolver um material super satisfatório. Pois não trará vantagens somente para nossos clientes, mas também nos poupará tempo, e para quem trabalha nessa área sabe que tempo é MUITO PRECIOSO.

## FLAT DESIGN

Sites com sombras, diversas fontes e cores para ressaltar o realismo da página ficou no passado, agora o que manda é a simplicidade. Design de empresas como Google, Twitter, Facebook e Windows 8 são exemplos fortíssimos de que isso deu certo e não vai sair de cena por muito tempo. Lembre-se: menos é mais!

[<img class=" size-full wp-image-48161 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/flat-design.png" alt="flat-design" width="730" height="400" />][1]

Pense que interessante seria se essa moda aparecesse nos tempos de IE6, quando transparencia, bordas arredondadas e gradientes não funcionavam. Era só colocar um botão com cor chapada de fundo, letra branca e pronto. Funcionaria em todos os browsers. Flat to save the devs.

## MOTION UI

A moderna forma de atrair o interesse dos usuários de forma leve e dinâmica está em alta. Frameworks te ajudam na missão de implementar mais animação em suas páginas sem fazer com que seu site fique pesado. Visite <a href="https://foundation.zurb.com/apps/docs/#!/motion-ui" target="_blank">Foundation for APPs</a> ou <a href="https://daneden.github.io/animate.css/" target="_blank">Animate.css</a> e veja os efeitos incríveis em ação.

[<img class=" size-full wp-image-48162 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/motion-ui.png" alt="motion-ui" width="730" height="400" />][2]

[Há um post aqui no Tableless][3] que fala um pouco sobre as inspirações que o Material Design do Google teve em diversos designs.

## RESPONSIVIDADE

A preocupação em se adaptar a todos os dispositivos utilizados pelos usuários hoje em dia está ficando cada vez maior entre as empresas, por isso, para não perder mais tempo, utilize de uma ajudinha amiga como <a href="https://getbootstrap.com/" target="_blank">Bootstrap</a>, <a href="https://foundation.zurb.com/" target="_blank">Foundation</a> e o novo <del>porém não menos interessante</del> <a href="https://semantic-ui.com/" target="_blank">Semantic UI</a>. Todos os frameworks são simples e contam com ótimos tutoriais disponíveis no próprio site.

[<img class=" size-full wp-image-48163 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/design-responsivo.png" alt="design-responsivo" width="730" height="400" />][4]

## SINGLE PAGES

Já viu aqueles sites em que você tem todo conteúdo em uma só página? Pois é, as single pages estão entre as tendências web 2015 e com razão. Além de visualmente serem mais agradáveis, são super práticas para usuários que odeiam se perder em milhares de páginas só para achar tal conteúdo que havia se interessado. Essa tecnologia fica ainda mais legal quando aplicada em mobiles! Olha um <a href="https://www.twitch.tv/year/2014" target="_blank">exemplo bem legal aqui</a>.

[<img class="aligncenter size-full wp-image-48164" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/single-page.png" alt="Single Pages" width="730" height="400" />][5]

A ideia de Single Pages Application é bem interessante e cada vez mais há ferramentas que nos ajudam nesse trabalho. Veja por exemplo [o caso do SennaJS][6], idealizado pelo nosso amigo Eduardo Lundgreen.

## VÍDEOS

Os vídeos estão tendo muita receptividade pelos usuários hoje em dia e podem facilmente conseguir mais atenção para seu site se você utilizá-lo como forma de apresentação de sua empresa ou produto, por exemplo. Além de ser rápido e prático, é um meio de comunicação muito mais esclarecedor e satisfatório para o usuário que ao assistir irá receber e entender todo o assunto tratado.

[<img class="aligncenter size-full wp-image-48165" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/videos.png" alt="Vídeos" width="730" height="400" />][7]

Há outras formas de uso de vídeos por meio dos designers. Dá uma olhada em sites como [Dadaab][8] ou [Barrel][9] que fazem uso bem criativo de vídeos como parte do design do site.

Junte todas essas armas para montar o site dos sonhos de seu cliente. 🙂

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/flat-design.png
 [2]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/motion-ui.png
 [3]: https://tableless.com.br/materialup-uma-colecao-de-conceitos-usando-material-design/
 [4]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/design-responsivo.png
 [5]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/single-page.png
 [6]: https://sennajs.com/
 [7]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/videos.png
 [8]: https://www.dadaabstories.org/
 [9]: https://www.barrelny.com/recap/2012/