---
title: Storytelling
authors: Dani Guerrato
paid: true
type: post
date: 2013-06-17
excerpt: Neste artigo descubra como técnicas de storytelling podem ser aplicadas em web design para transformar a experiência do usuário.
url: /storytelling/
dsq_thread_id: 1404579529
categories:
  - Artigos
  - Design
tags:
  - storytelling
  - ux
---
Um dos desafios de viver em um mundo onde o conhecimento está sempre facilmente disponível é lidar com a sobrecarga de informação. Na realidade existe tanto para se descobrir na internet que é difícil capturar a atenção do usuário por mais do que alguns minutos. Simplesmente mostrar uma informação não é mais relevante o suficiente. Estamos cada vez mais desconectados do significado e as vezes as palavras se tornam apenas ruídos de fundo. E isto vale na hora de apresentar uma marca, um produto, um serviço ou uma idéia. É necessário criar uma conexão emocional e contar uma história que transforme aquele objeto em algo significativo.

## A importância das histórias

Pense em colocar um pedaço de limão bem azedo na boca. Algumas pessoas conseguem praticamente sentir o gosto apenas ao imaginar. [Estudos recentes][1] de neurociência apontam que a mente humana ativa as mesmas áreas ao viver uma situação ou acessar uma memória. Ou seja, não existe uma distinção entre a maneira que processamos fatos reais e situações imaginárias. Ao visualizarmos mentalmente algo que remeta a uma informação arquivada na memória &#8211; como o limão do inicio do paragrafo &#8211; criamos uma associação sensorial e emocional maior do que com um dado científico isolado. E este é um recurso muito utilizado na aprendizagem. É muito mais fácil decorar uma fórmula de física da escola através de uma musiquinha ou situação engraçada do que tentando memorizar apenas o código numérico. Isto acontece por que narrativas ricas em linguagem figurada acessam sentidos que informações lógicas sem contexto emocional não alcançam. É por isto que histórias são poderosas. Histórias conseguem estimular áreas responsáveis pelos sentidos e criar relações &#8211; e portanto memórias &#8211; mais duradouras.

E isto ocorria muito antes da era da informação ou até mesmo do advento da escrita. Nossos ancestrais eram contadores de história e passavam assim o conhecimento de geração em geração. Os homens das cavernas faziam desenhos nas paredes e assim relatavam os acontecimentos de seu dia-a-dia. É através de histórias, arquétipos, mitos, lendas e símbolos que o ser humano atribui significado ao mundo.

## Storytelling e Design

Que &#8220;storytelling&#8221; é a expressão em inglês para &#8220;contar histórias&#8221; você provavelmente já sabe. Mas este conceito, transportado para o universo do design, não precisa ser necessariamente algo literal. Não estamos falando aqui de abrir um layout com &#8220;Era uma vez&#8221; (embora isto possa até funcionar em alguns contextos). Na realidade o storytelling acaba sendo uma camada invisível do design. Algo planejado intencionalmente para ser o tom ou a voz da sua marca, mas que não é tão óbvio para seu usuário. O storytelling pode estar na personalidade do seu discurso, no uso inteligente de imagens e ilustrações, na sequência de elementos da interface que vai guiar o visitante e convida-lo a explorar o conteúdo, etc.

Parte do trabalho de um webdesigner é pegar uma informação &#8220;crua&#8221; e transforma-la em uma mensagem interessante. Ao adicionar o elemento emoção o valor desta mensagem aumenta. As vantagens disto são inúmeras. Podemos criar um maior senso de ordenação de conteúdo, conforto cognitivo, aumento de empatia e maior absorção de informação. A web não é feita de pixels nem de fatos isolados. A web é feita de histórias.

OK. Tudo isto é muito bonito e legal, mas como utilizar estes conceitos na prática?

### A boa notícia!

Você provavelmente já utiliza alguns elementos de storytelling em seus trabalhos de design sem saber. Dicas visuais e _calls to action_ são uma maneira de conduzir o fluxo da informação e instigar a curiosidade do usuário como os _clifhangers_ de livros, filmes e seriados. Uma boa formatação de títulos, resumos e parágrafos também é uma dica visual da estrutura narrativa. Coerência entre a navegação, instruções claras em campos de formulário e links bem identificados garantem que o leitor não se perca.

## A história de um produto

Pessoas acreditam que produtos esteticamente bonitos são mais úteis e efetivos porque elas se tornam emocionalmente atraídas por eles. E tomamos decisões com base em nossos sentimentos, utilizando a razão apenas para justificar o por que estas decisões foram tomadas.

Para contar uma história que crie uma ligação emocional podemos explorar três esferas:
  
**Aspiração:** Como esperamos que aquele objeto funcione.
  
**Função:** Como aquele objeto pode ajudar a resolver um problema.
  
**Memória:** Lembranças positivas de uso.

Um exemplo disto é o design da Apple. O trecho abaixo é da página sobre o [iPhone][2].

&nbsp;

[<img class="alignnone size-full wp-image-37661" alt="iphone" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/iphone.jpg" width="660" height="240" srcset="uploads/2013/06/iphone.jpg 660w, uploads/2013/06/iphone-329x119.jpg 329w, uploads/2013/06/iphone-588x213.jpg 588w" sizes="(max-width: 660px) 100vw, 660px" />][3]

&nbsp;

**Aspiração:** Amar o produto.
  
**Função:** Tecnologia, câmera, bateria de longa duração, facilidade de uso.
  
**Memória:** As imagens grandes do produto em sequência, sempre inseridas em contextos de momentos felizes como viagens, família, amigos e momentos de lazer despertam a memória de felicidade e coisas que pessoas amam fazer, associando estas lembranças ao produto.

Outros elementos gráficos como vídeos e ícones complementam a história do produto. Em cada bloco de informação sobre o iPhone existe um link para continuar a navegação e ler os próximos capítulos da narrativa.

## Imagens Sequenciais

Este é provavelmente um dos recursos mais comuns de storytelling, presente em diversos meios como storyboards, histórias em quadrinhos e livros ilustrados. A página [Ben the Bodyguard][4] é um exemplo clássico de narrativa utilizando imagens sequenciais. O produto em questão é um aplicativo de segurança, apresentado pelo mascote da empresa &#8211; Ben, o guarda costas. A ambientação de cenários e os diálogos do personagem reforçam o clima de mistério e perigo. A navegação vertical ativada pela rolagem de mouse é o que dá movimento ao personagem e determina o ritmo e o tempo da história, transmitindo ao usuário um maior controle de interação.

[<img class="alignnone size-full wp-image-37655" alt="ben-thebodyguard" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/ben-thebodyguard.jpg" width="660" height="400" srcset="uploads/2013/06/ben-thebodyguard.jpg 660w, uploads/2013/06/ben-thebodyguard-277x168.jpg 277w, uploads/2013/06/ben-thebodyguard-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][5]

## Narrativas Lineares

Um modelo tradicional de histórias compreende a apresentação de personagens em uma aparente normalidade, o surgimento de um conflito, o clímax e uma conclusão que resolve os conflitos apresentados.

Um exemplo bacana de uso desta estrutura tradicional de narrativa é [The Story of Jess and Druss][6]. O site conta através de textos, ilustrações e uma linha de tempo a história de como o casal &#8211; Jess and Druss &#8211; se conheceu, apresentando as dificuldades de viver sozinho e como o amor aconteceu. As ilustrações, a tipografia, as cores e todos os outros elementos de design servem de suporte para contar a história do casal.

[<img class="alignnone size-full wp-image-37662" alt="Jess-and-Druss" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/Jess-and-Druss.jpg" width="660" height="400" srcset="uploads/2013/06/Jess-and-Druss.jpg 660w, uploads/2013/06/Jess-and-Druss-277x168.jpg 277w, uploads/2013/06/Jess-and-Druss-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][7]

A lineriadade da história é reforçada novamente pelo uso de uma navegação vertical e outro recurso interessante: a linha do tempo. O efeito de navegação parallax ajuda a transmitir um senso de continuidade para a história que possuí um clímax &#8211; o momento do pedido de casamento &#8211; e uma resolução em forma de um convite para os amigos do casal comparecerem ao evento. Final feliz para nossos personagens!

## Narrativas não-lineares

Se você viveu sua infância nos anos 90 provavelmente se lembra de [livros-jogo][8] do tipo &#8220;Escolha sua própria Aventura&#8221;. Para quem não conhece eram livros que ao final de cada capítulo ofereciam múltiplas escolhas de desfechos possíveis. O leitor podia então tomar suas próprias decisões e ir para a página X para continuar a história de uma maneira ou ir para a página Y para revelar outra trama. Os finais variavam de acordo com as escolhas e, se tudo desse errado, bastava começar a ler de novo e tomar decisões diferentes. A internet é como um grande livro-jogo! Todos os elementos estão aí. Múltiplos pontos de entrada para uma página (links), narrativa truncada não-linear (textos espalhados em diferentes sessões) que deve trabalhar em conjunto para transmitir uma mensagem (objetivo do site). A cada escolha de navegação de um site o leitor abre um capítulo diferente e assim vai construindo sua própria história.

Um exemplo concreto de site que faz uso deste tipo de recurso é o [Cadillac ATS vs The World][9]. Logo na página inicial é possível escolher entre os destinos possíveis (Patagonia, Marrocos, Monaco ou China) e embarcar em uma viagem virtual para cada local. Fotos panorâmicas servem como cenário, mas os depoimentos da equipe e dos moradores locais são o verdadeiro coração da história. As demais imagens, vídeos e informações em uma linguagem turística ajudam a complementar o tema viagem.

[<img class="alignnone size-full wp-image-37656" alt="cadillac" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/cadillac.jpg" width="660" height="400" srcset="uploads/2013/06/cadillac.jpg 660w, uploads/2013/06/cadillac-277x168.jpg 277w, uploads/2013/06/cadillac-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][10]

## 

## Seja o herói!

Toda história tem um protagonista. E protagonistas precisam de antagonistas, conflitos, dificuldades, problemas&#8230; Exponha claramente quem é do time do bem (você) e como solucionar um problema do usuário. Faça o público torcer para o sucesso da sua empresa, produto, serviço. Crie ações, metas e objetivos claros para ter um final feliz. Você não precisa ter um mascote para fazer isso. O seu serviço pode ser o herói.

Um case bacana de storytelling é o site da Dropbox. A metáfora de história permeia todo o design da página [Tour][11].

[<img class="alignnone size-full wp-image-37657" alt="dropbox-1" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/dropbox-1.jpg" width="660" height="400" srcset="uploads/2013/06/dropbox-1.jpg 660w, uploads/2013/06/dropbox-1-277x168.jpg 277w, uploads/2013/06/dropbox-1-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][12]

Eles exploram claramente o que é o serviço (&#8220;Um lugar para todos os seus arquivos, onde quer que você esteja&#8221;), quem são os possíveis personagens (&#8220;não importa se você é estudante ou profissional, um pai ou um avô.&#8221;), existe um vilão concreto (o medo de &#8220;derramar café sem querer no laptop&#8221;), um herói (a própria Dropbox) e um final feliz (&#8220;Relaxe com a certeza de que todos os seus arquivos estão seguros no Dropbox e nunca se perderão&#8221;). Para reforçar o conceito de história temos elementos esqueumórficos como metáforas (o livro, navegação por páginas, o próprio ícone da dropbox como uma caixa de arquivos) e ilustrações lúdicas para reforçar o ideal de segurança do final feliz.

[<img class="alignnone size-full wp-image-37658" alt="dropbox-2" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/dropbox-2.jpg" width="660" height="400" srcset="uploads/2013/06/dropbox-2.jpg 660w, uploads/2013/06/dropbox-2-277x168.jpg 277w, uploads/2013/06/dropbox-2-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][12]

Cada página do livro é em si uma história completa. Seguindo as páginas temos mais alguns elementos interessantes de storytelling como recursos de balõezinhos que remetem diretamente a história em quadrinho, elementos de humor, atribuição de super poder ao herói (máquina do tempo) e novamente vilões concretos (computador pegando fogo).

## O usuário também é um personagem

Se você for contar uma mesma história para seus pais em uma reunião de família, para um possível empregador em uma entrevista de emprego ou para um grupo de amigos em um bar provavelmente vai escolher diferentes abordagens. Em essência a história permanece igual mas decisões como o uso de palavrões, gírias, jargões técnicos, humor, etc vão determinar o tom da linguagem de acordo com a situação social. O truque para saber qual variação linguística utilizar é conhecer o seu público-alvo.

Você que está lendo este texto tem 80% de chance de ser homem e 77% de chance de ter entre 16 e 34 anos. Não, não tenho uma bola de cristal. Eu li o Media Kit do Tableless antes de começar a escrever estes artigos. Mas muitas vezes, ao lançar um serviço novo, estas informações não estão disponíveis. E para estas horas o que ajuda é imaginar o seu usuário também como um personagem. Dar uma cara para a figura misteriosa por trás do monitor vai te ajudar a escolher o tom da sua história.

Um recurso muito utilizado é a criação de personas. Essencialmente você deve pensar em quem, quando, onde e por que alguém vai querer utilizar o seu serviço. Mas o grau de complexidade das suas respostas pode variar muito. Você pode simplesmente elencar alguns dados demográficos ou ir mais longe e criar um nome, imagem e biografia para este usuário hipotético. Conhecendo quem é o seu público alvo fica muito mais fácil descobrir o que ele busca e desta forma entregar um conteúdo mais relevante. Não esqueça de elencar também os possíveis cenários e situações que este personagem irá interagir com a interface.

Quer saber como construir suas próprias personas? Aqui no Tableless temos um artigo muito interessante justamente sobre [Personalidade no Design][13].

Saber disto pode te ajudar a projetar a navegação de maneira mais inteligente. Você não pode controlar as escolhas do usuário, mas pode fornecer uma estrutura lógica coesa para que ele construa seu próprio caminho. Uma história nunca é percebida exatamente como foi imaginada. Cada pessoa entende histórias de maneiras diferentes, adicionando seus próprios pensamentos, sentimentos, percepções e experiências. Interfaces como a do Windows 8 e do [Google Now][14] estão em alta hoje não apenas por que o design minimalista é uma tendência visual da moda, mas por abrirem espaço para que narrativas pessoais possam existir. Ações como criar, escolher, modificar e ordenar blocos de conteúdo permitem um nível de personalização muito maior e assim criam o cenário perfeito para estas narrativas.

[<img class="alignnone size-full wp-image-37660" alt="google-now" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/google-now.jpg" width="660" height="240" srcset="uploads/2013/06/google-now.jpg 660w, uploads/2013/06/google-now-329x119.jpg 329w, uploads/2013/06/google-now-588x213.jpg 588w" sizes="(max-width: 660px) 100vw, 660px" />][15]

O Google Now oferece uma variedade de informações em cartões de conteúdo que variam de acordo com a localização geográfica da pessoa e seu histórico de pesquisas no Google. Assim é possível exibir informações sobre o clima, trânsito, mapas, fotos, etc de acordo com o uso. Este é um exemplo de estudo de persona levado a sério! O sistema a partir de inputs automáticos traça um perfil de maneira inteligente e como consequência fornece um conteúdo mais relevante.

## Mostre o que é único sobre você

Uma imagem vale mais do que mil palavras. Mas uma imagem genérica e sem personalidade equivale a um discurso sobre o nada. Bancos de imagens são um recurso valido, mas muito cuidado ao utilizar indiscriminadamente este tipo de imagens (principalmente os gratuitos). Isto pode passar ao seu usuário a impressão de frieza e falta de personalidade. Todo mundo sabe que aquela moça de headphones gigantesco não trabalha de verdade no callcenter da sua empresa&#8230; a não ser que ela trabalhe em todos os callcenters do mundo ao mesmo tempo. Pense em qual é o seu público e tente se relacionar com ele. Por que não mostrar a cara da sua equipe de verdade? E do seu escritório? Desta maneira o público consegue conhecer (e sentir empatia) por você de verdade.

Se não possuir recursos para ter imagens próprias tente procurar por registros marcados como Creative Commons (com licença de uso comercial) em sites como o [Flickr][16]. Este tipo de imagem transmite mais autenticidade do que aquela tipica família americana em um estúdio branco (que não lembra em nada as famílias brasileiras).

Você pode ainda utilizar outros recursos visuais como ilustrações ou até mesmo uma tipografia diferente. Além das imagens, elementos do layout como formas, linhas, cores, texturas, padrões, peso, movimento, espaço e proporção são as principais ferramentas para compor o tom. Dependendo do seu contexto letterings expressivos e caligrafia são boas opções e transmitem o sentimento de algo feito a mão com carinho e cuidado. O site [Forefathers Group][17] é um exemplo disto. O uso de lettering, o ar de mistério dos textos, a paleta de cores e ilustrações remete ao tema principal de grupos itinerantes e companhia de circo.

[<img class="alignnone size-full wp-image-37659" alt="Forefathers-Group" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/Forefathers-Group.jpg" width="660" height="400" srcset="uploads/2013/06/Forefathers-Group.jpg 660w, uploads/2013/06/Forefathers-Group-277x168.jpg 277w, uploads/2013/06/Forefathers-Group-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][18]

## Storytelling transmídia

É importante lembrar que a história de uma marca transcende os limites de uma página na internet. Toda a identidade visual e linguagem verbal empregada deve ser consistente e partir de um mesmo contexto lógico. De nada adianta uma empresa se esforçar para parecer simpática e amigável em seu site e depois tratar mal os clientes nas redes sociais, por exemplo. Se você é um freelancer a responsabilidade é ainda maior já que a sua marca é você mesmo! Muito cuidado com a imagem que você está transmitindo. Parece senso comum, mas muita gente acaba perdendo ótimas oportunidades profissionais ao reclamar do trabalho no Facebook ou Twitter.

Um exemplo de storytelling transmídia é a campanha de e-mails marketing da empresa Meu Móvel de Madeira. Cada e-mail foca em uma persona de usuário em uma situação específica. No [exemplo a seguir][19] o personagem hipotético acabou de comprar uma casa e deseja mobiliar a sala:

[<img class="alignnone size-full wp-image-37663" alt="mmm" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/mmm.jpg" width="660" height="400" srcset="uploads/2013/06/mmm.jpg 660w, uploads/2013/06/mmm-277x168.jpg 277w, uploads/2013/06/mmm-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][20]

&nbsp;

Além de um website, redes sociais e e-mails existem muitos outros recursos de mídia para continuar sua história dentro e fora da internet. Aplicativos, blogs,livros, cartões de visita, posters, adesivos, videos&#8230; Todos estes recursos são formas validas de comunicar sua mensagem e dar ao seu interlocutor a chance de participar de uma experiência completa. Cabe a você torna-la incrível! Boa sorte na sua jornada.

### Saiba mais:

[The Missing Element of Redesign: Story &#8211; Smashing Book #3⅓ — The Extension][21]
  
[Um dos desafios de viver em um mundo onde o conhecimento está sempre facilmente disponível é lidar com a sobrecarga de informação. Na realidade existe tanto para se descobrir na internet que é difícil capturar a atenção do usuário por mais do que alguns minutos. Simplesmente mostrar uma informação não é mais relevante o suficiente. Estamos cada vez mais desconectados do significado e as vezes as palavras se tornam apenas ruídos de fundo. E isto vale na hora de apresentar uma marca, um produto, um serviço ou uma idéia. É necessário criar uma conexão emocional e contar uma história que transforme aquele objeto em algo significativo.

## A importância das histórias

Pense em colocar um pedaço de limão bem azedo na boca. Algumas pessoas conseguem praticamente sentir o gosto apenas ao imaginar. [Estudos recentes][1] de neurociência apontam que a mente humana ativa as mesmas áreas ao viver uma situação ou acessar uma memória. Ou seja, não existe uma distinção entre a maneira que processamos fatos reais e situações imaginárias. Ao visualizarmos mentalmente algo que remeta a uma informação arquivada na memória &#8211; como o limão do inicio do paragrafo &#8211; criamos uma associação sensorial e emocional maior do que com um dado científico isolado. E este é um recurso muito utilizado na aprendizagem. É muito mais fácil decorar uma fórmula de física da escola através de uma musiquinha ou situação engraçada do que tentando memorizar apenas o código numérico. Isto acontece por que narrativas ricas em linguagem figurada acessam sentidos que informações lógicas sem contexto emocional não alcançam. É por isto que histórias são poderosas. Histórias conseguem estimular áreas responsáveis pelos sentidos e criar relações &#8211; e portanto memórias &#8211; mais duradouras.

E isto ocorria muito antes da era da informação ou até mesmo do advento da escrita. Nossos ancestrais eram contadores de história e passavam assim o conhecimento de geração em geração. Os homens das cavernas faziam desenhos nas paredes e assim relatavam os acontecimentos de seu dia-a-dia. É através de histórias, arquétipos, mitos, lendas e símbolos que o ser humano atribui significado ao mundo.

## Storytelling e Design

Que &#8220;storytelling&#8221; é a expressão em inglês para &#8220;contar histórias&#8221; você provavelmente já sabe. Mas este conceito, transportado para o universo do design, não precisa ser necessariamente algo literal. Não estamos falando aqui de abrir um layout com &#8220;Era uma vez&#8221; (embora isto possa até funcionar em alguns contextos). Na realidade o storytelling acaba sendo uma camada invisível do design. Algo planejado intencionalmente para ser o tom ou a voz da sua marca, mas que não é tão óbvio para seu usuário. O storytelling pode estar na personalidade do seu discurso, no uso inteligente de imagens e ilustrações, na sequência de elementos da interface que vai guiar o visitante e convida-lo a explorar o conteúdo, etc.

Parte do trabalho de um webdesigner é pegar uma informação &#8220;crua&#8221; e transforma-la em uma mensagem interessante. Ao adicionar o elemento emoção o valor desta mensagem aumenta. As vantagens disto são inúmeras. Podemos criar um maior senso de ordenação de conteúdo, conforto cognitivo, aumento de empatia e maior absorção de informação. A web não é feita de pixels nem de fatos isolados. A web é feita de histórias.

OK. Tudo isto é muito bonito e legal, mas como utilizar estes conceitos na prática?

### A boa notícia!

Você provavelmente já utiliza alguns elementos de storytelling em seus trabalhos de design sem saber. Dicas visuais e _calls to action_ são uma maneira de conduzir o fluxo da informação e instigar a curiosidade do usuário como os _clifhangers_ de livros, filmes e seriados. Uma boa formatação de títulos, resumos e parágrafos também é uma dica visual da estrutura narrativa. Coerência entre a navegação, instruções claras em campos de formulário e links bem identificados garantem que o leitor não se perca.

## A história de um produto

Pessoas acreditam que produtos esteticamente bonitos são mais úteis e efetivos porque elas se tornam emocionalmente atraídas por eles. E tomamos decisões com base em nossos sentimentos, utilizando a razão apenas para justificar o por que estas decisões foram tomadas.

Para contar uma história que crie uma ligação emocional podemos explorar três esferas:
  
**Aspiração:** Como esperamos que aquele objeto funcione.
  
**Função:** Como aquele objeto pode ajudar a resolver um problema.
  
**Memória:** Lembranças positivas de uso.

Um exemplo disto é o design da Apple. O trecho abaixo é da página sobre o [iPhone][2].

&nbsp;

[<img class="alignnone size-full wp-image-37661" alt="iphone" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/iphone.jpg" width="660" height="240" srcset="uploads/2013/06/iphone.jpg 660w, uploads/2013/06/iphone-329x119.jpg 329w, uploads/2013/06/iphone-588x213.jpg 588w" sizes="(max-width: 660px) 100vw, 660px" />][3]

&nbsp;

**Aspiração:** Amar o produto.
  
**Função:** Tecnologia, câmera, bateria de longa duração, facilidade de uso.
  
**Memória:** As imagens grandes do produto em sequência, sempre inseridas em contextos de momentos felizes como viagens, família, amigos e momentos de lazer despertam a memória de felicidade e coisas que pessoas amam fazer, associando estas lembranças ao produto.

Outros elementos gráficos como vídeos e ícones complementam a história do produto. Em cada bloco de informação sobre o iPhone existe um link para continuar a navegação e ler os próximos capítulos da narrativa.

## Imagens Sequenciais

Este é provavelmente um dos recursos mais comuns de storytelling, presente em diversos meios como storyboards, histórias em quadrinhos e livros ilustrados. A página [Ben the Bodyguard][4] é um exemplo clássico de narrativa utilizando imagens sequenciais. O produto em questão é um aplicativo de segurança, apresentado pelo mascote da empresa &#8211; Ben, o guarda costas. A ambientação de cenários e os diálogos do personagem reforçam o clima de mistério e perigo. A navegação vertical ativada pela rolagem de mouse é o que dá movimento ao personagem e determina o ritmo e o tempo da história, transmitindo ao usuário um maior controle de interação.

[<img class="alignnone size-full wp-image-37655" alt="ben-thebodyguard" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/ben-thebodyguard.jpg" width="660" height="400" srcset="uploads/2013/06/ben-thebodyguard.jpg 660w, uploads/2013/06/ben-thebodyguard-277x168.jpg 277w, uploads/2013/06/ben-thebodyguard-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][5]

## Narrativas Lineares

Um modelo tradicional de histórias compreende a apresentação de personagens em uma aparente normalidade, o surgimento de um conflito, o clímax e uma conclusão que resolve os conflitos apresentados.

Um exemplo bacana de uso desta estrutura tradicional de narrativa é [The Story of Jess and Druss][6]. O site conta através de textos, ilustrações e uma linha de tempo a história de como o casal &#8211; Jess and Druss &#8211; se conheceu, apresentando as dificuldades de viver sozinho e como o amor aconteceu. As ilustrações, a tipografia, as cores e todos os outros elementos de design servem de suporte para contar a história do casal.

[<img class="alignnone size-full wp-image-37662" alt="Jess-and-Druss" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/Jess-and-Druss.jpg" width="660" height="400" srcset="uploads/2013/06/Jess-and-Druss.jpg 660w, uploads/2013/06/Jess-and-Druss-277x168.jpg 277w, uploads/2013/06/Jess-and-Druss-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][7]

A lineriadade da história é reforçada novamente pelo uso de uma navegação vertical e outro recurso interessante: a linha do tempo. O efeito de navegação parallax ajuda a transmitir um senso de continuidade para a história que possuí um clímax &#8211; o momento do pedido de casamento &#8211; e uma resolução em forma de um convite para os amigos do casal comparecerem ao evento. Final feliz para nossos personagens!

## Narrativas não-lineares

Se você viveu sua infância nos anos 90 provavelmente se lembra de [livros-jogo][8] do tipo &#8220;Escolha sua própria Aventura&#8221;. Para quem não conhece eram livros que ao final de cada capítulo ofereciam múltiplas escolhas de desfechos possíveis. O leitor podia então tomar suas próprias decisões e ir para a página X para continuar a história de uma maneira ou ir para a página Y para revelar outra trama. Os finais variavam de acordo com as escolhas e, se tudo desse errado, bastava começar a ler de novo e tomar decisões diferentes. A internet é como um grande livro-jogo! Todos os elementos estão aí. Múltiplos pontos de entrada para uma página (links), narrativa truncada não-linear (textos espalhados em diferentes sessões) que deve trabalhar em conjunto para transmitir uma mensagem (objetivo do site). A cada escolha de navegação de um site o leitor abre um capítulo diferente e assim vai construindo sua própria história.

Um exemplo concreto de site que faz uso deste tipo de recurso é o [Cadillac ATS vs The World][9]. Logo na página inicial é possível escolher entre os destinos possíveis (Patagonia, Marrocos, Monaco ou China) e embarcar em uma viagem virtual para cada local. Fotos panorâmicas servem como cenário, mas os depoimentos da equipe e dos moradores locais são o verdadeiro coração da história. As demais imagens, vídeos e informações em uma linguagem turística ajudam a complementar o tema viagem.

[<img class="alignnone size-full wp-image-37656" alt="cadillac" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/cadillac.jpg" width="660" height="400" srcset="uploads/2013/06/cadillac.jpg 660w, uploads/2013/06/cadillac-277x168.jpg 277w, uploads/2013/06/cadillac-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][10]

## 

## Seja o herói!

Toda história tem um protagonista. E protagonistas precisam de antagonistas, conflitos, dificuldades, problemas&#8230; Exponha claramente quem é do time do bem (você) e como solucionar um problema do usuário. Faça o público torcer para o sucesso da sua empresa, produto, serviço. Crie ações, metas e objetivos claros para ter um final feliz. Você não precisa ter um mascote para fazer isso. O seu serviço pode ser o herói.

Um case bacana de storytelling é o site da Dropbox. A metáfora de história permeia todo o design da página [Tour][11].

[<img class="alignnone size-full wp-image-37657" alt="dropbox-1" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/dropbox-1.jpg" width="660" height="400" srcset="uploads/2013/06/dropbox-1.jpg 660w, uploads/2013/06/dropbox-1-277x168.jpg 277w, uploads/2013/06/dropbox-1-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][12]

Eles exploram claramente o que é o serviço (&#8220;Um lugar para todos os seus arquivos, onde quer que você esteja&#8221;), quem são os possíveis personagens (&#8220;não importa se você é estudante ou profissional, um pai ou um avô.&#8221;), existe um vilão concreto (o medo de &#8220;derramar café sem querer no laptop&#8221;), um herói (a própria Dropbox) e um final feliz (&#8220;Relaxe com a certeza de que todos os seus arquivos estão seguros no Dropbox e nunca se perderão&#8221;). Para reforçar o conceito de história temos elementos esqueumórficos como metáforas (o livro, navegação por páginas, o próprio ícone da dropbox como uma caixa de arquivos) e ilustrações lúdicas para reforçar o ideal de segurança do final feliz.

[<img class="alignnone size-full wp-image-37658" alt="dropbox-2" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/dropbox-2.jpg" width="660" height="400" srcset="uploads/2013/06/dropbox-2.jpg 660w, uploads/2013/06/dropbox-2-277x168.jpg 277w, uploads/2013/06/dropbox-2-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][12]

Cada página do livro é em si uma história completa. Seguindo as páginas temos mais alguns elementos interessantes de storytelling como recursos de balõezinhos que remetem diretamente a história em quadrinho, elementos de humor, atribuição de super poder ao herói (máquina do tempo) e novamente vilões concretos (computador pegando fogo).

## O usuário também é um personagem

Se você for contar uma mesma história para seus pais em uma reunião de família, para um possível empregador em uma entrevista de emprego ou para um grupo de amigos em um bar provavelmente vai escolher diferentes abordagens. Em essência a história permanece igual mas decisões como o uso de palavrões, gírias, jargões técnicos, humor, etc vão determinar o tom da linguagem de acordo com a situação social. O truque para saber qual variação linguística utilizar é conhecer o seu público-alvo.

Você que está lendo este texto tem 80% de chance de ser homem e 77% de chance de ter entre 16 e 34 anos. Não, não tenho uma bola de cristal. Eu li o Media Kit do Tableless antes de começar a escrever estes artigos. Mas muitas vezes, ao lançar um serviço novo, estas informações não estão disponíveis. E para estas horas o que ajuda é imaginar o seu usuário também como um personagem. Dar uma cara para a figura misteriosa por trás do monitor vai te ajudar a escolher o tom da sua história.

Um recurso muito utilizado é a criação de personas. Essencialmente você deve pensar em quem, quando, onde e por que alguém vai querer utilizar o seu serviço. Mas o grau de complexidade das suas respostas pode variar muito. Você pode simplesmente elencar alguns dados demográficos ou ir mais longe e criar um nome, imagem e biografia para este usuário hipotético. Conhecendo quem é o seu público alvo fica muito mais fácil descobrir o que ele busca e desta forma entregar um conteúdo mais relevante. Não esqueça de elencar também os possíveis cenários e situações que este personagem irá interagir com a interface.

Quer saber como construir suas próprias personas? Aqui no Tableless temos um artigo muito interessante justamente sobre [Personalidade no Design][13].

Saber disto pode te ajudar a projetar a navegação de maneira mais inteligente. Você não pode controlar as escolhas do usuário, mas pode fornecer uma estrutura lógica coesa para que ele construa seu próprio caminho. Uma história nunca é percebida exatamente como foi imaginada. Cada pessoa entende histórias de maneiras diferentes, adicionando seus próprios pensamentos, sentimentos, percepções e experiências. Interfaces como a do Windows 8 e do [Google Now][14] estão em alta hoje não apenas por que o design minimalista é uma tendência visual da moda, mas por abrirem espaço para que narrativas pessoais possam existir. Ações como criar, escolher, modificar e ordenar blocos de conteúdo permitem um nível de personalização muito maior e assim criam o cenário perfeito para estas narrativas.

[<img class="alignnone size-full wp-image-37660" alt="google-now" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/google-now.jpg" width="660" height="240" srcset="uploads/2013/06/google-now.jpg 660w, uploads/2013/06/google-now-329x119.jpg 329w, uploads/2013/06/google-now-588x213.jpg 588w" sizes="(max-width: 660px) 100vw, 660px" />][15]

O Google Now oferece uma variedade de informações em cartões de conteúdo que variam de acordo com a localização geográfica da pessoa e seu histórico de pesquisas no Google. Assim é possível exibir informações sobre o clima, trânsito, mapas, fotos, etc de acordo com o uso. Este é um exemplo de estudo de persona levado a sério! O sistema a partir de inputs automáticos traça um perfil de maneira inteligente e como consequência fornece um conteúdo mais relevante.

## Mostre o que é único sobre você

Uma imagem vale mais do que mil palavras. Mas uma imagem genérica e sem personalidade equivale a um discurso sobre o nada. Bancos de imagens são um recurso valido, mas muito cuidado ao utilizar indiscriminadamente este tipo de imagens (principalmente os gratuitos). Isto pode passar ao seu usuário a impressão de frieza e falta de personalidade. Todo mundo sabe que aquela moça de headphones gigantesco não trabalha de verdade no callcenter da sua empresa&#8230; a não ser que ela trabalhe em todos os callcenters do mundo ao mesmo tempo. Pense em qual é o seu público e tente se relacionar com ele. Por que não mostrar a cara da sua equipe de verdade? E do seu escritório? Desta maneira o público consegue conhecer (e sentir empatia) por você de verdade.

Se não possuir recursos para ter imagens próprias tente procurar por registros marcados como Creative Commons (com licença de uso comercial) em sites como o [Flickr][16]. Este tipo de imagem transmite mais autenticidade do que aquela tipica família americana em um estúdio branco (que não lembra em nada as famílias brasileiras).

Você pode ainda utilizar outros recursos visuais como ilustrações ou até mesmo uma tipografia diferente. Além das imagens, elementos do layout como formas, linhas, cores, texturas, padrões, peso, movimento, espaço e proporção são as principais ferramentas para compor o tom. Dependendo do seu contexto letterings expressivos e caligrafia são boas opções e transmitem o sentimento de algo feito a mão com carinho e cuidado. O site [Forefathers Group][17] é um exemplo disto. O uso de lettering, o ar de mistério dos textos, a paleta de cores e ilustrações remete ao tema principal de grupos itinerantes e companhia de circo.

[<img class="alignnone size-full wp-image-37659" alt="Forefathers-Group" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/Forefathers-Group.jpg" width="660" height="400" srcset="uploads/2013/06/Forefathers-Group.jpg 660w, uploads/2013/06/Forefathers-Group-277x168.jpg 277w, uploads/2013/06/Forefathers-Group-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][18]

## Storytelling transmídia

É importante lembrar que a história de uma marca transcende os limites de uma página na internet. Toda a identidade visual e linguagem verbal empregada deve ser consistente e partir de um mesmo contexto lógico. De nada adianta uma empresa se esforçar para parecer simpática e amigável em seu site e depois tratar mal os clientes nas redes sociais, por exemplo. Se você é um freelancer a responsabilidade é ainda maior já que a sua marca é você mesmo! Muito cuidado com a imagem que você está transmitindo. Parece senso comum, mas muita gente acaba perdendo ótimas oportunidades profissionais ao reclamar do trabalho no Facebook ou Twitter.

Um exemplo de storytelling transmídia é a campanha de e-mails marketing da empresa Meu Móvel de Madeira. Cada e-mail foca em uma persona de usuário em uma situação específica. No [exemplo a seguir][19] o personagem hipotético acabou de comprar uma casa e deseja mobiliar a sala:

[<img class="alignnone size-full wp-image-37663" alt="mmm" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/mmm.jpg" width="660" height="400" srcset="uploads/2013/06/mmm.jpg 660w, uploads/2013/06/mmm-277x168.jpg 277w, uploads/2013/06/mmm-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][20]

&nbsp;

Além de um website, redes sociais e e-mails existem muitos outros recursos de mídia para continuar sua história dentro e fora da internet. Aplicativos, blogs,livros, cartões de visita, posters, adesivos, videos&#8230; Todos estes recursos são formas validas de comunicar sua mensagem e dar ao seu interlocutor a chance de participar de uma experiência completa. Cabe a você torna-la incrível! Boa sorte na sua jornada.

### Saiba mais:

[The Missing Element of Redesign: Story &#8211; Smashing Book #3⅓ — The Extension][21]
  
][22] 
  
[10 Ways To Incorporate Storytelling In Web Design][23]

 [1]: https://www.nytimes.com/2012/03/18/opinion/sunday/the-neuroscience-of-your-brain-on-fiction.html "Your Brain on Fiction"
 [2]: https://www.apple.com/br/iphone/ "Apple iPhone"
 [3]: https://www.apple.com/br/iphone/
 [4]: https://benthebodyguard.com "Ben - The Bodyguard"
 [5]: https://benthebodyguard.com
 [6]: https://jessandruss.us/ "The Story of Jess and Druss"
 [7]: https://jessandruss.us/
 [8]: https://pt.wikipedia.org/wiki/Gamebook "Gamebook"
 [9]: https://ats-vs-world.cadillac.com/ "Cadillac ATS vs The World"
 [10]: https://ats-vs-world.cadillac.com/
 [11]: https://www.dropbox.com/tour "Dropbox Tour"
 [12]: https://www.dropbox.com/tour
 [13]: https://tableless.com.br/personalidade-no-design/ "Personalidade no Design"
 [14]: https://www.google.com/landing/now/ "Google Now"
 [15]: https://www.google.com/landing/now/
 [16]: https://www.flickr.com/ "Flickr"
 [17]: https://forefathersgroup.com/ "Forefathers Group"
 [18]: https://forefathersgroup.com/
 [19]: https://www.meumovel.com.br/mkt-mmm/email-mkt/2013/mar/minha-casa-nova-estar/minha-casa-nova-estar.html "E-mail marketing - Minha casa nova"
 [20]: https://www.meumovel.com.br/mkt-mmm/email-mkt/2013/mar/minha-casa-nova-estar/minha-casa-nova-estar.html
 [21]: https://shop.smashingmagazine.com/smashing-book-one-third-digital.html?pk_campaign=smashing-magazine-ebooks-tab# "Smashing Book #3 1/3"
 [22]: https://uxdesign.smashingmagazine.com/2010/02/11/better-user-experience-through-storytelling-part-2/ "Better User Experience with Storytelling"
 [23]: https://blog.usabilla.com/10-ways-to-incorporate-storytelling-in-web-design/ "10 ways to incorporate storytelling in web-design"