---
title: Sobre prazos e produtividade
authors: Diego Eis
type: post
date: 2013-04-08
excerpt: Um pensamento sobre prazos e produtividade.
url: /sobre-prazos-e-produtividade/
dsq_thread_id: 1195701445
categories:
  - Artigos
  - Técnicas e Práticas
tags:
  - 2013
  - editores
---
Você já percebeu que cumprir prazos em projetos de web é praticamente impossível? Nunca vi ninguém entregando tudo o que combinou no prazo final. Sempre falta alguma coisa, um teste, uma feature, algo que ninguém conseguiu prever. O problema é que isso pode estar se tornando um problema crônico dentro das empresas, principalmente em empresas onde as equipes não tem um processo bem formado, onde a comunicação é difícil.

Talvez a solução e o início do problema esteja nas trincheiras. Seja designer, front-end ou back-end, a maioria deles não sabe estimar. Todos eles acham que estimar é **acertar** a data exata de quando eles entregarão as tarefas e fecharão o ciclo principal de desenvolvimento. Estimar não significa isso, pelo contrário. E a solução pode estar aqui também por que os integrantes das equipes que devem definir as datas. Claro, essa data pode ser revista e afinada com os gestores, isso deve acontecer, é necessário. Mas quem deve dizer se uma data é impossível ou não são os desenvolvedores.

> Estimar é opinar a respeito de algo de que não se tem certeza.

Você não precisa saber exatamente o dia, mas algo aproximado. Quando alguém pergunta o prazo, não é a hora de agradar ninguém, é hora de você dar uma data confortável para o projeto que talvez seja suficiente para execução da tarefa. É opinar sobre os problemas e tentar identificar as armadilhas daquela tarefa e também do projeto. Fique tranquilo, você não precisa ter certeza de quanto tempo uma tarefa custará se você nunca a executou. A ideia de estimar é realmente esta: opinar uma data mais próxima possível da realidade. Você vai errar a maioria das vezes, afinal de contas, você não tem bola de cristal.

Eu sei que fazer isso e convencer os outros de que a sua data não é a real é um desafio quase que impossível. Mas tenha em mente que é muito melhor você deixar claro e mostrar os motivos do por que determinada data não factivel, do que tentar agradar a todos e ganhar a fama de atrasado e ainda assim prejudicar outras pontas do projeto, como campanhas de marketing, lançamento, budgets, etc etc etc&#8230; Eu sei também que tem desenvolvedores que se aproveitam disso para enrolar demais. Nestes casos o sistema trata de excluí-los automaticamente.

Ninguém sabe estimar. E isso é bom por que é um campo a ser trabalhado nas equipes. É possível convencê-los de que chupar o dedo e colocá-lo para cima para sentir para brisa não é a melhor forma de conseguir datas. Existem maneiras melhores para saber com mais precisão uma data de entrega. Inclusive melhorando a sua produtividade.

## Outros atrasam também

Claro que atrasam. O comercial, por exemplo. Quem não nunca trabalhou com um comercial que fecha orçamentos prometendo milagres em curto prazo? Geralmente isso acontece por que o comercial nunca trabalhou ou trabalha a pouco tempo com web. Eles nunca conversaram com os membros da equipe de produção. Nunca viram um processo do começo ao fim. E geralmente não entendem que tem uma fila de projetos a serem entregues.

Esse problema pode ser facilmente resolvido se: **1.** O comercial tem uma raíz técnica. Nesse caso ele sabe que dar uma data muito próxima, é irreal e tem mais chances de acordar uma data plausível. **2.** O comercial traz o briefing para a equipe e pede sua opinião. A equipe **estima** e devolve uma data mais próxima da realidade, levando em conta a fila de projetos, complexidade das tarefas e etc. **3.** O comercial leva o líder técnico ou o gerente da equipe para as reuniões &#8211; pelo menos as mais importantes. Dessa forma o comercial tem uma visão mais pé no chão de todas as necessidades do projeto e também o cliente ganha confiança, já que ele pode conversar direto com um integrante da equipe e executará o projeto.

Claro que o comercial precisa ser competitivo. Ninguém consegue vender se jogar o prazo lá para frente. O projeto fica mais caro, o cliente perde tempo e você deixa seus funcionários muito tempo alocado em apenas um projeto. Mas outra pergunta que se deve fazer é: quanto tempo você consegue manter o cliente atrasando seu projeto vezes seguidas? E os outros clientes que podem conhecer essa fama ruim de entregar projetos atrasados? Na minha opinião é melhor brigar por um prazo longo, mas que não prejudique a qualidade nem paciência dos envolvidos, do que atrasar o tempo todo e criar um clima ruim entre empresa e cliente.

## Produtividade

Entregar na data tem muito a ver com produtividade. E produtividade tem muito a ver em conhecer problemas e suas soluções de tarefas comuns que são frequentemente executadas. Entender quantas tarefas comuns existem em uma fatia do projeto ajuda a mensurar uma estimativa mais acertada, não a correta, mas com uma margem de erro muito pequena. Tente estudar, por exemplo, quanto tempo se leva para fazer uma tela de cadastro/login. Se você é designer, quanto tempo leva para desenhar uma tela de cadastro e uma de login? Se você é front-end, quanto tempo leva para implementar um cenário deste? E se você é programador, quanto tempo leva para preparar o banco e pra programar essas telas?

> Quando alguém pergunta o prazo, não é a hora de agradar ninguém

Depois que você passa a entender e a conhecer bem os cenários comuns, sabendo quais são seus problemas e suas soluções, você ganha a percepção de detectar problemas durante o processo. Em vez de avisar sobre um possível atraso no último dia do desenvolvimento, você vai detectar o problema semanas antes. Isso dá tempo para que a equipe se reprograme, para que a equipe de marketing remarque as campanhas, para que a diretoria replaneje a parte financeira.

A verdade é que você não pode esperar que um dia você acordará dando datas corretas e sendo um desenvolvedor perspicaz. Você tem que fazer por onde. Tem que descobrir respostas antecipadamente e tem que aprender com os problemas de projetos passados. Anote tudo o que puder durante o processo de produção. Isso vai te ajudar a manter um histórico de problemas e de soluções que geraram bons resultados e que podem ser usadas em outros projetos.

### Editores, programas e truques

Saber usar de verdade os programas e editores que você trabalha diariamente também ajuda muito.

Eu gosto dos desenvolvedores que utilizam VIM por um simples motivos: eles pararam um tempo para aprender todos os comandos do VI ou pelo menos os mais importantes. Eu particularmente não gosto de VI exatamente por que a curva de aprendizado é muito grande. Mas quando o desenvolvedor sabe utilizar tudo o que o VI oferece, a produtividade dele é muito alta.

> Chupar o dedo e colocá-lo para cima para sentir a brisa não é a melhor forma de conseguir datas.

Você pode alcançar uma produtividade monstruosa com qualquer editor. Basta estudar e aprender seus truques. O [Sublime Text][1] ganhou notoriedade entre os desenvolvedores exatamente por que ele é recheado de truques. Eu paro frequentemente para estudar novos atalhos ou para procurar novos plugins e sempre acabo esquecendo vários outros atalhos.

Muitos devs acham que perder tanto tempo em um editor é ruim. Eu acho que é totalmente o contrário. Você ganha efetividade nas tarefas futuras e esse tempo &#8220;perdido&#8221; se paga com muita facilidade. Obviamente, trocar de editor toda semana é muito contraproducente.

A mesma coisa quando o desenvolvedor aprende Expressões Regulares. Nada paga aquele Find & Replace complexo que consumiria meia hora do seu, mas que sendo feito com ER levou apenas poucos segundos/minutos. Não só ER, mas entender de verdade os atalhos da sua linguagem predileta vai te economizar muitos minutos durante tarefas triviais.

##### Coisas simples

Sabe como muitos desenvolvedores por aí perdem tempo? Segurando o mouse. Isso é uma coisa simples, mas eu já vi tanto desenvolvedor que nem usa o básico CMD/ALT+TAB para alternar janelas. Para tentar chegar numa determinada linha do editor, usa a barra de rolagem&#8230; Para escrever CSS, copia o bloco anterior, cola e modifica as propriedades&#8230; Entende o que estou tentando dizer? Em atos simples, você acaba perdendo produtividade e consequentemente, tempo.

## Concluindo

Ninguém nasceu sabendo estimar. Isso se aprende durante sua carreira, errando muito. É algo que você aprende rápido e leva uma vida inteira para aperfeiçoar. É um assunto interessante e com certeza, com este artigo, abordamos muito superficialmente o que podemos melhorar para que entreguemos mais em menos tempo. Em artigos posteriores podemos abordar métodos ágeis, flexibilização de processos entre as equipes e outos assuntos importantes. Aguarde.

 [1]: https://tableless.com.br/dicas-truques-sublime-text/ "Dicas e truques de Sublime Text"