---
title: Sobre organizar informação
authors: Diego Eis
type: post
date: 2013-09-10
excerpt: Um pensamento sobre organização de informação.
url: /sobre-organizar-informacao/
dsq_thread_id: 1674757767
categories:
  - Acessibilidade
  - Artigos
  - Código
  - HTML
tags:
  - hipertexto
  - html
  - marcacao

---
Quando eu era criança, fazer trabalhos escolares era algo corriqueiro. O processo quase sempre era assim: a professora definia o assunto e ao chegar em casa, pegava um bocado de papel almaço (lembra?) e ia para casa da minha tia. Ela era a única da família que tinha enciclopédias. Se eu precisava fazer um trabalho escolar, certamente as enciclopédias da minha tia me ajudariam na tarefa. As tais enciclopédias eram pesadas. Chatas de serem usadas. Mas tinham tudo ou quase tudo do que eu precisava para completar o trabalho com o máximo de detalhes possível.

Você já pensou em como se organiza informação? A informação &#8211; um texto por exemplo &#8211; pode ser organizada de forma linear ou não linear. Imagine um livro. Toda a informação contida no livro está organizada de forma linear, isto é, há começo, meio e fim. Você não consegue absorver todo o significado da história se iniciar sua leitura pela metade do livro. Você precisa, necessariamente, iniciar do primeiro capítulo até o último para absorver o máximo possível de informação sobre a história. 

As enciclopédias tem suas informações organizadas de forma não linear, ou seja, as informações não estão organizadas em uma ordem específica, mas sim de forma relacional, associativa. Há uma série de assuntos e todos eles estão organizados por meio de referências. Exemplo: quando você procura informações sobre veículos automotores em uma enciclopédia, ao final do texto você pode encontrar uma série de referências dos assuntos relacionados, como por exemplo: motores a combustão interna, rodas, combustíveis, mecânica e etc. 

É mais ou menos assim que a sua mente funciona: quando você pensa em um assunto, seu cérebro faz uma série de associações com outros assuntos, formando uma ideia, uma memória, uma lembrança. Por esse motivo seu cérebro consegue guardar informações que podem ser recuperadas pensando nelas diretamente ou quando se pensa nos assuntos relacionados a ela.

> As enciclopédias tem suas informações organizadas de forma não linear, ou seja, as informações não estão organizadas em uma ordem específica, mas sim de forma relacional, associativa.

Se levarmos esse conceito para web, percebemos que apenas uma tag faz esse trabalho de referência e associação de informação: o link. Na web você relaciona informações, sites e etc utilizando diretamente a tag &#8220;A&#8221;. Quando você linka um texto, uma imagem, um gráfico etc, você associa essa informação ao destino do link. Você está referenciando assuntos, como na enciclopédia. Sem os links não há web. Não conseguimos associar informação alguma. Perde-se a referência. Nós usamos o link todos os dias e aposto que a metade dos desenvolvedores não imagina a importância dessa tag. 

Sugiro que você pesquise sobre a [história do hipertexto][1]. Você vai entender a amplitude do que significa organizar informação e da importância que isso teve para os dias de hoje tanto para web quanto para o mundo em si. É um assunto fascinante. Se quiser, comece por aqui: https://bit.ly/History\_of\_hypertext

> Quando você linka um texto, uma imagem, um gráfico etc, você associa essa informação ao destino do link. Você está referenciando assuntos, como na enciclopédia. Sem os links não há web.

Abaixo você pode ver uma palestra que fiz sobre o assunto. Vou tentar escrever mais sobre hipermidia aqui. É um assunto interessantíssimo que pode te ajudar a entender a internet como um todo e quais os motivos que a transformam em uma plataforma.



<p style="margin-bottom:5px">
  <strong> <a href="https://www.slideshare.net/diegoeis/a-verdadeira-semntica-do-html5" title="A verdadeira semântica do html5" target="_blank">A verdadeira semântica do html5</a> </strong> from <strong><a href="https://www.slideshare.net/diegoeis" target="_blank">Diego Eis</a></strong>
</p>

 [1]: https://pt.wikipedia.org/wiki/Hipertexto