---
title: Sobre Cor e Webdesign
authors: Dani Guerrato
paid: true
type: post
date: 2013-06-10
excerpt: Entenda o funcionamento dos sistemas de cores mais utilizados da web e conheça ferramentas úteis para criar e organizar suas próprias paletas.
url: /sobre-cor-e-webdesign/
dsq_thread_id: 1383318570
categories:
  - Artigos
  - CSS3
  - Design
tags:
  - cor
  - ferramentas
  - hex
  - hsla
  - rgba

---
É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma][3] na hora de escolher a matiz mais bacana. Mesmo com a evolução das placas de video a preocupação com acessibilidade e retrocompatibilidade forçou alguns desenvolvedores a se prenderem aquele esquema inicial. Estas eram as cores &#8220;web safe&#8221;, ou seja, aquelas que supostamente seriam exibidas corretamente em todos os browsers. Posteriormente foi descoberto que apenas 22 destas cores eram realmente seguras. Mas isto é outra história&#8230; Felizmente a tecnologia evoluiu e os monitores coloridos atualmente tem 24 bits e são capazes de renderizar exatamente 16,777,216 cores. Os dias de web safe ficaram para trás. Mas catalogar milhões de cores em um computador com base em seus respectivos nomes e suas variações em cada língua através de uma tabela passou a ser impossível! É mais prático entender a mecânica por trás dos códigos para assim usarmos as cores na internet de maneira efetiva.

Mas se você ainda precisa de um nome humano para se sentir mais feliz pode utilizar alguma ferramenta como [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma][3] na hora de escolher a matiz mais bacana. Mesmo com a evolução das placas de video a preocupação com acessibilidade e retrocompatibilidade forçou alguns desenvolvedores a se prenderem aquele esquema inicial. Estas eram as cores &#8220;web safe&#8221;, ou seja, aquelas que supostamente seriam exibidas corretamente em todos os browsers. Posteriormente foi descoberto que apenas 22 destas cores eram realmente seguras. Mas isto é outra história&#8230; Felizmente a tecnologia evoluiu e os monitores coloridos atualmente tem 24 bits e são capazes de renderizar exatamente 16,777,216 cores. Os dias de web safe ficaram para trás. Mas catalogar milhões de cores em um computador com base em seus respectivos nomes e suas variações em cada língua através de uma tabela passou a ser impossível! É mais prático entender a mecânica por trás dos códigos para assim usarmos as cores na internet de maneira efetiva.

Mas se você ainda precisa de um nome humano para se sentir mais feliz pode utilizar alguma ferramenta como][4] para descobrir um (em inglês) a partir de seu respectivo código. Uma opção em português é navegar em uma lista como a da [Wikipedia][5]. Não que isto tenha algum aspecto prático no dia-a-dia. Explicar para o seu cliente qual é a cor Feldspato pode ser mais complicado do que simplesmente mostrar o trabalho, mas você pode impressionar os seus amigos na próxima vez que jogar Stop.

## Sistemas de Cores

### RGB

O RGB (Red, Green e Blue &#8211; ou Vermelho, Verde e Azul) é um sistema de cores aditivo projetado para ser utilizado em dispositivos eletrônicos. Monitores são pretos e iluminados por pontos de luz. Portanto você parte da ausência de cor e vai &#8220;somando&#8221; pontos de luz vermelhos, verdes e azuis até chegar na cor desejada.

&nbsp;

<img class="alignnone size-full wp-image-37585" alt="rgb" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/rgb.jpg" width="660" height="400" srcset="uploads/2013/06/rgb.jpg 660w, uploads/2013/06/rgb-277x168.jpg 277w, uploads/2013/06/rgb-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

&nbsp;

A estrutura é composta por 3 pares de números de 3 dígitos cada variando do 0 ao 255, quanto mais alto é o número mais clara é a cor. Através destas combinações podemos chegar a mais de 16 milhões de cores (256 x 256 x 256).

É possível utilizar cores do sistema RGB em layouts diretamente de suas folhas de estilo. Para isto basta declarar o valor dos canais vermelho, verde e azul separados por virgula.

Vamos imaginar que o seu layout possui um título azul. A sintaxe em CSS ficaria assim:

<pre class="lang-CSS">h1 {
color: rgb(0, 0, 255);
}</pre>

Com as novidades do CSS3 o RGB ganhou um upgrade e tornou-se RGBA. O canal A (alpha) é responsável por controlar a opacidade das cores dos elementos em CSS sem afetar outros itens afiliados. Para isto basta declarar um valor de 0.1 a 1 separado por ponto. Este valor corresponde ao nível de transparência sendo 1 sólido e 0 invisível.
  
O mesmo título do nosso exemplo com 50% de transparência ficaria assim:

<pre class="lang-CSS">h1 {
color: rgb(0, 0, 255, 0.5);
}</pre>

### O sistema Hexadecimal

Se você está lendo este artigo provavelmente já está familiarizado com os tripletos hexadecimais. São sequências numéricas que representam cores formadas a partir de uma combinações de 6 caracteres precedidos de uma hashtag. Mas você sabe a lógica por trás do sistema?

Os códigos hexadecimais são compostos através de uma combinação de três conjuntos de pares formados a partir de números de 0 a 9 e letras de A a F. Quanto mais alto o número mais clara é a cor e quanto mais baixo o número &#8211; você adivinhou! &#8211; mais escura. Por isso que #000000 é preto. Se o código for composto de pares que se repetem como no caso de #444444, por exemplo, é possível utilizar a formula abreviada #444. O simbolo # serve apenas para informar que se trata de um código hexadecimal.

A sintaxe acredito ser já conhecida de todos:

<pre class="lang-CSS">h1 {
color: #0000ff;
}</pre>

Cada campo pode conter apenas um caractere. A função das letras é representar os números de dois dígitos, algo como o que acontece com o valete, dama e rei em cartas de baralhos. E é daí que vem o nome hexadecimal. São números de base 16. Ou seja, o A representa o 10, o B o 11 e assim por diante até a letra F. Por isto que a cor mais clara de todas, o branco, é representado por #FFFFFF.

Cada par é responsável por uma cor aditiva do esquema RGB. Os primeiros 2 números controlam o vermelho, os 2 seguintes o verde e os dois últimos o azul. Ou seja #ff0000 é o vermelho mais claro, #00ff00 é o verde mais claro e #0000ff é o azul mais claro.

<img class="alignnone size-full wp-image-37583" alt="hex-valor" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hex-valor.jpg" width="660" height="200" srcset="uploads/2013/06/hex-valor.jpg 660w, uploads/2013/06/hex-valor-329x99.jpg 329w, uploads/2013/06/hex-valor-588x178.jpg 588w" sizes="(max-width: 660px) 100vw, 660px" />

Como saber isto pode te ajudar? Simples, através deste mecanismo você pode fazer ajustes de cores no seu design diretamente do CSS de maneira prática e lógica. Você pode deixar uma matiz mais clara ou escura apenas alterando o valor dos pares numéricos.

<img class="alignnone size-full wp-image-37582" alt="hex-luminosidade" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hex-luminosidade.jpg" width="660" height="400" srcset="uploads/2013/06/hex-luminosidade.jpg 660w, uploads/2013/06/hex-luminosidade-277x168.jpg 277w, uploads/2013/06/hex-luminosidade-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

Para esquentar uma cor basta aumentar a quantidade de vermelhos (primeiro par) e diminuir a quantidade de azul (último par). Para esfriar basta fazer o processo inverso.

<img class="alignnone size-full wp-image-37581" alt="hex-colorimetria" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hex-colorimetria.jpg" width="660" height="400" srcset="uploads/2013/06/hex-colorimetria.jpg 660w, uploads/2013/06/hex-colorimetria-277x168.jpg 277w, uploads/2013/06/hex-colorimetria-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

### HSL

A escala das cores tanto em RGB quanto em códigos HEX varia entre o eixo claro-escuro. Estes modelos deixam de lado outras maneiras mais intuitivas de classificação de cores como matiz e saturação. O HSL surgiu para preencher este vácuo. A idéia aqui é distribuir as cores não em um eixo vertical mas sim em um modelo de cilindro. As cores não são somadas ou subtraídas, mas sim distribuídas ao longo de um circulo cromático. Cada matiz representa um grau do cilindro entre 0 e 360.

<img class="alignnone size-full wp-image-37584" alt="hsl" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hsl.jpg" width="660" height="400" srcset="uploads/2013/06/hsl.jpg 660w, uploads/2013/06/hsl-277x168.jpg 277w, uploads/2013/06/hsl-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

A sintaxe dele é da seguinte maneira:
  
hsl (hue, saturation%, lightness%);

Sendo o primeiro valor a matiz, o segundo a saturação e o terceiro a quantidade de iluminação. O nosso título azul ficaria assim:

<pre class="lang-CSS">h1 {
color: hsl(240, 100%, 50%);
}</pre>

Da mesma forma que o RGB o HSL também pode ser utilizado em CSS e possui um canal alpha (HSLA). O mesmo título com 50% de opacidade:

<pre class="lang-CSS">h1 {
color: hsl(240, 100%, 50%, 0.5);
}</pre>

Embora possua suas vantagens, principalmente para quem esta acostumado com divisões mais artísticas de cores, o HSL ainda não se popularizou&#8230; Suponho que a razão é por que alguns softwares gráficos utilizados por designers, como o Photoshop, simplesmente não possuem um misturador de cores compatível com o formato. Todas as cores utilizadas no layout teriam que ser convertidas manualmente para HSL, o que poderia significar um gasto a mais em tempo. Existem alguns plugins que prometem facilitar o processo, mas as outras alternativas (RGBA e HEX) já funcionam muito bem. Até que os programas gráficos mais populares sejam compatíveis, o HSL não deve ganhar muito espaço.

### CMYK

Já aconteceu de você abrir uma foto no computador e reparar que as cores estão bem estranhas? Pois é, o estagiário provavelmente fechou o arquivo em CMYK. Este formato foi pensado exclusivamente para pigmentos de impressão.

CMYK é uma sigla para Cyan, Magenta, Yellow e Black (Ciano, Magenta, Amarelo e Preto). Se você está se perguntando por que a sigla para preto é K existem duas explicações provavéis. A primeira é que o K representa Key já que o preto é uma cor-chave. A outrea é simplesmente para não confundirem com o B de Blue no RGB.

O CMYK é um sistema de cores subtrativo já que você parte do branco e vai retirando luminosidade até chegar na cor desejada. A impressão em CMYK é a partir de pontos coloridos chamados retículas. Como nosso foco aqui é a internet não vou entrar em muitos detalhes sobre este sistema. Mas vale a pena conhecer para saber como **não** salvar arquivos para a web.

### Qual sistema utilizar?

Tudo depende das características do seu layout. Considerando esquemas de cores flat o hexadecimal serve muito bem. Alias, inspirada pelo visual minimalista do Windows 8 as [cores vivas e sólidas][6] são uma grande tendência em 2013. Mas se o seu layout faz uso de transparências, gradientes e sombras o RGBA vale bastante a pena.

Mas você não precisa prender-se a apenas uma opção. Você pode combinar, em um mesmo CSS, sistemas diferentes. Uma prática comum é utilizar HEX para cores sólidas e RGBA apenas para situações onde o canal alpha é importante. De qualquer maneira ter a mão uma tabela de equivalência pode ser útil. Sorte que existem conversores automáticos como o [ColorHexa][7] para ajudar nesta tarefa. Basta digitar um código de cor (de qualquer tipo) ou um nome em inglês para descobrir os valores equivalentes em HEX, Binário, RGB, CMYK, HSL, HSV, CIE-Lab, Hunter-Lab, CIE-Luv, CIE-LCH, XYZ e xyY. Só isto já seria ótimo, mas a ferramenta ainda tem outras informações interessantes como sugestões de esquemas de cores e alguns snippets de CSS para você visualizar aquela cor aplicada a um texto, borda e background de uma div. Outra função bacana é a possibilidade de visualizar como uma pessoa com daltonismo enxergaria aquela cor.

## Acessibilidade

Estima-se que 8% dos homens do mundo e 0.5% das mulheres sofre de algum tipo de dificuldade de percepção de cores como o daltonismo. Para garantir que estas pessoas poderão acessar o conteúdo da sua página é importante não depender da cor para indicar elementos importantes. Por exemplo, indicar campos de formulário com erros apenas com a cor vermelha não é distinção suficiente. Seria interessante, neste caso, complementar a informação com algum outro recurso gráfico como um ícone. Se você tem um amigo com daltonismo é interessante pedir para ele navegar no site e dizer se encontra algum problema. Como nem sempre temos a oportunidade de realizarmos este tipo de teste uma experiência que pode ajudar é retirar a saturação de todas as cores do layout em um programa gráfico. Se as informações importantes ainda estão claras e com bom contraste apenas em tons de cinza o seu layout é acessível. Você pode ainda utilizar alguma ferramenta online como o [Color Filter][8] para checar como pessoas com os tipos mais comuns de daltonismo enxergam sua página.

## Inspiração

### Cores de Marcas

Na hora de criar um layout um designer sempre tem a mão sua própria paleta de cores. Mas quando é preciso utilizar as cores de outras empresas a coisa complica! Qual é exatamente o tom de azul do Facebook? E do Twitter? E o código hexadecimal do verde Android? A missão do [Brand Colors][9] é justamente servir como um catálogo de cores dos gigantes da internet. Além de ser útil para descobrir rapidamente as cores de marcas famosas, a ferramenta é um bom panorama de quais são os tons mais utilizados na rede.

[<img class="alignnone size-full wp-image-37601" alt="brand-colors" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/brand-colors.jpg" width="660" height="400" srcset="uploads/2013/06/brand-colors.jpg 660w, uploads/2013/06/brand-colors-277x168.jpg 277w, uploads/2013/06/brand-colors-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][10]

### Cores da Web

Que tal ir um passo além da cor predominante e descobrir a paleta de cores completa de uma marca? Através do [Webcolour Data][11] você pode explorar as cores de qualquer site na internet. Basta inserir a URL e se inspirar no esquema de cores do seu site favorito. A ferramenta exibe resultados (e seus respectivos códigos HEX) em gráficos interessantes com base em porcentagem de uso, distribuição de tons, roda de cores e sites com paletas de cor semelhantes. O Webcolour Data também pode ser útil para realizar uma análise de design e verificar se as cores de um site estão consistentes com aquelas propostas na identidade visual.

[<img class="alignnone size-full wp-image-37600" alt="web-colour-data" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/web-colour-data.jpg" width="660" height="400" srcset="uploads/2013/06/web-colour-data.jpg 660w, uploads/2013/06/web-colour-data-277x168.jpg 277w, uploads/2013/06/web-colour-data-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][12]

### Cores de Fotos

O [Color Thief][13] tem uma proposta semelhante. Mas a idéia aqui é explorar paletas baseadas em fotos. Basta realizar um upload de imagens que a ferramenta captura o esquema de cores predominante.

[<img class="alignnone size-full wp-image-37596" alt="color-thief" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/color-thief.jpg" width="660" height="400" srcset="uploads/2013/06/color-thief.jpg 660w, uploads/2013/06/color-thief-277x168.jpg 277w, uploads/2013/06/color-thief-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][14]

### Cores de Filmes

O Tumblr [Movies In Color][15] pode ser uma grande fonte de inspiração para quem curte cinema. A idéia aqui é conhecer a paleta de cores utilizada na cinematografia de filmes como 2001 &#8211; Uma Odisséia no Espaço, O Fabuloso Destino de Amélie Poulain, Clube da Luta e Inception. Você pode navegar por imagens, títulos dos filmes ou nome do diretor de fotografia. Vale o clique!

[<img class="alignnone size-full wp-image-37599" alt="movis-in-color" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/movis-in-color.jpg" width="660" height="400" srcset="uploads/2013/06/movis-in-color.jpg 660w, uploads/2013/06/movis-in-color-277x168.jpg 277w, uploads/2013/06/movis-in-color-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][16]

### Criando suas próprias paletas

Criar esquemas de cores pode ser uma tarefa mais prática utilizando algum gerador como o [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma][3] na hora de escolher a matiz mais bacana. Mesmo com a evolução das placas de video a preocupação com acessibilidade e retrocompatibilidade forçou alguns desenvolvedores a se prenderem aquele esquema inicial. Estas eram as cores &#8220;web safe&#8221;, ou seja, aquelas que supostamente seriam exibidas corretamente em todos os browsers. Posteriormente foi descoberto que apenas 22 destas cores eram realmente seguras. Mas isto é outra história&#8230; Felizmente a tecnologia evoluiu e os monitores coloridos atualmente tem 24 bits e são capazes de renderizar exatamente 16,777,216 cores. Os dias de web safe ficaram para trás. Mas catalogar milhões de cores em um computador com base em seus respectivos nomes e suas variações em cada língua através de uma tabela passou a ser impossível! É mais prático entender a mecânica por trás dos códigos para assim usarmos as cores na internet de maneira efetiva.

Mas se você ainda precisa de um nome humano para se sentir mais feliz pode utilizar alguma ferramenta como [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma [É possível analisar a Teoria da Cor de diversas maneiras. Podemos escolher uma abordagem física, psicológica, cultural, filosófica ou artística para entendermos as cores. Todos estes estudos são interessantes e extremamente relevantes para designers e desenvolvedores. Mas na hora de colocar a mão na massa decidir entre sistemas e organizar uma paleta de cores bacana pode parecer uma tarefa confusa até para os designers veteranos. Quais são as melhores práticas? Quais ferramentas podem facilitar o uso, análise, inspiração e criação de paletas de cores para a internet? A intenção deste artigo é responder a estas perguntas e fornecer algumas dicas práticas sobre cor e webdesign.

## Nomeando Cores

Dar nome a cores sempre foi um problema. Linguagem é uma coisa extremamente subjetiva e arbitrária. Cada grupo cultural possui uma visão de mundo diferente e portanto dá nome ao objetos a sua própria maneira. Com as cores não podia ser diferente.

Outro grande problema é que a percepção física de cores varia de pessoa para pessoa. Cor é a maneira que o olho interpreta a luz refletida nos objetos. O ser humano possuí células chamadas cones. Estas células são responsáveis por entender os diferentes padrões de comprimento de onda e entregar esta informação ao cérebro. E esta percepção pode variar individualmente. [Pesquisas][1] mostram que existe uma diferença na maneira com a qual homens e mulheres classificam as cores, por exemplo. E até [pessoas com super visão][2] que enxergam milhões de cores a mais que alguem comum.

### A Era Web Safe

Nos primórdios da web tudo era relativamente mais simples. Os chips gráficos trabalhavam com apenas 8-bits e eram capazes de reproduzir exatamente 256 cores diferentes. 216 delas ganharam um nome em inglês (o restante ficou reservado para uso interno de cada sistema) e precisávamos consultar uma][3] na hora de escolher a matiz mais bacana. Mesmo com a evolução das placas de video a preocupação com acessibilidade e retrocompatibilidade forçou alguns desenvolvedores a se prenderem aquele esquema inicial. Estas eram as cores &#8220;web safe&#8221;, ou seja, aquelas que supostamente seriam exibidas corretamente em todos os browsers. Posteriormente foi descoberto que apenas 22 destas cores eram realmente seguras. Mas isto é outra história&#8230; Felizmente a tecnologia evoluiu e os monitores coloridos atualmente tem 24 bits e são capazes de renderizar exatamente 16,777,216 cores. Os dias de web safe ficaram para trás. Mas catalogar milhões de cores em um computador com base em seus respectivos nomes e suas variações em cada língua através de uma tabela passou a ser impossível! É mais prático entender a mecânica por trás dos códigos para assim usarmos as cores na internet de maneira efetiva.

Mas se você ainda precisa de um nome humano para se sentir mais feliz pode utilizar alguma ferramenta como][4] para descobrir um (em inglês) a partir de seu respectivo código. Uma opção em português é navegar em uma lista como a da [Wikipedia][5]. Não que isto tenha algum aspecto prático no dia-a-dia. Explicar para o seu cliente qual é a cor Feldspato pode ser mais complicado do que simplesmente mostrar o trabalho, mas você pode impressionar os seus amigos na próxima vez que jogar Stop.

## Sistemas de Cores

### RGB

O RGB (Red, Green e Blue &#8211; ou Vermelho, Verde e Azul) é um sistema de cores aditivo projetado para ser utilizado em dispositivos eletrônicos. Monitores são pretos e iluminados por pontos de luz. Portanto você parte da ausência de cor e vai &#8220;somando&#8221; pontos de luz vermelhos, verdes e azuis até chegar na cor desejada.

&nbsp;

<img class="alignnone size-full wp-image-37585" alt="rgb" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/rgb.jpg" width="660" height="400" srcset="uploads/2013/06/rgb.jpg 660w, uploads/2013/06/rgb-277x168.jpg 277w, uploads/2013/06/rgb-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

&nbsp;

A estrutura é composta por 3 pares de números de 3 dígitos cada variando do 0 ao 255, quanto mais alto é o número mais clara é a cor. Através destas combinações podemos chegar a mais de 16 milhões de cores (256 x 256 x 256).

É possível utilizar cores do sistema RGB em layouts diretamente de suas folhas de estilo. Para isto basta declarar o valor dos canais vermelho, verde e azul separados por virgula.

Vamos imaginar que o seu layout possui um título azul. A sintaxe em CSS ficaria assim:

<pre class="lang-CSS">h1 {
color: rgb(0, 0, 255);
}</pre>

Com as novidades do CSS3 o RGB ganhou um upgrade e tornou-se RGBA. O canal A (alpha) é responsável por controlar a opacidade das cores dos elementos em CSS sem afetar outros itens afiliados. Para isto basta declarar um valor de 0.1 a 1 separado por ponto. Este valor corresponde ao nível de transparência sendo 1 sólido e 0 invisível.
  
O mesmo título do nosso exemplo com 50% de transparência ficaria assim:

<pre class="lang-CSS">h1 {
color: rgb(0, 0, 255, 0.5);
}</pre>

### O sistema Hexadecimal

Se você está lendo este artigo provavelmente já está familiarizado com os tripletos hexadecimais. São sequências numéricas que representam cores formadas a partir de uma combinações de 6 caracteres precedidos de uma hashtag. Mas você sabe a lógica por trás do sistema?

Os códigos hexadecimais são compostos através de uma combinação de três conjuntos de pares formados a partir de números de 0 a 9 e letras de A a F. Quanto mais alto o número mais clara é a cor e quanto mais baixo o número &#8211; você adivinhou! &#8211; mais escura. Por isso que #000000 é preto. Se o código for composto de pares que se repetem como no caso de #444444, por exemplo, é possível utilizar a formula abreviada #444. O simbolo # serve apenas para informar que se trata de um código hexadecimal.

A sintaxe acredito ser já conhecida de todos:

<pre class="lang-CSS">h1 {
color: #0000ff;
}</pre>

Cada campo pode conter apenas um caractere. A função das letras é representar os números de dois dígitos, algo como o que acontece com o valete, dama e rei em cartas de baralhos. E é daí que vem o nome hexadecimal. São números de base 16. Ou seja, o A representa o 10, o B o 11 e assim por diante até a letra F. Por isto que a cor mais clara de todas, o branco, é representado por #FFFFFF.

Cada par é responsável por uma cor aditiva do esquema RGB. Os primeiros 2 números controlam o vermelho, os 2 seguintes o verde e os dois últimos o azul. Ou seja #ff0000 é o vermelho mais claro, #00ff00 é o verde mais claro e #0000ff é o azul mais claro.

<img class="alignnone size-full wp-image-37583" alt="hex-valor" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hex-valor.jpg" width="660" height="200" srcset="uploads/2013/06/hex-valor.jpg 660w, uploads/2013/06/hex-valor-329x99.jpg 329w, uploads/2013/06/hex-valor-588x178.jpg 588w" sizes="(max-width: 660px) 100vw, 660px" />

Como saber isto pode te ajudar? Simples, através deste mecanismo você pode fazer ajustes de cores no seu design diretamente do CSS de maneira prática e lógica. Você pode deixar uma matiz mais clara ou escura apenas alterando o valor dos pares numéricos.

<img class="alignnone size-full wp-image-37582" alt="hex-luminosidade" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hex-luminosidade.jpg" width="660" height="400" srcset="uploads/2013/06/hex-luminosidade.jpg 660w, uploads/2013/06/hex-luminosidade-277x168.jpg 277w, uploads/2013/06/hex-luminosidade-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

Para esquentar uma cor basta aumentar a quantidade de vermelhos (primeiro par) e diminuir a quantidade de azul (último par). Para esfriar basta fazer o processo inverso.

<img class="alignnone size-full wp-image-37581" alt="hex-colorimetria" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hex-colorimetria.jpg" width="660" height="400" srcset="uploads/2013/06/hex-colorimetria.jpg 660w, uploads/2013/06/hex-colorimetria-277x168.jpg 277w, uploads/2013/06/hex-colorimetria-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

### HSL

A escala das cores tanto em RGB quanto em códigos HEX varia entre o eixo claro-escuro. Estes modelos deixam de lado outras maneiras mais intuitivas de classificação de cores como matiz e saturação. O HSL surgiu para preencher este vácuo. A idéia aqui é distribuir as cores não em um eixo vertical mas sim em um modelo de cilindro. As cores não são somadas ou subtraídas, mas sim distribuídas ao longo de um circulo cromático. Cada matiz representa um grau do cilindro entre 0 e 360.

<img class="alignnone size-full wp-image-37584" alt="hsl" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/hsl.jpg" width="660" height="400" srcset="uploads/2013/06/hsl.jpg 660w, uploads/2013/06/hsl-277x168.jpg 277w, uploads/2013/06/hsl-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />

A sintaxe dele é da seguinte maneira:
  
hsl (hue, saturation%, lightness%);

Sendo o primeiro valor a matiz, o segundo a saturação e o terceiro a quantidade de iluminação. O nosso título azul ficaria assim:

<pre class="lang-CSS">h1 {
color: hsl(240, 100%, 50%);
}</pre>

Da mesma forma que o RGB o HSL também pode ser utilizado em CSS e possui um canal alpha (HSLA). O mesmo título com 50% de opacidade:

<pre class="lang-CSS">h1 {
color: hsl(240, 100%, 50%, 0.5);
}</pre>

Embora possua suas vantagens, principalmente para quem esta acostumado com divisões mais artísticas de cores, o HSL ainda não se popularizou&#8230; Suponho que a razão é por que alguns softwares gráficos utilizados por designers, como o Photoshop, simplesmente não possuem um misturador de cores compatível com o formato. Todas as cores utilizadas no layout teriam que ser convertidas manualmente para HSL, o que poderia significar um gasto a mais em tempo. Existem alguns plugins que prometem facilitar o processo, mas as outras alternativas (RGBA e HEX) já funcionam muito bem. Até que os programas gráficos mais populares sejam compatíveis, o HSL não deve ganhar muito espaço.

### CMYK

Já aconteceu de você abrir uma foto no computador e reparar que as cores estão bem estranhas? Pois é, o estagiário provavelmente fechou o arquivo em CMYK. Este formato foi pensado exclusivamente para pigmentos de impressão.

CMYK é uma sigla para Cyan, Magenta, Yellow e Black (Ciano, Magenta, Amarelo e Preto). Se você está se perguntando por que a sigla para preto é K existem duas explicações provavéis. A primeira é que o K representa Key já que o preto é uma cor-chave. A outrea é simplesmente para não confundirem com o B de Blue no RGB.

O CMYK é um sistema de cores subtrativo já que você parte do branco e vai retirando luminosidade até chegar na cor desejada. A impressão em CMYK é a partir de pontos coloridos chamados retículas. Como nosso foco aqui é a internet não vou entrar em muitos detalhes sobre este sistema. Mas vale a pena conhecer para saber como **não** salvar arquivos para a web.

### Qual sistema utilizar?

Tudo depende das características do seu layout. Considerando esquemas de cores flat o hexadecimal serve muito bem. Alias, inspirada pelo visual minimalista do Windows 8 as [cores vivas e sólidas][6] são uma grande tendência em 2013. Mas se o seu layout faz uso de transparências, gradientes e sombras o RGBA vale bastante a pena.

Mas você não precisa prender-se a apenas uma opção. Você pode combinar, em um mesmo CSS, sistemas diferentes. Uma prática comum é utilizar HEX para cores sólidas e RGBA apenas para situações onde o canal alpha é importante. De qualquer maneira ter a mão uma tabela de equivalência pode ser útil. Sorte que existem conversores automáticos como o [ColorHexa][7] para ajudar nesta tarefa. Basta digitar um código de cor (de qualquer tipo) ou um nome em inglês para descobrir os valores equivalentes em HEX, Binário, RGB, CMYK, HSL, HSV, CIE-Lab, Hunter-Lab, CIE-Luv, CIE-LCH, XYZ e xyY. Só isto já seria ótimo, mas a ferramenta ainda tem outras informações interessantes como sugestões de esquemas de cores e alguns snippets de CSS para você visualizar aquela cor aplicada a um texto, borda e background de uma div. Outra função bacana é a possibilidade de visualizar como uma pessoa com daltonismo enxergaria aquela cor.

## Acessibilidade

Estima-se que 8% dos homens do mundo e 0.5% das mulheres sofre de algum tipo de dificuldade de percepção de cores como o daltonismo. Para garantir que estas pessoas poderão acessar o conteúdo da sua página é importante não depender da cor para indicar elementos importantes. Por exemplo, indicar campos de formulário com erros apenas com a cor vermelha não é distinção suficiente. Seria interessante, neste caso, complementar a informação com algum outro recurso gráfico como um ícone. Se você tem um amigo com daltonismo é interessante pedir para ele navegar no site e dizer se encontra algum problema. Como nem sempre temos a oportunidade de realizarmos este tipo de teste uma experiência que pode ajudar é retirar a saturação de todas as cores do layout em um programa gráfico. Se as informações importantes ainda estão claras e com bom contraste apenas em tons de cinza o seu layout é acessível. Você pode ainda utilizar alguma ferramenta online como o [Color Filter][8] para checar como pessoas com os tipos mais comuns de daltonismo enxergam sua página.

## Inspiração

### Cores de Marcas

Na hora de criar um layout um designer sempre tem a mão sua própria paleta de cores. Mas quando é preciso utilizar as cores de outras empresas a coisa complica! Qual é exatamente o tom de azul do Facebook? E do Twitter? E o código hexadecimal do verde Android? A missão do [Brand Colors][9] é justamente servir como um catálogo de cores dos gigantes da internet. Além de ser útil para descobrir rapidamente as cores de marcas famosas, a ferramenta é um bom panorama de quais são os tons mais utilizados na rede.

[<img class="alignnone size-full wp-image-37601" alt="brand-colors" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/brand-colors.jpg" width="660" height="400" srcset="uploads/2013/06/brand-colors.jpg 660w, uploads/2013/06/brand-colors-277x168.jpg 277w, uploads/2013/06/brand-colors-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][10]

### Cores da Web

Que tal ir um passo além da cor predominante e descobrir a paleta de cores completa de uma marca? Através do [Webcolour Data][11] você pode explorar as cores de qualquer site na internet. Basta inserir a URL e se inspirar no esquema de cores do seu site favorito. A ferramenta exibe resultados (e seus respectivos códigos HEX) em gráficos interessantes com base em porcentagem de uso, distribuição de tons, roda de cores e sites com paletas de cor semelhantes. O Webcolour Data também pode ser útil para realizar uma análise de design e verificar se as cores de um site estão consistentes com aquelas propostas na identidade visual.

[<img class="alignnone size-full wp-image-37600" alt="web-colour-data" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/web-colour-data.jpg" width="660" height="400" srcset="uploads/2013/06/web-colour-data.jpg 660w, uploads/2013/06/web-colour-data-277x168.jpg 277w, uploads/2013/06/web-colour-data-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][12]

### Cores de Fotos

O [Color Thief][13] tem uma proposta semelhante. Mas a idéia aqui é explorar paletas baseadas em fotos. Basta realizar um upload de imagens que a ferramenta captura o esquema de cores predominante.

[<img class="alignnone size-full wp-image-37596" alt="color-thief" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/color-thief.jpg" width="660" height="400" srcset="uploads/2013/06/color-thief.jpg 660w, uploads/2013/06/color-thief-277x168.jpg 277w, uploads/2013/06/color-thief-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][14]

### Cores de Filmes

O Tumblr [Movies In Color][15] pode ser uma grande fonte de inspiração para quem curte cinema. A idéia aqui é conhecer a paleta de cores utilizada na cinematografia de filmes como 2001 &#8211; Uma Odisséia no Espaço, O Fabuloso Destino de Amélie Poulain, Clube da Luta e Inception. Você pode navegar por imagens, títulos dos filmes ou nome do diretor de fotografia. Vale o clique!

[<img class="alignnone size-full wp-image-37599" alt="movis-in-color" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/movis-in-color.jpg" width="660" height="400" srcset="uploads/2013/06/movis-in-color.jpg 660w, uploads/2013/06/movis-in-color-277x168.jpg 277w, uploads/2013/06/movis-in-color-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][16]

### Criando suas próprias paletas

Criar esquemas de cores pode ser uma tarefa mais prática utilizando algum gerador como o][17] da Adobe ou o [Color Scheme Designer][18]. Através destas ferramentas você pode criar esquemas monocromáticos, complementares, análogos, etc. Se você criou algo realmente legal e deseja compartilhar com o mundo ou simplesmente quer navegar por diversas paletas e se inspirar a rede social [Colour Lovers][19] pode ser um lugar interessante.

[<img class="alignnone size-full wp-image-37598" alt="kuler" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/kuler.jpg" width="660" height="400" srcset="uploads/2013/06/kuler.jpg 660w, uploads/2013/06/kuler-277x168.jpg 277w, uploads/2013/06/kuler-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][20]

### Games

Quem disse que você não pode aprender se divertindo? Alguns webgames como o [Color Method][21] testam o seu conhecimento e percepção de cores com base em tom, saturação, cores complementares, análogas&#8230; Cuidado, pode ser viciante!

[<img class="alignnone size-full wp-image-37595" alt="color-method" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/06/color-method.jpg" width="660" height="400" srcset="uploads/2013/06/color-method.jpg 660w, uploads/2013/06/color-method-277x168.jpg 277w, uploads/2013/06/color-method-511x310.jpg 511w" sizes="(max-width: 660px) 100vw, 660px" />][22]

### Saiba mais:

[CSS3 Breve Introdução a RGBA][23]
  
[RGB e HSL][24]
  
[The Code Side of the Color][25]

 [1]: https://blog.kissmetrics.com/gender-and-color/ "Gender and Color"
 [2]: https://revistagalileu.globo.com/Revista/Common/0,,EMI310040-17770,00-MULHER+COM+SUPERVISAO+ENXERGA+MILHOES+DE+CORES+A+MAIS.html "Mulher com super-visão enxerga 99 milhões de cores a mais"
 [3]: https://www.w3.org/TR/SVG/types.html#ColorKeywords "W3C Color Keywords"
 [4]: https://www.color-blindness.com/color-name-hue "Color name & hue"
 [5]: https://pt.wikipedia.org/wiki/Anexo:Lista_de_cores "Wikipedia - Lista de Cores"
 [6]: https://flatuicolors.com/ "Flat UI Colors"
 [7]: https://www.colorhexa.com/ "Color Hexa"
 [8]: https://colorfilter.wickline.org/ "Color Filter"
 [9]: https://brandcolors.net/ "Brand Colors"
 [10]: https://brandcolors.net/
 [11]: https://webcolourdata.com/ "Webcolourdata"
 [12]: https://webcolourdata.com/
 [13]: https://lokeshdhakar.com/projects/color-thief/ "Color Thief"
 [14]: https://lokeshdhakar.com/projects/color-thief/
 [15]: https://moviesincolor.com/ "Movies In Color"
 [16]: https://moviesincolor.com/
 [17]: https://kuler.adobe.com/create/color-wheel/ "Kuler"
 [18]: https://colorschemedesigner.com/ "Color Scheme Designer"
 [19]: https://www.colourlovers.com/ "Colour Lovers"
 [20]: https://kuler.adobe.com
 [21]: https://color.method.ac/ "Color Method"
 [22]: https://color.method.ac/
 [23]: https://tableless.com.br/css3-breve-introducao-a-rgba "Breve introdução a RGBA"
 [24]: https://tableless.com.br/rgb-e-hsl "RGB e HSL"
 [25]: https://coding.smashingmagazine.com/2012/10/04/the-code-side-of-color/ "The Code Side of the Color"