---
title: Slack Time – Sua preguiça também pode gerar resultados
authors: Henrique Schreiner
type: post
date: 2015-10-14
excerpt: Aprenda mais sobre esta técnica utilizada em metodologias ágeis e saiba usar seu tempo de folga para melhorar seus processos.
url: /slack-time-sua-preguica-tambem-pode-gerar-resultados/
categories:
  - Técnicas e Práticas
  - Tecnologia e Tendências

---
Pra quem já trabalhou com desenvolvimento ágil, provavelmente já ouviu falar sobre &#8220;_**Slack Time**_&#8221; (ou &#8220;**Tempo Preguiçoso**&#8221; ou &#8220;**Tempo de Folga**&#8220;, numa tradução livre).

Apesar do termo parecer algo negativo, é uma técnica muito usada pelas equipes que utilizam metodologias ágeis para usar o tempo entre uma tarefa e outra (como uma sprint e outra no <a href="https://pt.wikipedia.org/wiki/Scrum" target="_blank">SCRUM</a>), para criar algo que possa melhorar o processo de desenvolvimento, refatorar alguma rotina ou criar alguma ferramenta.

James Shore em seu livro &#8216;A Arte do Desenvolvimento Ágil&#8217; cita o seguinte exemplo para explicar o que o slack significa:

> _&#8220;Imagine que o cabo de sua estação de trabalho é suficientemente longo apenas para alcançar a tomada na parede. Você pode plugá-lo se deixá-lo bem esticado, mas a mais leve vibração fará com que o cabo se desconecte da tomada. Você perderá tudo o que estiver trabalhando._
  
>  _Eu não posso permitir que meu computador se desligue à menor provocação. Meu trabalho é muito importante para isso. Nesta situação, eu moveria meu computador para mais perto da tomada para que eu pudesse lidar com solavancos menores. Seus planos de projeto são muito importantes para serem corrompidos à menor provocação. Como o cabo de força, eles precisam de uma folga&#8221;._

Slacks (ou folgas) podem te ajudar a obter entregas consistentes e obter maior qualidade de software. A prática slack caminha lado-a-lado com as práticas ágeis como a refatoração contínua e o design emergente. Funciona assim: através da sprint seu time segue práticas de design emergente e refatoração. Então veja o quão rápido é o resultado. Use esta velocidade em futuras sprints para que o tempo para um bom design e refatoração seja construído em cima disso.

Talvez seja pouco intuitivo no começo, mas estas práticas irão ajudar as coisas a irem mais rápido ao longo do tempo. Refatoração é uma forma de pagar o débito técnico. Se você não paga este débito, o design do seu código se deteriora e o seu software se torna &#8220;engessado&#8221;. Isto lhe dará um resultado mais lento. Por outro lado, se uma atenção constante for dada ao design, através da refatoração, o código se torna mais fácil de mudar, o que implica em aumento de velocidade.

Com estas práticas aplicadas no seu tempo de desenvolvimento, você tem mais tempo (&#8220;folga&#8221;) quando emergências surgirem. Nestes casos, você pode colocar algumas refatorações em ordem para se adequarem às necessidades de uma tarefa que sendo executada. Contudo, use esta opção com sabedoria (e raramente), ou débitos técnicos começarão a aparecer de novo. Se você perceber que está omitindo a refatoração, provavelmente você não tem &#8220;folga&#8221; suficiente.
  
James Shore também disse: _&#8220;Pela variação da quantidade de tempo que você gasta para pagar por débitos técnicos, pode se certificar que a maioria das iterações aparecem no momento exato&#8221;._

Slack te dá essa segurança e te ajuda a manter alta a qualidade do seu software, te permitindo realizar grandes projetos mais rapidamente.