---
title: Shopify – Uma ótima opção de e-commerce
authors: Diego Eis
type: post
date: 2015-07-09
excerpt: Talvez, em vez de criar um e-commerce completo, seja mais interessante indicar um sistema pronto e-commerce, como o Shopify.
url: /shopify-uma-otima-opcao-de-e-commerce/
categories:
  - Publieditorial
tags:
  - eCommerce
  - publieditorial
  - shopify

---
Como desenvolvedores, nós temos a tendência de fazer nossos próprios produtos, serviços e sites. Muito dificilmente usamos algo já totalmente pronto, mas há momentos onde simplesmente indicar um serviço pronto é o melhor negócio, tanto para você, quanto para seu cliente. Talvez, um criador de sites seja um tanto inútil para você, desenvolver. Esse é seu arroz com feijão. Mas um e-commerce, por exemplo, a história é totalmente diferente. Um e-commerce tem uma série de processos, telas, fluxos e todas essas coisas que levam tempo para desenvolver. Se o cliente não precisa de uma customização visual ou um fluxo muito específico, talvez não valha a pena fazer um e-commerce do zero (a não ser por diversão).

**O [Shopify][1] é tudo o que você precisa para vender online**. Este é o destaque estampado no site do Shopify. Eu já tive uma série de clientes, pequenos, que não conseguiam ou não podiam pagar para desenvolver e manter um e-commerce completo, decente e principalmente customizado. Por isso, passei a indicar algumas soluções prontas, como o Shopify e até mesmo o WooCommerce, quando era o caso de um projeto em WordPress. 

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/07/img1.jpg" alt="spotify" width="887" height="602" class="alignnone size-full wp-image-49982" />

## Vantagens do Shopify

Por ser um serviço pronto e muito completo, há vários pontos que seu cliente não precisa se preocupar por serem nativas do serviço. Algumas delas:

  * **Hospedagem web:** Você nunca será cobrado com base no número de visitantes ou no tráfego da sua loja. A sua loja online inclui um certificado SSL de 256-bits para manter as informações dos seus clientes e os dados do seu negócio seguros. Todas as informações do seu negócio, incluindo produtos, clientes, pedidos e inventário, são salvas todos os dias em backup nos nossos data centers seguros.
  * **Vitrine de produtos:** Você tem acesso total ao HTML e CSS da sua loja, o que faz com que seja fácil personalizar cada aspecto da sua loja.
  * **Marketing e SEO:** O seu sitemap.xml é gerado automaticamente com seus produtos, páginas web e publicações de blog. Ajude clientes potenciais a encontrarem a sua loja usando mecanismos de busca. O Shopify suporta melhores práticas de SEO como H1 customizável, título e meta tags. Os seus clientes podem comprar um cartão de presente para alguém na sua loja ou você pode usar cartões de presente como crédito na loja.
  * **Analytics:** O Google Analytics funciona com a sua loja online, para que você possa acompanhar vendas, visitas e indicações. Veja de onde os seus visitantes estão vindo e como eles encontraram a sua loja online. Analise e obtenha informações sobre o crescimento da sua loja. Veja os produtos que estão vendendo – e aqueles que não estão.

Uma vantagem muito interessante é a possibilidade de você conseguir vender pelo Facebook com quase nenhum trabalho. Além de estar presente na sua loja virtual normal, pelo seu domínio, os produtos da sua loja também ficam disponíveis para a compra no próprio Facebook, que é onde os clientes podem passar a maior parte do tempo.

Achei muito fácil a &#8220;entrada&#8221; no sistema. Com 3 passos fáceis, sem muito blá blá blá a gente já consegue ter o cadastro feito e em poucos segundos já estamos na interface de administração do e-commerce.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/07/admin-loja-spotify.jpg" alt="admin-loja-spotify" width="1500" height="998" class="alignnone size-full wp-image-49983" />

Além disso, eles tem uma espécie de App Store de plugins/extensões. Essas extensões são feitos por outros desenvolvedores e empresas ligadas à venda online. A vantagem é que isso evita a necessidade de desenvolver alguma feature extra. Basta procurar primeiro nessa &#8220;loja de plugins&#8221; e se não tiver, aí sim let&#8217;s por a mão na massa. Se for o caso de desenvolver algo por fora, considere colocar na App Store para vender e ganhar um extra. Pode ser que outras pessoas precisam da sua solução.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/07/cards-appstore.jpg" alt="cards-appstore" width="1000" height="665" class="alignnone size-full wp-image-49988" />

Como eu disse no começo, pode ser um pouco estranho um desenvolvedor usar oferecer algo pronto para seu cliente. Mas não há motivos para que isso não seja uma boa prática. Além de economizar seu tempo, você fideliza o cliente mostrando uma tecnologia que talvez ele nunca descobriria sozinho, onde ele irá economizar tempo e dinheiro.

_<small>Publieditorial.</small>_

 [1]: https://bit.ly/1RlIgw2