---
title: Seu Conteúdo, Agora Mobile
authors: Will Sales
type: post
date: 2012-11-22
excerpt: |
  |
    Você não pode fazer suposições sobre o que o usuário quer fazer, simplesmente porque ele tem uma tela menor. Na verdade, tudo o que você realmente sabe é: “Ele tem uma tela menor”.
url: /seu-conteudo-agora-mobile/
tweetbackscheck:
  - 1356399295
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=7353";s:7:"tinyurl";s:26:"https://tinyurl.com/c5tcph9";s:4:"isgd";s:19:"https://is.gd/35weVb";}'
twittercomments:
  - 'a:0:{}'
categories:
  - Mobile
  - Traduções

---
_Resumo do 1° capítulo do livro “<a href="https://www.abookapart.com/products/content-strategy-for-mobile" target="_blank">Strategy for Mobile</a>” de Karen MacGrane, disponível na Editora <a href="https://www.abookapart.com/" target="_blank">A Book Apart</a>_.

Quando falamos sobre criar produtos e serviços para mobile, a conversa tende a concentrar-se nos desafios do design e desenvolvimento. Como a estética do nosso design muda quando estamos lidando com uma tela menor (ou com maior resolução)? Como podemos empregar (e ensinar) novas interações gestuais, que aproveitem as capacidades touchscreen? Como (e quem) vamos escrever o código para todas essas diferentes plataformas – e como manteremos todas elas?

Estas são grandes questões. Mas focar apenas em questões de design e desenvolvimento deixa de fora um assunto muito importante: Como fazer para que nosso conteúdo seja apresentado adequadamente nos dispositivos mobile?

A boa notícia é que a resposta a esta questão vai ajudá-lo independente do sistema operacional, capacidades de dispositivo, ou resolução de tela. Se você tirar um tempo para descobrir a maneira certa de apresentar seu conteúdo, terá liberdade (e flexibilidade) para mostrá-lo em qualquer lugar. Então você pode voltar a pensar em abordagens certas para o design e desenvolvimento de cada plataforma, pois terá uma base reutilizável de conteúdo para trabalhar.

A má notícia é que isto não é um problema superficial. Resolver esta questão não é algo que você possa fazer isoladamente, analisando um subconjunto de seu conteúdo num simplificado aplicativo ou site mobile. A solução requer que você olhe atentamente ao seu sistema de gerenciamento de conteúdo, seu workflow editorial, ou mesmo sua estrutura organizacional. Talvez você precise de diferentes ferramentas, processos e formas de comunicação.

Não se desespere, pois há notícias bem melhores no fim deste arco-íris. Tire um tempo agora para examinar seu conteúdo e estruture-o para ter máxima flexibilidade e reutilização, você estará mais preparado da próxima vez que um novo dispositivo estiver por aí. Terá podado todo o conteúdo morto, devido a irrelevância ou má escrita, o que significa que todos os seus usuários terão uma experiência melhor. Você vai ter revisto e atualizado seus processos e ferramentas para gestão e manutenção de conteúdo, o que significa que todo conteúdo que você criar em todos os canais – impressão, desktop, mobile, TV, social – serão cautelosamente gerenciados.

## MOBILE NÃO É UMA VERSÃO “LITE”

_“Imagine-se agora num trem. Você iria Gostar se eu lhe oferecesse uma versão de site mobile ofensivamente simplificada?” – _Cennydd Bowles (<a href="https://bkaprt.com/csm/15" target="_blank">https://bkaprt.com/csm/15</a>)”

Se as pessoas querem fazer algo na internet, elas vão querer fazê-lo usando seus dispositivos mobile.

As fronteiras entre as “tarefas de desktop” e “tarefas mobile” são fluidas, impulsionadas tanto pela conveniência dos dispositivos quanto pela facilidade da tarefa. Alguma vez você já tentou procurar rapidamente uma informação em seu tablet, pelo simples fato de estar com preguiça de ir até o computador? Ou digitou um longo e-mail em seu BlackBerry, enquanto estava sentado em sua mesa, esquecendo temporariamente que seu teclado existia? Ou mesmo descobriu que o processo para reservar um bilhete/ticket pelo seu celular era mais fácil que usar o desktop, pois toda aquela desordem extra do desktop havia sido arrancada?

Já reparou que o dispositivo que você escolhe para uma determinada atividade não implica necessariamente no seu contexto de uso?

As pessoas utilizam um dispositivo para cada situação. Para cada contexto.  Utilizam celulares quando estão em restaurantes ou no sofá. Usam tablets com uma determinação focada em reuniões, ou na cama (numa preguiçosa manhã de domingo). Elas utilizam laptops com conectividade oferecida por seu empregador, ou ainda com um pequeno sinal desviado de conexões wi-fi de hotéis. Usam desktops na praia… ops… ok, as pessoas realmente só utilizam desktops nas tradicionais mesas de trabalho. Você me pegou nessa.

Conhecer o tipo de dispositivo que o usuário está carregando não diz nada sobre suas verdadeiras intenções. Conhecer a situação não lhe diz nada sobre seus objetivos. Você não pode fazer suposições sobre o que o usuário quer fazer, simplesmente porque ele tem uma tela menor. Na verdade, tudo o que você realmente sabe é: “Ele tem uma tela menor”.

### O contexto não mobile

Usuários têm acessado nosso conteúdo através de telas com tamanhos e resoluções bem diversificados. Dados relatados pela SecureCube mostram que, em janeiro de 2000, a maioria dos usuários acessavam a partir de um navegador com resolução de 800 x 600, mas uma minoria significativa (29%) acessavam o site em 1024 x 768 ou superior, com uma pequena porcentagem (11%) em sites em 640 x 480 (<a href="https://bkaprt.com/csm/16" target="_blank">https://bkaprt.com/csm/16</a>; fig 1.1). Naquela época, as decisões sobre a melhor forma de apresentar o conteúdo eram vistas como desafios de design, e os desenvolvedores procuravam oferecer uma boa experiência na leitura para os usuários em todas as resoluções, discutindo formas apropriadas de ajustar a largura de colunas layout, conforme o redimensionamento da tela.

<img class="alignleft" src="https://www.alistapart.com/d/your-content-now-mobile/mcgrane-1-1.png" alt="" width="540" height="272" />

_Fig 1.1: Temos muita experiência em entregar um conteúdo a uma variedade de telas e resoluções. Então por que presumimos que as telas mobile necessariamente indicam um contexto diferente?_

O quê você não ouvia os designers falarem era de como o contexto “640 x 480″ diferenciava do contexo “1024 x 768″. Ninguém tentava intuir quais tarefas seriam mais importantes aos usuários que navegavam em 800 x 600, ou que houvessem opções menos importantes que pudessem ser “ocultada” deles.

Ninguém supôs que a mentalidade, tarefas e objetivos dessas pessoas fossem diferentes, simplesmente pelo fato de terem um monitor de tamanho diferente.

Então por que supomos que seja diferente com o mobile?

## TAREFAS MOBILE, CONTEÚDO MOBILE

Recentemente passei em Austin, Texas, em viagem com três amigos. Como chegamos ao aeroporto um pouco mais cedo, queria estar no conforto do United Club, longe da multidão. Achei que seria rude abandonar meus amigos, por isso gostaria de saber quantos convidados poderia levar ao clube.

Uma simples busca no Google deveria resolver este problema. E rapidamente encontrei um link que parecia ser promissor (fig 1.2).

<img class="alignleft" src="https://www.alistapart.com/d/your-content-now-mobile/mcgrane-1-2.png" alt="" width="540" height="342" />

_Fig 1.2: Uma busca por “United Club Membership” mostra que o conteúdo existe no site oficial. Mas como a URL é redirecionada a um website mobile, os usuários acabam caindo na  home  da versão mobile._

Infelizmente, seguir o link _United Club Membership_ me levou a homepage do <a href="https://mobile.united.com/" target="_blank">mobile.united.com</a>. Quando os usuários fazem a busca de um dispositivo móvel, a United automaticamente redireciona o link do Google para este website mobile – Sem checar se o conteúdo em questão está disponível nesta versão. Se o conteúdo não existe na versão mobile, os usuários ficam – sem a menor cerimônia – na home do site mobile. O redirecionamento mobile quebra a pesquisa – Isto seria uma boa experiência?

Claro, há um link para o site principal, mas que também nos leva a homepage. Eu poderia tentar fazer uma pesquisa interna no site da United, mas iria acabar fazendo diversas buscas e o resultado estaria em telas formatadas para desktop. E, honestamente: Por que eu deveria fazer isso? Uma resposta que eu deveria obter com um simples tap, a partir do resultado do Google, não deveria exigir buscas e tantos cliques entre as páginas mobile e desktop.

No fim, acabei perguntando a um representante (resposta correta: 2 convidados).

Não levanto esta questão para prejudicar a United por deliberadamente redirecionar links a uma determinada URL, quando o conteúdo não está disponível em sua versão mobile (isto seria algo terrível de se fazer. E está no fim de uma longa lista de outras coisas ruins, as quais eu realmente gostaria de prejudicar a United Airlines por ter feito). Não, eu utilizo este exemplo apenas para ilustrar um equívoco comum com os dispositivos móveis: que eles devam entregar tarefas baseadas na funcionalidade, mais do que a busca pela informação em seu conteúdo.

### Buscar informação é uma tarefa

Luke Wroblewski, em seu livro Mobile First, nos diz que a Southwest Airlines está fazendo a coisa certa focando apenas nas tarefas relacionadas a viagem (fig 1.3):

_“A experiência mobile…  tem um foco direcionado à necessidade dos clientes, e o que a Southwest faz: reservas de viagem, check in, verificação de status de vôo, check miles e get alerts. Não há espaço para mais nada. Só para o que realmente importa”._

Os especialistas e designers de apps mobile não decidem o que é realmente importante. O importante é o que importa “ao usuário”, e a probabilidade entre ele desejar realizar uma tarefa ou encontrar uma informação é a mesma.

<img class="alignleft" src="https://www.alistapart.com/d/your-content-now-mobile/mcgrane-1-3.png" alt="" width="270" height="389" />

_Fig 1.3: O app para iphone da Southwest Airlines só tem espaço para o que realmente é importante… desde que o que seja importante não envolva a busca por informações._

Nos meses que se passaram, 86% dos donos de Smartphones usaram seus celulares na busca de informações que ajudasse na solução de problemas, em discussões, no levantamento de informações sobre o tráfego ou resultados de jogos, e ainda para visitar algum estabelecimento – um restaurante, por exemplo (<a href="https://bkaprt.com/csm/27" target="_blank">https://bkaprt.com/csm/27</a>). Não acredita? Então olhe no histórico da busca do seu próprio dispositivo – provavelmente você já tentou obter respostas a diversas questões através do seu celular.

A versão desktop da Southwest Airlines inclui informações como normas de transporte de bagagens, incluindo informações sobre despacho de malas, bagagens de mão e animais de estimação, assim como achados e perdidos, atrasos, e uma variedade de outras informações aos viajantes, tais como o que fazer caso perca o seu bilhete, se precisar remarcar, ou caso o seu voo esteja atrasado. Esta versão ainda inclui informações aos pais que desejam fazer reservas a menores de idade, e sobre as adaptações da Southwest aos deficientes e idosos.

Isto não é uma experiência mobile? Quem somos nós para dizer que esse conteúdo não importa?

É muito bom otimizar a experiência mobile às tarefas mais comuns, mas isso não que dizer que você deva excluir um conteúdo valioso.

### Mobile é social

Você já clicou em um link do Facebook ou Twitter em seu celular? E num link de e-mail que alguém lhe enviou?

É claro que você já fez isso. Compartilhar conteúdo com nossos amigos e colegas é uma das formas mais básicas de se comunicar atualmente. Os usuários não fazem distinção entre acessar um e-mail, Facebook, Twitter, ou outros serviços sociais no desktop ou mobile – eles escolhem de maneira natural, dependendo do dispositivo que está mais próximo no momento. Na verdade, desde junho de 2012, quase 20% dos membros do Facebook utilizam exclusivamente sua versão mobile (<a href="https://bkaprt.com/csm/28" target="_blank">https://bkaprt.com/csm/28</a>).

Se seu conteúdo não está disponível na versão mobile – ou oferece uma experiência de leitura ruim – você está perdendo uma das formas mais atrativas de fazer com que as pessoas o leiam. Seu site é cheio de ícones tentando fazer com que os usuários compartilhem seu conteúdo? Se seus leitores receberem uma mensagem de erro ao tentar compartilhá-lo, todos os esforços para animá-lo a fazer isto serão desperdiçados (fig 1.4).

<img class="alignleft" src="https://www.alistapart.com/d/your-content-now-mobile/mcgrane-1-4.png" alt="" width="270" height="388" />

_Fig 1.4: “Nenhum conteúdo mobile foi encontrado. Você gostaria de visitar a versão desktop do site?” Pergunta o The Guardian. Você consegue adivinhar a resposta? _

**DESIGN PARA O CONTEXTO**

“Contexto” é a palavra do momento quando o assunto é mobile. Na conferência da South by Southwest Interactive de 2011, o painel chamado “Designing for Context” (Design para contexto ou Projetando para o contexto) foi sessão obrigatória, de acordo com a .Net Magazine (<a href="https://bkaprt.com/csm/29" target="_blank">https://bkaprt.com/csm/29</a>).

A ideia é que você possa adaptar seu conteúdo ao contexto do usuário – localização, hora do dia, ambiente social, preferências pessoais. Com base no que você sabe a respeito do usuário, você possa dinamicamente personalizar a experiência, de modo que ela se adapte às suas necessidades.

Hoje, costumamos “projetar para contextos mobile” como uma desculpa para fazer uma experiência mobile inferior. As empresas querem investir o mínimo de tempo e esforço possível no mobile, até ele demonstrar o retorno sobre o investimento. Designers acreditam que podem adivinhar o subconjunto de informações ou funcionalidades que os usuários desejam, e o argumento de todos é que estão projetando para “casos de uso mobile”.

### Cuidado com interfaces personalizadas

Presumir que o “designer sabe o que é melhor” ao escolher como entregar um conteúdo ou funcionalidade personalizada é arriscado. Somos notoriamente ruins em prever o que alguém vai querer. E mesmo armados com dados reais, estamos propensos a fazer suposições incorretas quando decidimos em mostrar ou esconder algo.

O Microsoft Office tentou essa estratégia no fim dos anos 90. O Office 97 oferecia vários recursos e aprimoramentos novos, os quais tornaram a interface mais complexa. Longos menus e densas barras de ferramentas deram a impressão de que a interface estava “inchada” (<a href="https://bkaprt.com/csm/30" target="_blank">https://bkaprt.com/csm/30</a>). (isto se assemelha a versões desktop de sites que você conhece?)

Em resposta, a Microsoft desenvolveu “Menus personalizados” e “Barras de ferramentas entroncadas” que mostravam os itens mais populares primeiro (fig 1.5). Embora a Microsoft tivesse bons dados e um poderoso algoritmo para ajudar a determinar quais itens devessem ser priorizados, descobriu-se que os usuários não gostavam de ser previstos. As pessoas achavam muito frustrante passar por um processo de dois estágios, procurando por múltiplos menus até encontrar o que buscavam. Menus personalizados violam um dos princípios fundamentais do design em uso: o de colocar o usuário no controle.

<img class="alignleft" src="https://www.alistapart.com/d/your-content-now-mobile/mcgrane-1-5.png" alt="" width="570" height="524" />

_Fig 1.5: Os menus personalizados no Office 97 tentaram priorizar as opções que a Microsoft achava que os usuários queriam. Foram um fracasso._

Agora imagine que se em vez de clicar na parte inferior do menu para expandi-lo, o usuário tenha que clicar em um link para a versão “desktop do site”, e então tenha que continuar procurando em sua navegação, enquanto comprime os olhos numa tela pequena. Se a versão mobile do seu site só oferece um subconjunto do seu conteúdo, você está dando aos seus usuários a mesma experiência frustrante. Só que muito pior.

### Você não tem dados muito bons

A Microsoft tinha uma tonelada de dados sobre o que as pessoas utilizavam com maior frequência. Eles desenvolveram um complexo algoritmo para apresentar o padrão de um menu “resumido” baseado nos itens que as pessoas eram mais propensas a utilizar, baseado nos anos de história e pesquisa com múltiplas iterações de seu produto. E mesmo assim eles cometeram erros.

As escolhas que você faz sobre o subconjunto do conteúdo a ser entregue ao seu usuário, provavelmente não está apoiada por bons dados. No fim das contas, elas podem não estar apoiadas por qualquer tipo de pesquisa, apenas por uma intuição sobre quais opções você imagina que serão mais importantes a esses míticos usuários.

E mesmo que você tenha dados analíticos, sobre o conteúdo mais buscado no mobile, é provável que você não possua um quadro preciso do que as pessoas realmente querem. Hoje, a deficiente experiência mobile é testada de forma inadequada ao avaliar o que as pessoas desejam fazer. É como Jason Grigsby, Co-fundador daCloudFour.com e MobilePortland.com disse:

_“Não podemos prever o comportamento futuro de uma experiência atual que é uma droga”_(<a href="https://bkaprt.com/csm/31" target="_blank">https://bkaprt.com/csm/31</a>)

Se a sua visão mobile é a do design para contexto, então o primeiro passo que você deve dar é pôr todo o seu conteúdo também nos dispositivos mobile.

## TUDO ISSO? SÉRIO?

Isso mesmo. Sua estratégia de conteúdo para mobile não deve ser apenas um satélite do seu site desktop, mostrando apenas um subconjunto do conteúdo que você decidiu que o usuário iria precisar. Isto não vai funcionar, pois:

  * As pessoas utilizam seus dispositivos de forma natural, mas muitas vezes escolhem o dispositivo mobile mesmo tendo acesso ao desktop. Não suponha que você vai projetar para usuários que estarão em movimento, pois as pessoas utilizam os dispositivos mobile em todo e qualquer lugar.

  * Usuários mobile querem e precisam ver todo o seu conteúdo também! Não os trate como cidadãos de segunda classe só porque eles nunca – ou raramente – utilizam o desktop. Mesmo que você pense que eles sejam em sua grande maioria “usuários mobile”, lembre-se: você não deve decidir quais dispositivos eles utilizam para acessar seu conteúdo. Eles devem fazer isso.

  * O mobile suporta conteúdo de leitura tão bem quanto tarefas funcionais. Não fique se gabando só porque “mobilezou ” alguns recursos – Há mais trabalho a fazer com seu conteúdo.

  * Contexto é uma desculpa. Não use o contexto como justificativa para reter o seu conteúdo, a não ser que você tenha uma pesquisa real, e dados sobre o que os usuários precisam em certa situação ou cenário. A menos que você tenha isto, você não será capaz de supor qualquer coisa (e mesmo que você tenha essas informações – dadas as péssimas experiências que a maioria dos usuários têm hoje em seus celulares, você provavelmente ainda irá supor errado).

Nunca force os usuários a ir à versão desktop do seu site, quando estiverem buscando por um conteúdo no dispositivo mobile. Pelo contrário, o objetivo é a igualdade entre o conteúdo desktop e a experiência mobile – Mesmo que o conteúdo apresentado não seja exatamente igual, a experiência deve ser essencialmente a mesma.

É sua missão adaptar seu conteúdo. Seja em qualquer plataforma ou  formato que seu público queira adquirir. Seus usuários irão decidir como, quando e onde ler este conteúdo. É seu desafio e sua responsabilidade entregar uma boa experiência a eles.

—

_Traduzido com autorização da <a href="https://www.alistapart.com/" target="_blank">A List Apart Magazine</a> e do autor._

_Artigo original escrito por <a href="https://www.alistapart.com/authors/m/Karen%20McGrane" target="_blank">Karen McGrane</a>._

_Acesse o artigo original no <a href="https://www.alistapart.com/articles/your-content-now-mobile/" target="_blank">A List Apart</a> – Your Content, Now Mobile – 5 de novembro de 2012._