---
title: Quero ser um desenvolvedor fora do Brasil. E agora?
authors: Eduardo Shiota
excerpt: Desde que comecei a carreira de front-end developer, meu sonho sempre foi trabalhar fora do Brasil.
type: post
date: 2018-01-10
image: https://i.imgur.com/dN55f40.jpg
categories:
  - Carreira
tags:
  - Mercado
  - opinião
  - carreira
---

Muitas pessoas me pediram dicas sobre como se preparar para um processo de
seleção no exterior. Resolvi então escrever este ~*textão*~ com muito do que vi
e aprendi até hoje sobre o assunto.

Desde que comecei a carreira de front-end developer, meu sonho sempre foi
trabalhar fora do Brasil. Via em outros países uma oportunidade de crescer
exponencialmente como profissional e como pessoa. Tive o privilégio de
participar do An Event Apart em 2008 (Chicago) e 2010 (Minneapolis). Falar com
as minhas maiores referências, ter contato com pessoas completamente diferentes
e passar por experiências totalmente novas fizeram meu desejo crescer ainda
mais.

Sempre procurei ter objetivos claramente definidos, traçando planos de como
alcançá-los. E em 2010, resolvi colocar meu *masterplan* em prática, em 5
passos: (1) ter independência financeira; (2) conhecer as maiores referências de
front-end no Brasil; (3) palestrar em eventos e crescer com a comunidade; (4)
trabalhar com o melhor time possível no Brasil; (5) conseguir uma oportunidade
fora do país. Passar por cada uma dessas etapas me fez conhecer pessoas
incríveis e vivenciar momentos inesquecíveis.

![](https://cdn-images-1.medium.com/max/800/1*d3yl0Vw-zBRy2GVWn-4S9w.png)
<span class="figcaption_hack">Primeira palestra que dei em 2010, no Dev in Sampa</span>

Em 2013, achei que era hora de colocar o passo 5 em prática. Conversei
extensivamente com o [Rafael Dohms](https://doh.ms/)—que se mudou para a Holanda
em 2011—sobre o processo de mudar de país; e tive uma "longa" discussão com a
Paula — minha esposa (até então, namorada) e [companheira de
aventuras](https://paulaabrahao.com.br/blog):

— Então… topa mudar de país? Tipo Holanda ou Estados Unidos?

— Okay, mas… e os gatinhos? A gente vai mudar de país mesmo tendo 4 gatos? O que
aconteceria com eles?

— … … … a gente leva os 4, no matter what.

A "longa" discussão demorou 30 segundos. E começamos a pesquisar sobre as leis
de levar animais pra fora do Brasil. Estava decidido. Comecei a pesquisar vagas
nos Estados Unidos, Europa, e o Dohms tentou ver se eu conseguia uma vaga na
empresa dele.

![](https://cdn-images-1.medium.com/max/800/1*qdilhvT9N5c51vplcnh83Q.jpeg)
<span class="figcaption_hack">Plus, ele me "convenceu" que ter uma vista assim todo dia seria legal.</span>

Coincidentemente, uma semana depois recebi um email de um recrutador trabalhando
para a Booking.com, e recebi uma resposta de duas empresas em São Francisco.
Comecei o processo nas três, e descobri que todas as experiências que tive
entrevistando ou sendo entrevistado no Brasil não me prepararam para uma seleção
fora do país. Vou tentar relatar aqui tudo o que aprendi no meio do caminho,
para possivelmente ajudar quem esteja pensando em passar pelo mesmo.

*Aviso: o que vou descrever aqui é um relato meu, com opiniões e sugestões
minhas, que não têm relação com a minha posição na Booking. São fatos e dicas
genéricas, aplicáveis para qualquer empresa.*

### English, motherf*cker, do you speak it?

> “*Antes de aprender JavaScript ou qualquer outra linguagem, você tem que
> aprender inglês.*” — Chico Xav, digo, Daniel Filho

Sim, a língua portuguesa é linda (de verdade). Sim, a comunidade de
desenvolvimento brasileira carece de bons materiais em português. Sim, o inglês
não faz parte da grade do ensino público, e mal recebe atenção no ensino
privado. Mas o fato é que um material escrito em português só será lido por
pessoas no Brasil, Portugal, Moçambique, Angola, Guinea-Bissau, Guinea
Equatorial, Timor Leste, Macau, Cabo Verde e São Tomé e Príncipe. E se você não
conseguir ler em inglês, ficará restrito ao material produzido em português.

Já imaginou se o Stoyan Stefanov publicasse seu "JavaScript Patterns" apenas em
búlgaro? Se o Mathias Bynens desse suas palestras em alemão (ou francês, ou
holandês — ele é belga :P)? Ou se a Sara Soueidan tivesse escrito o CSS
Reference do Codrops apenas em árabe? No mundo da programação, inglês é a língua
principal (e, segundo o Github, a segunda é JavaScript).

Para entrevistar fora do Brasil, salvo algumas exceções, seu CV deverá ser em
inglês. Sua cover letter deverá ser em inglês. Os testes técnicos serão em
inglês. As entrevistas serão em inglês. Grandes chances da comunicação no
dia-a-dia da empresa ser em inglês.

Invista em um bom curso que dê fluência, ou ao menos facilidade com a língua.
Treine com alguém que saiba inglês, respire fundo, e mantenha a calma. Você não
precisa ser o próximo Tolkien: entender e se comunicar com facilidade é o
suficiente. Ninguém vai te condenar por conjugar um verbo irregular errado, usar
uma pronúncia estranha ou falar com sotaque. Se quiser inspiração, leia [como o
Igor Apa resolveu se aventurar aprendendo
inglês](https://www.igorapa.com/fui-aprender-ingles.html) nos EUA.

E na dúvida, lembre-se que a maioria dos americanos provavelmente sabe menos
inglês que você. Se a insegurança bater, lembre-se dessa frase:

> “Nunca tire sarro de alguém que fala um inglês quebrado. Isso significa que eles
> sabem outra língua.”<br> —H. Jackson Brown, Jr. (tradução livre)

### Você (provavelmente) não é especial. E é tão especial quanto todos.

Eu sempre achei que pra trabalhar fora do Brasil precisaria ter um currículo
impecável, um Github repleto de quadradinhos verdes, um Twitter com 10k
seguidores, ter palestrado em cada um dos continentes e eliminado o exército
azul no War. Embora tudo isso ajude, não é bem assim.

![](https://cdn-images-1.medium.com/max/800/1*M6NbrdQCYB5H_3HFnxKPGg.png)
<span class="figcaption_hack">Isso também não vai ajudar muito.</span>

No Brasil (assim como em alguns outros países ou cidades), ter um nome conhecido
te leva a muitos lugares. As ofertas são constantes, e na maioria das vezes as
entrevistas se resumem a uma conversa de uma hora onde a empresa é quem tenta se
vender ao candidato. Entrevistas técnicas são feitas apenas por empresas
tradicionais, muito grandes, ou para vagas para pessoas iniciando na carreira.
Isso faz com que desenvolvedores com mais experiência raramente passem por
longos processos de recrutamento — e, inclusive, com que se sintam ofendidos
caso a empresa exija que o candidato resolva um desafio técnico ou tenha que
responder questões acadêmicas.

Quando uma empresa contrata pessoas do mundo todo, isso vai por água abaixo. Não
há como comparar o melhor desenvolvedor do Brasil com o melhor desenvolvedor da
Rússia, todos precisam passar pelos mesmos testes. Isso significa que, mesmo que
você tenha um Github repleto de forks e projetos pessoais, mesmo que você
contribua para projetos Open Source, mesmo que você tenha palestrado pelo país
inteiro, você vai passar por todas as etapas. Isso significa fazer entrevistas
com o RH. Ter que resolver desafios. Implementar um Fibonacci em JavaScript.
Explicar a diferença entre `position: absolute` e `position: relative`. Falar
sobre suas ambições. Explicar o que acontece quando você digita uma URL e aperta
<enter> no browser. Saber estimar quantas fraldas são usadas na China
anualmente.

Portanto, se você tem mexido apenas com IE10+, AngularJS e React, é bom
relembrar os desafios de suportar o IE8, como fazer um simples *event
delegation*, ou até mesmo como contar de 100 até 1 em um *loop*. É
impressionante o número de desenvolvedores com currículos repletos de
tecnologias JavaScript modernas, mas que não sabem o que é um module pattern,
`this`, ou `prototype`.

Lembrem-se: ter um conhecimento sólido de como uma linguagem funciona lhe torna
capaz de entender qualquer framework ou paradigma. Já o contrário pode não ser
verdade.

### Cada empresa é um novo processo…

Para muitos desenvolvedores, o conceito de "se preparar para uma entrevista" é
desnecessário. Nos focamos apenas na parte técnica e nas tecnologias, e
esquecemos nosso principal papel na maioria das empresas. E acredite, não é
fazer um código excepcionalmente lindo, ou discutir por horas se devemos usar
CommonJS ou AMD. Nosso papel é ajudar a empresa a fazer dinheiro, a lançar
produtos, a atingir os usuários. A parte técnica não é o "o quê", é apenas o
"como". E quando você compete com pessoas do mundo todo, saber ambos é uma
grande vantagem.

![](https://cdn-images-1.medium.com/max/800/1*392A0aF-n00-MLmO5RO0oQ.gif)
<span class="figcaption_hack">Somos mais do que apertadores de teclas</span>

Estude a empresa pra qual você está entrevistando: qual sua história, quem são
seus clientes, como ela faz dinheiro, como é o mercado na qual ela atua. Procure
saber quais são suas ideologias, seus valores, e seu dia-a-dia.

### … e cada país é uma nova cultura…

A maioria dos brasileiros adora falar—pelo menos é o que eu ouvi de pessoas de
outros países. Uma resposta que poderia ser dada em 10 segundos muitas vezes
vira um discurso de meia hora, com menções ao governo, à corrupção, e à economia
do país.

Mas em uma entrevista onde os processos são padronizados e o tempo é limitado,
você não terá horas pra responder uma questão. Lembre-se que o seu uso do tempo
disponível também pode ser avaliado. E o estilo de comunicação dos
entrevistadores irá variar de país para país. Aqui na Holanda (e na maior parte
do norte da Europa), as pessoas são direto ao ponto, sem *sugar coating*, e
"encher linguiça" pode ser até um sinal de que o candidato está tentando passar
a perna.

Procure saber como é o mercado de trabalho e o estilo de comunicação do país
para o qual você vai.

### … e no fim, todos querem saber a mesma coisa.

Você se comunica bem? Você é tecnicamente bom? Você vai ser capaz de lidar com o
dia-a-dia? Você vai se adaptar à cultura? No fim, o processo de recrutamento da
maioria dos lugares não é um *pop quiz* de quantas perguntas sobre a API do
Node.js você é capaz de responder. Como eu disse, as empresas procuram
profissionais que sejam aptos a resolver problemas e ajudar o negócio a evoluir.
Logo, algumas dicas devem servir para a maioria das entrevistas, independente de
quem ou onde:

* Se tiver que fazer um teste de código em casa, faça com carinho e da melhor
forma possível. Estes testes são o equivalente a você falar "é assim que eu
escrevo, e este é o meu melhor". E se o seu melhor for um código difícil de ler,
com variáveis crípticas e tabs misturados com espaços, provavelmente não irão te
escolher.
* Pode parecer óbvio, mas seja educado, agradável e pontual. Revise seu currículo
e corrija erros gramaticais. Basicamente, quem está te entrevistando está
escolhendo se quer você como um colega de trabalho.
* Treine. Se tiver um amigo que fala inglês, treine uma entrevista com ele. Bonus
points se ele for técnico.
* Faça a entrevista em um ambiente calmo, sem barulhos, e com uma conexão boa e um
sinal decente.
* Mantenha a calma. Se você não souber uma resposta, não entre em pânico. Respire,
pense um pouco, e comece a descrever sua linha de raciocínio. O mais importante
para quem entrevista é o caminho para chegar na solução.
* Se você souber a resposta, responda primeiro, e entre em detalhes depois. Fale
pausadamente: às vezes o entrevistador não precisa de cada pequeno detalhe, e é
bom que ele tenha uma chance de te interromper para prosseguir com outra
pergunta.
* Seja objetivo, não desvie da pergunta. Uma vez, perguntei qual era a motivação
do candidato para se mudar de cidade e trabalhar na empresa X. Ele me perguntou
se eu conhecia empresa Y. Disse que não, e ele passou os próximos 10 minutos
falando como empresa Y tinha sede na mesma cidade que X, e como ela era legal e
inovadora. No fim, ele simplesmente respondeu que queria mudar de cidade. Foi a
última vez que o vimos.
* Como eu disse lá em cima, esteja preparado para as perguntas técnicas. No caso
de uma vaga de front-end, estude as coisas básicas da linguagem, que acabamos
não tocando no dia-a-dia. O que é um DOCTYPE? O que acontece em um bloco que
contêm elementos com float: left ou right? Como funciona o hoisting do
JavaScript? Qual a diferença entre display: inline, block e inline-block? Qual a
diferença entre Foo() e new Foo()?
* Esteja preparado para escrever código. Pode ser que peçam para você codificar em
editores colaborativos. Se a entrevista for ao vivo, pode ser que você faça o
mesmo em um computador, em papel-e-caneta, ou em uma lousa. Mantenha a calma, e
deixe seu raciocínio bem explícito. Descreva o que você está escrevendo. Se
tiver alguma dúvida ou ficar preso em alguma parte, fale para o entrevistador.
Provavelmente ele vai te fazer perguntas para te ajudar a sair do buraco por
conta própria.
* Se quiser dar um passo a mais, [estude problemas básicos de
computação](https://www.reddit.com/r/cscareerquestions/comments/20ahfq/heres_a_pretty_big_list_of_programming_interview/),
e procure por [desafios acadêmicos](https://www.careercup.com/page) pra resolver.
Vai variar de processo para processo, mas muitas das empresas grandes e startups
do Vale do Silício incluem [uma ou mais
dessas](https://www.reddit.com/r/javascript/comments/3rb88w/ten_questions_ive_been_asked_most_more_than_once/?utm_source=javascriptweekly&utm_medium=email)
no meio das entrevistas.
* Pesquise sobre a história do lugar, sobre seu modelo de negócio, últimas
conquistas: eles querem alguém que ajude a empresa e o time a irem pra frente.
* Saiba [o que acontece de ponta a
ponta](https://github.com/alex/what-happens-when): desde o usuário digitar a URL
no navegador, até o site aparecer na tela. Tenha uma visão geral de como a web
funciona, e se aprofunde nas partes que importa (no caso de front-end: DNS
lookup, requisições HTTP, parsing do HTML e CSS em DOM e CSSOM, JS parsing,
event loop, paints e reflows).
* De novo: o processo seletivo serve para os entrevistadores decidirem se teriam
você como um colega de trabalho. Eu, por exemplo, dificilmente gostaria de
trabalhar com alguém que se julgue como "o melhor front-end developer do país",
ou "o melhor desenvolvedor que eu já conheci".

### Don't panic.

Não se desespere ao fazer as entrevistas. Como diria a sabedoria popular, "o
*não* você já tem". Tudo bem não passar de primeira: eu fiz vários processos, e
o aprendizado que tive neles me levou a ser aprovado na Booking. Cada etapa que
você faz, é uma skill a mais para o seu repertório de conhecimento.

E não fique com a ideia de que, caso não seja aprovado, você potencialmente
"desperdiçará sua chance" com empresa X. A maioria aceita que você tente
novamente em um período de 6 meses a um ano. Nesse tempo, dá pra estudar e
aprender ainda mais. Tenha em mente: **nem toda empresa foi feita pra você**.
Ser reprovado em um processo não quer dizer que você será reprovado em todos.
Cada empresa procura um perfil diferente e, mesmo que você não seja o melhor
candidato para uma, poderá ser o profissional perfeito para outra. Continue
procurando novas oportunidades!

Por último, seja confiante e acredite em você mesmo: você não tem nada a perder.
Se estiver com receio do seu inglês, faça [como o Leo Balter
fez](https://medium.com/brasil/um-brasileiro-na-bocoup-1b0f0fb9a9eb#.geiqal23x)
e arrisque. Se não for aprovado, peça um feedback do porquê, e trabalhe em cima
disso.

![](https://cdn-images-1.medium.com/max/800/1*FZmdO6TUIIFpG2krF5rSRA.png)
<span class="figcaption_hack">Se esse gráfico corporativo ágil 2.0 não lhe motivar, eu não sei mais o que lhe
motivaria.</span>

No fim, lembrar de tudo o que aconteceu desde 2010, das coisas que aprendi, das
pessoas incríveis que conheci e das experiências maravilhosas que pude ter, me
faz ter plena certeza de que todo o esforço valeu a pena.

![](https://cdn-images-1.medium.com/max/800/1*0xGQ_HGW3DOdV5k4yQWMhg.png)
<span class="figcaption_hack">O Jamie, a Lexie, a Arya e o Thorin também têm plena certeza. ❤</span>

